<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */

$giardino_template_args = get_query_var( 'giardino_template_args' );
if ( is_array( $giardino_template_args ) ) {
	$giardino_columns    = empty( $giardino_template_args['columns'] ) ? 2 : max( 2, $giardino_template_args['columns'] );
	$giardino_blog_style = array( $giardino_template_args['type'], $giardino_columns );
} else {
	$giardino_blog_style = explode( '_', giardino_get_theme_option( 'blog_style' ) );
	$giardino_columns    = empty( $giardino_blog_style[1] ) ? 2 : max( 2, $giardino_blog_style[1] );
}
$giardino_post_format = get_post_format();
$giardino_post_format = empty( $giardino_post_format ) ? 'standard' : str_replace( 'post-format-', '', $giardino_post_format );
$giardino_animation   = giardino_get_theme_option( 'blog_animation' );
$giardino_image       = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );

?><article id="post-<?php the_ID(); ?>" 
									<?php
									post_class(
										'post_item'
										. ' post_layout_portfolio'
										. ' post_layout_gallery'
										. ' post_layout_gallery_' . esc_attr( $giardino_columns )
										. ' post_format_' . esc_attr( $giardino_post_format )
										. ( ! empty( $giardino_template_args['slider'] ) ? ' slider-slide swiper-slide' : '' )
									);
									echo ( ! giardino_is_off( $giardino_animation ) && empty( $giardino_template_args['slider'] ) ? ' data-animation="' . esc_attr( giardino_get_animation_classes( $giardino_animation ) ) . '"' : '' );
									?>
	data-size="
	<?php
	if ( ! empty( $giardino_image[1] ) && ! empty( $giardino_image[2] ) ) {
		echo intval( $giardino_image[1] ) . 'x' . intval( $giardino_image[2] );}
	?>
	"
	data-src="
	<?php
	if ( ! empty( $giardino_image[0] ) ) {
		echo esc_url( $giardino_image[0] );}
	?>
	"
>
<?php

	// Sticky label
if ( is_sticky() && ! is_paged() ) {
	?>
		<span class="post_label label_sticky"></span>
		<?php
}

	// Featured image
	$giardino_image_hover = 'icon';
if ( in_array( $giardino_image_hover, array( 'icons', 'zoom' ) ) ) {
	$giardino_image_hover = 'dots';
}
$giardino_components = giardino_array_get_keys_by_value( giardino_get_theme_option( 'meta_parts' ) );
$giardino_counters   = giardino_array_get_keys_by_value( giardino_get_theme_option( 'counters' ) );
giardino_show_post_featured(
	array(
		'hover'         => $giardino_image_hover,
		'singular'      => false,
		'no_links'      => ! empty( $giardino_template_args['no_links'] ),
		'thumb_size'    => giardino_get_thumb_size( strpos( giardino_get_theme_option( 'body_style' ), 'full' ) !== false || $giardino_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only'    => true,
		'show_no_image' => true,
		'post_info'     => '<div class="post_details">'
						. '<h2 class="post_title">'
							. ( empty( $giardino_template_args['no_links'] )
								? '<a href="' . esc_url( get_permalink() ) . '">' . esc_html( get_the_title() ) . '</a>'
								: esc_html( get_the_title() )
								)
						. '</h2>'
						. '<div class="post_description">'
							. ( ! empty( $giardino_components )
								? giardino_show_post_meta(
									apply_filters(
										'giardino_filter_post_meta_args', array(
											'components' => $giardino_components,
											'counters' => $giardino_counters,
											'seo'      => false,
											'echo'     => false,
										), $giardino_blog_style[0], $giardino_columns
									)
								)
								: ''
								)
							. ( empty( $giardino_template_args['hide_excerpt'] )
								? '<div class="post_description_content">' . get_the_excerpt() . '</div>'
								: ''
								)
							. ( empty( $giardino_template_args['no_links'] )
								? '<a href="' . esc_url( get_permalink() ) . '" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__( 'Learn more', 'giardino' ) . '</span></a>'
								: ''
								)
						. '</div>'
					. '</div>',
	)
);
?>
</article><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!
