<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */

$giardino_template_args = get_query_var( 'giardino_template_args' );
if ( is_array( $giardino_template_args ) ) {
	$giardino_columns    = empty( $giardino_template_args['columns'] ) ? 2 : max( 2, $giardino_template_args['columns'] );
	$giardino_blog_style = array( $giardino_template_args['type'], $giardino_columns );
	if ( ! empty( $giardino_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $giardino_columns > 1 ) {
		?>
		<div class="column-1_<?php echo esc_attr( $giardino_columns ); ?>">
		<?php
	}
}
$giardino_components = giardino_array_get_keys_by_value( giardino_get_theme_option( 'meta_parts' ) );
$giardino_counters   = giardino_array_get_keys_by_value( giardino_get_theme_option( 'counters' ) );
$giardino_expanded    = ! giardino_sidebar_present() && giardino_is_on( giardino_get_theme_option( 'expand_content' ) );
$giardino_post_format = get_post_format();
$giardino_post_format = empty( $giardino_post_format ) ? 'standard' : str_replace( 'post-format-', '', $giardino_post_format );
$giardino_animation   = giardino_get_theme_option( 'blog_animation' );

?>
<article id="post-<?php the_ID(); ?>"
	<?php post_class( 'post_item post_layout_excerpt post_format_' . esc_attr( $giardino_post_format ) ); ?>
	<?php echo ( ! giardino_is_off( $giardino_animation ) && empty( $giardino_template_args['slider'] ) ? ' data-animation="' . esc_attr( giardino_get_animation_classes( $giardino_animation ) ) . '"' : '' ); ?>
	>
	<?php
     if ( 'quote' == $giardino_post_format ) {
    if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"><?php esc_html_e( 'Sticky Post', 'giardino' )?></span>
		<?php
	}

	// Featured image
	$giardino_hover = ! empty( $giardino_template_args['hover'] ) && ! giardino_is_inherit( $giardino_template_args['hover'] )
						? $giardino_template_args['hover']
						: giardino_get_theme_option( 'image_hover' );
	giardino_show_post_featured(
		array(
			'singular'   => false,
			'no_links'   => ! empty( $giardino_template_args['no_links'] ),
			'hover'      => $giardino_hover,
			'thumb_size' => giardino_get_thumb_size( strpos( giardino_get_theme_option( 'body_style' ), 'full' ) !== false ? 'full' : ( $giardino_expanded ? 'huge' : 'excerpt' ) ),
		)
	);

	// Post content
	if ( empty( $giardino_template_args['hide_excerpt'] ) ) {

		?>
		<div class="post_content entry-content">
		<?php
		if ( giardino_get_theme_option( 'blog_content' ) == 'fullpost' ) {
			// Post content area
			?>
				<div class="post_content_inner">
				<?php
				the_content( '' );
				?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'giardino' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'giardino' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
		} else {
			// Post content area
			?>
				<div class="post_content_inner">
				<?php
				if ( has_excerpt() ) {
						the_excerpt();
				} elseif ( strpos( get_the_content( '!--more' ), '!--more' ) !== false ) {
						the_content( '' );
				} elseif ( in_array( $giardino_post_format, array( 'link', 'aside', 'status' ) ) ) {
										the_content();
				} elseif ( 'quote' == $giardino_post_format ) {
					$quote = giardino_get_tag( get_the_content(), '<blockquote>', '</blockquote>' );
					if ( ! empty( $quote ) ) {
						giardino_show_layout( wpautop( $quote ) );
					} else {
						the_excerpt();
					}
				} elseif ( substr( get_the_content(), 0, 4 ) != '[vc_' ) {
					the_excerpt();
				}
                // Title and post meta
                if ( get_the_title() != '' ) {
                    ?>
                    <div class="post_header entry-header">
                        <?php
                        do_action( 'giardino_action_before_post_title' );

                        // Post title
                        if ( empty( $giardino_template_args['no_links'] ) ) {
                            the_title( sprintf( '<h2 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
                        } else {
                            the_title( '<h2 class="post_title entry-title">', '</h2>' );
                        }

                        ?>
                    </div><!-- .post_header -->
                    <?php
                }
				?>
				</div>
				<?php
				// More button
				if ( empty( $giardino_template_args['no_links'] ) && ! in_array( $giardino_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
					?>
					<p><a class="more-link" href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e( 'Read more', 'giardino' ); ?></a></p>
					<?php
				}?>
				<div class="footer_meta">
				    <div class="footer_tags">
                        <?php
                            // Post tags
				            the_tags( '<span class="post_meta_item post_tags"><span class="post_meta_label">' . esc_html__( 'Tags', 'giardino' ) . '</span> ', ' ', '</span>' );
                          ?>
                    </div>
                    <div class="footer_likes">
                    <?php
                        do_action( 'giardino_action_before_post_meta' );
                        // Post meta
                        $giardino_components = giardino_array_get_keys_by_value( giardino_get_theme_option( 'meta_parts' ) );
                        $giardino_counters   = giardino_array_get_keys_by_value( giardino_get_theme_option( 'counters' ) );

                        if ( ! empty( $giardino_components ) && ! in_array( $giardino_hover, array( 'border', 'pull', 'slide', 'fade' ) ) ) {
                            giardino_show_post_meta(
                                apply_filters(
                                    'giardino_filter_post_meta_args', array(
                                          'components' => 'counters',
                                        'counters'   => 'likes,comments',
                                        'seo'        => false,
                                    ), 'excerpt', 1
                                )
                            );
                        }
                     ?>
                     </div>
				 </div>
		<?php }
		?>
		</div><!-- .entry-content -->
		<?php
	}
     }
     else {
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"><?php esc_html_e( 'Sticky Post', 'giardino' )?></span>
		<?php
	}

	// Featured image
	$giardino_hover = ! empty( $giardino_template_args['hover'] ) && ! giardino_is_inherit( $giardino_template_args['hover'] )
						? $giardino_template_args['hover']
						: giardino_get_theme_option( 'image_hover' );
	giardino_show_post_featured(
		array(
			'singular'   => false,
			'no_links'   => ! empty( $giardino_template_args['no_links'] ),
			'hover'      => $giardino_hover,
			'thumb_size' => giardino_get_thumb_size( strpos( giardino_get_theme_option( 'body_style' ), 'full' ) !== false ? 'full' : ( $giardino_expanded ? 'huge' : 'excerpt' ) ),
		)
	);

	// Title and post meta
	if ( get_the_title() != '' ) {
		?>
		<div class="post_header entry-header">
			<?php
            do_action( 'giardino_action_before_post_meta' );

			// Post meta
			$giardino_components = giardino_array_get_keys_by_value( giardino_get_theme_option( 'meta_parts' ) );
			$giardino_counters   = giardino_array_get_keys_by_value( giardino_get_theme_option( 'counters' ) );
            // Post meta
				 do_action( 'giardino_action_before_post_meta' );
				?>
				<div class="excerpt_meta">
                    <div class="meta-left">
                        <?php
                            if ( ! empty( $giardino_components ) && ! in_array( $giardino_hover, array( 'border', 'pull', 'slide', 'fade' ) ) ) {
                            $cats = '';
                            $categories = 'categories';
                            $pos = strpos($giardino_components, $categories);
                            if ( $pos !==false ) {
                                $cats = get_post_type()=='post' ? get_the_category_list(' ') : apply_filters('giardino_filter_get_post_categories', '');
                                if (!empty($cats)) {
                                    $cats = '<span class="post_meta_item post_categories">'.$cats.'</span>';
                                } else {
                                    $cats = '';
                                }
                            }
                            giardino_show_layout($cats);
                        }
                        ?>
                        </div>
                    <div class="meta-right">
                        <?php
                            $vowels = array(",categories", "categories,", "categories");
                                $giardino_components = str_replace($vowels, "", $giardino_components);
                                if ( ! empty( $giardino_components ) && ! in_array( $giardino_hover, array( 'border', 'pull', 'slide', 'fade' ) ) ) {
                                    giardino_show_post_meta(
                                        apply_filters(
                                            'giardino_filter_post_meta_args', array(
                                                'components' => 'date,author',
                                                'counters'   => false,
                                                'seo'        => false,
                                            ), 'excerpt', 1
                                        )
                                    );
                                }
                         ?>
                    </div>
                </div>
                <?php
			do_action( 'giardino_action_before_post_title' );

			// Post title
			if ( empty( $giardino_template_args['no_links'] ) ) {
				the_title( sprintf( '<h2 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
			} else {
				the_title( '<h2 class="post_title entry-title">', '</h2>' );
			}

			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( empty( $giardino_template_args['hide_excerpt'] ) ) {

		?>
		<div class="post_content entry-content">
		<?php
		if ( giardino_get_theme_option( 'blog_content' ) == 'fullpost' ) {
			// Post content area
			?>
				<div class="post_content_inner">
				<?php
				the_content( '' );
				?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'giardino' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'giardino' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
		} else {
			// Post content area
			?>
				<div class="post_content_inner">
				<?php
				if ( has_excerpt() ) {
						the_excerpt();
				} elseif ( strpos( get_the_content( '!--more' ), '!--more' ) !== false ) {
						the_content( '' );
				} elseif ( in_array( $giardino_post_format, array( 'link', 'aside', 'status' ) ) ) {
										the_content();
				} elseif ( 'quote' == $giardino_post_format ) {
					$quote = giardino_get_tag( get_the_content(), '<blockquote>', '</blockquote>' );
					if ( ! empty( $quote ) ) {
						giardino_show_layout( wpautop( $quote ) );
					} else {
						the_excerpt();
					}
				} elseif ( substr( get_the_content(), 0, 4 ) != '[vc_' ) {
					the_excerpt();
				}
				?>
				</div>
				<?php
				// More button
				if ( empty( $giardino_template_args['no_links'] ) && ! in_array( $giardino_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
					?>
					<p><a class="more-link" href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e( 'Read more', 'giardino' ); ?></a></p>
					<?php
				}?>
				<div class="footer_meta">
				    <?php
				     $tags = get_the_tags();
                     if (! empty ($tags)){
                     ?>
				    <div class="footer_tags">
                        <?php
                            // Post tags
				            the_tags( '<span class="post_meta_item post_tags"><span class="post_meta_label">' . esc_html__( 'Tags', 'giardino' ) . '</span> ', ' ', '</span>' );
                          ?>
                    </div>
                    <?php
                       }
                     ?>
                    <div class="footer_likes">
                    <?php
                        do_action( 'giardino_action_before_post_meta' );
                        // Post meta
                        $giardino_components = giardino_array_get_keys_by_value( giardino_get_theme_option( 'meta_parts' ) );
                        $giardino_counters   = giardino_array_get_keys_by_value( giardino_get_theme_option( 'counters' ) );

                        if ( ! empty( $giardino_components ) && ! in_array( $giardino_hover, array( 'border', 'pull', 'slide', 'fade' ) ) ) {
                            giardino_show_post_meta(
                                apply_filters(
                                    'giardino_filter_post_meta_args', array(
                                        'components' => 'counters',
                                        'counters'   => 'likes,comments',
                                        'seo'        => false,
                                    ), 'excerpt', 1
                                )
                            );
                        }
                     ?>
                     </div>
				 </div>
		<?php }
		?>
		</div><!-- .entry-content -->
		<?php
	}
	}
	?>
	</article>
<?php

if ( is_array( $giardino_template_args ) ) {
	if ( ! empty( $giardino_template_args['slider'] ) || $giardino_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
