<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */

$giardino_template_args = get_query_var( 'giardino_template_args' );
if ( is_array( $giardino_template_args ) ) {
	$giardino_columns    = empty( $giardino_template_args['columns'] ) ? 1 : max( 1, min( 3, $giardino_template_args['columns'] ) );
	$giardino_blog_style = array( $giardino_template_args['type'], $giardino_columns );
} else {
	$giardino_blog_style = explode( '_', giardino_get_theme_option( 'blog_style' ) );
	$giardino_columns    = empty( $giardino_blog_style[1] ) ? 1 : max( 1, min( 3, $giardino_blog_style[1] ) );
}
$giardino_expanded    = ! giardino_sidebar_present() && giardino_is_on( giardino_get_theme_option( 'expand_content' ) );
$giardino_post_format = get_post_format();
$giardino_post_format = empty( $giardino_post_format ) ? 'standard' : str_replace( 'post-format-', '', $giardino_post_format );
$giardino_animation   = giardino_get_theme_option( 'blog_animation' );
$giardino_components = giardino_array_get_keys_by_value( giardino_get_theme_option( 'meta_parts' ) );
$giardino_counters   = giardino_array_get_keys_by_value( giardino_get_theme_option( 'counters' ) );

?><article id="post-<?php the_ID(); ?>" 
									<?php
									post_class(
										'post_item'
										. ' post_layout_chess'
										. ' post_layout_chess_' . esc_attr( $giardino_columns )
										. ' post_format_' . esc_attr( $giardino_post_format )
										. ( ! empty( $giardino_template_args['slider'] ) ? ' slider-slide swiper-slide' : '' )
									);
									echo ( ! giardino_is_off( $giardino_animation ) && empty( $giardino_template_args['slider'] ) ? ' data-animation="' . esc_attr( giardino_get_animation_classes( $giardino_animation ) ) . '"' : '' );
									?>
	>

	<?php
	// Add anchor
	if ( 1 == $giardino_columns && ! is_array( $giardino_template_args ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode( '[trx_sc_anchor id="post_' . esc_attr( get_the_ID() ) . '" title="' . esc_attr( get_the_title() ) . '" icon="' . esc_attr( giardino_get_post_icon() ) . '"]' );
	}

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$giardino_hover = ! empty( $giardino_template_args['hover'] ) && ! giardino_is_inherit( $giardino_template_args['hover'] )
						? $giardino_template_args['hover']
						: giardino_get_theme_option( 'image_hover' );
	giardino_show_post_featured(
		array(
			'class'         => 1 == $giardino_columns && ! is_array( $giardino_template_args ) ? 'giardino-full-height' : '',
			'singular'      => false,
			'hover'         => $giardino_hover,
			'no_links'      => ! empty( $giardino_template_args['no_links'] ),
			'show_no_image' => true,
			'thumb_ratio'   => '1:1',
			'thumb_bg'      => true,
			'thumb_size'    => giardino_get_thumb_size(
				strpos( giardino_get_theme_option( 'body_style' ), 'full' ) !== false
										? ( 1 < $giardino_columns ? 'huge' : 'original' )
										: ( 2 < $giardino_columns ? 'big' : 'huge' )
			),
		)
	);

	?>
	<div class="post_inner"><div class="post_inner_content"><div class="post_header entry-header">
        <div class="post-chess-header">
		    <?php
                // Post meta
                $giardino_post_meta  = empty( $giardino_components ) || in_array( $giardino_hover, array( 'border', 'pull', 'slide', 'fade' ) )
                    ? ''
                    : giardino_show_post_meta(
                        apply_filters(
                            'giardino_filter_post_meta_args', array(
                            'components' => $giardino_components,
                            'counters' => 'category',
                            'seo'  => false,
                            'echo' => false,
                        ), $giardino_blog_style[0], $giardino_columns
                        )
                    );
                giardino_show_layout( $giardino_post_meta );
            ?>
        </div>
            <?php
            // Post title
            if ( empty( $giardino_template_args['no_links'] ) ) {
                the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
            } else {
                the_title( '<h3 class="post_title entry-title">', '</h3>' );
            }

            $giardino_post_meta  = empty( $giardino_components ) || in_array( $giardino_hover, array( 'border', 'pull', 'slide', 'fade' ) )
                ? ''
                : giardino_show_post_meta(
                    apply_filters(
                        'giardino_filter_post_meta_args', array(
                        'components' => $giardino_components,
                        'counters' => $giardino_counters,
                        'seo'  => false,
                        'echo' => false,
                    ), $giardino_blog_style[0], $giardino_columns
                    )
                );
            giardino_show_layout( $giardino_post_meta );
            do_action( 'giardino_action_before_post_title' );
			?>


		</div><!-- .entry-header -->

		<div class="post_content entry-content">
		<?php
		if ( empty( $giardino_template_args['hide_excerpt'] ) ) {
			?>
				<div class="post_content_inner">
				<?php
				if ( has_excerpt() ) {
					the_excerpt();
				} elseif ( strpos( get_the_content( '!--more' ), '!--more' ) !== false ) {
					the_content( '' );
				} elseif ( in_array( $giardino_post_format, array( 'link', 'aside', 'status' ) ) ) {
					the_content();
				} elseif ( 'quote' == $giardino_post_format ) {
					$quote = giardino_get_tag( get_the_content(), '<blockquote>', '</blockquote>' );
					if ( ! empty( $quote ) ) {
						giardino_show_layout( wpautop( $quote ) );
					} else {
						the_excerpt();
					}
				} elseif ( substr( get_the_content(), 0, 4 ) != '[vc_' ) {
                    if( $giardino_columns >=2  ){
                        $my_excerpt = get_the_excerpt();
                        if ( '' != $my_excerpt ) {
                            $my_excerpt = substr($my_excerpt , 0, 100);
                        }
                       giardino_show_layout($my_excerpt);
                    }
                    else {
                        the_excerpt();
                    }
				}
				?>
				</div>
				<?php
		}
			// Post meta
		if ( in_array( $giardino_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
			giardino_show_layout( $giardino_post_meta );
		}
			// More button
		if ( empty( $giardino_template_args['no_links'] ) && ! in_array( $giardino_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
			?>
				<p><a class="more-link" href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e( 'Read more', 'giardino' ); ?></a></p>
				<?php
		}
		?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!
