<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Change default size for single image shortcode
add_action('init', 'vc_update_defaults', 100);
function vc_update_defaults() {
	if ( class_exists( 'WPBMap' ) )  {
		// Set full size for single image by default
		$param = WPBMap::getParam( 'vc_single_image', 'img_size' );
		$param['value'] = 'full';
		vc_update_shortcode_param( 'vc_single_image', $param );
	}
}

// Add moreparams
add_action('init', 'vc_add_new_para', 100);
function vc_add_new_para() {
	// Add Number param
	vc_add_shortcode_param( 'number', 'fundrize_param_number' );
	function fundrize_param_number( $settings, $value ) {
		$dependency = '';
		$param_name = isset($settings['param_name']) ? $settings['param_name'] : '';
		$type = isset($settings['type']) ? $settings['type'] : '';
		$suffix = isset($settings['suffix']) ? $settings['suffix'] : '';
		$class = isset($settings['class']) ? $settings['class'] : '';
		$output = '<input type="number" class="wpb_vc_param_value ' . $param_name . ' ' . $type . ' ' . $class . '" name="' . $param_name . '" value="'. $value.'" style="max-width:100px; margin-right: 10px;" />'. $suffix;
		return $output;
	}

	// Add Heading param
	vc_add_shortcode_param( 'headings', 'fundrize_param_heading' );
	function fundrize_param_heading( $settings, $value ) {
		$dependency = '';
		$param_name = isset($settings['param_name']) ? $settings['param_name'] : '';
		$class = isset($settings['class']) ? $settings['class'] : '';
		$text = isset($settings['text']) ? $settings['text'] : '';
		$output = '<h4 '. $dependency .' class="wpb_vc_param_value '. $class .'" style="margin: 10px 0 0;padding:10px;font-size:14px; background:#ebebeb;color:#666;">'. $text .'</h4>';
		$output .= '<input type="hidden" name="'. $settings['param_name'].'" class="wpb_vc_param_value ultimate-param-heading '. $settings['param_name'] .' '. $settings['type'] .'_field" value="'. $value.'" '. $dependency.'/>';
		return $output;
	}
}

// Register Backend and Frontend CSS Styles
add_action( 'vc_base_register_front_css', 'leadinjection_vc_iconpicker_base_register_css' );
add_action( 'vc_base_register_admin_css', 'leadinjection_vc_iconpicker_base_register_css' );
function leadinjection_vc_iconpicker_base_register_css(){
    wp_enqueue_style('extraicon', plugin_dir_url( __FILE__ ) . '/assets/donate-icons.css');
}

// Enqueue CSS in Frontend when it's used
add_action('vc_enqueue_font_icon_element', 'leadinjection_enqueue_font_extraicon');
function leadinjection_enqueue_font_extraicon($font){
    switch ( $font ) {
        case 'extraicon': wp_enqueue_style( 'extraicon' );
    }
}

// Define the Icons for VC Iconpicker
add_filter( 'vc_iconpicker-type-extraicon', 'vc_iconpicker_type_extraicon' );
function vc_iconpicker_type_extraicon() {
    return array(
		array("donation-icon-plus" => "plus"),
		array("donation-icon-rocket" => "rocket"),
		array("donation-icon-badge" => "badge"),
		array("donation-icon-blood" => "blood"),
		array("donation-icon-cancer" => "cancer"),
		array("donation-icon-care" => "care"),
		array("donation-icon-coins" => "coins"),
		array("donation-icon-credit-card" => "credit-card"),
		array("donation-icon-donate" => "donate"),
		array("donation-icon-donate2" => "donate2"),
		array("donation-icon-elephant" => "elephant"),
		array("donation-icon-ambulance" => "ambulance"),
		array("donation-icon-health" => "health"),
		array("donation-icon-medical" => "medical"),
		array("donation-icon-loving" => "loving"),
		array("donation-icon-doctor" => "doctor"),
		array("donation-icon-medical-kit" => "medical-kit"),
		array("donation-icon-medicine" => "medicine"),
		array("donation-icon-money" => "money"),
		array("donation-icon-money-bag" => "money-bag"),
		array("donation-icon-pig" => "pig"),
		array("donation-icon-water" => "water"),
		array("donation-icon-solidarity" => "solidarity"),
		array("donation-icon-stick-man" => "stick-man"),
		array("donation-icon-pill" => "pill"),
		array("donation-icon-wallet" => "wallet")
    );
}

// Return simple fonts array
if ( ! function_exists('fundrize_plugin_google_font') ) {
	function fundrize_plugin_google_font() {
		if ( function_exists('fundrize_google_fonts_array') ) {
			$default = array( 0 => 'Default' );
			return array_merge( $default, fundrize_google_fonts_array() );
		} else {
			return array(
				'Default', 'Arial, Helvetica, sans-serif', 'Arial Black, Gadget, sans-serif',
				'Bookman Old Style, serif', 'Comic Sans MS, cursive', 'Courier, monospace',
				'Georgia, serif', 'Garamond, serif', 'Impact, Charcoal, sans-serif', 'Lucida Console, Monaco, monospace',
				'Lucida Sans Unicode, Lucida Grande, sans-serif', 'MS Sans Serif, Geneva, sans-serif', 'MS Serif, New York, sans-serif',
				'Palatino Linotype, Book Antiqua, Palatino, serif', 'Tahoma, Geneva, sans-serif', 'Times New Roman, Times, serif',
				'Trebuchet MS, Helvetica, sans-serif', 'Verdana, Geneva, sans-serif', 'Paratina Linotype', 'Trebuchet MS',
			);
		}
	}
}

// Retrun animate classes
if ( ! function_exists('fundrize_animation') ) {
	function fundrize_animation() {
		return array(
			'fadeIn', 'fadeInDown', 'fadeInDownBig', 'fadeInLeftSmall', 'fadeInLeft', 'fadeInLeftBig', 'fadeInRightSmall', 'fadeInRight',
			'fadeInRightBig', 'fadeInUp', 'fadeInUpBig', 'fadeOut', 'fadeOutDown', 'fadeOutDownBig', 'fadeOutLeft', 'fadeOutLeftBig',
			'fadeOutRight', 'fadeOutRightBig', 'fadeOutUp', 'fadeOutUpBig', 'flash', 'pulse', 'rubberBand', 'shake', 'swing', 'tada', 'wobble',
			'jello', 'hinge', 'rollIn', 'rollOut', 'bounce', 'bounceIn', 'bounceInDown', 'bounceInLeft', 'bounceInRight',
			'bounceInUp', 'bounceOut', 'bounceOutDown', 'bounceOutLeft','bounceOutRight', 'bounceOutUp', 
			'flip', 'flipInX', 'flipInY', 'flipOutX', 'flipOutY', 'lightSpeedIn', 'lightSpeedOut', 'rotateIn', 'rotateInDownLeft', 'rotateInDownRight',
			'rotateInUpLeft', 'rotateInUpRight', 'rotateOut', 'rotateOutDownLeft', 'rotateOutDownRight', 'rotateOutUpLeft', 'rotateOutUpRight',
			'slideInUp', 'slideInDown', 'slideInLeft', 'slideInRight', 'slideOutUp', 'slideOutDown', 'slideOutLeft', 'slideOutRight',
			'zoomIn', 'zoomInDown', 'zoomInLeft', 'zoomInRight', 'zoomInUp', 'zoomOut', 'zoomOutDown', 'zoomOutLeft', 'zoomOutRight', 'zoomOutUp'
		);
	}
}

// Get icon font base on font icon type
if ( ! function_exists('fundrize_get_icon_class') ) {
	function fundrize_get_icon_class( $atts, $icon_location ) {
		// Define vars
		$icon = '';
		$icon_type = ! empty( $atts['icon_type'] ) ? $atts['icon_type'] : 'fontawesome';

		// Generate fontawesome icon class
		if ( 'fontawesome' == $icon_type && ! empty( $atts[$icon_location] ) ) {
			$icon = $atts[$icon_location];
			$icon = str_replace( 'fa-', '', $icon );
			$icon = str_replace( 'fa ', '', $icon );
			$icon = 'fa fa-'. $icon;
		} elseif ( ! empty( $atts[ $icon_location .'_'. $icon_type ] ) ) {
			$icon = $atts[ $icon_location .'_'. $icon_type ];
		}

		// Sanitize
		$icon = in_array( $icon, array( 'icon', 'none' ) ) ? '' : $icon;

		// Return icon class
		return $icon;
	}
}

// Spacing
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Spacing', 'fundrize'),
        'description' => esc_html__('Empty space with custom height.', 'fundrize'),
        'base' => 'spacing',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
        'params' => array(
	        array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Desktop: Height', 'fundrize'),
				'param_name' => 'desktop_height',
				'value' => '',
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Mobile: Height', 'fundrize'),
				'param_name' => 'mobile_height',
				'value' => '',
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Small Mobile: Height', 'fundrize'),
				'param_name' => 'smobile_height',
				'value' => '',
	        ),
        )
    ) );
} );

// Carousel Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_carouselbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Carousel Box', 'fundrize'),
		'description' => esc_html__('Scrolling anything.', 'fundrize'),
		'base' => 'carouselbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('only' => 'contentbox, imagebox, iconbox, advimage, testimonials, headings, fancytext, singleheading, pricetable, counter'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'fundrize' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Infinity Loop?', 'fundrize' ),
				'param_name' => 'loop',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'fundrize' ),
				'description'	=> esc_html__('Duplicate last and first items to get loop illusion.', 'fundrize'),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Spacing Between', 'fundrize'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'fundrize' ),
	        ),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'fundrize'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'fundrize' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Elements', 'fundrize' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'fundrize' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'fundrize'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'fundrize' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'fundrize' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'0 - IN' => '0i',
					'Center' => 'center',
					'0 - OUT' => '0o',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'fundrize' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			// Column
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px', 'fundrize' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px', 'fundrize' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px', 'fundrize' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Galleries Carousel
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Galleries Carousel', 'fundrize'),
        'description' => esc_html__('Displaying gallery posts in carousel.', 'fundrize'),
        'base' => 'galleries',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'fundrize' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'400 x 400' => 'square2',
					'600 x 500' => 'rectangle',
					'600 x 390' => 'rectangle2',
					'600 x auto' => 'auto2',
				),
				'std'		=> 'square2',
				'description'	=> esc_html__('Choose auto option to keep the same aspect ratio when cropping.', 'fundrize'),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'fundrize'),
				'param_name' => 'gap',
				'value' => '0',
				'description'	=> esc_html__('Ex: 30', 'fundrize'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Posts Per Page', 'fundrize'),
				'param_name' => 'items',
				'value' => '8',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'fundrize'),
				'param_name' => 'cat_slug',
				'value' => '',
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'fundrize'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'fundrize' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
			),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'fundrize'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'fundrize' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'fundrize' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'fundrize' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'fundrize'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'fundrize' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'fundrize' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'0 - IN' => '0i',
					'Center' => 'center',
					'0 - OUT' => '0o',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'fundrize' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px.', 'fundrize' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px.', 'fundrize' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px.', 'fundrize' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Galleries Grid
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Galleries Grid', 'fundrize'),
        'description' => esc_html__('Displaying gallery posts in grid with filter bar.', 'fundrize'),
        'base' => 'galleriesgrid',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'fundrize' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'400 x 400' => 'square2',
					'600 x 500' => 'rectangle',
					'600 x 390' => 'rectangle2',
					'600 x auto' => 'auto2',
				),
				'std'		=> 'rectangle2',
				'description'	=> esc_html__('Choose auto option to keep the same aspect ratio when cropping.', 'fundrize'),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'fundrize'),
				'param_name' => 'gapv',
				'value' => '0',
				'description'	=> esc_html__('Ex: 30', 'fundrize'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing below items', 'fundrize'),
				'param_name' => 'gaph',
				'value' => '0',
				'description'	=> esc_html__('Ex: 30', 'fundrize'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Posts Per Page', 'fundrize'),
				'param_name' => 'items',
				'group'      => esc_html__( 'Query', 'fundrize' ),
				'value' => '8',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'fundrize'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'fundrize' ),
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'fundrize'),
	        ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Show Pagination?', 'fundrize' ),
				'param_name' => 'pagination',
				'group' => esc_html__( 'Query', 'fundrize' ),
				'value' => array(
					'Yes' => 'true',
					'No' => 'false',
				),
				'std'		=> 'false',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Show Filter Bar?', 'fundrize' ),
				'param_name' => 'show_filter',
				'group' => esc_html__( 'Filter', 'fundrize' ),
				'value' => array(
					'Yes' => 'true',
					'No' => 'false',
				),
				'std'		=> 'true',
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Filter posts by default?', 'fundrize' ),
				'param_name' => 'filter_by_default',
				'group' => esc_html__( 'Filter', 'fundrize' ),
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug', 'fundrize'),
				'param_name' => 'filter_cat_slug',
				'value' => '',
				'group' => esc_html__( 'Filter', 'fundrize' ),
				'dependency' => array( 'element' => 'filter_by_default', 'value' => 'yes' ),
				'description'	=> esc_html__('Filter posts from this category by default. Using category-slug.', 'fundrize'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button: All', 'fundrize'),
				'param_name' => 'filter_button_all',
				'value' => 'All',
				'group' => esc_html__( 'Filter', 'fundrize' ),
				'description'	=> esc_html__('Leave it empty to disable.', 'fundrize'),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'fundrize'),
				'param_name' => 'bottom_filter',
				'group' => esc_html__( 'Filter', 'fundrize' ),
				'value' => '',
				'description'	=> esc_html__('Default: 45px.', 'fundrize'),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
            ),
            // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Filter: Font Family', 'fundrize' ),
				'param_name' => 'filter_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Filter: Font Weight', 'fundrize' ),
				'param_name' => 'filter_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Filter: Font Size', 'fundrize'),
				'param_name' => 'filter_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Filter: Line-Height', 'fundrize'),
				'param_name' => 'filter_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Filter: Letter Spacing', 'fundrize'),
				'param_name' => 'filter_letter_spacing',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Filter: Text Transform', 'fundrize' ),
				'param_name' => 'filter_text_tranform',
				'value'      => array(
					'Capitalize' => 'capitalize',
					'Uppercase' => 'uppercase',
				),
				'std'		=> 'uppercase',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap > 1100px', 'fundrize' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c'
				),
				'std'		=> '4c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 800px to 1099px', 'fundrize' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 550px to 799px', 'fundrize' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap < 549px', 'fundrize' ),
				'param_name' => 'column4',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Testimonials
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Testimonials', 'fundrize'),
	    'description' => esc_html__('Displaying testimonials box.', 'fundrize'),
	    'base' => 'testimonials',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
	    'params' => array(
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'fundrize'),
				'param_name' => 'image',
				'value' => '',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width (Optional)', 'fundrize'),
				'param_name' => 'image_width',
				'value' => '',
				'description'	=> esc_html__('Default: 70px.', 'fundrize'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Style', 'fundrize' ),
				'param_name' => 'image_style',
				'value'      => array(
					'Square' => 'image-square',
					'Circle' => 'image-circle',
				),
				'std'		=> 'image-circle',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Wrap: Background', 'fundrize'),
				'param_name' => 'text_background',
				'value' => '#f6f6f6',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap: Padding', 'fundrize'),
				'param_name' => 'text_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 30px 25px 25px 25px', 'fundrize'),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap: Rounded', 'fundrize'),
				'param_name' => 'text_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 6px', 'fundrize'),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Wrap: Box Shadow?', 'fundrize' ),
				'param_name' => 'box_shadow',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
	        // Text
			array(
				'type' 		=> 'textarea',
				'heading' 	=> esc_html__('Text', 'fundrize'),
				'param_name' 	=> 'text',
				'value' 		=> '',
				'group' => esc_html__( 'Text', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'fundrize'),
				'param_name' => 'text_color',
				'value' => '',
				'group' => esc_html__( 'Text', 'fundrize' ),
            ),
            // Name
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Name', 'fundrize'),
				'param_name' => 'name',
				'value' => 'JOHN ROE',
				'group' => esc_html__( 'Name & Position', 'fundrize' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Name Color', 'fundrize'),
				'param_name' => 'name_color',
				'value' => '',
				'group' => esc_html__( 'Name & Position', 'fundrize' ),
            ),
            // Position
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Position', 'fundrize'),
				'param_name' => 'position',
				'value' => 'Sale Manager',
				'group' => esc_html__( 'Name & Position', 'fundrize' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Position Color', 'fundrize'),
				'param_name' => 'position_color',
				'value' => '',
				'group' => esc_html__( 'Name & Position', 'fundrize' ),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Name & Position Inline?', 'fundrize' ),
				'param_name' => 'inline',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
				'description'	=> esc_html__('Displaying Name & Position Inline', 'fundrize'),
				'group' => esc_html__( 'Name & Position', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name & Position: Space Between', 'fundrize'),
				'param_name' => 'gap',
				'value' => '5px',
				'group' => esc_html__( 'Name & Position', 'fundrize' ),
				'dependency' => array( 'element' => 'inline', 'value' => 'yes' ),
	        ),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Text', 'fundrize'),
				'param_name' => 'text_typography',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Font Family', 'fundrize' ),
				'param_name' => 'text_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Font Weight', 'fundrize' ),
				'param_name' => 'text_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text Font Size', 'fundrize'),
				'param_name' => 'text_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Font Style', 'fundrize' ),
				'param_name' => 'text_font_style',
				'value'      => array(
					'Normal' => 'normal',
					'Italic' => 'italic',
				),
				'std'		=> 'normal',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text Line-height', 'fundrize'),
				'param_name' => 'text_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Name', 'fundrize'),
				'param_name' => 'name_typography',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Family', 'fundrize' ),
				'param_name' => 'name_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Weight', 'fundrize' ),
				'param_name' => 'name_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Font Size', 'fundrize'),
				'param_name' => 'name_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Line-height', 'fundrize'),
				'param_name' => 'name_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Position', 'fundrize'),
				'param_name' => 'position_typography',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Family', 'fundrize' ),
				'param_name' => 'position_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Weight', 'fundrize' ),
				'param_name' => 'company_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Font Size', 'fundrize'),
				'param_name' => 'position_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Line-height', 'fundrize'),
				'param_name' => 'position_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name & Position: Top Margin', 'fundrize'),
				'param_name' => 'name_post_top',
				'value' => '',
				'description'	=> esc_html__('Ex: 20px', 'fundrize'),
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	    )
	) );
} );

// News Carousel
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('News Carousel', 'fundrize'),
	    'description' => esc_html__('Displaying blog posts in carousel.', 'fundrize'),
	    'base' => 'news',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Thumbnail Cropping', 'fundrize' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'600 x 600' => 'square',
					'600 x 500' => 'rectangle',
					'600 x 440' => 'bloggrid',
					'600 x 390' => 'rectangle2',
				),
				'std'		=> 'rectangle',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'fundrize' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding.', 'fundrize'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 23px 30px 28px 30px', 'fundrize'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Background', 'fundrize'),
				'param_name' => 'content_background',
				'value' => '#f7f7f7',
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Hide Meta Post?', 'fundrize' ),
				'param_name' => 'hide_meta',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Box Shadow?', 'fundrize' ),
				'param_name' => 'box_shadow',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
	        // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'fundrize'),
				'param_name' => 'items',
				'value' => '3',
				'group' => esc_html__( 'Query', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'fundrize'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'fundrize' ),
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'fundrize'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Excerpt Length', 'fundrize'),
				'param_name' => 'excerpt_lenght',
				'value' => '15',
				'description' => esc_html('The number of words you wish to display in the excerpt. Enter "0" to hide the excerpt.', 'fundrize'),
				'group' => esc_html__( 'Query', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Space Between', 'fundrize'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'fundrize' ),
				'description'	=> esc_html__('Important! Include the blur distance of the shadow.', 'fundrize'),
	        ),
			// Button
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Text', 'fundrize'),
				'param_name' => 'button_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'Button', 'fundrize' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Style', 'fundrize' ),
				'param_name' => 'button_style',
				'value'      => array(
					'Simple Link' => 'simple_link',
					'Accent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
					'Very Light' => 'very-light',
					'White' => 'white',
					'Outline' => 'outline',
					'Outline Dark' => 'outline_dark',
					'Outline Light' => 'outline_light',
					'Outline Very light' => 'outline_very-light',
					'Outline White' => 'outline_white',
				),
				'std'		=> 'accent',
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'fundrize' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => '',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'small',
				'group' => esc_html__( 'Button', 'fundrize' ),
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'accent',
						'dark',
						'light',
						'very-light',
						'white',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'fundrize'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'fundrize'),
				'group' => esc_html__( 'Button', 'fundrize' ),
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'accent',
						'dark',
						'light',
						'very-light',
						'white',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Link Color', 'fundrize'),
				'param_name' => 'link_color',
				'value' => '',
				'group' => esc_html__( 'Button', 'fundrize' ),
				'dependency' => array( 'element' => 'button_style', 'value' => 'simple_link' ),
            ),
	        // Controls
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'fundrize' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'fundrize'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'fundrize' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'fundrize' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'fundrize' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'fundrize'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'fundrize' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'fundrize' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'0 - IN' => '0i',
					'Center' => 'center',
					'0 - OUT' => '0o',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'fundrize' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px.', 'fundrize' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px.', 'fundrize' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px.', 'fundrize' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'fundrize'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'fundrize' ),
				'param_name' => 'heading_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'fundrize' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'fundrize'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'fundrize'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'fundrize'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Excerpt', 'fundrize'),
				'param_name' => 'desc_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Excerpt Font Family', 'fundrize' ),
				'param_name' => 'desc_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Excerpt Font Weight', 'fundrize' ),
				'param_name' => 'desc_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Excerpt Color', 'fundrize'),
				'param_name' => 'desc_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Excerpt Font Size', 'fundrize'),
				'param_name' => 'desc_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Excerpt Line-height', 'fundrize'),
				'param_name' => 'desc_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Button', 'fundrize'),
				'param_name' => 'button_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Family', 'fundrize' ),
				'param_name' => 'button_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Weight', 'fundrize' ),
				'param_name' => 'button_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Font Size', 'fundrize'),
				'param_name' => 'button_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Line-Height', 'fundrize'),
				'param_name' => 'button_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'fundrize'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'fundrize'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Top Margin', 'fundrize'),
				'param_name' => 'desc_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Bottom Margin', 'fundrize'),
				'param_name' => 'desc_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	    )
	) );
} );

// ProgressBar
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Progress Bar', 'thecraft'),
        'description' => esc_html__('Displaying progress bars.', 'thecraft'),
        'base' => 'progressbar',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'thecraft'),
        'params' => array(
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Title', 'thecraft'),
				'param_name' => 'title',
				'value' => esc_html__('Title', 'thecraft'),
				'description' => esc_html__('Title of the ProgressBar.', 'thecraft')
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'thecraft'),
				'param_name' => 'title_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Percentage', 'thecraft'),
				'param_name' => 'percent',
				'value' => '90',
				'description' => esc_html__('Percentage value of the ProgressBar', 'thecraft')
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Percentage Style', 'thecraft' ),
				'param_name' => 'percent_style',
				'value'      => array(
					'Simple' => 'pstyle-1',
					'Accent' => 'pstyle-2',
					'Grey' => 'pstyle-3',
				),
				'std'		=> 'pstyle-1',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Percentage Color', 'thecraft'),
				'param_name' => 'per_color',
				'value' => '',
				'dependency' => array( 'element' => 'percent_style', 'value' => 'style-1' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Height of Bars', 'thecraft'),
				'param_name' => 'height',
				'value' => '10px',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Space between Text & Line', 'thecraft'),
				'param_name' => 'space_between',
				'value' => '10px',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'thecraft'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 5px', 'thecraft'),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'thecraft'),
				'param_name' => 'bottom_margin',
				'value' => '',
				'description'	=> esc_html__('Ex: 20px', 'thecraft'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line 1', 'thecraft'),
				'param_name' => 'line_one',
				'value' => '#636363',
				'group' => esc_html__( 'Line Color', 'thecraft' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line 2', 'thecraft'),
				'param_name' => 'line_two',
				'value' => '#e5e5e5',
				'group' => esc_html__( 'Line Color', 'thecraft' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'thecraft' ),
				'param_name' => 'font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'thecraft' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'thecraft' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'thecraft'),
				'param_name' => 'font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'thecraft' ),
	        ),
        )
    ) );
} );
// Accordions
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_accordions extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Accordions', 'fundrize' ),
        'description' => esc_html__('Displaying Accordions', 'fundrize'),
		'base'        => 'accordions',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array( 'only' => 'accordion' ),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'fundrize' ),
				'param_name' => 'style',
				'value'      => array(
					'Accent Background' => 'style-1',
					'Dark Background' => 'style-2',
				),
				'std'		=> 'style-1',
			),
		)
	) );
} );

// Accordion
add_action( 'vc_before_init', function() {
	vc_map( array(
	'name'        => esc_html__( 'Accordion', 'fundrize' ),
    'description' => esc_html__('Displaying Accordion', 'fundrize'),
		'base'        => 'accordion',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'js_composer'),
		'as_child'    => array( 'only' => 'accordions' ),
		'params'      => array(
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Active by default?', 'fundrize' ),
				'param_name' => 'open',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			array(
				'type' => 'number',
				'heading' => esc_html__('Bottom Margin', 'fundrize'),
				'param_name' => 'bottom_margin',
				'value' => 10,
				'suffix' => 'px',
				'description'	=> esc_html__('Default: 10px', 'fundrize'),
		  	),
			// Heading
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'fundrize' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Heading', 'fundrize' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'fundrize'),
				'param_name' => 'heading',
				'value' => '',
				'group' => esc_html__( 'Heading', 'fundrize' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Padding', 'fundrize'),
				'param_name' => 'heading_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 13px 25px 13px 25px', 'fundrize'),
				'group' => esc_html__( 'Heading', 'fundrize' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'fundrize'),
				'param_name' => 'heading_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 25px', 'fundrize'),
				'group' => esc_html__( 'Heading', 'fundrize' ),
            ),
			// Icon
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Heading Icon?', 'fundrize' ),
				'param_name' => 'show_icon',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
				'group' => esc_html__( 'Heading', 'fundrize' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'fundrize' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'fundrize' ),
				'value' => array(
					esc_html__( '', 'fundrize' ) => '',
					esc_html__( 'Donate Icons', 'fundrize' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'fundrize' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'fundrize' ) => 'openiconic',
					esc_html__( 'Typicons', 'fundrize' ) => 'typicons',
					esc_html__( 'Entypo', 'fundrize' ) => 'entypo',
					esc_html__( 'Linecons', 'fundrize' ) => 'linecons',
				),
				'group' => esc_html__( 'Heading', 'fundrize' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'fundrize' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Heading', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Heading', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Heading', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Heading', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Heading', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Heading', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'fundrize'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Heading', 'fundrize' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between the heading and the icon', 'fundrize'),
				'param_name' => 'heading_left_padding',
				'value' => '30',
				'group' => esc_html__( 'Heading', 'fundrize' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
	        ),
	        // Content
			array(
				'type' 		=> 'textarea_html',
				'heading' 	=> esc_html__('Content', 'fundrize'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'fundrize'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 20px 0px 23px 0px', 'fundrize'),
				'group' => esc_html__( 'Content', 'fundrize' ),
	        ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'fundrize' ),
				'param_name' => 'heading_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'fundrize' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'fundrize'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'fundrize'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
		)
	) );
} );

// Member Carousel
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Member Carousel', 'fundrize'),
	    'description' => esc_html__('Displaying member posts in carousel.', 'fundrize'),
	    'base' => 'member',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'fundrize' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'fundrize' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'600 x 500' => 'rectangle',
					'600 x 390' => 'rectangle2',
				),
				'std'		=> 'full',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'fundrize'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 8px 20px 35px 20px', 'fundrize'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'fundrize'),
				'param_name' => 'content_background',
				'value' => '#f6f6f6',
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Box Shadow?', 'fundrize' ),
				'param_name' => 'box_shadow',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
            // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'fundrize'),
				'param_name' => 'items',
				'value' => '4',
				'group' => esc_html__( 'Query', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'fundrize'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'fundrize' ),
				'description'	=> esc_html__('Display posts that have this category. Using category-slug.', 'fundrize'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'fundrize'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'fundrize' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'fundrize' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'fundrize' ),
			),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'fundrize'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'fundrize' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'fundrize' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'fundrize' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'fundrize'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'fundrize' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'fundrize' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'0 - IN' => '0i',
					'Center' => 'center',
					'0 - OUT' => '0o',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'fundrize' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px', 'fundrize' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px', 'fundrize' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px', 'fundrize' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Name', 'fundrize'),
				'param_name' => 'name_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Family', 'fundrize' ),
				'param_name' => 'name_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Weight', 'fundrize' ),
				'param_name' => 'name_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Name Color', 'fundrize'),
				'param_name' => 'name_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Font Size', 'fundrize'),
				'param_name' => 'name_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Line-Height', 'fundrize'),
				'param_name' => 'name_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Position', 'fundrize'),
				'param_name' => 'position_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Family', 'fundrize' ),
				'param_name' => 'position_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Weight', 'fundrize' ),
				'param_name' => 'position_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Position Color', 'fundrize'),
				'param_name' => 'position_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Font Size', 'fundrize'),
				'param_name' => 'position_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Line-Height', 'fundrize'),
				'param_name' => 'position_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			// Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name: Top Margin', 'fundrize'),
				'param_name' => 'name_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name: Bottom Margin', 'fundrize'),
				'param_name' => 'name_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position: Top Margin', 'fundrize'),
				'param_name' => 'position_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position: Bottom Margin', 'fundrize'),
				'param_name' => 'position_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	    )
	) );
} );

// Member Grid
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Member Grid', 'fundrize'),
	    'description' => esc_html__('Displaying member posts in grid.', 'fundrize'),
	    'base' => 'membergrid',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'fundrize' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'fundrize' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'600 x 500' => 'rectangle',
					'600 x 390' => 'rectangle2',
				),
				'std'		=> 'full',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'fundrize'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 8px 20px 35px 20px', 'fundrize'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'fundrize'),
				'param_name' => 'content_background',
				'value' => '#f6f6f6',
            ),
            array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Box Shadow?', 'fundrize' ),
				'param_name' => 'box_shadow',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
            // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'fundrize'),
				'param_name' => 'items',
				'value' => '3',
				'group' => esc_html__( 'Query', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'fundrize'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'fundrize' ),
				'description'	=> esc_html__('Display posts that have this category. Using category-slug.', 'fundrize'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'fundrize'),
				'param_name' => 'gapv',
				'value' => '30',
				'group' => esc_html__( 'Query', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing below items', 'fundrize'),
				'param_name' => 'gaph',
				'value' => '40',
				'group' => esc_html__( 'Query', 'fundrize' ),
	        ),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Column(s)', 'fundrize' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '3c',
			),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Name', 'fundrize'),
				'param_name' => 'name_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Family', 'fundrize' ),
				'param_name' => 'name_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Weight', 'fundrize' ),
				'param_name' => 'name_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Name Color', 'fundrize'),
				'param_name' => 'name_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Font Size', 'fundrize'),
				'param_name' => 'name_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Line-Height', 'fundrize'),
				'param_name' => 'name_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Position', 'fundrize'),
				'param_name' => 'position_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Family', 'fundrize' ),
				'param_name' => 'position_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Weight', 'fundrize' ),
				'param_name' => 'position_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Position Color', 'fundrize'),
				'param_name' => 'position_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Font Size', 'fundrize'),
				'param_name' => 'position_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Line-Height', 'fundrize'),
				'param_name' => 'position_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			// Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name: Top Margin', 'fundrize'),
				'param_name' => 'name_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name: Bottom Margin', 'fundrize'),
				'param_name' => 'name_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position: Top Margin', 'fundrize'),
				'param_name' => 'position_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position: Bottom Margin', 'fundrize'),
				'param_name' => 'position_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	    )
	) );
} );

// Action Box
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Action Box', 'fundrize'),
	    'description' => esc_html__('Displaying Action-Box or Promo-Box.', 'fundrize'),
	    'base' => 'actionbox',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
	    'params' => array(
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap Padding', 'fundrize'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'fundrize'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Wrap Background Color', 'fundrize'),
				'param_name' => 'background',
				'value' => '',
            ),
            // Content
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'fundrize'),
				'param_name' => 'heading_content',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'fundrize' ),
				'param_name' => 'heading_tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h2',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading Text', 'fundrize'),
				'param_name' => 'heading_text',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'fundrize'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
			// Icon
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Heading Icon?', 'fundrize' ),
				'param_name' => 'show_icon',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'fundrize' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'fundrize' ),
				'value' => array(
					esc_html__( '', 'fundrize' ) => '',
					esc_html__( 'Donate Icons', 'fundrize' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'fundrize' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'fundrize' ) => 'openiconic',
					esc_html__( 'Typicons', 'fundrize' ) => 'typicons',
					esc_html__( 'Entypo', 'fundrize' ) => 'entypo',
					esc_html__( 'Linecons', 'fundrize' ) => 'linecons',
				),
				'group' => esc_html__( 'Content', 'fundrize' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'fundrize' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'fundrize'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'fundrize'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Right Padding', 'fundrize'),
				'param_name' => 'icon_right_padding',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
				'description'	=> esc_html__('Spacing between the icon and the heading. Default: 20px.', 'fundrize'),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
	        ),
			// Sub-Heading
			array(
				'type' => 'headings',
				'text' => esc_html__('Sub-Heading', 'fundrize'),
				'param_name' => 'subheading_content',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Sub-Heading (Optional)', 'fundrize' ),
				'param_name' => 'subheading_text',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Sub-Heading Color', 'fundrize'),
				'param_name' => 'subheading_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
            // Button
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'fundrize' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => '',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> '',
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Style', 'fundrize' ),
				'param_name' => 'button_style',
				'value'      => array(
					'Accent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
					'Very Light' => 'very-light',
					'White' => 'white',
					'Outline' => 'outline',
					'Outline Dark' => 'outline_dark',
					'Outline Light' => 'outline_light',
					'Outline Very light' => 'outline_very-light',
					'Outline White' => 'outline_white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Button Text', 'fundrize'),
				'param_name' => 'button_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'Button', 'fundrize' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'fundrize'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'fundrize'),
				'group' => esc_html__( 'Button', 'fundrize' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button link (URL):', 'fundrize'),
				'param_name' => 'button_url',
				'value' => '',
				'group' => esc_html__( 'Button', 'fundrize' ),
            ),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Button Padding', 'fundrize'),
				'param_name' => 'button_padding',
				'value' => '',
				'group' => esc_html__( 'Button', 'fundrize' ),
            ),
            // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'fundrize'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'fundrize' ),
				'param_name' => 'heading_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'fundrize' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'fundrize'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'fundrize'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Sub-Heading', 'fundrize'),
				'param_name' => 'subheading_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading Font Family', 'fundrize' ),
				'param_name' => 'subheading_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading Font Weight', 'fundrize' ),
				'param_name' => 'subheading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading Font Size', 'fundrize'),
				'param_name' => 'subheading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading Line-Height', 'fundrize'),
				'param_name' => 'subheading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Button', 'fundrize'),
				'param_name' => 'button_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Family', 'fundrize' ),
				'param_name' => 'button_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Weight', 'fundrize' ),
				'param_name' => 'button_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Font Size', 'fundrize'),
				'param_name' => 'button_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Line-Height', 'fundrize'),
				'param_name' => 'button_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'fundrize'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'fundrize'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button: Top Margin', 'fundrize'),
				'param_name' => 'button_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button: Bottom Margin', 'fundrize'),
				'param_name' => 'button_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	    )
	) );
} );

// Menu List
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Menu List', 'fundrize'),
	    'description' => esc_html__('Menu List.', 'fundrize'),
	    'base' => 'menulist',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'params'      => array(
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'fundrize'),
				'param_name' => 'background',
				'value' => '#f8f8f8',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'fundrize'),
				'param_name' => 'border_color',
				'value' => '#f1f1f1',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'fundrize'),
				'param_name' => 'border_width',
				'value' => '1px',
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'fundrize' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
				),
				'std'		=> 'solid',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'fundrize'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 12px 30px 12px 30px', 'fundrize'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'fundrize'),
				'param_name' => 'bottom_margin',
				'value' => '10',
	        ),
	        // Content
			array(
				'type' => 'headings',
				'text' => esc_html__('Text', 'fundrize'),
				'param_name' => 'text_content',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Text', 'fundrize'),
				'param_name' => 'text',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'fundrize'),
				'param_name' => 'text_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text: Top Padding', 'fundrize'),
				'param_name' => 'text_padding',
				'value' => '5px',
				'group' => esc_html__( 'Content', 'fundrize' ),
				'dependency' => array( 'element' => 'value_style', 'value' => 'background' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Value', 'fundrize'),
				'param_name' => 'value_content',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Value Style', 'fundrize' ),
				'param_name' => 'value_style',
				'value'      => array(
					'Background' => 'background',
					'Simple' => 'simple',
				),
				'std'		=> 'background',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Value', 'fundrize'),
				'param_name' => 'value',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'fundrize'),
				'param_name' => 'value_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'fundrize'),
				'param_name' => 'value_background',
				'value' => '',
				'dependency' => array( 'element' => 'value_style', 'value' => 'background' ),
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'fundrize'),
				'param_name' => 'value_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 3px 10px 3px 10px', 'fundrize'),
				'dependency' => array( 'element' => 'value_style', 'value' => 'background' ),
				'group' => esc_html__( 'Content', 'fundrize' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'fundrize'),
				'param_name' => 'value_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex:3px', 'fundrize'),
				'dependency' => array( 'element' => 'value_style', 'value' => 'background' ),
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Text', 'fundrize'),
				'param_name' => 'text_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text: Font Family', 'fundrize' ),
				'param_name' => 'text_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text: Font Weight', 'fundrize' ),
				'param_name' => 'text_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text: Font Size', 'fundrize'),
				'param_name' => 'text_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Value', 'fundrize'),
				'param_name' => 'value_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Value: Font Family', 'fundrize' ),
				'param_name' => 'value_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Value: Font Weight', 'fundrize' ),
				'param_name' => 'value_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Value: Font Size', 'fundrize'),
				'param_name' => 'value_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
		)
	) );
} );

// Info List
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Info List', 'fundrize'),
	    'description' => esc_html__('Information List.', 'fundrize'),
	    'base' => 'infolist',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'params'      => array(
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Padding', 'fundrize'),
				'param_name' => 'bottom_padding',
				'value' => '10px',
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'fundrize'),
				'param_name' => 'bottom_margin',
				'value' => '10px',
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'fundrize'),
				'param_name' => 'border_color',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'fundrize'),
				'param_name' => 'border_width',
				'value' => '',
				'description'	=> esc_html__('Ex: 1px', 'fundrize'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'fundrize' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
				),
				'std'		=> 'solid',
			),
	        // Title
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Title', 'fundrize'),
				'param_name' => 'title',
				'value' => '',
				'group' => esc_html__( 'Title', 'fundrize' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Title Color', 'fundrize'),
				'param_name' => 'title_color',
				'value' => '',
				'group' => esc_html__( 'Title', 'fundrize' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Title: Width', 'fundrize'),
				'param_name' => 'title_width',
				'value' => '150px',
				'group' => esc_html__( 'Title', 'fundrize' ),
	        ),
	        // Text
			array(
				'type' 		=> 'textarea_html',
				'heading' 	=> esc_html__('Text', 'fundrize'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Text', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'fundrize'),
				'param_name' => 'text_color',
				'value' => '',
				'group' => esc_html__( 'Text', 'fundrize' ),
            ),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Title', 'fundrize'),
				'param_name' => 'title_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title: Font Family', 'fundrize' ),
				'param_name' => 'title_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title: Font Weight', 'fundrize' ),
				'param_name' => 'title_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Title: Font Size', 'fundrize'),
				'param_name' => 'title_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Text', 'fundrize'),
				'param_name' => 'text_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text: Font Family', 'fundrize' ),
				'param_name' => 'text_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text: Font Weight', 'fundrize' ),
				'param_name' => 'text_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text: Font Size', 'fundrize'),
				'param_name' => 'text_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
		)
	) );
} );

// Image Box
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Image Box', 'fundrize'),
	    'description' => esc_html__('Displaying image box.', 'fundrize'),
	    'base' => 'imagebox',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'fundrize' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> '',
			),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'fundrize'),
				'param_name' => 'image',
				'value' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'fundrize' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'600 x 600' => 'square',
					'600 x 500' => 'rectangle',
					'600 x 390' => 'rectangle2',
					'870 x auto' => 'auto1',
					'600 x auto' => 'auto2',
					'480 x auto' => 'auto3',
				),
				'std'		=> 'rectangle',
				'description'	=> esc_html__('Select "auto" to keep the same aspect ratio when cropping.', 'fundrize'),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'fundrize'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 23px 30px 28px 30px', 'fundrize'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'fundrize'),
				'param_name' => 'background_color',
				'value' => '#f6f6f6',
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Box Shadow?', 'fundrize' ),
				'param_name' => 'box_shadow',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			// Content
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'fundrize'),
				'param_name' => 'hading_content',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'fundrize' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'fundrize'),
				'param_name' => 'heading',
				'value' => 'Heading Text',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'fundrize'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Separator', 'fundrize'),
				'param_name' => 'separator_content',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Separator', 'fundrize' ),
				'param_name' => 'separator',
				'value'      => array(
					'No Separator' => '',
					'Line' => 'line'
				),
				'std'		=> '',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Line: Full-width', 'fundrize' ),
				'param_name' => 'line_full',
				'value'      => array(
					'No' => 'no',
					'Yes' => 'yes',
				),
				'std'		=> 'no',
				'group' => esc_html__( 'Content', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Width', 'fundrize'),
				'param_name' => 'line_width',
				'value' => '50',
				'group' => esc_html__( 'Content', 'fundrize' ),
				'dependency' => array( 'element' => 'line_full', 'value' => 'no' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'fundrize'),
				'param_name' => 'line_height',
				'value' => '2',
				'group' => esc_html__( 'Content', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line Color', 'fundrize'),
				'param_name' => 'line_color',
				'value' => '#eee',
				'group' => esc_html__( 'Content', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'fundrize'),
				'param_name' => 'desc_content',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type' 		=> 'textarea',
				'heading' 	=> esc_html__('Description', 'fundrize'),
				'param_name' 	=> 'description',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Description Color', 'fundrize'),
				'param_name' => 'desc_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
	        // Button
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Text', 'fundrize'),
				'param_name' => 'button_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'Button', 'fundrize' ),
				'description'	=> esc_html__('Leave it empty to disable.', 'fundrize'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Style', 'fundrize' ),
				'param_name' => 'button_style',
				'value'      => array(
					'Simple Link' => 'simple_link',
					'Accent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
					'Very Light' => 'very-light',
					'White' => 'white',
					'Outline' => 'outline',
					'Outline Dark' => 'outline_dark',
					'Outline Light' => 'outline_light',
					'Outline Very light' => 'outline_very-light',
					'Outline White' => 'outline_white',
				),
				'std'		=> 'accent',
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'fundrize' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => '',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'small',
				'group' => esc_html__( 'Button', 'fundrize' ),
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'accent',
						'dark',
						'light',
						'very-light',
						'white',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'fundrize'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'fundrize'),
				'group' => esc_html__( 'Button', 'fundrize' ),
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'accent',
						'dark',
						'light',
						'very-light',
						'white',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Link Color', 'fundrize'),
				'param_name' => 'link_color',
				'value' => '',
				'group' => esc_html__( 'Button', 'fundrize' ),
				'dependency' => array( 'element' => 'button_style', 'value' => 'simple_link' ),
            ),
	        // Hyperlink
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'fundrize'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Hyperlink', 'fundrize' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'fundrize' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'Hyperlink', 'fundrize' ),
			),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'fundrize'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'fundrize' ),
				'param_name' => 'heading_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'fundrize' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'fundrize'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'fundrize'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'fundrize'),
				'param_name' => 'desc_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Family', 'fundrize' ),
				'param_name' => 'desc_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Weight', 'fundrize' ),
				'param_name' => 'desc_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Font Size', 'fundrize'),
				'param_name' => 'desc_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Line-Height', 'fundrize'),
				'param_name' => 'desc_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Button', 'fundrize'),
				'param_name' => 'btn_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Family', 'fundrize' ),
				'param_name' => 'button_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Weight', 'fundrize' ),
				'param_name' => 'button_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Font Size', 'fundrize'),
				'param_name' => 'button_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Line-Height', 'fundrize'),
				'param_name' => 'button_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'fundrize'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'fundrize'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Separator: Top Margin', 'fundrize'),
				'param_name' => 'sep_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Separator: Bottom Margin', 'fundrize'),
				'param_name' => 'sep_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Top Margin', 'fundrize'),
				'param_name' => 'desc_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Bottom Margin', 'fundrize'),
				'param_name' => 'desc_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	    )
	) );
} );

// Images Grid
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name' => esc_html__( 'Images Grid', 'fundrize' ),
		'description' => esc_html__('Displaying images in masonry or mosaic grid.', 'fundrize'),
		'base' => 'imagesgrid',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Layout', 'fundrize' ),
				'param_name' => 'mode',
				'value'      => array(
					'Masonry' => 'grid',
					'Slider' => 'slider',
				),
				'std'		=> 'grid',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'fundrize' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'600 x 600' => 'square',
					'600 x 500' => 'rectangle',
					'600 x 390' => 'rectangle2',
					'870 x auto' => 'auto1',
					'600 x auto' => 'auto2',
					'480 x auto' => 'auto3',
					'Full' => 'full',
				),
				'std'		=> 'auto2',
				'description'	=> esc_html__('Choose auto option to keep the same aspect ratio when cropping.', 'fundrize'),
			),
			array(
				'type' => 'attach_images',
				'heading' => esc_html__('Images', 'fundrize'),
				'param_name' => 'images',
				'value' => '',
				'description' => esc_html__('Choose multi-images for Gallery.', 'fundrize')
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'fundrize'),
				'param_name' => 'gapv',
				'value' => '30',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing below items', 'fundrize'),
				'param_name' => 'gaph',
				'value' => '30',
				'dependency' => array( 'element' => 'mode', 'value' => 'grid' ),
            ),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'fundrize'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'fundrize' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'fundrize' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '30',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'fundrize'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'fundrize' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			// Column
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap > 1100px.', 'fundrize' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Column Options', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '4c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 800px to 1099px.', 'fundrize' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Column Options', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 550px to 799px.', 'fundrize' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Column Options', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap < 549px.', 'fundrize' ),
				'param_name' => 'column4',
				'group'      => esc_html__( 'Column Options', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
		)
	) );
} );

// List Advanced
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'List Advanced', 'fundrize' ),
        'description' => esc_html__('Displaying Icon lists with custom icon.', 'fundrize'),
		'base'        => 'advlist',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'fundrize' ),
				'param_name' => 'style',
				'value'      => array(
					'Icon Left' => 'icon-left',
					'Icon Right' => 'icon-right',
				),
				'std'		=> 'icon-left',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon to Display', 'fundrize' ),
				'param_name' => 'icon_display',
				'value'      => array(
					'Icon Font' => 'icon-font',
					'Icon Image' => 'icon-image',
				),
				'std'		=> 'icon-font',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'fundrize'),
				'param_name' => 'content_background_color',
				'value' => '#f8f8f8',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'fundrize' ),
				'param_name' => 'content_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
				),
				'std'		=> 'solid',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'fundrize'),
				'param_name' => 'content_border_color',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'fundrize'),
				'param_name' => 'content_border_width',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 1px 2px 2px 1px', 'fundrize'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'fundrize'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 12px 30px 12px 30px', 'fundrize'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'fundrize'),
				'param_name' => 'content_bottom_margin',
				'value' => '10',
	        ),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'fundrize'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Image', 'fundrize' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width', 'fundrize'),
				'param_name' => 'image_width',
				'value' => '',
				'description'	=> esc_html__('Ex: 50px', 'fundrize'),
				'group' => esc_html__( 'Image', 'fundrize' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
	        ),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'fundrize' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'fundrize' ),
				'value' => array(
					esc_html__( '', 'fundrize' ) => '',
					esc_html__( 'Donate Icons', 'fundrize' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'fundrize' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'fundrize' ) => 'openiconic',
					esc_html__( 'Typicons', 'fundrize' ) => 'typicons',
					esc_html__( 'Entypo', 'fundrize' ) => 'entypo',
					esc_html__( 'Linecons', 'fundrize' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'fundrize' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'fundrize'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'fundrize'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Position', 'fundrize' ),
				'param_name' => 'icon_position',
				'value'      => array(
					'Middle' => 'middle',
					'Top' => 'top',
				),
				'std'		=> 'middle',
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
			// Content
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Content', 'fundrize' ),
				'param_name' => 'content',
				'group' => esc_html__( 'Content', 'fundrize' ), 
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Color', 'fundrize'),
				'param_name' => 'content_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Left Padding', 'fundrize'),
				'param_name' => 'content_left_padding',
				'value' => '30',
				'group' => esc_html__( 'Content', 'fundrize' ),
				'description'	=> esc_html__('Spacing between the icon and the content', 'fundrize'),
				'dependency' => array( 'element' => 'style', 'value' => 'icon-left' ),
	        ),
	        // Hyperlink
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Hyperlink on text?', 'fundrize' ),
				'param_name' => 'hyperlink',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
				'group' => esc_html__( 'Hyperlink', 'fundrize' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'fundrize'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Hyperlink', 'fundrize' ),
				'dependency' => array( 'element' => 'hyperlink', 'value' => 'yes' ),
            ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Font Family', 'fundrize' ),
				'param_name' => 'content_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Font Weight', 'fundrize' ),
				'param_name' => 'content_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Font Size', 'fundrize'),
				'param_name' => 'content_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Line-Height', 'fundrize'),
				'param_name' => 'content_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
		)
	) );
} );

// Icon Box
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Icon Box', 'fundrize' ),
        'description' => esc_html__('Displaying Icon Box with custom icon.', 'fundrize'),
		'base'        => 'iconbox',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'fundrize' ),
				'param_name' => 'style',
				'value'      => array(
					'Icon Top' => 'icon-top',
					'Icon Left' => 'icon-left',
					'Icon Right' => 'icon-right',
					'Icon Left 2' => 'icon-left2',
				),
				'std'		=> 'icon-top',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'fundrize' ),
				'param_name' => 'text_align',
				'value'      => array(
					'Left' => 'align-left',
					'Center' => 'align-center',
					'Right' => 'align-right',
				),
				'std'		=> 'align-left',
				'dependency' => array( 'element' => 'style', 'value' => 'icon-top' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon to Display', 'fundrize' ),
				'param_name' => 'icon_display',
				'value'      => array(
					'Icon Font' => 'icon-font',
					'Icon Image' => 'icon-image',
				),
				'std'		=> 'icon-font',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Showcase', 'fundrize' ),
				'param_name' => 'icon_showcase',
				'value'      => array(
					'Simple' => 'simple',
					'Accent Background' => 'accent-bg',
					'Dark Background' => 'dark-bg',
					'Grey Background' => 'grey-bg',
					'Accent Outline' => 'accent-outline',
					'Dark Outline' => 'dark-outline',
					'Grey Outline' => 'grey-outline',
				),
				'std'		=> 'accent-bg',
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Wrap Width', 'fundrize' ),
				'param_name' => 'icon_width',
				'value'      => array(
					'50px' => 'w50',
					'55px' => 'w55',
					'60px' => 'w60',
					'65px' => 'w65',
					'70px' => 'w70',
					'75px' => 'w75',
					'80px' => 'w80',
					'85px' => 'w85',
					'90px' => 'w90',
					'95px' => 'w95',
					'100px' => 'w100',
					'105px' => 'w105',
					'110px' => 'w110',
					'115px' => 'w115',
					'120px' => 'w120',
					'125px' => 'w125',
					'130px' => 'w130',
				),
				'std'		=> 'w60',
				'dependency' => array( 'element' => 'icon_showcase', 'value' => array( 'accent-bg', 'dark-bg', 'grey-bg', 'accent-outline', 'dark-outline', 'grey-outline' ) ),
			),
	        array(
				'type'       => 'dropdown',
				'heading' => esc_html__('Icon Wrap Rounded', 'fundrize'),
				'param_name' => 'icon_rounded',
				'value'      => array(
					'Square' => '',
					'Circle ' => 'rounded-100',
					'1 Pixel' => 'rounded-1',
					'2 Pixels' => 'rounded-2',
					'3 Pixels' => 'rounded-3',
					'5 Pixels' => 'rounded-5',
					'10 Pixels' => 'rounded-10',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'icon_showcase', 'value' => array( 'accent-bg', 'dark-bg', 'grey-bg', 'accent-outline', 'dark-outline', 'grey-outline' ) ),
	        ),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'fundrize' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'fundrize' ),
				'value' => array(
					esc_html__( '', 'fundrize' ) => '',
					esc_html__( 'Donate Icons', 'fundrize' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'fundrize' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'fundrize' ) => 'openiconic',
					esc_html__( 'Typicons', 'fundrize' ) => 'typicons',
					esc_html__( 'Entypo', 'fundrize' ) => 'entypo',
					esc_html__( 'Linecons', 'fundrize' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'fundrize' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'fundrize'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'dependency' => array( 'element' => 'icon_showcase', 'value' => 'simple' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'fundrize'),
				'param_name' => 'icon_font_size',
				'value' => '30px',
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'fundrize'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Image', 'fundrize' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width', 'fundrize'),
				'param_name' => 'image_width',
				'value' => '',
				'description'	=> esc_html__('Ex: 100px', 'fundrize'),
				'group' => esc_html__( 'Image', 'fundrize' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
	        ),
			// Content
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'fundrize' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'fundrize'),
				'param_name' => 'heading',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'fundrize'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
			array(
				'type' => 'textarea',
				'heading' => esc_html__( 'Description', 'fundrize' ),
				'param_name' => 'description',
				'group' => esc_html__( 'Content', 'fundrize' ), 
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Description Color', 'fundrize'),
				'param_name' => 'desc_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
			// Button
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show button?', 'fundrize' ),
				'param_name' => 'show_button',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Style', 'fundrize' ),
				'param_name' => 'button_style',
				'value'      => array(
					'Simple Link' => 'simple_link',
					'Accent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
					'Very Light' => 'very-light',
					'White' => 'white',
					'Outline' => 'outline',
					'Outline Dark' => 'outline_dark',
					'Outline Light' => 'outline_light',
					'Outline Very light' => 'outline_very-light',
					'Outline White' => 'outline_white',
				),
				'std'		=> 'accent',
				'group' => esc_html__( 'Button', 'fundrize' ),
				'dependency' => array( 'element' => 'show_button', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'fundrize' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Default' => '',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> '',
				'group' => esc_html__( 'Button', 'fundrize' ),
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'accent',
						'dark',
						'light',
						'very-light',
						'white',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'fundrize'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'fundrize'),
				'group' => esc_html__( 'Button', 'fundrize' ),
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'accent',
						'dark',
						'light',
						'very-light',
						'white',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Link Color', 'fundrize'),
				'param_name' => 'link_color',
				'value' => '',
				'group' => esc_html__( 'Button', 'fundrize' ),
				'dependency' => array( 'element' => 'button_style', 'value' => 'simple_link' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Text (Required)', 'fundrize'),
				'param_name' => 'button_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'Button', 'fundrize' ),
				'dependency' => array( 'element' => 'show_button', 'value' => 'yes' ),
	        ),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Button Padding', 'fundrize'),
				'param_name' => 'button_padding',
				'value' => '',
				'group' => esc_html__( 'Button', 'fundrize' ),
				'description'	=> esc_html__('Top Right Bottom Left.', 'fundrize'),
				'dependency' => array('element' => 'button_style', 'value' => array('accent','dark','light','very-light','white','outline','outline_dark','outline_light','outline_very-light','outline_white' ) ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link URL (Required):', 'fundrize'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Button', 'fundrize' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'fundrize' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'fundrize'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'fundrize' ),
				'param_name' => 'heading_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'fundrize' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'fundrize'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'fundrize'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'fundrize'),
				'param_name' => 'desc_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Family', 'fundrize' ),
				'param_name' => 'desc_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Weight', 'fundrize' ),
				'param_name' => 'desc_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Font Size', 'fundrize'),
				'param_name' => 'desc_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Line-Height', 'fundrize'),
				'param_name' => 'desc_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Button', 'fundrize'),
				'param_name' => 'button_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Family', 'fundrize' ),
				'param_name' => 'button_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Weight', 'fundrize' ),
				'param_name' => 'button_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Font Size', 'fundrize'),
				'param_name' => 'button_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Line-Height', 'fundrize'),
				'param_name' => 'button_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content: Left Padding', 'fundrize'),
				'param_name' => 'content_left_padding',
				'value' => '85px',
				'group' => esc_html__( 'Spacing', 'fundrize' ), 
				'dependency' => array( 'element' => 'style', 'value' => 'icon-left' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content: Right Padding', 'fundrize'),
				'param_name' => 'content_right_padding',
				'value' => '85px',
				'group' => esc_html__( 'Spacing', 'fundrize' ), 
				'dependency' => array( 'element' => 'style', 'value' => 'icon-right' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Left Margin', 'fundrize'),
				'param_name' => 'heading_left_margin',
				'value' => '85px',
				'group' => esc_html__( 'Spacing', 'fundrize' ), 
				'dependency' => array( 'element' => 'style', 'value' => 'icon-left2' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'fundrize'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'fundrize'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Top Margin', 'fundrize'),
				'param_name' => 'desc_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Bottom Margin', 'fundrize'),
				'param_name' => 'desc_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
		)
	) );
} );

// PriceTable
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Price Table', 'fundrize' ),
        'description' => esc_html__('Displaying Price Tables.', 'fundrize'),
		'base'        => 'pricetable',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Wrap Style', 'fundrize' ),
				'param_name' => 'content_style',
				'value'      => array(
					'Has Shadow' => 'shadow',
					'Has Border' => 'border',
				),
				'std'		=> 'border',
			),
			// Heading
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'fundrize'),
				'param_name' => 'heading',
				'value' => 'STARTER',
				'group' => esc_html__( 'Heading', 'fundrize' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'fundrize'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Heading', 'fundrize' ),
            ),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading: Background', 'fundrize'),
				'param_name' => 'heading_background',
				'value' => '#f6f6f6',
				'group' => esc_html__( 'Heading', 'fundrize' ),
            ),
			// Price
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Price', 'fundrize'),
				'param_name' => 'price',
				'value' => '$19',
				'description'	=> esc_html__('The price for this package.', 'fundrize'),
				'group' => esc_html__( 'Price', 'fundrize' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Price Color', 'fundrize'),
				'param_name' => 'price_color',
				'value' => '',
				'group' => esc_html__( 'Price', 'fundrize' ),
            ),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Price Unit', 'fundrize' ),
				'param_name' => 'price_unit',
				'value' => 'PER MONTH',
				'description'	=> esc_html__('The price unit for this package.', 'fundrize'),
				'group' => esc_html__( 'Price', 'fundrize' ), 
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Price Unit Color', 'fundrize'),
				'param_name' => 'unit_color',
				'value' => '',
				'group' => esc_html__( 'Price', 'fundrize' ),
            ),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Price Wrap: Background', 'fundrize'),
				'param_name' => 'price_background',
				'value' => '#363636',
				'group' => esc_html__( 'Price', 'fundrize' ),
            ),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Price Wrap: Padding', 'fundrize' ),
				'param_name' => 'price_padding',
				'value' => '78px 0 52px 0',
				'description'	=> esc_html__('Top Right Bottom Left.', 'fundrize'),
				'group' => esc_html__( 'Price', 'fundrize' ),
			),
	        // Content
			array(
				'type' 		=> 'textarea_html',
				'heading' 	=> esc_html__('Content', 'fundrize'),
				'param_name' 	=> 'content',
				'description'	=> esc_html__('Create the features list using un-ordered list elements.', 'fundrize'),
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Wrap: Background', 'fundrize'),
				'param_name' => 'content_background',
				'value' => '#ffffff',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Color', 'fundrize'),
				'param_name' => 'content_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Content Wrap: Padding', 'fundrize' ),
				'param_name' => 'content_padding',
				'value' => '33px 42px 42px 46px',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 30px 0px 30px 0px', 'fundrize'),
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			// Button
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Style', 'fundrize' ),
				'param_name' => 'button_style',
				'value'      => array(
					'Accent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
					'Very Light' => 'very-light',
					'White' => 'white',
					'Outline' => 'outline',
					'Outline Dark' => 'outline_dark',
					'Outline Light' => 'outline_light',
					'Outline Very light' => 'outline_very-light',
					'Outline White' => 'outline_white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'fundrize' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => '',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> '',
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'fundrize'),
				'param_name' => 'btn_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 10px', 'fundrize'),
				'group' => esc_html__( 'Button', 'fundrize' ),
            ),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Button: Padding', 'fundrize' ),
				'param_name' => 'btn_padding',
				'description'	=> esc_html__('Top Right Bottom Left.', 'fundrize'),
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Button: Margin', 'fundrize' ),
				'param_name' => 'btn_margin',
				'value' => '37px 0px 0px 0px',
				'description'	=> esc_html__('Top Right Bottom Left.', 'fundrize'),
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Text', 'fundrize'),
				'param_name' => 'button_text',
				'value' => 'CHOOSE PLAN',
				'group' => esc_html__( 'Button', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Link (URL)', 'fundrize'),
				'param_name' => 'button_url',
				'value' => '',
				'group' => esc_html__( 'Button', 'fundrize' ),
	        ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'fundrize'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'fundrize' ),
				'param_name' => 'heading_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'fundrize' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'fundrize'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'fundrize'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Price', 'fundrize'),
				'param_name' => 'price_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Price Font Family', 'fundrize' ),
				'param_name' => 'price_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Price Font Weight', 'fundrize' ),
				'param_name' => 'price_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Price Font Size', 'fundrize'),
				'param_name' => 'price_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Price Line-Height', 'fundrize'),
				'param_name' => 'price_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Unit', 'fundrize'),
				'param_name' => 'unit_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Unit Font Family', 'fundrize' ),
				'param_name' => 'unit_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Unit Font Weight', 'fundrize' ),
				'param_name' => 'unit_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Unit Font Size', 'fundrize'),
				'param_name' => 'unit_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Unit Line-Height', 'fundrize'),
				'param_name' => 'unit_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
		)
	) );
} );

// Content Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_contentbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Content Box', 'fundrize'),
		'description' => esc_html__('Content Box.', 'fundrize'),
		'base' => 'contentbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'contentbox'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'js_view' => 'VcColumnView',
		'params' => array(
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'fundrize'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'fundrize'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'fundrize'),
				'param_name' => 'border_color',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'fundrize'),
				'param_name' => 'border_width',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 1px 1px 1px 1px', 'fundrize'),
	        ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Hide Border on Moblie?', 'fundrize' ),
				'param_name' => 'hide_boder',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'fundrize'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 6px', 'fundrize'),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Hide This Box on Moblie?', 'fundrize' ),
				'param_name' => 'hide_on_mobile',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
            // Background
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'fundrize'),
				'param_name' => 'background_color',
				'value' => '',
				'group' => esc_html__( 'Background', 'fundrize' ),
            ),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Background Image', 'fundrize'),
				'param_name' => 'bg_image',
				'value' => '',
				'group' => esc_html__( 'Background', 'fundrize' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Position', 'fundrize' ),
				'param_name'  => 'bg_position',
				'value'       => array(
					'Left Top' => 'lt',
					'Right Top' => 'rt',
					'Center Top' => 'ct',
					'Center Center' => 'cc',
					'Center Bottom'   => 'cb',
					'Left Bottom' => 'lb',
					'Right Bottom'   => 'rb',
				),
				'std'		=> 'lt',
				'group' => esc_html__( 'Background', 'fundrize' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Repeat', 'fundrize' ),
				'param_name'  => 'bg_repeat',
				'value'       => array(
					'No Repeat' => 'no-repeat',
					'Repeat'   => 'repeat',
					'Repeat X'   => 'repeat-x',
					'Repeat Y'   => 'repeat-y',
				),
				'std'		=> 'no-repeat',
				'group' => esc_html__( 'Background', 'fundrize' ),
			),
            // Margin
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'fundrize'),
				'param_name' => 'margin',
				'value' => '',
				'group' => esc_html__( 'Margins', 'fundrize' ),
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'fundrize'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin on mobile', 'fundrize'),
				'param_name' => 'mobile_margin',
				'value' => '',
				'group' => esc_html__( 'Margins', 'fundrize' ), 
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'fundrize'),
	        ),
			// Box Shadow
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Horizontal (Required)', 'fundrize'),
				'param_name' => 'horizontal',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'fundrize' ),
				'description'	=> esc_html__('Ex: 0px', 'fundrize'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Vertical (Required)', 'fundrize'),
				'param_name' => 'vertical',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'fundrize' ),
				'description'	=> esc_html__('Ex: 5px', 'fundrize'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Blur (Required)', 'fundrize'),
				'param_name' => 'blur',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'fundrize' ),
				'description'	=> esc_html__('Ex: 30px', 'fundrize'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spread (Required)', 'fundrize'),
				'param_name' => 'spread',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'fundrize' ),
				'description'	=> esc_html__('Ex: 0px', 'fundrize'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Box Shadow Color (Required)', 'fundrize'),
				'param_name' => 'shadow_color',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'fundrize' ),
				'description'	=> esc_html__('Ex: #eeeeee', 'fundrize'),
            ),
        )
    ) );
} );

// Headings
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Headings', 'fundrize' ),
        'description' => esc_html__('Displaying awesome heading styles.', 'fundrize'),
		'base'        => 'headings',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'fundrize' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading Text', 'fundrize' ),
				'param_name' => 'heading',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'fundrize'),
				'param_name' => 'heading_color',
				'value' => '',
            ),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Sub-Heading (Optional)', 'fundrize' ),
				'param_name' => 'subheading',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Sub-Heading Color', 'fundrize'),
				'param_name' => 'subheading_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading Max-Width', 'fundrize'),
				'param_name' => 'subheading_width',
				'value' => '',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Separator', 'fundrize' ),
				'param_name' => 'separator',
				'value'      => array(
					'No Separator' => '',
					'Line' => 'line',
					'Image' => 'image',
				),
				'std'		=> '',
				'group' => esc_html__( 'Separator', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Separator Position', 'fundrize' ),
				'param_name' => 'sep_position',
				'value'      => array(
					'Top' => 'top',
					'Between Heading & Sub-Heading' => 'between',
					'Bottom' => 'bottom',
					'Left' => 'left',
				),
				'std'		=> 'between',
				'group' => esc_html__( 'Separator', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => array( 'line', 'image' ) ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Width', 'fundrize'),
				'param_name' => 'line_width',
				'value' => '50',
				'group' => esc_html__( 'Separator', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'fundrize'),
				'param_name' => 'line_height',
				'value' => '2',
				'group' => esc_html__( 'Separator', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Right Margin', 'fundrize'),
				'param_name' => 'line_right_margin',
				'value' => '20',
				'group' => esc_html__( 'Separator', 'fundrize' ),
				'dependency' => array( 'element' => 'sep_position', 'value' => 'left' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line Color', 'fundrize'),
				'param_name' => 'line_color',
				'value' => '',
				'group' => esc_html__( 'Separator', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'fundrize'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Separator', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'image' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width (Optional)', 'fundrize'),
				'param_name' => 'image_width',
				'value' => '',
				'group' => esc_html__( 'Separator', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'image' ),
	        ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'fundrize'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'fundrize' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h2',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Family', 'fundrize' ),
				'param_name' => 'heading_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Weight', 'fundrize' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size', 'fundrize'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size on Mobile', 'fundrize'),
				'param_name' => 'heading_font_size_mobile',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Line Height', 'fundrize'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Sub-Heading', 'fundrize'),
				'param_name' => 'subheading_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Family', 'fundrize' ),
				'param_name' => 'subheading_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Weight', 'fundrize' ),
				'param_name' => 'subheading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Font Size', 'fundrize'),
				'param_name' => 'subheading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Line Height', 'fundrize'),
				'param_name' => 'subheading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Style', 'fundrize' ),
				'param_name' => 'subheading_font_style',
				'value'      => array(
					'Normal' => 'normal',
					'Italic' => 'italic',
				),
				'std'		=> 'normal',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'fundrize'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'fundrize'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Top Margin', 'fundrize'),
				'param_name' => 'subheading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Bottom Margin', 'fundrize'),
				'param_name' => 'subheading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
		)
	) );
} );

// Feature Box
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Feature Box', 'fundrize' ),
        'description' => esc_html__('Displaying a feature content box.', 'fundrize'),
		'base'        => 'featurebox',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'params'      => array(
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Wrap Background', 'fundrize'),
				'param_name' => 'wrap_background',
				'value' => '#f8f8f8',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap Padding', 'fundrize'),
				'param_name' => 'wrap_padding',
				'value' => '30px',
				'description'	=> esc_html__('Top Right Bottom Left.', 'fundrize'),
            ),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'fundrize'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Image', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'fundrize' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'600 x 500' => 'rectangle',
					'600 x 390' => 'rectangle2',
					'870 x auto' => 'auto1',
					'600 x auto' => 'auto2',
					'480 x auto' => 'auto3',
				),
				'std'		=> 'rectangle2',
				'group' => esc_html__( 'Image', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width', 'fundrize'),
				'param_name' => 'image_width',
				'value' => '',
				'description'	=> esc_html__('Ex: 200px.', 'fundrize'),
				'group' => esc_html__( 'Image', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image: Right Margin', 'fundrize'),
				'param_name' => 'image_right_margin',
				'value' => '30px',
				'group' => esc_html__( 'Image', 'fundrize' ),
	        ),
	        // Content
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'fundrize'),
				'param_name' => 'heading_content',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'fundrize' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading Text', 'fundrize' ),
				'param_name' => 'heading',
				'std'		=> 'Heading Text',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'fundrize'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Separator', 'fundrize'),
				'param_name' => 'separator_content',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Separator', 'fundrize' ),
				'param_name' => 'separator',
				'value'      => array(
					'No Separator' => '',
					'Line' => 'line'
				),
				'std'		=> '',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Line: Full-width', 'fundrize' ),
				'param_name' => 'line_full',
				'value'      => array(
					'No' => 'no',
					'Yes' => 'yes',
				),
				'std'		=> 'no',
				'group' => esc_html__( 'Content', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Width', 'fundrize'),
				'param_name' => 'line_width',
				'value' => '50',
				'group' => esc_html__( 'Content', 'fundrize' ),
				'dependency' => array( 'element' => 'line_full', 'value' => 'no' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'fundrize'),
				'param_name' => 'line_height',
				'value' => '2',
				'group' => esc_html__( 'Content', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line Color', 'fundrize'),
				'param_name' => 'line_color',
				'value' => '#ffb500',
				'group' => esc_html__( 'Content', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'fundrize'),
				'param_name' => 'content_content',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
			array(
				'type' => 'textarea_html',
				'holder' => 'div',
				'param_name' => 'content',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Color', 'fundrize'),
				'param_name' => 'content_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'fundrize' ),
            ),
	        // Button
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Text', 'fundrize'),
				'param_name' => 'button_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'Button', 'fundrize' ),
				'description'	=> esc_html__('Leave it empty to disable.', 'fundrize'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Style', 'fundrize' ),
				'param_name' => 'button_style',
				'value'      => array(
					'Simple Link' => 'simple_link',
					'Accent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
					'Very Light' => 'very-light',
					'White' => 'white',
					'Outline' => 'outline',
					'Outline Dark' => 'outline_dark',
					'Outline Light' => 'outline_light',
					'Outline Very light' => 'outline_very-light',
					'Outline White' => 'outline_white',
				),
				'std'		=> 'accent',
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Link Style', 'fundrize' ),
				'param_name' => 'link_style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
					'Style 4' => 'style-4',
				),
				'std'		=> 'style-1',
				'group' => esc_html__( 'Button', 'fundrize' ),
				'dependency' => array( 'element' => 'button_style', 'value' => 'simple_link' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'fundrize' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => '',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'small',
				'group' => esc_html__( 'Button', 'fundrize' ),
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'accent',
						'dark',
						'light',
						'very-light',
						'white',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'fundrize'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 10px', 'fundrize'),
				'group' => esc_html__( 'Button', 'fundrize' ),
				'dependency' => array(
					'element' => 'button_style',
					'value' => array (
						'accent',
						'dark',
						'light',
						'very-light',
						'white',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button (URL):', 'fundrize'),
				'param_name' => 'button_url',
				'value' => '',
				'group' => esc_html__( 'Button', 'fundrize' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'fundrize' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Button Icon?', 'fundrize' ),
				'param_name' => 'show_icon',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'fundrize' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'fundrize' ),
				'value' => array(
					esc_html__( '', 'fundrize' ) => '',
					esc_html__( 'Donate Icons', 'fundrize' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'fundrize' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'fundrize' ) => 'openiconic',
					esc_html__( 'Typicons', 'fundrize' ) => 'typicons',
					esc_html__( 'Entypo', 'fundrize' ) => 'entypo',
					esc_html__( 'Linecons', 'fundrize' ) => 'linecons',
				),
				'group' => esc_html__( 'Button', 'fundrize' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'fundrize' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Button', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Button', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'fundrize'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Button', 'fundrize' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Left Padding', 'fundrize'),
				'param_name' => 'icon_left_padding',
				'value' => '',
				'group' => esc_html__( 'Button', 'fundrize' ),
				'description'	=> esc_html__('Spacing between the icon and the link.', 'fundrize'),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
	        ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'fundrize'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Family', 'fundrize' ),
				'param_name' => 'heading_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Weight', 'fundrize' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size', 'fundrize'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Line Height', 'fundrize'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'fundrize'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'fundrize'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Separator: Top Margin', 'fundrize'),
				'param_name' => 'sep_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Separator: Bottom Margin', 'fundrize'),
				'param_name' => 'sep_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button: Top Margin', 'fundrize'),
				'param_name' => 'button_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button: Bottom Margin', 'fundrize'),
				'param_name' => 'button_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
		)
	) );
} );

// Animation Block
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_animationblock extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Animation Block', 'fundrize'),
		'description' => esc_html__('Apply animations anywhere.', 'fundrize'),
		'base' => 'animationblock',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'animationblock'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'fundrize' ),
				'param_name' => 'animation',
				'value'      =>  fundrize_animation(),
				'std'		 => 'fadeInLeft'
			),
			array(
				'type' => 'number',
				'heading' => esc_html__('Animation Duration', 'fundrize'),
				'param_name' => 'duration',
				'value' => 1,
				'suffix' => 's'
		  	),
	        array(
				'type' => 'number',
				'heading' => esc_html__('Animation Delay', 'fundrize'),
				'param_name' => 'delay',
				'value' => 0.6,
				'suffix' => 's'
	        ),
	        array(
				'type' => 'number',
				'heading' => esc_html__('Viewport Position', 'fundrize'),
				'param_name' => 'position',
				'value' => 90,
				'suffix' => '%'
	        ),
         )
    ) );
} );

// Counter
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Counter', 'fundrize' ),
        'description' => esc_html__('Displaying a running counter.', 'fundrize'),
		'base'        => 'counter',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Order', 'fundrize' ),
				'param_name' => 'style',
				'value'      => array(
					'No Icon' => 'no-icon',
					'Icon Top' => 'icon-top',
					'Icon Left' => 'icon-left',
				),
				'std'		=> '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Order', 'fundrize' ),
				'param_name' => 'order',
				'value'      => array(
					'Number & Heading' => 'nh',
					'Heading & Number' => 'hn',
				),
				'std'		=> 'nh',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'fundrize' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
				'dependency' => array( 'element' => 'style', 'value' => array('no-icon','icon-top')  ),
			),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'fundrize' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'fundrize' ),
				'value' => array(
					esc_html__( '', 'fundrize' ) => '',
					esc_html__( 'Donate Icons', 'fundrize' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'fundrize' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'fundrize' ) => 'openiconic',
					esc_html__( 'Typicons', 'fundrize' ) => 'typicons',
					esc_html__( 'Entypo', 'fundrize' ) => 'entypo',
					esc_html__( 'Linecons', 'fundrize' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'dependency' => array( 'element' => 'style', 'value' => array('icon-top','icon-left')  ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'fundrize' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'fundrize'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'dependency' => array( 'element' => 'style', 'value' => array('icon-top','icon-left')  ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'fundrize'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'dependency' => array( 'element' => 'style', 'value' => array('icon-top','icon-left')  ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Right Margin', 'fundrize'),
				'param_name' => 'icon_right_margin',
				'value' => '',
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'description'	=> esc_html__('Spacing between the icon and the heading.', 'fundrize'),
				'dependency' => array( 'element' => 'style', 'value' => array('icon-left')  ),
	        ),
			// Number
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Number', 'fundrize' ),
				'param_name' => 'number',
				'group' => esc_html__( 'Number', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Number Color', 'fundrize'),
				'param_name' => 'number_color',
				'value' => '',
				'group' => esc_html__( 'Number', 'fundrize' ),
            ),
			array(
				'type' => 'number',
				'heading' => esc_html__('Rolling Time', 'fundrize'),
				'param_name' => 'time',
				'value' => 5000,
				'suffix' => 'ms',
				'group' => esc_html__( 'Number', 'fundrize' ),
		  	),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Prefix (Optional)', 'fundrize' ),
				'param_name' => 'number_prefix',
				'group' => esc_html__( 'Number', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Prefix Color', 'fundrize'),
				'param_name' => 'prefix_color',
				'value' => '',
				'group' => esc_html__( 'Number', 'fundrize' ),
            ),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Suffix (Optional)', 'fundrize' ),
				'param_name' => 'number_suffix',
				'group' => esc_html__( 'Number', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Suffix Color', 'fundrize'),
				'param_name' => 'suffix_color',
				'value' => '',
				'group' => esc_html__( 'Number', 'fundrize' ),
            ),
		  	// Heading
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'fundrize' ),
				'param_name' => 'heading_tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
					'div' => 'div',
				),
				'std'		=> 'div',
				'group' => esc_html__( 'Heading', 'fundrize' ),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading', 'fundrize' ),
				'param_name' => 'heading',
				'group' => esc_html__( 'Heading', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'fundrize'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Heading', 'fundrize' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Separator', 'fundrize' ),
				'param_name' => 'separator',
				'value'      => array(
					'No Separator' => '',
					'Line' => 'line',
					'Image' => 'image',
				),
				'std'		=> '',
				'group' => esc_html__( 'Separator', 'fundrize' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Width', 'fundrize'),
				'param_name' => 'line_width',
				'value' => '50',
				'group' => esc_html__( 'Separator', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'fundrize'),
				'param_name' => 'line_height',
				'value' => '2',
				'group' => esc_html__( 'Separator', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line Color', 'fundrize'),
				'param_name' => 'line_color',
				'value' => '',
				'group' => esc_html__( 'Separator', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'fundrize'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Separator', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'image' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width (Optional)', 'fundrize'),
				'param_name' => 'image_width',
				'value' => '',
				'group' => esc_html__( 'Separator', 'fundrize' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'image' ),
	        ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Number Settings', 'fundrize'),
				'param_name' => 'number_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
				'class' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Number: Font Family', 'fundrize' ),
				'param_name' => 'number_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Number: Font Weight', 'fundrize' ),
				'param_name' => 'number_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Font Size', 'fundrize'),
				'param_name' => 'number_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Line Height', 'fundrize'),
				'param_name' => 'number_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading Settings', 'fundrize'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
				'class' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Family', 'fundrize' ),
				'param_name' => 'heading_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Weight', 'fundrize' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size', 'fundrize'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Line Height', 'fundrize'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Prefix Settings', 'fundrize'),
				'param_name' => 'prefix_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
				'class' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Prefix: Font Family', 'fundrize' ),
				'param_name' => 'prefix_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Prefix: Font Weight', 'fundrize' ),
				'param_name' => 'prefix_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Prefix: Font Size', 'fundrize'),
				'param_name' => 'prefix_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Prefix: Line Height', 'fundrize'),
				'param_name' => 'prefix_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Suffix Settings', 'fundrize'),
				'param_name' => 'suffix_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
				'class' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Suffix: Font Family', 'fundrize' ),
				'param_name' => 'suffix_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Suffix: Font Weight', 'fundrize' ),
				'param_name' => 'suffix_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Suffix: Font Size', 'fundrize'),
				'param_name' => 'suffix_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Suffix: Line Height', 'fundrize'),
				'param_name' => 'suffix_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Top Margin', 'fundrize'),
				'param_name' => 'number_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Bottom Margin', 'fundrize'),
				'param_name' => 'number_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'fundrize'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'fundrize'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
		)
	) );
} );

// Image Advanced
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Image Advanced', 'fundrize' ),
        'description' => esc_html__('Displaying a image with awesome options.', 'fundrize'),
		'base'        => 'advimage',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'fundrize' ),
				'param_name' => 'style',
				'value'      => array(
					'Video Poppup' => 'style-1',
					'Text Hyperlink' => 'style-2',
				),
				'std'		=> 'style-1',
			),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'fundrize'),
				'param_name' => 'image',
				'value' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'fundrize' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'600 x 500' => 'rectangle',
					'600 x 390' => 'rectangle2',
				),
				'std'		=> 'full',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Link Youtube/Vimeo (URL)', 'fundrize'),
				'param_name' => 'video_url',
				'value' => '',
				'dependency' => array( 'element' => 'style', 'value' => 'style-1' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Size', 'fundrize' ),
				'param_name' => 'icon_size',
				'value'      => array(
					'50px' => 'w50',
					'60px' => 'w60',
					'70px' => 'w70',
					'80px' => 'w80',
					'90px' => 'w90',
					'100px' => 'w100',
				),
				'std'		=> 'w50',
				'dependency' => array( 'element' => 'style', 'value' => 'style-1' ),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Heading', 'fundrize' ),
				'param_name' => 'heading',
				'value' => 'Heading Text',
				'dependency' => array( 'element' => 'style', 'value' => 'style-2' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading: Color', 'fundrize'),
				'param_name' => 'heading_color',
				'value' => '#ffffff',
				'dependency' => array( 'element' => 'style', 'value' => 'style-2' ),
            ),
	        // Hyperlink
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'fundrize'),
				'param_name' => 'link_url',
				'value' => '',
				'dependency' => array( 'element' => 'style', 'value' => 'style-2' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'fundrize' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'dependency' => array( 'element' => 'style', 'value' => 'style-2' ),
			),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'fundrize'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'fundrize' ),
				'dependency' => array( 'element' => 'style', 'value' => 'style-2' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'fundrize' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Typography', 'fundrize' ),
				'dependency' => array( 'element' => 'style', 'value' => 'style-2' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Family', 'fundrize' ),
				'param_name' => 'heading_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
				'dependency' => array( 'element' => 'style', 'value' => 'style-2' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Weight', 'fundrize' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
				'dependency' => array( 'element' => 'style', 'value' => 'style-2' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size', 'fundrize'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
				'dependency' => array( 'element' => 'style', 'value' => 'style-2' ),
	        ),
		)
	) );
} );

// Icons
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Icons', 'fundrize' ),
        'description' => esc_html__('Displaying Icon lists with custom icon.', 'fundrize'),
		'base'        => 'icons',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'fundrize' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'left',
					'Center' => 'center',
					'Right' => 'right',
				),
				'std'		=> 'left',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'fundrize' ),
				'param_name' => 'style',
				'value'      => array(
					'Simple or Ouline' => 'outline',
					'Background' => 'background',
				),
				'std'		=> 'outline',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Width', 'fundrize'),
				'param_name' => 'width',
				'value' => '60',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Height', 'fundrize'),
				'param_name' => 'height',
				'value' => '60',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'fundrize'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'fundrize'),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'fundrize'),
				'param_name' => 'background_color',
				'value' => '',
				'dependency' => array( 'element' => 'style', 'value' => 'background' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'fundrize'),
				'param_name' => 'border_color',
				'value' => '',
				'dependency' => array( 'element' => 'style', 'value' => 'outline' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'fundrize'),
				'param_name' => 'border_width',
				'value' => '2px',
				'dependency' => array( 'element' => 'style', 'value' => 'outline' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'fundrize' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
					'Double' => 'double',
				),
				'std'		=> 'solid',
				'dependency' => array( 'element' => 'style', 'value' => 'outline' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'fundrize'),
				'param_name' => 'margin',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'fundrize'),
	        ),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Enable Pulse Effect Infinity?', 'fundrize' ),
				'param_name' => 'icon_effect',
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'no',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'fundrize' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'fundrize' ),
				'value' => array(
					esc_html__( '', 'fundrize' ) => '',
					esc_html__( 'Donate Icons', 'fundrize' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'fundrize' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'fundrize' ) => 'openiconic',
					esc_html__( 'Typicons', 'fundrize' ) => 'typicons',
					esc_html__( 'Entypo', 'fundrize' ) => 'entypo',
					esc_html__( 'Linecons', 'fundrize' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'fundrize' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon: Color', 'fundrize'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'fundrize' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Font Size', 'fundrize'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'fundrize' ),
	        ),
	        // Hyperlink
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Hyperlink Style', 'fundrize' ),
				'param_name' => 'hyperlink',
				'value'      => array(
					'Simple Link' => 'simple',
					'Video Link' => 'video',
				),
				'std'		=> 'simple',
				'group' => esc_html__( 'Hyperlink', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Link Youtube/Vimeo (URL)', 'fundrize'),
				'param_name' => 'video_url',
				'value' => '',
				'group' => esc_html__( 'Hyperlink', 'fundrize' ),
				'dependency' => array( 'element' => 'hyperlink', 'value' => 'video' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'fundrize'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Hyperlink', 'fundrize' ),
				'dependency' => array( 'element' => 'hyperlink', 'value' => 'simple' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'fundrize' ),
				'param_name' => 'new_tab',
				'group' => esc_html__( 'Hyperlink', 'fundrize' ),
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'dependency' => array( 'element' => 'hyperlink', 'value' => 'simple' ),
			),
		)
	) );
} );

// Lines
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Lines', 'fundrize'),
        'description' => esc_html__('Displaying Lines with custom width and height.', 'fundrize'),
        'base' => 'lines',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'fundrize' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'left',
					'Center' => 'center',
					'Right' => 'right',
				),
				'std'		=> 'left',
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Line 1:', 'fundrize'),
				'param_name' => 'line1_heading',
				'class' => '',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line 1: Width', 'fundrize'),
				'param_name' => 'line1_width',
				'value' => '70',
				'dependency' => array( 'element' => 'line_1_full', 'value' => 'no' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line 1: Height', 'fundrize'),
				'param_name' => 'line1_height',
				'value' => '2',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line 1: Color', 'fundrize'),
				'param_name' => 'line1_color',
				'value' => '',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Line 1: Full-width', 'fundrize' ),
				'param_name' => 'line_1_full',
				'value'      => array(
					'No' => 'no',
					'Yes' => 'yes',
				),
				'std'		=> 'no',
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Line 2:', 'fundrize'),
				'param_name' => 'line2_heading',
				'class' => '',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line 2: Width', 'fundrize'),
				'param_name' => 'line2_width',
				'value' => '170',
				'dependency' => array( 'element' => 'line_2_full', 'value' => 'no' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line 2: Height', 'fundrize'),
				'param_name' => 'line2_height',
				'value' => '2',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line 2: Color', 'fundrize'),
				'param_name' => 'line2_color',
				'value' => '',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Line 2: Full-width', 'fundrize' ),
				'param_name' => 'line_2_full',
				'value'      => array(
					'No' => 'no',
					'Yes' => 'yes',
				),
				'std'		=> 'no',
			),
	        // Spacing
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Top Margin', 'fundrize'),
				'param_name' => 'top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
				'description' => esc_html__( 'Ex: 20px', 'fundrize' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'fundrize'),
				'param_name' => 'bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
				'description' => esc_html__( 'Ex: 20px', 'fundrize' ),
            ),
        )
    ) );
} );

// Divider
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Divider', 'fundrize'),
        'description' => esc_html__('Displaying lines separator.', 'fundrize'),
        'base' => 'divider',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'fundrize' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'left',
					'Center' => 'center',
					'Right' => 'right',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'icon_display', 'value' => 'no-icon' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Line Style', 'fundrize' ),
				'param_name' => 'style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
					'Double' => 'double',
				),
				'std'		=> 'solid',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Width (Optional)', 'fundrize'),
				'param_name' => 'width',
				'value' => '',
				'description' => esc_html__( 'Leave it empty to set full-width.', 'fundrize' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Height', 'fundrize'),
				'param_name' => 'height',
				'value' => '',
				'description'	=> esc_html__('Default: 1px', 'fundrize'),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line: Color', 'fundrize'),
				'param_name' => 'color',
				'value' => '',
            ),
			// Icon
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon to Display', 'fundrize' ),
				'param_name' => 'icon_display',
				'value'      => array(
					'No Icon' => 'no-icon',
					'Icon Font' => 'icon-font',
					'Icon Image' => 'icon-image',
				),
				'std'		=> 'no-icon',
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'fundrize' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'fundrize' ),
				'value' => array(
					esc_html__( '', 'fundrize' ) => '',
					esc_html__( 'Donate Icons', 'fundrize' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'fundrize' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'fundrize' ) => 'openiconic',
					esc_html__( 'Typicons', 'fundrize' ) => 'typicons',
					esc_html__( 'Entypo', 'fundrize' ) => 'entypo',
					esc_html__( 'Linecons', 'fundrize' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'fundrize' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon: Color', 'fundrize'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Font Size', 'fundrize'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Icon Image', 'fundrize'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Image: Width', 'fundrize'),
				'param_name' => 'image_width',
				'value' => '',
				'description'	=> esc_html__('Ex: 50px', 'fundrize'),
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Padding', 'fundrize'),
				'param_name' => 'icon_padding',
				'value' => '',
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'description'	=> esc_html__('Top Right Bottom Left. Default: 0px 12px 0px 12px', 'fundrize'),
				'dependency' => array( 'element' => 'icon_display', 'value' => array( 'icon-font', 'icon-image' ) ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Top Margin', 'fundrize'),
				'param_name' => 'top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Bottom Margin', 'fundrize'),
				'param_name' => 'bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'fundrize' ),
	        ),
        )
    ) );
} );

// Alignment Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_alignbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Alignment Box', 'fundrize' ),
        'description' => esc_html__('Align elements.', 'fundrize'),
		'base'        => 'alignbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'alignbox'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'fundrize' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
			),
		)
	) );
} );

// Buttons
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Buttons', 'fundrize'),
        'description' => esc_html__('Advanced Buttons.', 'fundrize'),
        'base' => 'buttons',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
        'params' => array(
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Text', 'fundrize'),
				'param_name' => 'text',
				'value' => 'Button Text',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'fundrize' ),
				'param_name' => 'style',
				'value'      => array(
					'Accent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
					'Very Light' => 'very-light',
					'White' => 'white',
					'Outline' => 'outline',
					'Outline Dark' => 'outline_dark',
					'Outline Light' => 'outline_light',
					'Outline Very light' => 'outline_very-light',
					'Outline White' => 'outline_white',
					'Design your own' => 'custom',
				),
				'std'		=> 'accent',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Size', 'fundrize' ),
				'param_name' => 'size',
				'value'      => array(
					'Default' => '',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> '',
				'dependency' => array(
					'element' => 'style',
					'value' => array (
						'accent',
						'dark',
						'light',
						'very-light',
						'white',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'fundrize'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 13px 40px 13px 40px', 'fundrize'),
				'dependency' => array( 'element' => 'style', 'value' => 'custom' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'fundrize'),
				'param_name' => 'background_color',
				'value' => '',
				'dependency' => array( 'element' => 'style', 'value' => 'custom' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'fundrize'),
				'param_name' => 'border_color',
				'value' => '',
				'dependency' => array( 'element' => 'style', 'value' => 'custom' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'fundrize'),
				'param_name' => 'text_color',
				'value' => '',
				'dependency' => array( 'element' => 'style', 'value' => 'custom' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'fundrize'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'fundrize'),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'fundrize'),
				'param_name' => 'border_width',
				'value' => '',
				'description'	=> esc_html__('Default: 2px', 'fundrize'),
				'dependency' => array(
					'element' => 'style',
					'value' => array (
						'custom',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'fundrize' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
					'Double' => 'double',
				),
				'std'		=> 'solid',
				'dependency' => array(
					'element' => 'style',
					'value' => array (
						'custom',
						'outline',
						'outline_dark',
						'outline_light',
						'outline_very-light',
						'outline_white'
					)
				),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'fundrize'),
				'param_name' => 'margin',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'fundrize'),
	        ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Full-width Button?', 'fundrize' ),
				'param_name' => 'full_width',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'fundrize' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'fundrize' ),
				'value' => array(
					esc_html__( '', 'fundrize' ) => '',
					esc_html__( 'Donate Icons', 'fundrize' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'fundrize' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'fundrize' ) => 'openiconic',
					esc_html__( 'Typicons', 'fundrize' ) => 'typicons',
					esc_html__( 'Entypo', 'fundrize' ) => 'entypo',
					esc_html__( 'Linecons', 'fundrize' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'fundrize' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'fundrize' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'fundrize'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'dependency' => array( 'element' => 'style', 'value' => 'custom' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'fundrize'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'fundrize' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Position', 'fundrize' ),
				'param_name' => 'icon_position',
				'value'      => array(
					'Icon Left' => 'icon-left',
					'Icon Right' => 'icon-right',
				),
				'std'		=> 'icon-right',
				'group' => esc_html__( 'Icon', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Right Padding', 'fundrize'),
				'param_name' => 'icon_right_padding',
				'value' => '',
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'description'	=> esc_html__('Spacing between the icon and the text. Ex: 40px.', 'fundrize'),
				'dependency' => array( 'element' => 'icon_position', 'value' => 'icon-left' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Left Padding', 'fundrize'),
				'param_name' => 'icon_left_padding',
				'value' => '',
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'description'	=> esc_html__('Spacing between the icon and the text. Ex: 40px.', 'fundrize'),
				'dependency' => array( 'element' => 'icon_position', 'value' => 'icon-right' ),
	        ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable separate line?', 'fundrize' ),
				'param_name' => 'separate',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
				'group' => esc_html__( 'Icon', 'fundrize' ),
				'dependency' => array(
					'element' => 'style',
					'value' => array (
						'accent',
						'dark',
					)
				),
			),
	        // Hyperlink
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'fundrize'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Hyperlink', 'fundrize' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'fundrize' ),
				'param_name' => 'new_tab',
				'group' => esc_html__( 'Hyperlink', 'fundrize' ),
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
			),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'fundrize' ),
				'param_name' => 'font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'fundrize' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'fundrize'),
				'param_name' => 'font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line-Height', 'fundrize'),
				'param_name' => 'line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
        )
    ) );
} );

// Hero Section
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_hero extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Hero Section', 'fundrize'),
        'description' => esc_html__('Hero Section.', 'fundrize'),
        'base' => 'hero',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'hero'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Hero Height', 'fundrize' ),
				'param_name' => 'hero_height',
				'value'      => array(
					'Full Height' => 'full-height',
					'Custom Height' => 'custom-height',
				),
				'std'		=> 'full-height',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Hero Custom Height', 'fundrize'),
				'param_name' => 'hero_custom_height',
				'value' => '',
				'description'	=> esc_html__('Ex: 600px.', 'fundrize'),
				'dependency' => array( 'element' => 'hero_height', 'value' => 'custom-height' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Showcase', 'fundrize' ),
				'param_name' => 'showcase',
				'value'      => array(
					'Background Slideshow' => 'slideshow',
					'Background Video' => 'video',
				),
				'std'		=> 'slideshow',
			),
			array(
				'type' => 'attach_images',
				'heading' => esc_html__('Background Images', 'fundrize'),
				'param_name' => 'images',
				'value' => '',
				'description' => esc_html__('Choose multi-images for background slideshow.', 'fundrize'),
				'dependency' => array( 'element' => 'showcase', 'value' => 'slideshow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Effects', 'fundrize' ),
				'param_name' => 'effect',
				'value'      => array(
					'fade' => 'fade',
					'fade2' => 'fade2',
					'slideLeft' => 'slideLeft',
					'slideLeft2' => 'slideLeft2',
					'slideRight' => 'slideRight',
					'slideRight2' => 'slideRight2',
					'slideUp' => 'slideUp',
					'slideDown' => 'slideDown',
					'slideDown2' => 'slideDown2',
					'zoomIn' => 'zoomIn',
					'zoomIn2' => 'zoomIn2',
					'zoomOut' => 'zoomOut',
					'zoomOut2' => 'zoomOut2',
					'swirlLeft' => 'swirlLeft',
					'swirlLeft2' => 'swirlLeft2',
					'swirlRight' => 'swirlRight',
					'swirlRight2' => 'swirlRight2',
					'burn' => 'burn',
					'burn2' => 'burn2',
					'blur' => 'blur',
					'blur2' => 'blur2',
					'flash' => 'flash',
					'flash2' => 'flash2'
				),
				'std'		=> 'fade',
				'dependency' => array( 'element' => 'showcase', 'value' => 'slideshow' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Youtube link (URL)', 'fundrize'),
				'param_name' => 'video_link',
				'value' => '',
				'description' => esc_html__('Youtube link or ID. Ex: https://www.youtube.com/watch?v=vQqZIFCab9o', 'fundrize'),
				'dependency' => array( 'element' => 'showcase', 'value' => 'video' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Pattern Overlay', 'fundrize' ),
				'param_name' => 'pattern_overlay',
				'value'      => array(
					'No Parttern' => '',
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
					'Style 4' => 'style-4',
					'Style 5' => 'style-5',
					'Style 6' => 'style-6',
					'Style 7' => 'style-7',
					'Style 8' => 'style-8',
					'Style 9' => 'style-9',
				),
				'std'		=> 'style-1',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color Overlay', 'fundrize'),
				'param_name' => 'color_overlay',
				'value' => '',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Alignment', 'fundrize' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Content: Top Margin', 'fundrize'),
				'param_name' => 'content_top',
				'value' => '',
				'description'	=> esc_html__('Ex: 50px. In case you want to set a spacing above the content area.', 'fundrize'),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Content area into Grid?', 'fundrize' ),
				'param_name' => 'grid',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			// Arrow
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show arrow?', 'fundrize' ),
				'param_name' => 'scroll',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
				'group' => esc_html__( 'Arrow', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Style', 'fundrize' ),
				'param_name' => 'arrow_style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
				'group' => esc_html__( 'Arrow', 'fundrize' ),
				'dependency' => array( 'element' => 'scroll', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Scroll to Row (ID)', 'fundrize'),
				'param_name' => 'scroll_id',
				'value' => '',
				'description' => esc_html__('Enter the anchor ID you assigned to the row.', 'fundrize'),
				'group' => esc_html__( 'Arrow', 'fundrize' ),
				'dependency' => array( 'element' => 'scroll', 'value' => 'yes' ),
            ),
        )
    ) );
} );

// Fancy Text
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Fancy Text', 'fundrize'),
        'description' => esc_html__('Awesome Animation Text.', 'fundrize'),
        'base' => 'fancytext',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'fundrize' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'fundrize' ),
				'param_name' => 'animation',
				'value'      => array(
					'Scrolling' => 'scroll',
					'Typing' => 'typed',
				),
				'std'		=> 'scroll',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 1 (Optional)', 'fundrize' ),
				'param_name' => 'text1',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 2 (Optional)', 'fundrize' ),
				'param_name' => 'text2',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 3 (Optional)', 'fundrize' ),
				'param_name' => 'text3',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 4 (Optional)', 'fundrize' ),
				'param_name' => 'text4',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 5 (Optional)', 'fundrize' ),
				'param_name' => 'text5',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Prefix Text (Optional)', 'fundrize' ),
				'param_name' => 'prefix_text',
				'group' => esc_html__( 'Prefix & Suffix', 'fundrize' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Suffix Text (Optional)', 'fundrize' ),
				'param_name' => 'suffix_text',
				'group' => esc_html__( 'Prefix & Suffix', 'fundrize' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'fundrize'),
				'param_name' => 'text_color',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Prefix Text Color', 'fundrize'),
				'param_name' => 'prefix_color',
				'value' => '',
				'group' => esc_html__( 'Prefix & Suffix', 'fundrize' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Suffix Text Color', 'fundrize'),
				'param_name' => 'suffix_color',
				'value' => '',
				'group' => esc_html__( 'Prefix & Suffix', 'fundrize' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
            ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Tag', 'fundrize' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h2',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'fundrize' ),
				'param_name' => 'font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'fundrize' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type' => 'number',
				'heading' => esc_html__( 'Font Size: Max', 'fundrize' ),
				'param_name' => 'font_max',
				'value' => 70,
				'suffix' => 'px',
				'group' => esc_html__( 'Typography', 'fundrize' ),
				'description'	=> esc_html__('Important! This size only appear exactly on the full-width grid, 65px max-size on the 1170 grid and 32px max-size on the 570px grid.', 'fundrize'),
		  	),
		  	array(
				'type' => 'number',
				'heading' => esc_html__( 'Font Size: Min', 'fundrize' ),
				'param_name' => 'font_min',
				'value' => 22,
				'suffix' => 'px',
				'group' => esc_html__( 'Typography', 'fundrize' ),
		  	),
        )
    ) );
} );

// Partner Carousel
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Partner Carousel', 'fundrize'),
	    'description' => esc_html__('Displaying partner posts in carousel.', 'fundrize'),
	    'base' => 'partners',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
	    'params' => array(
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'fundrize'),
				'param_name' => 'gap',
				'value' => '10',
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'fundrize' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Infinity Loop?', 'fundrize' ),
				'param_name' => 'loop',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'description'	=> esc_html__('Duplicate last and first items to get loop illusion.', 'fundrize'),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Box Shadow?', 'fundrize' ),
				'param_name' => 'box_shadow',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			// Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'fundrize'),
				'param_name' => 'items',
				'value' => '5',
				'group' => esc_html__( 'Query', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug', 'fundrize'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'fundrize' ),
				'description'	=> esc_html__('Only show posts from specific category-slug (optional).', 'fundrize'),
	        ),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'fundrize'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'fundrize' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'fundrize' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'fundrize' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'fundrize'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'fundrize' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'fundrize' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'0 - IN' => '0i',
					'Center' => 'center',
					'0 - OUT' => '0o',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'fundrize' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px', 'fundrize' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px', 'fundrize' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px', 'fundrize' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
	    )
	) );
} );

// Subscribe
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Subscribe Form', 'fundrize'),
        'description' => esc_html__('Displaying mailchimp newsletter form.', 'fundrize'),
        'base' => 'subscribe',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'fundrize' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap: Padding', 'fundrize'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 50px 57px 46px 57px', 'fundrize'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Wrap: Background', 'fundrize' ),
				'param_name' => 'background',
				'value'      => array(
					'Accent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
				),
				'std'		=> 'accent',
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading Text', 'fundrize' ),
				'param_name' => 'heading',
				'value' => 'Newsletter Subscribe'
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Sub-Heading (Optional)', 'fundrize' ),
				'param_name' => 'subheading',
			),
        )
    ) );
} );

// Google Maps
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Google Maps', 'fundrize'),
        'description' => esc_html__('Displaying Google Maps.', 'fundrize'),
        'base' => 'googlemap',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
        'params' => array(
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Latitude', 'fundrize' ),
				'param_name'  => 'lat',
				'description' => '<a href="http://universimmedia.pagesperso-orange.fr/geo/loc.htm" target="_blank">'. esc_html__('Here is a tool', 'fundrize').'</a> '. esc_html__('where you can find Latitude & Longitude of your location', 'fundrize'),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Longitude', 'fundrize' ),
				'param_name'  => 'lng',
				'description' => '<a href="http://universimmedia.pagesperso-orange.fr/geo/loc.htm" target="_blank">'. esc_html__('Here is a tool', 'fundrize').'</a> '. esc_html__('where you can find Latitude & Longitude of your location', 'fundrize'),
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Map Width', 'fundrize' ),
				'param_name' => 'width',
				'value'      => ''
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Map Height', 'fundrize' ),
				'param_name' => 'height',
				'value'      => 300
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Zoom Level', 'fundrize' ),
				'param_name'  => 'zoom',
				'description' => esc_html__( 'Select the default zoom level for the Maps', 'fundrize' ),
				'value'       => array_combine( range( 1, 24 ), range( 1, 24 ) ),
				'std'		  => '14'
			),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Dragging on Mobile' ),
                'param_name' => 'drag_mobile',
                'value' => array( esc_html__( 'Enable' ) => 'true', esc_html__( 'Disable' ) => 'false'),
                'std' => 'true'
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Dragging on Desktop' ),
                'param_name' => 'drag_desktop',
                'value' => array( esc_html__( 'Enable' ) => 'true', esc_html__( 'Disable' ) => 'false'),
                'std' => 'true'
            ),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Show The Marker', 'fundrize' ),
				'param_name'  => 'marker_type',
				'value'       => array(
					'Simple'          => 'simple',
					'Custom Image' => 'image',
				),
				'std'		=> 'simple',
				'group' => esc_html__( 'Maker', 'fundrize' ),
			),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'fundrize'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Maker', 'fundrize' ),
				'dependency' => array( 'element' => 'marker_type', 'value' => 'image' ),
			),
        )
    ) );
} );

// Tabs
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_dtabs extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Tabs', 'fundrize' ),
        'description' => esc_html__('Displaying Tabbed Content.', 'fundrize'),
		'base'        => 'dtabs',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array( 'only' => 'dtab' ),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'fundrize' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
					'Style 4' => 'style-4',
				),
				'std'		=> 'style-1',
			),
	        array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title: Width', 'fundrize' ),
				'param_name' => 'title_width',
				'value'      => array(
					'150px' => 'w150',
					'160px' => 'w160',
					'170px' => 'w170',
					'180px' => 'w180',
					'190px' => 'w190',
					'200px' => 'w200',
					'220px' => 'w220',
					'240px' => 'w240',
					'260px' => 'w260',
					'280px' => 'w280',
					'300px' => 'w300',
				),
				'std'		=> 'w190',
				'dependency' => array( 'element' => 'style', 'value' => array('style-3','style-4')),
	        ),
		)
	) );
} );

// Tab
add_action( 'vc_before_init', function() {
	vc_map( array(
	'name'        => esc_html__( 'Tab', 'fundrize' ),
    'description' => esc_html__('Displaying Tab.', 'fundrize'),
		'base'        => 'dtab',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'js_composer'),
		'as_child'    => array( 'only' => 'dtabs' ),
		'params'      => array(
			// Title
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Title', 'fundrize'),
				'param_name' => 'title',
				'value' => 'Tab',
				'group' => esc_html__( 'Title', 'fundrize' ),
            ),
	        // Content
			array(
				'type' 		=> 'textarea_html',
				'heading' 	=> esc_html__('Content', 'fundrize'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'fundrize'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 20px 0px 0px 0px;', 'fundrize'),
				'group' => esc_html__( 'Content', 'fundrize' ),
	        ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title Font Family', 'fundrize' ),
				'param_name' => 'title_font_family',
				'value'      =>  fundrize_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title Font Weight', 'fundrize' ),
				'param_name' => 'title_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'fundrize' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Title Font Size', 'fundrize'),
				'param_name' => 'title_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Title Line-Height', 'fundrize'),
				'param_name' => 'title_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'fundrize' ),
	        ),
		)
	) );
} );

// Causes Grid
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Causes Grid', 'fundrize'),
        'description' => esc_html__('Displaying causes in grid.', 'fundrize'),
        'base' => 'causesgrid',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'fundrize' ),
				'param_name' => 'style',
				'value'      => array(
					'Grey Background' => 'style-1',
					'White Background' => 'style-2',
				),
				'std'		=> 'style-1',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number', 'fundrize'),
				'param_name' => 'number',
				'value' => '',
				'description'	=> esc_html__('The number of campaigns to show.', 'fundrize'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Grid', 'fundrize' ),
				'param_name' => 'grid',
				'value'      => array(
					'1 Column' => 'grid1',
					'2 Columns' => 'grid2',
					'3 Columns' => 'grid3',
					'4 Columns' => 'grid4',
				),
				'std'		=> 'grid1',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Order By', 'fundrize' ),
				'param_name' => 'orderby',
				'value'      => array(
					'Date' => 'post_date',
					'Popular' => 'popular',
					'Ending' => 'ending',
				),
				'std'		=> 'post_date',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'fundrize'),
				'param_name' => 'cat_slug',
				'value' => '',
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'fundrize'),
	        ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Item: Box Shadow?', 'fundrize' ),
				'param_name' => 'box_shadow',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
        )
    ) );
} );

// Causes Carousel
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Causes Carousel', 'fundrize'),
        'description' => esc_html__('Displaying causes in carousel.', 'fundrize'),
        'base' => 'causes',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'fundrize' ),
				'param_name' => 'style',
				'value'      => array(
					'Grey Background' => 'style-1',
					'White Background' => 'style-2',
				),
				'std'		=> 'style-1',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Order By', 'fundrize' ),
				'param_name' => 'orderby',
				'value'      => array(
					'Date' => 'post_date',
					'Popular' => 'popular',
					'Ending' => 'ending',
				),
				'std'		=> 'post_date',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'fundrize'),
				'param_name' => 'cat_slug',
				'value' => '',
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'fundrize'),
	        ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Item: Box Shadow?', 'fundrize' ),
				'param_name' => 'box_shadow',
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
	        // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number', 'fundrize'),
				'param_name' => 'number',
				'value' => '',
				'group' => esc_html__( 'Query', 'fundrize' ),
				'description'	=> esc_html__('The number of campaigns to show.', 'fundrize'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Space Between', 'fundrize'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'fundrize' ),
				'description'	=> esc_html__('Important! Include the blur distance of the shadow.', 'fundrize'),
	        ),
	        // Controls
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'fundrize' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'fundrize'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'fundrize' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'fundrize' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'fundrize' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'fundrize'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'fundrize' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'fundrize' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'0 - IN' => '0i',
					'Center' => 'center',
					'0 - OUT' => '0o',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'fundrize' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px.', 'fundrize' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px.', 'fundrize' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px.', 'fundrize' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Products Carousel
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Products Carousel', 'fundrize'),
        'description' => esc_html__('Displaying products in carousel.', 'fundrize'),
        'base' => 'dproducts',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('Fundrize VC Addons', 'fundrize'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'fundrize' ),
				'param_name' => 'style',
				'value'      => array(
					'Grey Background' => 'style-1',
					'White Background' => 'style-2',
				),
				'std'		=> 'style-1',
			),
	        // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number', 'fundrize'),
				'param_name' => 'number',
				'value' => '4',
				'group' => esc_html__( 'Query', 'fundrize' ),
				'description'	=> esc_html__('The number of campaigns to show.', 'fundrize'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Space Between', 'fundrize'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'fundrize' ),
				'description'	=> esc_html__('Important! Include the blur distance of the shadow.', 'fundrize'),
	        ),
	        // Controls
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'fundrize' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'fundrize'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'fundrize' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'fundrize' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'fundrize' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'fundrize'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'fundrize' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'fundrize' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array( esc_html__( 'Yes, please.', 'fundrize' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'fundrize' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'0 - IN' => '0i',
					'Center' => 'center',
					'0 - OUT' => '0o',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'fundrize' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'fundrize' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px.', 'fundrize' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px.', 'fundrize' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px.', 'fundrize' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'fundrize' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );