<?php
/**
 * @package Hoxa - Responsive Multipurpose Joomla Template
 * @author Cththemes - www.cththemes.com
 * @date: 01-10-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */

defined('_JEXEC') or die;

$app             = JFactory::getApplication();
$doc             = JFactory::getDocument();
$user            = JFactory::getUser();
$this->language  = $doc->language;
$this->direction = $doc->direction;

$menu = $app->getMenu();//echo'<pre>';var_dump($menu);
$defaultMenu = $menu->getDefault();
$activeMenu = $menu->getActive();

// Getting params from template
$params = $app->getTemplate(true)->params;

// Detecting Active Variables
$option   = $app->input->getCmd('option', '');
$view     = $app->input->getCmd('view', '');
$layout   = $app->input->getCmd('layout', '');
$task     = $app->input->getCmd('task', '');
$itemid   = $app->input->getCmd('Itemid', '');
$sitename = $app->get('sitename');

$template_folder = JURI::root(true).'/templates/'.$this->template;

$favicon = $params->get('favicon');
$pageClassSfx = '';

$showLoading = $params->get('showLoading','1');
$showBackTop = $params->get('showBackTop','1');

// Google fonts
$useDifferentFont = $params->get('useDifferentFont','0');
$bodyfont = $params->get('bodyfont','Raleway');
$bodyfontvariants = $params->get('bodyfontvariants',array());
$bodyfontfamily = $params->get('bodyfontfamily',"'Raleway', sans-serif;");

$headingfont = $params->get('headingfont','Oswald');
$headingfontvariants = $params->get('headingfontvariants',array());
$headingfontfamily = $params->get('headingfontfamily',"'Oswald', sans-serif;");

// $highlightfont = $params->get('highlightfont','Raleway');
// $highlightfontvariants = $params->get('highlightfontvariants',array());
// $highlightfontfamily = $params->get('highlightfontfamily',"'Raleway', sans-serif;");


if(count($bodyfontvariants)){
    $bodyfont .= ':'.implode(",", $bodyfontvariants);
}

if(count($headingfontvariants)){
    $headingfont .= ':'.implode(",", $headingfontvariants);
}

if(isset($activeMenu)){
    if($activeMenu->params->get('pageclass_sfx')){
        $pageClassSfx =  ' '.$activeMenu->params->get('pageclass_sfx');  
    }
}

$favicon = $params->get('favicon','');
$logoImage = $params->get('logoImage','');
$logoText = $params->get('logoText','');
$logoSubText = $params->get('logoSubText','');
$logotype = $params->get('logotype','image');

$offlinebg = $params->get('offlinebg','');
if(!empty($offlinebg)){
  $offlinebg = ' style="background-image:url('.JURI::root(true).'/'.$offlinebg.');"';
}else{
  $offlinebgcolor = $params->get('offlinebgcolor','#e14d43');
  $offlinebg = ' style="background-color:'.$offlinebgcolor.';"';
}

$offlinetext = $params->get('offlinetext','');
$showloginform = $params->get('showloginform','1');
$showcountdown = $params->get('showcountdown','1');
$countdownyear = $params->get('countdownyear','');
$countdownmonth = $params->get('countdownmonth','');
$countdownday = $params->get('countdownday','');
$countdownhour = $params->get('countdownhour','');
$countdownminute = $params->get('countdownminute','');

$phonenumber = $params->get('phonenumber','');
$email = $params->get('email','');
$facebooklink = $params->get('facebooklink','');
$googlepluslink = $params->get('googlepluslink','');
$twitterlink = $params->get('twitterlink','');
$linkedinlink = $params->get('linkedinlink','');
$rsslink = $params->get('rsslink','');
$envelopelink = $params->get('envelopelink','');

$preset = $params->get('preset','default');
$overrideColor = $params->get('overrideColor','0');
$bC = substr($params->get('baseColor', '#e14d43'),1);
$sC = substr($params->get('secondColor', '#363b3f'),1);
$tC = substr($params->get('thirdColor', '#9AD03E'),1);

// $logo = '';
// if ($logotype !== 'showboth') {
//  if($logotype === 'image'){
//    $logo = '<a href="'.JURI::root(true).'"  title="'.$sitename.'"><img src="'.JURI::root(true).'/'.$logoImage.'" class="img-responsive"></a>';
//  }else{
//    if(!empty($logoText)){
//      $logo = '<h1 class="logo"><a href="'.JURI::root(true).'"  title="'.$sitename.'">'.$logoText.'</a></h1>';
//    }elseif(empty($logo)){
//      $logo = '<h1  class="logo"><a href="'.JURI::root(true).'"  title="'.$sitename.'">'.$sitename.'</a><h1>';
//    }
//  }
// }else{
//  if(!empty($logoImage)){
//    $logo .= '<a href="'.JURI::root(true).'"  title="'.$sitename.'"><img src="'.JURI::root(true).'/'.$logoImage.'" class="img-responsive"></a>';
//  }
//  if(!empty($logoText)){
//    $logo .= '<h1 class="logo"><a href="'.JURI::root(true).'"  title="'.$sitename.'">'.$logoText.'</a></h1>';
//  }else{
//    $logo .= '<h1  class="logo"><a href="'.JURI::root(true).'"  title="'.$sitename.'">'.$sitename.'</a><h1>';
//  }
// }
require_once JPATH_BASE.'/components/com_azurapagebuilder/helpers/elementparser.php';


?>

<!DOCTYPE html>
<!--[if lt IE 7]><html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="<?php echo $this->language;?>"> <![endif]-->
<!--[if IE 7]> <html class="no-js lt-ie9 lt-ie8" lang="<?php echo $this->language;?>"> <![endif]-->
<!--[if IE 8]> <html class="no-js lt-ie9" lang="<?php echo $this->language;?>"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" lang="<?php echo $this->language;?>"> <!--<![endif]-->
  <head>
    <meta charset="<?php echo $this->_charset;?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Standard Favicon--> 
  <link rel="shortcut icon" href="<?php echo JURI::base(true). (!empty($favicon)? '/'.$favicon : '/images/favicon/favicon.ico');?>">

    <title><?php echo $this->title; ?></title>

    <?php if($useDifferentFont === '1') :?>
  <link href='https://fonts.googleapis.com/css?family=<?php echo $bodyfont;?>' rel='stylesheet' type='text/css'>
  <link href='https://fonts.googleapis.com/css?family=<?php echo $headingfont;?>' rel='stylesheet' type='text/css'>
  <?php else :?>
  <link href='https://fonts.googleapis.com/css?family=Raleway:400,100,200,300,500,600,700,800' rel='stylesheet' type='text/css'>
    <link href='https://fonts.googleapis.com/css?family=Lato:100,300,400,700,900,100italic,300italic,400italic,700italic,900italic' rel='stylesheet' type='text/css'>
  <?php endif;?>
    <!-- Bootstrap core CSS -->
    <link href="<?php echo $template_folder; ?>/css/bootstrap.min.css" rel="stylesheet" type="text/css">
    <!-- Custom CSS -->
    <link href="<?php echo $template_folder; ?>/css/animate.css" rel="stylesheet" type="text/css">
    <link href="<?php echo $template_folder; ?>/css/jquery.mCustomScrollbar.css" rel="stylesheet" type="text/css">
    <link href="<?php echo $template_folder; ?>/css/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="<?php echo $template_folder; ?>/css/colorbox-skins/4/colorbox.css" type="text/css">
    <link href="<?php echo $template_folder; ?>/css/main.css" rel="stylesheet" type="text/css">
    <link href="<?php echo $template_folder; ?>/css/settings.css" rel="stylesheet" type="text/css">

    <link href="<?php echo $template_folder; ?>/css/header/h1.css" rel="stylesheet" type="text/css">
    <link href="<?php echo $template_folder; ?>/css/responsive.css" rel="stylesheet" type="text/css">
    <link href="<?php echo $template_folder; ?>/css/rivathemes.css" rel="stylesheet" type="text/css">
    
    <?php if($overrideColor == '1') : ?>
    <link rel="stylesheet/less" type="text/css" href="<?php echo $template_folder; ?>/css/color.php?bc=<?php echo $bC;?>&amp;sc=<?php echo $sC;?>&amp;tc=<?php echo $tC;?>">
    <script type="text/javascript" src="<?php echo $template_folder; ?>/js/less.js"></script>
    <?php else : ?>
      <?php if($preset !== 'default') :?>
        <link rel="stylesheet" href="<?php echo $template_folder; ?>/css/<?php echo $preset;?>.css" id="envor-site-color"/>
      <?php else:?>
        <link href="<?php echo $template_folder; ?>/css/color1.css" rel="stylesheet" type="text/css" id="envor-site-color">
      <?php endif;?>
    <?php endif;?>

    <!-- Custom Style -->
    <link rel="stylesheet" type="text/css" href="<?php echo $template_folder; ?>/css/custom.css" media="all" />
    <style>
    .offline-login {max-width: 400px;margin: 0px auto;background-color: #fff;padding-top: 10px;padding-bottom: 10px;}
    .offline-login fieldset {border:0px;}
    </style>

    <!-- Just for debugging purposes. Don't actually copy this line! -->
    <!--[if lt IE 9]><script src="<?php echo $template_folder; ?>/js/vendor/ie8-responsive-file-warning.js"></script><![endif]-->

    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
      <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->

    <script src="<?php echo $template_folder; ?>/js/vendor/modernizr-2.6.2-respond-1.1.0.min.js"></script>
    <script type="text/javascript" >
    baseUrl = "<?php echo JURI::root(true);?>";
    siteName = "<?php echo $sitename;?>";
    templateName = "<?php echo $this->template;?>";
  </script>
  </head>
<body class="cth-site<?php echo $pageClassSfx;?> <?php echo $option
  . ' view-' . $view
  . ($layout ? ' layout-' . $layout : ' no-layout')
  . ($task ? ' task-' . $task : ' no-task')
  . ($itemid ? ' itemid-' . $itemid : '');
?>">

    <!--[if lt IE 7]>
    <p class="chromeframe">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> or <a href="http://www.google.com/chromeframe/?redirect=true">activate Google Chrome Frame</a> to improve your experience.</p>
    <![endif]-->
    <?php if($showBackTop === '1') :?>
    <div id="to-the-top"><i class="fa fa-chevron-up"></i></div>
  <?php endif;?>

  <?php if($showLoading === '1') :?>
      <div id="envor-preload">
        <span><?php echo JText::_('TPL_ENVOR_LOADING_TEXT');?></span>
        <i class="fa fa-cog fa-spin"></i>
        <p></p>
      </div>
  <?php endif;?>
    
    <header class="envor-header envor-header-1">
      <!--

      Top bar start

      //-->
      <div class="envor-top-bar">
        <div class="container">
          <div class="row">
            <div class="col-lg-12">
                <?php if(!empty($phonenumber)) :?>
                  <p class="contacts contacts-soon-1" style="max-height:40px;"><i class="fa fa-phone"></i> <?php echo $phonenumber;?></p>
                <?php endif;?>
                <?php if(!empty($email)) :?>
                  <p class="contacts contacts-soon-2" style="max-height:40px;"><i class="fa fa-envelope"></i> <a href="mailto:<?php echo $email;?>"><?php echo $email;?></a></p>
                <?php endif;?>

                <?php echo $doc->getBuffer('modules', 'top_bar', array('style' => 'none')); ?>
            </div>
          </div>
        </div>
      </div>
    <!--

    Envor header end

    //-->
    </header>
    <!--

    Envor site content start

    //-->
    <div class="envor-content envor-content-404" data-stellar-background-ratio="0.5" <?php echo $offlinebg;?>>
      <div class="envor-content-404-gradient"></div>
        <!--

        404 Page Content start

        //-->
        <div class="envor-content-404-inner">
                <!--

                Site Logo start

                //-->
                <a href="<?php echo JURI::root(true);?>" class="logolink">
                    <div class="envor-logo">
                      <?php if(!empty($logoImage)) :?>
                        <img src="<?php echo JURI::root(true).'/'.$logoImage;?>" alt="<?php echo $sitename;?>">
                      <?php endif;?>
                      <?php if(!empty($logoText)) :?>
                        <p class="logo"><?php echo $logoText;?></p>
                      <?php endif;?>
                      <?php if(!empty($logoSubText)) :?>
                        <p class="tagline"><?php echo $logoSubText;?></p>
                      <?php endif;?>
                    </div>
                </a>

                <?php echo ElementParser::do_shortcode($offlinetext ); ?>
                <?php if($showcountdown === '1') : ?>
                <div class="riva-countdown" id="riva-countdown">
                  <!--
                  * Days
                  //-->
                  <div class="riva-countdown-item" id="riva-countdown-days">
                    <div class="value"><p>0</p></div>
                    <div class="label">days</div>
                  </div>
                  <!--
                  * Hours
                  //-->
                  <div class="riva-countdown-item" id="riva-countdown-hours">
                    <div class="value"><p>0</p></div>
                    <div class="label">hours</div>
                  </div>
                  <!--
                  * Minutes
                  //-->
                  <div class="riva-countdown-item" id="riva-countdown-minutes">
                    <div class="value"><p>0</p></div>
                    <div class="label">minutes</div>
                  </div>
                  <!--
                  * seconds
                  //-->
                  <div class="riva-countdown-item" id="riva-countdown-seconds">
                    <div class="value"><p>0</p></div>
                    <div class="label">seconds</div>
                  </div>
                </div>
              <?php endif;?>
                <?php echo $doc->getBuffer('modules', 'soon-countdown', array('style' => 'none')); ?>

                <div class="clearfix"></div>
              <?php if($showloginform === '1') :?>
                <div class="offline-login">
                  <form action="<?php echo JRoute::_('index.php', true); ?>" method="post" id="form-login">
                     <fieldset class="input">
                        <p id="form-login-username">
                           <label for="username"><?php echo JText::_('JGLOBAL_USERNAME'); ?></label>
                           <input name="username" id="username" type="text" class="inputbox" alt="<?php echo JText::_('JGLOBAL_USERNAME'); ?>" size="18" />
                        </p>
                        <p id="form-login-password">
                           <label for="passwd"><?php echo JText::_('JGLOBAL_PASSWORD'); ?></label>
                           <input type="password" name="password" class="inputbox" size="18" alt="<?php echo JText::_('JGLOBAL_PASSWORD'); ?>" id="passwd" />
                        </p>
                        <?php if (count($twofactormethods) > 1) : ?>
                           <p id="form-login-secretkey">
                              <label for="secretkey"><?php echo JText::_('JGLOBAL_SECRETKEY'); ?></label>
                              <input type="text" name="secretkey" class="inputbox" size="18" alt="<?php echo JText::_('JGLOBAL_SECRETKEY'); ?>" id="secretkey" />
                           </p>
                        <?php endif; ?>
                        <?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
                           <p id="form-login-remember">
                              <label for="remember"><?php echo JText::_('JGLOBAL_REMEMBER_ME'); ?></label>
                              <input type="checkbox" name="remember" class="inputbox" value="yes" alt="<?php echo JText::_('JGLOBAL_REMEMBER_ME'); ?>" id="remember" />
                           </p>
                        <?php endif; ?>
                        <p id="submit-buton">
                           <label>&nbsp;</label>
                           <input type="submit" name="Submit" class="button login" value="<?php echo JText::_('JLOGIN'); ?>" />
                        </p>
                        <input type="hidden" name="option" value="com_users" />
                        <input type="hidden" name="task" value="user.login" />
                        <input type="hidden" name="return" value="<?php echo base64_encode(JUri::base()); ?>" />
                        <?php echo JHtml::_('form.token'); ?>
                     </fieldset>
                  </form>
               </div>
            <?php endif;?>
                <p>&nbsp;</p>
                <?php echo $doc->getBuffer('modules', 'soon-menu', array('style' => 'none')); ?>
        <!--

        404 Page Content end

        //-->
        </div>
      <!--

      Social Buttons List start

      //-->
      <section class="envor-section envor-section-st2 envor-soc-buttons-list" id="socials">
        <div class="container">
          <div class="row">
            <div class="col-lg-12">
              <?php echo ElementParser::do_shortcode($doc->getBuffer('modules', 'soon-socials', array('style' => 'none')) ); ?>
            </div>
          </div>
        </div>
      <!--

      Social Buttons List end

      //-->
      </section>
    </div>
    <script src="<?php echo $template_folder; ?>/js/vendor/jquery-1.11.0.min.js"></script>
    <script src="<?php echo $template_folder; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo $template_folder; ?>/js/jquery.mCustomScrollbar.min.js"></script>
    <script src="<?php echo $template_folder; ?>/js/jquery.mousewheel.min.js"></script>
    <script src="<?php echo $template_folder; ?>/js/jquery.colorbox-min.js"></script>
    <script src="<?php echo $template_folder; ?>/js/preloadCssImages.jQuery_v5.js"></script>
    <script src="<?php echo $template_folder; ?>/js/jquery.stellar.min.js"></script>
    <script src="<?php echo $template_folder; ?>/js/jquery.fitvids.js"></script>
    <script src="<?php echo $template_folder; ?>/js/jquery.bxslider.min.js"></script>
  <script src="<?php echo $template_folder; ?>/js/masonry.pkgd.min.js"></script>
  <script src="<?php echo $template_folder; ?>/js/imagesloaded.pkgd.min.js"></script>
  <script src="<?php echo $template_folder; ?>/js/jquery.rivaMegaMenu.js"></script>

    <!--
    * jQuery with jQuery Easing, and jQuery Transit JS
    //-->
    <script src="<?php echo $template_folder; ?>/js/layerslider/jquery-easing-1.3.js" type="text/javascript"></script>
    <script src="<?php echo $template_folder; ?>/js/layerslider/jquery-transit-modified.js" type="text/javascript"></script>
    <script src="<?php echo $template_folder; ?>/js/jquery.rivathemes.js"></script>
    <script src="<?php echo $template_folder; ?>/js/jquery.flexslider-min.js"></script>
    <script src="<?php echo $template_folder; ?>/js/envor.js"></script>
    <script type="text/javascript">

        jQuery('document').ready(function($) {
            var $container = $('body');
            <?php if($showcountdown === '1') : ?>
            $('#riva-countdown').rivaCountdown({
              year : <?php echo $countdownyear;?>,
              month : <?php echo $countdownmonth;?>,
              date : <?php echo $countdownday;?>,
              hour : <?php echo $countdownhour;?>,
              minute : <?php echo $countdownminute;?>,
              second : 0,
            });
            <?php endif;?>
            $container.imagesLoaded( function() {
                $('#envor-preload').hide();
            });
      });
      
      /*

      Windows Phone 8 и Internet Explorer 10

      */
      if (navigator.userAgent.match(/IEMobile\/10\.0/)) {
        var msViewportStyle = document.createElement("style")
        msViewportStyle.appendChild(
          document.createTextNode(
            "@-ms-viewport{width:auto!important}"
          )
        )
        document.getElementsByTagName("head")[0].appendChild(msViewportStyle)
      }
    </script>
  </body>
</html>