(function($) {
	"use strict";

	
	/*
	*	Responsive Fix
	*/
	function responsiveFix() {
		var bodyW = $('body').width(),
			bodyH = $('body').height();
		$('i#envor-show-mibile-menu').css('top', parseInt($('body').css('padding-top')) + 55 + 'px');
		$('i#envor-show-mibile-cart').css('top', parseInt($('body').css('padding-top')) + 95 + 'px');
		if (bodyW > 768 && bodyW < 992) {
			$('article.envor-feature').last().css('margin-bottom', '60px');
		}
		if (bodyW < 768) {
			$('article.envor-feature').last().css('margin-bottom', '60px');
			$('.envor-mobile').css('height', $(window).height());
		}
	}
	responsiveFix();

	/*
	*	Envor Social Buttons
	*/
	$('.envor-soc-button li').each(function() {
		var $a = $(this).find('a');
		$('<span></span>').prependTo($a);
		$a.clone().addClass('hover').appendTo($(this));
	}).hover(function() {
		$(this).find('a').eq(0).stop(true, true).animate({'top':'-40px'}, 'fast').end().eq(1).stop(true, true).animate({'top':'0px'}, 'fast');
	}, function() {
		$(this).find('a').eq(0).stop(true, true).animate({'top':'0px'}, 'fast').end().eq(1).stop(true, true).animate({'top':'40px'}, 'fast');
	});

	/*
	*	Envor Site Logo
	*/
	var $logo = $('.envor-site-logo'),
		$img = $logo.find('figure');
	$logo.css('padding-left', $img.width() + 10);

	/*
	*	Nav.envor-desktop
	*/
	$('nav.envor-desktop li').hover(function() {
		var $ul = $(this).find('> ul');
		if ($ul.length != 0)
			$ul.fadeIn('fast');
	}, function() {
		var $ul = $(this).find('> ul');
		if ($ul.length != 0)
			$ul.fadeOut('fast');
	});

	/* 
	*	Envor Mobile Menu
	*/
	var mobileMenuScroll = 0;
	function setMobileMenuNav() {
		var $menuNav = $('.envor-mobile .envor-mobile-menu-nav'),
			$menu = $('.envor-mobile nav'),
			h = $(window).height();
		if ($menu.height() > h && !($('#envor-mobile').hasClass('envor-hide'))) {
			$menuNav.show();
		} else {
			$menuNav.hide();
		}
	}
	$('i#envor-show-mibile-menu').click(function() {
		var $menu = $('.envor-mobile');
		if ($menu.hasClass('envor-hide')) {
			$menu.animate({'right':'0px'}).removeClass('envor-hide');
			$(this).animate({'right':'200px'});
			setMobileMenuNav();
		} else {
			$menu.animate({'right':'-200px'}).addClass('envor-hide');
			$(this).animate({'right':'0px'});
			setMobileMenuNav();
		}
		$(this).toggleClass('envor-i-selected');
	});
	$('.envor-mobile nav ul li').each(function() { $('<span class="border"></span>').appendTo($(this)); });
	setMobileMenuNav();
	$('.envor-mobile .envor-mobile-menu-nav i').click(function() {
		var $this = $(this),
			$menu = $('.envor-mobile nav ul');
		if ($this.hasClass('fa-chevron-up')) {
			if (mobileMenuScroll != 0) {
				mobileMenuScroll = mobileMenuScroll - 1;
				$menu.animate({'top': '+=' + 80 + 'px'});
			}
		} else {
			$menu.animate({'top': '-=' + 80 + 'px'});
			mobileMenuScroll = mobileMenuScroll + 1;
		}
	});

	/*
	*	.envor-feature header
	*/
	$('.envor-feature').each(function() {
		$('<span class="arrow"></span>').prependTo($(this).find('header'));
		$('<span class="bg"></span>').prependTo($(this));
	});


	/*
	*	Window Resize Handler
	*/
	$(window).resize(function() {
		responsiveFix();
		setMobileMenuNav();
	});

})(jQuery);