<?php
/**
 * @package Hoxa - Responsive Multipurpose Joomla Template
 * @author Cththemes - www.cththemes.com
 * @date: 01-10-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;
/*
 * Module chrome for rendering the module in a submenu
 */
function modChrome_mega($module, &$params, &$attribs)
{
	if ($module->content)
	{
		// echo "< class=\"well " . htmlspecialchars($params->get('moduleclass_sfx')) . "\">";
		// if ($module->showtitle)
		// {
		// 	echo "<h3 class=\"page-header\">" . $module->title . "</h3>";
		// }
		echo "<li><p>" . $module->title . "</p></li>";
		echo $module->content;
		//echo "</div>";
	}
}

/*
 * html5 (chosen html5 tag and font headder tags)
 */
function modChrome_envor($module, &$params, &$attribs)
{
	$moduleTag      = $params->get('module_tag', 'div');
	$headerTag      = htmlspecialchars($params->get('header_tag', 'h3'));
	$bootstrapSize  = (int) $params->get('bootstrap_size', 0);
	$moduleClass    = $bootstrapSize != 0 ? ' col-sm-' . $bootstrapSize : '';

	// Temporarily store header class in variable
	$headerClass	= $params->get('header_class');
	$headerClass	= !empty($headerClass) ? ' class="envor-widget ' . htmlspecialchars($headerClass) . '"' : ' class="envor-widget"';

	if (!empty ($module->content)) : ?>
		<<?php echo $moduleTag; ?> class="moduletable<?php echo htmlspecialchars($params->get('moduleclass_sfx')) . $moduleClass; ?>">
			
			<?php echo '<div'.$headerClass .'>';?>
				<?php if ((bool) $module->showtitle) :?>
					<<?php echo $headerTag .  '>' . preg_replace("/--([^(-){2}]*)--/", "<strong>$1</strong>", $module->title); ?></<?php echo $headerTag; ?>>
				<?php endif; ?>
				<div class="envor-widget-inner">
					<?php echo $module->content; ?>
				</div>
			</div>
			
		</<?php echo $moduleTag; ?>>

	<?php endif;
}

function modChrome_mega_section($module, &$params, &$attribs)
{
	if ($module->content)
	{
		echo "<aside class=\"envor-mega-section " . htmlspecialchars($params->get('moduleclass_sfx')) . "\">";
		if ($module->showtitle)
		{
			echo "<h4>" . preg_replace("/--([^(-){2}]*)--/", "<strong>$1</strong>", $module->title) . "</h4>";
		}
		echo $module->content;

		echo "</aside>";
	}
}

function modChrome_mega_section_2($module, &$params, &$attribs)
{
	if ($module->content)
	{
		echo "<aside class=\"envor-mega-section-2 " . htmlspecialchars($params->get('moduleclass_sfx')) . "\">";
		if ($module->showtitle)
		{
			echo "<h4>" . preg_replace("/--([^(-){2}]*)--/", "<strong>$1</strong>", $module->title) . "</h4>";
		}
		echo $module->content;
		
		echo "</aside>";
	}
}

function modChrome_footercolumns($module, &$params, &$attribs)
{
	$colclass = '';
	switch ($attribs['columns']) {
		case '1':
			$colclass = 'one_full';
			break;
		case '2':
			$colclass = 'one_half';
			break;
		case '3':
			$colclass = 'one_third';
			break;
		case '4':
			$colclass = 'one_fourth';
			break;
		case '6':
			$colclass = 'one_fifth';
			break;
		default:
			$colclass = 'one_fourth';
			break;
	}
	$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));

	if ($module->content)
	{
		echo "<div class=\"" .$colclass. " animate\" data-anim-type=\"fadeInUp\">";
			if(!empty($moduleclass_sfx)){
				echo '<div class="'.$moduleclass_sfx.'">';
			}
			//echo "<div class=\"widget footer-widget ". htmlspecialchars($params->get('moduleclass_sfx')) ."\">";
			if ($module->showtitle)
			{
				echo "<h4 class=\"lmb\">" . $module->title . "</h4>";
			}
				echo $module->content;

			if(!empty($moduleclass_sfx)){
				echo '</div>';
			}
			//echo "</div>";						
		echo "</div>";
	}
}

function modChrome_fourcol($module, &$params, &$attribs)
{
	$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));

	if ($module->content)
	{
		echo "<div class=\"four col ".$moduleclass_sfx."\">";

			if ($module->showtitle)
			{
				echo "<h4>" . $module->title . "</h4>";
			}
				echo $module->content;

		echo "</div>";
	}
}


function modChrome_container($module,&$params, &$attribs){
	if($module->content){
		echo "<div class=\"cth-container " . htmlspecialchars($params->get('moduleclass_sfx')) . "\">";
			echo "<div class=\"container\">";
				if ($module->showtitle)
				{
					echo "<h5>" . $module->title . "</h5>";
				}
				echo $module->content;
			echo "</div>";
		echo "</div>";
	}
}

function modChrome_sidebarhr($module,&$params, &$attribs){
	if($module->content){
		echo "<div class=\"cth-sidebar " . htmlspecialchars($params->get('moduleclass_sfx')) . "\">";
		if ($module->showtitle)
		{
			echo "<" . htmlspecialchars($params->get('header_tag')) . " class=\"sidebar-heading ". htmlspecialchars($params->get('header_class')) . "\">" . $module->title . "</" . htmlspecialchars($params->get('header_tag')) . ">";
		}
		echo $module->content;
		echo "</div>";
		echo "<hr>";
	}
}

function modChrome_sidebar($module,&$params, &$attribs){
	if($module->content){
		echo "<div class=\"cth-sidebar " . htmlspecialchars($params->get('moduleclass_sfx')) . "\">";
		if ($module->showtitle)
		{
			echo "<" . htmlspecialchars($params->get('header_tag')) . " class=\"sidebar-heading ". htmlspecialchars($params->get('header_class')) . "\">" . $module->title . "</" . htmlspecialchars($params->get('header_tag')) . ">";
		}
		echo $module->content;
		echo "</div>";
	}
}


function modChrome_widget($module, &$params, &$attribs)
{
	if ($module->content)
	{
		echo "<aside class=\"envor-widget " . htmlspecialchars($params->get('moduleclass_sfx')) . "\">";
		if ($module->showtitle)
		{
			echo "<h3>" . preg_replace("/--([^(-){2}]*)--/", "<strong>$1</strong>", $module->title) . "</h3>";
		}
		echo $module->content;
		echo "</aside>";
	}
}

function modChrome_section($module, &$params, &$attribs){
	if($module->content){
		$cthmoduleid_sfx = $params->get('cthmoduleid_sfx');
		$cthmoduleclass_sfx = htmlspecialchars($params->get('cthmoduleclass_sfx'));
		echo '<section '.(!empty($cthmoduleid_sfx)? ' id="'.$cthmoduleid_sfx.'"' : '').' '.(!empty($cthmoduleclass_sfx)? ' class="'.$cthmoduleclass_sfx.'"' : '').'>';

			if ($module->showtitle)
			{
				echo '<!-- Title -->';
				echo '<div class="row title '.htmlspecialchars($params->get('header_class')).'">';
					echo '<h2>'. $module->title .'</h2>';
					echo '<hr>';
				echo '</div>';

			}

			echo $module->content;

		echo '</section>';

	}
}


?>
