<?php
/**
 * @version		2.2
 * @package		Example K2 Plugin (K2 plugin)
 * @author		JoomlaWorks - http://www.joomlaworks.net
 * @copyright	Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die ;

/**
 * Example K2 Plugin to render YouTube URLs entered in backend K2 forms to video players in the frontend.
 */

// Load the K2 Plugin API
JLoader::register('K2Plugin', JPATH_ADMINISTRATOR.'/components/com_k2/lib/k2plugin.php');

use Joomla\Registry\Registry;
jimport('joomla.application.component.helper');

require_once JPATH_ADMINISTRATOR.'/components/com_azurapagebuilder/helpers/azuraelements.php';
require_once JPATH_ADMINISTRATOR.'/components/com_azurapagebuilder/helpers/awesomefont.php';
require_once JPATH_ROOT.'/components/com_azurapagebuilder/helpers/elementparser.php';
require_once JPATH_ROOT.'/components/com_azurapagebuilder/helpers/azurajs.php';

// Initiate class to hold plugin events
class plgK2AzuraK2Builder extends K2Plugin
{

	// Some params
	var $pluginName = 'azurak2builder';
	var $pluginNameHumanReadable = 'K2 - Azura Builder';

	function __construct(&$subject, $params)
	{
		parent::__construct($subject, $params);

		$this->loadLanguage();

		$app  = JFactory::getApplication();

        //add admin style/script
		if ($app->isClient('administrator'))
		{

			JHtml::_('jquery.framework');
			
			$doc = JFactory::getDocument();

		    $doc->addStyleSheet(Juri::base() . 'components/com_azurapagebuilder/assets/admin/azp_styles.css');

		    $jinput = $app->input;

            $com_option = $jinput->get('option', 'com_azurapagebuilder', 'cmd');
            $com_view = $jinput->get('view', 'page', 'cmd');
            $com_layout = $jinput->get('layout', 'layout', 'cmd');

            $com_js_options = array(
            	'is_excom' => false,
            	'com_view' => $com_view,
            	'com_option' => $com_option,
			);
            if(  $com_option == 'com_k2' && $com_view == 'item' ){
            	JForm::addFieldPath(JPATH_ADMINISTRATOR. DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_azurapagebuilder' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'fields');
				JForm::addFormPath(JPATH_ADMINISTRATOR. DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_azurapagebuilder' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'forms');

				$com_js_options['editor'] = 'text';
				$com_js_options['editorTab'] = '#k2TabContent';
				$com_js_options['use_azpbuilder_field'] = 'plugins[azurak2builder_status]';
				$com_js_options['is_excom'] = true;

            	JHtml::_('jquery.framework');
            	JHtml::_('behavior.colorpicker');
				JHtml::_('jquery.ui', array('core', 'sortable'));

            	$scr = '
				var cururl = window.location.href;
				var adminpos = cururl.indexOf("administrator");
				if(adminpos){
					adComBaseUrl = cururl.substring(0, adminpos + 13)+"/";
				}
				adComRootUrl ="'. JURI::root().'";
				';

				// get element option types 
				AzuraElements::loadElementsOptions();
				$elementsOptions = AzuraElements::getElementsOptions();
				$scr .= "var azuraElementsOptions = ".json_encode($elementsOptions).";";
				$doc->addScriptDeclaration($scr);
				$doc->addStyleSheet(JURI::base(true).'/components/com_azurapagebuilder/assets/css/bootstrap.custom.css');
				$doc->addStyleSheet(JURI::base(true).'/components/com_azurapagebuilder/assets/css/azura-modal.css');
				//$doc->addStyleSheet(JURI::base(true).'/components/com_azurapagebuilder/assets/fancybox/jquery.fancybox.css');
				$doc->addStyleSheet(JURI::base(true).'/components/com_azurapagebuilder/assets/fancybox3/dist/jquery.fancybox.min.css');
				$doc->addStyleSheet(JURI::root().'/components/com_azurapagebuilder/assets/fonts/themify-icons/themify-icons.css');
				$doc->addStyleSheet(JURI::root().'/components/com_azurapagebuilder/assets/fonts/font-awesome/css/font-awesome.min.css');
				$doc->addStyleSheet(JURI::root().'/components/com_azurapagebuilder/assets/fonts/lineicons/lineicons.css');
				$doc->addStyleSheet(JURI::root().'/components/com_azurapagebuilder/assets/fonts/simple-line-icons/css/simple-line-icons.css');
				$doc->addStyleSheet(JURI::root().'/components/com_azurapagebuilder/assets/fonts/et-line/style.css');
				$doc->addStyleSheet(JURI::base(true).'/components/com_azurapagebuilder/assets/css/style.css');

				//$doc->addScript(JURI::base(true).'/components/com_azurapagebuilder/assets/fancybox/jquery.fancybox.pack.js');
				$doc->addScript(JURI::base(true).'/components/com_azurapagebuilder/assets/fancybox3/dist/jquery.fancybox.min.js');
				$doc->addScript(JURI::base(true).'/components/com_azurapagebuilder/assets/js/azura-modal.js');
				$doc->addScript(JURI::base(true).'/components/com_azurapagebuilder/assets/ace/src-min-noconflict/ace.js');
				$doc->addScript('https://ajax.googleapis.com/ajax/libs/webfont/1.6.26/webfont.js');

				// $doc->addScriptDeclaration('
				//     WebFont.load({
				//     	google: { 
				//            families: [\'Raleway\'] 
				//      	} 
				//  	});
				// ');
				$doc->addScript(JURI::base(true).'/components/com_azurapagebuilder/assets/js/libraries.js');
				$doc->addScript(JURI::base(true).'/components/com_azurapagebuilder/assets/js/newapp-editor.js');

				//$doc->addStyleSheet('https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.1.20/jquery.fancybox.min.css');	
				//$doc->addScript('https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.1.20/jquery.fancybox.min.js');
					

            }
            $doc->addScriptOptions('com_azurapagebuilder', $com_js_options);
		}

	}

	/**
	 * Below we list all available FRONTEND events, to trigger K2 plugins.
	 * Watch the different prefix "onK2" instead of just "on" as used in Joomla! already.
	 * Most functions are empty to showcase what is available to trigger and output. A few are used to actually output some code for example reasons.
	 */

	function onK2PrepareContent(&$item, &$params, $limitstart)
	{
		//echo '<pre>';var_dump($item);die;
		AzuraElements::loadElementsOptions();

		JHtml::_('jquery.framework');

		JHtml::_('stylesheet', 'components/com_azurapagebuilder/assets/css/azp_plugins.min.css');
		JHtml::_('stylesheet', 'components/com_azurapagebuilder/assets/css/azp_elements.min.css');

		if(isset( $item->hits )){
			AzuraJs::setData('hits',$item->hits);
			AzuraJs::setData('pageid',$item->id);
			AzuraJs::setData('page_likes', AzuraShortcode::getK2PostLikes($item->id) );
		}

		AzuraJs::writeStyles();
		AzuraJs::writeJScripts();
		AzuraJs::writeInlineStyles();

		JHtml::_('script', 'components/com_azurapagebuilder/assets/js/azp_front.min.js');
		
		if(strpos($item->text, '{K2Splitter}')!== false){
			@list($introtext, $fulltext) = explode('{K2Splitter}', $item->text);
			$item->text = $introtext . '{K2Splitter}' . '<div class="azp_page-content-wrap azp_do_shortcode">'. AzuraShortcode::doContentShortcode($fulltext) .'</div>';
		}else{
			$item->text = '<div class="azp_page-content-wrap azp_do_shortcode">'.AzuraShortcode::doContentShortcode($item->text).'</div>';
		}

		// $shortcode_content = AzuraShortcode::doContentShortcode($item->text);

		// echo'<pre>';var_dump($shortcode_content);die;

		// if($shortcode_content !='') $item->text = '<div class="azp_page-content-wrap azp_do_shortcode">'.$shortcode_content.'</div>';


	}

} // END CLASS
