<?php 
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;
$el_class = $el_id = $title = $icon_type = $link = $target = $btn_color = $btn_custom_color = $btn_size = $is_border = $is_fullwidth = $click_action = $menu_item = $popup_link = $modal_id =  $btn_type = $btn_image = '';
//$azura_attrs,$azura_content,$azura_element
extract($azura_attrs);
$animation_data = self::buildAnimation($azura_attrs);
$classes = array(
	'azp_element',
    'azp_btn-wrap',
    $el_class,
);
$classes[] = $animation_data['trigger'];
$classes[] = self::buildTypography($azura_attrs);//will return custom class for the element without dot
$iconClass = isset( ${'icon_' . $icon_type} ) ? ${'icon_' . $icon_type} : '';

$azpbuttonstyle = self::buildStyle($azura_attrs);

if(!empty($el_id)){
	$el_id = 'id="'.$el_id.'"';
}

if($btn_type == 'btn_image'){
	$linkcls = 'azp_btn-image';
}
elseif($btn_type == 'btn_image'){
	$linkcls = 'azp_btn-link';
}else{
	$linkcls = 'azp_btn';
	$linkcls .= ' azp_btn-'.$btn_color;
	$linkcls .= ' azp_btn-'.$btn_size;
	if(!empty($iconClass)){
	    $linkcls .= ' azp_btn-icon';
	}
	if($is_fullwidth == '1'){
	     $linkcls .= ' azp_btn-block';
	     $classes[] = ' azp_block';
	}
	if($is_border == '1'){
	     $linkcls .= ' azp_btn-bordered';
	}
}



$classes = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $classes ) ) );

$custom_style_class = uniqid('azp_custom_');
$addit_style = '';
if($btn_color == 'custom' && $btn_custom_color != ''){
	$darker_color = azura_colourBrightness($btn_custom_color, -0.8);
	if($is_border == '1'){
	    $addit_style .= '.'.$custom_style_class .' .azp_btn {color:'.$btn_custom_color.';border-color:'.$btn_custom_color.';}';
	    $addit_style .= '.'.$custom_style_class .':hover .azp_btn {color:#fff;background-color:'.$darker_color.';border-color:'.$darker_color.';}';
	}else{
		$addit_style .= '.'.$custom_style_class .' .azp_btn {background-color:'.$btn_custom_color.';border-color:'.$btn_custom_color.';}';
	    $addit_style .= '.'.$custom_style_class .':hover .azp_btn {background-color:'.$darker_color.';border-color:'.$darker_color.';}';
	}
} 
$link_new_attr = '';
if($addit_style != ''){
	AzuraJs::addInlineStyle($addit_style);
	$classes .= ' ' .$custom_style_class;
} 
if($click_action == 'menu'){
	if(!empty($menu_item)){
		$link = JURI::root().'?Itemid='.$menu_item;
	}
}elseif($click_action == 'popup' && $popup_link != ''){
	$classes .= ' azp_image-popup';
	$url_args = parse_url($popup_link);
	if(isset($url_args['host']) && ($url_args['host'] == 'youtu.be'||$url_args['host'] == 'www.youtube.com'||$url_args['host'] == 'youtube.com'||$url_args['host'] == 'vimeo.com'||$url_args['host'] == 'www.vimeo.com'||$url_args['host'] == 'soundcloud.com')){
		$link = $popup_link ;
		$linkcls .= ' mfp-iframe';
	}else{
		$link = JURI::root().$popup_link;
	}
	$linkcls .= ' image_popup_a';
}elseif($click_action == 'modal' && $modal_id != ''){
	$link_new_attr .= ' data-toggle="azpmodal" data-target="#'.$modal_id.'"';
	$link = '#';
}
?>
<div class="<?php echo $classes; ?>" <?php echo $el_id .' ' . $azpbuttonstyle.' '.$animation_data['data'];?>>
	<a class="<?php echo $linkcls;?>" href="<?php echo $link;?>" target="<?php echo $target;?>"<?php echo $link_new_attr;?>>
		<?php if($btn_image != ''): ?>
	    <img src="<?php echo JURI::root().$btn_image;?>" alt="<?php echo $title;?>">
	    <?php endif;?>
		<span><?php echo $title;?></span>
		<?php if(!empty($iconClass)): ?>
	    <i class="<?php echo $iconClass;?>"></i>
	    <?php endif;?>
	</a>
</div>