<?php
/*------------------------------------------------------------------------
# com_j2store - J2Store
# ------------------------------------------------------------------------
# author    Ramesh Elamathi - Weblogicx India http://www.weblogicxindia.com
# copyright Copyright (C) 2014 - 19 Weblogicxindia.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://j2store.org
# Technical Support:  Forum - http://j2store.org/forum/index.html
-------------------------------------------------------------------------*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
require_once(JPATH_ADMINISTRATOR.'/components/com_j2store/library/j2item.php');
require_once(JPATH_SITE.'/components/com_j2store/helpers/cart.php');
require_once (JPATH_ADMINISTRATOR.'/components/com_j2store/library/inventory.php');
$items = $this->cartobj;
//$mysubtotal = J2StoreHelperCart::getSubtotal();
//$state = $this->state;
$quantities = array();
$action = JRoute::_('index.php');
$checkout_url = JRoute::_('index.php?option=com_j2store&view=checkout');
$com_path = JPATH_SITE.'/components/com_content/';
require_once $com_path.'router.php';
require_once $com_path.'helpers/route.php';
$storeAddress = J2StoreHelperCart::getStoreAddress();
if(isset($storeAddress->config_default_category) && $storeAddress->config_default_category != 0) {
	$continue_shopping_url = JRoute::_(ContentHelperRoute::getCategoryRoute($storeAddress->config_default_category));
}

if(isset($storeAddress->config_continue_shopping_url ) && JString::strlen($storeAddress->config_continue_shopping_url ) > 5) {
	$continue_shopping_url = $storeAddress->config_continue_shopping_url;
}
//echo'<pre>';var_dump(count((array)$this->cartobj));die;
?>
<section class="envor-section envor-section-cart">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">

                <p class="incart"><?php echo sprintf(JText::_("TPL_ENVOR_YOUR_CART_TEXT"),count((array)$items));?></p>

                <div class="j2store">
                <div class="row-fluid">
                <div class="span12">
                <?php if(!isset($this->remove)):?>
                	<div id="j2storeCartPopup">
                <?php endif; ?>

                <!-- <div class='componentheading'>
                    <span><?php echo JText::_( "J2STORE_MY_SHOPPING_CART" ); ?></span>
                </div> -->

                <div class="j2store_cartitems">
                    <?php if (!empty($items)) { ?>
                    <form action="<?php echo $action; ?>" method="post" name="adminForm" id="j2store-cart-form" enctype="multipart/form-data">

                        <table id="cart" class="adminlist shoppin-cart-table">
                            <thead>
                                <tr>
                                    <td class="id"><?php echo JText::_( "J2STORE_CART_#" ); ?></td>
                                    <td class="item" style="text-align: left;"><?php echo JText::_( "J2STORE_CART_ITEM" ); ?></td>
                                    <td class="price"><?php echo JText::_( "J2STORE_CART_ITEM_PRICE_TEXT" ); ?></td>
                                    <td class="qty"><?php echo JText::_( "J2STORE_CART_ITEM_QUANTITY" ); ?></td>
                                    <td class="total"><?php echo JText::_( "J2STORE_CART_ITEM_TOTAL" ); ?></td>
                                    <!-- <th><?php echo JText::_( "J2STORE_CART_ITEM_REMOVE" ); ?></th> -->
                                </tr>
                            </thead>
                            <tbody>
                            <?php $i=0; $k=0; $subtotal = 0;?>
                            <?php foreach ($items as $item) : ?>
                            	<?php
                                    //echo '<pre>';var_dump($item);die;
                            		$article = J2StoreItem::getArticle($item->product_id);
                            		$link = ContentHelperRoute::getArticleRoute($article->id, $article->catid, $article->language);
                            		$link = JRoute::_($link);
                            		$image = J2StoreItem::getJ2Image($item->product_id, $this->params);
                            	?>

                                <tr class="row<?php echo $k; ?>">
                                    <td><?php echo $item->product_id;?></td>
                                	<td>
                                        <?php if($this->params->get('show_thumb_cart')) : ?>
                                            <span class="j2store-cart-item-image">
                                                <?php if(!empty($image)) {echo $image; }?>
                                            </span>
                                        <?php endif; ?>
                                        <a href="#"><?php echo $item->product_name; ?></a> <a href="javascript:void(0)" title="<?php echo JText::_( 'J2STORE_CART_REMOVE_ITEM' ); ?>" class="remove" onclick="j2storeCartRemove('<?php echo $item->key; ?>', <?php echo $item->product_id; ?>, 2)"><i class="fa fa-times-circle"></i></a>  
                                            

                                        <br/>

                                        <?php if (!empty($item->product_options)) : ?>
                	                       <?php foreach ($item->product_options as $option) : ?>
                             				   - <small>
                             				   	<?php echo $option->name; ?>: <?php echo (utf8_strlen($option->value) > 20 ? utf8_substr($option->value, 0, 20) . '..' : $option->value); ?>
                             				   	<?php if(isset($option->option_sku) && JString::strlen($option->option_sku) > 0):?>
                             				   		 (<?php echo JText::_('J2STORE_SKU'); ?> : <?php echo $option->option_sku; ?>)
                             				   	<?php endif; ?>
                             				   </small><br />

                            				   <?php endforeach; ?>
                	                    <?php endif; ?>
                	                    <?php if($this->params->get('show_sku_field') && JString::strlen($item->product_model) > 0) : ?>
                	                    	<?php echo JText::_( "J2STORE_SKU" ); ?>: <?php echo $item->product_model; ?>
                	                    <?php endif; ?>
                	                   
                                    </td>
                                    <td>
                                        <span class="price"><?php echo J2StorePrices::number($item->price); ?></span>
                                    </td>
                                    <td style="text-align: center;" class="product_quantity_input">
                                        <?php $type = 'text';
                                       ?>

                                   		<input type="text" name="quantity[<?php echo $item->key; ?>]" value="<?php echo $item->quantity; ?>" size="1" />

                                        <!-- Keep Original quantity to check any update to it when going to checkout -->
                                        <input name="original_quantities[<?php echo $item->key; ?>]" type="hidden" value="<?php echo $item->quantity; ?>" />
                                    </td>
                                    <td>
                                        <?php $subtotal = $subtotal + $item->total; ?>
                                        <span class="total"><?php echo J2StorePrices::number($item->total); ?></span>
                                    </td>
                                    <!-- <td><a href="javascript:void(0)" title="<?php echo JText::_( 'J2STORE_CART_REMOVE_ITEM' ); ?>" onclick="j2storeCartRemove('<?php echo $item->key; ?>', <?php echo $item->product_id; ?>, 2)">
                                    <div class="j2storeCartRemove"> </div>
                                    </a>  </td> -->
                                </tr>
                            <?php ++$i; $k = (1 - $k); ?>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                        <div class="clearfix"></div>
                        <div class="row">
                            <div class="col-lg-4 col-md-4">
                              <?php echo $this->loadTemplate('shipping');?>
                            </div>

                            <div class="col-lg-4 col-md-4">
                              <!-- <h3>Promocode</h3>
                              <p><label for="promocode">Promocode:*</label><input type="text" id="promocode" name="promocode"></p>
                              <p><button class="envor-btn envot-btn-normal envor-btn-secondary">Apply Promo</button></p> -->
                            </div>

                            <div class="col-lg-4 col-md-4">
                              <h3><?php echo JText::_('TPL_ENVOR_ORDER_TOTAL_TEXT');?></h3>
                              <ul class="order-total">
                                <li><?php echo JText::_( "J2STORE_CART_SUBTOTAL" ); ?>: <span><?php echo J2StorePrices::number($this->totals['subtotal']); ?></span></li>
                                <?php if(isset($this->totals['shipping_total'])): ?>
                                <li><?php echo $this->totals['shipping_name']; ?>: <span><?php echo J2StorePrices::number($this->totals['shipping_total']); ?></span></li>
                                <?php endif; ?>
                                <!-- coupon -->

                               <?php if(isset($this->totals['coupon'])): ?>
                                <li><?php echo $this->totals['coupon']['title']; ?>: <span><?php echo J2StorePrices::number($this->totals['coupon']['value']); ?></span> <a href="#" onClick="j2storeCartRemoveCoupon()" ><div class="j2storeCartRemove"> </div></a></li>
                                <?php endif;?>

                                <!-- tax -->
                                <?php if($this->params->get('auto_calculate_tax', 1) && $this->totals['taxes']):?>
                                    <?php
                                        foreach($this->totals['taxes'] as $tax) {
                                            echo '<li>'.$tax['title'].': <span>'.J2StorePrices::number($tax['value']).'</span></li>';
                                        }
                                    ?>
                                 <?php endif; ?>
                                 <!-- total-->
                                <li><strong><?php echo JText::_( "J2STORE_CART_GRANDTOTAL" ); ?>:</strong> <span class="total">
                                        <?php if($this->params->get('auto_calculate_tax', 1)):?>
                                            <?php echo J2StorePrices::number($this->totals['total']);?>
                                        <?php else: ?>
                                            <?php echo J2StorePrices::number($this->totals['total_without_tax']);?>
                                        <?php endif; ?>
                                </span></li>

                              </ul>
                              <p class="no-margin cfl-left">
                                <?php if(isset($continue_shopping_url)):?>
                                    <a class="envor-btn envot-btn-normal envor-btn-default" href="<?php echo $continue_shopping_url; ?>">
                                        <?php echo JText::_('J2STORE_CONTINUE_SHOPPING'); ?>
                                    </a>
                                <?php endif;?>
                                    <input  type="submit" class="j2store_cart_button envor-btn envot-btn-normal envor-btn-secondary" value="<?php echo JText::_('J2STORE_UPDATE_QUANTITIES'); ?>" name="update" />
                                    <a class="checkout_btn envor-btn envot-btn-normal envor-btn-primary" href="<?php echo $checkout_url; ?>"><?php echo JText::_( "J2STORE_BEGIN_CHECKOUT" ); ?></a>
                                </p>
                            </div>
                          </div>

                       <?php echo $this->onJ2StoreAfterDisplayCart;?>

                        <input type="hidden" name="option" value="com_j2store" />
                         <input type="hidden" name="view" value="mycart" />
                        <input type="hidden" name="task" value="update" />
                    </form>
                    <?php if($this->params->get('enable_coupon', 0) && J2STORE_PRO == 1):?>
                	    <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data">
                	    <div class="coupon">
                	    <?php
                	    $coupon = '';
                	    if(JFactory::getSession()->has('coupon', 'j2store')) {
                			$coupon =JFactory::getSession()->get('coupon', '', 'j2store');
                	    }
                	    ?>
                		<input type="text" name="coupon" value="<?php echo $coupon; ?>" />
                		<input type="submit" value="<?php echo JText::_('J2STORE_APPLY_COUPON')?>" class="button btn btn-primary" />
                		<input type="hidden" name="option" value="com_j2store" />
                         <input type="hidden" name="view" value="mycart" />
                	    </div>
                	     </form>
                    <?php endif; ?>
                	<?php echo $this->loadTemplate('calculator'); ?>
                    <?php } else { ?>
                    <p><?php echo JText::_( "J2STORE_NO_ITEMS" ); ?></p>
                    <?php } ?>
                </div>
                </div>
                </div></div>
                </div>

            </div><!-- end col-lg-12 -->
        </div>
    </div>
</section>