<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_users
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JHtml::_('behavior.keepalive');
?>
<section class="envor-section">
	<div class="container">
		<div class="row">
			<div class="col-md-6 col-md-offset-3">

				<div class="login<?php echo $this->pageclass_sfx?>">
					<?php if ($this->params->get('show_page_heading')) : ?>
					<div class="page-header">
						<h1>
							<?php echo $this->escape($this->params->get('page_heading')); ?>
						</h1>
					</div>
					<?php endif; ?>

					<?php if (($this->params->get('logindescription_show') == 1 && str_replace(' ', '', $this->params->get('login_description')) != '') || $this->params->get('login_image') != '') : ?>
					<div class="login-description">
					<?php endif; ?>

						<?php if ($this->params->get('logindescription_show') == 1) : ?>
							<?php echo $this->params->get('login_description'); ?>
						<?php endif; ?>

						<?php if (($this->params->get('login_image') != '')) :?>
							<img src="<?php echo $this->escape($this->params->get('login_image')); ?>" class="login-image" alt="<?php echo JTEXT::_('COM_USER_LOGIN_IMAGE_ALT')?>"/>
						<?php endif; ?>

					<?php if (($this->params->get('logindescription_show') == 1 && str_replace(' ', '', $this->params->get('login_description')) != '') || $this->params->get('login_image') != '') : ?>
					</div>
					<?php endif; ?>

					<form action="<?php echo JRoute::_('index.php?option=com_users&task=user.login'); ?>" method="post" class="form-validate form-vertical well">

						<fieldset>
							<?php foreach ($this->form->getFieldset('credentials') as $field) : ?>
								<?php if (!$field->hidden) : ?>
									<p>
										<?php echo $field->label; ?>
										<?php echo $field->input; ?>
									</p>
								<?php endif; ?>
							<?php endforeach; ?>

							<?php if ($this->tfa): ?>
								<p>
									<label><?php echo $this->form->getField('secretkey')->label; ?></label>
									<?php echo $this->form->getField('secretkey')->input; ?>
								</p>
							<?php endif; ?>

							<?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
							<p>
								<label><?php echo JText::_('COM_USERS_LOGIN_REMEMBER_ME') ?></label>
								<input id="remember" type="checkbox" name="remember" class="inputbox" value="yes"/>
							</p>
							<?php endif; ?>

							<p style="text-align:center; padding:15px 0;">
								<button type="submit" class="envor-btn envor-btn-primary">
									<?php echo JText::_('JLOGIN'); ?>
								</button>
							</p>

							<input type="hidden" name="return" value="<?php echo base64_encode($this->params->get('login_redirect_url', $this->form->getValue('return'))); ?>" />
							<?php echo JHtml::_('form.token'); ?>
						</fieldset>
					</form>
				</div>
				<div>
					<ul class="nav nav-tabs nav-stacked">
						<li>
							<a href="<?php echo JRoute::_('index.php?option=com_users&view=reset'); ?>">
							<?php echo JText::_('COM_USERS_LOGIN_RESET'); ?></a>
						</li>
						<li>
							<a href="<?php echo JRoute::_('index.php?option=com_users&view=remind'); ?>">
							<?php echo JText::_('COM_USERS_LOGIN_REMIND'); ?></a>
						</li>
						<?php
						$usersConfig = JComponentHelper::getParams('com_users');
						if ($usersConfig->get('allowUserRegistration')) : ?>
						<li>
							<a href="<?php echo JRoute::_('index.php?option=com_users&view=registration'); ?>">
								<?php echo JText::_('COM_USERS_LOGIN_REGISTER'); ?></a>
						</li>
						<?php endif; ?>
					</ul>
				</div>

			</div><!-- end col-lg-12 -->
		</div>
	</div>
</section>
