<?php
/**
 * @package Hoxa - Responsive Multipurpose Joomla Template
 * @author Cththemes - www.cththemes.com
 * @date: 01-10-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */

// no direct access
defined('_JEXEC') or die;

?>
<!-- Respond form -->
<h3><?php echo JText::_('TPL_ENVOR_POST_A_COMMENT_TEXT') ?></h3>
<div class="envor-add-comment">
    <!-- Form -->
    <form action="<?php echo JURI::root(); ?>" method="post" id="comment-form" class="form form-blog envor-f1" name="comment-form">
        <?php if($this->params->get('commentsFormNotes')): ?>
        <p class="comment-notes">
            <?php if($this->params->get('commentsFormNotesText')): ?>
            <?php echo nl2br($this->params->get('commentsFormNotesText')); ?>
            <?php else: ?>
            <?php echo JText::_('K2_COMMENT_FORM_NOTES') ?>
            <?php endif; ?>
        </p>
        <?php endif; ?>
        <p>
            <label class="control-label" for="userName"><?php echo JText::_('TPL_ENVOR_YOUR_NAME_TEXT');?></label>
            <input class="comment-input" name="userName" id="userName" type="text" value="" size="30" aria-required="true" />
        </p>
        <p>
            <label class="control-label" for="commentEmail"><?php echo JText::_('TPL_ENVOR_YOUR_EMAIL_TEXT');?></label>
            <input class="comment-input" name="commentEmail" id="commentEmail" type="text" value="" size="30" aria-required="true" />
        </p>
        <p>
            <label class="control-label" for="commentURL"><?php echo JText::_('TPL_ENVOR_YOUR_WEBSITE_TEXT');?></label>
            <input class="comment-input" name="commentURL" id="commentURL" type="text" value="" size="30" />
        </p>  
        <p>
            <label class="control-label" for="commentText"><?php echo JText::_('TPL_ENVOR_YOUR_COMMENT_TEXT');?></label>
            <textarea name="commentText" id="commentText" cols="45" rows="8" aria-required="true"></textarea>
        </p>
        <?php if($this->params->get('recaptcha') && ($this->user->guest || $this->params->get('recaptchaForRegistered', 1))): ?>
        <div class="clearfix"></div>
        <label class="formRecaptcha"><?php echo JText::_('K2_ENTER_THE_TWO_WORDS_YOU_SEE_BELOW'); ?></label>
        <div id="recaptcha"></div>
        <div class="clearfix"></div> 
        <?php endif; ?>
        <p>
            <button name="send" id="submitCommentButton" class="envor-btn envor-btn-normal envor-btn-primary" type="submit"><?php echo JText::_('TPL_ENVOR_SUBMIT_COMMENT_TEXT') ?></button>
        </p>
            
        <p><span id="formLog"></span></p>

        <input type="hidden" name="option" value="com_k2" />
        <input type="hidden" name="view" value="item" />
        <input type="hidden" name="task" value="comment" />
        <input type="hidden" name="itemID" value="<?php echo JRequest::getInt('id'); ?>" />
        <?php echo JHTML::_('form.token'); ?>
    </form>

</div>

