<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_users
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JHtml::_('behavior.keepalive');
JHtml::_('behavior.formvalidation');
?>
<section class="envor-section">
	<div class="container">
		<div class="row">
			<div class="col-md-6 col-md-offset-3">

				<div class="registration<?php echo $this->pageclass_sfx?>">
					<?php if ($this->params->get('show_page_heading')) : ?>
						<div class="page-header">
							<h1><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
						</div>
					<?php endif; ?>

					<form id="member-registration" action="<?php echo JRoute::_('index.php?option=com_users&task=registration.register'); ?>" method="post" class="form-validate form-vertical well" enctype="multipart/form-data">
						<?php foreach ($this->form->getFieldsets() as $fieldset): // Iterate through the form fieldsets and display each one.?>
							<?php $fields = $this->form->getFieldset($fieldset->name);?>
							<?php if (count($fields)):?>
								<fieldset>
								<?php if (isset($fieldset->label)):// If the fieldset has a label set, display it as the legend.?>
									<legend><?php echo JText::_($fieldset->label);?></legend>
								<?php endif;?>
								<?php foreach ($fields as $field) :// Iterate through the fields in the set and display them.?>
									<?php if ($field->hidden):// If the field is hidden, just display the input.?>
										<?php echo $field->input;?>
									<?php else:?>
										<p>
											<?php echo $field->label; ?>
											<?php echo $field->input;?>
										</p>
									<?php endif;?>
								<?php endforeach;?>
								</fieldset>
							<?php endif;?>
						<?php endforeach;?>
						<p style="text-align:center; padding:15px 0;">
							<button type="submit" class="envor-btn envor-btn-primary validate"><?php echo JText::_('JREGISTER');?></button>
								<a class="envor-btn envor-btn-normal" href="<?php echo JRoute::_('');?>" title="<?php echo JText::_('JCANCEL');?>"><?php echo JText::_('JCANCEL');?></a>
						</p>
						<div class="control-group">
							<div class="controls">
								
								<input type="hidden" name="option" value="com_users" />
								<input type="hidden" name="task" value="registration.register" />
							</div>
						</div>
						<?php echo JHtml::_('form.token');?>
					</form>
				</div>

			</div><!-- end col-lg-12 -->
		</div>
	</div>
</section>
