<?php
/**
 * @package Hoxa - Responsive Multipurpose Joomla Template
 * @author Cththemes - www.cththemes.com
 * @date: 01-10-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */

// no direct access
defined('_JEXEC') or die;

?>
<section class="envor-section">
	<div class="container">
		<div class="row">
			<div class="col-md-6 col-md-offset-3">

				<!-- K2 user profile form -->
				<form action="<?php echo JURI::root(true); ?>/index.php" enctype="multipart/form-data" method="post" name="userform" autocomplete="off" class="form-validate">
					<?php if($this->params->def('show_page_title',1)): ?>
					<div class="componentheading<?php echo $this->escape($this->params->get('pageclass_sfx')); ?> page-header">
						<h1><?php echo $this->escape($this->params->get('page_title')); ?></h1>
					</div>
					<?php endif; ?>
					<fieldset>
						<legend><?php echo JText::_('K2_ACCOUNT_DETAILS'); ?></legend>
						<p>
							<label for="username"><?php echo JText::_('K2_USER_NAME'); ?></label>
							<?php echo $this->user->get('username'); ?>
						</p>
						<p>
							<label id="namemsg" for="name"><?php echo JText::_('K2_NAME'); ?></label>
							<input type="text" name="<?php echo $this->nameFieldName; ?>" id="name" size="40" value="<?php echo $this->escape($this->user->get( 'name' )); ?>" class="inputbox required" maxlength="50" />
						</p>
						<p>
							<label id="emailmsg" for="email"><?php echo JText::_('K2_EMAIL'); ?></label>
							<input type="text" id="email" name="<?php echo $this->emailFieldName; ?>" size="40" value="<?php echo $this->escape($this->user->get( 'email' )); ?>" class="inputbox required validate-email" maxlength="100" />
						</p>
						<?php if(version_compare(JVERSION, '2.5', 'ge')): ?>
						<p>
							<label id="email2msg" for="email2"><?php echo JText::_('K2_CONFIRM_EMAIL'); ?> *</label>
							<input type="text" id="email2" name="jform[email2]" size="40" value="<?php echo $this->escape($this->user->get( 'email' )); ?>" class="inputbox required validate-email" maxlength="100" />
						</p>
						<?php endif; ?>
						<p>
							<label id="pwmsg" for="password"><?php echo JText::_('K2_PASSWORD'); ?></label>
							<input class="inputbox validate-password" type="password" id="password" name="<?php echo $this->passwordFieldName; ?>" size="40" value="" />
						</p>
						<p>
							<label id="pw2msg" for="password2"><?php echo JText::_('K2_VERIFY_PASSWORD'); ?></label>
							<input class="inputbox validate-passverify" type="password" id="password2" name="<?php echo $this->passwordVerifyFieldName; ?>" size="40" value="" />
						</p>
						<legend><?php echo JText::_('K2_PERSONAL_DETAILS'); ?></legend>
						<p>
							<label id="gendermsg" for="gender"><?php echo JText::_('K2_GENDER'); ?></label>
						</p>
						<div class="reg-radio">
							<?php echo $this->lists['gender']; ?>
						</div>
						<p>
							<label id="descriptionmsg" for="description"><?php echo JText::_('K2_DESCRIPTION'); ?></label>
							<?php echo $this->editor; ?>
						</p>
						<p>
							<label id="imagemsg" for="image"><?php echo JText::_( 'K2_USER_IMAGE_AVATAR' ); ?></label>
							<input type="file" id="image" name="image"/>
							<?php if ($this->K2User->image): ?>
							<img class="k2AccountPageImage" src="<?php echo JURI::root(true).'/media/k2/users/'.$this->K2User->image; ?>" alt="<?php echo $this->user->name; ?>" />
							<input type="checkbox" name="del_image" id="del_image" />
							<label for="del_image"><?php echo JText::_('K2_CHECK_THIS_BOX_TO_DELETE_CURRENT_IMAGE_OR_JUST_UPLOAD_A_NEW_IMAGE_TO_REPLACE_THE_EXISTING_ONE'); ?></label>
							<?php endif; ?>
						</p>
						<p>
							<label id="urlmsg" for="url"><?php echo JText::_('K2_URL'); ?></label>
							<input type="text" size="50" value="<?php echo $this->K2User->url; ?>" name="url" id="url"/>
						</p>
						<?php if(count(array_filter($this->K2Plugins))): ?>
							<!-- K2 Plugin attached fields -->
							<legend><?php echo JText::_('K2_ADDITIONAL_DETAILS'); ?></legend>

							<?php foreach($this->K2Plugins as $K2Plugin): ?>
								<?php if(!is_null($K2Plugin)): ?>
								<p><?php echo $K2Plugin->fields; ?></p>
								<?php endif; ?>
							<?php endforeach; ?>
						<?php endif; ?>
						<?php if(isset($this->params) && version_compare(JVERSION, '1.6', 'lt')): ?>
							<legend><?php echo JText::_('K2_ADMINISTRATIVE_DETAILS'); ?></legend>
							<p>
								<?php echo $this->params->render('params'); ?>
							</p>
						<?php endif; ?>

						<!-- Joomla! 1.6+ JForm implementation -->
						<?php if(isset($this->form)): ?>
							<?php foreach ($this->form->getFieldsets() as $fieldset): // Iterate through the form fieldsets and display each one.?>
								<?php if($fieldset->name != 'core'): ?>
								<?php $fields = $this->form->getFieldset($fieldset->name);?>
								<?php if (count($fields)):?>
									<?php if (isset($fieldset->label)):// If the fieldset has a label set, display it as the legend.?>
									<legend><?php echo JText::_($fieldset->label);?></legend>
		
									<?php endif;?>
									<?php foreach($fields as $field):// Iterate through the fields in the set and display them.?>
										<?php if ($field->hidden):// If the field is hidden, just display the input.?>
											<p><?php echo $field->input;?></p>
										<?php else:?>
											<p>
												<?php echo $field->label; ?>
												<?php if (!$field->required && $field->type != 'Spacer'): ?>
													<span class="optional"><?php echo JText::_('COM_USERS_OPTIONAL');?></span>
												<?php endif; ?>
												<?php echo $field->input;?>
											</p>
										<?php endif;?>
									<?php endforeach;?>
								<?php endif;?>
								<?php endif; ?>
							<?php endforeach;?>
						<?php endif; ?>

					</fieldset>
					<p style="text-align:center;">
						<button class="button envor-btn envor-btn-primary validate" type="submit" onclick="submitbutton( this.form );return false;">
								<?php echo JText::_('K2_SAVE'); ?>
						</button>
					</p>
					<input type="hidden" name="<?php echo $this->usernameFieldName; ?>" value="<?php echo $this->user->get('username'); ?>" />
					<input type="hidden" name="<?php echo $this->idFieldName; ?>" value="<?php echo $this->user->get('id'); ?>" />
					<input type="hidden" name="gid" value="<?php echo $this->user->get('gid'); ?>" />
					<input type="hidden" name="option" value="<?php echo $this->optionValue; ?>" />
					<input type="hidden" name="task" value="<?php echo $this->taskValue; ?>" />
					<input type="hidden" name="K2UserForm" value="1" />
					<?php echo JHTML::_( 'form.token' ); ?>
				</form>

			</div><!-- end col-lg-12 -->
		</div>
	</div>
</section>