<?php

defined('_JEXEC') or die;
use Joomla\Registry\Registry;
jimport('joomla.application.component.helper');

require_once JPATH_ADMINISTRATOR.'/components/com_azurapagebuilder/helpers/azuraelements.php';

require_once JPATH_ROOT.'/components/com_azurapagebuilder/helpers/elementparser.php';
require_once JPATH_ROOT.'/components/com_azurapagebuilder/helpers/azurajs.php';

class PlgContentAzuracontent extends JPlugin
{
	protected $enable_com_content_builder;
	protected $enable_com_contact_builder;
	protected $enable_com_modules_builder;
	protected $enable_com_azuraportfolio_builder;

    function __construct(&$subject, $config)
    {
        parent::__construct($subject, $config);

		$com_params = JComponentHelper::getParams('com_azurapagebuilder');
		$this->enable_com_content_builder = $com_params->get('com_content_builder','0');
		$this->enable_com_contact_builder = $com_params->get('com_contact_builder','0');
		$this->enable_com_modules_builder = $com_params->get('com_modules_builder','0');
		$this->enable_com_azuraportfolio_builder = $com_params->get('com_azuraportfolio_builder','1');
    }

	public function onContentPrepare($context, &$article, &$params, $page = 0)
	{	

		if( ( $context == 'com_content.article' && $this->enable_com_content_builder == '1' ) || ( $context == 'com_contact.contact' && $this->enable_com_contact_builder == '1' ) || ( $context == 'com_azuraportfolio.portfolio' && $this->enable_com_azuraportfolio_builder == '1' ) || ( $context == 'mod_custom.content' && $this->enable_com_modules_builder == '1' ) ){

			AzuraElements::loadElementsOptions();

			JHtml::_('jquery.framework');

			JHtml::_('stylesheet', 'components/com_azurapagebuilder/assets/css/azp_plugins.min.css');
			JHtml::_('stylesheet', 'components/com_azurapagebuilder/assets/css/azp_elements.min.css');

			AzuraJs::writeStyles();
			AzuraJs::writeJScripts();
			AzuraJs::writeInlineStyles();

			JHtml::_('script', 'components/com_azurapagebuilder/assets/js/azp_front.min.js');

			$shortcode_content = AzuraShortcode::doContentShortcode($article->text);

			if($shortcode_content !='') $article->text = '<div class="azp_page-content-wrap azp_do_shortcode">'.$shortcode_content.'</div>';
		}

		return true;	

	}

}
