<?php 
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;

$classes = array(
    'azp_element',
    'envor-relative envor-latest-news',
    $extraclass,
);


$azpelementstyle = self::buildStyle($azura_attrs);
$animation_data = self::buildAnimation($azura_attrs);

$classes[] = $animation_data['trigger'];
$classes = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $classes ) ) );


if($id != '') $id = 'id="'.$id.'"';

$items = self::getK2Items($category, $limit, $order, $orderdir,'','0');

$additionalData = '';

    $additionalData  .= ' data-selector="envor-post-preview"';

if(!empty($visible)){
    $additionalData  .= ' data-visible="'.$visible.'"';
}
if(!empty($mobilevisible)){
    $additionalData  .= ' data-mobilevisible="'.$mobilevisible.'"';
}

 
?>
<div <?php echo $id;?> class="<?php echo $classes;?>" <?php echo $azpelementstyle.' '.$animation_data['data'].$additionalData;?>>
<?php if($items): ?> 
    <?php foreach ($items as $key => $item) : 
    ?>
    <article class="envor-post-preview envor-padding-left-30">
        <div class="envor-post-preview-inner">
            <div class="header">
                <div class="date">
                    <span class="day"><?php echo JHtml::_('date',$item->created,'d');?></span><span class="month"><?php echo JHtml::_('date',$item->created,'M, y');?></span>
                </div>
                <a href="<?php echo self::getK2ItemLink($item->id,$item->alias,$item->catid,$item->categoryalias);?>"><?php echo $item->title;?></a>
            </div>
            <p><?php echo JHtml::_('string.truncate',strip_tags($item->introtext),150);?></p>
        </div>
    </article>

    <?php endforeach;?>
    <?php if($shownavigation === '1'): ?>
        <?php if($navigationpos === 'left') :?>
        <div class="envor-navigation envor-navigation-left rivaslider-navigation">
            <a href="#" class="back"><i class="glyphicon glyphicon-chevron-left"></i></a>
            <a href="#" class="forward"><i class="glyphicon glyphicon-chevron-right"></i></a>
        </div>
        <?php elseif($navigationpos === 'right') : ?>
        <div class="envor-navigation envor-navigation-right rivaslider-navigation">
            <a href="#" class="back"><i class="glyphicon glyphicon-chevron-left"></i></a>
            <a href="#" class="forward"><i class="glyphicon glyphicon-chevron-right"></i></a>
        </div>
        <?php else :?>
        <div class="envor-navigation rivaslider-navigation">
            <a href="#" class="back"><i class="glyphicon glyphicon-chevron-left"></i></a>
            <a href="#" class="forward"><i class="glyphicon glyphicon-chevron-right"></i></a>
        </div>
        <?php endif;?>
    <?php endif;?>
    

<?php endif;?>
</div>
<?php if($showmore === '1') :?>
    <!-- Link to more projects -->
    <div class="clearfix text-center">
        <br>
        <br>
        <a href="<?php echo self::getK2CategoryLink($category);?>" class="envor-btn envor-btn-primary envor-btn-normal"><?php echo JText::_('TPL_ENVOR_VIEW_MORE_TEXT');?></a>
    </div>
<?php endif;?>
