<?php
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;

require_once JPATH_COMPONENT_ADMINISTRATOR.'/helpers/pages.php';
require_once JPATH_COMPONENT_ADMINISTRATOR.'/helpers/azuraelements.php';
require_once JPATH_COMPONENT_ADMINISTRATOR.'/helpers/awesomefont.php';

class AzuraPagebuilderViewPage extends JViewLegacy
{
	protected $state;

	protected $item;

	protected $form;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->state	= $this->get('State');
		$this->item		= $this->get('Item');
		$this->form		= $this->get('Form');
		//die('this here');
		$this->canDo		= PagesHelper::getActions('com_azurapagebuilder', 'page', $this->item->id);
        
		$this->pageTemplates = $this->get('PageTemplates');
		$this->secTemplates = $this->get('SecTemplates');
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$this->addToolbar();
		parent::display($tpl);
	}


	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);

		$user		= JFactory::getUser();
		$isNew		= ($this->item->id == 0);
		$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $user->get('id'));

		// Since we don't track these assets at the item level, use the category id.
		$canDo		= $this->canDo;

		JToolbarHelper::title(JText::_('Pages Manager: Build Page'), '');

		// If not checked out, can save the item.
		if (!$checkedOut && ($canDo->get('core.edit')||($user->authorise('core.create', 'com_azurapagebuilder'))))
		{
			JToolbarHelper::apply('page.apply');
			JToolbarHelper::save('page.save');
		}
		if (!$checkedOut && ($user->authorise('core.create', 'com_azurapagebuilder')))
		{
			JToolbarHelper::save2new('page.save2new');
		}
		// If an existing item, can save to a copy.
		if (!$isNew && ($user->authorise('core.create', 'com_azurapagebuilder')))
		{
			JToolbarHelper::save2copy('page.save2copy');
		}
		if (empty($this->item->id))
		{
			JToolbarHelper::cancel('page.cancel');
		}
		else
		{
			if ($this->state->params->get('save_history', 0) && $user->authorise('core.edit'))
			{
				JToolbarHelper::versions('com_azurapagebuilder.page', $this->item->id);
			}

			JToolbarHelper::cancel('page.cancel', 'JTOOLBAR_CLOSE');
		}
	}

	protected function getImageBrowserLink(){
		$link = JURI::base().'index.php?option=com_media&amp;view=images&amp;tmpl=component&amp;asset=&amp;author=';
		if(file_exists(JPATH_ADMINISTRATOR . '/components/com_jce/helpers/browser.php')){
			
			require_once(JPATH_ADMINISTRATOR . '/components/com_jce/helpers/browser.php');
			if( class_exists('WFBrowserHelper') && method_exists('WFBrowserHelper','getMediaFieldLink') ){
        		$link = WFBrowserHelper::getMediaFieldLink('', 'images');

        	}
        }

        return $link;

	}

	protected function getIconBrowserLink($layout = ''){
		if($layout != '') {
			$link = JURI::base().'index.php?option=com_azurapagebuilder&amp;view=fonts&amp;tmpl=component&amp;layout='.$layout;
		}else{
			$link = JURI::base().'index.php?option=com_azurapagebuilder&amp;view=fonts&amp;tmpl=component';
		}
		

        return $link;

	}

	protected function getImagesFolder(){
		$form = JForm::getInstance('com_azurapagebuilder.page.folderlist', 'folderlist');
		return $form->getField('imagesfolder')->renderField();
	}

}
