<?php
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;
?>
<div id="elements-list-to-add" style="display: none;">
	<?php
		$eleCats = array();
		if(isset($this->elementsOptions['AzuraColumn'])) unset($this->elementsOptions['AzuraColumn']);
		if(isset($this->elementsOptions['AzuraColumnInner'])) unset($this->elementsOptions['AzuraColumnInner']);
		if(isset($this->elementsOptions['ElementStyleOptions'])) unset($this->elementsOptions['ElementStyleOptions']);
		if(isset($this->elementsOptions['ElementAnimationOptions'])) unset($this->elementsOptions['ElementAnimationOptions']);
		if(isset($this->elementsOptions['ElementResponsiveOptions'])) unset($this->elementsOptions['ElementResponsiveOptions']);
		if(isset($this->elementsOptions['ElementTypographyOptions'])) unset($this->elementsOptions['ElementTypographyOptions']);

		
		foreach ($this->elementsOptions as $key => $ele) { 
			$ele['type'] = $key;
			$ele['attrs'] = (object)array();

			if(isset($ele['showStyleTab'])) unset($ele['showStyleTab']);
			if(isset($ele['showAnimationTab'])) unset($ele['showAnimationTab']);
			if(isset($ele['showResponsiveTab'])) unset($ele['showResponsiveTab']);
			if(isset($ele['showTypographyTab'])) unset($ele['showTypographyTab']);

			$defaultAttr = array(
				'name'=>'Element name',
				'desc'=>'',
				'icon'=>'',
				'category'=>'content',
				'hasownchild'=>'no',
				'childtypename'=>'',
				'childname'=>'Child Element',
				'isownchild'=>'no',
				'ispagesection'=>'no',
				'children'=>array(),
				'attrs'=> (object)array()
			);

			$ele = array_merge($defaultAttr, $ele);
			if(!isset($ele['isownchild']) || $ele['isownchild'] == 'no') $eleCats[] = $ele['category'];
			
		?>

			<div class="azura-element-inlist azura-element <?php echo strtolower(str_replace(" ", "_", $ele['category']));?> <?php echo $ele['type'];?><?php if(isset($ele['isownchild']) && $ele['isownchild'] == 'yes') echo ' isownchild-element'; ?>" data-search="<?php echo strtolower( $ele['name'] );?>" data-type="<?php echo $ele['type'];?>" data-ele='<?php echo json_encode($ele);?>'>
				<div class="azura-element-wrapper azura-element-type-<?php echo $ele['type'];?> azp_admin-clearfix">
				<?php if($ele['icon'] != '') :?>
					<img class="element-icon" src="<?php echo $ele['icon'];?>" alt="<?php echo $ele['name'];?>"  width="50" height="50">
				<?php endif;?>
					<h3><?php echo $ele['name'];?></h3>
					<?php if(!empty($ele['desc'])) :?>
						<span class="element-description"><?php //echo $ele['desc'];?></span>
					<?php endif;?>

				</div>
			</div>
		<?php
		}

	?>
</div>
<!-- Page Elements Modal -->
<div id="azuraPagebuilderModalElement" class="azp_modal fade" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
  <div class="azp_modal-dialog azp_modal-fluid">
    <div class="azp_modal-content">
     	<div class="azp_modal-header">
			<button type="button" class="close" data-dismiss="azpmodal" aria-hidden="true">×</button>
			<h3 id="myLargeModalLabel">Azura Elements</h3>
			<div id="ele_filters" class="button-group elements-filter">
			  	<a class="filter-btn" href="javascript:void(0)" data-filter="*">Show all</a>
			<?php 
			$eleCats = array_unique($eleCats);
			if(count($eleCats)) :
			foreach ($eleCats as $key => $fil) : ?>
			  	<a class="filter-btn" href="javascript:void(0)" data-filter="<?php echo strtolower(str_replace(" ", "_", $fil));?>"><?php echo ucwords($fil);?></a>
			<?php endforeach; endif;?>

				<input class="input-large eles-searchbox" name="search-eles" id="eles-searchbox" type="text" placeholder="Type to search for elements">

			</div>
			
		</div>
		<div class="azp_modal-body azura-elements-body">
			<div id="azura-element-container" class="azura-elements">
				<!-- elements will be added here -->
				
			</div>
		</div>
    </div>
  </div>
</div>

<div class="azp_modal fade" tabindex="-1" role="dialog" id="elementOptionsModal"></div>
<!-- Template Modal -->
<div id="templatesModal" class="azp_modal fade<?php if ( version_compare( JVERSION, '3.4', '>=' ) == 1) echo ' azp_modal-template';?>" tabindex="-1" role="dialog"></div>
<!-- End Template Modal -->