<?php
/**
 * Generate valid PHP code that defines an array of Google Font
 * options and their properties.
 */

// Define directories
$base_dir = dirname( __FILE__ );
$temp_dir = $base_dir . '/';
$dest_dir = $temp_dir;

// Check for JSON file
if ( ! is_file( $temp_dir . 'google_fonts.json' ) ) {
  die( 'File ' . $temp_dir . 'google_fonts.json not found.' );
}

// Get JSON data
$d = file_get_contents( $temp_dir . 'google_fonts.json' );

// Convert to multi-dimensional PHP array
$d2 = (array) json_decode( $d );
//echo'<pre>';var_dump($d2);
$d2 = array_map( function( $a ) {

 	$a =  (array) $a; 

	unset($a['files']);
	unset($a['kind']);
	unset($a['lastModified']);

	return $a;

}, $d2['items'] );

// Convert to valid PHP code and clean up
$d3 = var_export( $d2, true );
$d3 = preg_replace( "/\n +array/", 'array', $d3 );
$d3 = preg_replace( '/ /', "\t", $d3 );
$d3 = preg_replace( "/\t+=>\t+/", ' => ', $d3 );
$d3 = preg_replace( "/array\t+\(/", 'array(', $d3 );
$d3 = preg_replace( "/(\w+)\t/", '\1 ', $d3 );
$d3 = preg_replace( "/(\d+) => '/", "'", $d3 );
$d3 = preg_replace( "/(\d+) => /", "", $d3 );
$d3 = str_replace( "\t\t", "\t", $d3 );
$d3 = str_replace( "\t\t\t\t", "\t\t", $d3 );
$d3 = str_replace( "\t\t\t\t\t", "\t\t\t", $d3 );
//remove unuse elements
// $d3 = array_map( function( $a ) { 
// 	unset($a['items']);
// 	unset($a['kind']);
// 	unset($a['lastModified']);

// 	//echo'<pre>';var_dump($a);

// 	return $a;

// }, $d3 );

//echo'<pre>';var_dump($d3);
// Get timestamp
$date = date( 'c', time() );

// File contents
$file = <<<EOD
<?php
/**
 * @package Make
 */

// Updated: {$date}


// Import the data.
function azura_get_google_fonts_array(){

\$fonts =  {$d3} ;

return \$fonts;

}
EOD;

// Check for destination
if ( ! file_exists( $dest_dir ) ) {
  die( 'Destination directory ' . $dest_dir . ' does not exist.' );
}

// Create/overwrite the file
file_put_contents( $dest_dir . 'google-data.php', $file );

// Done.
exit();