<?php

defined('_JEXEC') or die;

/**
* AzuraElements
*/


class AzuraElements
{
    private static $elementsOptions = array();
    public static function getElementsOptions(){
        return self::$elementsOptions;
        
    }

    public static function loadElementsOptions(){
        $elements = array();

        


        $elements['AzuraRow'] = array(
            'name'=>'Row',
            'category'=>"structure",
            'desc'=>'Create Row/Column layout grid',
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/row.png',

            'hasownchild'=>'yes',
            'childtypename'=>'AzuraColumn',
            'childname'=>'Column',
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'showResponsiveTab'=> false,
            'attrs' => array (
                
                array(
                    'type'=>'text',
                    'param_name'=>'section_title',
                    'label'=>'Section Title',
                    'desc' => "" ,
                    'default'=>'',
                    
                ),
                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Section Introtext (Can be use with html tags.)',
                    'desc' => "" ,
                    'default'=>'',
                    'iscontent'=>'yes'
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'title_align',
                    'label'=>'Section Title Alignment',
                    'desc' => "" ,
                    'default'=>'setleft',
                    "value" => array(   
                        'Left' => 'setleft',  
                        'Center' => 'setcenter',                                                                                
                        'Right' => 'setright',                                                                                
                    ),
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'fullwidth',
                    'label'=>'Content width',
                    'desc' => "" ,
                    'default'=>'1',
                    "value" => array(   
                        'Fluid width' => '1',  
                        'Fixed width' => '0',                                                                                
                    ),
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'sec_width',
                    'label'=>'Section Width',
                    'desc' => "Use Default for template content width" ,
                    'default'=>'default',
                    "value" => array(   
                        'Default' => 'default',  
                        'Fullscreen width' => 'fullscreen',                                                                                
                    ),
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'is_fullheight',
                    'label'=>'Is Fullscreen height',
                    'desc' => "" ,
                    'default'=>'0',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',                                                                                
                    ),
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'equal_height',
                    'label'=>'Equal height',
                    'desc' => "Set this option to Yes if you want to set columns equal height." ,
                    'default'=>'0',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',                                                                                
                    ),
                ),


                array(
                    'type'=>'switch',
                    'param_name'=>'use_parallax',
                    'label'=>'Use Parallax',
                    'desc' => "" ,
                    'default'=>'0',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',                                                                                
                    ),
                ),

                array(
                    'type'          =>'image',
                    'param_name'    =>'parallax_image',
                    'label'         =>'Parallax Image',
                    'desc'          => "If no image is selected, parallax will use background image from Style tab." ,
                    'default'       =>'',
                    "depends_on"         => array(   
                        'element'   => 'use_parallax',  
                        'value'     => array('1'),                                                                                
                        'has_value' => false,                                                                                
                    ),
                ),

                array(
                    'type'          =>'text',
                    'param_name'    =>'parallax_value',
                    'label'         =>'Parallax Value',
                    'desc'          => "Pixel number. Which we are telling the browser is to move Parallax Image down every time we scroll down 100% of the viewport height and move Parallax Image up every time we scroll up 100% of the viewport height. Ex: 300 or -300 for reverse direction." ,
                    'default'       =>'300',
                    'rgba'          => true,
                    "depends_on"         => array(   
                        'element'   => 'use_parallax',  
                        'value'     => array('1'),                                                                                
                        'has_value' => false,                                                                                
                    ),
                ),

                array(
                    'type'          =>'color',
                    'param_name'    =>'overlay_color',
                    'label'         =>'Overlay Color',
                    'desc'          => "" ,
                    'default'       =>'',
                    'rgba'          => true,
                    "depends_on"         => array(   
                        'element'   => 'use_parallax',  
                        'value'     => array('1'),                                                                                
                        'has_value' => false,                                                                                
                    ),
                ),
                
                array(
                    'type'=>'select',
                    'param_name'=>'column_gap',
                    'label'=>'Columns gap',
                    'desc' => "Gap between columns." ,
                    'default'=>'30',
                    "value" => array(   
                        '0px' => '0',                                                                               
                        '1px' => '1',                                                                               
                        '2px' => '2',                                                                               
                        '3px' => '3',                                                                               
                        '4px' => '4',                                                                               
                        '5px' => '5',                                                                               
                        '10px' => '10',                                                                               
                        '15px' => '15',                                                                               
                        '20px' => '20',                                                                               
                        '25px' => '25',                                                                               
                        '30px' => '30',                                                                               
                        '35px' => '35',                                                                               
                        '40px' => '40',                                                                               
                        '45px' => '45',                                                                               
                        '50px' => '50',                                                                               
                    ),
                ),

                array(
                    'type'          =>'text',
                    'param_name'    =>'el_id',
                    'label'         =>'Section ID',
                    'desc'          => "" ,
                    'default'       =>'',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                ),
            )
        );

        $elements['AzuraRowInner'] = array(
            'name'=>'Row Inner',
            'desc'=>'Create Row/Column layout grid in parent column element',
            'category'=>"structure",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/row.png',
            'hasownchild'=>'yes',
            'childtypename'=>'AzuraColumnInner',
            'childname'=>'Column Inner',
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'showResponsiveTab'=> false,
            'attrs' => array (
                array(
                    'type'=>'select',
                    'param_name'=>'column_gap',
                    'label'=>'Columns gap',
                    'desc' => "Gap between columns." ,
                    'default'=>'30',
                    "value" => array(   
                        '0px' => '0',                                                                               
                        '1px' => '1',                                                                               
                        '2px' => '2',                                                                               
                        '3px' => '3',                                                                               
                        '4px' => '4',                                                                               
                        '5px' => '5',                                                                               
                        '10px' => '10',                                                                               
                        '15px' => '15',                                                                               
                        '20px' => '20',                                                                               
                        '25px' => '25',                                                                               
                        '30px' => '30',                                                                               
                        '35px' => '35',                                                                               
                        '40px' => '40',                                                                               
                        '45px' => '45',                                                                               
                        '50px' => '50',                                                                               
                    ),
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'equal_height',
                    'label'=>'Equal height',
                    'desc' => "Set this option to Yes if you want to set columns equal height." ,
                    'default'=>'0',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',                                                                                
                    ),
                ),
                
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Row ID',
                    'desc' => "" ,
                    'default'=>'',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,

                    'default'=>'',
                ),
            )
        );

        $elements['AzuraColumn'] = array(
            'name'=>'Column',
            'category'=>"forrow",
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'showResponsiveTab'=> true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,

                    'default'=>''
                ),
                
            )
        );
        $elements['AzuraColumnInner'] = array(
            'name'=>'Column Inner',
            'category'=>"forrowinner",
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'showResponsiveTab'=> true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,

                    'default'=>''
                ),
                
            )
        );
        $elements['AzuraContainer'] = array(
            'name'=>'Container',
            'desc'=>'Create wrapper in parent column element',
            'category'=>"structure",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/container.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'showResponsiveTab'=> false,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,

                    'default'=>''
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'wraptag',
                    'label'=>'Wrapper Tag',
                    'desc' => "" ,
                    'default'=>'div',
                    'value'=> array(
                        'div'=>'div',
                        'section'=>'section',
                        'article'=>'article',
                        'aside'=>'aside',
                        'ul'=>'ul',
                    )
                ),
                
            )
        );

        $elements['azp_textblock'] = array(
            'name'=>'Text Block',
            'desc'=>'A block of text with WYSIWYG editor',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/text-block.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                array(
                    'type'=>'editor',
                    
                    'param_name'=>'content',
                    'label'=>'Content',
                    'show_in_admin' => true,
                    'desc' => "Text Content (Can be used with HTML tags)" ,
                    'default'=>'<h3>Back End Page Builder</h3><p>Build a responsive website and manage your content easily with super fast back-end builder. No programming knowledge required – create stunning and beautiful pages with drag and drop builder.</p>',
                    'iscontent'=>'yes'
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,

                    'default'=>''
                ),
                
            )
        );

        

        $elements['AzuraTinyMce'] = array(
            'name'=>'Tiny MCE',
            'desc'=>'A block of text with TinyMCE editor',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/tinymce.png', 
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showAnimationTab'=>true,
            'attrs' => array (
                array(
                    'type'=>'tinymce',
                    
                    'param_name'=>'content',
                    'label'=>'Content',
                    'desc' => "Content. Select Tools -> Source Code to view the code." ,
                    'default'=>'Content. Select Tools -> Source Code to view the code.',
                    'iscontent'=>'yes',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,

                    'default'=>''
                ),
                
            )
        );

        $elements['AzuraSeparator'] = array(
            'name'=>'Separator',
            'desc'=>'Horizontal separator line',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/separator.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'attrs' => array (
                array(
                    'type'=>'select',
                    'param_name'=>'bd_style',
                    'label'=>'Border Style',
                    'desc' => "" ,
                    'default'=>'solid',
                    'value'=> array(
                        'Border'=>'solid',
                        'Dashed'=>'dashed',
                        'Dotted'=>'dotted',
                        'Double'=>'double'
                    )
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'alignment',
                    'label'=>'Alignment',
                    'desc' => "" ,
                    'default'=>'center',
                    'value'=> array(
                        'Center'=>'center',
                        'Left'=>'left',
                        'Right'=>'right',
                    )
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'bd_width',
                    'label'=>'Border Width',
                    'desc' => "" ,
                    'default'=>'5px',
                    'value'=> array(
                        '1px'=>'1px',
                        '2px'=>'2px',
                        '3px'=>'3px',
                        '4px'=>'4px',
                        '5px'=>'5px',
                        '6px'=>'6px',
                        '7px'=>'7px',
                        '8px'=>'8px',
                        '9px'=>'9px',
                        '10px'=>'10px',
                    )
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'el_width',
                    'label'=>'Element width',
                    'desc' => "Separator element width in percent" ,
                    'default'=>'70',
                    'value'=> array(
                        '100%'=>'100',
                        '90%'=>'90',
                        '80%'=>'80',
                        '70%'=>'70',
                        '60%'=>'60',
                        '50%'=>'50',
                        '40%'=>'40',
                        '30%'=>'30',
                        '20%'=>'20',
                        '10%'=>'10',
                    )
                ),
                array(
                    'type'=>'color',
                    'param_name'=>'color',
                    'label'=>'Separator Color',
                    'desc' => "Default: #e8e8e8" ,
                    'default'=>'',
                    
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
                
            )
        );

        $elements['AzuraSeparatorText'] = array(
            'name'=>'Separator with text',
            'desc'=>'Horizontal separator line with heading',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/separator-text.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showTypographyTab'=> true,
            'showAnimationTab'=>true,
            'attrs' => array (
                array(
                    'type'=>'select',
                    'param_name'=>'title_type',
                    'label'=>'Title Type',
                    'desc' => "" ,
                    'default'=>'text',
                    'value'=> array(
                        'Text'=>'text',
                        'Icon'=>'icon',
                        'Image'=>'image',
                    )
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'title',
                    'label'=>'Title',
                    'desc' => "" ,
                    'default'=>'Title',
                    'depends_on'=> array(
                        'element'=>'title_type',
                        'value' => array('text'),
                        'has_value'=> false
                    ),
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'icon_type',
                    'label'=>"Icon library",
                    'desc' => "Select icon library." ,
                    'default'=>'fontawesome',
                    'value'=> array(
                        'Font Awesome'=>'fontawesome',
                        'Line icon'=>'lineicon',
                        'Simple Line icon'=>'simplelineicon',
                        'ET Line icon'=>'etlineicon',
                    ),
                    'depends_on'=> array(
                        'element'=>'title_type',
                        'value' => array('icon'),
                        'has_value'=> false
                    )
                    
                ),

                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_fontawesome',
                    'label'=>"Icon",
                    'desc' => "Awesome font icon" ,
                    'default'=>'fa fa-download',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('fontawesome'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'lineicon',
                    'param_name'=>'icon_lineicon',
                    'label'=>"Icon",
                    'desc' => "Line icon",
                    'default'=>'azp_lineicon azp_lineicon-download',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('lineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'simplelineicon',
                    'param_name'=>'icon_simplelineicon',
                    'label'=>"Icon",
                    'desc' => "Simple Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('simplelineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'etlineicon',
                    'param_name'=>'icon_etlineicon',
                    'label'=>"Icon",
                    'desc' => "ET Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('etlineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'image',
                    'param_name'=>'title_img',
                    'label'=>'Image',
                    'desc' => "" ,
                    'default'=>'',
                    'depends_on'=> array(
                        'element'=>'title_type',
                        'value' => array('image'),
                        'has_value'=> false
                    )
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'title_pos',
                    'label'=>'Title Position',
                    'desc' => "" ,
                    'default'=>'right',
                    'value'=> array(
                        'Left'=>'left',
                        'Center'=>'center',
                        'Right'=>'right',
                    )
                ),
                

                array(
                    'type'=>'select',
                    'param_name'=>'bd_style',
                    'label'=>'Border Style',
                    'desc' => "" ,
                    'default'=>'solid',
                    'value'=> array(
                        'Border'=>'solid',
                        'Dashed'=>'dashed',
                        'Dotted'=>'dotted',
                        'Double'=>'double'
                    )
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'alignment',
                    'label'=>'Alignment',
                    'desc' => "" ,
                    'default'=>'left',
                    'value'=> array(
                        'Center'=>'center',
                        'Left'=>'left',
                        'Right'=>'right',
                    )
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'bd_width',
                    'label'=>'Border Width',
                    'desc' => "" ,
                    'default'=>'5px',
                    'value'=> array(
                        '1px'=>'1px',
                        '2px'=>'2px',
                        '3px'=>'3px',
                        '4px'=>'4px',
                        '5px'=>'5px',
                        '6px'=>'6px',
                        '7px'=>'7px',
                        '8px'=>'8px',
                        '9px'=>'9px',
                        '10px'=>'10px',
                    )
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'el_width',
                    'label'=>'Element width',
                    'desc' => "Separator element width in percent" ,
                    'default'=>'70',
                    'value'=> array(
                        '100%'=>'100',
                        '90%'=>'90',
                        '80%'=>'80',
                        '70%'=>'70',
                        '60%'=>'60',
                        '50%'=>'50',
                        '40%'=>'40',
                        '30%'=>'30',
                        '20%'=>'20',
                        '10%'=>'10',
                    )
                ),
                array(
                    'type'=>'color',
                    'param_name'=>'color',
                    'label'=>'Separator Color',
                    'desc' => "Default: #e8e8e8" ,
                    'default'=>'',
                    
                ),
                array(
                    'type'=>'color',
                    'param_name'=>'title_color',
                    'label'=>'Title Color',
                    'desc' => "Default: #000000" ,
                    'default'=>'',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),

                
            )
        );

        $elements['AzuraAlert'] = array(
            'name'=>'Alert Box',
            'desc'=>'Notification box',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/alert.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showTypographyTab'=> true,
            'showAnimationTab'=>true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'title',
                    'label'=>'Title',
                    'show_in_admin' => true,
                    'desc' => "" ,
                    'default'=>'Success',
                    
                ),

                array(
                    'type'=>'textarea',
                    
                    'param_name'=>'content',
                    'label'=>'Message',
                    'desc' => "" ,
                    'default'=>'You successfully read this important alert message',
                    'show_in_admin' => true,
                    'iscontent'=>'yes'
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'type',
                    'label'=>'Alert Type',
                    'desc' => "" ,
                    'default'=>'success',
                    'value'=> array(
                        'Success'=>'success',
                        'Info'=>'info',
                        'Warning'=>'warning',
                        'Error'=>'danger',
                    )
                    
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'closebtn',
                    'label'=>'Close Button',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),
                array(
                    'type'=>'animationselector',
                    'param_name'=>'closeeffect',
                    'label'=>'Close effect',
                    'desc' => "" ,
                    'default'=>'bounceOut',
                    "value" => array(   

                        'bounceOut' => 'bounceOut',
                        'bounceOutDown' => 'bounceOutDown',
                        'bounceOutLeft' => 'bounceOutLeft',
                        'bounceOutRight' => 'bounceOutRight',
                        'bounceOutUp' => 'bounceOutUp',
                        'fadeOut' => 'fadeOut',
                        'fadeOutDown' => 'fadeOutDown',
                        'fadeOutDownBig' => 'fadeOutDownBig',
                        'fadeOutLeft' => 'fadeOutLeft',
                        'fadeOutLeftBig' => 'fadeOutLeftBig',
                        'fadeOutRight' => 'fadeOutRight',
                        'fadeOutRightBig' => 'fadeOutRightBig',
                        'fadeOutUp' => 'fadeOutUp',
                        'fadeOutUpBig' => 'fadeOutUpBig',
                        'flipOutX' => 'flipOutX',
                        'flipOutY' => 'flipOutY',
                        'lightSpeedOut' => 'lightSpeedOut',
                        'rotateOut' => 'rotateOut',
                        'rotateOutDownLeft' => 'rotateOutDownLeft',
                        'rotateOutDownRight' => 'rotateOutDownRight',
                        'rotateOutUpLeft' => 'rotateOutUpLeft',
                        'rotateOutUpRight' => 'rotateOutUpRight',
                        'rollOut' => 'rollOut',
                        'zoomOut' => 'zoomOut',
                        'zoomOutDown' => 'zoomOutDown',
                        'zoomOutLeft' => 'zoomOutLeft',
                        'zoomOutRight' => 'zoomOutRight',
                        'zoomOutUp' => 'zoomOutUp',
                        'slideOutDown' => 'slideOutDown',
                        'slideOutLeft' => 'slideOutLeft',
                        'slideOutRight' => 'slideOutRight',
                        'slideOutUp' => 'slideOutUp',
                    ),
                    'depends_on'=> array(
                        'element'=> 'closebtn',
                        'value' => array('1'),
                        'has_value'=> false
                    )
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'icon_type',
                    'label'=>"Icon library",
                    'desc' => "Select icon library." ,
                    'default'=>'fontawesome',
                    'value'=> array(
                        'Font Awesome'=>'fontawesome',
                        'Line icon'=>'lineicon',
                        'Simple Line icon'=>'simplelineicon',
                        'ET Line icon'=>'etlineicon',
                    ),
                    
                ),

                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_fontawesome',
                    'label'=>"Icon",
                    'desc' => "Awesome font icon" ,
                    'default'=>'fa fa-check',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('fontawesome'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'lineicon',
                    'param_name'=>'icon_lineicon',
                    'label'=>"Icon",
                    'desc' => "Line icon",
                    'default'=>'azp_lineicon-happy',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('lineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'simplelineicon',
                    'param_name'=>'icon_simplelineicon',
                    'label'=>"Icon",
                    'desc' => "Simple Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('simplelineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'etlineicon',
                    'param_name'=>'icon_etlineicon',
                    'label'=>"Icon",
                    'desc' => "ET Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('etlineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                
                array(
                    'type'=>'text',
                    
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
                
                
            )
        );
        $elements['AzuraFacebook'] = array(
            'name'=>'Facebook Page',
            'desc'=>'Facebook Page Plugin. More details: https://developers.facebook.com/docs/plugins/page-plugin',
            'category'=>"social",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/facebook.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showAnimationTab'=> true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'href',
                    'label'=>'Facebook Page URL',
                    'desc' => "The URL of the Facebook Page. Leave this empty for current page." ,
                    'default'=>'https://www.facebook.com/facebook',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'width',
                    'label'=>'Plugin Width',
                    'desc' => "The pixel width of the plugin. Min. is 180 & Max. is 500" ,
                    'default'=>'340',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'height',
                    'label'=>'Plugin Height',
                    'desc' => "The pixel height of the plugin. Min. is 70" ,
                    'default'=>'500',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'tabs',
                    'label'=>'Tabs',
                    'desc' => "Tabs to render i.e. timeline, events, messages. Use a comma-separated list to add multiple tabs, i.e. timeline, events." ,
                    'default'=>'timeline',
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'hide_cover',
                    'label'=>"Hide Cover Photo",
                    'desc' => "Hide cover photo in the header" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'small_header',
                    'label'=>"Use Small Header",
                    'desc' => "Use the small header instead" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'show_facepile',
                    'label'=>"Show Friend's Faces",
                    'desc' => "Show profile photos when friends like this" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'hide_cta',
                    'label'=>"Hide Call to action button",
                    'desc' => "Hide the custom call to action button (if available)" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'adapt_container_width',
                    'label'=>"Adapt to plugin container width",
                    'desc' => "Try to fit inside the container width" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),

                array(
                    'type'=>'text',
                    
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                    
                ),
                

                array(
                    'type'=>'text',
                    
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
 
           
                
            )
        );
        
        $elements['AzuraFacebookShare'] = array(
            'name'=>'Facebook Share',
            'desc'=>'Facebook share button',
            'category'=>"social",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/facebook.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showAnimationTab'=> true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'href',
                    'label'=>'Url to like',
                    'desc' => "Enter Url to like and share. Leave this empty for current page." ,
                    'default'=>'https://developers.facebook.com/docs/plugins/',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'layout',
                    'label'=>'Layout',
                    'desc' => "Select a layout" ,
                    'default'=>'icon_link',
                    'value'=> array(
                        'Default'=>'icon_link',
                        'Button Count'=>'button_count',
                        'Box Count'=>'box_count',
                        'Button'=>'button',

                    )
                    
                ),
                
                array(
                    'type'=>'select',
                    'param_name'=>'size',
                    'label'=>'Button Size',
                    'desc' => "" ,
                    'default'=>'small',
                    'value'=> array(
                        'Small'=>'small',
                        'Large'=>'large',
                    )
                    
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'mobile_iframe',
                    'label'=>"Mobile Iframe",
                    'desc' => "Show the share dialog in an iframe on mobile" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),

                array(
                    'type'=>'text',
                    
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
 
           
                
            )
        );

        $elements['AzuraFacebookLike'] = array(
            'name'=>'Facebook Like',
            'desc'=>'Facebook like button',
            'category'=>"social",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/facebook.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showAnimationTab'=> true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'href',
                    'label'=>'Url to like',
                    'desc' => "Enter Url to like and share. Leave this empty for current page." ,
                    'default'=>'https://developers.facebook.com/docs/plugins/',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'layout',
                    'label'=>'Layout',
                    'desc' => "Select a layout" ,
                    'default'=>'standard',
                    'value'=> array(
                        'Standard'=>'standard',
                        'Button Count'=>'button_count',
                        'Box Count'=>'box_count',
                        'Button'=>'button',

                    )
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'action',
                    'label'=>'Action Type',
                    'desc' => "Action" ,
                    'default'=>'like',
                    'value'=> array(
                        'Like'=>'like',
                        'Recommend'=>'recommend',
                    )
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'size',
                    'label'=>'Button Size',
                    'desc' => "" ,
                    'default'=>'small',
                    'value'=> array(
                        'Small'=>'small',
                        'Large'=>'large',
                    )
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'width',
                    'label'=>'Plugin Width',
                    'desc' => "The width of the plugin (standard layout only), which is subject to the minimum and default width." ,
                    'default'=>'',
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'show_face',
                    'label'=>"Show friend's face",
                    'desc' => "Show friend's face" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),
                array(
                    'type'=>'switch',
                    
                    'param_name'=>'show_share',
                    'label'=>"Share button",
                    'desc' => "Include a share button beside the Like button" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),
                
                array(
                    'type'=>'select',
                    
                    'param_name'=>'color_scheme',
                    'label'=>"Color Scheme",
                    'desc' => "The color scheme used by the plugin for any text outside of the button itself." ,
                    'default'=>'light',
                    'value'=> array(
                        'Light'=>'light',
                        'Dark'=>'dark',
                    )
                    
                ),

                array(
                    'type'=>'text',
                    
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
 
           
                
            )
        );

        $elements['AzuraTwitterShare'] = array(
            'name'=>'Tweet Button',
            'desc'=>'Button to share your content on Twitter',
            'category'=>"social",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/twitter.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showAnimationTab'=>true,
            'attrs' => array (

                array(
                    'type'=>'text',
                    'param_name'=>'url',
                    'label'=>'Url to tweet',
                    'desc' => "An absolute HTTP or HTTPS URL to be shared on Twitter" ,
                    'default'=>'',
                    'show_in_admin' => true,
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'via',
                    'label'=>'Via name',
                    'desc' => 'This text will appear in a Tweet as ” via @username”' ,
                    'default'=>'',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'related',
                    'label'=>'Related',
                    'desc' => "" ,
                    'default'=>'',
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'hashtags',
                    'label'=>'Hashtags',
                    'desc' => "Add a comma-separated list of hashtags to a Tweet using the hashtags parameter." ,
                    'default'=>'',
                    
                ),

                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Tweet Text',
                    'desc' => "Leave empty to use site title text." ,
                    'default'=>'Check out our new version of Azura - Joomla Page Builder at',
                    'iscontent'=>'yes'
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'size',
                    'label'=>'Button Size',
                    'desc' => "" ,
                    'default'=>'default',
                    'value'=> array(
                        'Default'=>'default',
                        'Large'=>'large',
                    )
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'btn_name',
                    'label'=>'Button Name',
                    'desc' => "" ,
                    'default'=>'Tweet',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
                
                
            )
        );

        $elements['AzuraTweets'] = array(
            'name'=>'Twitter Feeds',
            'desc'=>'Twitter Feeds',
            'category'=>"social",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/twitter.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showTypographyTab'=> true,
            'showAnimationTab'=>true,
            'attrs' => array (
                
                array(
                    'type'=>'text',
                    'param_name'=>'twittername',
                    'label'=>'Twitter Name',
                    'desc' => "The Twitter screen name of the user for whom to return results." ,
                    'default'=>'CTHthemes',
                    'show_in_admin' => true,
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'count',
                    'label'=>'Tweets Count',
                    'desc' => "Number of tweets" ,
                    'default'=>'3',
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'layout',
                    'label'=>'Layout',
                    'desc' => "" ,
                    'default'=>'list',
                    'value'=> array(
                        'List'=>'list',
                        'Slider'=>'slider',
                    )
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'list_ticker',
                    'label'=>'Is Ticker List',
                    'desc' => "" ,
                    'default'=>'ticker_slide',
                    'value'=> array(
                        'Fade Ticket'=>'ticker_fade',
                        'Slide Ticker'=>'ticker_slide',
                        'No'=>'no',
                    ),
                    'depends_on'=>array(
                        'element'=>'layout',
                        'value' => array('list'),
                        'has_value' => false
                    )
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'show_nav',
                    'label'=>'Show Navigation',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    ),
                    'depends_on'=>array(
                        'element'=>'layout',
                        'value' => array('slider'),
                        'has_value' => false
                    )
                    
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'show_pagi',
                    'label'=>'Show Pagination',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    ),
                    'depends_on'=>array(
                        'element'=>'layout',
                        'value' => array('slider'),
                        'has_value' => false
                    )
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'autoheight',
                    'label'=>'Auto Height',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    ),
                    'depends_on'=>array(
                        'element'=>'layout',
                        'value' => array('slider'),
                        'has_value' => false
                    )
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'transition',
                    'label'=>'Slider Transition',
                    'desc' => "" ,
                    'default'=>'slide',
                    'value'=> array(
                        'Slide'=>'slide',
                        'Fade'=>'fade',
                    ),
                    'depends_on'=>array(
                        'element'=>'layout',
                        'value' => array('slider'),
                        'has_value' => false
                    )
                    
                ),


                array(
                    'type'=>'label',
                    'param_name'=>'twitter_app_keys',
                    'label'=>'<strong>Twitter App Keys</strong>',
                    'desc'=>'You must enter your Twitter App keys to <strong>Tweets Feed</strong> tab on <a href="'.JUri::base().'index.php?option=com_config&view=component&component=com_azurapagebuilder&path=" target="_blank">Azura Component Options</a> page.'
                ),


                
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
                
            )
        );
        $elements['AzuraGooglePlus'] = array(
            'name'=>'Google+ Button',
            'desc'=>'Recommend on Google',
            'category'=>"social",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/google-plus.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showAnimationTab'=>true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'url',
                    'label'=>'Url to share',
                    'desc' => "An absolute HTTP or HTTPS URL to be shared on Google+" ,
                    'default'=>'',
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'size',
                    'label'=>"Button Size",
                    'desc' => "" ,
                    'default'=>'standard',
                    'value'=> array(
                        
                        'Small'=>'small',
                        'Medium'=>'medium',
                        'Standard'=>'standard',
                        'Tall'=>'tall',
                    )
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'annotation',
                    'label'=>"Annotation",
                    'desc' => "Button Annotation" ,
                    'default'=>'bubble',
                    'value'=> array(
                        
                        'Bubble'=>'bubble',
                        'Inline'=>'inline',
                        'None'=>'none',
                    )
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
                
            )
        );

        $elements['AzuraPinterest'] = array(
            'name'=>'Pinterest',
            'desc'=>'Pinterest button',
            'category'=>"social",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/pinterest.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showAnimationTab'=>true,
            'attrs' => array (

                array(
                    'type'=>'text',
                    'param_name'=>'url',
                    'label'=>'Url to pin',
                    'desc' => "URL of the page where the image is" ,
                    'default'=>'',
                    'show_in_admin' => true,
                    
                ),
                array(
                    'type'=>'image',
                    'param_name'=>'media',
                    'label'=>'Image URL',
                    'desc' => "This attribute is added individually to images on your page." ,
                    'default'=>'',
                    
                ),
                array(
                    'type'=>'textarea',
                    'param_name'=>'desc',
                    'label'=>'Image Description',
                    'desc' => "Leave empty to use Page title." ,
                    'default'=>'',
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'shape',
                    'label'=>"Shape",
                    'desc' => "" ,
                    'default'=>'rect',
                    'value'=> array(
                        'Rectangular'=>'rect',
                        'Round'=>'round',
                    )
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'size',
                    'label'=>"Button size",
                    'desc' => "" ,
                    'default'=>'small',
                    'value'=> array(
                        'Large'=>'large',
                        'Small'=>'small',
                    )
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'annotation',
                    'label'=>"Count Position",
                    'desc' => "" ,
                    'default'=>'above',
                    'value'=> array(
                        
                        'Above'=>'above',
                        'Beside'=>'beside',
                        'None'=>'none',
                    )
                    
                ),
                

                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
                
            )
        );

        $elements['AzuraImage'] = array(
            'name'=>'Single Image',
            'desc'=>'',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/image.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showAnimationTab'=>true,
            'attrs' => array (
                array(
                    'type'=>'image',
                    'param_name'=>'image_url',
                    'label'=>'Image Source',
                    'desc' => "" ,
                    'default'=>'',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'alttext',
                    'label'=>'Alt Text',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'image_style',
                    'label'=>"Image Style",
                    'desc' => "" ,
                    'default'=>'default',
                    'value'=> array(
                        'Default'=>'default',
                        'Circle'=>'circle',
                        'Thumbnail'=>'thumbnail',
                        // 'Thumbnail with content' => 'withcontent'
                    )
                    
                ),

                
                array(
                    'type'=>'select',
                    'param_name'=>'click_action',
                    'label'=>"Click action",
                    'desc' => "Select action for user click." ,
                    'default'=>'none',
                    'value'=> array(
                        'None'=>'none',
                        'Open popup'=>'lightbox',
                        'Open modal'=>'modal',
                        'Open link'=>'link',
                    )
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'modal_id',
                    'label'=>'Modal ID',
                    'desc' => "Enter your modal ID here to open it." ,
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'click_action',
                        'value' => array('modal'),
                        'has_value' => false,
                    ),
                ),
                array(
                    'type'=>'image',
                    'param_name'=>'large_image',
                    'label'=>'Popup image or video',
                    'desc' => "Large Image or Youtube, Vimeo, Soundcloud link for light box. Leave empty to use default." ,
                    'default'=>'',
                    'depends_on'=> array(
                        'element'=> 'click_action',
                        'value'=> array('lightbox'),
                        'has_value' => false,
                    ),
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'image_link',
                    'label'=>'Image Link',
                    'desc' => "" ,
                    'default'=>'#',
                    'depends_on'=> array(
                        'element'=> 'click_action',
                        'value'=> array('link'),
                        'has_value' => false,
                    ),
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'link_target',
                    'label'=>"Open link in",
                    'desc' => "" ,
                    'default'=>'_blank',
                    'value'=> array(
                        'New tab'=>'_blank',
                        'Current tab'=>'_self',
                    ),
                    'depends_on'=> array(
                        'element'=> 'image_link',
                        'value'=> array(),
                        'has_value' => true,
                    ),
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),

                
            )
        );

        $elements['AzuraGallery'] = array(
            'name'=>'Image Gallery',
            'desc'=>'Responsive image gallery',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/gallery.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showAnimationTab'=>true,
            'attrs' => array (

                array(
                    'type'=>'images',
                    'param_name'=>'content',
                    'label'=>'Select a folder then click to images to use',
                    'desc' => "" ,
                    'default'=>'',
                    'iscontent'=>'yes',
                    'image_attrs'=>array(
                        'Alt text'=> array(
                                        'type'=>'text',
                                        'desc' => 'Image alt text'
                                    ),
                        'Filters'=>   array(
                                        'type'=>'text',
                                        'desc' => 'Separated with | character. Ex: Web|Graphic'
                                    ),
                        'Caption'=> array(
                                        'type'=>'textarea',
                                        'desc' => 'Image caption text'
                                    ),
                    ), // define image attr with its field type. text and texarea are allowed and do not allowed SRC for attribute name
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'filters_text',
                    'label'=>'Filter Texts',
                    'desc' => "Separated with <strong>|</strong> character. Ex: \"Web|Graphic|Logo|App\". Each image can have one or more filter texts in its Filters field." ,
                    'default'=>''
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'filter_all',
                    'label'=>"Show All in filter",
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'loaded',
                    'label'=>'First Load items',
                    'desc' => "Number of images you want to display in the first load. Should be maller than your total images number to use INFINITE scroll option bellow." ,
                    'default'=>'10'
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'show_loadmore',
                    'label'=>"Use INFINITE scroll load more items?",
                    'desc' => "Images will automatically load and adding when you scroll to the bottom." ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'lmore_items',
                    'label'=>'Load more items',
                    'desc' => "Number of images you want to get in the next loadings." ,
                    'default'=>'3',
                    'depends_on'=> array(
                        'element'=> 'show_loadmore',
                        'value'=> array('1'),
                        'has_value' => false,
                    ),
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'columns',
                    'label'=>"Columns Grid",
                    'desc' => "" ,
                    
                    'value'=> array(
                        'One Column'=>'one',
                        'Two Columns'=>'two',
                        'Three Columns'=>'three',
                        'Four Columns'=>'four',
                        'Five Columns'=>'five',
                        'Six Columns'=>'six',
                        'Seven Columns'=>'seven',
                        'Eight Columns'=>'eight',
                        'Nine Columns'=>'nine',
                        'Ten Columns'=>'ten',
                    ),
                    'default'=>'three',
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'tablet_columns',
                    'label'=>"Tablet Columns Grid",
                    'desc' => "" ,
                    
                    'value'=> array(
                        'One Column'=>'one',
                        'Two Columns'=>'two',
                        'Three Columns'=>'three',
                        'Four Columns'=>'four',
                        'Five Columns'=>'five',
                        'Six Columns'=>'six',
                        'Seven Columns'=>'seven',
                        'Eight Columns'=>'eight',
                        'Nine Columns'=>'nine',
                        'Ten Columns'=>'ten',
                    ),
                    'default'=>'two',
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'mobile_columns',
                    'label'=>"Mobile Columns Grid",
                    'desc' => "" ,
                    
                    'value'=> array(
                        'One Column'=>'one',
                        'Two Columns'=>'two',
                        'Three Columns'=>'three',
                        'Four Columns'=>'four',
                        'Five Columns'=>'five',
                        'Six Columns'=>'six',
                        'Seven Columns'=>'seven',
                        'Eight Columns'=>'eight',
                        'Nine Columns'=>'nine',
                        'Ten Columns'=>'ten',
                    ),
                    'default'=>'one',
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'spacing',
                    'label'=>"Spacing",
                    'desc' => "" ,
                    'value'=> array(
                        'None'=>'one',
                        'Two Columns'=>'none',
                        'Extra Small'=>'extrasmall',
                        'Small'=>'small',
                        'Medium'=>'medium',
                        'Big'=>'big',
                    ),
                    'default'=>'big',
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'caption_style',
                    'label'=>"Caption Style",
                    'desc' => "" ,
                    'value'=> array(
                        'ZoomIn'=> 'capZoomIn', 
                        'ZoomInDown' => 'capZoomInDown', 
                        'RollIn' => 'capRollIn', 
                        'RotateIn' => 'capRotateIn', 
                        'BounceOut' => 'capBounceOut', 
                    ),
                    'default'=>'capBounceOut',
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'enable_gallery',
                    'label'=>"Enable Gallery",
                    'desc' => "Use popup gallery items instead of single image popup." ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),


                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>''
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
                
            )
        );

        // $elements['AzuraGalleryItem'] = array(
        //     'name'=>'Gallery Item',
        //     'desc'=>'',
        //     'isownchild'=>'yes',
        //     'showStyleTab'=>false,
        //     'showAnimationTab'=>false,
        //     'attrs' => array (


        //         array(
        //             'type'=>'image',
        //             'param_name'=>'slideimage',
        //             'label'=>'Image Source',
        //             'desc' => "" ,
        //             'default'=>'',
        //         ),
        //         array(
        //             'type'=>'text',
        //             'param_name'=>'alttext',
        //             'label'=>'Alt Text',
        //             'desc' => "" ,
        //             'default'=>'',
        //         ),
                
        //         array(
        //             'type'=>'switch',
        //             'param_name'=>'usepretty',
        //             'label'=>"Use PrettyPhoto",
        //             'desc' => "Use PrettyPhoto plugin to show large image" ,
        //             'default'=>'0',
        //             'value'=> array(
        //                 'Yes'=>'1',
        //                 'No'=>'0',
        //             )
                    
        //         ),
        //         array(
        //             'type'=>'image',
        //             'param_name'=>'largeimage',
        //             'label'=>'Large Image',
        //             'desc' => "Full Size Image (Or Youtube and Vimeo video link)" ,
        //             'default'=>'',
        //             'depends_on'=> array(
        //                 'element'=> 'usepretty',
        //                 'value'=> array('1'),
        //                 'has_value' => false,
        //             ),
        //         ),
        //         array(
        //             'type'=>'text',
        //             'param_name'=>'imagelink',
        //             'label'=>'Image Link',
        //             'desc' => "" ,
        //             'default'=>'',
        //             'depends_on'=> array(
        //                 'element'=> 'usepretty',
        //                 'value'=> array('0'),
        //                 'has_value' => false,
        //             ),
        //         ),
        //         array(
        //             'type'=>'text',
        //             'param_name'=>'gallery',
        //             'label'=>'Gallery Rel',
        //             'desc' => "Gallery Rel (Leave empty if want open image in prettyPhoto as single photo)" ,
        //             'default'=>'gallery',
        //         ),
        //         array(
        //             'type'=>'select',
        //             'param_name'=>'gridwidth',
        //             'label'=>"Grid width",
        //             'desc' => "" ,
        //             'default'=>'20',
        //             'value'=> array(
        //                 'Ten columns'=>'10',
        //                 'Five columns'=>'20',
        //                 'Four columns'=>'25',
        //                 'Three columns'=>'33.33',
        //                 'Two columns'=>'50',
        //                 'One column'=>'100',
        //             )
                    
        //         ),

        //         array(
        //             'type'=>'text',
        //             'param_name'=>'extraclass',
        //             'label'=>'Extra Class',
        //             'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
        //             'default'=>'',
                    
        //         ),
                
        //     )
        // );

        $elements['AzuraCarousel'] = array(
            'name'=>'Carousel',
            'desc'=>'With multiple images selected',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/image-carousel.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showTypographyTab'=> true,
            'showAnimationTab'=>true,
            'attrs' => array (
                
                array(
                    'type'=>'images',
                    'param_name'=>'content',
                    'label'=>'Select a folder then click to images to use',
                    'desc' => "" ,
                    'default'=>'',
                    'iscontent'=>'yes',
                    'image_attrs'=>array(
                        'Alt text'=> array(
                                        'type'=>'text',
                                        'desc' => 'Image alt text'
                                    ),
                        'Title'=>   array(
                                        'type'=>'text',
                                        'desc' => 'Image title text'
                                    ),
                        'Caption'=> array(
                                        'type'=>'textarea',
                                        'desc' => 'Image caption text'
                                    ),
                    ), // define image attr with its field type. text and texarea are allowed and do not allowed SRC for attribute name
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'interval',
                    'label'=>'Interval',
                    'desc' => "The amount of time (miliseconds) to delay between automatically cycling an item. If false, carousel will not automatically cycle." ,
                    'default'=>'5000',
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'pause',
                    'label'=>'Pause on hover',
                    'desc' => "Pauses the cycling of the carousel on mouseenter and resumes the cycling of the carousel on mouseleave." ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'loop',
                    'label'=>"Loop",
                    'desc' => "Whether the carousel should cycle continuously or have hard stops." ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),
                // array(
                //     'type'=>'switch',
                //     'param_name'=>'keyboard',
                //     'label'=>"Keyboard",
                //     'desc' => "Whether the carousel should react to keyboard events." ,
                //     'default'=>'1',
                //     'value'=> array(
                //         'Yes'=>'1',
                //         'No'=>'0',
                //     )
                    
                // ),

                array(
                    'type'=>'switch',
                    'param_name'=>'show_nav',
                    'label'=>"Show Navigation",
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'show_pagi',
                    'label'=>"Show Pagination",
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Slider ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,

                    'default'=>'',
                ),
                
            )
        );

        $elements['AzuraBsCarousel'] = array(
            'name'=>'Carousel Pro',
            'desc'=>'Animated carousel with images',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/carousel-pro.png',
            'open_settings_on_create'=>true,
            'hasownchild'=>"yes",
            'childname'=>"Carousel Item",
            'childtypename'=>"AzuraBsCarouselItem",
            'showStyleTab'=>true,
            'showTypographyTab'=> true,
            'showAnimationTab'=>true,
            'attrs' => array (
                
                
                array(
                    'type'=>'text',
                    'param_name'=>'interval',
                    'label'=>'Interval',
                    'desc' => "The amount of time (miliseconds) to delay between automatically cycling an item. If false, carousel will not automatically cycle." ,
                    'default'=>'5000',
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'pause',
                    'label'=>'Pause on hover',
                    'desc' => "Pauses the cycling of the carousel on mouseenter and resumes the cycling of the carousel on mouseleave." ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'loop',
                    'label'=>"Loop",
                    'desc' => "Whether the carousel should cycle continuously or have hard stops." ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),
                // array(
                //     'type'=>'switch',
                //     'param_name'=>'keyboard',
                //     'label'=>"Keyboard",
                //     'desc' => "Whether the carousel should react to keyboard events." ,
                //     'default'=>'1',
                //     'value'=> array(
                //         'Yes'=>'1',
                //         'No'=>'0',
                //     )
                    
                // ),

                array(
                    'type'=>'switch',
                    'param_name'=>'show_nav',
                    'label'=>"Show Navigation",
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'show_pagi',
                    'label'=>"Show Pagination",
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Slider ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,

                    'default'=>'',
                ),
                
            )
        );
        $elements['AzuraBsCarouselItem'] = array(
            'name'=>"Carousel Item",
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/carousel-pro-item.png',
            'open_settings_on_create'=>true,
            'isownchild' => 'yes',
            'showStyleTab'=> true,
            'attrs' => array (
                array(
                    'type'=>'image',
                    'param_name'=>'image',
                    'label'=>'Image Source',
                    'desc' => "" ,
                    'default'=>'',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'alttext',
                    'label'=>'Image Alt Text',
                    'desc' => "" ,
                    'default'=>'',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'title',
                    'label'=>'Title',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Caption',
                    'desc' => "" ,
                    'default'=>'',
                    'iscontent'=>'yes',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Slide Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        $elements['AzuraTabs'] = array(
            'name'=>'Tabs',
            'desc'=>'Tabbed content',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/tabs.png',
            'open_settings_on_create'=>true,
            'hasownchild'=>"yes",
            'childname'=>"Tab Item",
            'childtypename'=>"AzuraTabsItem",
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'showResponsiveTab'=> false,
            'attrs' => array (
                
                array(
                    'type'=>'text',
                    'param_name'=>'defaultactive',
                    'label'=>'Active Tab',
                    'desc' => "Tab which open by default. 1 - for first item" ,
                    'default'=>'1'
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'tabstyle',
                    'label'=>'Tab Style',
                    'desc' => "" ,
                    'default'=>'default',
                    'value'=> array(
                        'Style 1'=>'default',
                        'Style 2'=>'style2',
                        'Style 3'=>'style3',
                    ),
                    
                ),
                array(
                    'type'=>'hidden',
                    'param_name'=>'usejustified',
                    'label'=>'Justified Tabs',
                    'desc' => "" ,
                    'default'=>'1',
                    
                ),
                array(
                    'type'=>'hidden',
                    'param_name'=>'fade',
                    'label'=>'Use Fade Effect',
                    'desc' => "" ,
                    'default'=>'1',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );


        $elements['AzuraTabsItem'] = array(
            'name'=>"Tab Item",
            'category'=>"forparent_tabs",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/tabs.png',
            'open_settings_on_create'=>true,
            'isownchild' => 'yes',
            'showStyleTab'=> false,
            'showAnimationTab'=> false,
            'showResponsiveTab'=> false,
            'attrs' => array (
                
                array(
                    'type'=>'text',
                    'param_name'=>'title',
                    'label'=>'Title',
                    'desc' => "" ,
                    'default'=>'Tab title',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_awesome',
                    'label'=>'Button Icon',
                    'desc' => "" ,
                    'default'=>'fa fa-cogs',
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'icon_position',
                    'label'=>"Icon position",
                    'desc' => "" ,
                    'default'=>'before',
                    'value'=> array(
                        'Before title'=>'before',
                        'After title'=>'after',
                    ),
                    'depends_on' => array(
                        'element' => 'icon_awesome',
                        'value' => array(),
                        'has_value' => true,
                    ),
                    
                ),
                array(
                    'type'=>'editor',
                    'param_name'=>'content',
                    'label'=>'Content',
                    'desc' => "" ,
                    'default'=>'<p>Eu vel reque eripuit sanctus. Mei ei erant soleat percipitur. Eam ipsum feugait eu, nec vero verear aliquid ex eripuit sanctus. </p>',
                    'iscontent'=>'yes',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
            )
        );

        // $elements['AzuraTour'] = array(
        //     'name'=>'Tour',
        //     'desc'=>'Vertical tabbed content',
        //     'category'=>"content",
        //     'hasownchild'=>"yes",
        //     'childname'=>"Tour Item",
        //     'childtypename'=>"AzuraTabsItem",
        //     'showStyleTab'=> true,
        //     'showAnimationTab'=> true,
        //     'showResponsiveTab'=> false,
        //     'attrs' => array (
        //         array(
        //             'type'=>'text',
        //             'param_name'=>'id',
        //             'label'=>'ID',
        //             'desc' => "" ,
        //             'default'=>''
        //         ),
                
        //         array(
        //             'type'=>'text',
        //             'param_name'=>'class',
        //             'label'=>'Class',
        //             'desc' => "" ,
        //             'default'=>'accordion'
        //         ),
        //         array(
        //             'type'=>'text',
        //             'param_name'=>'defaultactive',
        //             'label'=>'Active Tab',
        //             'desc' => "Tab which open by default. 1 - for first item" ,
        //             'default'=>'1'
        //         ),
        //         array(
        //             'type'=>'hidden',
        //             'param_name'=>'tabstyle',
        //             'label'=>'Style',
        //             'desc' => "" ,
        //             'default'=>'tab',
                    
        //         ),
        //         array(
        //             'type'=>'hidden',
        //             'param_name'=>'usejustified',
        //             'label'=>'Justified Tabs',
        //             'desc' => "" ,
        //             'default'=>'1',
                    
        //         ),
        //         array(
        //             'type'=>'hidden',
        //             'param_name'=>'fade',
        //             'label'=>'Use Fade Effect',
        //             'desc' => "" ,
        //             'default'=>'1',
                    
        //         ),
                
        //     )
        // );


        // $elements['AzuraTourItem'] = array(
        //     'name'=>"Tour Item",
        //     'category'=>"forparent_tour",
        //     'isownchild' => 'yes',
        //     'showStyleTab'=> false,
        //     'showAnimationTab'=> false,
        //     'showResponsiveTab'=> false,
        //     'attrs' => array (
        //         array(
        //             'type'=>'text',
        //             'param_name'=>'id',
        //             'label'=>'ID',
        //             'desc' => "" ,
        //             'default'=>''
        //         ),
        //         array(
        //             'type'=>'text',
        //             'param_name'=>'class',
        //             'label'=>'Extra Class',
        //             'desc' => "" ,
        //             'default'=>''
        //         ),
        //         array(
        //             'type'=>'text',
        //             'param_name'=>'title',
        //             'label'=>'Title',
        //             'desc' => "" ,
        //             'default'=>''
        //         ),
        //         array(
        //             'type'=>'editor',
        //             'param_name'=>'ttContent',
        //             'label'=>'Content',
        //             'desc' => "" ,
        //             'default'=>'',
        //             'iscontent'=>'yes'
        //         ),
                
        //     )
        // );

        $elements['AzuraAccordion'] = array(
            'name'=>'Accordion',
            'desc'=>'Collapsible content panels',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/accordion.png',
            'open_settings_on_create'=>true,
            'hasownchild'=>"yes",
            'childname'=>"Accordion Item",
            'childtypename'=>"AzuraAccordionItem",
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'showResponsiveTab'=> false,
            'attrs' => array (
                
                array(
                    'type'=>'text',
                    'param_name'=>'defaultactive',
                    'label'=>'Active Tab',
                    'desc' => "Tab which open by default. 1 - for first item" ,
                    'default'=>'1'
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'acctype',
                    'label'=>'Type',
                    'desc' => "" ,
                    'default'=>'accordion',
                    'value'=> array(
                        'Accordion'=>'accordion',
                        'Toggle'=>'toggle',
                    )
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        $elements['AzuraAccordionItem'] = array(
            'name'=>"Accordion Item",
            'category'=>"forparent_accordion",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/accordion.png',
            'open_settings_on_create'=>true,
            'isownchild' => 'yes',
            'showStyleTab'=> false,
            'showAnimationTab'=> false,
            'showResponsiveTab'=> false,


            'attrs' => array (
                
                array(
                    'type'=>'text',
                    'param_name'=>'title',
                    'label'=>'Title',
                    'desc' => "" ,
                    'default'=>'Tab title',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_awesome',
                    'label'=>'Button Icon',
                    'desc' => "" ,
                    'default'=>'fa fa-cogs',
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'icon_position',
                    'label'=>"Icon position",
                    'desc' => "" ,
                    'default'=>'before',
                    'value'=> array(
                        'Before title'=>'before',
                        'After title'=>'after',
                    ),
                    'depends_on' => array(
                        'element' => 'icon_awesome',
                        'value' => array(),
                        'has_value' => true,
                    ),
                    
                ),
                array(
                    'type'=>'editor',
                    'param_name'=>'content',
                    'label'=>'Item Content (Can be use with html tags.)',
                    'desc' => "" ,
                    'default'=>'<p>Eu vel reque eripuit sanctus. Mei ei erant soleat percipitur. Eam ipsum feugait eu, nec vero verear aliquid ex eripuit sanctus. </p>',
                    'iscontent'=>'yes',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        $elements['AzuraCounter'] = array(
            'name'=>'Animated Counter',
            'desc'=>'',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/counter.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                array(
                    'type'=>'select',
                    'param_name'=>'counter_style',
                    'label'=>"Counter style",
                    'desc' => "" ,
                    'default'=>'flat',
                    'value'=> array(
                        'Boxed'=>'boxed',
                        'Flat'=>'flat',
                        
                    ),
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'number',
                    'label'=>'Number',
                    'desc' => "" ,
                    'default'=>'100',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'duration',
                    'label'=>'Duration',
                    'desc' => "Miliseconds number determining how long the animation will run." ,
                    'default'=>'400'
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'icon_type',
                    'label'=>"Icon library",
                    'desc' => "Select icon library." ,
                    'default'=>'fontawesome',
                    'value'=> array(
                        'Font Awesome'=>'fontawesome',
                        'Line icon'=>'lineicon',
                        'Simple Line icon'=>'simplelineicon',
                        'ET Line icon'=>'etlineicon',
                    ),
                    
                ),

                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_fontawesome',
                    'label'=>"Icon",
                    'desc' => "Awesome font icon" ,
                    'default'=>'fa fa-download',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('fontawesome'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'lineicon',
                    'param_name'=>'icon_lineicon',
                    'label'=>"Icon",
                    'desc' => "Line icon",
                    'default'=>'azp_lineicon azp_lineicon-download',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('lineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'simplelineicon',
                    'param_name'=>'icon_simplelineicon',
                    'label'=>"Icon",
                    'desc' => "Simple Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('simplelineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'etlineicon',
                    'param_name'=>'icon_etlineicon',
                    'label'=>"Icon",
                    'desc' => "ET Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('etlineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Content',
                    'desc' => "" ,
                    'default'=>'<p>Download</p>',
                    'iscontent'=>'yes'
                ),

                // array(
                //     'type'=>'text',
                //     'param_name'=>'el_id',
                //     'label'=>'ID',
                //     'desc' => "" ,
                //     'default'=>''
                // ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        $elements['AzuraIcon'] = array(
            'name'=>'Styled Icon',
            'desc'=>'',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/icon.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                

                array(
                    'type'=>'select',
                    'param_name'=>'icon_type',
                    'label'=>"Icon library",
                    'desc' => "Select icon library." ,
                    'default'=>'fontawesome',
                    'value'=> array(
                        'Font Awesome'=>'fontawesome',
                        'Line icon'=>'lineicon',
                        'Simple Line icon'=>'simplelineicon',
                        'ET Line icon'=>'etlineicon',
                    ),

                    
                ),

                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_fontawesome',
                    'label'=>"Icon",
                    'desc' => "Awesome font icon" ,
                    'default'=>'fa fa-download',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('fontawesome'),
                        'has_value' => false,
                    ),
                    'show_in_admin' => true,
                    
                ),

                array(
                    'type'=>'lineicon',
                    'param_name'=>'icon_lineicon',
                    'label'=>"Icon",
                    'desc' => "Line icon",
                    'default'=>'azp_lineicon azp_lineicon-download',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('lineicon'),
                        'has_value' => false,
                    ),
                    'show_in_admin' => true,
                    
                ),
                array(
                    'type'=>'simplelineicon',
                    'param_name'=>'icon_simplelineicon',
                    'label'=>"Icon",
                    'desc' => "Simple Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('simplelineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'etlineicon',
                    'param_name'=>'icon_etlineicon',
                    'label'=>"Icon",
                    'desc' => "ET Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('etlineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'icon_style',
                    'label'=>"Icon style",
                    'desc' => "" ,
                    'default'=>'default',
                    'value'=> array(
                        'Default'=>'default',
                        'Circle'=>'circle',
                        'Square'=>'square',
                        
                    ),
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'is_bordered',
                    'label'=>'Is bordered?',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    ),
                    'depends_on' => array(
                        'element' => 'icon_style',
                        'value' => array('circle','square'),
                        'has_value' => false,
                    ),
                ),

                array(
                    'type'=>'color',
                    'param_name'=>'icon_color',
                    'label'=>'Color',
                    'desc' => "" ,
                    'default'=>'',
                    //'rgba'=> true
                    
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        $elements['AzuraIconbox'] = array(
            'name'=>'Icon box',
            'desc'=>'',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/icon-box.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                
                

                array(
                    'type'=>'text',
                    'param_name'=>'title',
                    'label'=>'Title',
                    'desc' => "" ,
                    'default'=>'Responsive design',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'icon_type',
                    'label'=>"Icon library",
                    'desc' => "Select icon library." ,
                    'default'=>'fontawesome',
                    'value'=> array(
                        'Font Awesome'=>'fontawesome',
                        'Line icon'=>'lineicon',
                        'Simple Line icon'=>'simplelineicon',
                        'ET Line icon'=>'etlineicon',
                    ),
                    
                ),

                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_fontawesome',
                    'label'=>"Icon",
                    'desc' => "Awesome font icon" ,
                    'default'=>'fa fa-laptop',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('fontawesome'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'lineicon',
                    'param_name'=>'icon_lineicon',
                    'label'=>"Icon",
                    'desc' => "Line icon",
                    'default'=>'azp_lineicon azp_lineicon-laptop',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('lineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'simplelineicon',
                    'param_name'=>'icon_simplelineicon',
                    'label'=>"Icon",
                    'desc' => "Simple Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('simplelineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'etlineicon',
                    'param_name'=>'icon_etlineicon',
                    'label'=>"Icon",
                    'desc' => "ET Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('etlineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'editor',
                    'param_name'=>'content',
                    'label'=>'Content',
                    'desc' => "" ,
                    'default'=>'<p>Omnesque atomorum, pro integre nibh sale meis eam cu. Ut vim modus zril, ex cum erat dictas urbanitas pertinacia eu eum. Usu in ullum omnesque atomoru pro integre imperdiet in. Saperet perpetua ut mei, nibh sale meis eam cu omnium gloriatur te mei ex blandit.</p>',
                    'iscontent'=>'yes',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'iconbox_style',
                    'label'=>"Icon style",
                    'desc' => "" ,
                    'default'=>'style1',
                    'value'=> array(
                        'Boxed'=>'style1',
                        'Color Box'=>'style2',
                        'Icon Overlay'=>'style3',
                        
                    ),
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'icon_align',
                    'label'=>"Icon Alignment",
                    'desc' => "" ,
                    'default'=>'setleft',
                    'value'=> array(
                        'Left'=>'setleft',
                        'Center'=>'centered',
                        'Right'=>'setright',
                        
                    ),
                    'depends_on' => array(
                        'element' => 'iconbox_style',
                        'value' => array('style1'),
                        'has_value'=> false
                    ),
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'is_shadow',
                    'label'=>'Is Shadow Boxed?',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    ),
                    'depends_on' => array(
                        'element' => 'iconbox_style',
                        'value' => array('style1'),
                        'has_value' => false,
                    ),
                ),

                array(
                    'type'=>'color',
                    'param_name'=>'icon_color',
                    'label'=>'Background Color',
                    'desc' => "" ,
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'iconbox_style',
                        'value' => array('style2'),
                        'has_value' => false,
                    ),
                ),

                
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),

                
                
            )
        );


        $elements['AzuraIcontext'] = array(
            'name'=>'Icon with text',
            'desc'=>'',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/icon-text.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                
                

                array(
                    'type'=>'text',
                    'param_name'=>'title',
                    'label'=>'Title',
                    'desc' => "" ,
                    'default'=>'Responsive design',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'icon_type',
                    'label'=>"Icon library",
                    'desc' => "Select icon library." ,
                    'default'=>'fontawesome',
                    'value'=> array(
                        'Font Awesome'=>'fontawesome',
                        'Line icon'=>'lineicon',
                        'Simple Line icon'=>'simplelineicon',
                        'ET Line icon'=>'etlineicon',
                    ),
                    
                ),

                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_fontawesome',
                    'label'=>"Icon",
                    'desc' => "Awesome font icon" ,
                    'default'=>'fa fa-laptop',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('fontawesome'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'lineicon',
                    'param_name'=>'icon_lineicon',
                    'label'=>"Icon",
                    'desc' => "Line icon",
                    'default'=>'azp_lineicon azp_lineicon-laptop',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('lineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'simplelineicon',
                    'param_name'=>'icon_simplelineicon',
                    'label'=>"Icon",
                    'desc' => "Simple Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('simplelineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'etlineicon',
                    'param_name'=>'icon_etlineicon',
                    'label'=>"Icon",
                    'desc' => "ET Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('etlineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'icon_align',
                    'label'=>"Icon Alignment",
                    'desc' => "" ,
                    'default'=>'setleft',
                    'value'=> array(
                        'Left'=>'setleft',
                        'Center'=>'centered',
                        'Right'=>'setright',
                        
                    ),
    
                    
                ),

                array(
                    'type'=>'color',
                    'param_name'=>'icon_color',
                    'label'=>'Icon Color',
                    'desc' => "" ,
                    'default'=>'',
                    
                ),

                array(
                    'type'=>'editor',
                    'param_name'=>'content',
                    'label'=>'Content',
                    'desc' => "" ,
                    'default'=>'<p>Omnesque atomorum, pro integre nibh sale meis eam cu. Ut vim modus zril, ex cum erat dictas urbanitas pertinacia eu eum. Usu in ullum omnesque atomoru pro integre imperdiet in. Saperet perpetua ut mei, nibh sale meis eam cu omnium gloriatur te mei ex blandit.</p>',
                    'iscontent'=>'yes',
                    'show_in_admin' => true,
                ),


                


                

                
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),

                
                
            )
        );
    
                
        $elements['AzuraArticleView'] = array(
            'name'=>'Single Article',
            'desc'=>'Single Joomla Article view',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/article.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showTypographyTab'=> true,
            'showAnimationTab'=>true,
            'attrs' => array (
                array(
                    'type'=>'article',
                    'param_name'=>'id',
                    'label'=>'Select an article',
                    'desc' => "" ,
                    'default'=>'',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showthumbnail',
                    'label'=>'Show Thumbnail',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showtitle',
                    'label'=>'Show title',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showdate',
                    'label'=>'Show Created Date',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showauthor',
                    'label'=>'Show Author',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showcat',
                    'label'=>'Show category',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'showtags',
                    'label'=>'Show tags',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'showintrotext',
                    'label'=>'Show Introtext',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showredmore',
                    'label'=>'Show Read more',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label' => "Extra Class" ,
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                ),

            )
        );

        $elements['AzuraArticlesGrid'] = array(
            'name'=>'Articles Grid',
            'desc'=>'Articles in grid view',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/articles-grid.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showTypographyTab'=> true,
            'showAnimationTab'=>true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'article_ids',
                    'label'=>'Article IDs',
                    'desc' => "Enter article ids to show, separated by a comma (,). Ex: 99,100 " ,
                    'default'=>'',
                    'show_in_admin' => true,
                ),
                
                array(
                    'type'=>'sqlselect',
                    'param_name'=>'category',
                    'label'=>'Or select a category',
                    'desc' => "Choose category get items from",
                    'default'=>'',

                    'query'=>"SELECT id AS value, title AS category FROM #__categories WHERE extension='com_content' AND published=1",
                    'titlekey'=>'category',
                    'valuekey'=>'value',
                    'show_in_admin' => true,

                ),
                array(
                    'type'=>'text',
                    'param_name'=>'limit',
                    'label'=>'Limit (for category source only)',
                    'desc' => "Number or All " ,
                    'default'=>'',
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'order',
                    'label'=>'Order (for category source only)',
                    'desc' => "" ,
                    'default'=>'created',
                    'value'=> array(
                        'Created'=>'created',
                        'ID'=>'id',
                        'Ordering'=>'ordering',
                    )
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'orderdir',
                    'label'=>'Sort Order (for category source only)',
                    'desc' => "" ,
                    'default'=>'DESC',
                    'value'=> array(
                        'Ascending'=>'ASC',
                        'Descending'=>'DESC',
                    )
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'columns',
                    'label'=>"Columns Grid",
                    'desc' => "" ,
                    
                    'value'=> array(
                        'One Column'=>'one',
                        'Two Columns'=>'two',
                        'Three Columns'=>'three',
                        'Four Columns'=>'four',
                        'Five Columns'=>'five',
                        'Six Columns'=>'six',
                        'Seven Columns'=>'seven',
                        'Eight Columns'=>'eight',
                        'Nine Columns'=>'nine',
                        'Ten Columns'=>'ten',
                    ),
                    'default'=>'three',
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'tablet_columns',
                    'label'=>"Tablet Columns Grid",
                    'desc' => "" ,
                    
                    'value'=> array(
                        'One Column'=>'one',
                        'Two Columns'=>'two',
                        'Three Columns'=>'three',
                        'Four Columns'=>'four',
                        'Five Columns'=>'five',
                        'Six Columns'=>'six',
                        'Seven Columns'=>'seven',
                        'Eight Columns'=>'eight',
                        'Nine Columns'=>'nine',
                        'Ten Columns'=>'ten',
                    ),
                    'default'=>'two',
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'mobile_columns',
                    'label'=>"Mobile Columns Grid",
                    'desc' => "" ,
                    
                    'value'=> array(
                        'One Column'=>'one',
                        'Two Columns'=>'two',
                        'Three Columns'=>'three',
                        'Four Columns'=>'four',
                        'Five Columns'=>'five',
                        'Six Columns'=>'six',
                        'Seven Columns'=>'seven',
                        'Eight Columns'=>'eight',
                        'Nine Columns'=>'nine',
                        'Ten Columns'=>'ten',
                    ),
                    'default'=>'one',
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'spacing',
                    'label'=>"Spacing",
                    'desc' => "" ,
                    'value'=> array(
                        'None'=>'one',
                        'Two Columns'=>'none',
                        'Extra Small'=>'extrasmall',
                        'Small'=>'small',
                        'Medium'=>'medium',
                        'Big'=>'big',
                    ),
                    'default'=>'big',
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'showfilter',
                    'label'=>"Show Tags filter",
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'filter_all',
                    'label'=>"Show All in filter",
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    ),
                    'depends_on'=> array(
                        'element'=>'showfilter',
                        'value' => array('1'),
                        'has_value'=> false
                    )
                    
                ),


                array(
                    'type'=>'switch',
                    'param_name'=>'showthumbnail',
                    'label'=>'Show Thumbnail',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showtitle',
                    'label'=>'Show title',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showdate',
                    'label'=>'Show Created Date',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showauthor',
                    'label'=>'Show Author',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showcat',
                    'label'=>'Show category',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'showtags',
                    'label'=>'Show tags',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'showintrotext',
                    'label'=>'Show Introtext',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showredmore',
                    'label'=>'Show Read more',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                // array(
                //     'type'=>'switch',
                //     'param_name'=>'showloadmore',
                //     'label'=>'Show Load more',
                //     'desc' => "" ,
                //     'default'=>'0',
                //     'value'=> array(
                //         'Yes'=>'1',
                //         'No'=>'0'
                //     )
                // ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label' => "Extra Class" ,
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                ),
            )
        );

        $elements['AzuraArticlesSlider'] = array(
            'name'=>'Articles Slider',
            'desc'=>'Slider with Content Articles',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/articles-slider.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showTypographyTab'=> true,
            'showAnimationTab'=>true,
            'attrs' => array (
                
                array(
                    'type'=>'text',
                    'param_name'=>'article_ids',
                    'label'=>'Article IDs',
                    'desc' => "Enter article ids to show, separated by a comma (,). Ex: 99,100 " ,
                    'default'=>'',
                    'show_in_admin' => true,
                ),
                
                array(
                    'type'=>'sqlselect',
                    'param_name'=>'category',
                    'label'=>'Or select a category',
                    'desc' => "Choose category get items from",
                    'default'=>'',

                    'query'=>"SELECT id AS value, title AS category FROM #__categories WHERE extension='com_content' AND published=1",
                    'titlekey'=>'category',
                    'valuekey'=>'value',
                    'show_in_admin' => true,

                ),
                array(
                    'type'=>'text',
                    'param_name'=>'limit',
                    'label'=>'Limit (for category source only)',
                    'desc' => "Number or All " ,
                    'default'=>'',
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'order',
                    'label'=>'Order (for category source only)',
                    'desc' => "" ,
                    'default'=>'created',
                    'value'=> array(
                        'Created'=>'created',
                        'ID'=>'id',
                        'Ordering'=>'ordering',
                    )
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'orderdir',
                    'label'=>'Sort Order (for category source only)',
                    'desc' => "" ,
                    'default'=>'DESC',
                    'value'=> array(
                        'Ascending'=>'ASC',
                        'Descending'=>'DESC',
                    )
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'showthumbnail',
                    'label'=>'Show Thumbnail',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showtitle',
                    'label'=>'Show title',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showdate',
                    'label'=>'Show Created Date',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showauthor',
                    'label'=>'Show Author',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showcat',
                    'label'=>'Show category',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'showtags',
                    'label'=>'Show tags',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showtitle',
                    'label'=>'Show title',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showintrotext',
                    'label'=>'Show Introtext',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                
                

                array(
                    'type'=>'switch',
                    'param_name'=>'autoplay',
                    'label'=>'Autoplay',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'loop',
                    'label'=>'Loop',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'slider_items',
                    'label'=>'Slider items',
                    'desc' => "Number of items display in view port" ,
                    'default'=>'2',
                ),  

                array(
                    'type'=>'text',
                    'param_name'=>'slideby',
                    'label'=>'Slide By',
                    'desc' => "Navigation slide by x. 'page' string can be set to slide by page" ,
                    'default'=>'1',
                ),


                

                array(
                    'type'=>'switch',
                    'param_name'=>'center_mode',
                    'label'=>'Center mode',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'autoheight',
                    'label'=>'Auto height',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'responsive',
                    'label'=>'Responsive',
                    'desc' => "The format is: screen-size:number-items-display,larger-screen-size:number-items-display. Ex: 320:1,768:2,1200:2" ,
                    'default'=>'320:1,768:2,1200:2',
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'nav',
                    'label'=>'Show Navigation',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'dots',
                    'label'=>'Show Pagination',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
            

                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label' => "Extra Class" ,
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                ),
                
            )
        );

        $elements['AzuraModule'] = array(
            'name'=>'Joomla Module',
            'desc'=>'Insert Joomla module to your page',
            'category'=>"structure",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/joomla.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'attrs' => array (
                
                array(
                    'type'=>'sqlselect',
                    'param_name'=>'moduleid',
                    'label'=>'Select a module',
                    'desc' => "" ,
                    'default'=>'',
                    'query'=>"SELECT id AS value, title AS moduleid FROM #__modules WHERE published=1 AND client_id=0",
                    'titlekey'=>'moduleid',
                    'valuekey'=>'value',
                    'show_in_admin' => true,

                ),
                array(
                    'type'=>'chromestyle',
                    'param_name'=>'chromestyle',
                    'label'=>'Module Style',
                    'desc' => "" ,
                    'default'=>'',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showtitle',
                    'label'=>'Show title',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Module ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label' => "Extra Class" ,
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                ),
            )
        );

        // $elements['AzuraFlexSlider'] = array(
        //     'name'=>'Flex Slider',
        //     'desc'=>'Flex slider element',
        //     'category'=>"content",
        //     'hasownchild'=>"yes",
        //     'childname'=>"Slide Item",
        //     'childtypename'=>"AzuraFlexSliderItem",
        //     'showStyleTab'=>true,
        //     'showAnimationTab'=>true,
        //     'attrs' => array (
        //         array(
        //             'type'=>'text',
        //             'param_name'=>'id',
        //             'label'=>'ID',
        //             'desc' => "" ,
        //             'default'=>'',
        //         ),
        //         array(
        //             'type'=>'text',
        //             'param_name'=>'class',
        //             'label'=>'Slider Class',
        //             'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
        //             'default'=>'flexslider',
        //         ),
        //         array(
        //             'type'=>'select',
        //             'param_name'=>'flexanimation',
        //             'label'=>'Animation',
        //             'desc' => "Controls the animation type" ,
        //             'default'=>'fade',
        //             'value'=> array(
        //                 'Fade'=>'fade',
        //                 'Slide'=>'slide',

        //             ),
        //         ),
        //         array(
        //             'type'=>'select',
        //             'param_name'=>'direction',
        //             'label'=>'Direction',
        //             'desc' => "Controls the animation direction" ,
        //             'default'=>'horizontal',
        //             'value'=> array(
        //                 'Horizontal'=>'horizontal',
        //                 'Vertical'=>'vertical',

        //             ),
        //         ),
        //         array(
        //             'type'=>'switch',
        //             'param_name'=>'slideshow',
        //             'label'=>'Slide Show',
        //             'desc' => "Setup a slideshow for the slider to animate automatically" ,
        //             'default'=>'1',
        //             'value'=> array(
        //                 'Yes'=>'1',
        //                 'No'=>'0',

        //             ),
        //         ),
        //         array(
        //             'type'=>'text',
        //             'param_name'=>'slideshowspeed',
        //             'label'=>'Slideshow Speed',
        //             'desc' => "Set the speed of the slideshow cycling, in milliseconds" ,
        //             'default'=>'7000',
        //         ),
        //         array(
        //             'type'=>'text',
        //             'param_name'=>'animationspeed',
        //             'label'=>'Animation Speed',
        //             'desc' => "Set the speed of animations, in milliseconds" ,
        //             'default'=>'600',
        //         ),
                
        //     )
        // );
        // $elements['AzuraFlexSliderItem'] = array(
        //     'name'=>"Slide Item",
        //     'category'=>"content",
        //     'isownchild' => 'yes',
        //     'showStyleTab'=> true,
        //     'attrs' => array (
        //         array(
        //             'type'=>'text',
        //             'param_name'=>'class',
        //             'label'=>'Slide Class',
        //             'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
        //             'default'=>''
        //         ),
        //         array(
        //             'type'=>'image',
        //             'param_name'=>'slideimage',
        //             'label'=>'Slide Photo',
        //             'desc' => "" ,
        //             'default'=>''
        //         ),
        //         array(
        //             'type'=>'text',
        //             'param_name'=>'alttext',
        //             'label'=>'Alt text',
        //             'desc' => "" ,
        //             'default'=>''
        //         ),
        //         array(
        //             'type'=>'textarea',
        //             'param_name'=>'textContent',
        //             'label'=>'Content',
        //             'desc' => "" ,
        //             'default'=>'',
        //             'iscontent'=>'yes'
        //         ),
                
        //     )
        // );

        $elements['AzuraButton'] = array(
            'name'=>'Button',
            'desc'=>'Eye catching button',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/button.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showTypographyTab'=> true,
            'showAnimationTab'=>true,
            'attrs' => array (

                array(
                    'type'=>'text',
                    'param_name'=>'title',
                    'label'=>'Button Title',
                    'desc' => "" ,
                    'default'=>'View More',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'icon_type',
                    'label'=>"Icon library",
                    'desc' => "Select icon library." ,
                    'default'=>'fontawesome',
                    'value'=> array(
                        'Font Awesome'=>'fontawesome',
                        'Line icon'=>'lineicon',
                        'Simple Line icon'=>'simplelineicon',
                        'ET Line icon'=>'etlineicon',
                    ),
                    
                ),

                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_fontawesome',
                    'label'=>"Icon",
                    'desc' => "Awesome font icon" ,
                    'default'=>'fa fa-eye',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('fontawesome'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'lineicon',
                    'param_name'=>'icon_lineicon',
                    'label'=>"Icon",
                    'desc' => "Line icon",
                    'default'=>'azp_lineicon-eye',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('lineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'simplelineicon',
                    'param_name'=>'icon_simplelineicon',
                    'label'=>"Icon",
                    'desc' => "Simple Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('simplelineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'etlineicon',
                    'param_name'=>'icon_etlineicon',
                    'label'=>"Icon",
                    'desc' => "ET Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('etlineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'click_action',
                    'label'=>'Click action',
                    'desc' => "" ,
                    'default'=>'external',
                    'value'=> array(
                        'Open external link'=>'external',
                        'Open a Joomla menu'=>'menu',
                        'Open popup'=>'popup',
                        'Open modal'=>'modal',

                    ),
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'link',
                    'label'=>'URL (Link)',
                    'desc' => "" ,
                    'default'=>'https://themeforest.net/user/cththemes/portfolio',
                    'depends_on' => array(
                        'element' => 'click_action',
                        'value' => array('external'),
                        'has_value' => false,
                    ),
                ),

                array(
                    'type'=>'menuitem',
                    'param_name'=>'menu_item',
                    'label'=>'Select a menu item',
                    'desc' => "",
                    'default'=>'0',
                    'depends_on' => array(
                        'element' => 'click_action',
                        'value' => array('menu'),
                        'has_value' => false,
                    ),
                ),


                array(
                    'type'=>'select',
                    'param_name'=>'target',
                    'label'=>'Open link in: ',
                    'desc' => "" ,
                    'default'=>'_self',
                    'value'=> array(
                        'New tab'=>'_blank',
                        'Current tab'=>'_self',

                    ),
                    'depends_on' => array(
                        'element' => 'click_action',
                        'value' => array('external','menu'),
                        'has_value' => false,
                    ),
                ),
                array(
                    'type'=>'image',
                    'param_name'=>'popup_link',
                    'label'=>'Popup image or video',
                    'desc' => "Large Image or Youtube, Vimeo, Soundcloud link for popup." ,
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'click_action',
                        'value' => array('popup'),
                        'has_value' => false,
                    ),
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'modal_id',
                    'label'=>'Modal ID',
                    'desc' => "Enter your modal ID here to open it." ,
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'click_action',
                        'value' => array('modal'),
                        'has_value' => false,
                    ),
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'btn_type',
                    'label'=>'Button Type',
                    'desc' => "" ,
                    'default'=>'default',
                    'value'=> array(
                        'Default'=>'default',
                        'Button link'=>'btn_link',
                        'Button image'=>'btn_image',

                    ),
                ),

                array(
                    'type'=>'image',
                    'param_name'=>'btn_image',
                    'label'=>'Image',
                    'desc' => "" ,
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'btn_type',
                        'value' => array('btn_image'),
                        'has_value' => false,
                    ),
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'btn_color',
                    'label'=>'Button Color',
                    'desc' => "" ,
                    'default'=>'default',
                    'value'=> array(
                        'Default'=>'default',
                        'Primary'=>'primary',
                        'Blue'=>'blue',
                        'Purple'=>'purple',
                        'Pink'=>'pink',
                        'Yellow'=>'yellow',
                        'Green'=>'green',
                        'Red'=>'red',
                        
                        // 'White'=>'white',
                        'Custom color'=>'custom',

                    ),
                    'depends_on'=> array(
                        'element'=> 'btn_type',
                        'value'=> array('default'),
                        'has_value' => false
                    ),
                ),

                array(
                    'type'=>'color',
                    'param_name'=>'btn_custom_color',
                    'label'=>'Select a color',
                    'desc' => "" ,
                    'default'=>'',
                    'depends_on'=> array(
                        'element'=> 'btn_color',
                        'value'=> array('custom'),
                        'has_value' => false
                    ),
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'btn_size',
                    'label'=>'Button Size',
                    'desc' => "" ,
                    'default'=>'s-df',
                    'value'=> array(
                        'Large'=>'lg',
                        'Default'=>'s-df',
                        'Small'=>'sm',
                        'Extra Small'=>'xs',

                    ),
                    'depends_on'=> array(
                        'element'=> 'btn_type',
                        'value'=> array('default'),
                        'has_value' => false
                    ),
                ),


                
                
                array(
                    'type'=>'switch',
                    'param_name'=>'is_border',
                    'label'=>'Is Bordered button?',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                    'depends_on'=> array(
                        'element'=> 'btn_type',
                        'value'=> array('default'),
                        'has_value' => false
                    ),
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'is_fullwidth',
                    'label'=>'Set full width button?',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                    'depends_on'=> array(
                        'element'=> 'btn_type',
                        'value'=> array('default'),
                        'has_value' => false
                    ),
                ),



                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                ),



                



                
            )
        );
        $elements['AzuraModal'] = array(
            'name'=>'Modal',
            'desc'=>'Streamlined, but flexible, dialog prompts',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/modal.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showTypographyTab'=> true,
            'showAnimationTab'=>true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Modal ID',
                    'desc' => "" ,
                    'default'=>'myModal',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'modal_title',
                    'label'=>'Modal Title',
                    'desc' => "" ,
                    'default'=>'Modal title',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'editor',
                    'param_name'=>'content',
                    'label'=>'Modal content',
                    'desc' => "" ,
                    'height' => "600" ,
                    'default'=>'<h5>Dropcaps default</h5>
<p><span class="dropcaps drop-default">V</span>idit vivendum sit ea ex pro regione tibique. Sed ea porro explicari, noster pertinacia eu eum. Usu in ullum omnesque atomorum integre imperdiet in. Saperet perpetua ut mei, nibh sale meis eam cu ut vim modus ex cum erat.</p>

<h5>Dropcaps primary</h5>
<p><span class="dropcaps drop-primary">A</span>tomorum usu in ullum omnesque atomorum, pro integre imperdiet in. Saperet perpetua ut mei, nibh sale meis eam cu. Ut vim modus zril, ex cum erat dictas liber ancillae voluptatibus vis ex etiam timeam honestatis.</p>

<h5>Dropcaps circle</h5>
<p><span class="dropcaps drop-default drop-circle">P</span>urto dissentias te eum. Eu labitur accusata quo. Has equidem ceteros id, eum nihil nobis cu. Ut his nonumes ocurreret, ut usu nobis deserunt, persecuti expetendis voluptatum eu sit.</p>

<h5>Dropcaps circle</h5>
<p><span class="dropcaps drop-primary drop-circle">L</span>orem ipsum dolor sit amet, alia iudico his an. Eu oratio ridens nam. Mel elitr interesset eu, eu sed cetero recusabo neglegentur. Vel erat mucius ea, etiam insolens phaedrum id pri utroque tibique salutatus.</p>

<h5>Dropcaps square</h5>
<p><span class="dropcaps drop-default drop-square">P</span>urto dissentias te eum. Eu labitur accusata quo. Has equidem ceteros id, eum nihil nobis cu. Ut his nonumes ocurreret, ut usu nobis deserunt, persecuti expetendis voluptatum eu sit.</p>

<h5>Dropcaps square</h5>
<p><span class="dropcaps drop-primary drop-square">L</span>orem ipsum dolor sit amet, alia iudico his an. Eu oratio ridens nam. Mel elitr interesset eu, eu sed cetero recusabo neglegentur. Vel erat mucius ea, etiam insolens phaedrum id pri utroque tibique salutatus. &nbsp; &nbsp; &nbsp;</p>',
                    'iscontent'=>'yes'
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'modal_size',
                    'label'=>'Modal Size',
                    'desc' => "" ,
                    'default'=>'s-df',
                    'value'=> array(
                        'Large'=>'lg',
                        'Default'=>'s-df',
                        'Small'=>'sm',

                    ),
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'show_close',
                    'label'=>'Show close button',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'show_button',
                    'label'=>'Show toogle button',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),


                array(
                    'type'=>'text',
                    'param_name'=>'btn_title',
                    'label'=>'Button Title',
                    'desc' => "" ,
                    'default'=>'Launch modal',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'icon_type',
                    'label'=>"Icon library",
                    'desc' => "Select icon library." ,
                    'default'=>'fontawesome',
                    'value'=> array(
                        'Font Awesome'=>'fontawesome',
                        'Line icon'=>'lineicon',
                        'Simple Line icon'=>'simplelineicon',
                        'ET Line icon'=>'etlineicon',
                    ),
                    
                ),

                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_fontawesome',
                    'label'=>"Icon",
                    'desc' => "Awesome font icon" ,
                    'default'=>'fa fa-eye',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('fontawesome'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'lineicon',
                    'param_name'=>'icon_lineicon',
                    'label'=>"Icon",
                    'desc' => "Line icon",
                    'default'=>'azp_lineicon-plus',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('lineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'simplelineicon',
                    'param_name'=>'icon_simplelineicon',
                    'label'=>"Icon",
                    'desc' => "Simple Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('simplelineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'etlineicon',
                    'param_name'=>'icon_etlineicon',
                    'label'=>"Icon",
                    'desc' => "ET Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('etlineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                
                array(
                    'type'=>'select',
                    'param_name'=>'btn_color',
                    'label'=>'Button Color',
                    'desc' => "" ,
                    'default'=>'default',
                    'value'=> array(
                        'Default'=>'default',
                        'Primary'=>'primary',
                        'Blue'=>'blue',
                        'Purple'=>'purple',
                        'Pink'=>'pink',
                        'Yellow'=>'yellow',
                        'Green'=>'green',
                        'Red'=>'red',

                    ),
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'btn_size',
                    'label'=>'Button Size',
                    'desc' => "" ,
                    'default'=>'s-df',
                    'value'=> array(
                        'Large'=>'lg',
                        'Default'=>'s-df',
                        'Small'=>'sm',
                        'Extra Small'=>'xs',

                    ),
                ),


                
                
                array(
                    'type'=>'switch',
                    'param_name'=>'is_border',
                    'label'=>'Is Bordered button?',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'is_fullwidth',
                    'label'=>'Set full width button?',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),



                
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                ),  
            )
        );
        $elements['AzuraCTA'] = array(
            'name'=>'Call to Action',
            'desc'=>'Catch visitors attention with CTA block',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/call-to-action.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showTypographyTab'=> true,
            'showAnimationTab'=>true,
            'attrs' => array (
                
                
                array(
                    'type'=>'text',
                    'param_name'=>'heading',
                    'label'=>'Heading',
                    'desc' => "" ,
                    'default'=>'Get it now… for free premium access !',
                    'show_in_admin' => true,
                ),

                

                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Content',
                    'desc' => "" ,
                    'default'=>'Quisque ullamcorper urna massa, in rhoncus ex mattis vitae. Donec scelerisque, neque ac ultrices mollis, nisl turpis lobortis augue, in egestas libero enim ac velit. Pellentesque imperdiet quam sapien, a varius dui vulputate lobortis. Donec aliquet id ex vitae eleifend. ',
                    'iscontent'=>'yes',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'color',
                    'param_name'=>'cta_heading_color',
                    'label'=>'Heading Color',
                    'desc' => "" ,
                    'default'=>'',
                    
                ),

                array(
                    'type'=>'color',
                    'param_name'=>'cta_color',
                    'label'=>'Main Text Color',
                    'desc' => "" ,
                    'default'=>'',
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'textalign',
                    'label'=>'Text Align',
                    'desc' => "" ,
                    'default'=>'center',
                    'value'=> array(
                        'Left'=>'left',
                        'Right'=>'right',
                        'Center'=>'center',
                        'Justify'=>'justify',

                    ),
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'btn_position',
                    'label'=>'Button Position',
                    'desc' => "" ,
                    'default'=>'center',
                    'value'=> array(
                        'Left'=>'left',
                        'Right'=>'right',
                        'Center'=>'center',

                    ),
                ),


                array(
                    'type'=>'text',
                    'param_name'=>'btn_title',
                    'label'=>'Button Title',
                    'desc' => "" ,
                    'default'=>'Register now',
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'icon_type',
                    'label'=>"Icon library",
                    'desc' => "Select icon library." ,
                    'default'=>'fontawesome',
                    'value'=> array(
                        'Font Awesome'=>'fontawesome',
                        'Line icon'=>'lineicon',
                        'Simple Line icon'=>'simplelineicon',
                        'ET Line icon'=>'etlineicon',
                    ),
                    
                ),

                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_fontawesome',
                    'label'=>"Icon",
                    'desc' => "Awesome font icon" ,
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('fontawesome'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'lineicon',
                    'param_name'=>'icon_lineicon',
                    'label'=>"Icon",
                    'desc' => "Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('lineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'simplelineicon',
                    'param_name'=>'icon_simplelineicon',
                    'label'=>"Icon",
                    'desc' => "Simple Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('simplelineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'etlineicon',
                    'param_name'=>'icon_etlineicon',
                    'label'=>"Icon",
                    'desc' => "ET Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('etlineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'click_action',
                    'label'=>'Click action',
                    'desc' => "" ,
                    'default'=>'external',
                    'value'=> array(
                        'Open external link'=>'external',
                        'Open a Joomla menu'=>'menu',
                        'Open popup'=>'popup',
                        'Open modal'=>'modal',

                    ),
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'link',
                    'label'=>'URL (Link)',
                    'desc' => "" ,
                    'default'=>'https://themeforest.net/user/cththemes/portfolio',
                    'depends_on' => array(
                        'element' => 'click_action',
                        'value' => array('external'),
                        'has_value' => false,
                    ),
                ),

                array(
                    'type'=>'menuitem',
                    'param_name'=>'menu_item',
                    'label'=>'Select a menu item',
                    'desc' => "",
                    'default'=>'0',
                    'depends_on' => array(
                        'element' => 'click_action',
                        'value' => array('menu'),
                        'has_value' => false,
                    ),
                ),


                array(
                    'type'=>'select',
                    'param_name'=>'target',
                    'label'=>'Open link in: ',
                    'desc' => "" ,
                    'default'=>'_self',
                    'value'=> array(
                        'New tab'=>'_blank',
                        'Current tab'=>'_self',

                    ),
                    'depends_on' => array(
                        'element' => 'click_action',
                        'value' => array('external','menu'),
                        'has_value' => false,
                    ),
                ),
                array(
                    'type'=>'image',
                    'param_name'=>'popup_link',
                    'label'=>'Popup image or video',
                    'desc' => "Large Image or Youtube, Vimeo, Soundcloud link for popup." ,
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'click_action',
                        'value' => array('popup'),
                        'has_value' => false,
                    ),
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'modal_id',
                    'label'=>'Modal ID',
                    'desc' => "Enter your modal ID here to open it." ,
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'click_action',
                        'value' => array('modal'),
                        'has_value' => false,
                    ),
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'btn_color',
                    'label'=>'Button Color',
                    'desc' => "" ,
                    'default'=>'default',
                    'value'=> array(
                        'Default'=>'default',
                        'Primary'=>'primary',
                        'Blue'=>'blue',
                        'Purple'=>'purple',
                        'Pink'=>'pink',
                        'Yellow'=>'yellow',
                        'Green'=>'green',
                        'Red'=>'red',
                        
                        // 'White'=>'white',
                        'Custom color'=>'custom',

                    ),
                ),

                array(
                    'type'=>'color',
                    'param_name'=>'btn_custom_color',
                    'label'=>'Select a color',
                    'desc' => "" ,
                    'default'=>'',
                    'depends_on'=> array(
                        'element'=> 'btn_color',
                        'value'=> array('custom'),
                        'has_value' => false
                    ),
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'btn_size',
                    'label'=>'Button Size',
                    'desc' => "" ,
                    'default'=>'s-df',
                    'value'=> array(
                        'Large'=>'lg',
                        'Default'=>'s-df',
                        'Small'=>'sm',
                        'Extra Small'=>'xs',

                    ),
                ),


                
                
                array(
                    'type'=>'switch',
                    'param_name'=>'is_border',
                    'label'=>'Is Bordered button?',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'is_fullwidth',
                    'label'=>'Set full width button?',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),




                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                ),                
            )
        );
        
        $elements['AzuraVideo'] = array(
            'name'=>'Video Player',
            'desc'=>'Embeded Youtube/Vimeo Video Player',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/video.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showAnimationTab'=>true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'video_link',
                    'label'=>'Video Link',
                    'desc' => "Video Link (Youtube, Vimeo)" ,
                    'default'=>'https://www.youtube.com/watch?v=Tjvtl3qMRHs',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'video_width',
                    'label'=>'Video Width',
                    'desc' => "Related with its container element" ,
                    'default'=>'100',
                    'value'=> array(
                        '100%' => '100',
                        '90%' => '90',
                        '80%' => '80',
                        '70%' => '70',
                        '60%' => '60',
                        '50%' => '50',
                        '40%' => '40',
                        '30%' => '30',
                        '20%' => '20',
                        '10%' => '10',
                    )
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'aspect_ratio',
                    'label'=>'Aspect Ratio',
                    'desc' => "The ratio of the width to the height of the video." ,
                    'default'=>'16_9',
                    'value'=> array(
                        'HD Video 16:9'=>'16_9',
                        'Standard 4:3'=>'4_3',
                        'Classic 3:2'=>'3_2',
                        'Cinemascope 21:9'=>'21_9',

                    ),
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'autoplay',
                    'label'=>'Autoplay',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'loop',
                    'label'=>'Loop',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),

                
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                ),
                
            )
        );
        $elements['AzuraVideoBg'] = array(
            'name'=>'Background Video',
            'desc'=>'Add a Youtube background video as to your page',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/mb.YTPlayer.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'attrs' => array (
                
                array(
                    'type'=>'text',
                    'param_name'=>'link',
                    'label'=>'Video Link',
                    'desc' => "Youtube Video Link in one of these URL format: https://www.youtube.com/watch?v=V2rifmjZuKQ, http://youtu.be/V2rifmjZuKQ or V2rifmjZuKQ" ,
                    'default'=>'https://www.youtube.com/watch?v=V2rifmjZuKQ',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'autoplay',
                    'label'=>'Autoplay',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'loop',
                    'label'=>'Loop',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'mute',
                    'label'=>'Mute',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'vol',
                    'label'=>'Vol',
                    'desc' => "1 to 100 (number) set the volume level of the video" ,
                    'default'=>'50',
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'quality',
                    'label'=>'Quality',
                    'desc' => "" ,
                    'default'=>'default',
                    'value'=> array(
                        'Default'=>'default',
                        'Small'=>'small',
                        'Medium'=>'medium',
                        'Large'=>'large',
                        'HD720'=>'hd720',
                        'HD1080'=>'hd1080',
                        'Highres'=>'highres',

                    ),
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'ratio',
                    'label'=>'Ratio',
                    'desc' => "" ,
                    'default'=>'16/9',
                    'value'=> array(
                        '4/3'=>'4/3',
                        '16/9'=>'16/9',

                    ),
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'opacity',
                    'label'=>'Video Opacity',
                    'desc' => "" ,
                    'default'=>'1',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'containment',
                    'label'=>'Containment',
                    'desc' => "(string) the CSS selector of the DOM element where you want the video background; if not specified it takes the {body}; if set to {self} the player will be instanced on this element." ,
                    'default'=>'body',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'startat',
                    'label'=>'Start At',
                    'desc' => "Set the seconds the video should start at." ,
                    'default'=>'0',
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'showcontrols',
                    'label'=>'Show Controls',
                    'desc' => "Show or hide the controls bar at the bottom of the page." ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'addraster',
                    'label'=>'Add Raster',
                    'desc' => "Show or hide a raster image over the video" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),


                array(
                    'type'=>'image',
                    'param_name'=>'mobile_img',
                    'label'=>'Mobile Background',
                    'desc' => "" ,
                    'default'=>'',
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                ),
                
            )
        );
        $elements['AzuraGMap'] = array(
            'name'=>'Google Map',
            'desc'=>'Google Google Map',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/google-map.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showAnimationTab'=>true,
            'attrs' => array (

                
                array(
                    'type'=>'text',
                    'param_name'=>'map_height',
                    'label'=>'Map Height',
                    'desc' => "Enter your map height in pixel. Default: 450" ,
                    'default'=>'450',
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'map_lat',
                    'label'=>'Address Latitude',
                    'desc' => "Enter your address latitude. You can get your value from: <a href='http://www.gps-coordinates.net/' target='_blank'>http://www.gps-coordinates.net/</a>" ,
                    'default'=>'40.7168183',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'map_long',
                    'label'=>'Address Longitude',
                    'desc' => "Enter your address longtitude. You can get your value from: <a href='http://www.gps-coordinates.net/' target='_blank'>http://www.gps-coordinates.net/</a>" ,
                    'default'=>'-73.99330616',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'map_address',
                    'label'=>'Address String',
                    'desc' => "" ,
                    'default'=>'Azura - New York City',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'textarea',
                    
                    'param_name'=>'add_address',
                    'label'=>'Additional Address',
                    'desc' => "Address must be separated by `|`. Format: Latitude;Longitude;String_Address<p>Ex: 40.7168183;-73.9973402;Azura - Washington|10.73334016;73.99330616;Azura - Florida</p>" ,
                    'default'=>'',
                ),

                array(
                    'type'=>'image',
                    'param_name'=>'map_marker',
                    'label'=>'Map marker',
                    'desc' => "Upload google map marker or leave it empty to use default." ,
                    'default'=>'',
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'map_zoom',
                    'label'=>'Map zoom',
                    'desc' => "" ,
                    'default'=>'10',
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'zoom_control',
                    'label'=>'Show Zoom Control',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'maptype_control',
                    'label'=>'Show Type Control',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),



                array(
                    'type'=>'switch',
                    'param_name'=>'scale_control',
                    'label'=>'Show Scale Control',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),
                
                
                array(
                    'type'=>'switch',
                    'param_name'=>'scroll_wheel',
                    'label'=>'Scroll Wheel Control',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'default_style',
                    'label'=>'Use default style',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'street_view',
                    'label'=>'Street View Control',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'draggable',
                    'label'=>'Draggable Control',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),



                
                // array(
                //     'type'=>'select',
                //     'param_name'=>'gmaptypeid',
                //     'label'=>'Map Type',
                //     'desc' => "" ,
                //     'default'=>'ROADMAP',
                //     'value'=> array(
                //         'HYBRID'=>'HYBRID',
                //         'ROADMAP'=>'ROADMAP',
                //         'SATELLITE'=>'SATELLITE',
                //         'TERRAIN'=>'TERRAIN',

                //     ),
                // ),

                

                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                ),
                
            )
        );

        


        $elements['raw_html'] = array(
            'name'=>'Raw HTML',
            'desc'=>'Output raw html code on your page',
            'category'=>"structure",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/raw-html.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                array(
                    'type'=>'aceeditor',//aceeditor
                    'mode'=>'html',
                    'param_name'=>'content',
                    'label'=>'Text Content (Can be use with html tags.)',
                    'desc' => "Text Content (Can be use with html tags)" ,
                    'default'=>'',
                    'iscontent'=>'yes',
                    'show_in_admin'=>true
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                ),
                
            )
        );

        
           

        $elements['AzuraJS'] = array(
            'name'=>'Raw JS',
            'desc'=>'Output raw javascript code on your page',
            'category'=>"structure",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/raw-js.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> false,
            'showAnimationTab'=> false,
            'showResponsiveTab'=> false,
            'attrs' => array (
                array(
                    'type'=>'aceeditor',
                    'param_name'=>'content',
                    'label'=>'Javascript code',
                    'desc' => "Please enter your javascript code (&lt;script&gt; and &lt;/script&gt; tags are require)" ,
                    'default'=>'',
                    'mode'=>'javascript',
                    'iscontent'=>'yes'
                ),
                
                
            )
        );
        $elements['AzuraFlickr'] = array(
            'name'=>'Flickr Widget',
            'desc'=>'Image feed from your flickr account',
            'category'=>"social",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/flickr.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showAnimationTab' => true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'accountid',
                    'label'=>'Flickr Account',
                    'desc' => "" ,
                    'default'=>'37304598@N02',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'count',
                    'label'=>'Count',
                    'desc' => "Number of photos to feed" ,
                    'default'=>'6',
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'thumbnail',
                    'label'=>'Thumbnail Size',
                    'desc' => "" ,
                    'default'=>'image_m',
                    'value'=> array(
                        'Small square 75x75'=>'image_s',
                        //'Large square 150x150'=>'image_q',
                        'Thumbnail, 100 on longest side'=>'image_t',
                        'Small, 240 on longest side' => 'image_m',
                        //'Small, 320 on longest side' => 'image_n',
                        'Medium, 500 on longest side'=>'image',
                        'Large, 1024 on longest side' => 'image_b',
                        // 'Large 2048, 2048 on longest side' => 'image_k',
                        // 'Original Image' => 'image_o'
                    ),
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'viewtype',
                    'label'=>'View Type',
                    'desc' => "" ,
                    'default'=>'grid',
                    'value'=> array(
                        'Grid'=>'grid',
                        'Slider'=>'slider',
                    ),
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'columns',
                    'label'=>"Grid Columns",
                    'desc' => "Number of images display on a row." ,
                    
                    'value'=> array(
                        'One Column'=>'one',
                        'Two Columns'=>'two',
                        'Three Columns'=>'three',
                        'Four Columns'=>'four',
                        'Five Columns'=>'five',
                        'Six Columns'=>'six',
                        'Seven Columns'=>'seven',
                        'Eight Columns'=>'eight',
                        'Nine Columns'=>'nine',
                        'Ten Columns'=>'ten',
                    ),
                    'default'=>'three',
                    'depends_on' => array(
                        'element' => 'viewtype',
                        'value' => array('grid'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'slider_items',
                    'label'=>'Slider items',
                    'desc' => "Number of items display in view port" ,
                    'default'=>'3',
                    'depends_on' => array(
                        'element' => 'viewtype',
                        'value' => array('slider'),
                        'has_value' => false,
                    ),
                ),  

                array(
                    'type'=>'text',
                    'param_name'=>'slideby',
                    'label'=>'Slide By',
                    'desc' => "Navigation slide by x. 'page' string can be set to slide by page" ,
                    'default'=>'1',
                    'depends_on' => array(
                        'element' => 'viewtype',
                        'value' => array('slider'),
                        'has_value' => false,
                    ),
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'responsive',
                    'label'=>'Responsive',
                    'desc' => "The format is: screen-size:number-items-display,larger-screen-size:number-items-display. Ex: 320:1,768:2,1200:2" ,
                    'default'=>'320:1,768:2,1200:3',
                    'depends_on' => array(
                        'element' => 'viewtype',
                        'value' => array('slider'),
                        'has_value' => false,
                    ),
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'nav',
                    'label'=>'Show Navigation',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    ),
                    'depends_on' => array(
                        'element' => 'viewtype',
                        'value' => array('slider'),
                        'has_value' => false,
                    ),
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'dots',
                    'label'=>'Show Pagination',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    ),
                    'depends_on' => array(
                        'element' => 'viewtype',
                        'value' => array('slider'),
                        'has_value' => false,
                    ),
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'enable_gal',
                    'label'=>'Enable Gallery',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    ),
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                ),
                
            )
        );

        $elements['AzuraProgress'] = array(
            'name'=>'Progress Bar',
            'desc'=>'Animated progress bar',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/progress-bar.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'title',
                    'label'=>'Title',
                    'desc' => "Text used as title of bar." ,
                    'default'=>'Skill Name',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'value',
                    'label'=>'Value',
                    'desc' => "Enter value of bar." ,
                    'default'=>'85',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'progress_style',
                    'label'=>'Progress Style',
                    'desc' => "" ,
                    'default'=>'style1',
                    'value'=> array(
                        'Default'=>'style1',
                        'Style 2'=>'style2',
                        'Style 3'=>'style3',
                        'Style 4'=>'style4',
                        
                    ),
                    
                ),

                array(
                    'type'=>'color',
                    'param_name'=>'progress_color',
                    'label'=>'Color',
                    'desc' => "" ,
                    'default'=>'',
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,

                    'default'=>'',
                ),
                
                
                
                
                
            )
        );

        $elements['AzuraCircleProgress'] = array(
            'name'=>'CircleProgress',
            'desc'=>'Animated circle progress',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/circle-progress.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                
                array(
                    'type'=>'text',
                    'param_name'=>'value',
                    'label'=>'Value',
                    'desc' => "Enter value of circle progress. Number from 0 to 100." ,
                    'default'=>'85',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'title',
                    'label'=>'Title',
                    'desc' => "Text used as title of circle progress." ,
                    'default'=>'Skill Name',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'icon_type',
                    'label'=>"Icon library",
                    'desc' => "Select icon library." ,
                    'default'=>'fontawesome',
                    'value'=> array(
                        'Font Awesome'=>'fontawesome',
                        'Line icon'=>'lineicon',
                        'Simple Line icon'=>'simplelineicon',
                        'ET Line icon'=>'etlineicon',
                    ),
                    
                ),

                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_fontawesome',
                    'label'=>"Icon",
                    'desc' => "Awesome font icon" ,
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('fontawesome'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'lineicon',
                    'param_name'=>'icon_lineicon',
                    'label'=>"Icon",
                    'desc' => "Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('lineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'simplelineicon',
                    'param_name'=>'icon_simplelineicon',
                    'label'=>"Icon",
                    'desc' => "Simple Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('simplelineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'etlineicon',
                    'param_name'=>'icon_etlineicon',
                    'label'=>"Icon",
                    'desc' => "ET Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('etlineicon'),
                        'has_value' => false,
                    ),
                    
                ),


                array(
                    'type'=>'text',
                    'param_name'=>'size',
                    'label'=>'Size',
                    'desc' => "Size of the circle / canvas in pixels" ,
                    'default'=>'200',
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'thickness',
                    'label'=>'Thickness',
                    'desc' => "Width of the arc. By default it\'s automatically calculated as 1/14 of size but you may set your own number" ,
                    'default'=>'auto',
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'startangle',
                    'label'=>'Start Angle',
                    'desc' => "Initial angle (for 0 value) " ,
                    'default'=> -pi(),
                    'value'=> array(
                        'Top quarter'=>-pi()/2,
                        'Top - Right 1/8'=>-pi()/4,
                        'Right quarter'=>pi(),
                        'Bottom - Right 1/8'=>pi()/4,
                        'Bottom quarter'=>pi()/2,
                        'Bottom - Left 1/8'=>pi()/4*3,
                        'Left quarter'=>-pi(),
                        'Top - Left 1/8'=>-pi()/4*5,
                        
                    ),
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'linecap',
                    'label'=>'Line Cap',
                    'desc' => "Arc line cap" ,
                    'default'=>'butt',
                    'value'=> array(
                        'butt'=>'butt',
                        'Round'=>'round',
                        'Square'=>'square',
                        
                    ),
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'colortype',
                    'label'=>'Color Type',
                    'desc' => "" ,
                    'default'=>'gradient',
                    'value'=> array(
                        'Solid color'=>'solid',
                        'Gradient'=>'gradient',
                        
                    ),
                    
                ),

                array(
                    'type'=>'color',
                    'param_name'=>'progress_color',
                    'label'=>'Color',
                    'desc' => "" ,
                    'default'=>'#3aeabb',
                    
                ),
                array(
                    'type'=>'color',
                    'param_name'=>'progress_color2',
                    'label'=>'Color 2',
                    'desc' => "" ,
                    'default'=>'#fdd250',
                    'depends_on'=> array(
                        'element'=> 'colortype',
                        'value'=>array('gradient'),
                        'has_value'=>false,
                    )
                    
                ),

                array(
                    'type'=>'color',
                    'param_name'=>'empty_color',
                    'label'=>'Empty Color',
                    'desc' => "" ,
                    'default'=>'#cccccc',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'duration',
                    'label'=>'Duration',
                    'desc' => "Miliseconds number determining how long the animation will run." ,
                    'default'=>'1200',
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'showanimation',
                    'label'=>'Show Animation number',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'showanimationpro',
                    'label'=>'Show Animation progress',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),


                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,

                    'default'=>'',
                ),
                
                
                
                
                
            )
        );

        

        // $elements['AzuraPieChart'] = array(
        //     'name'=>'Pie chart',
        //     'desc'=>'Animated pie chart',
        //     'category'=>"content",
        //     'showStyleTab'=> false,
        //     'showAnimationTab'=> false,
        //     'showResponsiveTab'=> false,
        //     'attrs' => array (
        //         array(
        //             'type'=>'aceeditor',
        //             'param_name'=>'jsScript',
        //             'label'=>'Javascript code',
        //             'desc' => "Please enter your javascript code (&lt;script&gt; and &lt;/script&gt; tags are require)" ,
        //             'default'=>'',
        //             'mode'=>'javascript'
        //         ),
                
                
        //     )
        // );

        $elements['AzuraPricingTable'] = array(
            'name'=>'Pricing Table',
            'desc'=>'',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/pricing-table.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (

                array(
                    'type'=>'select',
                    'param_name'=>'pricing_style',
                    'label'=>'Pricing Style',
                    'desc' => "" ,
                    'default'=>'style1',
                    'value'=> array(
                        'Icon Style'=>'style1',
                        'Heading'=>'secondary',
                    ), 
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'icon_type',
                    'label'=>"Icon library",
                    'desc' => "Select icon library." ,
                    'default'=>'fontawesome',
                    'value'=> array(
                        'Font Awesome'=>'fontawesome',
                        'Line icon'=>'lineicon',
                        'Simple Line icon'=>'simplelineicon',
                        'ET Line icon'=>'etlineicon',
                    ),
                    'depends_on' => array(
                        'element' => 'pricing_style',
                        'value' => array('style1'),
                    ),
                    
                ),

                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_fontawesome',
                    'label'=>"Icon",
                    'desc' => "Awesome font icon" ,
                    'default'=>'fa fa-trophy',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('fontawesome'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'lineicon',
                    'param_name'=>'icon_lineicon',
                    'label'=>"Icon",
                    'desc' => "Line icon",
                    'default'=>'.azp_lineicon-happy',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('lineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'simplelineicon',
                    'param_name'=>'icon_simplelineicon',
                    'label'=>"Icon",
                    'desc' => "Simple Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('simplelineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'etlineicon',
                    'param_name'=>'icon_etlineicon',
                    'label'=>"Icon",
                    'desc' => "ET Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('etlineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'price_title',
                    'label'=>'Title',
                    'desc' => "" ,
                    'default'=>'Personal',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'price_subtitle',
                    'label'=>'SubTitle',
                    'desc' => "" ,
                    'default'=>'Single license',
                    'depends_on' => array(
                        'element' => 'pricing_style',
                        'value' => array('style1'),
                    ),
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'price',
                    'label'=>'Price',
                    'desc' => "" ,
                    'default'=>'49',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'currency',
                    'label'=>'Currency',
                    'desc' => "" ,
                    'default'=>'$',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'period',
                    'label'=>'Period',
                    'desc' => "" ,
                    'default'=>'.99/ year',
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'is_active',
                    'label'=>'Is Featured',
                    'desc' => "Show Subject field instead of hidden field" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),

                array(
                    'type'=>'editor',
                    'param_name'=>'content',
                    'label'=>'Pricing Features',
                    'desc' => "" ,
                    'default'=>'<ul class="pricing-feature-list">
    <li class="pricing-feature">1 GB of space</li>
    <li class="pricing-feature">Support at $25/hour</li>
    <li class="pricing-feature">Small social media package</li>
</ul>
<div class="pricing-footer"><a href="#" class="azp_btn azp_btn-primary azp_btn-sm">Choose plan</a></div>',
                    'iscontent'=>'yes',
                    'show_in_admin' => true,
                ),

                
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,

                    'default'=>'',
                ),

                
                
            )
        );


        $elements['AzuraSpacer'] = array(
            'name'=>'Empty Space',
            'desc'=>'Add spacer with custom height',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/empty-space.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'height',
                    'label'=>'Height',
                    'desc' => "Enter empty space height." ,
                    'default'=>'50px',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
                
            )
        );

        $elements['AzuraHeading'] = array(
            'name'=>'Custom Heading',
            'desc'=>'Add custom heading text',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/heading.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Heading Text',
                    'desc' => "" ,
                    'default'=>'This is custom heading.',
                    'iscontent'=>'yes',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'icon_type',
                    'label'=>"Icon library",
                    'desc' => "Select icon library." ,
                    'default'=>'fontawesome',
                    'value'=> array(
                        'Font Awesome'=>'fontawesome',
                        'Line icon'=>'lineicon',
                        'Simple Line icon'=>'simplelineicon',
                        'ET Line icon'=>'etlineicon',
                    ),
                    
                ),

                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_fontawesome',
                    'label'=>"Icon",
                    'desc' => "Awesome font icon" ,
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('fontawesome'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'lineicon',
                    'param_name'=>'icon_lineicon',
                    'label'=>"Icon",
                    'desc' => "Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('lineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'simplelineicon',
                    'param_name'=>'icon_simplelineicon',
                    'label'=>"Icon",
                    'desc' => "Simple Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('simplelineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'etlineicon',
                    'param_name'=>'icon_etlineicon',
                    'label'=>"Icon",
                    'desc' => "ET Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('etlineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'element_tag',
                    'label'=>'Header Tag',
                    'desc' => "" ,
                    'default'=>'h1',
                    'value'=> array(
                        'H1'=>'h1',
                        'H2'=>'h2',
                        'H3'=>'h3',
                        'H4'=>'h4',
                        'H5'=>'h5',
                        'H6'=>'h6',
                        'Paragraph'=>'p',
                        'Div'=>'div',
                        
                    ),
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'text_transform',
                    'label'=>'Text Transformation',
                    'desc' => "" ,
                    'default'=>'',
                    'value'=> array(
                        'Template Default'=>'',
                        'Uppercase'=>'uppercase',
                        'Lowercase'=>'lowercase',
                        'Capitalize'=>'capitalize',
                    ),
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'text_align',
                    'label'=>'Text Align',
                    'desc' => "" ,
                    'default'=>'',
                    'value'=> array(
                        'Template default'=>'',
                        'Left'=>'left',
                        'Right'=>'right',
                        'Center'=>'center',
                        'Justify'=>'justify',
                    ),
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'font_size',
                    'label'=>'Font Size',
                    'desc' => "Unit included. Ex: 28px" ,
                    'default'=>'',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'line_height',
                    'label'=>'Line Height',
                    'desc' => "Unit included: 36px or 1 for 'Font Size' value" ,
                    'default'=>'',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'letter_spacing',
                    'label'=>'Letter Spacing',
                    'desc' => "Unit included. Ex: 3px" ,
                    'default'=>'',
                    
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'text_indent',
                    'label'=>'Text Indentation',
                    'desc' => "Specify the indentation of the first line of a text. Unit included. Ex: 50px" ,
                    'default'=>'',
                    
                ),

                array(
                    'type'=>'color',
                    'param_name'=>'font_color',
                    'label'=>'Color',
                    'desc' => "" ,
                    'default'=>'',
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'use_template_font',
                    'label'=>'Use template font?',
                    'desc' => "Use default template font instead of custom Google font." ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),

                array(
                    'type'=>'googlefonts',
                    'param_name'=>'font_family',
                    'label'=>'Font Family',
                    'desc' => "" ,
                    'default'=>'Roboto:regular',
                    'depends_on' => array(
                        'element'=>'use_template_font',
                        'value'=>array('0'),
                        'has_value'=> false
                    ),
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
                
            )
        );

        $elements['AzuraDropcaps'] = array(
            'name'=>'Dropcaps',
            'desc'=>'Add custom heading text',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/drop-caps.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=>true,
            'attrs' => array (
                array(
                    'type'=>'select',
                    'param_name'=>'dropcaps_style',
                    'label'=>'Style',
                    'desc' => "" ,
                    'default'=>'default',
                    'value'=> array(
                        'Default'=>'default',
                        'Circle'=>'circle',
                        'Square'=>'square',
                    ),
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'dropcaps',
                    'label'=>'Dropcap letter',
                    'desc' => "" ,
                    'default'=>'V',
                    'show_in_admin' => true,
                    
                ),
                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Content',
                    'desc' => "" ,
                    'default'=>'idit vivendum sit ea ex pro regione tibique. Sed ea porro explicari, noster pertinacia eu eum. Usu in ullum omnesque atomorum integre imperdiet in. Saperet perpetua ut mei, nibh sale meis eam cu ut vim modus ex cum erat.',
                    'iscontent'=>'yes',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'element_tag',
                    'label'=>'Element Tag',
                    'desc' => "" ,
                    'default'=>'p',
                    'value'=> array(
                        'Paragraph'=>'p',
                        'Span'=>'span',
                        'Div'=>'div',
                        
                    ),
                    
                ),
                

                array(
                    'type'=>'text',
                    'param_name'=>'font_size',
                    'label'=>'Font Size',
                    'desc' => "Unit included. Ex: 14px" ,
                    'default'=>'',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'line_height',
                    'label'=>'Line Height',
                    'desc' => "Unit included: 28px or 1 for 'Font Size' value" ,
                    'default'=>'',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'letter_spacing',
                    'label'=>'Letter Spacing',
                    'desc' => "Unit included. Ex: 3px" ,
                    'default'=>'',
                    
                ),
                

                array(
                    'type'=>'color',
                    'param_name'=>'dropcaps_color',
                    'label'=>'Color',
                    'desc' => "" ,
                    'default'=>'',
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'use_template_font',
                    'label'=>'Use template font?',
                    'desc' => "Use default template font instead of custom Google font." ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),

                array(
                    'type'=>'googlefonts',
                    'param_name'=>'font_family',
                    'label'=>'Font Family',
                    'desc' => "" ,
                    'default'=>'Roboto:regular',
                    'depends_on' => array(
                        'element'=>'use_template_font',
                        'value'=>array('0'),
                        'has_value'=> false
                    ),
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
                
            )
        );

        $elements['AzuraContactForm'] = array(
            'name'=>'Contact Form',
            'desc'=>'Add AJAX contact form block',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/contactform.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'title',
                    'label'=>'Title',
                    'desc' => "" ,
                    'default'=>'',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'emailsubject',
                    'label'=>'Email Subject',
                    'desc' => "" ,
                    'default'=>'Support Request',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showsubject',
                    'label'=>'Show Subject',
                    'desc' => "Show Subject field instead of hidden field" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showwebsite',
                    'label'=>'Show Website Field',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'thanksmessage',
                    'label'=>'Thanks Message',
                    'desc' => "" ,
                    'default'=>'Thank you for contacting with us',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'redirect',
                    'label'=>'Redirect',
                    'desc' => "Set page link user will redirect to after submit form instead of hidding the form." ,
                    'default'=>'',
                ),

                array(
                    'type'=>'label',
                    'param_name'=>'form_email_temps',
                    'label'=>'<strong>Setup Email Templates</strong>',
                    'desc'=>'You can setup email templates from <strong>Contact Form</strong> tab on <a href="'.JUri::base().'index.php?option=com_config&view=component&component=com_azurapagebuilder&path=" target="_blank">Azura Component Options</a> page.'
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
                
                
            )
        );

        $elements['AzuraK2Grid'] = array(
            'name'=>'K2s Grid',
            'desc'=>'Display grid k2 items',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/k2.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'article_ids',
                    'label'=>'Article IDs',
                    'desc' => "Enter article ids to show, separated by a comma (,). Ex: 99,100 " ,
                    'default'=>'',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'sqlselect',
                    'param_name'=>'category',
                    'label'=>'Select a category',
                    'desc' => "Select a k2 category get item from" ,
                    'default'=>'',

                    'query'=>"SELECT id AS value, name AS category FROM #__k2_categories WHERE published=1 AND trash=0",
                    'titlekey'=>'category',
                    'valuekey'=>'value',
                    'show_in_admin' => true,

                ),
                array(
                    'type'=>'text',
                    'param_name'=>'limit',
                    'label'=>'Limit (for category source only)',
                    'desc' => "Number or All " ,
                    'default'=>'All',
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'order',
                    'label'=>'Order (for category source only)',
                    'desc' => "" ,
                    'default'=>'created',
                    'value'=> array(
                        'Created'=>'created',
                        'ID'=>'id',
                        'Ordering'=>'ordering',
                    )
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'orderdir',
                    'label'=>'Sort Order (for category source only)',
                    'desc' => "" ,
                    'default'=>'DESC',
                    'value'=> array(
                        'Ascending'=>'ASC',
                        'Descending'=>'DESC',
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'childcat',
                    'label'=>'Fetch Child Category',
                    'desc' => "Get items from child categories?" ,
                    'default'=>'0',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',   

                    ),
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'columns',
                    'label'=>"Columns Grid",
                    'desc' => "" ,
                    
                    'value'=> array(
                        'One Column'=>'one',
                        'Two Columns'=>'two',
                        'Three Columns'=>'three',
                        'Four Columns'=>'four',
                        'Five Columns'=>'five',
                        'Six Columns'=>'six',
                        'Seven Columns'=>'seven',
                        'Eight Columns'=>'eight',
                        'Nine Columns'=>'nine',
                        'Ten Columns'=>'ten',
                    ),
                    'default'=>'three',
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'tablet_columns',
                    'label'=>"Tablet Columns Grid",
                    'desc' => "" ,
                    
                    'value'=> array(
                        'One Column'=>'one',
                        'Two Columns'=>'two',
                        'Three Columns'=>'three',
                        'Four Columns'=>'four',
                        'Five Columns'=>'five',
                        'Six Columns'=>'six',
                        'Seven Columns'=>'seven',
                        'Eight Columns'=>'eight',
                        'Nine Columns'=>'nine',
                        'Ten Columns'=>'ten',
                    ),
                    'default'=>'two',
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'mobile_columns',
                    'label'=>"Mobile Columns Grid",
                    'desc' => "" ,
                    
                    'value'=> array(
                        'One Column'=>'one',
                        'Two Columns'=>'two',
                        'Three Columns'=>'three',
                        'Four Columns'=>'four',
                        'Five Columns'=>'five',
                        'Six Columns'=>'six',
                        'Seven Columns'=>'seven',
                        'Eight Columns'=>'eight',
                        'Nine Columns'=>'nine',
                        'Ten Columns'=>'ten',
                    ),
                    'default'=>'one',
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'spacing',
                    'label'=>"Spacing",
                    'desc' => "" ,
                    'value'=> array(
                        'None'=>'one',
                        'Two Columns'=>'none',
                        'Extra Small'=>'extrasmall',
                        'Small'=>'small',
                        'Medium'=>'medium',
                        'Big'=>'big',
                    ),
                    'default'=>'big',
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'showfilter',
                    'label'=>"Show Tags filter",
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'filter_all',
                    'label'=>"Show All in filter",
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    ),
                    'depends_on'=> array(
                        'element'=>'showfilter',
                        'value' => array('1'),
                        'has_value'=> false
                    )
                    
                ),


                array(
                    'type'=>'switch',
                    'param_name'=>'showthumbnail',
                    'label'=>'Show Thumbnail',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showtitle',
                    'label'=>'Show title',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showdate',
                    'label'=>'Show Created Date',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showauthor',
                    'label'=>'Show Author',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showcat',
                    'label'=>'Show category',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'showtags',
                    'label'=>'Show tags',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'showintrotext',
                    'label'=>'Show Introtext',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showredmore',
                    'label'=>'Show Read more',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label' => "Extra Class" ,
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                ),

                
            )
        );

        $elements['AzuraContacts'] = array(
            'name'=>'Contacts Grid',
            'desc'=>'A column grid of contact articles',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/contacts.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'contact_ids',
                    'label'=>'Contact IDs',
                    'desc' => "Enter contact ids to show, separated by a comma (,). Ex: 99,100 " ,
                    'default'=>'',
                    'show_in_admin' => true,
                ),
                // array(
                //     'type'=>'sqlselect',
                //     'param_name'=>'category',
                //     'label'=>'Or select a category',
                //     'desc' => "Choose category get items from",
                //     'default'=>'',

                //     'query'=>"SELECT id AS value, title AS category FROM #__categories WHERE extension='com_contact' AND published=1",
                //     'titlekey'=>'category',
                //     'valuekey'=>'value',

                // ),
                // array(
                //     'type'=>'text',
                //     'param_name'=>'limit',
                //     'label'=>'Limit (for category source only)',
                //     'desc' => "Number or All " ,
                //     'default'=>'',
                // ),
                // array(
                //     'type'=>'select',
                //     'param_name'=>'order',
                //     'label'=>'Order (for category source only)',
                //     'desc' => "" ,
                //     'default'=>'created',
                //     'value'=> array(
                //         'Created'=>'created',
                //         'ID'=>'id',
                //         'Ordering'=>'ordering',
                //     )
                // ),
                // array(
                //     'type'=>'select',
                //     'param_name'=>'orderdir',
                //     'label'=>'Sort Order (for category source only)',
                //     'desc' => "" ,
                //     'default'=>'DESC',
                //     'value'=> array(
                //         'Ascending'=>'ASC',
                //         'Descending'=>'DESC',
                //     )
                // ),

                array(
                    'type'=>'select',
                    'param_name'=>'columns',
                    'label'=>"Columns Grid",
                    'desc' => "" ,
                    'value'=> array(
                        'One Column'=>'col-md-12',
                        'Two Columns'=>'col-md-6',
                        'Three Columns'=>'col-md-4',
                        'Four Columns'=>'col-md-3',
                        'Six Columns'=>'col-md-2',
                    ),
                    'default'=>'col-md-4',
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'tablet_columns',
                    'label'=>"Tablet Columns Grid",
                    'desc' => "" ,
                    'value'=> array(
                        'One Column'=>'col-sm-12',
                        'Two Columns'=>'col-sm-6',
                        'Three Columns'=>'col-sm-4',
                        'Four Columns'=>'col-sm-3',
                        'Six Columns'=>'col-sm-2',
                    ),
                    'default'=>'col-sm-6',
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'mobile_columns',
                    'label'=>"Mobile Columns Grid",
                    'desc' => "" ,
                    'value'=> array(
                        'One Column'=>'col-xs-12',
                        'Two Columns'=>'col-xs-6',
                        'Three Columns'=>'col-xs-4',
                        'Four Columns'=>'col-xs-3',
                        'Six Columns'=>'col-xs-2',
                    ),
                    'default'=>'col-sx-12',
                    
                ),

                
                


                array(
                    'type'=>'switch',
                    'param_name'=>'showthumbnail',
                    'label'=>'Show Thumbnail',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'caption_style',
                    'label'=>"Caption Style",
                    'desc' => "" ,
                    'value'=> array(
                        'ZoomIn'=>'capZoomIn',
                        'ZoomInDown'=>'capZoomInDown',
                        'RollIn'=>'capRollIn',
                        'RotateIn'=>'capRotateIn',
                        'BounceOut'=>'capBounceOut',
                    ),
                    'default'=>'capZoomInDown',
                    'depends_on' => array(
                        'element' => 'showthumbnail',
                        'value'     => array('1'),
                        'has_value' => false
                    )
                    
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showsocials',
                    'label'=>'Show Contact Links',
                    'desc' => "Contact Links is set on Display tab in the contact editing screen. You can use (Line icon) <strong>azp_lineicon-{icon-name}</strong> or <strong>Awesome Font</strong> icon class: <strong>fa fa-facebook</strong> for creating social icon link. <a href='".JURI::root().'media/com_azurapagebuilder/images/contact-socials.png'."' target='_blank'>Demo</a>" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    ),
                    'depends_on' => array(
                        'element' => 'showthumbnail',
                        'value'     => array('1'),
                        'has_value' => false
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showtitle',
                    'label'=>'Show Name',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showpos',
                    'label'=>'Show Position',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                

                array(
                    'type'=>'switch',
                    'param_name'=>'show_intro',
                    'label'=>'Show Introtext',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showsingle',
                    'label'=>'Show Link to contact page',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    ),

                ),
                array(
                    'type'=>'select',
                    'param_name'=>'link_target',
                    'label'=>"Open link in",
                    'desc' => "" ,
                    'default'=>'_self',
                    'value'=> array(
                        'New tab'=>'_blank',
                        'Current tab'=>'_self',
                    ),
                    'depends_on'=> array(
                        'element'=> 'showsingle',
                        'value'=> array('1'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label' => "Extra Class" ,
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                ),

                
            )
        );

        $elements['Testimonial'] = array(
            'name'=>'Single Testimonial',
            'desc'=>'Whats customer say',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/testimonial.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showTypographyTab'=> true,
            'showAnimationTab'=>true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'name',
                    'label'=>'Name',
                    'desc' => "" ,
                    'default'=>'Lasmini',
                    'show_in_admin' => true,
                ),
                
                array(
                    'type'=>'image',
                    'param_name'=>'avatar',
                    'label'=>'Avatar',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Content',
                    'desc' => "" ,
                    'iscontent' => 'yes',
                    'default'=>'<p>Debet error everti ex pri, an vis soluta alienum intellegat. Nusquam praesent ea per, sit no nibh fabulas, pri modo tibique percipitur an pri utinam legere antiopam et.</p>',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'rating',
                    'label'=>"Rating",
                    'desc' => "" ,
                    'default'=>'3.5',
                    'value'=> array(
                        'Not reated'=>'no',
                        '1 Star'=>'1',
                        '2 Stars'=>'2',
                        '2.5 Stars'=>'2.5',
                        '3 Stars'=>'3',
                        '3.5 Stars'=>'3.5',
                        '4 Stars'=>'4',
                        '4.5 Stars'=>'4.5',
                        '5 Stars'=>'5',
                    ),   
                    
                ),
                

                array(
                    'type'=>'text',
                    'param_name'=>'position',
                    'label'=>'Job position',
                    'desc' => "" ,
                    'default'=>'Manager',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'company',
                    'label'=>'Company',
                    'desc' => "" ,
                    'default'=>'Saursepuh corp.',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'com_link',
                    'label'=>'Image Link',
                    'desc' => "" ,
                    'default'=>'#',
                    'depends_on'=> array(
                        'element'=> 'company',
                        'value'=> array(),
                        'has_value' => true,
                    ),
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'link_target',
                    'label'=>"Open link in",
                    'desc' => "" ,
                    'default'=>'_blank',
                    'value'=> array(
                        'New tab'=>'_blank',
                        'Current tab'=>'_self',
                    ),
                    'depends_on'=> array(
                        'element'=> 'company',
                        'value'=> array(),
                        'has_value' => true,
                    ),
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'testi_style',
                    'label'=>"Style",
                    'desc' => "" ,
                    'default'=>'style1',
                    'value'=> array(
                        'Style 1'=>'style1',
                        'Style 2'=>'style2',
                    ),
                  
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'testi_align',
                    'label'=>"Style",
                    'desc' => "" ,
                    'default'=>'testi-left',
                    'value'=> array(
                        'Left'=>'testi-left',
                        'Center'=>'testi-center',
                        'Right'=>'testi-right',
                    ),
                    'depends_on'=> array(
                        'element'=> 'testi_style',
                        'value'=> array('style1'),
                        'has_value' => false,
                    ),
                    
                ),


                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),

                
            )
        );

        $elements['TestimonialsSlider'] = array(
            'name'=>'Testimonials Slider',
            'desc'=>'Slider of testimonials',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/testimonials.png',
            'open_settings_on_create'=>true,
            'hasownchild'=>"yes",
            'childname'=>"Tesimonial Slide Item",
            'childtypename'=>"TestimonialsSliderItem",
            'showStyleTab'=> true,
            'showTypographyTab' => true,
            'showAnimationTab'=> true,
            'showResponsiveTab'=> false,
            'attrs' => array (
                array(
                    'type'=>'select',
                    'param_name'=>'testi_style',
                    'label'=>"Style",
                    'desc' => "" ,
                    'default'=>'style1',
                    'value'=> array(
                        'Style 1'=>'style1',
                        'Style 2'=>'style2',
                    ),
                  
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'testi_align',
                    'label'=>"Style",
                    'desc' => "" ,
                    'default'=>'testi-center',
                    'value'=> array(
                        'Left'=>'testi-left',
                        'Center'=>'testi-center',
                        'Right'=>'testi-right',
                    ),
                    'depends_on'=> array(
                        'element'=> 'testi_style',
                        'value'=> array('style1'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'autoplay',
                    'label'=>'Autoplay',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'slider_items',
                    'label'=>'Slider items',
                    'desc' => "Number of items display in view port" ,
                    'default'=>'1',
                ),  

                array(
                    'type'=>'text',
                    'param_name'=>'slideby',
                    'label'=>'Slide By',
                    'desc' => "Navigation slide by x. 'page' string can be set to slide by page" ,
                    'default'=>'1',
                ),


                

                array(
                    'type'=>'switch',
                    'param_name'=>'center_mode',
                    'label'=>'Center mode',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'autoheight',
                    'label'=>'Auto height',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'responsive',
                    'label'=>'Responsive',
                    'desc' => "The format is: screen-size:number-items-display,larger-screen-size:number-items-display. Ex: 320:1,768:2,1200:2" ,
                    'default'=>'',
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'nav',
                    'label'=>'Show Navigation',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'dots',
                    'label'=>'Show Pagination',
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        $elements['TestimonialsSliderItem'] = array(
            'name'=>"Tesimonial Slide Item",
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/testimonial.png',
            'open_settings_on_create'=>true,
            'isownchild' => 'yes',
            'showStyleTab'=> true,
            'showAnimationTab'=> false,
            'showResponsiveTab'=> false,
            'attrs' => array(
                array(
                    'type'=>'text',
                    'param_name'=>'name',
                    'label'=>'Name',
                    'desc' => "" ,
                    'default'=>'Lasmini',
                    'show_in_admin' => true,
                ),
                
                array(
                    'type'=>'image',
                    'param_name'=>'avatar',
                    'label'=>'Avatar',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Content',
                    'desc' => "" ,
                    'iscontent' => 'yes',
                    'default'=>'<p>Debet error everti ex pri, an vis soluta alienum intellegat. Nusquam praesent ea per, sit no nibh fabulas, pri modo tibique percipitur an pri utinam legere antiopam et.</p>',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'rating',
                    'label'=>"Rating",
                    'desc' => "" ,
                    'default'=>'3.5',
                    'value'=> array(
                        'Not reated'=>'no',
                        '1 Star'=>'1',
                        '2 Stars'=>'2',
                        '2.5 Stars'=>'2.5',
                        '3 Stars'=>'3',
                        '3.5 Stars'=>'3.5',
                        '4 Stars'=>'4',
                        '4.5 Stars'=>'4.5',
                        '5 Stars'=>'5',
                    ),   
                    
                ),
                

                array(
                    'type'=>'text',
                    'param_name'=>'position',
                    'label'=>'Job position',
                    'desc' => "" ,
                    'default'=>'Manager',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'company',
                    'label'=>'Company',
                    'desc' => "" ,
                    'default'=>'Saursepuh corp.',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'com_link',
                    'label'=>'Image Link',
                    'desc' => "" ,
                    'default'=>'#',
                    'depends_on'=> array(
                        'element'=> 'company',
                        'value'=> array(),
                        'has_value' => true,
                    ),
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'link_target',
                    'label'=>"Open link in",
                    'desc' => "" ,
                    'default'=>'_blank',
                    'value'=> array(
                        'New tab'=>'_blank',
                        'Current tab'=>'_self',
                    ),
                    'depends_on'=> array(
                        'element'=> 'company',
                        'value'=> array(),
                        'has_value' => true,
                    ),
                    
                ),
  


                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
            )
        );

        $elements['AzuraHtml'] = array(
            'name'=>'Text Block (old)',
            'desc'=>'A block of text with WYSIWYG editor',
            'category'=>"deprecated",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/text-block.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                array(
                    'type'=>'editor',
                    
                    'param_name'=>'content',
                    'label'=>'Content',
                    'show_in_admin' => true,
                    'desc' => "Text Content (Can be used with HTML tags)" ,
                    'default'=>'<h3>Back End Page Builder</h3><p>Build a responsive website and manage your content easily with super fast back-end builder. No programming knowledge required – create stunning and beautiful pages with drag and drop builder.</p>',
                    'iscontent'=>'yes'
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,

                    'default'=>''
                ),
                
            )
        );

        $elements['AzuraText'] = array(
            'name'=>'Raw HTML (old)',
            'desc'=>'Output raw html code on your page',
            'category'=>"deprecated",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/raw-html.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                array(
                    'type'=>'aceeditor',//aceeditor
                    'mode'=>'html',
                    'param_name'=>'content',
                    'label'=>'Text Content (Can be use with html tags.)',
                    'desc' => "Text Content (Can be use with html tags)" ,
                    'default'=>'',
                    'iscontent'=>'yes'
                )
                
            )
        );

        /* For Styles - Animations and Responsive tabs */

        $elements['ElementStyleOptions'] = array(
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'padding_top',
                    'label'=>'Padding top',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'padding_right',
                    'label'=>'Padding right',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'padding_bottom',
                    'label'=>'Padding bottom',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'padding_left',
                    'label'=>'Padding left',
                    'desc' => "" ,
                    'default'=>''
                ),
                

                array(
                    'type'=>'text',
                    'param_name'=>'border_top',
                    'label'=>'Border top',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'border_right',
                    'label'=>'Border right',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'border_bottom',
                    'label'=>'Border bottom',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'border_left',
                    'label'=>'Border left',
                    'desc' => "" ,
                    'default'=>''
                ),
                

                array(
                    'type'=>'text',
                    'param_name'=>'margin_top',
                    'label'=>'Margin top',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'margin_right',
                    'label'=>'Margin right',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'margin_bottom',
                    'label'=>'Margin bottom',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'margin_left',
                    'label'=>'Margin left',
                    'desc' => "" ,
                    'default'=>''
                ),
                

                array(
                    'type'=>'color',
                    'param_name'=>'border_color',
                    'label'=>'Border Color',
                    'desc' => "" ,
                    'default'=>'',
                    //'rgba'=> true
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'border_style',
                    'label'=>'Border Style',
                    'desc' => "" ,
                    'default'=>'',
                    "value" => array(   
                        'Default' => '',  
                        'Solid' => 'solid',   
                        'Dotted' => 'dotted',   
                        'Dashed' => 'dashed',   
                        'None' => 'none',   
                        'Hidden' => 'hidden',   
                        'Double' => 'double',   
                        'Groove' => 'groove',   
                        'Ridge' => 'ridge',   
                        'Inset' => 'inset',   
                        'Outset' => 'outset',   
                        'Initial' => 'initial',   
                        'Inherit' => 'inherit',   

                    ),
                ),

                array(
                    'type'=>'color',
                    'param_name'=>'background_color',
                    'label'=>'Background Color',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'image',
                    'param_name'=>'background_image',
                    'label'=>'Background Image',
                    'fieldclass'=>'input-small',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'background_repeat',
                    'label'=>'Background Repeat',
                    'desc' => "" ,
                    'default'=>'',
                    "value" => array(   
                        'Default - Repeat' => '',  
                        'Repeat X' => 'repeat-x',   
                        'Repeat Y' => 'repeat-y',   
                        'No Repeat' => 'no-repeat',     

                    ),
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'background_attachment',
                    'label'=>'Background Attachment',
                    'desc' => "" ,
                    'default'=>'',
                    "value" => array(   
                        'Default - Scroll' => '',  
                        'Fixed' => 'fixed',   
                        'Local' => 'local',     

                    ),
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'background_size',
                    'label'=>'Background Size',
                    'desc' => "" ,
                    'default'=>'',
                    "value" => array(   
                        'Default - Auto' => '',  
                        'Cover' => 'cover',   
                        'Contain' => 'contain',     

                    ),
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'background_position',
                    'label'=>'Background Position',
                    'desc' => "" ,
                    'default'=>'',
                    "value" => array(   
                        'Default' => '',  
                        'Left - Top' => 'left top',      
                        'Left - Center' => 'left center',      
                        'Left - Bottom' => 'left bottom',      
                        'Right - Top' => 'right top',      
                        'Right - Center' => 'right center',      
                        'Right - Bottom' => 'right bottom',      
                        'Center - Top' => 'center top',      
                        'Center - Center' => 'center center',      
                        'Center - Bottom' => 'center bottom',      
                    ),
                ),
                array(
                    'type'=>'textarea',
                    'param_name'=>'additional_style',
                    'label'=>'Additional Inline Style',
                    'fieldclass'=>'ele-inline-css',
                    'desc' => "" ,
                    'default'=>''
                ),
                // array(
                //     'type'=>'checkbox',
                //     'param_name'=>'simplified',
                //     'label'=>'Box Control',
                //     'fieldclass'=>'',
                //     'desc' => "" ,
                //     'default'=>'0',
                //     "value" => '1',
                // ),
            )
        );

        $elements['ElementTypographyOptions'] = array(
            'attrs' => array (
                array(
                    'type'=>'switch',
                    'param_name'=>'typo_tempfont',
                    'label'=>'Use template font?',
                    'desc' => "Use default template font instead of custom Google font." ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',

                    ),
                ),

                array(
                    'type'=>'googlefonts',
                    'param_name'=>'typo_googlefont',
                    'label'=>'Google Font',
                    'desc' => "" ,
                    'default'=>'Roboto:regular',
                    'depends_on' => array(
                        'element'=>'typo_tempfont',
                        'value'=>array('0'),
                        'has_value'=> false
                    ),
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'typo_fontsize',
                    'label'=>'Font Size',
                    'desc' => "Unit included. Ex: 14px",
                    'default'=>''
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'typo_lheight',
                    'label'=>'Line Height',
                    'desc' => "Unit included: 28px or 1 for 'Font Size' value" ,
                    'default'=>'',
                    
                ),
                array(
                    'type'=>'color',
                    'param_name'=>'typo_textcolor',
                    'label'=>'Text Color',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'typo_textalign',
                    'label'=>'Text Align',
                    'desc' => "" ,
                    'default'=>'',
                    'value'=> array(
                        'Template Default'=>'',
                        'Left'=>'left',
                        'Right'=>'right',
                        'Center'=>'center',
                        'Justify'=>'justify',
                    ),
                    
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'typo_texttransform',
                    'label'=>'Text Transformation',
                    'desc' => "" ,
                    'default'=>'',
                    'value'=> array(
                        'Template Default'=>'',
                        'Uppercase'=>'uppercase',
                        'Lowercase'=>'lowercase',
                        'Capitalize'=>'capitalize',
                    ),
                    
                ),
                

   
                
                array(
                    'type'=>'text',
                    'param_name'=>'typo_letterspacing',
                    'label'=>'Letter Spacing',
                    'desc' => "Unit included. Ex: 3px" ,
                    'default'=>'',
                    
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'typo_textindent',
                    'label'=>'Text Indentation',
                    'desc' => "Specify the indentation of the first line of a text. Unit included. Ex: 50px" ,
                    'default'=>'',
                    
                ),



                
            )
        );

        $elements['ElementAnimationOptions'] = array(
            'attrs' => array (
                array(
                    'type'=>'switch',
                    'param_name'=>'animation',
                    'label'=>'Use Animation',
                    'desc' => "" ,
                    'default'=>'0',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',                                                                                
                    ),
                ),
                

                array(
                    'type'=>'select',
                    'param_name'=>'animationtype',
                    'label'=>'Animation Type',
                    'desc' => "" ,
                    'default'=>'fade-in',
                    "value" => array(   
                        'fade-in' => 'fade-in',   
                        'fade-in-up' => 'fade-in-up',   
                        'fade-in-up-big' => 'fade-in-up-big',   
                        'fade-in-up-large' => 'fade-in-up-large', 

                        'fade-in-down' => 'fade-in-down',   
                        'fade-in-down-big' => 'fade-in-down-big',   
                        'fade-in-down-large' => 'fade-in-down-large',  

                        'fade-in-left' => 'fade-in-left',   
                        'fade-in-left-big' => 'fade-in-left-big',   
                        'fade-in-left-large' => 'fade-in-left-large',  

                        'fade-in-right' => 'fade-in-right',   
                        'fade-in-right-big' => 'fade-in-right-big',   
                        'fade-in-right-large' => 'fade-in-right-large',   

                        'fade-in-up-left' => 'fade-in-up-left',   
                        'fade-in-up-left-big' => 'fade-in-up-left-big',   
                        'fade-in-up-left-large' => 'fade-in-up-left-large',

                        'fade-in-up-right' => 'fade-in-up-right',   
                        'fade-in-up-right-big' => 'fade-in-up-right-big',   
                        'fade-in-up-right-large' => 'fade-in-up-right-large',  

                        'fade-in-down-left' => 'fade-in-down-left',   
                        'fade-in-down-left-big' => 'fade-in-down-left-big',   
                        'fade-in-down-left-large' => 'fade-in-down-left-large',  

                        'fade-in-down-right' => 'fade-in-down-right',   
                        'fade-in-down-right-big' => 'fade-in-down-right-big',   
                        'fade-in-down-right-large' => 'fade-in-down-right-large',   

                        'fade-out' => 'fade-out',   

                        'fade-out-up' => 'fade-out-up',   
                        'fade-out-up-big' => 'fade-out-up-big',   
                        'fade-out-up-large' => 'fade-out-up-large',   

                        'fade-out-down' => 'fade-out-down',   
                        'fade-out-down-big' => 'fade-out-down-big',   
                        'fade-out-down-large' => 'fade-out-down-large',  

                        'fade-out-left' => 'fade-out-left',   
                        'fade-out-left-big' => 'fade-out-left-big',   
                        'fade-out-left-large' => 'fade-out-left-large', 

                        'fade-out-right' => 'fade-out-right',   
                        'fade-out-right-big' => 'fade-out-right-big',   
                        'fade-out-right-large' => 'fade-out-right-large',   

                        'fade-out-up-left' => 'fade-out-up-left',   
                        'fade-out-up-left-big' => 'fade-out-up-left-big',   
                        'fade-out-up-left-large' => 'fade-out-up-left-large', 

                        'fade-out-up-right' => 'fade-out-up-right',   
                        'fade-out-up-right-big' => 'fade-out-up-right-big',   
                        'fade-out-up-right-large' => 'fade-out-up-right-large',   

                        'fade-out-down-left' => 'fade-out-down-left',   
                        'fade-out-down-left-big' => 'fade-out-down-left-big',   
                        'fade-out-down-left-large' => 'fade-out-down-left-large',   

                        'fade-out-down-right' => 'fade-out-down-right',   
                        'fade-out-down-right-big' => 'fade-out-down-right-big',   
                        'fade-out-down-right-large' => 'fade-out-down-right-large',   

                        'bounce-in' => 'bounce-in',   
                        'bounce-in-big' => 'bounce-in-big',   
                        'bounce-in-large' => 'bounce-in-large', 

                        'bounce-in-up' => 'bounce-in-up',   
                        'bounce-in-up-big' => 'bounce-in-up-big',   
                        'bounce-in-up-large' => 'bounce-in-up-large',   

                        'bounce-in-down' => 'bounce-in-down',   
                        'bounce-in-down-big' => 'bounce-in-down-big',   
                        'bounce-in-down-large' => 'bounce-in-down-large', 

                        'bounce-in-left' => 'bounce-in-left',   
                        'bounce-in-left-big' => 'bounce-in-left-big',   
                        'bounce-in-left-large' => 'bounce-in-left-large',  

                        'bounce-in-right' => 'bounce-in-right',   
                        'bounce-in-right-big' => 'bounce-in-right-big',   
                        'bounce-in-right-large' => 'bounce-in-right-large',  

                        'bounce-in-up-left' => 'bounce-in-up-left',   
                        'bounce-in-up-left-big' => 'bounce-in-up-left-big',   
                        'bounce-in-up-left-large' => 'bounce-in-up-left-large',  

                        'bounce-in-up-right' => 'bounce-in-up-right',   
                        'bounce-in-up-right-big' => 'bounce-in-up-right-big',   
                        'bounce-in-up-right-large' => 'bounce-in-up-right-large', 

                        'bounce-in-down-left' => 'bounce-in-down-left',   
                        'bounce-in-down-left-big' => 'bounce-in-down-left-big',   
                        'bounce-in-down-left-large' => 'bounce-in-down-left-large',  

                        'bounce-in-down-right' => 'bounce-in-down-right',   
                        'bounce-in-down-right-big' => 'bounce-in-down-right-big',   
                        'bounce-in-down-right-large' => 'bounce-in-down-right-large',   

                        'bounce-out' => 'bounce-out',   
                        'bounce-out-big' => 'bounce-out-big',   
                        'bounce-out-large' => 'bounce-out-large',   

                        'bounce-out-up' => 'bounce-out-up',   
                        'bounce-out-up-big' => 'bounce-out-up-big',   
                        'bounce-out-up-large' => 'bounce-out-up-large',   

                        'bounce-out-down' => 'bounce-out-down',   
                        'bounce-out-down-big' => 'bounce-out-down-big',   
                        'bounce-out-down-large' => 'bounce-out-down-large', 



                        'bounce-out-left' => 'bounce-out-left',   
                        'bounce-out-left-big' => 'bounce-out-left-big',   
                        'bounce-out-left-large' => 'bounce-out-left-large',  

                        'bounce-out-right' => 'bounce-out-right',   
                        'bounce-out-right-big' => 'bounce-out-right-big',   
                        'bounce-out-right-large' => 'bounce-out-right-large',   

                        'bounce-out-up-left' => 'bounce-out-up-left',   
                        'bounce-out-up-left-big' => 'bounce-out-up-left-big',   
                        'bounce-out-up-left-large' => 'bounce-out-up-left-large',   

                        'bounce-out-up-right' => 'bounce-out-up-right',   
                        'bounce-out-up-right-big' => 'bounce-out-up-right-big',   
                        'bounce-out-up-right-large' => 'bounce-out-up-right-large',  

                        'bounce-out-down-left' => 'bounce-out-down-left',   
                        'bounce-out-down-left-big' => 'bounce-out-down-left-big',   
                        'bounce-out-down-left-large' => 'bounce-out-down-left-large', 

                        'bounce-out-down-right' => 'bounce-out-down-right',   
                        'bounce-out-down-right-big' => 'bounce-out-down-right-big',   
                        'bounce-out-down-right-large' => 'bounce-out-down-right-large',   

                        'zoom-in' => 'zoom-in', 

                        'zoom-in-up' => 'zoom-in-up',   
                        'zoom-in-up-big' => 'zoom-in-up-big',   
                        'zoom-in-up-large' => 'zoom-in-up-large',   

                        'zoom-in-down' => 'zoom-in-down',   
                        'zoom-in-down-big' => 'zoom-in-down-big',   
                        'zoom-in-down-large' => 'zoom-in-down-large', 

                        'zoom-in-left' => 'fadzoom-in-lefte',   
                        'zoom-in-left-big' => 'zoom-in-left-big',   
                        'zoom-in-left-large' => 'zoom-in-left-large',   

                        'zoom-in-right' => 'zoom-in-right',   
                        'zoom-in-right-big' => 'zoom-in-right-big',   
                        'zoom-in-right-large' => 'zoom-in-right-large', 

                        'zoom-in-up-left' => 'zoom-in-up-left',   
                        'zoom-in-up-left-big' => 'zoom-in-up-left-big',   
                        'zoom-in-up-left-large' => 'zoom-in-up-left-large',   

                        'zoom-in-up-right' => 'zoom-in-up-right',   
                        'zoom-in-up-right-big' => 'zoom-in-up-right-big',   
                        'zoom-in-up-right-large' => 'zoom-in-up-right-large',   

                        'zoom-in-down-left' => 'zoom-in-down-left',   
                        'zoom-in-down-left-big' => 'zoom-in-down-left-big',   
                        'zoom-in-down-left-large' => 'zoom-in-down-left-large',   

                        'zoom-in-down-right' => 'zoom-in-down-right',   
                        'zoom-in-down-right-big' => 'zoom-in-down-right-big',   
                        'zoom-in-down-right-large' => 'zoom-in-down-right-large', 

                        'zoom-out' => 'zoom-out',   

                        'zoom-out-up' => 'zoom-out-up',   
                        'zoom-out-up-big' => 'zoom-out-up-big',   
                        'zoom-out-up-large' => 'zoom-out-up-large',

                        'zoom-out-down' => 'zoom-out-down',   
                        'zoom-out-down-big' => 'zoom-out-down-big',   
                        'zoom-out-down-large' => 'zoom-out-down-large',  

                        'zoom-out-left' => 'zoom-out-left',   
                        'zoom-out-left-big' => 'zoom-out-left-big',   
                        'zoom-out-left-large' => 'zoom-out-left-large',   

                        'zoom-out-right' => 'zoom-out-right',   
                        'zoom-out-right-big' => 'zoom-out-right-big',   
                        'zoom-out-right-large' => 'zoom-out-right-large', 

                        'zoom-out-up-left' => 'zoom-out-up-left',   
                        'zoom-out-up-left-big' => 'zoom-out-up-left-big',   
                        'zoom-out-up-left-large' => 'zoom-out-up-left-large',   

                        'zoom-out-up-right' => 'zoom-out-up-right',   
                        'zoom-out-up-right-big' => 'zoom-out-up-right-big',   
                        'zoom-out-up-right-large' => 'zoom-out-up-right-large',

                        'zoom-out-down-left' => 'zoom-out-down-left',   
                        'zoom-out-down-left-big' => 'zoom-out-down-left-big',   
                        'zoom-out-down-left-large' => 'zoom-out-down-left-large',   

                        'zoom-out-down-right' => 'zoom-out-down-right',   
                        'zoom-out-down-right-big' => 'zoom-out-down-right-big',   
                        'zoom-out-down-right-large' => 'zoom-out-down-right-large',

                        'flip-in-x' => 'flip-in-x',   
                        'flip-in-y' => 'flip-in-y',   
                        'flip-in-top-front' => 'flip-in-top-front',   
                        'flip-in-top-back' => 'flip-in-top-back',   
                        'flip-in-bottom-front' => 'flip-in-bottom-front',   
                        'flip-in-bottom-back' => 'flip-in-bottom-back',   
                        'flip-in-left-front' => 'flip-in-left-front',   
                        'flip-in-left-back' => 'flip-in-left-back',   
                        'flip-in-right-front' => 'flip-in-right-front',   
                        'flip-in-right-back' => 'flip-in-right-back',   
                        'flip-out-x' => 'flip-out-x',   
                        'flip-out-y' => 'flip-out-y',   
                        'flip-out-top-front' => 'flip-out-top-front',   
                        'flip-out-top-back' => 'flip-out-top-back',   
                        'flip-out-bottom-front' => 'flip-out-bottom-front',   
                        'flip-out-bottom-back' => 'flip-out-bottom-back',   
                        'flip-out-left-front' => 'flip-out-left-front',   
                        'flip-out-left-back' => 'flip-out-left-back',   
                        'flip-out-right-front' => 'flip-out-right-front',   
                        'flip-out-right-back' => 'flip-out-right-back',   
                        'flash' => 'flash',   
                        'strobe' => 'strobe',   
                        'shake-x' => 'shake-x',   
                        'shake-y' => 'shake-y',   
                        'bounce' => 'bounce',   
                        'tada' => 'tada',   
                        'rubber-band' => 'rubber-band',   
                        'swing' => 'swing',   
                        'spin' => 'spin',   
                        'spin-reverse' => 'spin-reverse',   
                        'slingshot' => 'slingshot',   
                        'slingshot-reverse' => 'slingshot-reverse',   
                        'wobble' => 'wobble',   
                        'pulse' => 'pulse',   
                        'pulsate' => 'pulsate',   
                        'heartbeat' => 'heartbeat',   
                        'panic' => 'panic',   
                
                        

                    ),
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'animationdelay',
                    'label'=>'Animation Delay',
                    'desc' => "Animation delay in milisecond" ,
                    'default'=>'100',
                ),
                
            )
        );
        //new animation from version 3
        $elements['ElementAnimationOptions'] = array(
            'attrs' => array (
                array(
                    'type'=>'switch',
                    'param_name'=>'animation',
                    'label'=>'Use Animation',
                    'desc' => "" ,
                    'default'=>'0',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',                                                                                
                    ),
                ),
                

                array(
                    'type'=>'animationselector',
                    'param_name'=>'animationtype',
                    'label'=>'Animation Type',
                    'desc' => "" ,
                    'default'=>'fadeIn',
                    "value" => array(   
                        'bounce' => 'bounce',
                        'flash' => 'flash',
                        'pulse' => 'pulse',
                        'rubberBand' => 'rubberBand',
                        'shake' => 'shake',
                        'headShake' => 'headShake',
                        'swing' => 'swing',
                        'tada' => 'tada',
                        'jello' => 'jello',
                        'bounceIn' => 'bounceIn',
                        'bounceInDown' => 'bounceInDown',
                        'bounceInLeft' => 'bounceInLeft',
                        'bounceInRight' => 'bounceInRight',
                        'bounceInUp' => 'bounceInUp',
                        // 'bounceOut' => 'bounceOut',
                        // 'bounceOutDown' => 'bounceOutDown',
                        // 'bounceOutLeft' => 'bounceOutLeft',
                        // 'bounceOutRight' => 'bounceOutRight',
                        // 'bounceOutUp' => 'bounceOutUp',
                        'fadeIn' => 'fadeIn',
                        'fadeInDown' => 'fadeInDown',
                        'fadeInDownBig' => 'fadeInDownBig',
                        'fadeInLeft' => 'fadeInLeft',
                        'fadeInLeftBig' => 'fadeInLeftBig',
                        'fadeInRight' => 'fadeInRight',
                        'fadeInRightBig' => 'fadeInRightBig',
                        'fadeInUp' => 'fadeInUp',
                        'fadeInUpBig' => 'fadeInUpBig',
                        // 'fadeOut' => 'fadeOut',
                        // 'fadeOutDown' => 'fadeOutDown',
                        // 'fadeOutDownBig' => 'fadeOutDownBig',
                        // 'fadeOutLeft' => 'fadeOutLeft',
                        // 'fadeOutLeftBig' => 'fadeOutLeftBig',
                        // 'fadeOutRight' => 'fadeOutRight',
                        // 'fadeOutRightBig' => 'fadeOutRightBig',
                        // 'fadeOutUp' => 'fadeOutUp',
                        // 'fadeOutUpBig' => 'fadeOutUpBig',
                        'flipInX' => 'flipInX',
                        'flipInY' => 'flipInY',
                        // 'flipOutX' => 'flipOutX',
                        // 'flipOutY' => 'flipOutY',
                        'lightSpeedIn' => 'lightSpeedIn',
                        //'lightSpeedOut' => 'lightSpeedOut',
                        'rotateIn' => 'rotateIn',
                        'rotateInDownLeft' => 'rotateInDownLeft',
                        'rotateInDownRight' => 'rotateInDownRight',
                        'rotateInUpLeft' => 'rotateInUpLeft',
                        'rotateInUpRight' => 'rotateInUpRight',
                        // 'rotateOut' => 'rotateOut',
                        // 'rotateOutDownLeft' => 'rotateOutDownLeft',
                        // 'rotateOutDownRight' => 'rotateOutDownRight',
                        // 'rotateOutUpLeft' => 'rotateOutUpLeft',
                        // 'rotateOutUpRight' => 'rotateOutUpRight',
                        'hinge' => 'hinge',
                        'jackInTheBox' => 'jackInTheBox',
                        'rollIn' => 'rollIn',
                        //'rollOut' => 'rollOut',
                        'zoomIn' => 'zoomIn',
                        'zoomInDown' => 'zoomInDown',
                        'zoomInLeft' => 'zoomInLeft',
                        'zoomInRight' => 'zoomInRight',
                        'zoomInUp' => 'zoomInUp',
                        // 'zoomOut' => 'zoomOut',
                        // 'zoomOutDown' => 'zoomOutDown',
                        // 'zoomOutLeft' => 'zoomOutLeft',
                        // 'zoomOutRight' => 'zoomOutRight',
                        // 'zoomOutUp' => 'zoomOutUp',
                        'slideInDown' => 'slideInDown',
                        'slideInLeft' => 'slideInLeft',
                        'slideInRight' => 'slideInRight',
                        'slideInUp' => 'slideInUp',
                        // 'slideOutDown' => 'slideOutDown',
                        // 'slideOutLeft' => 'slideOutLeft',
                        // 'slideOutRight' => 'slideOutRight',
                        // 'slideOutUp' => 'slideOutUp',
                    ),
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'animationdelay',
                    'label'=>'Animation Delay',
                    'desc' => "Animation delay in milisecond" ,
                    'default'=>'100',
                ),
                
            )
        );

        $elements['ElementResponsiveOptions'] = array(
            'attrs' => array (
                // array(
                //     'type'=>'select',
                //     'param_name'=>'columnwidthclass',
                //     'label'=>'Width',
                //     'desc' => "" ,
                //     'default'=>'col-md-12',
                //     "value" => array(   
                //         '1 Column - 1/12' => 'col-md-1',  
                //         '2 Columns - 1/6' => 'col-md-2',   
                //         '3 Columns - 1/4' => 'col-md-3',     
                //         '4 Columns - 1/3' => 'col-md-4',     
                //         '5 Columns - 5/12' => 'col-md-5',     
                //         '6 Columns - 1/2' => 'col-md-6',     
                //         '7 Columns - 7/12' => 'col-md-7',     
                //         '8 Columns - 2/3' => 'col-md-8',     
                //         '9 Columns - 1/4' => 'col-md-9',     
                //         '10 Columns - 5/6' => 'col-md-10',     
                //         '11 Columns - 11/12' => 'col-md-11',     
                //         '12 Columns - 1/1' => 'col-md-12',      

                //     ),
                // ),
                array (
                    'type'=>'label',
                    'param_name'=>'respdevice',
                    'label'=>'Device',
                    'desc'=>''
                ),
                array (
                    'type'=>'label',
                    'param_name'=>'respoffset',
                    'label'=>'Offset',
                    'desc'=>''
                ),
                array (
                    'type'=>'label',
                    'param_name'=>'respwidth',
                    'label'=>'Width',
                    'desc'=>''
                ),
                array (
                    'type'=>'label',
                    'param_name'=>'resphideondevice',
                    'label'=>'Hide on device',
                    'desc'=>''
                ),
                array(
                    'type'=>'clearfix',
                ),
                array (
                    'type'=>'label',
                    'param_name'=>'devicedesktop',
                    'label'=>'<i class="ti-desktop"></i>',
                    'desc'=>''
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'lgoffsetclass',
                    'label'=>'',
                    'desc' => "" ,
                    'default'=>'',
                    "value" => array(   
                        'Inherit from smaller' => '',  
                        'No offset' => 'col-lg-offset-0',  
                        '1 Column - 1/12' => 'col-lg-offset-1',  
                        '2 Columns - 1/6' => 'col-lg-offset-2',   
                        '3 Columns - 1/4' => 'col-lg-offset-3',     
                        '4 Columns - 1/3' => 'col-lg-offset-4',     
                        '5 Columns - 5/12' => 'col-lg-offset-5',     
                        '6 Columns - 1/2' => 'col-lg-offset-6',     
                        '7 Columns - 7/12' => 'col-lg-offset-7',     
                        '8 Columns - 2/3' => 'col-lg-offset-8',     
                        '9 Columns - 1/4' => 'col-lg-offset-9',     
                        '10 Columns - 5/6' => 'col-lg-offset-10',     
                        '11 Columns - 11/12' => 'col-lg-offset-11',     
                        '12 Columns - 1/1' => 'col-lg-offset-12',      

                    ),
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'lgwidthclass',
                    'label'=>'',
                    'desc' => "" ,
                    'default'=>'',
                    "value" => array( 
                        'Inherit from smaller'=>'',  
                        '1 Column - 1/12' => 'col-lg-1',  
                        '2 Columns - 1/6' => 'col-lg-2',   
                        '3 Columns - 1/4' => 'col-lg-3',     
                        '4 Columns - 1/3' => 'col-lg-4',     
                        '5 Columns - 5/12' => 'col-lg-5',     
                        '6 Columns - 1/2' => 'col-lg-6',     
                        '7 Columns - 7/12' => 'col-lg-7',     
                        '8 Columns - 2/3' => 'col-lg-8',     
                        '9 Columns - 1/4' => 'col-lg-9',     
                        '10 Columns - 5/6' => 'col-lg-10',     
                        '11 Columns - 11/12' => 'col-lg-11',     
                        '12 Columns - 1/1' => 'col-lg-12',        

                    ),
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'hidden-lg',
                    'label'=>"Hide on desktop",
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),

                array(
                    'type'=>'clearfix',
                ),

                array(
                    'type'=>'label',
                    'param_name'=>'devicetablethoz',
                    'label'=>'<i class="ti-tablet"></i>',
                    'desc'=>''
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'mdoffsetclass',
                    'label'=>'',
                    'desc' => "" ,
                    'default'=>'',
                    "value" => array(   
                        'Inherit from smaller' => '',  
                        'No offset' => 'col-md-offset-0',  
                        '1 Column - 1/12' => 'col-md-offset-1',  
                        '2 Columns - 1/6' => 'col-md-offset-2',   
                        '3 Columns - 1/4' => 'col-md-offset-3',     
                        '4 Columns - 1/3' => 'col-md-offset-4',     
                        '5 Columns - 5/12' => 'col-md-offset-5',     
                        '6 Columns - 1/2' => 'col-md-offset-6',     
                        '7 Columns - 7/12' => 'col-md-offset-7',     
                        '8 Columns - 2/3' => 'col-md-offset-8',     
                        '9 Columns - 1/4' => 'col-md-offset-9',     
                        '10 Columns - 5/6' => 'col-md-offset-10',     
                        '11 Columns - 11/12' => 'col-md-offset-11',     
                        '12 Columns - 1/1' => 'col-md-offset-12',      

                    ),
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'mdwidthclass',
                    'label'=>'',
                    'desc' => "" ,
                    'default'=>'',
                    "value" => array( 
                        'Inherit from smaller'=>'',  
                        '1 Column - 1/12' => 'col-md-1',  
                        '2 Columns - 1/6' => 'col-md-2',   
                        '3 Columns - 1/4' => 'col-md-3',     
                        '4 Columns - 1/3' => 'col-md-4',     
                        '5 Columns - 5/12' => 'col-md-5',     
                        '6 Columns - 1/2' => 'col-md-6',     
                        '7 Columns - 7/12' => 'col-md-7',     
                        '8 Columns - 2/3' => 'col-md-8',     
                        '9 Columns - 1/4' => 'col-md-9',     
                        '10 Columns - 5/6' => 'col-md-10',     
                        '11 Columns - 11/12' => 'col-md-11',     
                        '12 Columns - 1/1' => 'col-md-12',        

                    ),
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'hidden-md',
                    'label'=>"Hide on laptop",
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),
                array(
                    'type'=>'clearfix',
                ),

                array(
                    'type'=>'label',
                    'param_name'=>'devicetablet',
                    'label'=>'<i class="ti-tablet"></i>',
                    'desc'=>''
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'smoffsetclass',
                    'label'=>'',
                    'desc' => "" ,
                    'default'=>'',
                    "value" => array(   
                        'Inherit from smaller' => '',  
                        'No offset' => 'col-sm-offset-0',  
                        '1 Column - 1/12' => 'col-sm-offset-1',  
                        '2 Columns - 1/6' => 'col-sm-offset-2',   
                        '3 Columns - 1/4' => 'col-sm-offset-3',     
                        '4 Columns - 1/3' => 'col-sm-offset-4',     
                        '5 Columns - 5/12' => 'col-sm-offset-5',     
                        '6 Columns - 1/2' => 'col-sm-offset-6',     
                        '7 Columns - 7/12' => 'col-sm-offset-7',     
                        '8 Columns - 2/3' => 'col-sm-offset-8',     
                        '9 Columns - 1/4' => 'col-sm-offset-9',     
                        '10 Columns - 5/6' => 'col-sm-offset-10',     
                        '11 Columns - 11/12' => 'col-sm-offset-11',     
                        '12 Columns - 1/1' => 'col-sm-offset-12',      

                    ),
                ),

                //Default value from width attribute
                // array (
                //     'type'=>'label',
                //     'param_name'=>'smwidthclass',
                //     'label'=>'Default value from width attribute',
                //     'desc'=>''
                // ),

                array(
                    'type'=>'select',
                    'param_name'=>'columnwidthclass',
                    'label'=>'Width',
                    'desc' => "" ,
                    'default'=>'col-md-12',
                    "value" => array(   
                        '1 Column - 1/12' => 'col-md-1',  
                        '2 Columns - 1/6' => 'col-md-2',   
                        '3 Columns - 1/4' => 'col-md-3',     
                        '4 Columns - 1/3' => 'col-md-4',     
                        '5 Columns - 5/12' => 'col-md-5',     
                        '6 Columns - 1/2' => 'col-md-6',     
                        '7 Columns - 7/12' => 'col-md-7',     
                        '8 Columns - 2/3' => 'col-md-8',     
                        '9 Columns - 1/4' => 'col-md-9',     
                        '10 Columns - 5/6' => 'col-md-10',     
                        '11 Columns - 11/12' => 'col-md-11',     
                        '12 Columns - 1/1' => 'col-md-12',      

                    ),
                ),
                
                array(
                    'type'=>'switch',
                    'param_name'=>'hidden-sm',
                    'label'=>"Hide on tablet",
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),

                array(
                    'type'=>'clearfix',
                ),

                array(
                    'type'=>'label',
                    'param_name'=>'devicemobile',
                    'label'=>'<i class="ti-mobile"></i>',
                    'desc'=>''
                ),


                array(
                    'type'=>'select',
                    'param_name'=>'xsoffsetclass',
                    'label'=>'',
                    'desc' => "" ,
                    'default'=>'',
                    "value" => array(   

                        'No offset' => '',  
                        '1 Column - 1/12' => 'col-xs-offset-1',  
                        '2 Columns - 1/6' => 'col-xs-offset-2',   
                        '3 Columns - 1/4' => 'col-xs-offset-3',     
                        '4 Columns - 1/3' => 'col-xs-offset-4',     
                        '5 Columns - 5/12' => 'col-xs-offset-5',     
                        '6 Columns - 1/2' => 'col-xs-offset-6',     
                        '7 Columns - 7/12' => 'col-xs-offset-7',     
                        '8 Columns - 2/3' => 'col-xs-offset-8',     
                        '9 Columns - 1/4' => 'col-xs-offset-9',     
                        '10 Columns - 5/6' => 'col-xs-offset-10',     
                        '11 Columns - 11/12' => 'col-xs-offset-11',     
                        '12 Columns - 1/1' => 'col-xs-offset-12',      

                    ),
                ),

                
                array(
                    'type'=>'select',
                    'param_name'=>'xswidthclass',
                    'label'=>'',
                    'desc' => "" ,
                    'default'=>'',
                    "value" => array(   
                        'No Select' => '',  
                        '1 Column - 1/12' => 'col-xs-1',  
                        '2 Columns - 1/6' => 'col-xs-2',   
                        '3 Columns - 1/4' => 'col-xs-3',     
                        '4 Columns - 1/3' => 'col-xs-4',     
                        '5 Columns - 5/12' => 'col-xs-5',     
                        '6 Columns - 1/2' => 'col-xs-6',     
                        '7 Columns - 7/12' => 'col-xs-7',     
                        '8 Columns - 2/3' => 'col-xs-8',     
                        '9 Columns - 1/4' => 'col-xs-9',     
                        '10 Columns - 5/6' => 'col-xs-10',     
                        '11 Columns - 11/12' => 'col-xs-11',     
                        '12 Columns - 1/1' => 'col-xs-12',       

                    ),
                ),
                array(
                    'type'=>'switch',
                    'param_name'=>'hidden-xs',
                    'label'=>"Hide on mobile",
                    'desc' => "" ,
                    'default'=>'0',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0',
                    )
                    
                ),

                array(
                    'type'=>'clearfix',
                ),

            )
        );



        // Import the azura plugin group.
        JPluginHelper::importPlugin('azura');

        // Get the dispatcher.
        $dispatcher = JEventDispatcher::getInstance();

        // Trigger the form preparation event.
        $results = $dispatcher->trigger('onAzuraPrepareElementsArray', array(&$elements));

        // Check for errors encountered while preparing the form.
        if (count($results) && in_array(false, $results, true))
        {
            // Get the last error.
            $error = $dispatcher->getError();

            if (!($error instanceof Exception))
            {
                throw new Exception($error);
            }
        }

        self::$elementsOptions = $elements;
    }
	
}

//AzuraElements::loadElements();