<?php 
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;
//$azura_attrs,$azura_content,$azura_element
$el_class = $title = $icon_type = $icon_align = $icon_color  = $iconbox_style = $is_shadow = '';
extract($azura_attrs);

$classes = array(
    'azp_element',
    'azp_iconbox',
    $el_class,
);

$classes[] = self::buildTypography($azura_attrs);//will return custom class for the element without dot
$animation_data = self::buildAnimation($azura_attrs);
$classes[] = $animation_data['trigger'];
$classes = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $classes ) ) );
$iconboxstyle = self::buildStyle($azura_attrs);


$iconClass = isset( ${'icon_' . $icon_type} ) ? ${'icon_' . $icon_type} : '';

switch ($iconbox_style) {
    case 'style2': // color style
        $classes .= ' azp_iconbox_style2';

    ?>
    <div class="<?php echo $classes; ?>" <?php echo $iconboxstyle.' '.$animation_data['data'];?>>
        <div class="set-column-icon"<?php if($icon_color != '') echo ' style="background-color: '.$icon_color.';"';?>>
            <?php if(!empty($iconClass)): ?>
            <i class="<?php echo $iconClass;?>"></i>
            <?php endif;?>
        </div>
        <div class="set-column-content">
            <?php if(!empty($title)):?>
            <h4><?php echo $title;?></h4>
            <?php endif;?>
            <?php echo $azura_content;?>
        </div>
    </div>
    <?php
        break;
    case 'style3': // icon overlay style
        $classes .= ' azp_iconbox_style3 full-column-icon';

    ?>
    <div class="<?php echo $classes ; ?>" <?php echo $iconboxstyle.' '.$animation_data['data'];?>>
        <div class="full-column-content">
            <?php if(!empty($iconClass)): ?>
            <i class="<?php echo $iconClass ;?>"></i>
            <?php endif;?>
            <?php if(!empty($title)):?>
            <h4><?php echo $title;?></h4>
            <?php endif;?>
            <?php echo $azura_content;?>
        </div>
        <?php if(!empty($iconClass)): ?>
        <i class="<?php echo $iconClass;?> overlay"></i>
        <?php endif;?>
    </div>

    <?php
        break;
    default: // boxed style
        $classes .= ' azp_iconbox_style1';
        //$addcl = $icon_align;
        if($is_shadow == '1') $icon_align .= ' box-shadow';
        if($iconClass == '') $icon_align .= ' no-icon';
    ?>
    <div class="<?php echo $classes ; ?>" <?php echo $iconboxstyle.' '.$animation_data['data'];?>>
        <div class="column-box <?php echo $icon_align ; ?>">
            <?php if(!empty($iconClass)): ?>
            <i class="<?php echo $iconClass;?>"></i>
            <?php endif;?>
            <?php if(!empty($title)):?>
            <h4><?php echo $title;?></h4>
            <?php endif;?>
            <?php echo $azura_content;?>
        </div>
    </div>
    <?php
        break;
}