<?php 
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;

$app = JFactory::getApplication();
$params = $app->getParams();
if($app->isAdmin()){

}else{
    AzuraJs::addJScript('GmapAPI', 'https://maps.google.com/maps/api/js?key='.$params->get('google_api'), false , false, '');
}

$el_id = $el_class = $map_lat = $map_long = $map_address = $map_zoom = $map_marker = $default_style = $map_height = $add_address = '';
$zoom_control = $maptype_control = $scale_control = $scroll_wheel = $street_view = $draggable = '';
extract($azura_attrs);

$gmapstyle = self::buildStyle($azura_attrs);
$animation_data = self::buildAnimation($azura_attrs);


$classes = 'azp_element azp_map-box';
$classes .= ' '.$animation_data['trigger'];
if(!empty($el_class)){
    $classes .= ' '.$el_class;
}
$classes = 'class="'.$classes.'"';




if(!empty($map_marker)){
  $map_marker = JURI::root() . $map_marker ;
}
$dataArr = array();
$dataArr['zoom'] = (int)$map_zoom;

$dataArr['zoomControl'] = $zoom_control;
$dataArr['mapTypeControl'] = $maptype_control;
$dataArr['scaleControl'] = $scale_control;
$dataArr['scrollwheel'] = $scroll_wheel;
$dataArr['streetViewControl'] = $street_view;
$dataArr['draggable'] = $draggable;

?>
<div <?php echo $classes; ?>>
    <div class="map-wrapper">
        <div id="<?php echo uniqid('map');?>" class="maps" 
        <?php if($map_height != '450'):?>
          style="height:<?php echo $map_height;?>px" 
        <?php endif;?>  data-marker="<?php echo $map_marker;?>"
         data-dfstyle="<?php echo $default_style;?>"
         data-options='<?php echo json_encode($dataArr);?>'></div>
        <div class="item-map" 
             data-lat="<?php echo $map_lat;?>" 
             data-lng="<?php echo $map_long ;?>" 
             data-address="<?php echo $map_address;?>">
        </div>
        <?php 
        if($add_address != ''){
            $add_spl = explode("|", $add_address);
            foreach ($add_spl as $key => $value) {
                $add_val = explode(";", $value);
                ?>
                <div class="item-map" 
                     data-lat="<?php echo $add_val[0];?>" 
                     data-lng="<?php echo $add_val[1];?>" 
                     data-address="<?php echo $add_val[2];?>">
                </div>
        <?php

            }
        }
        ?>
    </div>
</div>


