<?php 
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;
$el_class = $el_id = $title = $receiveemail = $thanksmessage = $emailsubject = $showsubject = $showwebsite = $redirect = '';
//$azura_attrs,$azura_content,$azura_element
extract($azura_attrs);
$animation_data = self::buildAnimation($azura_attrs);
$classes = array(
    'azp_element',
    'azp_contactform',
    $el_class,
);
$classes[] = $animation_data['trigger'];
$classes[] = self::buildTypography($azura_attrs);//will return custom class for the element without dot
$azpcontactformstyle = self::buildStyle($azura_attrs);

if(!empty($el_id)){
    $el_id = 'id="'.$el_id.'"';
}
$classes = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $classes ) ) );

$document = JFactory::getDocument();
$document->addScriptOptions('com_azp_contact', array(
    'name' => JText::_('Please enter your name'),
    'email' => array(JText::_('Please enter your email address'),JText::_('Your email address must be in the format of name@domain.com')),
    'message' => JText::_('Please enter your message'),
    'error' => JText::_('There is something wrong! Try again please.'),
    'thanks'=> $thanksmessage,
    'plw' => JText::_('Please wait...')
));

?>
<!--contact form -->

<div class="<?php echo $classes; ?>" <?php echo $el_id .' ' . $azpcontactformstyle.' '.$animation_data['data'];?>>

    <?php if($title!='') :?>
    <h3><?php echo $title;?></h3>
    <?php endif;?>

    <div id="azp_message"></div>

    <form class="azp_contact-form" method="post" action="<?php echo JURI::current();?>" name="azpcontactform" id="azpcontactform" data-redirect="<?php echo $redirect;?>">
        <div class="azp_form-group">
            <label><?php echo JText::_('Your name');?></label>
            <input type="text" name="name" class="azp_form-control" placeholder="<?php echo JText::_('Your name');?>">
        </div>
        
        <div class="azp_form-group">
            <label><?php echo JText::_('Your email address');?></label>
            <input type="email" name="email" class="azp_form-control" placeholder="<?php echo JText::_('Your email address');?>">
        </div>  
        <?php if($showwebsite === '1') :?> 
        <div class="azp_form-group">
            <label><?php echo JText::_('Website URL');?></label>
            <input type="text" name="website" class="azp_form-control" placeholder="<?php echo JText::_('Website URL');?>">
        </div> 
        <?php endif;?>
        <?php if($showsubject === '1') :?> 
        <div class="azp_form-group">
            <label><?php echo JText::_('Subject');?></label>
            <input type="text" name="subject" class="azp_form-control" placeholder="<?php echo JText::_('Subject');?>" value="<?php echo $emailsubject;?>">
        </div> 
        <?php endif;?>
        <div class="azp_form-group">
            <label><?php echo JText::_('Message');?></label>
            <textarea name="message" rows="6" class="azp_form-control" placeholder="<?php echo JText::_('Message');?>"></textarea>
        </div> 

        <?php           
        $captchaId = uniqid('captchaid');
        JPluginHelper::importPlugin('captcha', 'recaptcha');
        $dispatcher = JEventDispatcher::getInstance();
        $initResult = $dispatcher->trigger('onInit', array($captchaId));
        if ($initResult)
        {
            echo implode('', $dispatcher->trigger('onDisplay', array(null, $captchaId, 'class=""')));
        }
        ?>
			
        <div class="azp_form-group">
            <button type="submit"  class="azp_btn azp_btn-primary" id="azpsubmit"><?php echo JText::_('Submit');?></button>
        </div> 
            
        <?php if($showsubject === '0') :?> 
		<input type="hidden" name="subject" value="<?php echo $emailsubject;?>">
        <?php endif;?>
		<input type="hidden" name="option" value="com_azurapagebuilder">
		<input type="hidden" name="task" value="ajax.contact">
		<?php echo JHtml::_('form.token'); ?>


    </form>
</div>
