<?php
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;

//require_once JPATH_COMPONENT_ADMINISTRATOR.'/helpers/elementoptions.php';
require_once JPATH_COMPONENT_ADMINISTRATOR.'/helpers/awesomefont.php';
require_once JPATH_COMPONENT_ADMINISTRATOR.'/helpers/google_fonts/google-data.php';
require_once realpath(JPATH_ADMINISTRATOR . '/components/com_menus/helpers/menus.php');

class AzuraPagebuilderControllerElement extends JControllerLegacy
{
	public function __construct($config = array())
	{

		JForm::addFieldPath(JPATH_ROOT.'/administrator/components/com_azurapagebuilder/models/fields');
		//JForm::addFieldPath(JPATH_ROOT.'/administrator/components/com_content/models/fields');

		//JForm::addFieldPath(JPATH_ROOT.'/administrator/components/com_k2/elements');
		JForm::addFormPath(JPATH_ROOT.'/administrator/components/com_azurapagebuilder/models/forms');
		//JForm::addFormPath(JPATH_THEMES.'/'.JFactory::getApplication()->getTemplate().'/html/com_azurapagebuilder/forms');
		//require_once realpath(JPATH_ADMINISTRATOR . '/components/com_azurapagebuilder/helpers/azuraelements.php');  //JPATH_ROOT.'/administrator/components/com_azurapagebuilder/helpers/azuraelements.php';
		//AzuraElements::loadElements(false);
		//AzuraElements::loadElements(true);

		// Import the com_menus helper. - for getmenuitems function
		require_once realpath(JPATH_ADMINISTRATOR . '/components/com_menus/helpers/menus.php');
		parent::__construct();
	}
	public function configHtml(){
		$data = $this->input->get('data','','raw');
		$height = $this->input->get('height','630','int');
		$app = JFactory::getApplication();
	    $app->setUserState('com_azurapagebuilder.element.html.data',$data);
	    $app->setUserState('com_azurapagebuilder.element.html.height',$height);
	    echo '<iframe class="AzuraHtml-editor" src="'.JURI::base().'index.php?option=com_azurapagebuilder&task=edit.editor&tmpl=component" width="100%" height="'.$height.'px" style="border:none;"></iframe>';
	    exit;

	}

	public function getSqlSelect(){
		$query = $this->input->get('query','','raw');
		$query = urldecode($query);

		$db = JFactory::getDbo();
		$db->setQuery($query);
		$items = $db->loadObjectlist();
		echo json_encode($items);
		exit;

	}

	public function getchromestyle()
	{
		$groups = array();

		// Add Module Style Field
		$tmp = '---' . JText::_('JLIB_FORM_VALUE_FROM_TEMPLATE') . '---';
		//$groups[$tmp][] = JHtml::_('select.option', '0', JText::_('JLIB_FORM_VALUE_INHERITED'));
		// $groups[$tmp][] = array(JText::_('JLIB_FORM_VALUE_INHERITED') => '0');// JHtml::_('select.option', '0', JText::_('JLIB_FORM_VALUE_INHERITED'));
		$groups[$tmp][JText::_('JLIB_FORM_VALUE_INHERITED')] = '0';// JHtml::_('select.option', '0', JText::_('JLIB_FORM_VALUE_INHERITED'));

		$templateStyles = $this->getTemplateModuleStyles();

		// Create one new option object for each available style, grouped by templates
		foreach ($templateStyles as $template => $styles)
		{
			$template = ucfirst($template);
			$groups[$template] = array();

			foreach ($styles as $style)
			{	

				//$tmp = JHtml::_('select.option', $template . '-' . $style, $style);
				//$tmp = array($style => $template . '-' . $style);
				$groups[$template][$style] = $template . '-' . $style;
			}
		}

		reset($groups);

		echo json_encode($groups);
		exit;
	}
	/**
	 * Method to get the templates module styles.
	 *
	 * @return  array  The array of styles, grouped by templates.
	 *
	 * @since   3.0
	 */
	protected function getTemplateModuleStyles()
	{
		$moduleStyles = array();

		$templates = array($this->getSystemTemplate());
		$templates = array_merge($templates, $this->getTemplates());

		foreach ($templates as $template)
		{
			$modulesFilePath = JPATH_SITE . '/templates/' . $template->element . '/html/modules.php';

			// Is there modules.php for that template?
			if (file_exists($modulesFilePath))
			{
				$modulesFileData = file_get_contents($modulesFilePath);

				preg_match_all('/function[\s\t]*modChrome\_([a-z0-9\-\_]*)[\s\t]*\(/i', $modulesFileData, $styles);

				if (!array_key_exists($template->element, $moduleStyles))
				{
					$moduleStyles[$template->element] = array();
				}

				$moduleStyles[$template->element] = $styles[1];
			}
		}

		return $moduleStyles;
	}
	/**
	 * Method to get the system template as an object.
	 *
	 * @return  array  The object of system template.
	 *
	 * @since   3.0
	 */
	protected function getSystemTemplate()
	{
		$template = new stdClass;
		$template->element = 'system';
		$template->name    = 'system';
		$template->enabled = 1;

		return $template;
	}

	/**
	 * Return a list of templates
	 *
	 * @return  array  List of templates
	 *
	 * @since   3.2.1
	 */
	protected function getTemplates()
	{
		$db = JFactory::getDbo();

		// Get the database object and a new query object.
		$query = $db->getQuery(true);

		// Build the query.
		$query->select('element, name, enabled')
			->from('#__extensions')
			->where('client_id = 0')
			->where('type = ' . $db->quote('template'));

		// Set the query and load the templates.
		$db->setQuery($query);
		$templates = $db->loadObjectList('element');

		return $templates;
	}

	/**
	 * Method to get the field option groups.
	 *
	 * @return  array  The field option objects as a nested array in groups.
	 *
	 * @since   1.6
	 */
	
	public function getmenuitems()
	{
		$groups = array();
		$items = MenusHelper::getMenuLinks(null, 0, 0, array(), array());
		// Build the groups arrays.
		foreach ($items as $menu)
		{
			// Initialize the group.
			$groups[$menu->title] = array();

			// Build the options array.
			foreach ($menu->links as $link)
			{
				$levelPrefix = str_repeat('- ', $link->level - 1);

				// Displays language code if not set to All
				if ($link->language !== '*')
				{
					$lang = ' (' . $link->language . ')';
				}
				else
				{
					$lang = '';
				}

				$groups[$menu->title][$levelPrefix . $link->text . $lang] = $link->value ;


			}
		}

		echo json_encode( $groups );
		exit;
	}

	public function getK2andArticle(){
		$item_id = $this->input->get('item_id','','int');
		$item_type = $this->input->get('item_type','article','cmd');

		$databasename = '#__content';
		if($item_type === 'k2'){
			$databasename = '#__k2_items';
		}

		if ((int) $item_id > 0)
		{
			$db	= JFactory::getDbo();
			$query = $db->getQuery(true)
				->select($db->quoteName('title'))
				->from($db->quoteName($databasename))
				->where($db->quoteName('id') . ' = ' . (int) $item_id);
			$db->setQuery($query);

			try
			{
				$title = $db->loadResult();
			}
			catch (RuntimeException $e)
			{
				JError::raiseWarning(500, $e->getMessage());
			}
		}

		if (empty($title))
		{
			$title = JText::_('COM_CONTENT_SELECT_AN_ARTICLE');
		}

		$title = htmlspecialchars($title, ENT_QUOTES, 'UTF-8');

		echo $title;
		exit;

	}
	public function getgooglefontsnew()
	{
		$value = $this->input->get('value','','string');
		$param_name = $this->input->get('param_name','googlefont','string');
		$value = explode(":", $value);

		$return = '';

		$googlefonts = azura_get_google_fonts_array();
		if(isset($googlefonts) && count($googlefonts)) :

			ob_start();
			?>
			<select id="elementAttrs_<?php echo $param_name ;?>" class="googlefonts-font-select" name="elementAttrs[<?php echo $param_name ;?>]">
			<?php
			$variants = array();
			foreach ($googlefonts as $key => $font) {
				if($font['family'] == $value[0]) :
					$variants = $font['variants'] ;
				?>
				<option data-styles="<?php echo rawurlencode(json_encode($font['variants']));?>" value="<?php echo $font['family'];?>" selected="selected"><?php echo $font['family'];?></option>
			<?php else : ?>
				<option data-styles="<?php echo rawurlencode(json_encode($font['variants']));?>" value="<?php echo $font['family'];?>"><?php echo $font['family'];?></option>
			<?php endif ; ?>
			<?php 
			}
			?>
			</select>
			
			<div class="control-label">
				<label id="fstyleAttrs_<?php echo $param_name ;?>-lbl" for="fstyleAttrs_<?php echo $param_name ;?>" class="hasTooltip" title="">Font style</label>
			</div>
			<div class="controls">
				<select id="fstyleAttrs_<?php echo $param_name ;?>" class="googlefonts-style-select" name="fstyleAttrs[<?php echo $param_name ;?>]">
				<?php 
				if(count($variants)) {
					foreach ($variants as  $val) {
						?>
						<option value="<?php echo $val ;?>"<?php if($val == $value[1]) echo ' selected="selected"';?>><?php echo $val ;?></option>
					<?php
					}
				}
				?>
				</select>
			</div>
			<?php
			$return = ob_get_clean();

		endif;

		echo $return;
		exit();
	}
	public function images(){

		
		$folder = $this->input->get('folder','','string');
		if($folder != ''){
			$folder = 'images/'.$folder ;
		}else {
			$folder = 'images';
		}
		$form = JForm::getInstance('com_azurapagebuilder.page.imagesfield', 'imagesfield');

		$field = $form->getField('myimage');
		$field->__set('directory',$folder);
		$imagesarray = $field->azuraGetOptions() ;
		echo json_encode($imagesarray);
		exit;
	}
	public function folders(){
		
		$form = JForm::getInstance('com_azurapagebuilder.page.folderlist', 'folderlist');
		echo $form->getField('imagesfolder')->input;
		exit;
	}




	public function iconfonts(){
		$awesomefont = azura_extract_awesome_icon_array();

		$q = $this->input->get('q');
		$html = array();

		if($q !== ""){
			$q = strtolower($q);
			$len = strlen($q);
			foreach ($awesomefont as $font => $name) {
				if (stristr($q, substr($font, 3, $len))) {
					$html[] = "\t".'<div class="icon-select">';
					$html[] = "\t\t".'<i data-font="'.$font.'" class="fa '.$font.' fa-2x"></i>';
					$html[] = "\t".'</div>';
				}
			}
		}else{
			foreach ($awesomefont as $font => $name) {
				$html[] = "\t".'<div class="icon-select">';
				$html[] = "\t\t".'<i data-font="'.$font.'" class="fa '.$font.' fa-2x"></i>';
				$html[] = "\t".'</div>';
			}
		}

		echo (empty($html)? "Not Found!" : implode("\n", $html));

		exit();
	}
	
	public function getgooglefonts()
	{
		$fonts = array();

		$data = azura_get_google_fonts_array();

		if(isset($data) && count($data)){
			foreach ($data as $key => $font) {
				$fonts[$font['family']] = rawurlencode(json_encode($font['variants']));
			}
		}

		echo json_encode($fonts);
		exit;
	}
	
}


