<?php
/**
 * @package Hoxa - Responsive Multipurpose Joomla Template
 * @author Cththemes - www.cththemes.com
 * @date: 01-10-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */

// no direct access
defined('_JEXEC') or die;

$menu = JFactory::getApplication()->getMenu();
$defaultMenu = $menu->getDefault();
$activeMenu = $menu->getActive() ? $menu->getActive() : $menu->getDefault();
$portfolio_layout = '3';
$portfolio_sidebar = 'full';
if($activeMenu->params->get('portfolio_layout')){
	$portfolio_layout = $activeMenu->params->get('portfolio_layout','3');
	$portfolio_sidebar = $activeMenu->params->get('portfolio_sidebar','full');
}

require_once JPATH_BASE.'/components/com_azurapagebuilder/helpers/elementparser.php';

function getItemTagsFilter($item, $implode = " "){
	require_once JPATH_BASE.'/components/com_k2/models/item.php';

	$K2ModelItem = new K2ModelItem;

    $tags = array();
	$itemTags = $K2ModelItem->getItemTags($item->id);
	if(count($itemTags)) {
		foreach ($itemTags as $tag) {
            $tagName = str_replace(" ", "-", $tag->name);
            $tags[] = strtolower($tagName);
        }
	}
    $filter = implode($implode, $tags);

    return $filter;
}

function getCats($catid=0){
    $db =  JFactory::getDbo();
    $query=$db->getQuery(true);
    array('a.published=1','a.trash=0');
    if((int)$catid!=0){
        $where ='a.catid='.(int)$catid;
    }
    $query 		->select('a.id')
        ->from('#__k2_items AS a')
        ->where($where)
        ->order('created ASC');
    $db->setQuery($query,0,'All');

    return $db->loadObjectList();
}

function getTagsFilter($catid){

	$items = getCats($catid);

	$catTags = array();

	$allTags = array();

	$tags = array();

	if(count($items)){


		require_once JPATH_BASE.'/components/com_k2/models/item.php';

		$K2ModelItem = new K2ModelItem;

		foreach ($items as $item) {
			$catTags[] = $K2ModelItem->getItemTags($item->id);
		}
		
		if(!empty($catTags)){
			foreach ($catTags as $catTag) {
				if (!empty($catTag)) {
					foreach ($catTag as $tag) {
						$allTags[] = $tag->name;
					}
				}
			}
		}

		$tags = array_unique($allTags);
	}
	return $tags;
}

// function getK2ItemImage($id,$size='XS'){
// 	return JURI::root(true).'/media/k2/items/cache/'.md5("Image".$id).'_'.$size.'.jpg';
// }


// function getK2ItemLink($id,$alias,$catid,$categoryalias){
// 	require_once (JPATH_SITE.'/components/com_k2/helpers/route.php');
// 	return urldecode(JRoute::_(K2HelperRoute::getItemRoute($id.':'.urlencode($alias), $catid.':'.urlencode($categoryalias))));
// }

if($this->category){
	$tagsFilter = getTagsFilter($this->category->id);
}else{
	$categories = $this->params->get('categories');
	$tagsFilter = array();
	if($categories && !empty($categories)){
		if(is_array($categories)){
			foreach ($categories as $key => $cat) {
				$tagsFilter = array_merge($tagsFilter,getTagsFilter($cat));
			}
			$tagsFilter = array_unique($tagsFilter);
		}
	}
}
//echo'<pre>';var_dump($this->category);die;
?>
<?php if((isset($this->leading) || isset($this->primary) || isset($this->secondary) || isset($this->links)) && (count($this->leading) || count($this->primary) || count($this->secondary) || count($this->links))): ?>
<section class="envor-section">
    <div class="container">
      	<div class="row">
      	<?php if($portfolio_sidebar == 'left') :?>
			<div class="col-lg-3">
				<?php 
					echo AzuraModuleHelper::loadposition('left-sidebar','widget');
				?>
			</div>
      	<?php endif;?>
      	<?php if($portfolio_sidebar == 'full') :?>
        	<div class="col-lg-12">
        <?php else: ?>
        	<div class="col-lg-9">
        <?php endif;?>
		        <?php if(!empty($this->category->description)) : ?>
					<?php echo $this->category->description;?>
				<?php endif;?>
	          	<div class="envor-sorting envor-portfolio-sorting" id="portfolio-sorting">
		          	<?php if(isset($tagsFilter)):  ?>
		            	<div class="envor-sorting-filters">
		            	<?php foreach($tagsFilter as $tag): ?>
		              		<span data-value="<?php echo strtolower(str_replace(" ","-",$tag)); ?>"><?php echo ucfirst($tag); ?></span>
		              	<?php endforeach;  ?>
		            	</div>
		            <?php endif;?>
					<div class="clearfix"></div>
					<div class="row projects-list">
	                  	<div class="col-lg-12">
	                  		<div class="envor-projects-listing envor-projects-listing-<?php echo $portfolio_layout;?>-cols">
							<?php $item_index = 1; ?>
							<?php if(isset($this->leading) && count($this->leading)): ?>
							<!-- Leading items -->
								<?php foreach($this->leading as $item): ?>

									<?php
										// Load category_item.php by default
										$this->item=$item;
										echo $this->loadTemplate('item');
										if($item_index % 2 == 0) echo '<div class="clearfix visible-sm-block hidden-md hidden-lg"></div>';
										if($item_index % (int)$portfolio_layout == 0) echo '<div class="clearfix visible-lg-block hidden-sm"></div>';
										$item_index++;
									?>
								<?php endforeach; ?>
							<?php endif; ?>

							<?php if(isset($this->primary) && count($this->primary)): ?>
							<!-- Primary items -->
								<?php foreach($this->primary as $item): ?>

									<?php
										// Load category_item.php by default
										$this->item=$item;
										echo $this->loadTemplate('item');
										if($item_index % 2 == 0) echo '<div class="clearfix visible-sm-block hidden-md hidden-lg"></div>';
										if($item_index % (int)$portfolio_layout == 0) echo '<div class="clearfix visible-lg-block hidden-sm"></div>';
										$item_index++;
									?>
								<?php endforeach; ?>
							<?php endif; ?>

							<?php if(isset($this->secondary) && count($this->secondary)): ?>
							<!-- Secondary items -->
								<?php foreach($this->secondary as $item): ?>
								
								
									<?php
										// Load category_item.php by default
										$this->item=$item;
										echo $this->loadTemplate('item');
										if($item_index % 2 == 0) echo '<div class="clearfix visible-sm-block hidden-md hidden-lg"></div>';
										if($item_index % (int)$portfolio_layout == 0) echo '<div class="clearfix visible-lg-block hidden-sm"></div>';
										$item_index++;
									?>

								<?php endforeach; ?>
							<?php endif; ?> 

							</div>
						</div>
					</div>
				</div>
			</div>
			<?php if($portfolio_sidebar == 'right') :?>
			<div class="col-lg-3">
				<?php 
					echo AzuraModuleHelper::loadposition('right-sidebar','widget');
				?>
			</div>
      		<?php endif;?>
		</div>
		<?php if($this->pagination->getPagesLinks()): ?>
		    <div class="row nomargin-im">
		    	<div class="col-lg-12">
		    		<?php if($this->params->get('catPagination')) echo $this->pagination->getPagesLinks(); ?>
		    	</div>
		    </div>
		<?php endif; ?>
	</div>
</section>

<?php endif; ?>
