<?php
/**
 * @package Hoxa - Responsive Multipurpose Joomla Template
 * @author Cththemes - www.cththemes.com
 * @date: 01-10-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */

// no direct access
defined('_JEXEC') or die;
$menu = JFactory::getApplication()->getMenu();
$defaultMenu = $menu->getDefault();
$activeMenu = $menu->getActive() ? $menu->getActive() : $menu->getDefault();
$portfolio_layout = '3';
$portfolio_sidebar = 'full';
if($activeMenu->params->get('portfolio_layout')){
	$portfolio_layout = $activeMenu->params->get('portfolio_layout','3');
	$portfolio_sidebar = $activeMenu->params->get('portfolio_sidebar','full');
}
require_once JPATH_BASE.'/components/com_azurapagebuilder/helpers/elementparser.php';

function getK2CategoryLink($catid){
    require_once (JPATH_SITE.'/components/com_k2/helpers/route.php');
    return urldecode(JRoute::_(K2HelperRoute::getCategoryRoute($catid)));
}
function getItemTagsFilter($item, $implode = " "){
	require_once JPATH_BASE.'/components/com_k2/models/item.php';

	$K2ModelItem = new K2ModelItem;

    $tags = array();
	$itemTags = $K2ModelItem->getItemTags($item->id);
	if(count($itemTags)) {
		foreach ($itemTags as $tag) {
            $tagName = str_replace(" ", "-", $tag->name);
            $tags[] = strtolower($tagName);
        }
	}
    $filter = implode($implode, $tags);

    return $filter;
}

global $k2item;
$k2item = $this->item;
?>

<section class="envor-section">
    <div class="container">
      	<div class="row">
        	<?php if($portfolio_sidebar == 'left') :?>
			<div class="col-lg-3">
				<?php 
					echo AzuraModuleHelper::loadposition('left-sidebar','widget');
				?>
			</div>
	      	<?php endif;?>
	      	<?php if($portfolio_sidebar == 'full') :?>
	        	<div class="col-lg-12">
	        <?php else: ?>
	        	<div class="col-lg-9">
	        <?php endif;?>
			
			<?php if(!empty($this->item->fulltext)): ?>
				<?php if($this->item->params->get('itemIntroText')): ?>
				<!-- Item introtext -->
				
					<div class="row nomargin-im">
						<?php echo ElementParser::do_shortcode($this->item->introtext); ?>
					</div>
				
				<?php endif; ?>
				<?php if($this->item->params->get('itemFullText')): ?>
				<!-- Item fulltext -->

					<div class="row nomargin-im">
						<?php echo ElementParser::do_shortcode($this->item->fulltext); ?>
					</div>

				<?php endif; ?>
			<?php else: ?>
				<!-- Item text -->

					<div class="row nomargin-im">
						<?php echo ElementParser::do_shortcode($this->item->introtext); ?>
					</div>

			<?php endif; ?>

				<?php //echo plgContentLikebtn::getMarkup('com_k2.item', $this->item->id, array('style'=>'drop', 'lang'=>'en'), true, true); ?>
				
				<?php if($this->item->params->get('itemExtraFields') && count($this->item->extra_fields)): ?>
	  <!-- Item extra fields -->
	  <div class="itemExtraFields">
	  	<h3><?php echo JText::_('K2_ADDITIONAL_INFO'); ?></h3>
	  	<ul>
			<?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
			<?php if($extraField->value != ''): ?>
			<li class="<?php echo ($key%2) ? "odd" : "even"; ?> type<?php echo ucfirst($extraField->type); ?> group<?php echo $extraField->group; ?>">
				<?php if($extraField->type == 'header'): ?>
				<h4 class="itemExtraFieldsHeader"><?php echo $extraField->name; ?></h4>
				<?php else: ?>
				<span class="itemExtraFieldsLabel"><?php echo $extraField->name; ?>:</span>
				<span class="itemExtraFieldsValue"><?php echo $extraField->value; ?></span>
				<?php endif; ?>
			</li>
			<?php endif; ?>
			<?php endforeach; ?>
			</ul>
	    <div class="clr"></div>
	  </div>
	  <?php endif; ?>

				<?php if($this->item->params->get('itemRating')): ?>
				<!-- Item Rating -->
				<div class="itemRatingBlock">
					<span><?php echo JText::_('K2_RATE_THIS_ITEM'); ?></span>
					<div class="itemRatingForm">
						<ul class="itemRatingList">
							<li class="itemCurrentRating" id="itemCurrentRating<?php echo $this->item->id; ?>" style="width:<?php echo $this->item->votingPercentage; ?>%;"></li>
							<li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_1_STAR_OUT_OF_5'); ?>" class="one-star">1</a></li>
							<li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_2_STARS_OUT_OF_5'); ?>" class="two-stars">2</a></li>
							<li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_3_STARS_OUT_OF_5'); ?>" class="three-stars">3</a></li>
							<li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_4_STARS_OUT_OF_5'); ?>" class="four-stars">4</a></li>
							<li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_5_STARS_OUT_OF_5'); ?>" class="five-stars">5</a></li>
						</ul>
						<div id="itemRatingLog<?php echo $this->item->id; ?>" class="itemRatingLog"><?php echo $this->item->numOfvotes; ?></div>
						<div class="clr"></div>
					</div>
					<div class="clr"></div>
				</div>
				<?php endif; ?>

				<?php if($this->item->params->get('itemTwitterButton',1) || $this->item->params->get('itemFacebookButton',1) || $this->item->params->get('itemGooglePlusOneButton',1)): ?>
					<!-- Social sharing -->
					<div class="itemSocialSharing">

						<?php if($this->item->params->get('itemTwitterButton',1)): ?>
						<!-- Twitter Button -->
						<div class="itemTwitterButton">
							<a href="https://twitter.com/share" class="twitter-share-button" data-count="horizontal"<?php if($this->item->params->get('twitterUsername')): ?> data-via="<?php echo $this->item->params->get('twitterUsername'); ?>"<?php endif; ?>>
								<?php echo JText::_('K2_TWEET'); ?>
							</a>
							<script type="text/javascript" src="//platform.twitter.com/widgets.js"></script>
						</div>
						<?php endif; ?>

						<?php if($this->item->params->get('itemFacebookButton',1)): ?>
						<!-- Facebook Button -->
						<div class="itemFacebookButton">
							<div id="fb-root"></div>
							<script type="text/javascript">
								(function(d, s, id) {
								  var js, fjs = d.getElementsByTagName(s)[0];
								  if (d.getElementById(id)) return;
								  js = d.createElement(s); js.id = id;
								  js.src = "//connect.facebook.net/en_US/all.js#xfbml=1";
								  fjs.parentNode.insertBefore(js, fjs);
								}(document, 'script', 'facebook-jssdk'));
							</script>
							<div class="fb-like" data-send="false" data-width="200" data-show-faces="true"></div>
						</div>
						<?php endif; ?>

						<?php if($this->item->params->get('itemGooglePlusOneButton',1)): ?>
						<!-- Google +1 Button -->
						<div class="itemGooglePlusOneButton">
							<g:plusone annotation="inline" width="120"></g:plusone>
							<script type="text/javascript">
							  (function() {
							  	window.___gcfg = {lang: 'en'}; // Define button default language here
							    var po = document.createElement('script'); po.type = 'text/javascript'; po.async = true;
							    po.src = 'https://apis.google.com/js/plusone.js';
							    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(po, s);
							  })();
							</script>
						</div>
						<?php endif; ?>

						<div class="clr"></div>
					</div>
					<?php endif; ?>

					<?php 
						echo AzuraModuleHelper::loadposition('portfolio-bottom','envor');
					?>

			</div>

	        <?php if($portfolio_sidebar == 'right') :?>
			<div class="col-lg-3">
				<?php 
					echo AzuraModuleHelper::loadposition('right-sidebar','widget');
				?>
			</div>
      		<?php endif;?>
      	</div>
    </div>
  </section>

<?php if($this->item->params->get('itemRelated') && isset($this->relatedItems)): ?>
  <!-- Related items by tag -->
	<section class="envor-section envor-section-align-center envor-padding-top-0">
        <div class="container">
            <div class="row">
              	<div class="col-lg-12">
              		<h2><?php echo JText::_("TPL_ENVOR_RELATED_PROJECTS_TEXT"); ?></h2>
					<!-- <ul> -->
					<div class="envor-relative envor-latest-projects" data-visible="3" data-selector="envor-project">
						<?php foreach($this->relatedItems as $key=>$item): //echo'<pre>';var_dump($item);die;?>
						<?php 
						$reextraFields = array();

						if($item->extra_fields){
							if(!is_array($item->extra_fields)){
								$reextraFields = json_decode($item->extra_fields);
							}else{
								$reextraFields = $item->extra_fields;
							}
						} ?>

							<article class="envor-project envor-padding-left-30">
			                    <div class="envor-project-inner">
			                    <?php if(!empty($reextraFields[0]->value)) :?>
			                      	<figure><a href=""><img src="<?php echo JURI::root(true).$reextraFields[0]->value;?>" alt=""></a><figcaption><a href="<?php echo JURI::root(true).$reextraFields[0]->value;?>" title="<?php echo $item->title;?>" class="colorbox"><i class="fa fa-plus"></i></a></figcaption></figure>
			                    <?php endif;?>
			                      	<div class="envor-project-details">
				                       	<!-- <div class="envor-project-likes"><i class="fa fa-star-o"></i> <?php //echo $itemRated;?></div> -->
				                        <p class="link"><a href="<?php echo $item->link ?>"><?php echo $item->title; ?></a></p>
				                        <p class="filter"><?php echo getItemTagsFilter($item, ', ');?></p>
			                      	</div>
			                    </div>
		                  	</article>
						<?php endforeach; ?>
						<div class="envor-navigation rivaslider-navigation">
		                    <a href="" class="back"><i class="glyphicon glyphicon-chevron-left"></i></a>
		                    <a href="" class="forward"><i class="glyphicon glyphicon-chevron-right"></i></a>
		                </div>
                	</div>
				</div>
			</div>
		</div>
	</section>
<?php endif; ?>



<?php if($this->item->params->get('itemNavigation') && !JRequest::getCmd('print') && (isset($this->item->nextLink) || isset($this->item->previousLink))): ?>
<!-- Project navigation -->
<section class="envor-section envor-section-align-center envor-padding-top-0">
    <div class="container">
        <div class="row">
			<div class="col-lg-12">
			<?php if(isset($this->item->previousLink)): ?>
				<a class="project-prev" href="<?php echo $this->item->previousLink; ?>"><i class="fa fa-long-arrow-left"></i></a>
			<?php endif; ?>
				<a class="project-back" href="<?php echo getK2CategoryLink($this->item->catid);?>"><i class="fa fa-th"></i></a>
			<?php if(isset($this->item->nextLink)): ?>
				<a class="project-next" href="<?php echo $this->item->nextLink; ?>"><i class="fa fa-long-arrow-right"></i></a>
			<?php endif; ?>
			</div>
		</div>
	</div>
</section>
<?php endif; ?>
