<?php
/**
 * @package Hoxa - Responsive Multipurpose Joomla Template
 * @author Cththemes - www.cththemes.com
 * @date: 01-10-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */

// no direct access
defined('_JEXEC') or die;
$menu = JFactory::getApplication()->getMenu();
$defaultMenu = $menu->getDefault();
$activeMenu = $menu->getActive() ? $menu->getActive() : $menu->getDefault();
$blog_layout = 'list1';
$blog_sidebar = 'right';
if($activeMenu->params->get('blog_layout')){
  $blog_layout = $activeMenu->params->get('blog_layout','list1');
  $blog_sidebar = $activeMenu->params->get('blog_sidebar','right');
}

//echo'<pre>';var_dump($this->item);die;
$extraFields = array();

if($this->item->extra_fields){
  if(!is_array($this->item->extra_fields)){
    $extraFields = json_decode($this->item->extra_fields);
  }else{
    $extraFields = $this->item->extra_fields;
  }
}
//$extraFields = json_decode($this->item->extra_fields);
if(!empty($extraFields)){
  $postType = $extraFields[1]->value;
  $postLink = $extraFields[2]->value;
}
require_once JPATH_BASE.'/components/com_azurapagebuilder/helpers/elementparser.php';

function getK2CategoryLink($catid){
    require_once (JPATH_SITE.'/components/com_k2/helpers/route.php');
    return urldecode(JRoute::_(K2HelperRoute::getCategoryRoute($catid)));
}
// $postType = $extraFields[0]->value;
// $postLink = substr(JUtility::parseAttributes($extraFields[1]->value)['src'], strlen(JURI::base(true)));
?>
<section class="envor-section blog-single">
    <div class="container">
        <div class="row">
        <?php if($blog_sidebar == 'left') :?>
        <div class="col-lg-3 col-md-3">
            <?php 
              echo AzuraModuleHelper::loadposition('left-sidebar','widget');
            ?>
        </div>
        <?php endif;?>
        <?php if($blog_sidebar == 'full') :?>
          <div class="col-lg-12 col-md-12">
        <?php else: ?>
          <div class="col-lg-9 col-md-9">
        <?php endif;?>
        <!-- Post -->
        <article class="envor-post<?php echo ($this->item->featured) ? ' itemIsFeatured' : ''; ?><?php if($this->item->params->get('pageclass_sfx')) echo ' '.$this->item->params->get('pageclass_sfx'); ?>">
            <?php if(JRequest::getInt('print')==1): ?>
            <!-- Print button at the top of the print page only -->
            <a class="itemPrintThisPage" rel="nofollow" href="#" onclick="window.print();return false;">
                <span><?php echo JText::_('K2_PRINT_THIS_PAGE'); ?></span>
            </a>
            <?php endif; ?>

            <!-- Plugins: BeforeDisplay -->
            <?php echo $this->item->event->BeforeDisplay; ?>

            <!-- K2 Plugins: K2BeforeDisplay -->
            <?php echo $this->item->event->K2BeforeDisplay; ?>

            <?php if($this->item->params->get('itemImage') && !empty($this->item->image)): ?>
              <!-- Item Image -->
            <a href="<?php echo $this->item->image;?>" class="colorbox img">
                <img src="<?php echo $this->item->image; ?>" alt="<?php if(!empty($this->item->image_caption)) echo K2HelperUtilities::cleanHtml($this->item->image_caption); else echo K2HelperUtilities::cleanHtml($this->item->title); ?>"/>
                </a>
            <?php endif; ?>

            

            <header>
                <?php if($this->item->params->get('itemTitle')): ?>
                <!-- Item title -->
                <h3>
                    <i class="fa fa-image"></i>
                        <?php if(isset($this->item->editLink)): ?>
                        <!-- Item edit link -->
                        <span class="itemEditLink">
                            <a class="modal" rel="{handler:'iframe',size:{x:990,y:550}}" href="<?php echo $this->item->editLink; ?>">
                                <?php echo JText::_('K2_EDIT_ITEM'); ?>
                            </a>
                        </span>
                        <?php endif; ?>

                    <span><?php echo $this->item->title; ?></span>

                    <?php if($this->item->params->get('itemFeaturedNotice') && $this->item->featured): ?>
                    <!-- Featured flag -->
                    <span>
                        <sup>
                            <?php echo JText::_('K2_FEATURED'); ?>
                        </sup>
                    </span>
                    <?php endif; ?>

                </h3>
                <?php endif; ?>

                <!-- Plugins: AfterDisplayTitle -->
                <?php echo $this->item->event->AfterDisplayTitle; ?>

                <!-- K2 Plugins: K2AfterDisplayTitle -->
                <?php echo $this->item->event->K2AfterDisplayTitle; ?>
                <p>
                    <?php if($this->item->params->get('itemCategory')): ?>
                        <!-- Item category -->
                        <?php echo JText::_('TPL_ENVOR_POSTED_IN_TEXT');?>
                        <a href="<?php echo $this->item->category->link; ?>"><?php echo $this->item->category->name; ?></a>
                    <?php endif; ?>
                    <?php if($this->item->params->get('itemAuthor')): ?>
                    <!-- Item Author -->
                    
                        <?php echo JText::_('TPL_ENVOR_BY_TEXT');?>
                        <?php if(empty($this->item->created_by_alias)): ?>
                        <a href="<?php echo $this->item->author->link; ?>"><?php echo $this->item->author->name; ?></a>
                        <?php else: ?>
                        <a href="#"><?php echo $this->item->author->name; ?></a>
                        <?php endif; ?>
                    
                    <?php endif; ?>
                </p>

                <?php if($this->item->params->get('itemRating')): ?>
                <!-- Item Rating -->
                <div class="itemRatingBlock">
                    <span><?php echo JText::_('K2_RATE_THIS_ITEM'); ?></span>
                    <div class="itemRatingForm">
                        <ul class="itemRatingList">
                            <li class="itemCurrentRating" id="itemCurrentRating<?php echo $this->item->id; ?>" style="width:<?php echo $this->item->votingPercentage; ?>%;"></li>
                            <li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_1_STAR_OUT_OF_5'); ?>" class="one-star">1</a></li>
                            <li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_2_STARS_OUT_OF_5'); ?>" class="two-stars">2</a></li>
                            <li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_3_STARS_OUT_OF_5'); ?>" class="three-stars">3</a></li>
                            <li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_4_STARS_OUT_OF_5'); ?>" class="four-stars">4</a></li>
                            <li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_5_STARS_OUT_OF_5'); ?>" class="five-stars">5</a></li>
                        </ul>
                        <div id="itemRatingLog<?php echo $this->item->id; ?>" class="itemRatingLog"><?php echo $this->item->numOfvotes; ?></div>
                        <div class="clr"></div>
                    </div>
                    <div class="clr"></div>
                </div>
                <?php endif; ?>


                <?php if(
                    $this->item->params->get('itemFontResizer') ||
                    $this->item->params->get('itemPrintButton') ||
                    $this->item->params->get('itemEmailButton') ||
                    $this->item->params->get('itemSocialButton') ||
                    $this->item->params->get('itemVideoAnchor') ||
                    $this->item->params->get('itemImageGalleryAnchor')
                ): ?>
                <div class="itemToolbar">
                    <ul>
                        <?php if($this->item->params->get('itemFontResizer')): ?>
                        <!-- Font Resizer -->
                        <li>
                            <span class="itemTextResizerTitle"><?php echo JText::_('K2_FONT_SIZE'); ?></span>
                            <a href="#" id="fontDecrease">
                                <span><?php echo JText::_('K2_DECREASE_FONT_SIZE'); ?></span>
                                <img src="<?php echo JURI::root(true); ?>/components/com_k2/images/system/blank.gif" alt="<?php echo JText::_('K2_DECREASE_FONT_SIZE'); ?>" />
                            </a>
                            <a href="#" id="fontIncrease">
                                <span><?php echo JText::_('K2_INCREASE_FONT_SIZE'); ?></span>
                                <img src="<?php echo JURI::root(true); ?>/components/com_k2/images/system/blank.gif" alt="<?php echo JText::_('K2_INCREASE_FONT_SIZE'); ?>" />
                            </a>
                        </li>
                        <?php endif; ?>

                        <?php if($this->item->params->get('itemPrintButton') && !JRequest::getInt('print')): ?>
                        <!-- Print Button -->
                        <li>
                            <a class="itemPrintLink" rel="nofollow" href="<?php echo $this->item->printLink; ?>" onclick="window.open(this.href,'printWindow','width=900,height=600,location=no,menubar=no,resizable=yes,scrollbars=yes'); return false;">
                                <span><?php echo JText::_('K2_PRINT'); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>

                        <?php if($this->item->params->get('itemEmailButton') && !JRequest::getInt('print')): ?>
                        <!-- Email Button -->
                        <li>
                            <a class="itemEmailLink" rel="nofollow" href="<?php echo $this->item->emailLink; ?>" onclick="window.open(this.href,'emailWindow','width=400,height=350,location=no,menubar=no,resizable=no,scrollbars=no'); return false;">
                                <span><?php echo JText::_('K2_EMAIL'); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>

                        <?php if($this->item->params->get('itemSocialButton') && !is_null($this->item->params->get('socialButtonCode', NULL))): ?>
                        <!-- Item Social Button -->
                        <li>
                            <?php echo $this->item->params->get('socialButtonCode'); ?>
                        </li>
                        <?php endif; ?>

                        <?php if($this->item->params->get('itemVideoAnchor') && !empty($this->item->video)): ?>
                        <!-- Anchor link to item video below - if it exists -->
                        <li>
                            <a class="itemVideoLink k2Anchor" href="<?php echo $this->item->link; ?>#itemVideoAnchor"><?php echo JText::_('K2_MEDIA'); ?></a>
                        </li>
                        <?php endif; ?>

                        <?php if($this->item->params->get('itemImageGalleryAnchor') && !empty($this->item->gallery)): ?>
                        <!-- Anchor link to item image gallery below - if it exists -->
                        <li>
                            <a class="itemImageGalleryLink k2Anchor" href="<?php echo $this->item->link; ?>#itemImageGalleryAnchor"><?php echo JText::_('K2_IMAGE_GALLERY'); ?></a>
                        </li>
                        <?php endif; ?>

                        
                    </ul>
                    <div class="cl"></div>
                </div>
                <?php endif; ?>
            </header>
            <!-- Plugins: BeforeDisplayContent -->
            <?php echo $this->item->event->BeforeDisplayContent; ?>

            <!-- K2 Plugins: K2BeforeDisplayContent -->
            <?php echo $this->item->event->K2BeforeDisplayContent; ?>


            <?php if(!empty($this->item->fulltext)): ?>
                <?php if($this->item->params->get('itemIntroText')): ?>

                    <?php echo $this->item->introtext; ?>

                <?php endif; ?>
                <?php if($this->item->params->get('itemFullText')): ?>
                    <!-- Item fulltext -->
                    <?php echo $this->item->fulltext; ?>
                <?php endif; ?>
            <?php else: ?>
                <!-- Item text -->
                <?php echo $this->item->introtext; ?>
            <?php endif; ?>

            <?php if($this->item->params->get('itemTags') && count($this->item->tags)): ?>
              <!-- Item tags -->
                <p class="tags">
                    <?php foreach ($this->item->tags as $tag): ?>
                    <i class="fa fa-tag"></i> <a href="<?php echo $tag->link; ?>"><?php echo $tag->name; ?></a> 
                    <?php endforeach; ?>
                </p>
                <br>
              <?php endif; ?>


            <?php if($this->item->params->get('itemExtraFields') && count($this->item->extra_fields)): ?>
            <!-- Item extra fields -->
            <div class="itemExtraFields">
                <h3><?php echo JText::_('K2_ADDITIONAL_INFO'); ?></h3>
                <ul>
                    <?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
                    <?php if($extraField->value != ''): ?>
                    <li class="<?php echo ($key%2) ? "odd" : "even"; ?> type<?php echo ucfirst($extraField->type); ?> group<?php echo $extraField->group; ?>">
                        <?php if($extraField->type == 'header'): ?>
                        <h4 class="itemExtraFieldsHeader"><?php echo $extraField->name; ?></h4>
                        <?php else: ?>
                        <span class="itemExtraFieldsLabel"><?php echo $extraField->name; ?>:</span>
                        <span class="itemExtraFieldsValue"><?php echo $extraField->value; ?></span>
                        <?php endif; ?>
                    </li>
                    <?php endif; ?>
                    <?php endforeach; ?>
                    </ul>
                <div class="cl"></div>
            </div>
            <?php endif; ?>

            <?php if($this->item->params->get('itemAttachments') && count($this->item->attachments)): ?>
              <!-- Item attachments -->
              <div class="itemAttachmentsBlock">
                  <span><?php echo JText::_('K2_DOWNLOAD_ATTACHMENTS'); ?></span>
                  <ul class="itemAttachments">
                    <?php foreach ($this->item->attachments as $attachment): ?>
                    <li>
                        <a title="<?php echo K2HelperUtilities::cleanHtml($attachment->titleAttribute); ?>" href="<?php echo $attachment->link; ?>"><?php echo $attachment->title; ?></a>
                        <?php if($this->item->params->get('itemAttachmentsCounter')): ?>
                        <span>(<?php echo $attachment->hits; ?> <?php echo ($attachment->hits==1) ? JText::_('K2_DOWNLOAD') : JText::_('K2_DOWNLOADS'); ?>)</span>
                        <?php endif; ?>
                    </li>
                    <?php endforeach; ?>
                  </ul>
              </div>
            <?php endif; ?>

            

            <?php if($this->item->params->get('itemHits') || ($this->item->params->get('itemDateModified') && intval($this->item->modified)!=0)): ?>
            <div class="itemContentFooter">

                <?php if($this->item->params->get('itemHits')): ?>
                <!-- Item Hits -->
                <span class="itemHits">
                    <?php echo JText::_('K2_READ'); ?> <b><?php echo $this->item->hits; ?></b> <?php echo JText::_('K2_TIMES'); ?>
                </span>
                <?php endif; ?>

                <?php if($this->item->params->get('itemDateModified') && intval($this->item->modified)!=0): ?>
                <!-- Item date modified -->
                <span class="itemDateModified">
                    <?php echo JText::_('K2_LAST_MODIFIED_ON'); ?> <?php echo JHTML::_('date', $this->item->modified, JText::_('K2_DATE_FORMAT_LC2')); ?>
                </span>
                <?php endif; ?>

                <div class="clr"></div>
            </div>
            <?php endif; ?>

            <!-- Plugins: AfterDisplayContent -->
            <?php echo $this->item->event->AfterDisplayContent; ?>

            <!-- K2 Plugins: K2AfterDisplayContent -->
            <?php echo $this->item->event->K2AfterDisplayContent; ?>



            
            <?php if($this->item->params->get('itemTwitterButton',1) || $this->item->params->get('itemFacebookButton',1) || $this->item->params->get('itemGooglePlusOneButton',1)): ?>
            <!-- Social sharing -->
            <div class="itemSocialSharing">

                <?php if($this->item->params->get('itemTwitterButton',1)): ?>
                <!-- Twitter Button -->
                <div class="itemTwitterButton">
                    <a href="https://twitter.com/share" class="twitter-share-button" data-count="horizontal"<?php if($this->item->params->get('twitterUsername')): ?> data-via="<?php echo $this->item->params->get('twitterUsername'); ?>"<?php endif; ?>>
                        <?php echo JText::_('K2_TWEET'); ?>
                    </a>
                    <script type="text/javascript" src="//platform.twitter.com/widgets.js"></script>
                </div>
                <?php endif; ?>

                <?php if($this->item->params->get('itemFacebookButton',1)): ?>
                <!-- Facebook Button -->
                <div class="itemFacebookButton">
                    <div id="fb-root"></div>
                    <script type="text/javascript">
                        (function(d, s, id) {
                          var js, fjs = d.getElementsByTagName(s)[0];
                          if (d.getElementById(id)) return;
                          js = d.createElement(s); js.id = id;
                          js.src = "//connect.facebook.net/en_US/all.js#xfbml=1";
                          fjs.parentNode.insertBefore(js, fjs);
                        }(document, 'script', 'facebook-jssdk'));
                    </script>
                    <div class="fb-like" data-send="false" data-width="200" data-show-faces="true"></div>
                </div>
                <?php endif; ?>

                <?php if($this->item->params->get('itemGooglePlusOneButton',1)): ?>
                <!-- Google +1 Button -->
                <div class="itemGooglePlusOneButton">
                    <g:plusone annotation="inline" width="120"></g:plusone>
                    <script type="text/javascript">
                      (function() {
                        window.___gcfg = {lang: 'en'}; // Define button default language here
                        var po = document.createElement('script'); po.type = 'text/javascript'; po.async = true;
                        po.src = 'https://apis.google.com/js/plusone.js';
                        var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(po, s);
                      })();
                    </script>
                </div>
                <?php endif; ?>

                <div class="cl"></div>
            </div>
            <?php endif; ?>

            <?php if($this->item->params->get('itemDateCreated')): ?>
            <div class="date">
                <span class="day"><?php echo JHTML::_('date', $this->item->created , 'd'); ?></span>
                <span class="month"><?php echo JHTML::_('date', $this->item->created , 'm, y'); ?></span>
            </div>
            <?php endif; ?>

            <?php if($this->item->params->get('itemCommentsAnchor') && $this->item->params->get('itemComments') && ( ($this->item->params->get('comments') == '2' && !$this->user->guest) || ($this->item->params->get('comments') == '1')) ): ?>
            <!-- Anchor link to comments below - if enabled -->
            <div class="likes">
                <?php if(!empty($this->item->event->K2CommentsCounter)): ?>
                    <!-- K2 Plugins: K2CommentsCounter -->
                    <?php echo $this->item->event->K2CommentsCounter; ?>
                <?php else: ?>
                    <?php if($this->item->numOfComments > 0): ?>
                    <a class="itemCommentsLink k2Anchor" href="<?php echo $this->item->link; ?>#itemCommentsAnchor">
                        <span><i class="fa fa-comments"></i></span> <span class="month"><?php echo $this->item->numOfComments; ?> <?php //echo ($this->item->numOfComments>1) ? JText::_('K2_COMMENTS') : JText::_('K2_COMMENT'); ?></span>
                    </a>
                    <?php else: ?>
                    <a class="itemCommentsLink k2Anchor" href="<?php echo $this->item->link; ?>#itemCommentsAnchor">
                        <span><i class="fa fa-comments"></i></span> <span class="month"><?php echo JText::_('TPL_ENVOR_BE_FIRST');//JText::_('K2_BE_THE_FIRST_TO_COMMENT'); ?></span>
                    </a>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
            <?php endif; ?> 

            <?php if($this->item->params->get('itemNavigation') && !JRequest::getCmd('print') && (isset($this->item->nextLink) || isset($this->item->previousLink))): ?>
                <div style="min-height:15px;padding-top:13px;">
                    <?php if(isset($this->item->previousLink)): ?>
                        <a class="itemPrevious" href="<?php echo $this->item->previousLink; ?>">&laquo; <?php echo $this->item->previousTitle; ?></a>
                    <?php endif; ?>
                        <!-- <a class="project-back" href="<?php echo getK2CategoryLink($this->item->catid);?>"><i class="fa fa-th"></i></a> -->
                    <?php if(isset($this->item->nextLink)): ?>
                        <a class="itemNext flr" href="<?php echo $this->item->nextLink; ?>"><?php echo $this->item->nextTitle; ?> &raquo;</a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

        </article>
        


        <?php if($this->item->params->get('itemAuthorBlock') && empty($this->item->created_by_alias)): ?>
            <!-- Author Block -->
            <h3><?php echo JText::_('TPL_ENVOR_ABOUT_AUTHOR_TEXT');?></h3>
            <div class="envor-post-author">
                <?php if($this->item->params->get('itemAuthorImage') && !empty($this->item->author->avatar)): ?>
                    <figure><img class="itemAuthorAvatar" src="<?php echo $this->item->author->avatar; ?>" alt="<?php echo K2HelperUtilities::cleanHtml($this->item->author->name); ?>"></figure>
                <?php endif; ?>
                <p class="name"><?php echo $this->item->author->name; ?></p>
                <!-- <p class="role">developer</p> -->
                <?php if($this->item->params->get('itemAuthorDescription') && !empty($this->item->author->profile->description)): ?>
                    <p><?php echo $this->item->author->profile->description; ?></p>
                <?php endif; ?>
                <?php //echo '<pre>';var_dump($this->item->author);die;?>
                <p>
                    <?php if($this->item->params->get('itemAuthorURL') && !empty($this->item->author->profile->url)): ?>
                        <span class="itemAuthorUrl"><?php echo JText::_('K2_WEBSITE'); ?> <a rel="me" href="<?php echo $this->item->author->profile->url; ?>" target="_blank"><?php echo str_replace('http://','',$this->item->author->profile->url); ?></a></span>
                    <?php endif; ?>

                    <?php if($this->item->params->get('itemAuthorEmail')): ?>
                        <span class="itemAuthorEmail"><?php echo JText::_('K2_EMAIL'); ?> <?php echo JHTML::_('Email.cloak', $this->item->author->email); ?></span>
                    <?php endif; ?>
                </p>
                <!-- K2 Plugins: K2UserDisplay -->
                <?php echo $this->item->event->K2UserDisplay; ?>
            </div>
            <p>&nbsp;</p>
            <p>&nbsp;</p>
        <?php endif; ?>

        <?php if($this->item->params->get('itemAuthorLatest') && empty($this->item->created_by_alias) && isset($this->authorLatestItems)): ?>
            <!-- Latest items from author -->
            <div class="itemAuthorLatest">
                <h3><?php echo JText::_('K2_LATEST_FROM'); ?> <?php echo $this->item->author->name; ?></h3>
                <ul>
                    <?php foreach($this->authorLatestItems as $key=>$item): ?>
                    <li class="<?php echo ($key%2) ? "odd" : "even"; ?>">
                        <a href="<?php echo $item->link ?>"><?php echo $item->title; ?></a>
                    </li>
                    <?php endforeach; ?>
                </ul>
                <div class="clr"></div>
            </div>
            <?php endif; ?>

        <?php
            /*
            Note regarding 'Related Items'!
            If you add:
            - the CSS rule 'overflow-x:scroll;' in the element div.itemRelated {…} in the k2.css
            - the class 'k2Scroller' to the ul element below
            - the classes 'k2ScrollerElement' and 'k2EqualHeights' to the li element inside the foreach loop below
            - the style attribute 'style="width:<?php echo $item->imageWidth; ?>px;"' to the li element inside the foreach loop below
            ...then your Related Items will be transformed into a vertical-scrolling block, inside which, all items have the same height (equal column heights). This can be very useful if you want to show your related articles or products with title/author/category/image etc., which would take a significant amount of space in the classic list-style display.
            */
        ?>

        <?php if($this->item->params->get('itemRelated') && isset($this->relatedItems)): ?>
        <!-- Related items by tag -->
        <h3><?php echo JText::_('TPL_ENVOR_RELATED_POSTS_TEXT');?></h3>
        <?php if($this->relatedItems) :?>
            <div class="envor-relative envor-related-posts" data-visible="3" data-selector="envor-post-preview">
                <?php foreach($this->relatedItems as $key=>$item): ?>
                    <article class="envor-post-preview envor-padding-left-30">
                        <div class="envor-post-preview-inner">
                            <header>
                                <div class="date">
                                    <span class="day"><?php echo JHTML::_('date', $this->item->created , 'd'); ?></span><span class="month"><?php echo JHTML::_('date', $this->item->created , 'M, y'); ?></span>
                                </div>
                                <?php if($this->item->params->get('itemRelatedTitle', 1)): ?>
                                    <a class="itemRelTitle" href="<?php echo $item->link ?>"><?php echo $item->title; ?></a>
                                <?php endif; ?>
                            </header>
                            <?php if($this->item->params->get('itemRelatedCategory')): ?>
                            <div class="itemRelCat"><?php echo JText::_("K2_IN"); ?> <a href="<?php echo $item->category->link ?>"><?php echo $item->category->name; ?></a></div>
                            <?php endif; ?>

                            <?php if($this->item->params->get('itemRelatedAuthor')): ?>
                            <div class="itemRelAuthor"><?php echo JText::_("K2_BY"); ?> <a rel="author" href="<?php echo $item->author->link; ?>"><?php echo $item->author->name; ?></a></div>
                            <?php endif; ?>

                            <?php if($this->item->params->get('itemRelatedImageSize')): ?>
                            <img style="width:<?php echo $item->imageWidth; ?>px;height:auto;" class="itemRelImg" src="<?php echo $item->image; ?>" alt="<?php K2HelperUtilities::cleanHtml($item->title); ?>" />
                            <?php endif; ?>

                            <?php if($this->item->params->get('itemRelatedIntrotext')): ?>
                            <div class="itemRelIntrotext"><?php echo $item->introtext; ?></div>
                            <?php endif; ?>

                            <?php if($this->item->params->get('itemRelatedFulltext')): ?>
                            <div class="itemRelFulltext"><?php echo $item->fulltext; ?></div>
                            <?php endif; ?>

                            <?php if($this->item->params->get('itemRelatedMedia')): ?>
                                <?php if($item->videoType=='embedded'): ?>
                                <div class="itemRelMediaEmbedded"><?php echo $item->video; ?></div>
                                <?php else: ?>
                                <div class="itemRelMedia"><?php echo $item->video; ?></div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php if($this->item->params->get('itemRelatedImageGallery')): ?>
                            <div class="itemRelImageGallery"><?php echo $item->gallery; ?></div>
                            <?php endif; ?>
                            
                        </div>
                    </article>
                <?php endforeach; ?>
                <div class="envor-navigation envor-navigation-left rivaslider-navigation">
                    <a href="" class="back"><i class="glyphicon glyphicon-chevron-left"></i></a>
                    <a href="" class="forward"><i class="glyphicon glyphicon-chevron-right"></i></a>
                </div>
            </div>
        <?php endif;?>
        <?php endif; ?>

        <?php if($this->item->params->get('itemVideo') && !empty($this->item->video)): ?>
        <!-- Item video -->
        <a name="itemVideoAnchor" id="itemVideoAnchor"></a>

        <div class="itemVideoBlock">
            <h3><?php echo JText::_('K2_MEDIA'); ?></h3>

                <?php if($this->item->videoType=='embedded'): ?>
                <div class="itemVideoEmbedded">
                    <?php echo $this->item->video; ?>
                </div>
                <?php else: ?>
                <span class="itemVideo"><?php echo $this->item->video; ?></span>
                <?php endif; ?>

              <?php if($this->item->params->get('itemVideoCaption') && !empty($this->item->video_caption)): ?>
              <span class="itemVideoCaption"><?php echo $this->item->video_caption; ?></span>
              <?php endif; ?>

              <?php if($this->item->params->get('itemVideoCredits') && !empty($this->item->video_credits)): ?>
              <span class="itemVideoCredits"><?php echo $this->item->video_credits; ?></span>
              <?php endif; ?>

              <div class="clr"></div>
          </div>
        <?php endif; ?>

        <?php if($this->item->params->get('itemImageGallery') && !empty($this->item->gallery)): ?>
          <!-- Item image gallery -->
          <a name="itemImageGalleryAnchor" id="itemImageGalleryAnchor"></a>
          <div class="itemImageGallery">
              <h3><?php echo JText::_('K2_IMAGE_GALLERY'); ?></h3>
              <?php echo $this->item->gallery; ?>
          </div>
        <?php endif; ?>

        

        <!-- Plugins: AfterDisplay -->
        <?php echo $this->item->event->AfterDisplay; ?>

        <!-- K2 Plugins: K2AfterDisplay -->
        <?php echo $this->item->event->K2AfterDisplay; ?>

        <?php if($this->item->params->get('itemComments') && ( ($this->item->params->get('comments') == '2' && !$this->user->guest) || ($this->item->params->get('comments') == '1'))): ?>
            <!-- K2 Plugins: K2CommentsBlock -->
            <?php echo $this->item->event->K2CommentsBlock; ?>
        <?php endif; ?>

        <?php if($this->item->params->get('itemComments') && ($this->item->params->get('comments') == '1' || ($this->item->params->get('comments') == '2')) && empty($this->item->event->K2CommentsBlock)): ?>
            <!-- Item comments -->
            <a name="itemCommentsAnchor" id="itemCommentsAnchor"></a>
            <?php if($this->item->params->get('commentsFormPosition')=='above' && $this->item->params->get('itemComments') && !JRequest::getInt('print') && ($this->item->params->get('comments') == '1' || ($this->item->params->get('comments') == '2' && K2HelperPermissions::canAddComment($this->item->catid)))): ?>
                <!-- Item comments form -->
                <!-- <div class="itemCommentsForm"> -->
                    <?php echo $this->loadTemplate('comments_form'); ?>
                <!-- </div> -->
            <?php endif; ?>
            <div class="envor-comments-list">

                <?php if($this->item->numOfComments>0 && $this->item->params->get('itemComments') && ($this->item->params->get('comments') == '1' || ($this->item->params->get('comments') == '2'))): ?>
                <!-- Item user comments -->
                <h3>
                    <strong><?php echo $this->item->numOfComments; ?></strong> <?php echo ($this->item->numOfComments>1) ? JText::_('K2_COMMENTS') : JText::_('K2_COMMENT'); ?>
                </h3>
                
                
                <?php foreach ($this->item->comments as $key=>$comment): ?>
                    <div class="envor-comment<?php echo (!$this->item->created_by_alias && $comment->userID==$this->item->created_by) ? " authorResponse" : ""; echo($comment->published) ? '':' unpublishedComment'; ?>">
                        <div class="inner">
                        <?php if($comment->userImage): ?>
                            <figure><img src="<?php echo $comment->userImage; ?>"  width="<?php echo $this->item->params->get('commenterImgWidth'); ?>" alt="<?php echo JFilterOutput::cleanText($comment->userName); ?>"></figure>
                        <?php endif; ?>
                            <p class="meta"><span class="author">
                            <?php if(!empty($comment->userLink)): ?>
                            <a href="<?php echo JFilterOutput::cleanText($comment->userLink); ?>" title="<?php echo JFilterOutput::cleanText($comment->userName); ?>" target="_blank" rel="nofollow">
                                <?php echo $comment->userName; ?>
                            </a>
                            <?php else: ?>
                            <?php echo $comment->userName; ?>
                            <?php endif; ?> <?php echo JText::_('TPL_ENVOR_SAYS_TEXT'); ?></span> <span class="date"><?php echo JText::_('TPL_ENVOR_POSTED_ON_TEXT'); ?><?php echo JHTML::_('date', $comment->commentDate, JText::_('CTH_COMMENT_DATE_FORMAT')); ?></span></p>
                            <div class="entry"><?php echo $comment->commentText; ?></div>

                            <?php if($this->inlineCommentsModeration || ($comment->published && ($this->params->get('commentsReporting')=='1' || ($this->params->get('commentsReporting')=='2' && !$this->user->guest)))): ?>
                            <span class="commentToolbar">
                                <?php if($this->inlineCommentsModeration): ?>
                                <?php if(!$comment->published): ?>
                                <a class="commentApproveLink" href="<?php echo JRoute::_('index.php?option=com_k2&view=comments&task=publish&commentID='.$comment->id.'&format=raw')?>"><?php echo JText::_('K2_APPROVE')?></a>
                                <?php endif; ?>

                                <a class="commentRemoveLink" href="<?php echo JRoute::_('index.php?option=com_k2&view=comments&task=remove&commentID='.$comment->id.'&format=raw')?>"><?php echo JText::_('K2_REMOVE')?></a>
                                <?php endif; ?>

                                <?php if($comment->published && ($this->params->get('commentsReporting')=='1' || ($this->params->get('commentsReporting')=='2' && !$this->user->guest))): ?>
                                <a class="modal" rel="{handler:'iframe',size:{x:560,y:480}}" href="<?php echo JRoute::_('index.php?option=com_k2&view=comments&task=report&commentID='.$comment->id)?>"><?php echo JText::_('K2_REPORT')?></a>
                                <?php endif; ?>

                                <?php if($comment->reportUserLink): ?>
                                <a class="k2ReportUserButton" href="<?php echo $comment->reportUserLink; ?>"><?php echo JText::_('K2_FLAG_AS_SPAMMER'); ?></a>
                                <?php endif; ?>

                            </span>
                            <?php endif; ?>

                        </div>
                    </div>
                <?php endforeach; ?>

                <!-- <div class="itemCommentsPagination"> -->
                    <?php echo $this->pagination->getPagesLinks(); ?>
                    <!-- <div class="cl"></div> -->
                <!-- </div> -->
                <?php endif; ?>
                <p>&nbsp;</p>
                <p>&nbsp;</p>
            </div>

            <?php if($this->item->params->get('commentsFormPosition')=='below' && $this->item->params->get('itemComments') && !JRequest::getInt('print') && ($this->item->params->get('comments') == '1' || ($this->item->params->get('comments') == '2' && K2HelperPermissions::canAddComment($this->item->catid)))): ?>
                <!-- Item comments form -->
                <!-- <div class="itemCommentsForm"> -->
                    <?php echo $this->loadTemplate('comments_form'); ?>
                <!-- </div> -->
            <?php endif; ?>

            <?php $user = JFactory::getUser(); 
            if ($this->item->params->get('comments') == '2' && $user->guest): ?>
                <div><?php echo JText::_('K2_LOGIN_TO_POST_COMMENTS'); ?></div>
            <?php endif; ?>

          
        <?php endif; ?>



        </div> <!-- end col-lg-9 -->

        <?php if($blog_sidebar == 'right') :?>
        <div class="col-lg-3 col-md-3">
            <?php 
                echo AzuraModuleHelper::loadposition('right-sidebar','widget');
            ?>
        </div>
        <?php endif;?>

        </div>
    </div>
</section>

  
  

  


