<?php
/**
 * @package Hoxa - Responsive Multipurpose Joomla Template
 * @author Cththemes - www.cththemes.com
 * @date: 01-10-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */

defined('_JEXEC') or die;

$app             = JFactory::getApplication();
$doc             = JFactory::getDocument();
$user            = JFactory::getUser();
$this->language  = $doc->language;
$this->direction = $doc->direction;

$menu = $app->getMenu();//echo'<pre>';var_dump($menu);
$defaultMenu = $menu->getDefault();
$activeMenu = $menu->getActive();

// Getting params from template
$params = $app->getTemplate(true)->params;

// Detecting Active Variables
$option   = $app->input->getCmd('option', '');
$view     = $app->input->getCmd('view', '');
$layout   = $app->input->getCmd('layout', '');
$task     = $app->input->getCmd('task', '');
$itemid   = $app->input->getCmd('Itemid', '');
$sitename = $app->get('sitename');

$template_folder = JURI::root(true).'/templates/'.$this->template;

$favicon = $params->get('favicon');
$pageClassSfx = '';

$showLoading = $params->get('showLoading','1');
$showBackTop = $params->get('showBackTop','1');

// Google fonts
$useDifferentFont = $params->get('useDifferentFont','0');
$bodyfont = $params->get('bodyfont','Raleway');
$bodyfontvariants = $params->get('bodyfontvariants',array());
$bodyfontfamily = $params->get('bodyfontfamily',"'Raleway', sans-serif;");

$headingfont = $params->get('headingfont','Oswald');
$headingfontvariants = $params->get('headingfontvariants',array());
$headingfontfamily = $params->get('headingfontfamily',"'Oswald', sans-serif;");

// $highlightfont = $params->get('highlightfont','Raleway');
// $highlightfontvariants = $params->get('highlightfontvariants',array());
// $highlightfontfamily = $params->get('highlightfontfamily',"'Raleway', sans-serif;");


if(count($bodyfontvariants)){
    $bodyfont .= ':'.implode(",", $bodyfontvariants);
}

if(count($headingfontvariants)){
    $headingfont .= ':'.implode(",", $headingfontvariants);
}

if(isset($activeMenu)){
    if($activeMenu->params->get('pageclass_sfx')){
        $pageClassSfx =  ' '.$activeMenu->params->get('pageclass_sfx');  
    }
}

$favicon = $params->get('favicon','');
$logoImage = $params->get('logoImage','');
$logoText = $params->get('logoText','');
$logoSubText = $params->get('logoSubText','');
$logotype = $params->get('logotype','image');

$errorbg = $params->get('errorbg','');
if(!empty($errorbg)){
	$errorbg = ' style="background-image:url('.JURI::root(true).'/'.$errorbg.');"';
}else{
	$errorbgcolor = $params->get('errorbgcolor','#e14d43');
	$errorbg = ' style="background-color:'.$errorbgcolor.';"';
}
$errortext = $params->get('errortext','');

$phonenumber = $params->get('phonenumber','');
$email = $params->get('email','');
$facebooklink = $params->get('facebooklink','');
$googlepluslink = $params->get('googlepluslink','');
$twitterlink = $params->get('twitterlink','');
$linkedinlink = $params->get('linkedinlink','');
$rsslink = $params->get('rsslink','');
$envelopelink = $params->get('envelopelink','');

$preset = $params->get('preset','default');
$overrideColor = $params->get('overrideColor','0');
$bC = substr($params->get('baseColor', '#e14d43'),1);
$sC = substr($params->get('secondColor', '#363b3f'),1);
$tC = substr($params->get('thirdColor', '#9AD03E'),1);

// $logo = '';
// if ($logotype !== 'showboth') {
// 	if($logotype === 'image'){
// 		$logo = '<a href="'.JURI::root(true).'"  title="'.$sitename.'"><img src="'.JURI::root(true).'/'.$logoImage.'" class="img-responsive"></a>';
// 	}else{
// 		if(!empty($logoText)){
// 			$logo = '<h1 class="logo"><a href="'.JURI::root(true).'"  title="'.$sitename.'">'.$logoText.'</a></h1>';
// 		}elseif(empty($logo)){
// 			$logo = '<h1  class="logo"><a href="'.JURI::root(true).'"  title="'.$sitename.'">'.$sitename.'</a><h1>';
// 		}
// 	}
// }else{
// 	if(!empty($logoImage)){
// 		$logo .= '<a href="'.JURI::root(true).'"  title="'.$sitename.'"><img src="'.JURI::root(true).'/'.$logoImage.'" class="img-responsive"></a>';
// 	}
// 	if(!empty($logoText)){
// 		$logo .= '<h1 class="logo"><a href="'.JURI::root(true).'"  title="'.$sitename.'">'.$logoText.'</a></h1>';
// 	}else{
// 		$logo .= '<h1  class="logo"><a href="'.JURI::root(true).'"  title="'.$sitename.'">'.$sitename.'</a><h1>';
// 	}
// }
require_once JPATH_BASE.'/components/com_azurapagebuilder/helpers/elementparser.php';


?>

<!DOCTYPE html>
<!--[if lt IE 7]><html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="<?php echo $this->language;?>"> <![endif]-->
<!--[if IE 7]> <html class="no-js lt-ie9 lt-ie8" lang="<?php echo $this->language;?>"> <![endif]-->
<!--[if IE 8]> <html class="no-js lt-ie9" lang="<?php echo $this->language;?>"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" lang="<?php echo $this->language;?>"> <!--<![endif]-->
  <head>
    <meta charset="<?php echo $this->_charset;?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Standard Favicon--> 
	<link rel="shortcut icon" href="<?php echo JURI::base(true). (!empty($favicon)? '/'.$favicon : '/images/favicon/favicon.ico');?>">

    <title><?php echo $this->title; ?> <?php echo htmlspecialchars($this->error->getMessage(), ENT_QUOTES, 'UTF-8'); ?></title>

    <?php if($useDifferentFont === '1') :?>
	<link href='https://fonts.googleapis.com/css?family=<?php echo $bodyfont;?>' rel='stylesheet' type='text/css'>
	<link href='https://fonts.googleapis.com/css?family=<?php echo $headingfont;?>' rel='stylesheet' type='text/css'>
	<?php else :?>
	<link href='https://fonts.googleapis.com/css?family=Raleway:400,100,200,300,500,600,700,800' rel='stylesheet' type='text/css'>
  	<link href='https://fonts.googleapis.com/css?family=Lato:100,300,400,700,900,100italic,300italic,400italic,700italic,900italic' rel='stylesheet' type='text/css'>
	<?php endif;?>
    <!-- Bootstrap core CSS -->
    <link href="<?php echo $template_folder; ?>/css/bootstrap.min.css" rel="stylesheet" type="text/css">
    <!-- Custom CSS -->
    <link href="<?php echo $template_folder; ?>/css/animate.css" rel="stylesheet" type="text/css">
    <link href="<?php echo $template_folder; ?>/css/jquery.mCustomScrollbar.css" rel="stylesheet" type="text/css">
    <link href="<?php echo $template_folder; ?>/css/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="<?php echo $template_folder; ?>/css/colorbox-skins/4/colorbox.css" type="text/css">
    <link href="<?php echo $template_folder; ?>/css/main.css" rel="stylesheet" type="text/css">
    <link href="<?php echo $template_folder; ?>/css/settings.css" rel="stylesheet" type="text/css">
    <link href="<?php echo $template_folder; ?>/css/header/h1.css" rel="stylesheet" type="text/css">
    <link href="<?php echo $template_folder; ?>/css/responsive.css" rel="stylesheet" type="text/css">
    <link href="<?php echo $template_folder; ?>/css/rivathemes.css" rel="stylesheet" type="text/css">

    <?php if($overrideColor == '1') : ?>
    <link rel="stylesheet/less" type="text/css" href="<?php echo $template_folder; ?>/css/color.php?bc=<?php echo $bC;?>&amp;sc=<?php echo $sC;?>&amp;tc=<?php echo $tC;?>">
<script type="text/javascript" src="<?php echo $template_folder; ?>/js/less.js"></script>
    <?php else : ?>
      <?php if($preset !== 'default') :?>
        <link rel="stylesheet" href="<?php echo $template_folder; ?>/css/<?php echo $preset;?>.css" id="envor-site-color"/>
      <?php else:?>
        <link href="<?php echo $template_folder; ?>/css/color1.css" rel="stylesheet" type="text/css" id="envor-site-color">
      <?php endif;?>
    <?php endif;?>
    <!-- Custom Style -->
    <link rel="stylesheet" type="text/css" href="<?php echo $template_folder; ?>/css/custom.css" media="all" />

    <!-- Just for debugging purposes. Don't actually copy this line! -->
    <!--[if lt IE 9]><script src="<?php echo $template_folder; ?>/js/vendor/ie8-responsive-file-warning.js"></script><![endif]-->

    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
      <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->

    <script src="<?php echo $template_folder; ?>/js/vendor/modernizr-2.6.2-respond-1.1.0.min.js"></script>
    <script type="text/javascript" >
		baseUrl = "<?php echo JURI::root(true);?>";
		siteName = "<?php echo $sitename;?>";
		templateName = "<?php echo $this->template;?>";
	</script>
  </head>
<body class="cth-site<?php echo $pageClassSfx;?> <?php echo $option
	. ' view-' . $view
	. ($layout ? ' layout-' . $layout : ' no-layout')
	. ($task ? ' task-' . $task : ' no-task')
	. ($itemid ? ' itemid-' . $itemid : '');
?>">

    <!--[if lt IE 7]>
    <p class="chromeframe">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> or <a href="http://www.google.com/chromeframe/?redirect=true">activate Google Chrome Frame</a> to improve your experience.</p>
    <![endif]-->
    <?php if($showBackTop === '1') :?>
    <div id="to-the-top"><i class="fa fa-chevron-up"></i></div>
	<?php endif;?>

	<?php if($showLoading === '1') :?>
	    <div id="envor-preload">
	      <span><?php echo JText::_('TPL_ENVOR_LOADING_TEXT');?></span>
	      <i class="fa fa-cog fa-spin"></i>
	      <p></p>
	    </div>
	<?php endif;?>
    
    <header class="envor-header envor-header-1">
      <!--

      Top bar start

      //-->
      <div class="envor-top-bar">
        <div class="container">
          <div class="row">
            <div class="col-lg-12">
                <?php if(!empty($phonenumber)) :?>
                <p class="contacts"><i class="fa fa-phone"></i> <?php echo $phonenumber;?></p>
                <?php endif;?>
                <?php if(!empty($email)) :?>
                  <p class="contacts"><i class="fa fa-envelope"></i> <a href="mailto:<?php echo $email;?>"><?php echo $email;?></a></p>
                <?php endif;?>
                  
                  <ul class="social-btns">
                      <?php if(!empty($facebooklink)) :?>
                          <li><a href="<?php echo $facebooklink;?>"><i class="fa fa-facebook"></i></a></li>
                      <?php endif;?>
                      <?php if(!empty($twitterlink)) :?>
                          <li><a href="<?php echo $twitterlink;?>"><i class="fa fa-twitter"></i></a></li>
                      <?php endif;?>
                      <?php if(!empty($linkedinlink)) :?>
                          <li><a href="<?php echo $linkedinlink;?>"><i class="fa fa-linkedin"></i></a></li>
                      <?php endif;?>
                      <?php if(!empty($googlepluslink)) :?>
                          <li><a href="<?php echo $googlepluslink;?>"><i class="fa fa-google-plus"></i></a></li>
                      <?php endif;?>
                      <?php if(!empty($rsslink)) :?>
                          <li><a href="<?php echo $rsslink;?>"><i class="fa fa-rss"></i></a></li>
                      <?php endif;?>
                          
                </ul>

              	<?php echo $doc->getBuffer('modules', 'top_bar', array('style' => 'none')); ?>
            </div>
          </div>
        </div>
      </div>
    <!--

    Envor header end

    //-->
    </header>
    <!--

    Envor site content start

    //-->
    <div class="envor-content envor-content-404" data-stellar-background-ratio="0.5" <?php echo $errorbg;?>>
      <div class="envor-content-404-gradient"></div>
        <!--

        404 Page Content start

        //-->
        <div class="envor-content-404-inner">
                <!--

                Site Logo start

                //-->
                <a href="<?php echo JURI::root(true);?>" class="logolink">
                    <div class="envor-logo">
                      <?php if(!empty($logoImage)) :?>
                        <img src="<?php echo JURI::root(true).'/'.$logoImage;?>" alt="<?php echo $sitename;?>">
                      <?php endif;?>
                      <?php if(!empty($logoText)) :?>
                        <p class="logo"><?php echo $logoText;?></p>
                      <?php endif;?>
                      <?php if(!empty($logoSubText)) :?>
                        <p class="tagline"><?php echo $logoSubText;?></p>
                      <?php endif;?>
                    </div>
                </a>

                <p class="oops"><?php echo $this->error->getCode(); ?>!</p>
                <p class="note"><?php echo htmlspecialchars($this->error->getMessage(), ENT_QUOTES, 'UTF-8');?></p>
                <p>&nbsp;</p>
                <?php echo $doc->getBuffer('modules', '404-search', array('style' => 'none')); ?>
                <p>&nbsp;</p>
                <?php echo $doc->getBuffer('modules', '404-menu', array('style' => 'none')); ?>
        <!--

        404 Page Content end

        //-->
        </div>
      <!--

      Social Buttons List start

      //-->
      <section class="envor-section envor-section-st2 envor-soc-buttons-list" id="socials">
        <div class="container">
          <div class="row">
            <div class="col-lg-12">
              <?php echo ElementParser::do_shortcode($doc->getBuffer('modules', '404-socials', array('style' => 'none')) ); ?>
            </div>
          </div>
        </div>
      <!--

      Social Buttons List end

      //-->
      </section>
    </div>
    <script src="<?php echo $template_folder; ?>/js/vendor/jquery-1.11.0.min.js"></script>
    <script src="<?php echo $template_folder; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo $template_folder; ?>/js/jquery.mCustomScrollbar.min.js"></script>
    <script src="<?php echo $template_folder; ?>/js/jquery.mousewheel.min.js"></script>
    <script src="<?php echo $template_folder; ?>/js/jquery.colorbox-min.js"></script>
    <script src="<?php echo $template_folder; ?>/js/preloadCssImages.jQuery_v5.js"></script>
    <script src="<?php echo $template_folder; ?>/js/jquery.stellar.min.js"></script>
    <script src="<?php echo $template_folder; ?>/js/jquery.fitvids.js"></script>
    <script src="<?php echo $template_folder; ?>/js/jquery.bxslider.min.js"></script>
  <script src="<?php echo $template_folder; ?>/js/masonry.pkgd.min.js"></script>
  <script src="<?php echo $template_folder; ?>/js/imagesloaded.pkgd.min.js"></script>
  <script src="<?php echo $template_folder; ?>/js/jquery.rivaMegaMenu.js"></script>

    <!--
    * jQuery with jQuery Easing, and jQuery Transit JS
    //-->
    <script src="<?php echo $template_folder; ?>/js/layerslider/jquery-easing-1.3.js" type="text/javascript"></script>
    <script src="<?php echo $template_folder; ?>/js/layerslider/jquery-transit-modified.js" type="text/javascript"></script>
    <script src="<?php echo $template_folder; ?>/js/jquery.rivathemes.js"></script>
    <script src="<?php echo $template_folder; ?>/js/jquery.flexslider-min.js"></script>
    <script src="<?php echo $template_folder; ?>/js/envor.js"></script>
    <script type="text/javascript">

        jQuery('document').ready(function($) {
            var $container = $('body');
            $container.imagesLoaded( function() {
                $('#envor-preload').hide();
            });
      });
      
      /*

      Windows Phone 8 и Internet Explorer 10

      */
      if (navigator.userAgent.match(/IEMobile\/10\.0/)) {
        var msViewportStyle = document.createElement("style")
        msViewportStyle.appendChild(
          document.createTextNode(
            "@-ms-viewport{width:auto!important}"
          )
        )
        document.getElementsByTagName("head")[0].appendChild(msViewportStyle)
      }
    </script>
  </body>
</html>