<?php
/*
 * --------------------------------------------------------------------------------
 * J2 Store Stock Notification Plugin
 * --------------------------------------------------------------------------------
 * @package		Joomla! 2.5+
 * @subpackage	J2 Store
 * @author 		Weblogicx India http://www.weblogicxindia.com
 * @copyright	Copyright (c) 2010 - 2015 Weblogicx India Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * --------------------------------------------------------------------------------
 */

/**
 * ensure this file is being included by a parent file
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );

require_once (JPATH_ADMINISTRATOR . '/components/com_j2store/library/plugins/_base.php');
require_once (JPATH_SITE . '/components/com_j2store/helpers/utilities.php');
jimport('joomla.filesystem.file');

class plgJ2StoreOrderexportemail extends J2StorePluginBase {

	var $_element = 'orderexportemail';

	function plgJ2StoreOrderexportemail(& $subject, $config) {
		parent::__construct ( $subject, $config );
		$this->loadLanguage ( 'com_j2store', JPATH_ADMINISTRATOR );
	}

	function onJ2StoreBeforeOrderExport() {
		$data = array();

		$pref = $this->params->get('email_latest_orders');

		$data['export_status'] = $this->params->get('export_status');
		if($pref) {
			$last_export_id = $this->_getLastExportId();
			$data['export_from'] = $last_export_id+1;
		} else {
			$data['export_from'] = 0;
		}
		$data['export_to'] = '';
		$data['export_from_date'] ='';
		$data['export_to_date'] ='';

		return $data;
	}

	function onJ2StoreAfterOrderExport($filepath, $last_order_id) {

		//send the email with file as attachment
		if($this->params->get('auto_email')) {
			$this->_sendNotification($filepath);
		}
		$pref = $this->params->get('email_latest_orders');
		//write the last order id to text file.
		if($pref) {
			$this->_writeLastExportId($last_order_id);
		}

		//delete the file after sending
		if($this->params->get('delete_file')) {
			unlink($filepath);
		}

	}

	private function _sendNotification($file) {

		//get params
		$params = JComponentHelper::getParams('com_j2store');
		$app =JFactory::getApplication();
		$config = JFactory::getConfig();

		//get the emails if set from the plugin params
		$export_emails = $this->params->get('export_emails', '');

		if(!empty($export_emails)) {
			$export_emails  = explode(',', $export_emails);

		}else {
			return true;
		}

		//get the mailer
		$mailer = clone JFactory::getMailer();

		$mailer->IsHTML(true);
		// Required in order not to get broken characters
		$mailer->CharSet = 'UTF-8';
		$mailer->addAttachment($file);

		if(version_compare(JVERSION, '3.0', 'ge')) {
			$mailfrom = $params->get('emails_defaultemail', $config->get('mailfrom'));
			$fromname = $params->get('emails_defaultname', $config->get('fromname'));
			$sitename = $config->get('sitename');
		} else {
			$mailfrom = $params->get('emails_defaultname', $config->getValue('config.mailfrom'));
			$fromname = $params->get('emails_defaultname', $config->getValue('config.fromname'));
			$sitename = $config->getValue('config.sitename');
		}

		//set subject
		$subject = JText::sprintf('J2STORE_EXPORT_ORDER_EMAIL_SUBJECT', $sitename);
		$mailer->setSubject($subject);

		//get the body html
		$mailer->setBody(JText::_('J2STORE_EXPORT_ORDER_EMAIL_BODY'));

		$mailer->addRecipient($export_emails);
		$mailer->setSender(array( $mailfrom, $fromname ));
		$mailer->send();
		return true;
	}

	private function _getLastExportId() {

		$target = JPATH_SITE.'/plugins/j2store/orderexportemail/invid.txt';
		$id = 0;
		if(JFile::exists($target)) {
			$rawData = JFile::read($target);
			$info = explode("\n", $rawData);
			$id = trim($info[0]);
		}
		return (int) $id;
	}

	private function _writeLastExportId($id) {

		$file = JPATH_SITE.'/plugins/j2store/orderexportemail/invid.txt';
		$buffer = $id;
		try {
			JFile::write($file, $buffer);
		}catch (Exception $e) {
			//do nothing here
		}

		return true;
	}
}
