<?php

defined('_JEXEC') or die;

jimport('joomla.application.component.helper');

class plgInstallerAzuraPagebuilder extends JPlugin
{
    /**
     * Load the language file on instantiation.
     *
     * @var    boolean
     * @since  3.6.0
     */
    protected $autoloadLanguage = true;

    /**
     * Handle adding credentials to package download request.
     *
     * @param string $url     url from which package is going to be downloaded
     * @param array  $headers headers to be sent along the download request (key => value format)
     *
     * @return boolean true if credentials have been added to request or not our business, false otherwise (credentials not set by user)
     *
     * @since   3.0
     */
    public function onInstallerBeforePackageDownload(&$url, &$headers)
    {
        $app = JFactory::getApplication();

        $uri = JUri::getInstance($url);
        $host = $uri->getHost();

        if ($host !== 'www.azura.cththemes.com') {
            return true;
        }

        // Get the purchase code
        $com_params = JComponentHelper::getParams('com_azurapagebuilder');
        $purchase_code = $com_params->get('purchase_code','');


        if ( empty($purchase_code) && strpos($url, 'azura-page-builder') !== false  ) {

            $app->enqueueMessage(JText::_('PLG_INSTALLER_AZURAPAGEBUILDER_PURCHASE_CODE_WRANING'), 'notice');

            return true;
        }

        // Append the purchase code to the download URL
        $uri->setVar('purchase_code', $purchase_code);
        $url = $uri->toString();

        return true;
    }
}
