<?php 
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
$animation_data = self::buildAnimation($azura_attrs);
$classes = array(
    'azp_element',
    'azp_contactform contacts-ajax',
    $el_class,
);
$classes[] = $animation_data['trigger'];
$classes[] = self::buildTypography($azura_attrs);//will return custom class for the element without dot
$azpcontactformstyle = self::buildStyle($azura_attrs);

if(!empty($el_id)){
    $el_id = 'id="'.$el_id.'"';
}
$classes = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $classes ) ) );

$document = JFactory::getDocument();
$document->addScriptOptions('com_azp_contact', array(
    'name' => JText::_('Please enter your name'),
    'email' => array(JText::_('Please enter your email address'),JText::_('Your email address must be in the format of name@domain.com')),
    'message' => JText::_('Please enter your message'),
    'error' => JText::_('There is something wrong! Try again please.'),
    'thanks'=> $thanksmessage,
    'plw' => JText::_('Please wait...')
));

?>
<!--contact form -->

<div class="<?php echo $classes; ?>" <?php echo $el_id .' ' . $azpcontactformstyle.' '.$animation_data['data'];?>>

    <?php if($title!='') :?>
    <h3><?php echo $title;?></h3>
    <?php endif;?>

    <div id="azp_message"></div>

    <form class="envor-fhtml" method="post" action="<?php echo JURI::current();?>" name="azpcontactform" id="azpcontactform" data-redirect="<?php echo $redirect;?>">
        <fieldset>
            
            <legend><?php echo JText::_('TPL_ENVOR_CONTACT_DETAILS');?></legend>

            <div>
                <label for="name" accesskey="U"><?php echo JText::_('TPL_ENVOR_YOUR_NAME_TEXT');?></label>
                <input type="text" name="name" id="name" placeholder="<?php echo JText::_('TPL_ENVOR_ENTER_YOUR_NAME_TEXT');?>" required="required">
            </div>
            <div>
                <label for="email" accesskey="E"><?php echo JText::_('TPL_ENVOR_YOUR_EMAIL_TEXT');?></label>
                <input type="email" name="email" id="email" placeholder="<?php echo JText::_('TPL_ENVOR_ENTER_YOUR_EMAIL_ADDRESS_TEXT');?>" required="required">
            </div>
            <?php if($showwebsite === '1') :?> 
            <div>
                <label for="website" accesskey="W"><?php echo JText::_('TPL_ENVOR_YOUR_WEBSITE_TEXT');?></label>
                <input type="text" name="website" id="website" placeholder="<?php echo JText::_('TPL_ENVOR_ENTER_YOUR_WEBSITE_ADDRESS_TEXT');?>">
            </div>
            <?php endif;?>
        </fieldset>

        <fieldset>
            <legend><?php echo JText::_('TPL_ENVOR_YOUR_MESSAGES');?></legend>

            <?php if($showsubject === '1') :?> 
            <div>
                <label for="subject" accesskey="S"><?php echo JText::_('TPL_ENVOR_YOUR_SUBJECT_TEXT');?></label>
                <input type="text" name="subject" id="subject" value="<?php echo $emailsubject;?>" required="required">
            </div>
            <?php endif;?>

            <div>
                <label for="message" accesskey="C"><?php echo JText::_('TPL_ENVOR_MESSAGE_TEXT');?></label>
                <textarea name="message" cols="40" rows="3" id="message" placeholder="<?php echo JText::_('TPL_ENVOR_YOUR_MESSAGE_TEXT');?>" spellcheck="true" required="required"></textarea>
            </div>


            <?php           
            $captchaId = uniqid('captchaid');
            JPluginHelper::importPlugin('captcha', 'recaptcha');
            $dispatcher = JEventDispatcher::getInstance();
            $initResult = $dispatcher->trigger('onInit', array($captchaId));
            if ($initResult)
            {
                echo implode('', $dispatcher->trigger('onDisplay', array(null, $captchaId, 'class=""')));
            }
            ?>

        </fieldset>
        

        <button id="azurasubmit" type="submit" class="envor-btn envor-btn-normal envor-btn-primary" ><?php echo JText::_('TPL_ENVOR_SEND_MESSAGE_TEXT');?></button>

            
        <?php if($showsubject === '0') :?> 
        <input type="hidden" name="subject" value="<?php echo $emailsubject;?>">
        <?php endif;?>
        <input type="hidden" name="option" value="com_azurapagebuilder">
        <input type="hidden" name="task" value="ajax.contact">
        <?php echo JHtml::_('form.token'); ?>


    </form>
</div>
