CREATE TABLE `#__action_log_config` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `id_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `title_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `table_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `text_prefix` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `#__action_log_config`  VALUES ('1', 'article', 'com_content.article', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'), ('2', 'article', 'com_content.form', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'), ('3', 'banner', 'com_banners.banner', 'id', 'name', '#__banners', 'PLG_ACTIONLOG_JOOMLA'), ('4', 'user_note', 'com_users.note', 'id', 'subject', '#__user_notes', 'PLG_ACTIONLOG_JOOMLA'), ('5', 'media', 'com_media.file', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'), ('6', 'category', 'com_categories.category', 'id', 'title', '#__categories', 'PLG_ACTIONLOG_JOOMLA'), ('7', 'menu', 'com_menus.menu', 'id', 'title', '#__menu_types', 'PLG_ACTIONLOG_JOOMLA'), ('8', 'menu_item', 'com_menus.item', 'id', 'title', '#__menu', 'PLG_ACTIONLOG_JOOMLA'), ('9', 'newsfeed', 'com_newsfeeds.newsfeed', 'id', 'name', '#__newsfeeds', 'PLG_ACTIONLOG_JOOMLA'), ('10', 'link', 'com_redirect.link', 'id', 'old_url', '#__redirect_links', 'PLG_ACTIONLOG_JOOMLA'), ('11', 'tag', 'com_tags.tag', 'id', 'title', '#__tags', 'PLG_ACTIONLOG_JOOMLA'), ('12', 'style', 'com_templates.style', 'id', 'title', '#__template_styles', 'PLG_ACTIONLOG_JOOMLA'), ('13', 'plugin', 'com_plugins.plugin', 'extension_id', 'name', '#__extensions', 'PLG_ACTIONLOG_JOOMLA'), ('14', 'component_config', 'com_config.component', 'extension_id', 'name', '', 'PLG_ACTIONLOG_JOOMLA'), ('15', 'contact', 'com_contact.contact', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA'), ('16', 'module', 'com_modules.module', 'id', 'title', '#__modules', 'PLG_ACTIONLOG_JOOMLA'), ('17', 'access_level', 'com_users.level', 'id', 'title', '#__viewlevels', 'PLG_ACTIONLOG_JOOMLA'), ('18', 'banner_client', 'com_banners.client', 'id', 'name', '#__banner_clients', 'PLG_ACTIONLOG_JOOMLA'), ('19', 'application_config', 'com_config.application', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA');
CREATE TABLE `#__action_logs` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `message_language_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `message` text COLLATE utf8mb4_unicode_ci NOT NULL,   `log_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `user_id` int(11) NOT NULL DEFAULT '0',   `item_id` int(11) NOT NULL DEFAULT '0',   `ip_address` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0',   PRIMARY KEY (`id`),   KEY `idx_user_id` (`user_id`),   KEY `idx_user_id_logdate` (`user_id`,`log_date`),   KEY `idx_user_id_extension` (`user_id`,`extension`),   KEY `idx_extension_item_id` (`extension`,`item_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE `#__action_logs_extensions` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `#__action_logs_extensions`  VALUES ('1', 'com_banners'), ('2', 'com_cache'), ('3', 'com_categories'), ('4', 'com_config'), ('5', 'com_contact'), ('6', 'com_content'), ('7', 'com_installer'), ('8', 'com_media'), ('9', 'com_menus'), ('10', 'com_messages'), ('11', 'com_modules'), ('12', 'com_newsfeeds'), ('13', 'com_plugins'), ('14', 'com_redirect'), ('15', 'com_tags'), ('16', 'com_templates'), ('17', 'com_users'), ('18', 'com_checkin');
CREATE TABLE `#__action_logs_users` (   `user_id` int(11) unsigned NOT NULL,   `notify` tinyint(1) unsigned NOT NULL,   `extensions` text COLLATE utf8mb4_unicode_ci NOT NULL,   PRIMARY KEY (`user_id`),   KEY `idx_notify` (`notify`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE `#__ak_profiles` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,   `configuration` longtext COLLATE utf8mb4_unicode_ci,   `filters` longtext COLLATE utf8mb4_unicode_ci,   `quickicon` tinyint(3) NOT NULL DEFAULT '1',   PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `#__ak_profiles`  VALUES ('1', 'Default Backup Profile', '###AES128###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', '', '1');
CREATE TABLE `#__ak_stats` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,   `comment` longtext COLLATE utf8mb4_unicode_ci,   `backupstart` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `backupend` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `status` enum('run','fail','complete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'run',   `origin` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'backend',   `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'full',   `profile_id` bigint(20) NOT NULL DEFAULT '1',   `archivename` longtext COLLATE utf8mb4_unicode_ci,   `absolute_path` longtext COLLATE utf8mb4_unicode_ci,   `multipart` int(11) NOT NULL DEFAULT '0',   `tag` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `backupid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `filesexist` tinyint(3) NOT NULL DEFAULT '1',   `remote_filename` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `total_size` bigint(20) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `idx_fullstatus` (`filesexist`,`status`),   KEY `idx_stale` (`status`,`origin`) ) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `#__ak_stats`  VALUES ('1', 'Backup taken on Thursday, 01 January 2015 06:41', '', '2014-12-31 23:41:03', '2014-12-31 23:41:37', 'complete', 'backend', 'full', '1', 'site-localhost-20150101-064103.zip', '/Applications/AMPPS/www/devgo/administrator/components/com_akeeba/backup/site-localhost-20150101-064103.zip', '1', 'backend', NULL, '0', NULL, '26075801'), ('2', 'Backup taken on Monday, 05 January 2015 09:47', '', '2015-01-05 02:47:05', '2015-01-05 02:47:34', 'complete', 'backend', 'full', '1', 'site-localhost-20150105-094705.zip', '/Applications/AMPPS/www/devgo/administrator/components/com_akeeba/backup/site-localhost-20150105-094705.zip', '1', 'backend', NULL, '0', NULL, '29524668'), ('3', 'Backup taken on Tuesday, 06 January 2015 13:58', '', '2015-01-06 06:58:52', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'site-localhost-20150106-135852.zip', '/Applications/AMPPS/www/devgo/administrator/components/com_akeeba/backup/site-localhost-20150106-135852.zip', '0', 'backend', NULL, '0', NULL, '0'), ('4', 'Backup taken on Sunday, 11 January 2015 06:28', '', '2015-01-10 23:28:05', '2015-01-10 23:28:47', 'complete', 'backend', 'full', '1', 'site-localhost-20150111-062805.zip', '/Applications/AMPPS/www/devgo/administrator/components/com_akeeba/backup/site-localhost-20150111-062805.zip', '1', 'backend', NULL, '0', NULL, '35088313'), ('5', 'Backup taken on Sunday, 11 January 2015 08:40', '', '2015-01-11 01:40:10', '2015-01-11 01:40:49', 'complete', 'backend', 'full', '1', 'site-localhost-20150111-084010.zip', '/Applications/AMPPS/www/devgo/administrator/components/com_akeeba/backup/site-localhost-20150111-084010.zip', '1', 'backend', NULL, '0', NULL, '35096226'), ('6', 'Backup taken on Wednesday, 14 January 2015 10:47', '', '2015-01-14 03:47:06', '2015-01-14 03:47:49', 'complete', 'backend', 'full', '1', 'site-localhost-20150114-104706.zip', '/Applications/AMPPS/www/devgo/administrator/components/com_akeeba/backup/site-localhost-20150114-104706.zip', '1', 'backend', NULL, '0', NULL, '41867370'), ('7', 'Backup taken on Thursday, 15 January 2015 14:21', '', '2015-01-15 07:21:03', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'site-localhost-20150115-142103.zip', '/Applications/AMPPS/www/devgo/administrator/components/com_akeeba/backup/site-localhost-20150115-142103.zip', '0', 'backend', NULL, '0', NULL, '0'), ('8', 'Backup taken on Sunday, 18 January 2015 14:08', '', '2015-01-18 07:08:21', '2015-01-18 07:08:57', 'complete', 'backend', 'full', '1', 'site-localhost-20150118-140821.zip', '/Applications/AMPPS/www/devgo/administrator/components/com_akeeba/backup/site-localhost-20150118-140821.zip', '1', 'backend', NULL, '0', NULL, '44492899'), ('9', 'Backup taken on Monday, 26 January 2015 13:37', '', '2015-01-26 06:37:30', '2015-01-26 06:40:34', 'complete', 'backend', 'full', '1', 'site-localhost-20150126-133730.zip', '/Applications/AMPPS/www/devgo/administrator/components/com_akeeba/backup/site-localhost-20150126-133730.zip', '1', 'backend', NULL, '0', NULL, '45410091'), ('10', 'Backup taken on Thursday, 29 January 2015 10:01', '', '2015-01-29 03:01:05', '2015-01-29 03:05:20', 'complete', 'backend', 'full', '1', 'site-localhost-20150129-100105.zip', '/Applications/AMPPS/www/devgo/administrator/components/com_akeeba/backup/site-localhost-20150129-100105.zip', '1', 'backend', NULL, '0', NULL, '42999418'), ('11', 'Backup taken on Friday, 06 February 2015 15:40', '', '2015-02-06 08:40:23', '2015-02-06 08:41:00', 'complete', 'backend', 'full', '1', 'site-localhost-20150206-154023.zip', '/Applications/AMPPS/www/devgo/administrator/components/com_akeeba/backup/site-localhost-20150206-154023.zip', '1', 'backend', NULL, '0', NULL, '48285042'), ('12', 'Backup taken on Sunday, 08 February 2015 12:02', '', '2015-02-08 05:02:11', '2015-02-08 05:02:49', 'complete', 'backend', 'full', '1', 'site-localhost-20150208-120211.zip', '/Applications/AMPPS/www/devgo/administrator/components/com_akeeba/backup/site-localhost-20150208-120211.zip', '1', 'backend', NULL, '0', NULL, '48931485'), ('13', 'Backup taken on Monday, 09 February 2015 15:01', '', '2015-02-09 08:01:30', '2015-02-09 08:02:10', 'complete', 'backend', 'full', '1', 'site-localhost-20150209-150130.zip', '/Applications/AMPPS/www/devgo/administrator/components/com_akeeba/backup/site-localhost-20150209-150130.zip', '1', 'backend', NULL, '0', NULL, '49395740'), ('14', 'Backup taken on Saturday, 14 February 2015 03:38', '', '2015-02-13 20:38:47', '2015-02-13 20:39:26', 'complete', 'backend', 'full', '1', 'site-localhost-20150214-033847.zip', '/Applications/AMPPS/www/devgo/administrator/components/com_akeeba/backup/site-localhost-20150214-033847.zip', '1', 'backend', NULL, '0', NULL, '49420021'), ('15', 'Backup taken on Saturday, 14 February 2015 10:25', '', '2015-02-14 03:25:15', '2015-02-14 03:25:53', 'complete', 'backend', 'full', '1', 'site-localhost-20150214-102515.zip', '/Applications/AMPPS/www/devgo/administrator/components/com_akeeba/backup/site-localhost-20150214-102515.zip', '1', 'backend', NULL, '0', NULL, '49414180'), ('16', 'Backup taken on Wednesday, 18 February 2015 01:55', '', '2015-02-17 18:55:35', '2015-02-17 18:56:13', 'complete', 'backend', 'full', '1', 'site-localhost-20150218-015535.zip', '/Applications/AMPPS/www/devgo/administrator/components/com_akeeba/backup/site-localhost-20150218-015535.zip', '1', 'backend', NULL, '0', NULL, '31551170'), ('17', 'Backup taken on Wednesday, 18 February 2015 01:58', '', '2015-02-17 18:58:56', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'site-localhost-20150218-015856.zip', '/Applications/AMPPS/www/devgo/administrator/components/com_akeeba/backup/site-localhost-20150218-015856.zip', '0', 'backend', NULL, '0', NULL, '0'), ('18', 'Backup taken on Thursday, 26 February 2015 01:40', '', '2015-02-25 18:40:25', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'site-demo.cththemes.com-20150226-014025.zip', '/home/cththeme/public_html/demo_new/templatetest/administrator/components/com_akeeba/backup/site-demo.cththemes.com-20150226-014025.zip', '0', 'backend', NULL, '0', NULL, '0'), ('19', 'Backup taken on Friday, 13 March 2015 06:56', '', '2015-03-12 23:56:35', '2015-03-12 23:57:13', 'complete', 'backend', 'full', '1', 'site-localhost-20150313-065635.jpa', '/Applications/AMPPS/www/devenvor/administrator/components/com_akeeba/backup/site-localhost-20150313-065635.jpa', '0', 'backend', NULL, '0', NULL, '30375015'), ('20', 'Backup taken on Friday, 13 March 2015 06:57', '', '2015-03-12 23:58:02', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'site-localhost-20150313-065802.zip', '/Applications/AMPPS/www/devenvor/administrator/components/com_akeeba/backup/site-localhost-20150313-065802.zip', '0', 'backend', NULL, '0', NULL, '0'), ('21', 'Backup taken on Sunday, 03 May 2015 11:41', '', '2015-05-03 04:41:59', '2015-05-03 04:43:15', 'complete', 'backend', 'full', '1', 'site-localhost-20150503-114159.zip', '/Applications/AMPPS/www/devenvor/administrator/components/com_akeeba/backup/site-localhost-20150503-114159.zip', '0', 'backend', NULL, '0', NULL, '46807893'), ('22', 'Backup taken on Sunday, 03 May 2015 14:13', '', '2015-05-03 07:13:36', '2015-05-03 07:14:56', 'complete', 'backend', 'full', '1', 'site-localhost-20150503-141336.zip', '/Applications/AMPPS/www/devenvor/administrator/components/com_akeeba/backup/site-localhost-20150503-141336.zip', '0', 'backend', NULL, '0', NULL, '46945124'), ('23', 'Backup taken on Sunday, 03 May 2015 14:49', '', '2015-05-03 07:49:19', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'site-localhost-20150503-144919.zip', '/Applications/AMPPS/www/devenvor/administrator/components/com_akeeba/backup/site-localhost-20150503-144919.zip', '0', 'backend', NULL, '0', NULL, '0'), ('24', 'Backup taken on Thursday, 11 June 2015 12:21', '', '2015-06-11 05:21:06', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'site-localhost-20150611-122106.zip', '/Applications/AMPPS/www/quickstartenvor/administrator/components/com_akeeba/backup/site-localhost-20150611-122106.zip', '0', 'backend', NULL, '0', NULL, '0'), ('25', 'Backup taken on Thursday, 02 July 2015 03:06', '', '2015-07-01 20:07:00', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'site-localhost-20150702-030700.zip', '/Applications/AMPPS/www/quickstartenvor/administrator/components/com_akeeba/backup/site-localhost-20150702-030700.zip', '0', 'backend', NULL, '0', NULL, '0'), ('26', 'Backup taken on Tuesday, 29 March 2016 05:09', '', '2016-03-28 22:09:27', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'site-localhost-20160329-050927.zip', '/Applications/AMPPS/www/quickstartenvor/administrator/components/com_akeeba/backup/site-localhost-20160329-050927.zip', '0', 'backend', NULL, '0', NULL, '0'), ('27', 'Backup taken on Friday, 20 October 2017 02:25', '', '2017-10-19 19:25:41', '2017-10-19 19:27:06', 'complete', 'backend', 'full', '1', 'site-localhost-20171020-022541.zip', '/Applications/MAMP/htdocs/envor/administrator/components/com_akeeba/backup/site-localhost-20171020-022541.zip', '0', 'backend', 'id27', '1', NULL, '59655658'), ('28', 'Backup taken on Friday, 20 October 2017 02:48', '', '2017-10-19 19:49:01', '2017-10-19 19:50:07', 'complete', 'backend', 'full', '1', 'site-localhost-20171020-024901.zip', '/Applications/MAMP/htdocs/envor/administrator/components/com_akeeba/backup/site-localhost-20171020-024901.zip', '0', 'backend', 'id28', '1', NULL, '44267571'), ('29', 'Backup taken on Thursday, 18 July 2019 04:06', '', '2019-07-18 04:06:40', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'site-localhost-20190718-040640.zip', '/Applications/MAMP/htdocs/envor/administrator/components/com_akeeba/backup/site-localhost-20190718-040640.zip', '0', 'backend', 'id29', '1', NULL, '0');
CREATE TABLE `#__ak_storage` (   `tag` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,   `lastupdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,   `data` longtext COLLATE utf8mb4_unicode_ci,   PRIMARY KEY (`tag`(100)) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE `#__akeeba_common` (   `key` varchar(190) COLLATE utf8mb4_unicode_ci NOT NULL,   `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,   PRIMARY KEY (`key`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `#__akeeba_common`  VALUES ('file_fef', '[\"com_akeeba\"]'), ('fof30', '[\"com_akeeba\",\"file_fef\"]'), ('stats_lastrun', '1563417727'), ('stats_siteid', 'f649265cb782ab101b7e7d19297fc0263a9927b5'), ('stats_siteurl', '3d354d99df7f1f4e8f0fb8e0ec271d0f');
CREATE TABLE `#__assets` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',   `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',   `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',   `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',   `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',   `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',   `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',   `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',   PRIMARY KEY (`id`),   UNIQUE KEY `idx_asset_name` (`name`),   KEY `idx_lft_rgt` (`lft`,`rgt`),   KEY `idx_parent_id` (`parent_id`) ) ENGINE=InnoDB AUTO_INCREMENT=229 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `#__assets`  VALUES ('1', '0', '0', '379', '0', 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('2', '1', '1', '2', '1', 'com_admin', 'com_admin', '{}'), ('3', '1', '3', '6', '1', 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('4', '1', '7', '8', '1', 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('5', '1', '9', '10', '1', 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('6', '1', '11', '12', '1', 'com_config', 'com_config', '{}'), ('7', '1', '13', '16', '1', 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('8', '1', '17', '66', '1', 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('9', '1', '67', '68', '1', 'com_cpanel', 'com_cpanel', '{}'), ('10', '1', '69', '70', '1', 'com_installer', 'com_installer', '{\"core.admin\":[],\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'), ('11', '1', '71', '72', '1', 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('12', '1', '73', '74', '1', 'com_login', 'com_login', '{}'), ('13', '1', '75', '76', '1', 'com_mailto', 'com_mailto', '{}'), ('14', '1', '77', '78', '1', 'com_massmail', 'com_massmail', '{}'), ('15', '1', '79', '80', '1', 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'), ('16', '1', '81', '82', '1', 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('17', '1', '83', '84', '1', 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('18', '1', '85', '238', '1', 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('19', '1', '239', '242', '1', 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('20', '1', '243', '244', '1', 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('21', '1', '245', '246', '1', 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1},\"core.manage\":[]}'), ('22', '1', '247', '248', '1', 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'), ('23', '1', '249', '250', '1', 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('24', '1', '251', '254', '1', 'com_users', 'com_users', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('25', '1', '255', '258', '1', 'com_weblinks', 'com_weblinks', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('26', '1', '259', '260', '1', 'com_wrapper', 'com_wrapper', '{}'), ('27', '8', '18', '19', '2', 'com_content.category.2', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('28', '3', '4', '5', '2', 'com_banners.category.3', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('29', '7', '14', '15', '2', 'com_contact.category.4', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('30', '19', '240', '241', '2', 'com_newsfeeds.category.5', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('31', '25', '256', '257', '2', 'com_weblinks.category.6', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('32', '24', '252', '253', '1', 'com_users.category.7', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('33', '1', '261', '262', '1', 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'), ('34', '1', '263', '264', '1', 'com_joomlaupdate', 'com_joomlaupdate', '{\"core.admin\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}'), ('35', '1', '265', '266', '1', 'com_tags', 'com_tags', '{\"core.admin\":[],\"core.manage\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}'), ('36', '1', '267', '268', '1', 'com_contenthistory', 'com_contenthistory', '{}'), ('37', '1', '269', '270', '1', 'com_ajax', 'com_ajax', '{}'), ('38', '1', '271', '272', '1', 'com_postinstall', 'com_postinstall', '{}'), ('40', '18', '86', '87', '2', 'com_modules.module.2', 'Login', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('41', '18', '88', '89', '2', 'com_modules.module.3', 'Popular Articles', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('42', '18', '90', '91', '2', 'com_modules.module.4', 'Recently Added Articles', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('43', '18', '92', '93', '2', 'com_modules.module.8', 'Toolbar', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('44', '18', '94', '95', '2', 'com_modules.module.9', 'Quick Icons', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('45', '18', '96', '97', '2', 'com_modules.module.10', 'Logged-in Users', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('46', '18', '98', '99', '2', 'com_modules.module.12', 'Admin Menu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('47', '18', '100', '101', '2', 'com_modules.module.13', 'Admin Submenu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('48', '18', '102', '103', '2', 'com_modules.module.14', 'User Status', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('49', '18', '104', '105', '2', 'com_modules.module.15', 'Title', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('50', '18', '106', '107', '2', 'com_modules.module.16', 'Log In', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('51', '18', '108', '109', '2', 'com_modules.module.17', 'Breadcrumbs', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('52', '18', '110', '111', '2', 'com_modules.module.79', 'Multilanguage status', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('53', '18', '112', '113', '2', 'com_modules.module.86', 'Joomla Version', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('54', '1', '273', '360', '1', 'com_azurapagebuilder', 'com_azurapagebuilder', '{}'), ('55', '1', '361', '362', '1', 'com_k2', 'com_k2', '{\"core.admin\":[],\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('56', '18', '114', '115', '2', 'com_modules.module.87', 'Blog --Comments--', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('57', '18', '116', '117', '2', 'com_modules.module.88', 'Recent --Posts--', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('58', '18', '118', '119', '2', 'com_modules.module.89', '--Search-- Widget', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('59', '18', '120', '121', '2', 'com_modules.module.90', 'K2 --Users--', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('60', '18', '122', '123', '2', 'com_modules.module.91', 'K2 --User--', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('61', '18', '124', '125', '2', 'com_modules.module.92', 'K2 Quick Icons (admin)', ''), ('62', '18', '126', '127', '2', 'com_modules.module.93', 'K2 Stats (admin)', ''), ('63', '1', '363', '364', '1', 'com_jce', 'jce', '{}'), ('64', '18', '128', '129', '2', 'com_modules.module.94', 'Copyright', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('65', '18', '130', '131', '2', 'com_modules.module.95', 'Main Navigation', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('66', '1', '365', '366', '1', 'com_akeeba', 'akeeba', '{}'), ('67', '18', '132', '133', '2', 'com_modules.module.96', 'Home Index2 Slider', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('68', '1', '367', '368', '1', 'com_uniterevolution2', 'com_uniterevolution2', '{\"revolution2.slidersetting\":{\"7\":1},\"revolution2.slideroperations\":{\"7\":1},\"revolution2.slideoperations\":{\"7\":1},\"revolution2.editslide\":{\"7\":1} }'), ('70', '18', '134', '135', '2', 'com_modules.module.98', 'VM - Administrator Module', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('80', '18', '136', '137', '2', 'com_modules.module.105', 'K2 Store Cart', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('81', '18', '138', '139', '2', 'com_modules.module.106', 'K2Store Currency', ''), ('90', '8', '20', '53', '2', 'com_content.category.8', 'Envor Store', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('91', '90', '21', '22', '3', 'com_content.article.1', 'backpack', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('92', '90', '23', '24', '3', 'com_content.article.2', 'sunglasses', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('93', '90', '25', '26', '3', 'com_content.article.3', 'helm', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('94', '90', '27', '28', '3', 'com_content.article.4', 'bag', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('95', '90', '29', '30', '3', 'com_content.article.5', 'flashlight', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('96', '90', '31', '32', '3', 'com_content.article.6', 'laptop', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('97', '90', '33', '34', '3', 'com_content.article.7', 'sunglasses', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('98', '90', '35', '36', '3', 'com_content.article.8', 'women\'s bag', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('99', '90', '37', '38', '3', 'com_content.article.9', 'women\'s heels', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('100', '90', '39', '40', '3', 'com_content.article.10', 'women\'s heels', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('101', '90', '41', '42', '3', 'com_content.article.11', 'shiny sunglasses', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('102', '90', '43', '44', '3', 'com_content.article.12', 'Women\'s shoes', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('103', '90', '45', '46', '3', 'com_content.article.13', 'Hard hat, eyeglasses...', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('104', '90', '47', '48', '3', 'com_content.article.14', 'Stylish sunglasses', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('105', '90', '49', '50', '3', 'com_content.article.15', 'Yellow bag', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('106', '90', '51', '52', '3', 'com_content.article.16', 'Digital SLR camera', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('107', '18', '140', '141', '2', 'com_modules.module.114', 'Online Store Introtext', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('108', '18', '142', '143', '2', 'com_modules.module.115', 'Envor Main Navigation', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('109', '18', '144', '145', '2', 'com_modules.module.116', 'Sidebar - Pages Navigation', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('112', '18', '146', '147', '2', 'com_modules.module.119', 'Browse --Categories--', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('114', '18', '148', '149', '2', 'com_modules.module.121', 'Popular --Posts--', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('115', '18', '150', '151', '2', 'com_modules.module.122', 'Post --Tags--', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('116', '18', '152', '153', '2', 'com_modules.module.123', '--Calendar--', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('117', '18', '154', '155', '2', 'com_modules.module.124', 'Recent --Tweets--', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('121', '18', '156', '157', '2', 'com_modules.module.125', 'VM - Administrator Module', ''), ('122', '18', '158', '159', '2', 'com_modules.module.126', 'VM - Currencies Selector', ''), ('123', '18', '160', '161', '2', 'com_modules.module.127', 'VM - Featured products', ''), ('124', '18', '162', '163', '2', 'com_modules.module.128', 'VM - Search in Shop', ''), ('125', '18', '164', '165', '2', 'com_modules.module.129', 'VM - Manufacturer', ''), ('126', '18', '166', '167', '2', 'com_modules.module.130', 'VM - Shopping cart', ''), ('127', '18', '168', '169', '2', 'com_modules.module.131', 'VM - Category', ''), ('128', '1', '369', '370', '1', 'com_uniform', 'uniform', '{}'), ('129', '18', '170', '171', '2', 'com_modules.module.132', 'General Enquiry - UniForm', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('130', '18', '172', '173', '2', 'com_modules.module.133', 'Sales Enquiry - UniForm', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('131', '18', '174', '175', '2', 'com_modules.module.134', 'Voice It Form - UniForm', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('132', '18', '176', '177', '2', 'com_modules.module.135', 'Contacts', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('133', '18', '178', '179', '2', 'com_modules.module.136', 'Flickr --Photos--', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('134', '18', '180', '181', '2', 'com_modules.module.137', 'Latest --News--', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('135', '18', '182', '183', '2', 'com_modules.module.138', 'About', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('136', '18', '184', '185', '2', 'com_modules.module.139', 'Easy Customization', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('137', '18', '186', '187', '2', 'com_modules.module.140', 'Easy Customization', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('138', '18', '188', '189', '2', 'com_modules.module.141', '600+ Font Icons', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('139', '18', '190', '191', '2', 'com_modules.module.142', '600+ Font Icons', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('140', '18', '192', '193', '2', 'com_modules.module.143', 'Tons of Shortcodes', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('141', '18', '194', '195', '2', 'com_modules.module.144', 'Tons of Shortcodes', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('142', '18', '196', '197', '2', 'com_modules.module.145', 'Working Contact Form', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('143', '18', '198', '199', '2', 'com_modules.module.146', 'Working Contact Form', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('144', '18', '200', '201', '2', 'com_modules.module.147', 'Links', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('145', '18', '202', '203', '2', 'com_modules.module.148', 'About', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('146', '18', '204', '205', '2', 'com_modules.module.149', 'Content --Tags--', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('147', '18', '206', '207', '2', 'com_modules.module.150', 'Contacts', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('149', '18', '208', '209', '2', 'com_modules.module.152', 'Top Search Box', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('150', '18', '210', '211', '2', 'com_modules.module.153', 'Envor Mobile Navigation', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('151', '8', '54', '65', '2', 'com_content.category.9', 'Pricing Plans', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('152', '151', '55', '56', '3', 'com_content.article.17', 'Basic', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('153', '151', '57', '58', '3', 'com_content.article.18', 'Plus', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('154', '151', '59', '60', '3', 'com_content.article.19', 'Pro', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('155', '151', '61', '62', '3', 'com_content.article.20', 'Extra', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('156', '18', '212', '213', '2', 'com_modules.module.154', 'Related Products', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('157', '18', '214', '215', '2', 'com_modules.module.155', 'S5 Domain Check', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('158', '18', '216', '217', '2', 'com_modules.module.156', 'J2Store Detail Cart Advanced', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('160', '18', '218', '219', '2', 'com_modules.module.158', 'CTH Domain Check', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('161', '18', '220', '221', '2', 'com_modules.module.159', 'Products Search', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('163', '18', '222', '223', '2', 'com_modules.module.161', 'Breadcrumbs Right', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('164', '18', '224', '225', '2', 'com_modules.module.162', '404 Search', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('165', '18', '226', '227', '2', 'com_modules.module.163', '404 Menu', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('166', '18', '228', '229', '2', 'com_modules.module.164', '404 Socials', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('167', '18', '230', '231', '2', 'com_modules.module.165', 'Comming Soon Menu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('168', '18', '232', '233', '2', 'com_modules.module.166', 'Comming Soon Socials', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('169', '151', '63', '64', '3', 'com_content.article.21', 'Free', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('170', '18', '234', '235', '2', 'com_modules.module.167', 'Home Index4 Slider', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('171', '18', '236', '237', '2', 'com_modules.module.168', 'Home Index5 Slider', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('173', '54', '274', '313', '2', 'com_azurapagebuilder.category.10', 'Envor - Home Page', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('174', '173', '275', '276', '3', 'azurapagebuilder.page.1', 'Home Index 1', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('175', '173', '277', '278', '3', 'azurapagebuilder.page.2', 'Home Index 2', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('176', '173', '279', '280', '3', 'azurapagebuilder.page.3', 'Home Index 4', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('177', '173', '281', '282', '3', 'azurapagebuilder.page.4', 'Home Index 5', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('178', '173', '283', '284', '3', 'azurapagebuilder.page.5', 'Home Index 6', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('179', '173', '285', '286', '3', 'azurapagebuilder.page.23', 'Home Index 7', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('180', '173', '287', '288', '3', 'azurapagebuilder.page.29', 'Home Index 3', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('181', '173', '289', '290', '3', 'azurapagebuilder.page.24', 'Home Index 8', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('182', '173', '291', '292', '3', 'azurapagebuilder.page.25', 'Home Index 9', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('183', '173', '293', '294', '3', 'azurapagebuilder.page.26', 'Home Index 10', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('184', '173', '295', '296', '3', 'azurapagebuilder.page.27', 'Home Flex Slider', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('185', '173', '297', '298', '3', 'azurapagebuilder.page.28', 'Home Bootstrap Carousel', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('186', '54', '314', '323', '2', 'com_azurapagebuilder.category.11', 'Envor - Contact Pages', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('187', '54', '324', '357', '2', 'com_azurapagebuilder.category.12', 'Envor - Pages', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('188', '186', '315', '316', '3', 'azurapagebuilder.page.20', 'Contact - General', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('189', '186', '317', '318', '3', 'azurapagebuilder.page.22', 'Contact - Advanced', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('190', '186', '319', '320', '3', 'azurapagebuilder.page.21', 'Contact - Html5/Ajax', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('191', '187', '325', '326', '3', 'azurapagebuilder.page.6', 'About Company', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('192', '187', '327', '328', '3', 'azurapagebuilder.page.7', 'About Person', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('193', '187', '329', '330', '3', 'azurapagebuilder.page.8', 'Services', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('194', '187', '331', '332', '3', 'azurapagebuilder.page.9', 'Left Sidebar', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('195', '187', '333', '334', '3', 'azurapagebuilder.page.10', 'Right Sidebar', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('196', '187', '335', '336', '3', 'azurapagebuilder.page.11', 'Two Sidebars', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('197', '187', '337', '338', '3', 'azurapagebuilder.page.12', 'Full width', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('198', '187', '339', '340', '3', 'azurapagebuilder.page.13', 'Pricing Table', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('199', '187', '341', '342', '3', 'azurapagebuilder.page.14', 'Partner', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('200', '187', '343', '344', '3', 'azurapagebuilder.page.15', 'Career', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('201', '187', '345', '346', '3', 'azurapagebuilder.page.16', 'FAQ', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('202', '187', '347', '348', '3', 'azurapagebuilder.page.17', 'Elements', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('203', '187', '349', '350', '3', 'azurapagebuilder.page.18', 'Testimonials', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('204', '187', '351', '352', '3', 'azurapagebuilder.page.19', 'Typography', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('205', '1', '371', '372', '1', 'com_fields', 'com_fields', '{}'), ('206', '1', '373', '374', '1', 'com_associations', 'com_associations', '{}'), ('207', '187', '353', '354', '3', 'com_azurapagebuilder.page.12', 'Full width', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('208', '187', '355', '356', '3', 'com_azurapagebuilder.page.13', 'Pricing Table', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('209', '173', '299', '300', '3', 'com_azurapagebuilder.page.1', 'Home Index 1', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('210', '173', '301', '302', '3', 'com_azurapagebuilder.page.2', 'Home Index 2', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('211', '173', '303', '304', '3', 'com_azurapagebuilder.page.3', 'Home Index 4', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('212', '173', '305', '306', '3', 'com_azurapagebuilder.page.4', 'Home Index 5', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('213', '173', '307', '308', '3', 'com_azurapagebuilder.page.24', 'Home Index 8', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('214', '173', '309', '310', '3', 'com_azurapagebuilder.page.27', 'Home Flex Slider', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('215', '173', '311', '312', '3', 'com_azurapagebuilder.page.28', 'Home Bootstrap Carousel', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('216', '186', '321', '322', '3', 'com_azurapagebuilder.page.20', 'Contact - General', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'), ('217', '54', '358', '359', '2', 'com_azurapagebuilder.page.30', 'Test Item', '{}'), ('218', '1', '375', '376', '1', 'com_privacy', 'com_privacy', '{}'), ('219', '1', '377', '378', '1', 'com_actionlogs', 'com_actionlogs', '{}');
CREATE TABLE `#__associations` (   `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',   `context` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',   `key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',   PRIMARY KEY (`context`,`id`),   KEY `idx_key` (`key`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE `#__azurapagebuilder_likes` (   `pageID` int(11) NOT NULL,   `like_count` int(10) unsigned NOT NULL DEFAULT '0',   `likedUsers` mediumtext NOT NULL,   `likedIPs` mediumtext NOT NULL,   `option` varchar(50) NOT NULL ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__azurapagebuilder_pages` (   `id` int(11) unsigned NOT NULL AUTO_INCREMENT,   `asset_id` int(10) NOT NULL DEFAULT '0',   `title` text NOT NULL,   `alias` varchar(255) NOT NULL,   `catid` int(11) NOT NULL DEFAULT '0',   `shortcode` mediumtext NOT NULL,   `elementsArray` text NOT NULL,   `introtext` text NOT NULL,   `fulltext` text NOT NULL,   `pagecontent` mediumtext NOT NULL,   `state` tinyint(1) NOT NULL DEFAULT '1',   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(11) NOT NULL DEFAULT '0',   `created_by_alias` varchar(250) NOT NULL,   `checked_out` int(11) NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `hits` int(11) NOT NULL DEFAULT '0',   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(11) NOT NULL DEFAULT '0',   `access` int(10) NOT NULL DEFAULT '1',   `language` varchar(25) NOT NULL,   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) NOT NULL,   `params` text NOT NULL,   `alt_layout` varchar(250) NOT NULL,   `customCssLinks` text NOT NULL,   `customJsLinks` text NOT NULL,   `customJsButtonLinks` text NOT NULL,   `customJsBottomScript` text NOT NULL,   `jQueryLinkType` text NOT NULL,   `noConflict` text NOT NULL,   `metadata` text NOT NULL,   `metadesc` text NOT NULL,   `metakey` text NOT NULL,   `tags` text NOT NULL,   `version` int(10) NOT NULL,   PRIMARY KEY (`id`) ) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;
INSERT INTO `#__azurapagebuilder_pages`  VALUES ('1', '209', 'Home Index 1', 'home-index-1', '10', '[AzuraRow animationtype=\"bounce\" animationdelay=\"200ms\"][AzuraColumn columnwidthclass=\"col-md-6\" animationtype=\"fade-in-up\" animationdelay=\"200ms\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][feature_box]<p>Donec cursus ligula ante, non faucibus felis lobortis sed.</p>\r\n<p><a href=\"http://themeforest.net/user/cththemes/portfolio?ref=cththemes\" target=\"_blank\">Details <i class=\"fa fa-arrow-circle-right\"></i></a></p>[/feature_box][/AzuraColumn][AzuraColumn columnwidthclass=\"col-md-6\" animationtype=\"fade-in-up\" animationdelay=\"400ms\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][feature_box icon_fontawesome=\"fa fa-cog\" title=\"Exquisite\"]<p>Donec cursus ligula ante, non faucibus felis lobortis sed.</p>\r\n<p><a href=\"http://themeforest.net/user/cththemes/portfolio?ref=cththemes\" target=\"_blank\">Details <i class=\"fa fa-arrow-circle-right\"></i></a></p>[/feature_box][/AzuraColumn][AzuraColumn columnwidthclass=\"col-md-6\" animationtype=\"fade-in-up\" animationdelay=\"600ms\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][feature_box icon_fontawesome=\"fa fa-trophy\" title=\"Glorious\"]<p>Donec cursus ligula ante, non faucibus felis lobortis sed.</p>\r\n<p><a href=\"http://themeforest.net/user/cththemes/portfolio?ref=cththemes\" target=\"_blank\">Details <i class=\"fa fa-arrow-circle-right\"></i></a></p>[/feature_box][/AzuraColumn][AzuraColumn columnwidthclass=\"col-md-6\" animationtype=\"fade-in-up\" animationdelay=\"800ms\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][feature_box icon_fontawesome=\"fa fa-flask\" title=\"Stunning\"]<p>Donec cursus ligula ante, non faucibus felis lobortis sed.</p>\r\n<p><a href=\"http://themeforest.net/user/cththemes/portfolio?ref=cththemes\" target=\"_blank\">Details <i class=\"fa fa-arrow-circle-right\"></i></a></p>[/feature_box][/AzuraColumn][/AzuraRow][AzuraRow animationtype=\"bounce\" animationdelay=\"200ms\" background_color=\"#f2f2f2\" typo_textalign=\"center\" secclass=\"envor-section-st1 envor-section-align-center\"][AzuraColumn][raw_html]<h2>welcome to <strong>Envor</strong> - <span>JOOMLA</span> Multipurpose Template</h2>\r\n<p>Vestibulum nunc erat, venenatis tristique nisi sit amet, volutpat accumsan lorem. Sed quis tortor magna. Maecenas hendrerit feugiat pulvinar. Aenean condimentum quam eu ultricies cursus.  Nulla facilisi. In hac habitasse platea dictumst. Ut nec tellus neque. Sed non dui eget arcu elementum facilisis.</p>\r\n<p>\r\n  <a href=\"http://themeforest.net/user/cththemes/portfolio?ref=cththemes\" class=\"envor-btn envor-btn-primary envor-btn-normal\"><i class=\"glyphicon glyphicon-check\"></i> purchase now!</a>\r\n  <a href=\"http://themeforest.net/user/cththemes/portfolio?ref=cththemes\" class=\"envor-btn envor-btn-secondary envor-btn-normal\"><i class=\"glyphicon glyphicon-question-sign\"></i> discover more</a>\r\n</p>[/raw_html][/AzuraColumn][/AzuraRow][AzuraRow animationtype=\"bounce\" animationdelay=\"200ms\" secclass=\"envor-section-align-center\"][AzuraColumn][azp_textblock]<h2>latest <strong>projects</strong></h2><p class=\"block-description\">Nullam condimentum nibh at lorem feugiat, at pulvinar orci luctus.</p><p>Etiam in ante ac velit imperdiet vestibulum ac quis nisi. Morbi sed fringilla nisl, a lacinia justo. Mauris vitae pellentesque felis. Nam placerat turpis eu mauris dignissim, in fringilla odio lobortis. Suspendisse venenatis sit amet lorem faucibus eleifend.</p>[/azp_textblock][projects_slider category=\"2\"][/projects_slider][/AzuraColumn][/AzuraRow][AzuraRow background_image=\"images/background/bg1.jpg\" animationtype=\"bounce\" animationdelay=\"200ms\" secclass=\"envor-section-align-center envor-section-bg1\"][AzuraColumn][AzuraQuote animationtype=\"fade-in\" animationdelay=\"\"]<h2>clients <strong>testimonials</strong></h2>[AzuraTestimonial name=\"\" company=\"\"]<p><em>Quisque eget dictum turpis. Cras suscipit luctus facilisis. Etiam et elit eget dui sodales auctor vitae semper sapien. Ut iaculis erat non nunc feugiat laoreet. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</em></p>\r\n<p class=\"author\">- Ruth M. Patterson, <span>developer</span></p>[/AzuraTestimonial][AzuraTestimonial name=\"\" company=\"\"]<p><em>Pellentesque et condimentum ligula, ut eleifend neque. Phasellus ullamcorper nisl ut ligula semper dapibus.</em></p>\r\n<p class=\"author\">- Sarah T. Elliot, <span>developer</span></p>[/AzuraTestimonial][AzuraTestimonial name=\"\" company=\"\"]<p><em>Nam non dolor vulputate risus condimentum convallis quis non purus. Suspendisse tellus sapien, dignissim at tincidunt eu, tristique ac mauris. Aliquam sed lectus ut dolor vulputate sollicitudin. Sed leo erat, gravida eu massa a, placerat ultrices nulla. Sed cursus congue convallis.</em></p>\r\n<p class=\"author\">- Vicki N. Ennis, <span>developer</span></p>[/AzuraTestimonial][AzuraTestimonial name=\"\" company=\"\"]<p><em>Sed faucibus metus nibh, a condimentum lorem mattis sit amet. Ut feugiat a arcu at blandit. Cras elementum, lacus sed posuere dapibus, ipsum erat dapibus erat, dapibus malesuada neque enim eu turpis.</em></p>\r\n<p class=\"author\">- Michael K. Nguyen, <span>developer</span></p>[/AzuraTestimonial][AzuraTestimonial name=\"\" company=\"\"]<p><em>Mauris sit amet diam aliquet, iaculis nulla eget, vestibulum dolor. Aenean nec lacus porta, elementum augue vel, fringilla neque. Suspendisse eu odio mauris. Cras vehicula dolor sagittis lacus lobortis bibendum. Nunc nec purus non sapien rutrum euismod a ut ipsum. Maecenas egestas mi vitae nunc lacinia vulputate. Fusce iaculis ante diam, dignissim venenatis odio sollicitudin quis. Sed tristique elementum velit id condimentum.</em></p>\r\n<p class=\"author\">- Marvin M. Gilbert, <span>developer</span></p>[/AzuraTestimonial][/AzuraQuote][/AzuraColumn][/AzuraRow][AzuraRow animationtype=\"bounce\" animationdelay=\"200ms\" secclass=\"envor-section-align-center\"][AzuraColumn][raw_html]<h2>our <strong>partners</strong></h2>[/raw_html][our_partners][{\"src\":\"images/partners/1.png\",\"alt_text\":\"\",\"website\":\"\",\"content\":\"\"},{\"src\":\"images/partners/2.png\",\"alt_text\":\"\",\"website\":\"\",\"content\":\"\"},{\"src\":\"images/partners/3.png\",\"alt_text\":\"\",\"website\":\"\",\"content\":\"\"},{\"src\":\"images/partners/4.png\",\"alt_text\":\"\",\"website\":\"\",\"content\":\"\"},{\"src\":\"images/partners/5.png\",\"alt_text\":\"\",\"website\":\"\",\"content\":\"\"},{\"src\":\"images/partners/6.png\",\"alt_text\":\"\",\"website\":\"\",\"content\":\"\"},{\"src\":\"images/partners/7.png\",\"alt_text\":\"\",\"website\":\"\",\"content\":\"\"},{\"src\":\"images/partners/8.png\",\"alt_text\":\"\",\"website\":\"\",\"content\":\"\"}][/our_partners][/AzuraColumn][/AzuraRow][AzuraRow animationtype=\"bounce\" animationdelay=\"\" secclass=\"envor-section-st2 envor-section-cta2\"][AzuraColumn][raw_html]<p><span>Like <strong>Envor</strong> Template? Purchase in on ThemeForest!</span> <a href=\"http://themeforest.net/user/cththemes/portfolio?ref=cththemes\" class=\"envor-btn envor-btn-normal envor-btn-border-white\"><i class=\"glyphicon glyphicon-download\"></i> purchase and download</a></p>[/raw_html][/AzuraColumn][/AzuraRow]', '', '', '', '', '1', '2015-01-15 14:34:32', '1000', '', '0', '0000-00-00 00:00:00', '172', '2017-10-19 14:51:25', '1000', '1', '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', '{\"og_title\":\"\",\"og_description\":\"\",\"og_image\":\"\",\"tt_description\":\"\",\"tt_image\":\"\"}', '_:homepage', '', '', '', '', '', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '', '57'), ('2', '210', 'Home Index 2', 'home-index-2', '10', '[AzuraRow animationtype=\"rotateInDownRight\" animationdelay=\"200\" secclass=\"envor-section-st2\" animation=\"1\"][AzuraColumn columnwidthclass=\"col-md-6\" animationtype=\"fade-in-up\" animationdelay=\"200ms\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][feature_box]<p>Donec cursus ligula ante, non faucibus felis lobortis sed.</p>\r\n<p><a href=\"http://themeforest.net/user/cththemes/portfolio?ref=cththemes\" target=\"_blank\">Details <i class=\"fa fa-arrow-circle-right\"></i></a></p>[/feature_box][/AzuraColumn][AzuraColumn columnwidthclass=\"col-md-6\" animationtype=\"fade-in-up\" animationdelay=\"400ms\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][feature_box icon_fontawesome=\"fa fa-cog\" title=\"Exquisite\"]<p>Donec cursus ligula ante, non faucibus felis lobortis sed.</p>\r\n<p><a href=\"http://themeforest.net/user/cththemes/portfolio?ref=cththemes\" target=\"_blank\">Details <i class=\"fa fa-arrow-circle-right\"></i></a></p>[/feature_box][/AzuraColumn][AzuraColumn columnwidthclass=\"col-md-6\" animationtype=\"fade-in-up\" animationdelay=\"600ms\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][feature_box icon_fontawesome=\"fa fa-trophy\" title=\"Glorious\"]<p>Donec cursus ligula ante, non faucibus felis lobortis sed.</p>\r\n<p><a href=\"http://themeforest.net/user/cththemes/portfolio?ref=cththemes\" target=\"_blank\">Details <i class=\"fa fa-arrow-circle-right\"></i></a></p>[/feature_box][/AzuraColumn][AzuraColumn columnwidthclass=\"col-md-6\" animationtype=\"fade-in-up\" animationdelay=\"800ms\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][feature_box icon_fontawesome=\"fa fa-flask\" title=\"Stunning\"]<p>Donec cursus ligula ante, non faucibus felis lobortis sed.</p>\r\n<p><a href=\"http://themeforest.net/user/cththemes/portfolio?ref=cththemes\" target=\"_blank\">Details <i class=\"fa fa-arrow-circle-right\"></i></a></p>[/feature_box][/AzuraColumn][/AzuraRow][AzuraRow secclass=\"envor-animation envor-section envor-section-core envor-section-bg2 envor-section-align-center\" background_image=\"images/background/core-features-bg.jpg\" animationtype=\"fade-in\" animationdelay=\"\"]<h2>envor <strong>core</strong> features</h2>[AzuraColumn animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-6\" mdwidthclass=\"col-md-6\"][AzuraImage src=\"images/pages/showcase.png\" animationtype=\"fade-in\" animationdelay=\"\"][/AzuraImage][/AzuraColumn][AzuraColumn animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-6\" mdwidthclass=\"col-md-6\"][raw_html]<p>Sed a eros semper, blandit lectus at, vulputate dui. Mauris ut gravida felis. Aliquam sit amet ultrices elit, eget pulvinar quam. Aliquam urna sapien, luctus sit amet volutpat eget, faucibus nec arcu. Phasellus a consectetur ante, ac mollis nunc. Aenean nisi justo, blandit sagittis dapibus sit amet, posuere ut urna.</p>\r\n<ul>\r\n  <li><i class=\"fa fa-glass\"></i> Praesent feugiat hendrerit</li>\r\n  <li><i class=\"fa fa-power-off\"></i> Sed nisi nibh, commodo</li>\r\n  <li><i class=\"fa fa-star\"></i> Suspendisse at eros sed</li>\r\n  <li><i class=\"fa fa-flag\"></i> Vestibulum lobortis congue</li>\r\n  <li><i class=\"fa fa-tags\"></i> Nulla a semper sem</li>\r\n  <li><i class=\"fa fa-refresh\"></i> Phasellus ut mauris ac nunc</li>\r\n  <li><i class=\"fa fa-book\"></i> In nec neque in augue luctus</li>\r\n  <li><i class=\"fa fa-road\"></i> Mauris lacinia nulla ut dictum</li>\r\n</ul>\r\n<p><a href=\"\" class=\"envor-btn envor-btn-primary envor-btn-normal\">learn more!</a></p>\r\n[/raw_html][/AzuraColumn][/AzuraRow][AzuraRow animationtype=\"bounce\" animationdelay=\"200ms\" secclass=\"envor-section-align-center envor-section\"][AzuraColumn][azp_textblock]<h2>latest <strong>projects</strong></h2><p class=\"block-description\">Nullam condimentum nibh at lorem feugiat, at pulvinar orci luctus.</p><p>Etiam in ante ac velit imperdiet vestibulum ac quis nisi. Morbi sed fringilla nisl, a lacinia justo. Mauris vitae pellentesque felis. Nam placerat turpis eu mauris dignissim, in fringilla odio lobortis. Suspendisse venenatis sit amet lorem faucibus eleifend.</p>[/azp_textblock][projects_slider category=\"2\" showmore=\"1\"][/projects_slider][/AzuraColumn][/AzuraRow][AzuraRow secclass=\"envor-animation envor-section envor-section-st1 envor-section-align-center\" animationtype=\"fade-in\" animationdelay=\"200ms\"][AzuraColumn][raw_html]<h2>welcome to <strong>Envor</strong> - <span>JOOMLA</span> Multipurpose Template</h2>\r\n<p>Vestibulum nunc erat, venenatis tristique nisi sit amet, volutpat accumsan lorem. Sed quis tortor magna. Maecenas hendrerit feugiat pulvinar. Aenean condimentum quam eu ultricies cursus.  Nulla facilisi. In hac habitasse platea dictumst. Ut nec tellus neque. Sed non dui eget arcu elementum facilisis.</p>\r\n<p>\r\n  <a href=\"http://themeforest.net/user/cththemes/portfolio?ref=cththemes\" class=\"envor-btn envor-btn-primary envor-btn-normal\"><i class=\"glyphicon glyphicon-check\"></i> purchase now!</a>\r\n  <a href=\"http://themeforest.net/user/cththemes/portfolio?ref=cththemes\" class=\"envor-btn envor-btn-secondary envor-btn-normal\"><i class=\"glyphicon glyphicon-question-sign\"></i> discover more</a>\r\n</p>[/raw_html][/AzuraColumn][/AzuraRow][AzuraRow secclass=\"envor-animation envor-section envor-section-align-left\" animationtype=\"fade-in\" animationdelay=\"\"][AzuraColumn animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-6\" mdwidthclass=\"col-md-6\"][AzuraK2CatView category=\"1\" id=\"latest-news\" visible=\"2\" navigationpos=\"left\" layout=\"envor:azurak2catview-latestnews\" animationtype=\"bounce\" animationdelay=\"\"][/AzuraK2CatView][/AzuraColumn][AzuraColumn animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-6\" mdwidthclass=\"col-md-6\"][AzuraQuote animationtype=\"fade-in\" animationdelay=\"\" paginationpos=\"left\"]<h2>clients <strong>testimonials</strong></h2>[AzuraTestimonial name=\"\" company=\"\"]<p><em>Quisque eget dictum turpis. Cras suscipit luctus facilisis. Etiam et elit eget dui sodales auctor vitae semper sapien. Ut iaculis erat non nunc feugiat laoreet. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</em></p>\r\n<p class=\"author\">- Ruth M. Patterson, <span>developer</span></p>[/AzuraTestimonial][AzuraTestimonial name=\"\" company=\"\"]<p><em>Pellentesque et condimentum ligula, ut eleifend neque. Phasellus ullamcorper nisl ut ligula semper dapibus.</em></p>\r\n<p class=\"author\">- Sarah T. Elliot, <span>developer</span></p>[/AzuraTestimonial][AzuraTestimonial name=\"\" company=\"\"]<p><em>Nam non dolor vulputate risus condimentum convallis quis non purus. Suspendisse tellus sapien, dignissim at tincidunt eu, tristique ac mauris. Aliquam sed lectus ut dolor vulputate sollicitudin. Sed leo erat, gravida eu massa a, placerat ultrices nulla. Sed cursus congue convallis.</em></p>\r\n<p class=\"author\">- Vicki N. Ennis, <span>developer</span></p>[/AzuraTestimonial][AzuraTestimonial name=\"\" company=\"\"]<p><em>Sed faucibus metus nibh, a condimentum lorem mattis sit amet. Ut feugiat a arcu at blandit. Cras elementum, lacus sed posuere dapibus, ipsum erat dapibus erat, dapibus malesuada neque enim eu turpis.</em></p>\r\n<p class=\"author\">- Michael K. Nguyen, <span>developer</span></p>[/AzuraTestimonial][/AzuraQuote][/AzuraColumn][/AzuraRow][AzuraRow secclass=\"envor-animation envor-section envor-section-twitter-1 envor-section-align-center envor-section-st2\" animationtype=\"fade-in\" animationdelay=\"\"][AzuraColumn][AzuraTweets twittername=\"Cththemes\" layout=\"slider\" animationtype=\"bounce\" animationdelay=\"\"][/AzuraTweets][/AzuraColumn][/AzuraRow]', '', '', '', '', '1', '2015-01-16 10:58:39', '1000', '', '0', '0000-00-00 00:00:00', '28', '2017-10-19 15:57:08', '1000', '1', '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2', '{\"og_title\":\"\",\"og_description\":\"\",\"og_image\":\"\",\"tt_description\":\"\",\"tt_image\":\"\"}', '_:homepage', '', '', '', '', '', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '', '27'), ('3', '211', 'Home Index 4', 'home-index-4', '10', '[AzuraRow secclass=\"envor-section envor-section-st3\" animationtype=\"fade-in\" animationdelay=\"\"][AzuraColumn columnwidthclass=\"col-md-6\"][AzuraModule moduleid=\"158\" chromestyle=\"0\" showtitle=\"0\"][/AzuraModule][/AzuraColumn][AzuraColumn columnwidthclass=\"col-md-6\"][AzuraText]<div class=\"envor-domain-price\">\r\n  <p>.com</p>\r\n  <small>$4.99/year</small>\r\n</div>\r\n<!--\r\n\r\nDomain Price Item\r\n\r\n//-->\r\n<div class=\"envor-domain-price\">\r\n  <p>.org</p>\r\n  <small>$3.99/year</small>\r\n</div>\r\n<!--\r\n\r\nDomain Price Item\r\n\r\n//-->\r\n<div class=\"envor-domain-price\">\r\n  <p>.co</p>\r\n  <small>$4.45/year</small>\r\n</div>\r\n<!--\r\n\r\nDomain Price Item\r\n\r\n//-->\r\n<div class=\"envor-domain-price\">\r\n  <p>.net</p>\r\n  <small>$2.99/year</small>\r\n</div>[/AzuraText][/AzuraColumn][/AzuraRow][AzuraRow secclass=\"envor-section envor-section-bg3\" background_image=\"images/background/hosting-features-bg.jpg\" animationtype=\"fade-in\" animationdelay=\"200ms\"][AzuraColumn columnwidthclass=\"col-md-6\" animationdelay=\"200ms\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][AzuraText]<article class=\"envor-feature-2 envor-feature-2-color\">\r\n  <header>\r\n    <i class=\"fa fa-globe\"></i><span class=\"arrow\"></span>\r\n    lovely\r\n  </header>\r\n  <p>Donec cursus ligula ante, non faucibus felis lobortis sed.</p>\r\n  <p><a href=\"\" class=\"envor-btn envor-btn-primary envor-btn-small\">Details <i class=\"fa fa-arrow-circle-right\"></i></a></p>\r\n</article>[/AzuraText][/AzuraColumn][AzuraColumn columnwidthclass=\"col-md-6\" animationdelay=\"200ms\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][AzuraText]<article class=\"envor-feature-2 envor-feature-2-color\">\r\n  <header>\r\n    <i class=\"fa fa-cog\"></i><span class=\"arrow\"></span>\r\n    exquisite\r\n  </header>\r\n  <p>Vivamus sollicitudin nisi rhoncus bibendum suscipit.</p>\r\n  <p><a href=\"\" class=\"envor-btn envor-btn-primary envor-btn-small\">Details <i class=\"fa fa-arrow-circle-right\"></i></a></p>\r\n</article>[/AzuraText][/AzuraColumn][AzuraColumn columnwidthclass=\"col-md-6\" animationdelay=\"200ms\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][AzuraText]<article class=\"envor-feature-2 envor-feature-2-color\">\r\n  <header>\r\n    <i class=\"fa fa-trophy\"></i><span class=\"arrow\"></span>\r\n    glorious\r\n  </header>\r\n  <p>Pellentesque lacinia, lectus ac varius adipiscing.</p>\r\n  <p><a href=\"\" class=\"envor-btn envor-btn-primary envor-btn-small\">Details <i class=\"fa fa-arrow-circle-right\"></i></a></p>\r\n</article>[/AzuraText][/AzuraColumn][AzuraColumn columnwidthclass=\"col-md-6\" animationdelay=\"200ms\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][AzuraText]<article class=\"envor-feature-2 envor-feature-2-color\">\r\n  <header>\r\n    <i class=\"fa fa-flask\"></i><span class=\"arrow\"></span>\r\n    stunning\r\n  </header>\r\n  <p>Fusce mattis sem sed lectus rhoncus nisl nisl tincidunt libero.</p>\r\n  <p><a href=\"\" class=\"envor-btn envor-btn-primary envor-btn-small\">Details <i class=\"fa fa-arrow-circle-right\"></i></a></p>\r\n</article>[/AzuraText][/AzuraColumn][/AzuraRow][AzuraRow secclass=\"envor-section envor-section-align-center\" animationtype=\"fade-in\" animationdelay=\"\"]<h2>pricing <strong>plans</strong></h2>[AzuraColumn animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][AzuraText]<div class=\"envor-pricing-1\">\r\n  <header>\r\n    <div class=\"plan-title\">\r\n      <p>basic</p>\r\n      <small>For Individuals</small>\r\n    </div>\r\n    <div class=\"plan-price\">\r\n      <p>$4.99</p>\r\n      <small>p/mo</small>\r\n    </div>\r\n  </header>\r\n  <p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n  <ul>\r\n    <li>250 Mb Disc Space</li>\r\n    <li>5 Gb Data Transfer</li>\r\n    <li>1 Domain Name</li>\r\n    <li>2 FTP Accounts</li>\r\n    <li>2 MySQL Databases</li>\r\n    <li>Unlimited Emails</li>\r\n    <li>24/7 Support</li>\r\n  </ul>\r\n{j2storecart 17}\r\n</div>[/AzuraText][/AzuraColumn][AzuraColumn animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][AzuraText]<div class=\"envor-pricing-1\">\r\n  <header>\r\n    <div class=\"plan-title\">\r\n      <p>plus</p>\r\n      <small>For small business</small>\r\n    </div>\r\n    <div class=\"plan-price\">\r\n      <p>$7.99</p>\r\n      <small>p/mo</small>\r\n    </div>\r\n  </header>\r\n  <p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n  <ul>\r\n    <li>250 Mb Disc Space</li>\r\n    <li>5 Gb Data Transfer</li>\r\n    <li>1 Domain Name</li>\r\n    <li>2 FTP Accounts</li>\r\n    <li>2 MySQL Databases</li>\r\n    <li>Unlimited Emails</li>\r\n    <li>24/7 Support</li>\r\n  </ul>\r\n{j2storecart 18}\r\n</div>[/AzuraText][/AzuraColumn][AzuraColumn animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][AzuraText]<div class=\"envor-pricing-1\">\r\n  <header>\r\n    <div class=\"plan-title\">\r\n      <p>pro</p>\r\n      <small>For big business</small>\r\n    </div>\r\n    <div class=\"plan-price\">\r\n      <p>$9.99</p>\r\n      <small>p/mo</small>\r\n    </div>\r\n  </header>\r\n  <p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n  <ul>\r\n    <li>250 Mb Disc Space</li>\r\n    <li>5 Gb Data Transfer</li>\r\n    <li>1 Domain Name</li>\r\n    <li>2 FTP Accounts</li>\r\n    <li>2 MySQL Databases</li>\r\n    <li>Unlimited Emails</li>\r\n    <li>24/7 Support</li>\r\n  </ul>\r\n{j2storecart 19}\r\n</div>[/AzuraText][/AzuraColumn][AzuraColumn animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][AzuraText]<div class=\"envor-pricing-1\">\r\n  <header>\r\n    <div class=\"plan-title\">\r\n      <p>extra</p>\r\n      <small>corporate offer</small>\r\n    </div>\r\n    <div class=\"plan-price\">\r\n      <p>$12.99</p>\r\n      <small>p/mo</small>\r\n    </div>\r\n  </header>\r\n  <p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n  <ul>\r\n    <li>250 Mb Disc Space</li>\r\n    <li>5 Gb Data Transfer</li>\r\n    <li>1 Domain Name</li>\r\n    <li>2 FTP Accounts</li>\r\n    <li>2 MySQL Databases</li>\r\n    <li>Unlimited Emails</li>\r\n    <li>24/7 Support</li>\r\n  </ul>\r\n{j2storecart 20}\r\n</div>[/AzuraText][/AzuraColumn][/AzuraRow][AzuraRow secclass=\"envor-section envor-section-align-center\" animationtype=\"fade-in\" animationdelay=\"\"][AzuraColumn][AzuraOurClients animationtype=\"fade-in\" animationdelay=\"\"]<h2>our <strong>partners</strong></h2>[AzuraOurClientsItem logo=\"images/partners/1.png\"][/AzuraOurClientsItem][AzuraOurClientsItem logo=\"images/partners/2.png\"][/AzuraOurClientsItem][AzuraOurClientsItem logo=\"images/partners/3.png\"][/AzuraOurClientsItem][AzuraOurClientsItem logo=\"images/partners/4.png\"][/AzuraOurClientsItem][AzuraOurClientsItem logo=\"images/partners/5.png\"][/AzuraOurClientsItem][AzuraOurClientsItem logo=\"images/partners/6.png\"][/AzuraOurClientsItem][AzuraOurClientsItem logo=\"images/partners/7.png\"][/AzuraOurClientsItem][AzuraOurClientsItem logo=\"images/partners/8.png\"][/AzuraOurClientsItem][/AzuraOurClients][/AzuraColumn][/AzuraRow][AzuraRow secclass=\"envor-section envor-section-align-left\" animationtype=\"fade-in\" animationdelay=\"\"][AzuraColumn animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-6\" mdwidthclass=\"col-md-6\"][AzuraK2CatView category=\"1\" id=\"latest-news\" selector=\"envor-post-preview\" visible=\"2\" navigationpos=\"left\" layout=\"envor:azurak2catview-latestnews\" animationtype=\"bounce\" animationdelay=\"\"][/AzuraK2CatView][/AzuraColumn][AzuraColumn animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-6\" mdwidthclass=\"col-md-6\"][AzuraQuote animationtype=\"fade-in\" animationdelay=\"\" selector=\"envor-testimonials-2\" paginationpos=\"left\"]<h2>clients <strong>testimonials</strong></h2>[AzuraTestimonial name=\"\" company=\"\"]<p><em>Quisque eget dictum turpis. Cras suscipit luctus facilisis. Etiam et elit eget dui sodales auctor vitae semper sapien. Ut iaculis erat non nunc feugiat laoreet. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</em></p>\r\n<p class=\"author\">- Ruth M. Patterson, <span>developer</span></p>[/AzuraTestimonial][AzuraTestimonial name=\"\" company=\"\"]<p><em>Pellentesque et condimentum ligula, ut eleifend neque. Phasellus ullamcorper nisl ut ligula semper dapibus.</em></p>\r\n<p class=\"author\">- Sarah T. Elliot, <span>developer</span></p>[/AzuraTestimonial][AzuraTestimonial name=\"\" company=\"\"]<p><em>Nam non dolor vulputate risus condimentum convallis quis non purus. Suspendisse tellus sapien, dignissim at tincidunt eu, tristique ac mauris. Aliquam sed lectus ut dolor vulputate sollicitudin. Sed leo erat, gravida eu massa a, placerat ultrices nulla. Sed cursus congue convallis.</em></p>\r\n<p class=\"author\">- Vicki N. Ennis, <span>developer</span></p>[/AzuraTestimonial][AzuraTestimonial name=\"\" company=\"\"]<p><em>Sed faucibus metus nibh, a condimentum lorem mattis sit amet. Ut feugiat a arcu at blandit. Cras elementum, lacus sed posuere dapibus, ipsum erat dapibus erat, dapibus malesuada neque enim eu turpis.</em></p>\r\n<p class=\"author\">- Michael K. Nguyen, <span>developer</span></p>[/AzuraTestimonial][/AzuraQuote][/AzuraColumn][/AzuraRow][AzuraRow secclass=\"envor-section envor-section-st2 envor-section-cta2\" animationtype=\"fade-in\" animationdelay=\"\"][AzuraColumn][AzuraText]<p><span>Like <strong>Envor</strong> Template? Purchase in on ThemeForest!</span> <a href=\"http://themeforest.net/user/cththemes/portfolio?ref=cththemes\" class=\"envor-btn envor-btn-normal envor-btn-border-white\"><i class=\"glyphicon glyphicon-download\"></i> purchase and download</a></p>[/AzuraText][/AzuraColumn][/AzuraRow]', '', '', '', '', '1', '2015-01-16 14:01:07', '1000', '', '0', '0000-00-00 00:00:00', '7', '2017-10-18 09:57:15', '1000', '1', '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '3', '{\"og_title\":\"\",\"og_description\":\"\",\"og_image\":\"\",\"tt_description\":\"\",\"tt_image\":\"\"}', '_:homepage', '', '', '', '', '', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '', '18'), ('4', '212', 'Home Index 5', 'home-index-5', '10', '[AzuraRow secclass=\"envor-section envor-section-st3\" animationtype=\"fade-in\" animationdelay=\"\"][AzuraColumn columnwidthclass=\"col-md-4\" animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][AzuraText]<div class=\"envor-feature-store envor-feature-store-white\">\r\n  <span><i class=\"fa fa-truck\"></i></span>\r\n  <p><strong>free overnight</strong> shipping over %50</p>\r\n</div>[/AzuraText][/AzuraColumn][AzuraColumn columnwidthclass=\"col-md-4\" animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][AzuraText]<div class=\"envor-feature-store envor-feature-store-white\">\r\n  <span><i class=\"fa fa-undo\"></i></span>\r\n  <p><strong>free returns</strong> for 100 days</p>\r\n</div>[/AzuraText][/AzuraColumn][AzuraColumn columnwidthclass=\"col-md-4\" animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][AzuraText]<div class=\"envor-feature-store envor-feature-store-white\">\r\n  <span><i class=\"fa fa-clock-o\"></i></span>\r\n  <p><strong>3HR delivery</strong> in SYD & MEL</p>\r\n</div>[/AzuraText][/AzuraColumn][AzuraColumn columnwidthclass=\"col-md-4\" animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][AzuraModule moduleid=\"159\" chromestyle=\"0\" showtitle=\"0\"][/AzuraModule][/AzuraColumn][/AzuraRow][AzuraRow secclass=\"envor-section envor-section-align-center\" animationtype=\"fade-in\" animationdelay=\"\"][AzuraColumn][AzuraText]<h2>our <strong>bestsellers</strong></h2>\r\n<p class=\"block-description\">Quisque in urna a mi feugiat molestie quis elementum mauris.</p>\r\n<p>Sed lobortis facilisis posuere. Phasellus pharetra vel velit vitae luctus. Nulla eget enim sit amet augue imperdiet posuere. Aenean diam ligula, gravida eu imperdiet ullamcorper, tincidunt nec turpis.</p>[/AzuraText][AzuraModule moduleid=\"160\" chromestyle=\"0\" showtitle=\"0\"][/AzuraModule][/AzuraColumn][/AzuraRow][AzuraRow secclass=\"envor-section envor-section-align-center\" animationtype=\"fade-in\" animationdelay=\"\"][AzuraColumn][AzuraOurClients animationtype=\"fade-in\" animationdelay=\"\"]<h2>our <strong>partners</strong></h2>[AzuraOurClientsItem logo=\"images/partners/1.png\"][/AzuraOurClientsItem][AzuraOurClientsItem logo=\"images/partners/2.png\"][/AzuraOurClientsItem][AzuraOurClientsItem logo=\"images/partners/3.png\"][/AzuraOurClientsItem][AzuraOurClientsItem logo=\"images/partners/4.png\"][/AzuraOurClientsItem][AzuraOurClientsItem logo=\"images/partners/5.png\"][/AzuraOurClientsItem][AzuraOurClientsItem logo=\"images/partners/6.png\"][/AzuraOurClientsItem][AzuraOurClientsItem logo=\"images/partners/7.png\"][/AzuraOurClientsItem][AzuraOurClientsItem logo=\"images/partners/8.png\"][/AzuraOurClientsItem][/AzuraOurClients][/AzuraColumn][/AzuraRow][AzuraRow secclass=\"envor-section envor-section-align-left\" animationtype=\"fade-in\" animationdelay=\"\"][AzuraColumn animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-6\" mdwidthclass=\"col-md-6\"][AzuraK2CatView category=\"1\" id=\"latest-news\" selector=\"envor-post-preview\" visible=\"2\" navigationpos=\"left\" layout=\"envor:azurak2catview-latestnews\" animationtype=\"bounce\" animationdelay=\"\"][/AzuraK2CatView][/AzuraColumn][AzuraColumn animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-6\" mdwidthclass=\"col-md-6\"][AzuraQuote animationtype=\"fade-in\" animationdelay=\"\" selector=\"envor-testimonials-2\" paginationpos=\"left\"]<h2>clients <strong>testimonials</strong></h2>[AzuraTestimonial name=\"\" company=\"\"]<p><em>Quisque eget dictum turpis. Cras suscipit luctus facilisis. Etiam et elit eget dui sodales auctor vitae semper sapien. Ut iaculis erat non nunc feugiat laoreet. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</em></p>\r\n<p class=\"author\">- Ruth M. Patterson, <span>developer</span></p>[/AzuraTestimonial][AzuraTestimonial name=\"\" company=\"\"]<p><em>Pellentesque et condimentum ligula, ut eleifend neque. Phasellus ullamcorper nisl ut ligula semper dapibus.</em></p>\r\n<p class=\"author\">- Sarah T. Elliot, <span>developer</span></p>[/AzuraTestimonial][AzuraTestimonial name=\"\" company=\"\"]<p><em>Nam non dolor vulputate risus condimentum convallis quis non purus. Suspendisse tellus sapien, dignissim at tincidunt eu, tristique ac mauris. Aliquam sed lectus ut dolor vulputate sollicitudin. Sed leo erat, gravida eu massa a, placerat ultrices nulla. Sed cursus congue convallis.</em></p>\r\n<p class=\"author\">- Vicki N. Ennis, <span>developer</span></p>[/AzuraTestimonial][AzuraTestimonial name=\"\" company=\"\"]<p><em>Sed faucibus metus nibh, a condimentum lorem mattis sit amet. Ut feugiat a arcu at blandit. Cras elementum, lacus sed posuere dapibus, ipsum erat dapibus erat, dapibus malesuada neque enim eu turpis.</em></p>\r\n<p class=\"author\">- Michael K. Nguyen, <span>developer</span></p>[/AzuraTestimonial][/AzuraQuote][/AzuraColumn][/AzuraRow][AzuraRow secclass=\"envor-section envor-section-twitter-1 envor-section-color envor-section-align-center envor-section-bg4\" animationtype=\"fade-in\" animationdelay=\"\"][AzuraColumn][AzuraTweets twittername=\"Cththemes\" layout=\"envor:azuratweets-envor1\" animationtype=\"fade-in\" animationdelay=\"\"][/AzuraTweets][/AzuraColumn][/AzuraRow]', '', '', '', '', '1', '2015-01-16 14:24:51', '1000', '', '0', '0000-00-00 00:00:00', '8', '2017-10-18 09:56:50', '1000', '1', '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '4', '{\"og_title\":\"\",\"og_description\":\"\",\"og_image\":\"\",\"tt_description\":\"\",\"tt_image\":\"\"}', '_:homepage', '', '', '', '', '', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '', '9'), ('5', '178', 'Home Index 6', 'home-index-6', '10', '', '', '', '', '%5B%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Feature%203%20Section%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-6%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-3%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Carticle%20class%3D%5C%22envor-feature-3%5C%22%3E%5Cn%20%20%3Cspan%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-link%5C%22%3E%3C%2Fi%3E%3C%2Fspan%3E%5Cn%20%20%3Ch3%3EDonec%20eu%20quam%3C%2Fh3%3E%5Cn%20%20%3Cp%3EAenean%20vulputate%20dictum%20sapien%20et%20sollicitudin.%3C%2Fp%3E%5Cn%20%20%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-small%5C%22%3Edetails%3C%2Fa%3E%3C%2Fp%3E%5Cn%3C%2Farticle%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Donec%20eu%20quam%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-6%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-3%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Carticle%20class%3D%5C%22envor-feature-3%5C%22%3E%5Cn%20%20%3Cspan%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-thumbs-up%5C%22%3E%3C%2Fi%3E%3C%2Fspan%3E%5Cn%20%20%3Ch3%3ECurabitur%20ornare%3C%2Fh3%3E%5Cn%20%20%3Cp%3ECurabitur%20nunc%20elit%2C%20eleifend%20in%20eros%20id%2C%20venenatis%20congue%20odio.%3C%2Fp%3E%5Cn%20%20%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-small%5C%22%3Edetails%3C%2Fa%3E%3C%2Fp%3E%5Cn%3C%2Farticle%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Curabitur%20ornare%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-6%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-3%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Carticle%20class%3D%5C%22envor-feature-3%5C%22%3E%5Cn%20%20%3Cspan%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-earphone%5C%22%3E%3C%2Fi%3E%3C%2Fspan%3E%5Cn%20%20%3Ch3%3ENulla%20dictum%3C%2Fh3%3E%5Cn%20%20%3Cp%3EPraesent%20vitae%20volutpat%20arcu%2C%20in%20eleifend%20purus.%3C%2Fp%3E%5Cn%20%20%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-small%5C%22%3Edetails%3C%2Fa%3E%3C%2Fp%3E%5Cn%3C%2Farticle%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Nulla%20dictum%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-6%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-3%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Carticle%20class%3D%5C%22envor-feature-3%5C%22%3E%5Cn%20%20%3Cspan%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-font%5C%22%3E%3C%2Fi%3E%3C%2Fspan%3E%5Cn%20%20%3Ch3%3Eante%20non%20tempor%3C%2Fh3%3E%5Cn%20%20%3Cp%3EVivamus%20convallis%20dictum%20sem%20in%20tristique.%3C%2Fp%3E%5Cn%20%20%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-small%5C%22%3Edetails%3C%2Fa%3E%3C%2Fp%3E%5Cn%3C%2Farticle%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22ante%20non%20tempor%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%20envor-padding-top-0%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Call%20to%20Action%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%7D%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cdiv%20class%3D%5C%22envor-call-to-action-3%5C%22%3E%5Cn%20%20%20%20%3Cdiv%20class%3D%5C%22row%5C%22%3E%5Cn%20%20%20%20%20%20%20%20%3Cdiv%20class%3D%5C%22col-lg-10%5C%22%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%3Ch3%3Ewelcome%20to%20%3Cstrong%3Eenvor%3C%2Fstrong%3E%20JOOMLA%20template%3C%2Fh3%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%3Cp%3EPhasellus%20imperdiet%20arcu%20id%20auctor%20vehicula.%20Vestibulum%20euismod%20commodo%20fermentum.%20Proin%20pretium%20nisl%20ut%20risus%20ullamcorper.%3C%2Fp%3E%5Cn%20%20%20%20%20%20%20%20%3C%2Fdiv%3E%5Cn%20%20%20%20%20%20%20%20%3Cdiv%20class%3D%5C%22col-lg-2%5C%22%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%3Ca%20href%3D%5C%22http%3A%2F%2Fthemeforest.net%2Fuser%2Fcththemes%2Fportfolio%3Fref%3Dcththemes%5C%22%20class%3D%5C%22envor-btn%20envor-btn-secondary%20envor-btn-normal%5C%22%3Epurchase!%3C%2Fa%3E%5Cn%20%20%20%20%20%20%20%20%3C%2Fdiv%3E%5Cn%20%20%20%20%3C%2Fdiv%3E%5Cn%3C%2Fdiv%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Content%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%20envor-section-align-left%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Latest%20News%20%2B%20Testimonials%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-9%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Latest%20News%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%20%3Ch2%3Elatest%20from%20the%20%3Cstrong%3Eblog%3C%2Fstrong%3E%3C%2Fh2%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Title%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraK2CatView%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22category%22%3A%221%22%2C%22limit%22%3A%22All%22%2C%22order%22%3A%22created%22%2C%22orderdir%22%3A%22DESC%22%2C%22showmore%22%3A%220%22%2C%22id%22%3A%22latest-news%22%2C%22selector%22%3A%22envor-post-preview%22%2C%22visible%22%3A%223%22%2C%22shownavigation%22%3A%221%22%2C%22navigationpos%22%3A%22left%22%2C%22extraclass%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurak2catview-latestnews-2%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Latest%20News%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Testimonials%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraQuote%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%3Ewhat%20clients%20%3Cstrong%3Esay%3C%2Fstrong%3E%3C%2Fh2%3E%22%2C%22attrs%22%3A%7B%22extraclass%22%3A%22%22%2C%22sliderid%22%3A%22clients-testimonials%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22selector%22%3A%22envor-testimonials-3%22%2C%22shownavigation%22%3A%221%22%2C%22showpagination%22%3A%221%22%2C%22visible%22%3A%221%22%2C%22mobilevisible%22%3A%221%22%2C%22paginationpos%22%3A%22left%22%2C%22layout%22%3A%22envor%3Aazuraquote-style3%22%7D%2C%22name%22%3A%22Client%20Testimonials%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraTestimonial%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22Morbi%20sem%20erat%2C%20scelerisque%20sed%20est%20et%2C%20scelerisque%20rhoncus%20purus.%20Aenean%20varius%2C%20est%20vitae%20aliquet%20faucibus%2C%20nibh%20enim%20vehicula%20enim%2C%20sed%20tincidunt%20velit%20turpis%20sed%20ligula.%22%2C%22attrs%22%3A%7B%22name%22%3A%22Connie%20C.%20Sirois%22%2C%22company%22%3A%22developer%22%2C%22email%22%3A%22%22%2C%22photo%22%3A%22images%2Fusers%2F2.jpg%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Comment%201%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTestimonial%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22Praesent%20euismod%20sapien%20vulputate%2C%20pulvinar%20lectus%20eu%2C%20interdum%20metus.%20Donec%20orci%20erat%2C%20scelerisque%20vitae%20tincidunt%20in%2C%20tincidunt%20sit%20amet%20nibh.%20Ut%20nibh%20ligula%2C%20dignissim%20in%20lobortis%20eget%2C%20rutrum%20vitae%20erat.%20Nullam%20eu%20felis%20euismod%20nibh%20mollis%20malesuada%20vel%20nec%20tortor.%22%2C%22attrs%22%3A%7B%22name%22%3A%22Robin%20J.%20Reeves%22%2C%22company%22%3A%22developer%22%2C%22email%22%3A%22contact.cththemes%40gmail.com%22%2C%22photo%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Comment%202%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTestimonial%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22Integer%20varius%20tristique%20massa%20et%20lacinia.%20Maecenas%20sit%20amet%20feugiat%20sapien%2C%20quis%20auctor%20sem%20varius%20congue.%22%2C%22attrs%22%3A%7B%22name%22%3A%22James%20A.%20Kittle%22%2C%22company%22%3A%22developer%22%2C%22email%22%3A%22%22%2C%22photo%22%3A%22images%2Fusers%2F1.jpg%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Comment%203%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTestimonial%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22Sed%20vel%20libero%20eget%20erat%20commodo%20porta%20sed%20facilisis%20mauris.%20Cum%20sociis%20natoque%20penatibus%20et%20magnis%20dis%20parturient%20montes%2C%20nascetur%20ridiculus%20mus.%20Morbi%20fringilla%20condimentum%20sapien.%20Nullam%20porta%2C%20elit%20vel%20porttitor%20elementum%2C%20mauris%20risus%20interdum%20arcu%2C%20nec%20blandit%20lacus%20tortor%20quis%20tortor.%22%2C%22attrs%22%3A%7B%22name%22%3A%22Richard%20S.%20Berry%22%2C%22company%22%3A%22developer%22%2C%22email%22%3A%22%22%2C%22photo%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Comment%204%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%20envor-section-st2%20envor-section-cta2%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Call%20to%20Action%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%7D%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3E%3Cspan%3ELike%20%3Cstrong%3EEnvor%3C%2Fstrong%3E%20Template%3F%20Purchase%20in%20on%20ThemeForest!%3C%2Fspan%3E%20%3Ca%20href%3D%5C%22http%3A%2F%2Fthemeforest.net%2Fuser%2Fcththemes%2Fportfolio%3Fref%3Dcththemes%5C%22%20class%3D%5C%22envor-btn%20envor-btn-normal%20envor-btn-border-white%5C%22%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-download%5C%22%3E%3C%2Fi%3E%20purchase%20and%20download%3C%2Fa%3E%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Content%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%5D', '1', '2015-01-16 14:34:14', '1000', '', '0', '0000-00-00 00:00:00', '7', '2015-05-03 04:55:32', '1000', '1', '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '5', '', '_:homepage', '', '', '', '', '', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '', '8'), ('6', '191', 'About Company', 'about-company', '12', '', '', '', '', '%5B%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22animationdelay%22%3A%22200ms%22%2C%22animationduration%22%3A%22%22%2C%22stellar%22%3A%22%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Welcome%20Section%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22animationdelay%22%3A%22200ms%22%2C%22animationduration%22%3A%22%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-6%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-6%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Image%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraImage%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22src%22%3A%22images%2Fpages%2F1.jpg%22%2C%22alignment%22%3A%22left%22%2C%22style%22%3A%22default%22%2C%22bordercolor%22%3A%22grey%22%2C%22usepretty%22%3A%220%22%2C%22largeimage%22%3A%22%22%2C%22imagelink%22%3A%22%22%2C%22extraclass%22%3A%22single%22%2C%22layout%22%3A%22envor%3Aazuraimage-wrapper%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Page-1%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22animationdelay%22%3A%22200ms%22%2C%22animationduration%22%3A%22%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-6%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-6%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Content%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%3Ewelcome%20to%20%3Cstrong%3Eenvor%3C%2Fstrong%3E%3C%2Fh2%3E%5Cn%3Cp%3ELorem%20ipsum%20dolor%20sit%20amet%2C%20consectetur%20adipiscing%20elit.%20Aenean%20viverra%20nulla%20ac%20luctus%20volutpat.%20Pellentesque%20et%20arcu%20elit.%20Donec%20porttitor%20leo%20sit%20amet%20orci%20egestas%20pharetra.%20Sed%20eget%20tincidunt%20nulla%2C%20at%20facilisis%20velit.%20Lorem%20ipsum%20dolor%20sit%20amet%2C%20consectetur%20adipiscing%20elit.%3C%2Fp%3E%5Cn%3Cp%3EQuisque%20eleifend%20quis%20nisl%20eget%20gravida.%20Sed%20ut%20arcu%20orci.%20Morbi%20at%20dui%20ut%20dolor%20ultrices%20ullamcorper%20eu%20nec%20ligula.%20Mauris%20scelerisque%20et%20dolor%20non%20tempus.%20Aliquam%20vitae%20dolor%20mollis%2C%20tincidunt%20magna%20at%2C%20semper%20sem.%20Phasellus%20elementum%20tristique%20leo%20at%20sollicitudin.%20Fusce%20pretium%20accumsan%20leo%20at%20imperdiet.%20Aenean%20gravida%20sit%20amet%20lorem%20ut%20vestibulum.%20Nam%20justo%20sem%2C%20luctus%20vitae%20magna%20ut%2C%20interdum%20lobortis%20nisi.%20Sed%20nulla%20purus%2C%20tempor%20eget%20tincidunt%20ac%2C%20accumsan%20sit%20amet%20elit.%20Integer%20sit%20amet%20interdum%20eros.%3C%2Fp%3E%5Cn%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary-border%20envor-btn-normal%5C%22%3Elearn%20more%20%3Ci%20class%3D%5C%22fa%20fa-plus%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Content%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%3Eour%20%3Cstrong%3Emain%3C%2Fstrong%3E%20features%3C%2Fh2%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%20envor-section-align-center%20envor-section-st1%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22animationdelay%22%3A%22200ms%22%2C%22animationduration%22%3A%22%22%2C%22stellar%22%3A%22%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Features%20Section%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-6%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-3%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Carticle%20class%3D%5C%22envor-feature-3%5C%22%3E%5Cn%20%20%3Cspan%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-link%5C%22%3E%3C%2Fi%3E%3C%2Fspan%3E%5Cn%20%20%3Ch3%3EDonec%20eu%20quam%3C%2Fh3%3E%5Cn%20%20%3Cp%3EAenean%20vulputate%20dictum%20sapien%20et%20sollicitudin.%3C%2Fp%3E%5Cn%20%20%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-small%5C%22%3Edetails%3C%2Fa%3E%3C%2Fp%3E%5Cn%3C%2Farticle%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Donec%20eu%20quam%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-6%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-3%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Carticle%20class%3D%5C%22envor-feature-3%5C%22%3E%5Cn%20%20%3Cspan%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-thumbs-up%5C%22%3E%3C%2Fi%3E%3C%2Fspan%3E%5Cn%20%20%3Ch3%3ECurabitur%20ornare%3C%2Fh3%3E%5Cn%20%20%3Cp%3ECurabitur%20nunc%20elit%2C%20eleifend%20in%20eros%20id%2C%20venenatis%20congue%20odio.%3C%2Fp%3E%5Cn%20%20%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-small%5C%22%3Edetails%3C%2Fa%3E%3C%2Fp%3E%5Cn%3C%2Farticle%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Curabitur%20ornare%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-6%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-3%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Carticle%20class%3D%5C%22envor-feature-3%5C%22%3E%5Cn%20%20%3Cspan%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-earphone%5C%22%3E%3C%2Fi%3E%3C%2Fspan%3E%5Cn%20%20%3Ch3%3ENulla%20dictum%3C%2Fh3%3E%5Cn%20%20%3Cp%3EPraesent%20vitae%20volutpat%20arcu%2C%20in%20eleifend%20purus.%3C%2Fp%3E%5Cn%20%20%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-small%5C%22%3Edetails%3C%2Fa%3E%3C%2Fp%3E%5Cn%3C%2Farticle%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Nulla%20dictum%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-6%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-3%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Carticle%20class%3D%5C%22envor-feature-3%5C%22%3E%5Cn%20%20%3Cspan%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-font%5C%22%3E%3C%2Fi%3E%3C%2Fspan%3E%5Cn%20%20%3Ch3%3Eante%20non%20tempor%3C%2Fh3%3E%5Cn%20%20%3Cp%3EVivamus%20convallis%20dictum%20sem%20in%20tristique.%3C%2Fp%3E%5Cn%20%20%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-small%5C%22%3Edetails%3C%2Fa%3E%3C%2Fp%3E%5Cn%3C%2Farticle%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22ante%20non%20tempor%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22animationdelay%22%3A%22200ms%22%2C%22animationduration%22%3A%22%22%2C%22stellar%22%3A%22%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Text%20-%20Toggle%20-%20Skills%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-4%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-4%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Text%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%3EWhy%20%3Cstrong%3Eus%3C%2Fstrong%3E%3F%3C%2Fh2%3E%5Cn%3Cp%3EDonec%20at%20augue%20non%20eros%20faucibus%20laoreet.%20Vivamus%20eget%20arcu%20sodales%2C%20faucibus%20risus%20a%2C%20placerat%20odio.%20Integer%20semper%20quis%20leo%20sit%20amet%20tempor.%20Integer%20vulputate%20augue%20eget%20rutrum%20aliquet.%20Nam%20id%20ante%20lacinia%2C%20fermentum%20mauris%20vel%2C%20sollicitudin%20purus.%3C%2Fp%3E%5Cn%3Cp%3EDonec%20dui%20lacus%2C%20placerat%20vitae%20aliquet%20eget%2C%20adipiscing%20in%20nibh.%20Morbi%20semper%20laoreet%20leo%2C%20non%20luctus%20turpis%20tempor%20sed.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Content%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-4%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-4%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Toggles%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cdiv%20class%3D%5C%22envor-toggle%5C%22%3E%5Cn%20%20%3C!--%5Cn%5Cn%20%20Toggle%20Item%5Cn%5Cn%20%20%2F%2F--%3E%5Cn%20%20%3Carticle%3E%5Cn%20%20%20%20%3Cheader%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-globe%5C%22%3E%3C%2Fi%3E%20Sed%20consectetur%20nunc%20eget%20sem%20tempus%20%3Ci%20class%3D%5C%22fa%20fa-plus%5C%22%3E%3C%2Fi%3E%3C%2Fheader%3E%5Cn%20%20%20%20%3Cdiv%20class%3D%5C%22entor-toggle-content%5C%22%3E%3Cp%3EFusce%20imperdiet%20est%20a%20feugiat%20vehicula.%20Pellentesque%20tempor%20feugiat%20lectus%20vitae%20feugiat.%20Nulla%20aliquet%2C%20diam%20non%20gravida%20iaculis%2C%20nulla%20metus%20bibendum%20ante%2C%20vel%20vehicula%20justo%20ligula%20ac%20dui.%20Vivamus%20lorem%20sem%2C%20scelerisque%20et%20mollis%20et%2C%20vestibulum%20at%20nisl.%20Aenean%20sagittis%20vulputate%20nulla%20a%20tristique.%3C%2Fp%3E%3C%2Fdiv%3E%5Cn%20%20%3C%2Farticle%3E%5Cn%20%20%3C!--%5Cn%5Cn%20%20Toggle%20Item%5Cn%20%20%5Cn%20%20%2F%2F--%3E%5Cn%20%20%3Carticle%3E%5Cn%20%20%20%20%3Cheader%3EMauris%20risus%20ante%2C%20volutpat%20eu%20malesuada%20ac%20%3Ci%20class%3D%5C%22fa%20fa-plus%5C%22%3E%3C%2Fi%3E%3C%2Fheader%3E%5Cn%20%20%20%20%3Cdiv%20class%3D%5C%22entor-toggle-content%5C%22%3E%3Cp%3EFusce%20imperdiet%20est%20a%20feugiat%20vehicula.%20Pellentesque%20tempor%20feugiat%20lectus%20vitae%20feugiat.%20Nulla%20aliquet%2C%20diam%20non%20gravida%20iaculis%2C%20nulla%20metus%20bibendum%20ante%2C%20vel%20vehicula%20justo%20ligula%20ac%20dui.%20Vivamus%20lorem%20sem%2C%20scelerisque%20et%20mollis%20et%2C%20vestibulum%20at%20nisl.%20Aenean%20sagittis%20vulputate%20nulla%20a%20tristique.%3C%2Fp%3E%3C%2Fdiv%3E%5Cn%20%20%3C%2Farticle%3E%5Cn%20%20%3C!--%5Cn%5Cn%20%20Toggle%20Item%5Cn%20%20%5Cn%20%20%2F%2F--%3E%5Cn%20%20%3Carticle%3E%5Cn%20%20%20%20%3Cheader%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-info-sign%5C%22%3E%3C%2Fi%3E%20Maecenas%20a%20laoreet%20augue%20%3Ci%20class%3D%5C%22fa%20fa-plus%5C%22%3E%3C%2Fi%3E%3C%2Fheader%3E%5Cn%20%20%20%20%3Cdiv%20class%3D%5C%22entor-toggle-content%5C%22%3E%3Cp%3EFusce%20imperdiet%20est%20a%20feugiat%20vehicula.%20Pellentesque%20tempor%20feugiat%20lectus%20vitae%20feugiat.%20Nulla%20aliquet%2C%20diam%20non%20gravida%20iaculis%2C%20nulla%20metus%20bibendum%20ante%2C%20vel%20vehicula%20justo%20ligula%20ac%20dui.%20Vivamus%20lorem%20sem%2C%20scelerisque%20et%20mollis%20et%2C%20vestibulum%20at%20nisl.%20Aenean%20sagittis%20vulputate%20nulla%20a%20tristique.%3C%2Fp%3E%3C%2Fdiv%3E%5Cn%20%20%3C%2Farticle%3E%5Cn%20%20%3C!--%5Cn%5Cn%20%20Toggle%20Item%5Cn%20%20%5Cn%20%20%2F%2F--%3E%5Cn%20%20%3Carticle%3E%5Cn%20%20%20%20%3Cheader%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-phone-alt%5C%22%3E%3C%2Fi%3E%20Vestibulum%20eu%20felis%20vehicula%20tortor%20%3Ci%20class%3D%5C%22fa%20fa-plus%5C%22%3E%3C%2Fi%3E%3C%2Fheader%3E%5Cn%20%20%20%20%3Cdiv%20class%3D%5C%22entor-toggle-content%5C%22%3E%3Cp%3EFusce%20imperdiet%20est%20a%20feugiat%20vehicula.%20Pellentesque%20tempor%20feugiat%20lectus%20vitae%20feugiat.%20Nulla%20aliquet%2C%20diam%20non%20gravida%20iaculis%2C%20nulla%20metus%20bibendum%20ante%2C%20vel%20vehicula%20justo%20ligula%20ac%20dui.%20Vivamus%20lorem%20sem%2C%20scelerisque%20et%20mollis%20et%2C%20vestibulum%20at%20nisl.%20Aenean%20sagittis%20vulputate%20nulla%20a%20tristique.%3C%2Fp%3E%3C%2Fdiv%3E%5Cn%20%20%3C%2Farticle%3E%5Cn%20%20%3C!--%5Cn%5Cn%20%20Toggle%20Item%5Cn%20%20%5Cn%20%20%2F%2F--%3E%5Cn%20%20%3Carticle%3E%5Cn%20%20%20%20%3Cheader%3EMauris%20vitae%20turpis%20ante%20%3Ci%20class%3D%5C%22fa%20fa-plus%5C%22%3E%3C%2Fi%3E%3C%2Fheader%3E%5Cn%20%20%20%20%3Cdiv%20class%3D%5C%22entor-toggle-content%5C%22%3E%3Cp%3EFusce%20imperdiet%20est%20a%20feugiat%20vehicula.%20Pellentesque%20tempor%20feugiat%20lectus%20vitae%20feugiat.%20Nulla%20aliquet%2C%20diam%20non%20gravida%20iaculis%2C%20nulla%20metus%20bibendum%20ante%2C%20vel%20vehicula%20justo%20ligula%20ac%20dui.%20Vivamus%20lorem%20sem%2C%20scelerisque%20et%20mollis%20et%2C%20vestibulum%20at%20nisl.%20Aenean%20sagittis%20vulputate%20nulla%20a%20tristique.%3C%2Fp%3E%3C%2Fdiv%3E%5Cn%20%20%3C%2Farticle%3E%5Cn%3C%2Fdiv%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Toggle%20Items%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-4%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-4%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Skills%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%3EOur%20%3Cstrong%3ESkills%3C%2Fstrong%3E%3C%2Fh2%3E%5Cn%3C!--%5Cn*%20Skill%20%232%20Item%5Cn%2F%2F--%3E%5Cn%3Cdiv%20class%3D%5C%22envor-skill-2%5C%22%20data-name%3D%5C%22HTML5%5C%22%20data-value%3D%5C%2289%25%5C%22%3E%3C%2Fdiv%3E%5Cn%3Cdiv%20class%3D%5C%22envor-skill-2%5C%22%20data-name%3D%5C%22CSS3%5C%22%20data-value%3D%5C%2282%25%5C%22%3E%3C%2Fdiv%3E%5Cn%3Cdiv%20class%3D%5C%22envor-skill-2%5C%22%20data-name%3D%5C%22JavaScript%5C%22%20data-value%3D%5C%2279%25%5C%22%3E%3C%2Fdiv%3E%5Cn%3Cdiv%20class%3D%5C%22envor-skill-2%5C%22%20data-name%3D%5C%22PHP%5C%22%20data-value%3D%5C%2275%25%5C%22%3E%3C%2Fdiv%3E%5Cn%3Cdiv%20class%3D%5C%22envor-skill-2%5C%22%20data-name%3D%5C%22WordPress%5C%22%20data-value%3D%5C%2284%25%5C%22%3E%3C%2Fdiv%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Skill%20Items%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%20envor-section-align-center%20envor-section-bg10%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Our%20Team%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%7D%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%20class%3D%5C%22white%5C%22%3Emeet%20%3Cstrong%3Eour%3C%2Fstrong%3E%20team%3C%2Fh2%3E%5Cn%3Cp%20class%3D%5C%22white%5C%22%3ELorem%20ipsum%20dolor%20sit%20amet%2C%20consectetur%20adipisicing%20elit%2C%20sed%20do%20eiusmod%20tempor%20incididunt%20ut%20labore%20et%20dolore%20magna%20aliqua.%20Ut%20enim%20ad%20minim%20veniam%2C%20quis%20nostrud%20exercitation%20ullamco%20laboris%20nisi%20ut%20aliquip%20ex%20ea%20commodo%20consequat.%20Duis%20aute%20irure%20dolor%20in%20reprehenderit%20in%20voluptate%20velit%20esse%20cillum%20dolore%20eu%20fugiat%20nulla%20pariatur.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22IntroText%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTeamSlider%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22extraclass%22%3A%22nav-white%22%2C%22selector%22%3A%22envor-team-1%22%2C%22visible%22%3A%224%22%2C%22shownavigation%22%3A%221%22%2C%22navigationpos%22%3A%22center%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Our%20Team%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraTeamSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22role%5C%22%3Edeveloper%3C%2Fp%3E%5Cn%3Cp%3EUt%20risus%20quam%2C%20lacinia%20id%20porta%20eu%2C%20pellentesque%20sed%20risus.%20Aenean%20sed%20magna%20ac%20ligula%20ultrices%20consectetur.%3C%2Fp%3E%5Cn%3Cp%20class%3D%5C%22links%5C%22%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-facebook%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-twitter%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-linkedin%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-envelope%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22job%22%3A%22Hi%20there!%20My%20name%20is%22%2C%22name%22%3A%22Anthony%20A.%20Schmidt%22%2C%22photo%22%3A%22images%2Fteam%2F1.jpg%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Anthony%20A.%20Schmidt%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTeamSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22role%5C%22%3Edeveloper%3C%2Fp%3E%5Cn%3Cp%3EMauris%20vel%20diam%20a%20purus%20lobortis%20malesuada.%20Nam%20tincidunt%20tortor%20quis%20ultricies%20ultricies.%3C%2Fp%3E%5Cn%3Cp%20class%3D%5C%22links%5C%22%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-facebook%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-twitter%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-linkedin%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-envelope%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22job%22%3A%22Hi%20there!%20My%20name%20is%22%2C%22name%22%3A%22Nadine%20F.%20Spears%22%2C%22photo%22%3A%22images%2Fteam%2F2.jpg%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Nadine%20F.%20Spears%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTeamSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22role%5C%22%3Edeveloper%3C%2Fp%3E%5Cn%3Cp%3EMauris%20tincidunt%20fringilla%20erat%20at%20dictum.%20Morbi%20justo%20lacus%2C%20mollis%20sit%20amet%20sodales%20quis%2C%20mattis%20ut%20dui.%20Fusce%20porttitor%20rhoncus%20enim.%3C%2Fp%3E%5Cn%3Cp%20class%3D%5C%22links%5C%22%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-facebook%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-twitter%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-linkedin%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-envelope%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22job%22%3A%22Hi%20there!%20My%20name%20is%22%2C%22name%22%3A%22Dennis%20A.%20Pendleton%22%2C%22photo%22%3A%22images%2Fteam%2F3.jpg%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Dennis%20A.%20Pendleton%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTeamSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22role%5C%22%3Edeveloper%3C%2Fp%3E%5Cn%3Cp%3ESed%20quis%20sagittis%20urna%2C%20ac%20commodo%20dolor.%20Nunc%20tincidunt%20volutpat%20sagittis.%20Proin%20eu%20massa%20gravida%2C%20euismod%20justo%20nec%2C%20sollicitudin%20tellus.%3C%2Fp%3E%5Cn%3Cp%20class%3D%5C%22links%5C%22%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-facebook%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-twitter%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-linkedin%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-envelope%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22job%22%3A%22Hi%20there!%20My%20name%20is%22%2C%22name%22%3A%22Marjorie%20L.%20Penland%22%2C%22photo%22%3A%22images%2Fteam%2F4.jpg%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Marjorie%20L.%20Penland%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTeamSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22role%5C%22%3Edeveloper%3C%2Fp%3E%5Cn%3Cp%3EMorbi%20at%20lorem%20mollis%2C%20fermentum%20eros%20eu%2C%20mollis%20metus.%20Cras%20consectetur%20quam%20vitae%20urna%20elementum%20sodales.%3C%2Fp%3E%5Cn%3Cp%20class%3D%5C%22links%5C%22%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-facebook%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-twitter%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-linkedin%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-envelope%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22job%22%3A%22Hi%20there!%20My%20name%20is%22%2C%22name%22%3A%22Jerry%20C.%20Schneider%22%2C%22photo%22%3A%22images%2Fteam%2F5.jpg%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Jerry%20C.%20Schneider%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTeamSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22role%5C%22%3Edeveloper%3C%2Fp%3E%5Cn%3Cp%3ENam%20malesuada%20risus%20nulla%2C%20sit%20amet%20sodales%20orci%20lacinia%20nec.%20Curabitur%20nec%20convallis%20quam.%3C%2Fp%3E%5Cn%3Cp%20class%3D%5C%22links%5C%22%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-facebook%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-twitter%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-linkedin%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-envelope%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22job%22%3A%22Hi%20there!%20My%20name%20is%22%2C%22name%22%3A%22Minnie%20B.%20Young%22%2C%22photo%22%3A%22images%2Fteam%2F6.jpg%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Minnie%20B.%20Young%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%20envor-section-align-center%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Our%20Patners%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%7D%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraOurClients%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%3Eour%20%3Cstrong%3Epartners%3C%2Fstrong%3E%3C%2Fh2%3E%22%2C%22attrs%22%3A%7B%22extraclass%22%3A%22%22%2C%22selector%22%3A%22envor-partner-logo%22%2C%22visible%22%3A%225%22%2C%22mobilevisible%22%3A%221%22%2C%22showpagination%22%3A%221%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22paginationpos%22%3A%22center%22%7D%2C%22name%22%3A%22Clients%20Slider%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraOurClientsItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22logo%22%3A%22images%2Fpartners%2F1.png%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Logo1%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraOurClientsItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22logo%22%3A%22images%2Fpartners%2F2.png%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Logo%202%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraOurClientsItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22logo%22%3A%22images%2Fpartners%2F3.png%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Logo%203%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraOurClientsItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22logo%22%3A%22images%2Fpartners%2F4.png%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Logo%204%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraOurClientsItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22logo%22%3A%22images%2Fpartners%2F5.png%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Logo%205%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraOurClientsItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22logo%22%3A%22images%2Fpartners%2F6.png%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Logo%206%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraOurClientsItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22logo%22%3A%22images%2Fpartners%2F7.png%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Logo%207%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraOurClientsItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22logo%22%3A%22images%2Fpartners%2F8.png%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Logo%208%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%5D%7D%5D', '1', '2015-01-22 14:33:31', '1000', '', '0', '0000-00-00 00:00:00', '7', '2016-03-29 05:08:36', '1000', '1', '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '6', '', '_:homepage', '', '', '', '', '', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '', '8'), ('7', '192', 'About Person', 'about-person', '12', '', '', '', '', '%5B%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22animationdelay%22%3A%22200ms%22%2C%22animationduration%22%3A%22%22%2C%22stellar%22%3A%22%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Welcome%20Section%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22animationdelay%22%3A%22200ms%22%2C%22animationduration%22%3A%22%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-4%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-4%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Image%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraImage%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22src%22%3A%22images%2Fteam%2F15.jpg%22%2C%22alignment%22%3A%22left%22%2C%22style%22%3A%22default%22%2C%22bordercolor%22%3A%22grey%22%2C%22usepretty%22%3A%220%22%2C%22largeimage%22%3A%22%22%2C%22imagelink%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazuraimage-wrapper%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Page-1%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22animationdelay%22%3A%22200ms%22%2C%22animationduration%22%3A%22%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-8%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-8%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Content%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%3EHi%20there!%20I%20am%20a%20%3Cstrong%3Eweb%20developer%3C%2Fstrong%3E!%3C%2Fh2%3E%5Cn%3Cp%3EAenean%20varius%20nulla%20turpis%2C%20id%20iaculis%20leo%20elementum%20vitae.%20Lorem%20ipsum%20dolor%20sit%20amet%2C%20consectetur%20adipiscing%20elit.%20Cras%20sodales%20diam%20lacinia%2C%20porta%20lectus%20a%2C%20consectetur%20justo.%20Phasellus%20elit%20leo%2C%20rhoncus%20ac%20urna%20at%2C%20suscipit%20rhoncus%20nisi.%20Aenean%20dignissim%20magna%20a%20erat%20blandit%2C%20in%20feugiat%20nibh%20malesuada.%20Vestibulum%20ullamcorper%20vulputate%20adipiscing.%20Duis%20cursus%20imperdiet%20orci%20vel%20vulputate.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Content%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cdiv%20class%3D%5C%22row%5C%22%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22col-lg-6%20col-md-6%5C%22%3E%5Cn%20%20%20%20%3Ch2%3Emore%20%3Cstrong%3Eoptions%3C%2Fstrong%3E%3C%2Fh2%3E%5Cn%20%20%20%20%3Cul%20class%3D%5C%22e-color-list%5C%22%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20Sed%20vel%20libero%20eget%20erat%20commodo%20porta%20sed%20facilisis.%3C%2Fli%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20Cum%20sociis%20natoque%20penatibus%20et%20magnis%20dis%20parturient%20.%3C%2Fli%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20Morbi%20fringilla%20condimentum%20sapien%20mi%20vitae%20facilisis.%3C%2Fli%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20Nullam%20porta%2C%20elit%20vel%20porttitor%20elementum%2C%20mauris.%3C%2Fli%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20Praesent%20hendrerit%20eu%20dui%20eu%20tempor.%3C%2Fli%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20Donec%20dolor%20massa%2C%20accumsan%20sit%20amet%20orci%20non.%3C%2Fli%3E%5Cn%20%20%20%20%3C%2Ful%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22col-lg-6%20col-md-6%5C%22%3E%5Cn%20%20%20%20%3Ch2%3EMy%20%3Cstrong%3ESkills%3C%2Fstrong%3E%3C%2Fh2%3E%5Cn%20%20%20%20%3Cdiv%20class%3D%5C%22envor-relative%5C%22%20id%3D%5C%22skills%5C%22%3E%5Cn%20%20%20%20%20%20%3Cdiv%20class%3D%5C%22envor-skill-2%5C%22%20data-name%3D%5C%22HTML5%5C%22%20data-value%3D%5C%2289%25%5C%22%3E%3C%2Fdiv%3E%5Cn%20%20%20%20%20%20%3Cdiv%20class%3D%5C%22envor-skill-2%5C%22%20data-name%3D%5C%22CSS3%5C%22%20data-value%3D%5C%2282%25%5C%22%3E%3C%2Fdiv%3E%5Cn%20%20%20%20%20%20%3Cdiv%20class%3D%5C%22envor-skill-2%5C%22%20data-name%3D%5C%22JavaScript%5C%22%20data-value%3D%5C%2279%25%5C%22%3E%3C%2Fdiv%3E%5Cn%20%20%20%20%20%20%3Cdiv%20class%3D%5C%22envor-skill-2%5C%22%20data-name%3D%5C%22PHP%5C%22%20data-value%3D%5C%2275%25%5C%22%3E%3C%2Fdiv%3E%5Cn%20%20%20%20%3C%2Fdiv%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%3C%2Fdiv%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Options%20-%20Skills%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%20envor-section-bg8%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22images%2Fbackground%2Fbg3.jpg%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22animationdelay%22%3A%22200ms%22%2C%22animationduration%22%3A%22%22%2C%22stellar%22%3A%22%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Features%20Section%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-3%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Carticle%20class%3D%5C%22envor-feature-2%20envor-feature-2-color%5C%22%3E%5Cn%20%20%3Cheader%3E%5Cn%20%20%20%20%3Ci%20class%3D%5C%22fa%20fa-globe%5C%22%3E%3C%2Fi%3E%3Cspan%20class%3D%5C%22arrow%5C%22%3E%3C%2Fspan%3E%5Cn%20%20%20%20lovely%5Cn%20%20%3C%2Fheader%3E%5Cn%20%20%3Cp%3EDonec%20cursus%20ligula%20ante%2C%20non%20faucibus%20felis%20lobortis%20sed.%3C%2Fp%3E%5Cn%20%20%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-small%5C%22%3EDetails%20%3Ci%20class%3D%5C%22fa%20fa-arrow-circle-right%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%3C%2Fp%3E%5Cn%3C%2Farticle%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22lovely%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-3%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Carticle%20class%3D%5C%22envor-feature-2%20envor-feature-2-color%5C%22%3E%5Cn%20%20%3Cheader%3E%5Cn%20%20%20%20%3Ci%20class%3D%5C%22fa%20fa-cog%5C%22%3E%3C%2Fi%3E%3Cspan%20class%3D%5C%22arrow%5C%22%3E%3C%2Fspan%3E%5Cn%20%20%20%20exquisite%5Cn%20%20%3C%2Fheader%3E%5Cn%20%20%3Cp%3EVivamus%20sollicitudin%20nisi%20rhoncus%20bibendum%20suscipit.%3C%2Fp%3E%5Cn%20%20%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-small%5C%22%3EDetails%20%3Ci%20class%3D%5C%22fa%20fa-arrow-circle-right%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%3C%2Fp%3E%5Cn%3C%2Farticle%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22exquisite%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-3%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Carticle%20class%3D%5C%22envor-feature-2%20envor-feature-2-color%5C%22%3E%5Cn%20%20%3Cheader%3E%5Cn%20%20%20%20%3Ci%20class%3D%5C%22fa%20fa-trophy%5C%22%3E%3C%2Fi%3E%3Cspan%20class%3D%5C%22arrow%5C%22%3E%3C%2Fspan%3E%5Cn%20%20%20%20glorious%5Cn%20%20%3C%2Fheader%3E%5Cn%20%20%3Cp%3EPellentesque%20lacinia%2C%20lectus%20ac%20varius%20adipiscing.%3C%2Fp%3E%5Cn%20%20%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-small%5C%22%3EDetails%20%3Ci%20class%3D%5C%22fa%20fa-arrow-circle-right%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%3C%2Fp%3E%5Cn%3C%2Farticle%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22glorious%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-3%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Carticle%20class%3D%5C%22envor-feature-2%20envor-feature-2-color%5C%22%3E%5Cn%20%20%3Cheader%3E%5Cn%20%20%20%20%3Ci%20class%3D%5C%22fa%20fa-flask%5C%22%3E%3C%2Fi%3E%3Cspan%20class%3D%5C%22arrow%5C%22%3E%3C%2Fspan%3E%5Cn%20%20%20%20stunning%5Cn%20%20%3C%2Fheader%3E%5Cn%20%20%3Cp%3EFusce%20mattis%20sem%20sed%20lectus%20rhoncus%20nisl%20nisl%20tincidunt%20libero.%3C%2Fp%3E%5Cn%20%20%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-small%5C%22%3EDetails%20%3Ci%20class%3D%5C%22fa%20fa-arrow-circle-right%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%3C%2Fp%3E%5Cn%3C%2Farticle%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22stunning%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%20envor-section-st2%20envor-soc-buttons-list%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Follow%20Me%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%7D%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%20class%3D%5C%22white%5C%22%3Efollow%20%3Cstrong%3Eme%3C%2Fstrong%3E%3C%2Fh2%3E%5Cn%3Cdiv%20class%3D%5C%22cl%5C%22%3E%3C%2Fdiv%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22title%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cdiv%20class%3D%5C%22envor-social-button-2%20envor-social-button-2-white%5C%22%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-tooltip%5C%22%3E%5Cn%20%20%20%20%3Cp%3Efacebook%3C%2Fp%3E%5Cn%20%20%20%20%3Cspan%20class%3D%5C%22arrow%5C%22%3E%3C%2Fspan%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-main%5C%22%3E%5Cn%20%20%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-facebook%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%3C%2Fdiv%3E%5Cn%3C!--%5Cn%5CnSocial%20Button%20Item%20start%5Cn%5Cn%2F%2F--%3E%5Cn%3Cdiv%20class%3D%5C%22envor-social-button-2%20envor-social-button-2-white%5C%22%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-tooltip%5C%22%3E%5Cn%20%20%20%20%3Cp%3Etwitter%3C%2Fp%3E%5Cn%20%20%20%20%3Cspan%20class%3D%5C%22arrow%5C%22%3E%3C%2Fspan%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-main%5C%22%3E%5Cn%20%20%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-twitter%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%3C%2Fdiv%3E%5Cn%3C!--%5Cn%5CnSocial%20Button%20Item%20start%5Cn%5Cn%2F%2F--%3E%5Cn%3Cdiv%20class%3D%5C%22envor-social-button-2%20envor-social-button-2-white%5C%22%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-tooltip%5C%22%3E%5Cn%20%20%20%20%3Cp%3Elinkedin%3C%2Fp%3E%5Cn%20%20%20%20%3Cspan%20class%3D%5C%22arrow%5C%22%3E%3C%2Fspan%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-main%5C%22%3E%5Cn%20%20%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-linkedin%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%3C%2Fdiv%3E%5Cn%3C!--%5Cn%5CnSocial%20Button%20Item%20start%5Cn%5Cn%2F%2F--%3E%5Cn%3Cdiv%20class%3D%5C%22envor-social-button-2%20envor-social-button-2-white%5C%22%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-tooltip%5C%22%3E%5Cn%20%20%20%20%3Cp%3Egoogle%20plus%3C%2Fp%3E%5Cn%20%20%20%20%3Cspan%20class%3D%5C%22arrow%5C%22%3E%3C%2Fspan%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-main%5C%22%3E%5Cn%20%20%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-google-plus%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%3C%2Fdiv%3E%5Cn%3C!--%5Cn%5CnSocial%20Button%20Item%20start%5Cn%5Cn%2F%2F--%3E%5Cn%3Cdiv%20class%3D%5C%22envor-social-button-2%20envor-social-button-2-white%5C%22%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-tooltip%5C%22%3E%5Cn%20%20%20%20%3Cp%3Edribbble%3C%2Fp%3E%5Cn%20%20%20%20%3Cspan%20class%3D%5C%22arrow%5C%22%3E%3C%2Fspan%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-main%5C%22%3E%5Cn%20%20%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-dribbble%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%3C%2Fdiv%3E%5Cn%3C!--%5Cn%5CnSocial%20Button%20Item%20start%5Cn%5Cn%2F%2F--%3E%5Cn%3Cdiv%20class%3D%5C%22envor-social-button-2%20envor-social-button-2-white%5C%22%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-tooltip%5C%22%3E%5Cn%20%20%20%20%3Cp%3Eskype%20%3C%2Fp%3E%5Cn%20%20%20%20%3Cspan%20class%3D%5C%22arrow%5C%22%3E%3C%2Fspan%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-main%5C%22%3E%5Cn%20%20%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-skype%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%3C%2Fdiv%3E%5Cn%3C!--%5Cn%5CnSocial%20Button%20Item%20start%5Cn%5Cn%2F%2F--%3E%5Cn%3Cdiv%20class%3D%5C%22envor-social-button-2%20envor-social-button-2-white%5C%22%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-tooltip%5C%22%3E%5Cn%20%20%20%20%3Cp%3Eyoutube%3C%2Fp%3E%5Cn%20%20%20%20%3Cspan%20class%3D%5C%22arrow%5C%22%3E%3C%2Fspan%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-main%5C%22%3E%5Cn%20%20%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-youtube%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%3C%2Fdiv%3E%5Cn%3C!--%5Cn%5CnSocial%20Button%20Item%20start%5Cn%5Cn%2F%2F--%3E%5Cn%3Cdiv%20class%3D%5C%22envor-social-button-2%20envor-social-button-2-white%5C%22%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-tooltip%5C%22%3E%5Cn%20%20%20%20%3Cp%3Evimeo%3C%2Fp%3E%5Cn%20%20%20%20%3Cspan%20class%3D%5C%22arrow%5C%22%3E%3C%2Fspan%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-main%5C%22%3E%5Cn%20%20%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-vimeo-square%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%3C%2Fdiv%3E%5Cn%3C!--%5Cn%5CnSocial%20Button%20Item%20start%5Cn%5Cn%2F%2F--%3E%5Cn%3Cdiv%20class%3D%5C%22envor-social-button-2%20envor-social-button-2-white%5C%22%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-tooltip%5C%22%3E%5Cn%20%20%20%20%3Cp%3EVK%3C%2Fp%3E%5Cn%20%20%20%20%3Cspan%20class%3D%5C%22arrow%5C%22%3E%3C%2Fspan%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22esb-main%5C%22%3E%5Cn%20%20%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-vk%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%3C%2Fdiv%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Social%20Buttons%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%5D', '1', '2015-01-22 15:29:59', '1000', '', '0', '0000-00-00 00:00:00', '4', '2015-05-03 04:54:18', '1000', '1', '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '7', '', '_:homepage', '', '', '', '', '', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '', '3');
INSERT INTO `#__azurapagebuilder_pages` VALUES ('8', '193', 'Services', 'services', '12', '', '', '', '', '%5B%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%3Eour%20fields%20of%20%3Cstrong%3Eexpertise%3C%2Fstrong%3E%3C%2Fh2%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%20envor-section-align-center%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Our%20fields%20of%20expertise%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-6%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-6%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Image%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraImage%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22src%22%3A%22images%2Fpages%2F2.jpg%22%2C%22alignment%22%3A%22left%22%2C%22style%22%3A%22default%22%2C%22bordercolor%22%3A%22grey%22%2C%22usepretty%22%3A%220%22%2C%22largeimage%22%3A%22%22%2C%22imagelink%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazuraimage-wrapper%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Page-2%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22envor-section-align-left%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-6%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-6%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Content%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3ESed%20a%20eros%20semper%2C%20blandit%20lectus%20at%2C%20vulputate%20dui.%20Mauris%20ut%20gravida%20felis.%20Aliquam%20sit%20amet%20ultrices%20elit%2C%20eget%20pulvinar%20quam.%20Aliquam%20urna%20sapien%2C%20luctus%20sit%20amet%20volutpat%20eget%2C%20faucibus%20nec%20arcu.%20Phasellus%20a%20consectetur%20ante%2C%20ac%20mollis%20nunc.%20Aenean%20nisi%20justo%2C%20blandit%20sagittis%20dapibus%20sit%20amet%2C%20posuere%20ut%20urna.%3C%2Fp%3E%5Cn%3Cul%20class%3D%5C%22e-color-list%20e-border-list%5C%22%3E%5Cn%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20Sed%20vel%20libero%20eget%20erat%20commodo%20porta%20sed%20facilisis%20mauris.%3C%2Fli%3E%5Cn%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20Cum%20sociis%20natoque%20penatibus%20et%20magnis%20dis%20parturient%20montes%20.%3C%2Fli%3E%5Cn%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20Morbi%20fringilla%20condimentum%20sapien%20mi%20vitae%20facilisis%20tincidunt.%3C%2Fli%3E%5Cn%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20Nullam%20porta%2C%20elit%20vel%20porttitor%20elementum%2C%20mauris%20risus%20interdum.%3C%2Fli%3E%5Cn%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20Praesent%20hendrerit%20eu%20dui%20eu%20tempor.%3C%2Fli%3E%5Cn%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20Donec%20dolor%20massa%2C%20accumsan%20sit%20amet%20orci%20non%2C%20placerat.%3C%2Fli%3E%5Cn%3C%2Ful%3E%5Cn%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-normal%5C%22%3Elearn%20more!%3C%2Fa%3E%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Content%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%20envor-section-align-center%20envor-section-st1%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Features%20Slider%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%7D%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%3Eour%20main%20%3Cstrong%3Efeatures%3C%2Fstrong%3E%3C%2Fh2%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Title%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFeaturesSlider%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22extraclass%22%3A%22%22%2C%22selector%22%3A%22envor-feature%22%2C%22visible%22%3A%224%22%2C%22shownavigation%22%3A%221%22%2C%22navigationpos%22%3A%22center%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Our%20core%20Features%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraFeaturesSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cheader%3E%5Cn%20%20%3Ci%20class%3D%5C%22fa%20fa-globe%5C%22%3E%3C%2Fi%3E%5Cn%20%20lovely%5Cn%3C%2Fheader%3E%5Cn%3Cp%3EDonec%20cursus%20ligula%20ante%2C%20non%20faucibus%20felis%20lobortis%20sed.%3C%2Fp%3E%5Cn%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%3EDetails%20%3Ci%20class%3D%5C%22fa%20fa-arrow-circle-right%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22extraclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22lovely%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFeaturesSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cheader%3E%5Cn%20%20%3Ci%20class%3D%5C%22fa%20fa-cog%5C%22%3E%3C%2Fi%3E%5Cn%20%20exquisite%5Cn%3C%2Fheader%3E%5Cn%3Cp%3EVivamus%20sollicitudin%20nisi%20rhoncus%20bibendum%20suscipit.%3C%2Fp%3E%5Cn%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%3EDetails%20%3Ci%20class%3D%5C%22fa%20fa-arrow-circle-right%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22extraclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22exquisite%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFeaturesSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cheader%3E%5Cn%20%20%3Ci%20class%3D%5C%22fa%20fa-trophy%5C%22%3E%3C%2Fi%3E%5Cn%20%20glorious%5Cn%3C%2Fheader%3E%5Cn%3Cp%3EPellentesque%20lacinia%2C%20lectus%20ac%20varius%20adipiscing.%3C%2Fp%3E%5Cn%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%3EDetails%20%3Ci%20class%3D%5C%22fa%20fa-arrow-circle-right%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22extraclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22glorious%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFeaturesSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cheader%3E%5Cn%20%20%3Ci%20class%3D%5C%22fa%20fa-flask%5C%22%3E%3C%2Fi%3E%5Cn%20%20stunning%5Cn%3C%2Fheader%3E%5Cn%3Cp%3EFusce%20mattis%20sem%20sed%20lectus%20rhoncus%20nisl%20nisl%20tincidunt%20libero.%3C%2Fp%3E%5Cn%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%3EDetails%20%3Ci%20class%3D%5C%22fa%20fa-arrow-circle-right%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22extraclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22stunning%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFeaturesSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cheader%3E%5Cn%20%20%3Ci%20class%3D%5C%22fa%20fa-magic%5C%22%3E%3C%2Fi%3E%5Cn%20%20inspired%5Cn%3C%2Fheader%3E%5Cn%3Cp%3EPellentesque%20lacinia%2C%20lectus%20ac%20varius%20adipiscing.%3C%2Fp%3E%5Cn%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%3EDetails%20%3Ci%20class%3D%5C%22fa%20fa-arrow-circle-right%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22extraclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22inspired%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFeaturesSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cheader%3E%5Cn%20%20%3Ci%20class%3D%5C%22fa%20fa-tachometer%5C%22%3E%3C%2Fi%3E%5Cn%20%20sublime%5Cn%3C%2Fheader%3E%5Cn%3Cp%3EFusce%20mattis%20sem%20sed%20lectus%20rhoncus%20nisl%20nisl%20tincidunt%20libero.%3C%2Fp%3E%5Cn%3Cp%3E%3Ca%20href%3D%5C%22%5C%22%3EDetails%20%3Ci%20class%3D%5C%22fa%20fa-arrow-circle-right%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22extraclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22sublime%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Other%20Services%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-4%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-4%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%3Eother%20%3Cstrong%3Eservices%3C%2Fstrong%3E%3C%2Fh2%3E%5Cn%3Cp%3EDuis%20et%20neque%20lacinia%2C%20tincidunt%20urna%20vel%2C%20suscipit%20elit.%20Nullam%20quis%20eleifend%20est%2C%20at%20hendrerit%20metus.%20Phasellus%20a%20vehicula%20neque.%20Aenean%20congue%20felis%20id%20vehicula%20feugiat.%20Curabitur%20non%20leo%20ac%20nulla%20euismod%20dictum.%20Sed%20odio%20dolor%2C%20iaculis%20in%20ipsum%20nec%2C%20molestie%20gravida%20massa.%20Integer%20auctor%20dignissim%20tempus.%20Mauris%20ultrices%20urna%20auctor%20dolor%20tristique%20blandit.%20Praesent%20mattis%20mauris%20ultricies%20libero%20blandit%20elementum.%3C%2Fp%3E%5Cn%3Cp%3E%3Ca%20href%3D%5C%22http%3A%2F%2Fthemeforest.net%2Fuser%2Fcththemes%2Fportfolio%3Fref%3Dcththemes%5C%22%20class%3D%5C%22envor-btn%20envor-btn-normal%20envor-btn-primary%5C%22%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-download%5C%22%3E%3C%2Fi%3E%20purchase%20and%20download%3C%2Fa%3E%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Other%20Services%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-8%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-8%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraTabs%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22defaultactive%22%3A%221%22%2C%22tabstyle%22%3A%22tab%22%2C%22usejustified%22%3A%221%22%2C%22fade%22%3A%221%22%2C%22layout%22%3A%22envor%3Aazuratabs-envor%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraTabsItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ci%20class%3D%5C%22glyphicon%20glyphicon-flag%5C%22%3E%3C%2Fi%3E%5Cn%3Cp%3EMorbi%20hendrerit%20dolor%20nec%20pretium%20malesuada.%20Mauris%20fringilla%20blandit%20tortor%20condimentum%20tempor.%20Proin%20dictum%20accumsan%20pellentesque.%20In%20elementum%2C%20mauris%20vel%20feugiat%20faucibus%2C%20quam%20metus%20ultricies%20erat%2C%20quis%20pretium%20leo%20lacus%20sit%20amet%20ligula.%20Ut%20a%20pellentesque%20ligula.%20In%20aliquam%20turpis%20eget%20tellus%20viverra%2C%20convallis%20ultricies%20elit%20suscipit.%3C%2Fp%3E%5Cn%3Cul%20class%3D%5C%22e-color-list%5C%22%3E%5Cn%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-star-empty%5C%22%3E%3C%2Fi%3E%20Sed%20vel%20libero%20eget%20erat%20commodo%20porta%20sed%20facilisis%20mauris.%3C%2Fli%3E%5Cn%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-star-empty%5C%22%3E%3C%2Fi%3E%20Nullam%20porta%2C%20elit%20vel%20porttitor%20elementum%2C%20mauris%20risus%20interdum%20placerat%20sed%20libero%20nec.%3C%2Fli%3E%5Cn%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-star-empty%5C%22%3E%3C%2Fi%3E%20Praesent%20hendrerit%20eu%20dui%20eu%20tempor.%3C%2Fli%3E%5Cn%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-star-empty%5C%22%3E%3C%2Fi%3E%20Donec%20dolor%20massa%2C%20accumsan%20sit%20amet%20orci%20non%2C%20placerat%20pellentesque.%3C%2Fli%3E%5Cn%3C%2Ful%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22title%22%3A%22Lovely%22%7D%2C%22name%22%3A%22Lovely%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTabsItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cdiv%20class%3D%5C%22dropcap%5C%22%3EN%3C%2Fdiv%3E%5Cn%3Cp%3Eullam%20pharetra%20mattis%20condimentum.%20Maecenas%20venenatis%20aliquet%20dui%20eu%20scelerisque.%20Proin%20nec%20magna%20vel%20lacus%20pretium%20interdum.%20Nam%20eu%20leo%20id%20arcu%20hendrerit%20semper.%20Phasellus%20bibendum%20est%20dignissim%20posuere%20lobortis.%20Sed%20a%20mollis%20est.%20Mauris%20at%20ipsum%20nec%20dui%20fermentum%20bibendum.%20Nullam%20non%20convallis%20enim.%20Quisque%20ornare%20tellus%20ac%20mi%20tincidunt%2C%20non%20auctor%20enim%20cursus.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22title%22%3A%22Exquisite%22%7D%2C%22name%22%3A%22Exquisite%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTabsItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EMaecenas%20quis%20bibendum%20arcu.%20Vestibulum%20placerat%20nunc%20nunc%2C%20at%20rhoncus%20dui%20lacinia%20quis.%20Morbi%20eu%20tortor%20tristique%2C%20semper%20metus%20a%2C%20molestie%20urna.%20Curabitur%20volutpat%20ante%20eros%2C%20eu%20hendrerit%20enim%20ullamcorper%20accumsan.%20Sed%20ipsum%20lectus%2C%20volutpat%20a%20nisi%20in%2C%20euismod%20porta%20elit.%20Vivamus%20viverra%20eu%20sapien%20ut%20aliquam.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22title%22%3A%22Glorious%22%7D%2C%22name%22%3A%22Glorious%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%20envor-section-bg7%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22images%2Fbackground%2Fbg2.jpg%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Toggle%20-%20Testimonials%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-6%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-6%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraAccordion%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22defaultActive%22%3A%222%22%2C%22acctype%22%3A%22accordion%22%2C%22layout%22%3A%22envor%3Aazuraaccordion-envor%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraAccordionItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EFusce%20imperdiet%20est%20a%20feugiat%20vehicula.%20Pellentesque%20tempor%20feugiat%20lectus%20vitae%20feugiat.%20Nulla%20aliquet%2C%20diam%20non%20gravida%20iaculis%2C%20nulla%20metus%20bibendum%20ante%2C%20vel%20vehicula%20justo%20ligula%20ac%20dui.%20Vivamus%20lorem%20sem%2C%20scelerisque%20et%20mollis%20et%2C%20vestibulum%20at%20nisl.%20Aenean%20sagittis%20vulputate%20nulla%20a%20tristique.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22title%22%3A%22--globe--%20Sed%20consectetur%20nunc%20eget%20sem%20tempus%22%2C%22subtitle%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraAccordionItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3ENullam%20ultricies%20ullamcorper%20nunc%2C%20sit%20amet%20pretium%20turpis%20elementum%20eu.%20Sed%20sodales%20libero%20odio%2C%20vel%20mattis%20nulla%20malesuada%20a.%20Suspendisse%20facilisis%20turpis%20quis%20ante%20interdum%2C%20ut%20tempor%20lectus%20interdum.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22title%22%3A%22Mauris%20risus%20ante%2C%20volutpat%20eu%20malesuada%20ac%22%2C%22subtitle%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraAccordionItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EMauris%20non%20lacus%20consectetur%2C%20iaculis%20ligula%20at%2C%20tempus%20elit.%20Donec%20vel%20tortor%20non%20nunc%20venenatis%20lobortis.%20Pellentesque%20sapien%20diam%2C%20vestibulum%20id%20risus%20fringilla%2C%20fermentum%20bibendum%20ipsum.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22title%22%3A%22--info-sign--%20Maecenas%20a%20laoreet%20augue%22%2C%22subtitle%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraAccordionItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3ENullam%20viverra%20metus%20sed%20odio%20dignissim%20suscipit.%20Class%20aptent%20taciti%20sociosqu%20ad%20litora%20torquent%20per%20conubia%20nostra%2C%20per%20inceptos%20himenaeos.%20Sed%20ut%20neque%20vitae%20ipsum%20auctor%20adipiscing.%20Mauris%20porta%20nulla%20at%20tellus%20eleifend%2C%20id%20dictum%20quam%20aliquam.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22title%22%3A%22--phone-alt--%20Vestibulum%20eu%20felis%20vehicula%20tortor%20aliquet%20fermentum%22%2C%22subtitle%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-6%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-6%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%3Ewhat%20%3Cstrong%3Eclients%20say%3C%2Fstrong%3E%3C%2Fh2%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Title%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraQuote%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22extraclass%22%3A%22%22%2C%22selector%22%3A%22envor-testimonials-3%22%2C%22visible%22%3A%221%22%2C%22mobilevisible%22%3A%221%22%2C%22showpagination%22%3A%221%22%2C%22paginationpos%22%3A%22left%22%2C%22layout%22%3A%22envor%3Aazuraquote-style3%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraTestimonial%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22Morbi%20sem%20erat%2C%20scelerisque%20sed%20est%20et%2C%20scelerisque%20rhoncus%20purus.%20Aenean%20varius%2C%20est%20vitae%20aliquet%20faucibus%2C%20nibh%20enim%20vehicula%20enim%2C%20sed%20tincidunt%20velit%20turpis%20sed%20ligula.%22%2C%22attrs%22%3A%7B%22name%22%3A%22Connie%20C.%20Sirois%22%2C%22company%22%3A%22developer%22%2C%22email%22%3A%22%22%2C%22photo%22%3A%22images%2Fusers%2F2.jpg%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Connie%20C.%20Sirois%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTestimonial%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22Praesent%20euismod%20sapien%20vulputate%2C%20pulvinar%20lectus%20eu%2C%20interdum%20metus.%20Donec%20orci%20erat%2C%20scelerisque%20vitae%20tincidunt%20in%2C%20tincidunt%20sit%20amet%20nibh.%20Ut%20nibh%20ligula%2C%20dignissim%20in%20lobortis%20eget%2C%20rutrum%20vitae%20erat.%20Nullam%20eu%20felis%20euismod%20nibh%20mollis%20malesuada%20vel%20nec%20tortor.%22%2C%22attrs%22%3A%7B%22name%22%3A%22Robin%20J.%20Reeves%22%2C%22company%22%3A%22developer%22%2C%22email%22%3A%22%22%2C%22photo%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Robin%20J.%20Reeves%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTestimonial%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22Integer%20varius%20tristique%20massa%20et%20lacinia.%20Maecenas%20sit%20amet%20feugiat%20sapien%2C%20quis%20auctor%20sem%20varius%20congue.%22%2C%22attrs%22%3A%7B%22name%22%3A%22James%20A.%20Kittle%22%2C%22company%22%3A%22developer%22%2C%22email%22%3A%22%22%2C%22photo%22%3A%22images%2Fusers%2F1.jpg%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%7D%2C%22name%22%3A%22James%20A.%20Kittle%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTestimonial%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22Sed%20vel%20libero%20eget%20erat%20commodo%20porta%20sed%20facilisis%20mauris.%20Cum%20sociis%20natoque%20penatibus%20et%20magnis%20dis%20parturient%20montes%2C%20nascetur%20ridiculus%20mus.%20Morbi%20fringilla%20condimentum%20sapien.%20Nullam%20porta%2C%20elit%20vel%20porttitor%20elementum%2C%20mauris%20risus%20interdum%20arcu%2C%20nec%20blandit%20lacus%20tortor%20quis%20tortor.%22%2C%22attrs%22%3A%7B%22name%22%3A%22Richard%20S.%20Berry%22%2C%22company%22%3A%22developer%22%2C%22email%22%3A%22contact.cththemes%40gmail.com%22%2C%22photo%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Richard%20S.%20Berry%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%5D%7D%5D', '1', '2015-01-23 11:37:05', '1000', '', '0', '0000-00-00 00:00:00', '7', '2015-05-03 04:54:31', '1000', '1', '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '8', '', '_:homepage', '', '', '', '', '', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '', '9'), ('9', '194', 'Left Sidebar', 'left-sidebar', '12', '', '', '', '', '%5B%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Sidebar%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%2289%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Search%20Widget%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%22119%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Browse%20Categories%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%2288%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Recent%20Posts%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%22122%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Tags%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%22124%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Recent%20Tweets%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-9%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Content%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraHtml%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%20class%3D%5C%22align-left%5C%22%3EThis%20Is%20An%20Example%20%3Cstrong%3ESidebar%3C%2Fstrong%3E%20Page%3C%2Fh2%3E%3Cfigure%3E%3Cimg%20alt%3D%5C%223%5C%22%20src%3D%5C%22images%2Fpages%2F3.jpg%5C%22%20data-mce-src%3D%5C%22images%2Fpages%2F3.jpg%5C%22%3E%3C%2Ffigure%3E%3Cp%3E%26nbsp%3B%3C%2Fp%3E%3Cp%3EQuisque%20vitae%20commodo%20est.%20Duis%20rutrum%20odio%20nec%20risus%20sagittis%20pretium.%20Etiam%20bibendum%20turpis%20in%20tellus%20tempor%2C%20eget%20convallis%20nisi%20feugiat.%20Sed%20in%20eros%20ipsum.%20Vestibulum%20viverra%20adipiscing%20commodo.%20Sed%20vel%20nulla%20augue.%20In%20pellentesque%20aliquet%20lacus%2C%20vitae%20sagittis%20orci%20dictum%20vel.%20Maecenas%20mattis%20eros%20nec%20erat%20blandit%20aliquam.%20Aliquam%20aliquet%20lobortis%20dictum.%20Integer%20interdum%20interdum%20magna%20et%20dignissim.%20Donec%20tincidunt%20elit%20libero%2C%20eu%20blandit%20mauris%20tincidunt%20ut.%20Quisque%20malesuada%20commodo%20nisi%20vitae%20varius.%20Quisque%20malesuada%20quam%20ut%20sapien%20consequat%20suscipit.%20Nullam%20vel%20turpis%20lobortis%2C%20dapibus%20tortor%20nec%2C%20blandit%20ligula.%20Praesent%20vitae%20turpis%20eget%20purus%20rhoncus%20cursus%20nec%20id%20metus.%3C%2Fp%3E%3Cp%3EPraesent%20pulvinar%20quis%20enim%20quis%20auctor.%20Nam%20condimentum%2C%20nisi%20vitae%20volutpat%20bibendum%2C%20turpis%20nisl%20malesuada%20arcu%2C%20vitae%20consequat%20nibh%20est%20quis%20dolor.%20In%20consectetur%20nec%20risus%20sed%20tempor.%20Maecenas%20eu%20est%20felis.%20Sed%20a%20elit%20eget%20ligula%20rhoncus%20fringilla%20ac%20sit%20amet%20sapien.%20Mauris%20sagittis%20lectus%20eget%20interdum%20viverra.%20Vestibulum%20nec%20nisi%20eu%20nunc%20porttitor%20tristique.%20Cras%20nunc%20quam%2C%20cursus%20id%20dictum%20ut%2C%20ultrices%20at%20sapien.%20Maecenas%20lectus%20tellus%2C%20gravida%20vitae%20mollis%20nec%2C%20vulputate%20eu%20nibh.%20Sed%20ornare%20ante%20ac%20velit%20gravida%20rhoncus.%20Ut%20vitae%20molestie%20magna%2C%20feugiat%20porttitor%20enim.%3C%2Fp%3E%3Cblockquote%3ENunc%20vel%20posuere%20tortor.%20Donec%20elementum%20purus%20nec%20hendrerit%20viverra.%20Morbi%20consectetur%2C%20ligula%20ut%20varius%20ultricies%2C%20felis%20felis%20facilisis%20libero%2C%20quis%20luctus%20massa%20leo%20at%20sapien.%20Nam%20ultricies%20lorem%20tellus%2C%20vitae%20congue%20felis%20tempor%20sit%20amet.%20Nam%20congue%20dui%20sem%2C%20at%20consequat%20tellus%20bibendum%20id.%20Vivamus%20porttitor%20augue%20a%20lorem%20suscipit%20viverra.%3C%2Fblockquote%3E%3Cp%3ENam%20venenatis%2C%20neque%20at%20euismod%20lobortis%2C%20felis%20nulla%20tristique%20metus%2C%20in%20ultricies%20elit%20nulla%20a%20turpis.%20Nam%20condimentum%20nulla%20metus%2C%20vel%20blandit%20metus%20suscipit%20suscipit.%20Vivamus%20sed%20tortor%20tortor.%20Donec%20id%20lectus%20odio.%20Vestibulum%20vel%20tortor%20ac%20nibh%20pharetra%20vestibulum%20malesuada%20sit%20amet%20felis.%20Mauris%20placerat%20ornare%20leo%20eu%20sagittis.%20Suspendisse%20eu%20consequat%20elit.%20Donec%20suscipit%20scelerisque%20ligula%2C%20ullamcorper%20luctus%20sem%20laoreet%20eget.%20Duis%20quis%20iaculis%20enim.%20Etiam%20sit%20amet%20tristique%20augue%2C%20vel%20imperdiet%20lectus.%20Aliquam%20vitae%20pharetra%20mi.%20Aenean%20turpis%20dui%2C%20ultrices%20sit%20amet%20varius%20et%2C%20dignissim%20quis%20leo.%20Vivamus%20tempus%2C%20augue%20ut%20placerat%20adipiscing%2C%20dui%20ipsum%20rutrum%20risus%2C%20in%20euismod%20mi%20nibh%20non%20urna.%20Pellentesque%20dignissim%20ut%20risus%20id%20bibendum.%20Morbi%20quis%20nulla%20luctus%2C%20interdum%20nisi%20quis%2C%20euismod%20dolor.%3C%2Fp%3E%3Ch3%3EH3%20Headline%3C%2Fh3%3E%3Cp%3EQuisque%20elementum%2C%20enim%20sagittis%20tempor%20tincidunt%2C%20sapien%20dui%20cursus%20orci%2C%20sed%20luctus%20neque%20eros%20in%20urna.%20Nunc%20gravida%20augue%20eget%20felis%20imperdiet%20lacinia.%20Duis%20feugiat%20porta%20ante%20non%20ornare.%20Duis%20mattis%2C%20magna%20rhoncus%20malesuada%20rutrum%2C%20leo%20libero%20rutrum%20lorem%2C%20vel%20rhoncus%20lorem%20risus%20id%20risus.%20Aliquam%20tincidunt%20ipsum%20vel%20turpis%20viverra%2C%20iaculis%20bibendum%20est%20bibendum.%20Nam%20luctus%20semper%20bibendum.%20Ut%20vel%20tortor%20non%20leo%20lacinia%20eleifend%20volutpat%20vitae%20dui.%20Vivamus%20accumsan%20lacus%20quam%2C%20ut%20semper%20tortor%20porta%20in.%20Sed%20dictum%20iaculis%20consequat.%20Donec%20posuere%20arcu%20mollis%2C%20sagittis%20velit%20a%2C%20viverra%20augue.%20Nunc%20blandit%20at%20est%20quis%20rhoncus.%20Donec%20egestas%20vestibulum%20orci%2C%20sit%20amet%20mattis%20metus%20elementum%20placerat.%20Maecenas%20accumsan%20mi%20in%20purus%20rutrum%2C%20convallis%20tempus%20metus%20porta.%20Proin%20blandit%20lectus%20ac%20lacus%20pharetra%2C%20in%20porttitor%20mauris%20sagittis.%3C%2Fp%3E%3Cul%3E%3Cli%3ESed%20placerat%20suscipit%3B%3C%2Fli%3E%3Cli%3ESed%20quis%20dictum%20ligula%3B%3C%2Fli%3E%3Cli%3EPraesent%20sapien%20nisl%3B%3C%2Fli%3E%3Cli%3EMaecenas%20fringilla%20purus%20odio%3B%3C%2Fli%3E%3Cli%3ENullam%20sed%20euismod%20nulla.%3C%2Fli%3E%3C%2Ful%3E%3Cp%3EQuisque%20id%20laoreet%20libero.%20Aenean%20commodo%2C%20sapien%20et%20tincidunt%20eleifend%2C%20nulla%20turpis%20egestas%20metus%2C%20in%20adipiscing%20nibh%20enim%20vel%20turpis.%20Pellentesque%20ullamcorper%20nulla%20at%20augue%20porta%20molestie.%20Donec%20eu%20augue%20rutrum%2C%20sollicitudin%20ipsum%20ac%2C%20pharetra%20urna.%20Praesent%20elementum%20tempor%20lacinia.%20Curabitur%20imperdiet%20at%20purus%20eget%20euismod.%20Nulla%20suscipit%2C%20quam%20non%20pulvinar%20iaculis%2C%20nisl%20massa%20interdum%20metus%2C%20ac%20placerat%20diam%20nibh%20sed%20mauris.%20Curabitur%20blandit%20sit%20amet%20neque%20non%20sagittis.%3C%2Fp%3E%3Cp%3ECras%20sed%20varius%20mi.%20Aenean%20lacinia%20libero%20at%20neque%20porttitor%2C%20at%20ornare%20dui%20molestie.%20Vestibulum%20vel%20nisl%20tortor.%20Duis%20non%20sem%20tortor.%20Vivamus%20non%20nisl%20vel%20lacus%20feugiat%20cursus%20a%20ac%20risus.%20Donec%20ultrices%20massa%20id%20nibh%20rutrum%20semper.%20Vestibulum%20eu%20augue%20quis%20metus%20pharetra%20semper%20ut%20in%20dui.%20Fusce%20tempor%20metus%20at%20tortor%20ornare%2C%20id%20condimentum%20diam%20congue.%20Cras%20ultrices%20nulla%20augue%2C%20et%20varius%20nibh%20ullamcorper%20adipiscing.%20Curabitur%20iaculis%20orci%20quis%20arcu%20dictum%2C%20eu%20dictum%20enim%20dignissim.%20Pellentesque%20lacinia%20elit%20vel%20enim%20ullamcorper%20congue.%3C%2Fp%3E%3Cp%3EFusce%20tristique%20sapien%20ac%20lacus%20bibendum%2C%20sit%20amet%20aliquet%20purus%20viverra.%20Sed%20congue%20ligula%20leo%2C%20vel%20ultricies%20nunc%20rhoncus%20a.%20Aenean%20at%20orci%20ac%20dui%20aliquet%20fermentum.%20Morbi%20eget%20ipsum%20in%20massa%20ultricies%20fermentum.%20Donec%20nec%20enim%20sollicitudin%2C%20volutpat%20orci%20sed%2C%20venenatis%20felis.%20Vivamus%20quis%20malesuada%20magna%2C%20eget%20blandit%20erat.%20Curabitur%20tempor%20neque%20vel%20imperdiet%20feugiat.%20Donec%20et%20ultricies%20leo.%20Nam%20non%20leo%20vitae%20justo%20mattis%20vestibulum%20et%20quis%20lacus.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Content%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%5D', '1', '2015-01-24 10:56:20', '1000', '', '0', '0000-00-00 00:00:00', '1', '2015-05-03 04:54:45', '1000', '1', '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '9', '', '_:homepage', '', '', '', '', '', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '', '9'), ('10', '195', 'Right Sidebar', 'right-sidebar', '12', '', '', '', '', '%5B%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-9%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Content%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraHtml%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%20class%3D%5C%22align-left%5C%22%3EThis%20Is%20An%20Example%20%3Cstrong%3ESidebar%3C%2Fstrong%3E%20Page%3C%2Fh2%3E%3Cfigure%3E%3Cimg%20alt%3D%5C%223%5C%22%20src%3D%5C%22images%2Fpages%2F3.jpg%5C%22%20data-mce-src%3D%5C%22images%2Fpages%2F3.jpg%5C%22%3E%3C%2Ffigure%3E%3Cp%3E%26nbsp%3B%3C%2Fp%3E%3Cp%3EQuisque%20vitae%20commodo%20est.%20Duis%20rutrum%20odio%20nec%20risus%20sagittis%20pretium.%20Etiam%20bibendum%20turpis%20in%20tellus%20tempor%2C%20eget%20convallis%20nisi%20feugiat.%20Sed%20in%20eros%20ipsum.%20Vestibulum%20viverra%20adipiscing%20commodo.%20Sed%20vel%20nulla%20augue.%20In%20pellentesque%20aliquet%20lacus%2C%20vitae%20sagittis%20orci%20dictum%20vel.%20Maecenas%20mattis%20eros%20nec%20erat%20blandit%20aliquam.%20Aliquam%20aliquet%20lobortis%20dictum.%20Integer%20interdum%20interdum%20magna%20et%20dignissim.%20Donec%20tincidunt%20elit%20libero%2C%20eu%20blandit%20mauris%20tincidunt%20ut.%20Quisque%20malesuada%20commodo%20nisi%20vitae%20varius.%20Quisque%20malesuada%20quam%20ut%20sapien%20consequat%20suscipit.%20Nullam%20vel%20turpis%20lobortis%2C%20dapibus%20tortor%20nec%2C%20blandit%20ligula.%20Praesent%20vitae%20turpis%20eget%20purus%20rhoncus%20cursus%20nec%20id%20metus.%3C%2Fp%3E%3Cp%3EPraesent%20pulvinar%20quis%20enim%20quis%20auctor.%20Nam%20condimentum%2C%20nisi%20vitae%20volutpat%20bibendum%2C%20turpis%20nisl%20malesuada%20arcu%2C%20vitae%20consequat%20nibh%20est%20quis%20dolor.%20In%20consectetur%20nec%20risus%20sed%20tempor.%20Maecenas%20eu%20est%20felis.%20Sed%20a%20elit%20eget%20ligula%20rhoncus%20fringilla%20ac%20sit%20amet%20sapien.%20Mauris%20sagittis%20lectus%20eget%20interdum%20viverra.%20Vestibulum%20nec%20nisi%20eu%20nunc%20porttitor%20tristique.%20Cras%20nunc%20quam%2C%20cursus%20id%20dictum%20ut%2C%20ultrices%20at%20sapien.%20Maecenas%20lectus%20tellus%2C%20gravida%20vitae%20mollis%20nec%2C%20vulputate%20eu%20nibh.%20Sed%20ornare%20ante%20ac%20velit%20gravida%20rhoncus.%20Ut%20vitae%20molestie%20magna%2C%20feugiat%20porttitor%20enim.%3C%2Fp%3E%3Cblockquote%3ENunc%20vel%20posuere%20tortor.%20Donec%20elementum%20purus%20nec%20hendrerit%20viverra.%20Morbi%20consectetur%2C%20ligula%20ut%20varius%20ultricies%2C%20felis%20felis%20facilisis%20libero%2C%20quis%20luctus%20massa%20leo%20at%20sapien.%20Nam%20ultricies%20lorem%20tellus%2C%20vitae%20congue%20felis%20tempor%20sit%20amet.%20Nam%20congue%20dui%20sem%2C%20at%20consequat%20tellus%20bibendum%20id.%20Vivamus%20porttitor%20augue%20a%20lorem%20suscipit%20viverra.%3C%2Fblockquote%3E%3Cp%3ENam%20venenatis%2C%20neque%20at%20euismod%20lobortis%2C%20felis%20nulla%20tristique%20metus%2C%20in%20ultricies%20elit%20nulla%20a%20turpis.%20Nam%20condimentum%20nulla%20metus%2C%20vel%20blandit%20metus%20suscipit%20suscipit.%20Vivamus%20sed%20tortor%20tortor.%20Donec%20id%20lectus%20odio.%20Vestibulum%20vel%20tortor%20ac%20nibh%20pharetra%20vestibulum%20malesuada%20sit%20amet%20felis.%20Mauris%20placerat%20ornare%20leo%20eu%20sagittis.%20Suspendisse%20eu%20consequat%20elit.%20Donec%20suscipit%20scelerisque%20ligula%2C%20ullamcorper%20luctus%20sem%20laoreet%20eget.%20Duis%20quis%20iaculis%20enim.%20Etiam%20sit%20amet%20tristique%20augue%2C%20vel%20imperdiet%20lectus.%20Aliquam%20vitae%20pharetra%20mi.%20Aenean%20turpis%20dui%2C%20ultrices%20sit%20amet%20varius%20et%2C%20dignissim%20quis%20leo.%20Vivamus%20tempus%2C%20augue%20ut%20placerat%20adipiscing%2C%20dui%20ipsum%20rutrum%20risus%2C%20in%20euismod%20mi%20nibh%20non%20urna.%20Pellentesque%20dignissim%20ut%20risus%20id%20bibendum.%20Morbi%20quis%20nulla%20luctus%2C%20interdum%20nisi%20quis%2C%20euismod%20dolor.%3C%2Fp%3E%3Ch3%3EH3%20Headline%3C%2Fh3%3E%3Cp%3EQuisque%20elementum%2C%20enim%20sagittis%20tempor%20tincidunt%2C%20sapien%20dui%20cursus%20orci%2C%20sed%20luctus%20neque%20eros%20in%20urna.%20Nunc%20gravida%20augue%20eget%20felis%20imperdiet%20lacinia.%20Duis%20feugiat%20porta%20ante%20non%20ornare.%20Duis%20mattis%2C%20magna%20rhoncus%20malesuada%20rutrum%2C%20leo%20libero%20rutrum%20lorem%2C%20vel%20rhoncus%20lorem%20risus%20id%20risus.%20Aliquam%20tincidunt%20ipsum%20vel%20turpis%20viverra%2C%20iaculis%20bibendum%20est%20bibendum.%20Nam%20luctus%20semper%20bibendum.%20Ut%20vel%20tortor%20non%20leo%20lacinia%20eleifend%20volutpat%20vitae%20dui.%20Vivamus%20accumsan%20lacus%20quam%2C%20ut%20semper%20tortor%20porta%20in.%20Sed%20dictum%20iaculis%20consequat.%20Donec%20posuere%20arcu%20mollis%2C%20sagittis%20velit%20a%2C%20viverra%20augue.%20Nunc%20blandit%20at%20est%20quis%20rhoncus.%20Donec%20egestas%20vestibulum%20orci%2C%20sit%20amet%20mattis%20metus%20elementum%20placerat.%20Maecenas%20accumsan%20mi%20in%20purus%20rutrum%2C%20convallis%20tempus%20metus%20porta.%20Proin%20blandit%20lectus%20ac%20lacus%20pharetra%2C%20in%20porttitor%20mauris%20sagittis.%3C%2Fp%3E%3Cul%3E%3Cli%3ESed%20placerat%20suscipit%3B%3C%2Fli%3E%3Cli%3ESed%20quis%20dictum%20ligula%3B%3C%2Fli%3E%3Cli%3EPraesent%20sapien%20nisl%3B%3C%2Fli%3E%3Cli%3EMaecenas%20fringilla%20purus%20odio%3B%3C%2Fli%3E%3Cli%3ENullam%20sed%20euismod%20nulla.%3C%2Fli%3E%3C%2Ful%3E%3Cp%3EQuisque%20id%20laoreet%20libero.%20Aenean%20commodo%2C%20sapien%20et%20tincidunt%20eleifend%2C%20nulla%20turpis%20egestas%20metus%2C%20in%20adipiscing%20nibh%20enim%20vel%20turpis.%20Pellentesque%20ullamcorper%20nulla%20at%20augue%20porta%20molestie.%20Donec%20eu%20augue%20rutrum%2C%20sollicitudin%20ipsum%20ac%2C%20pharetra%20urna.%20Praesent%20elementum%20tempor%20lacinia.%20Curabitur%20imperdiet%20at%20purus%20eget%20euismod.%20Nulla%20suscipit%2C%20quam%20non%20pulvinar%20iaculis%2C%20nisl%20massa%20interdum%20metus%2C%20ac%20placerat%20diam%20nibh%20sed%20mauris.%20Curabitur%20blandit%20sit%20amet%20neque%20non%20sagittis.%3C%2Fp%3E%3Cp%3ECras%20sed%20varius%20mi.%20Aenean%20lacinia%20libero%20at%20neque%20porttitor%2C%20at%20ornare%20dui%20molestie.%20Vestibulum%20vel%20nisl%20tortor.%20Duis%20non%20sem%20tortor.%20Vivamus%20non%20nisl%20vel%20lacus%20feugiat%20cursus%20a%20ac%20risus.%20Donec%20ultrices%20massa%20id%20nibh%20rutrum%20semper.%20Vestibulum%20eu%20augue%20quis%20metus%20pharetra%20semper%20ut%20in%20dui.%20Fusce%20tempor%20metus%20at%20tortor%20ornare%2C%20id%20condimentum%20diam%20congue.%20Cras%20ultrices%20nulla%20augue%2C%20et%20varius%20nibh%20ullamcorper%20adipiscing.%20Curabitur%20iaculis%20orci%20quis%20arcu%20dictum%2C%20eu%20dictum%20enim%20dignissim.%20Pellentesque%20lacinia%20elit%20vel%20enim%20ullamcorper%20congue.%3C%2Fp%3E%3Cp%3EFusce%20tristique%20sapien%20ac%20lacus%20bibendum%2C%20sit%20amet%20aliquet%20purus%20viverra.%20Sed%20congue%20ligula%20leo%2C%20vel%20ultricies%20nunc%20rhoncus%20a.%20Aenean%20at%20orci%20ac%20dui%20aliquet%20fermentum.%20Morbi%20eget%20ipsum%20in%20massa%20ultricies%20fermentum.%20Donec%20nec%20enim%20sollicitudin%2C%20volutpat%20orci%20sed%2C%20venenatis%20felis.%20Vivamus%20quis%20malesuada%20magna%2C%20eget%20blandit%20erat.%20Curabitur%20tempor%20neque%20vel%20imperdiet%20feugiat.%20Donec%20et%20ultricies%20leo.%20Nam%20non%20leo%20vitae%20justo%20mattis%20vestibulum%20et%20quis%20lacus.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Content%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Sidebar%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%2289%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Search%20Widget%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%22119%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Categories%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%2288%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Posts%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%22122%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Tags%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%22124%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Tweets%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%5D', '1', '2015-01-24 10:56:20', '1000', '', '0', '0000-00-00 00:00:00', '1', '2015-05-03 04:56:13', '1000', '1', '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '10', '', '_:homepage', '', '', '', '', '', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '', '4'), ('11', '196', 'Two Sidebars', 'two-sidebars', '12', '', '', '', '', '%5B%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Sidebar%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%2289%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Search%20Widget%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%22119%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Cats%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%2288%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Posts%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%22122%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Tags%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-6%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Content%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraHtml%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%20class%3D%5C%22align-left%5C%22%3EThis%20Is%20An%20Example%20%3Cstrong%3ESidebar%3C%2Fstrong%3E%20Page%3C%2Fh2%3E%3Cfigure%3E%3Cimg%20alt%3D%5C%223%5C%22%20src%3D%5C%22images%2Fpages%2F3.jpg%5C%22%20data-mce-src%3D%5C%22images%2Fpages%2F3.jpg%5C%22%3E%3C%2Ffigure%3E%3Cp%3E%26nbsp%3B%3C%2Fp%3E%3Cp%3EQuisque%20vitae%20commodo%20est.%20Duis%20rutrum%20odio%20nec%20risus%20sagittis%20pretium.%20Etiam%20bibendum%20turpis%20in%20tellus%20tempor%2C%20eget%20convallis%20nisi%20feugiat.%20Sed%20in%20eros%20ipsum.%20Vestibulum%20viverra%20adipiscing%20commodo.%20Sed%20vel%20nulla%20augue.%20In%20pellentesque%20aliquet%20lacus%2C%20vitae%20sagittis%20orci%20dictum%20vel.%20Maecenas%20mattis%20eros%20nec%20erat%20blandit%20aliquam.%20Aliquam%20aliquet%20lobortis%20dictum.%20Integer%20interdum%20interdum%20magna%20et%20dignissim.%20Donec%20tincidunt%20elit%20libero%2C%20eu%20blandit%20mauris%20tincidunt%20ut.%20Quisque%20malesuada%20commodo%20nisi%20vitae%20varius.%20Quisque%20malesuada%20quam%20ut%20sapien%20consequat%20suscipit.%20Nullam%20vel%20turpis%20lobortis%2C%20dapibus%20tortor%20nec%2C%20blandit%20ligula.%20Praesent%20vitae%20turpis%20eget%20purus%20rhoncus%20cursus%20nec%20id%20metus.%3C%2Fp%3E%3Cp%3EPraesent%20pulvinar%20quis%20enim%20quis%20auctor.%20Nam%20condimentum%2C%20nisi%20vitae%20volutpat%20bibendum%2C%20turpis%20nisl%20malesuada%20arcu%2C%20vitae%20consequat%20nibh%20est%20quis%20dolor.%20In%20consectetur%20nec%20risus%20sed%20tempor.%20Maecenas%20eu%20est%20felis.%20Sed%20a%20elit%20eget%20ligula%20rhoncus%20fringilla%20ac%20sit%20amet%20sapien.%20Mauris%20sagittis%20lectus%20eget%20interdum%20viverra.%20Vestibulum%20nec%20nisi%20eu%20nunc%20porttitor%20tristique.%20Cras%20nunc%20quam%2C%20cursus%20id%20dictum%20ut%2C%20ultrices%20at%20sapien.%20Maecenas%20lectus%20tellus%2C%20gravida%20vitae%20mollis%20nec%2C%20vulputate%20eu%20nibh.%20Sed%20ornare%20ante%20ac%20velit%20gravida%20rhoncus.%20Ut%20vitae%20molestie%20magna%2C%20feugiat%20porttitor%20enim.%3C%2Fp%3E%3Cblockquote%3ENunc%20vel%20posuere%20tortor.%20Donec%20elementum%20purus%20nec%20hendrerit%20viverra.%20Morbi%20consectetur%2C%20ligula%20ut%20varius%20ultricies%2C%20felis%20felis%20facilisis%20libero%2C%20quis%20luctus%20massa%20leo%20at%20sapien.%20Nam%20ultricies%20lorem%20tellus%2C%20vitae%20congue%20felis%20tempor%20sit%20amet.%20Nam%20congue%20dui%20sem%2C%20at%20consequat%20tellus%20bibendum%20id.%20Vivamus%20porttitor%20augue%20a%20lorem%20suscipit%20viverra.%3C%2Fblockquote%3E%3Cp%3ENam%20venenatis%2C%20neque%20at%20euismod%20lobortis%2C%20felis%20nulla%20tristique%20metus%2C%20in%20ultricies%20elit%20nulla%20a%20turpis.%20Nam%20condimentum%20nulla%20metus%2C%20vel%20blandit%20metus%20suscipit%20suscipit.%20Vivamus%20sed%20tortor%20tortor.%20Donec%20id%20lectus%20odio.%20Vestibulum%20vel%20tortor%20ac%20nibh%20pharetra%20vestibulum%20malesuada%20sit%20amet%20felis.%20Mauris%20placerat%20ornare%20leo%20eu%20sagittis.%20Suspendisse%20eu%20consequat%20elit.%20Donec%20suscipit%20scelerisque%20ligula%2C%20ullamcorper%20luctus%20sem%20laoreet%20eget.%20Duis%20quis%20iaculis%20enim.%20Etiam%20sit%20amet%20tristique%20augue%2C%20vel%20imperdiet%20lectus.%20Aliquam%20vitae%20pharetra%20mi.%20Aenean%20turpis%20dui%2C%20ultrices%20sit%20amet%20varius%20et%2C%20dignissim%20quis%20leo.%20Vivamus%20tempus%2C%20augue%20ut%20placerat%20adipiscing%2C%20dui%20ipsum%20rutrum%20risus%2C%20in%20euismod%20mi%20nibh%20non%20urna.%20Pellentesque%20dignissim%20ut%20risus%20id%20bibendum.%20Morbi%20quis%20nulla%20luctus%2C%20interdum%20nisi%20quis%2C%20euismod%20dolor.%3C%2Fp%3E%3Ch3%3EH3%20Headline%3C%2Fh3%3E%3Cp%3EQuisque%20elementum%2C%20enim%20sagittis%20tempor%20tincidunt%2C%20sapien%20dui%20cursus%20orci%2C%20sed%20luctus%20neque%20eros%20in%20urna.%20Nunc%20gravida%20augue%20eget%20felis%20imperdiet%20lacinia.%20Duis%20feugiat%20porta%20ante%20non%20ornare.%20Duis%20mattis%2C%20magna%20rhoncus%20malesuada%20rutrum%2C%20leo%20libero%20rutrum%20lorem%2C%20vel%20rhoncus%20lorem%20risus%20id%20risus.%20Aliquam%20tincidunt%20ipsum%20vel%20turpis%20viverra%2C%20iaculis%20bibendum%20est%20bibendum.%20Nam%20luctus%20semper%20bibendum.%20Ut%20vel%20tortor%20non%20leo%20lacinia%20eleifend%20volutpat%20vitae%20dui.%20Vivamus%20accumsan%20lacus%20quam%2C%20ut%20semper%20tortor%20porta%20in.%20Sed%20dictum%20iaculis%20consequat.%20Donec%20posuere%20arcu%20mollis%2C%20sagittis%20velit%20a%2C%20viverra%20augue.%20Nunc%20blandit%20at%20est%20quis%20rhoncus.%20Donec%20egestas%20vestibulum%20orci%2C%20sit%20amet%20mattis%20metus%20elementum%20placerat.%20Maecenas%20accumsan%20mi%20in%20purus%20rutrum%2C%20convallis%20tempus%20metus%20porta.%20Proin%20blandit%20lectus%20ac%20lacus%20pharetra%2C%20in%20porttitor%20mauris%20sagittis.%3C%2Fp%3E%3Cul%3E%3Cli%3ESed%20placerat%20suscipit%3B%3C%2Fli%3E%3Cli%3ESed%20quis%20dictum%20ligula%3B%3C%2Fli%3E%3Cli%3EPraesent%20sapien%20nisl%3B%3C%2Fli%3E%3Cli%3EMaecenas%20fringilla%20purus%20odio%3B%3C%2Fli%3E%3Cli%3ENullam%20sed%20euismod%20nulla.%3C%2Fli%3E%3C%2Ful%3E%3Cp%3EQuisque%20id%20laoreet%20libero.%20Aenean%20commodo%2C%20sapien%20et%20tincidunt%20eleifend%2C%20nulla%20turpis%20egestas%20metus%2C%20in%20adipiscing%20nibh%20enim%20vel%20turpis.%20Pellentesque%20ullamcorper%20nulla%20at%20augue%20porta%20molestie.%20Donec%20eu%20augue%20rutrum%2C%20sollicitudin%20ipsum%20ac%2C%20pharetra%20urna.%20Praesent%20elementum%20tempor%20lacinia.%20Curabitur%20imperdiet%20at%20purus%20eget%20euismod.%20Nulla%20suscipit%2C%20quam%20non%20pulvinar%20iaculis%2C%20nisl%20massa%20interdum%20metus%2C%20ac%20placerat%20diam%20nibh%20sed%20mauris.%20Curabitur%20blandit%20sit%20amet%20neque%20non%20sagittis.%3C%2Fp%3E%3Cp%3ECras%20sed%20varius%20mi.%20Aenean%20lacinia%20libero%20at%20neque%20porttitor%2C%20at%20ornare%20dui%20molestie.%20Vestibulum%20vel%20nisl%20tortor.%20Duis%20non%20sem%20tortor.%20Vivamus%20non%20nisl%20vel%20lacus%20feugiat%20cursus%20a%20ac%20risus.%20Donec%20ultrices%20massa%20id%20nibh%20rutrum%20semper.%20Vestibulum%20eu%20augue%20quis%20metus%20pharetra%20semper%20ut%20in%20dui.%20Fusce%20tempor%20metus%20at%20tortor%20ornare%2C%20id%20condimentum%20diam%20congue.%20Cras%20ultrices%20nulla%20augue%2C%20et%20varius%20nibh%20ullamcorper%20adipiscing.%20Curabitur%20iaculis%20orci%20quis%20arcu%20dictum%2C%20eu%20dictum%20enim%20dignissim.%20Pellentesque%20lacinia%20elit%20vel%20enim%20ullamcorper%20congue.%3C%2Fp%3E%3Cp%3EFusce%20tristique%20sapien%20ac%20lacus%20bibendum%2C%20sit%20amet%20aliquet%20purus%20viverra.%20Sed%20congue%20ligula%20leo%2C%20vel%20ultricies%20nunc%20rhoncus%20a.%20Aenean%20at%20orci%20ac%20dui%20aliquet%20fermentum.%20Morbi%20eget%20ipsum%20in%20massa%20ultricies%20fermentum.%20Donec%20nec%20enim%20sollicitudin%2C%20volutpat%20orci%20sed%2C%20venenatis%20felis.%20Vivamus%20quis%20malesuada%20magna%2C%20eget%20blandit%20erat.%20Curabitur%20tempor%20neque%20vel%20imperdiet%20feugiat.%20Donec%20et%20ultricies%20leo.%20Nam%20non%20leo%20vitae%20justo%20mattis%20vestibulum%20et%20quis%20lacus.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Content%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22Sidebar%20Right%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%22123%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Calendar%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%22124%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Tweets%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%5D', '1', '2015-01-24 10:56:20', '1000', '', '0', '0000-00-00 00:00:00', '4', '2015-05-03 04:56:26', '1000', '1', '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '11', '', '_:homepage', '', '', '', '', '', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '', '6'), ('12', '207', 'Full width', 'full-width', '12', '[AzuraRow animationtype=\"fade-in\" animationdelay=\"\"][AzuraColumn animationtype=\"fade-in\" animationdelay=\"\"][AzuraHtml animationtype=\"bounce\" animationdelay=\"\"]<h2 class=\"align-left\">This Is An Example <strong>Sidebar</strong> Page</h2><figure><img src=\"images/pages/3.jpg\" alt=\"3\" data-mce-src=\"images/pages/3.jpg\"></figure><p>&nbsp;</p><p>Quisque vitae commodo est. Duis rutrum odio nec risus sagittis pretium. Etiam bibendum turpis in tellus tempor, eget convallis nisi feugiat. Sed in eros ipsum. Vestibulum viverra adipiscing commodo. Sed vel nulla augue. In pellentesque aliquet lacus, vitae sagittis orci dictum vel. Maecenas mattis eros nec erat blandit aliquam. Aliquam aliquet lobortis dictum. Integer interdum interdum magna et dignissim. Donec tincidunt elit libero, eu blandit mauris tincidunt ut. Quisque malesuada commodo nisi vitae varius. Quisque malesuada quam ut sapien consequat suscipit. Nullam vel turpis lobortis, dapibus tortor nec, blandit ligula. Praesent vitae turpis eget purus rhoncus cursus nec id metus.</p><p>Praesent pulvinar quis enim quis auctor. Nam condimentum, nisi vitae volutpat bibendum, turpis nisl malesuada arcu, vitae consequat nibh est quis dolor. In consectetur nec risus sed tempor. Maecenas eu est felis. Sed a elit eget ligula rhoncus fringilla ac sit amet sapien. Mauris sagittis lectus eget interdum viverra. Vestibulum nec nisi eu nunc porttitor tristique. Cras nunc quam, cursus id dictum ut, ultrices at sapien. Maecenas lectus tellus, gravida vitae mollis nec, vulputate eu nibh. Sed ornare ante ac velit gravida rhoncus. Ut vitae molestie magna, feugiat porttitor enim.</p><blockquote>Nunc vel posuere tortor. Donec elementum purus nec hendrerit viverra. Morbi consectetur, ligula ut varius ultricies, felis felis facilisis libero, quis luctus massa leo at sapien. Nam ultricies lorem tellus, vitae congue felis tempor sit amet. Nam congue dui sem, at consequat tellus bibendum id. Vivamus porttitor augue a lorem suscipit viverra.</blockquote><p>Nam venenatis, neque at euismod lobortis, felis nulla tristique metus, in ultricies elit nulla a turpis. Nam condimentum nulla metus, vel blandit metus suscipit suscipit. Vivamus sed tortor tortor. Donec id lectus odio. Vestibulum vel tortor ac nibh pharetra vestibulum malesuada sit amet felis. Mauris placerat ornare leo eu sagittis. Suspendisse eu consequat elit. Donec suscipit scelerisque ligula, ullamcorper luctus sem laoreet eget. Duis quis iaculis enim. Etiam sit amet tristique augue, vel imperdiet lectus. Aliquam vitae pharetra mi. Aenean turpis dui, ultrices sit amet varius et, dignissim quis leo. Vivamus tempus, augue ut placerat adipiscing, dui ipsum rutrum risus, in euismod mi nibh non urna. Pellentesque dignissim ut risus id bibendum. Morbi quis nulla luctus, interdum nisi quis, euismod dolor.</p><h3>H3 Headline</h3><p>Quisque elementum, enim sagittis tempor tincidunt, sapien dui cursus orci, sed luctus neque eros in urna. Nunc gravida augue eget felis imperdiet lacinia. Duis feugiat porta ante non ornare. Duis mattis, magna rhoncus malesuada rutrum, leo libero rutrum lorem, vel rhoncus lorem risus id risus. Aliquam tincidunt ipsum vel turpis viverra, iaculis bibendum est bibendum. Nam luctus semper bibendum. Ut vel tortor non leo lacinia eleifend volutpat vitae dui. Vivamus accumsan lacus quam, ut semper tortor porta in. Sed dictum iaculis consequat. Donec posuere arcu mollis, sagittis velit a, viverra augue. Nunc blandit at est quis rhoncus. Donec egestas vestibulum orci, sit amet mattis metus elementum placerat. Maecenas accumsan mi in purus rutrum, convallis tempus metus porta. Proin blandit lectus ac lacus pharetra, in porttitor mauris sagittis.</p><ul><li>Sed placerat suscipit;</li><li>Sed quis dictum ligula;</li><li>Praesent sapien nisl;</li><li>Maecenas fringilla purus odio;</li><li>Nullam sed euismod nulla.</li></ul><p>Quisque id laoreet libero. Aenean commodo, sapien et tincidunt eleifend, nulla turpis egestas metus, in adipiscing nibh enim vel turpis. Pellentesque ullamcorper nulla at augue porta molestie. Donec eu augue rutrum, sollicitudin ipsum ac, pharetra urna. Praesent elementum tempor lacinia. Curabitur imperdiet at purus eget euismod. Nulla suscipit, quam non pulvinar iaculis, nisl massa interdum metus, ac placerat diam nibh sed mauris. Curabitur blandit sit amet neque non sagittis.</p><p>Cras sed varius mi. Aenean lacinia libero at neque porttitor, at ornare dui molestie. Vestibulum vel nisl tortor. Duis non sem tortor. Vivamus non nisl vel lacus feugiat cursus a ac risus. Donec ultrices massa id nibh rutrum semper. Vestibulum eu augue quis metus pharetra semper ut in dui. Fusce tempor metus at tortor ornare, id condimentum diam congue. Cras ultrices nulla augue, et varius nibh ullamcorper adipiscing. Curabitur iaculis orci quis arcu dictum, eu dictum enim dignissim. Pellentesque lacinia elit vel enim ullamcorper congue.</p><p>Fusce tristique sapien ac lacus bibendum, sit amet aliquet purus viverra. Sed congue ligula leo, vel ultricies nunc rhoncus a. Aenean at orci ac dui aliquet fermentum. Morbi eget ipsum in massa ultricies fermentum. Donec nec enim sollicitudin, volutpat orci sed, venenatis felis. Vivamus quis malesuada magna, eget blandit erat. Curabitur tempor neque vel imperdiet feugiat. Donec et ultricies leo. Nam non leo vitae justo mattis vestibulum et quis lacus.</p>[/AzuraHtml][/AzuraColumn][/AzuraRow]', '', '', '', '', '1', '2015-01-24 10:56:20', '1000', '', '0', '0000-00-00 00:00:00', '1', '2017-10-17 15:46:36', '1000', '1', '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '12', '{\"og_title\":\"\",\"og_description\":\"\",\"og_image\":\"\",\"tt_description\":\"\",\"tt_image\":\"\"}', '_:homepage', '', '', '', '', '', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '', '4'), ('13', '208', 'Pricing Table', 'pricing-table', '12', '[AzuraRow animationtype=\"fade-in\" animationdelay=\"\"]<h2>Pricing Tables <strong>#1</strong></h2>[AzuraColumn animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][AzuraText]<div class=\"envor-pricing-1\">\r\n  <header>\r\n    <div class=\"plan-title\">\r\n      <p>basic</p>\r\n      <small>For Individuals</small>\r\n    </div>\r\n    <div class=\"plan-price\">\r\n      <p>$4.99</p>\r\n      <small>p/mo</small>\r\n    </div>\r\n  </header>\r\n  <p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n  <ul>\r\n    <li>250 Mb Disc Space</li>\r\n    <li>5 Gb Data Transfer</li>\r\n    <li>1 Domain Name</li>\r\n    <li>2 FTP Accounts</li>\r\n    <li>2 MySQL Databases</li>\r\n    <li>Unlimited Emails</li>\r\n    <li>24/7 Support</li>\r\n  </ul>\r\n <!-- <p><a href=\"\" class=\"envor-btn envor-btn-primary envor-btn-normal\">signup now!</a></p>-->\r\n{j2storecart 17}\r\n</div>[/AzuraText][/AzuraColumn][AzuraColumn animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][AzuraText]<div class=\"envor-pricing-1\">\r\n<header>\r\n  <div class=\"plan-title\">\r\n    <p>plus</p>\r\n    <small>For small business</small>\r\n  </div>\r\n  <div class=\"plan-price\">\r\n    <p>$7.99</p>\r\n    <small>p/mo</small>\r\n  </div>\r\n</header>\r\n<p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<ul>\r\n  <li>250 Mb Disc Space</li>\r\n  <li>5 Gb Data Transfer</li>\r\n  <li>1 Domain Name</li>\r\n  <li>2 FTP Accounts</li>\r\n  <li>2 MySQL Databases</li>\r\n  <li>Unlimited Emails</li>\r\n  <li>24/7 Support</li>\r\n</ul>\r\n<!--<p><a href=\"\" class=\"envor-btn envor-btn-primary envor-btn-normal\">signup now!</a></p>-->\r\n{j2storecart 18}\r\n</div>[/AzuraText][/AzuraColumn][AzuraColumn animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][AzuraText]<div class=\"envor-pricing-1\">\r\n  <header>\r\n    <div class=\"plan-title\">\r\n      <p>pro</p>\r\n      <small>For big business</small>\r\n    </div>\r\n    <div class=\"plan-price\">\r\n      <p>$9.99</p>\r\n      <small>p/mo</small>\r\n    </div>\r\n  </header>\r\n  <p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n  <ul>\r\n    <li>250 Mb Disc Space</li>\r\n    <li>5 Gb Data Transfer</li>\r\n    <li>1 Domain Name</li>\r\n    <li>2 FTP Accounts</li>\r\n    <li>2 MySQL Databases</li>\r\n    <li>Unlimited Emails</li>\r\n    <li>24/7 Support</li>\r\n  </ul>\r\n  <!--<p><a href=\"\" class=\"envor-btn envor-btn-primary envor-btn-normal\">signup now!</a></p>-->\r\n{j2storecart 19}\r\n</div>[/AzuraText][/AzuraColumn][AzuraColumn animationtype=\"fade-in\" animationdelay=\"\" lgwidthclass=\"col-lg-3\" mdwidthclass=\"col-md-3\"][AzuraText]<div class=\"envor-pricing-1\">\r\n  <header>\r\n    <div class=\"plan-title\">\r\n      <p>extra</p>\r\n      <small>For corporate offer</small>\r\n    </div>\r\n    <div class=\"plan-price\">\r\n      <p>$11.99</p>\r\n      <small>p/mo</small>\r\n    </div>\r\n  </header>\r\n  <p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n  <ul>\r\n    <li>250 Mb Disc Space</li>\r\n    <li>5 Gb Data Transfer</li>\r\n    <li>1 Domain Name</li>\r\n    <li>2 FTP Accounts</li>\r\n    <li>2 MySQL Databases</li>\r\n    <li>Unlimited Emails</li>\r\n    <li>24/7 Support</li>\r\n  </ul>\r\n  <!--<p><a href=\"\" class=\"envor-btn envor-btn-primary envor-btn-normal\">signup now!</a></p>-->\r\n{j2storecart 20}\r\n</div>[/AzuraText][/AzuraColumn][/AzuraRow][AzuraPricingTable animationtype=\"fade-in\" animationdelay=\"\"]<h2>Pricing Tables <strong>#2</strong></h2>[AzuraPricingPlan columnwidthclass=\"col-md-15\"]<div class=\"plan\"><p>free</p><span class=\"arrow\"></span></div>\r\n<div class=\"price\">\r\n  <p>$0.00</p>\r\n  <small>p/m</small>\r\n</div>\r\n<ul>\r\n  <li><strong>10Gb</strong> Disc Space</li>\r\n  <li><strong>100Gb</strong> Bandwidth</li>\r\n  <li><strong>1</strong> Databases</li>\r\n  <li><strong>1</strong> Email Accounts</li>\r\n  <li><strong>Email</strong> Support</li>\r\n  <li><i class=\"fa fa-times\"></i></li>\r\n</ul>\r\n<!--<p class=\"pr-btn\"><a href=\"\" class=\"envor-btn envor-btn-secondary envor-btn-normal\">signup now!</a></p>-->\r\n{j2storecart 21}[/AzuraPricingPlan][AzuraPricingPlan columnwidthclass=\"col-md-15\"]<div class=\"plan\"><p>basic</p><span class=\"arrow\"></span></div>\r\n<div class=\"price\">\r\n  <p>$4.99</p>\r\n  <small>p/m</small>\r\n</div>\r\n<ul>\r\n  <li><strong>10Gb</strong> Disc Space</li>\r\n  <li><strong>100Gb</strong> Bandwidth</li>\r\n  <li><strong>1</strong> Databases</li>\r\n  <li><strong>1</strong> Email Accounts</li>\r\n  <li><strong>Email</strong> Support</li>\r\n  <li><i class=\"fa fa-times\"></i></li>\r\n</ul>\r\n<!--<p class=\"pr-btn\"><a href=\"\" class=\"envor-btn envor-btn-secondary envor-btn-normal\">signup now!</a></p>-->\r\n{j2storecart 17}[/AzuraPricingPlan][AzuraPricingPlan columnwidthclass=\"col-md-15\"]<div class=\"plan\"><p>plus</p><span class=\"arrow\"></span></div>\r\n<div class=\"price\">\r\n  <p>$7.99</p>\r\n  <small>p/m</small>\r\n</div>\r\n<ul>\r\n  <li><strong>10Gb</strong> Disc Space</li>\r\n  <li><strong>100Gb</strong> Bandwidth</li>\r\n  <li><strong>1</strong> Databases</li>\r\n  <li><strong>1</strong> Email Accounts</li>\r\n  <li><strong>Email</strong> Support</li>\r\n  <li><strong>24/7</strong> Support</li>\r\n</ul>\r\n<!--<p class=\"pr-btn\"><a href=\"\" class=\"envor-btn envor-btn-secondary envor-btn-normal\">signup now!</a></p>-->\r\n{j2storecart 18}[/AzuraPricingPlan][AzuraPricingPlan columnwidthclass=\"col-md-15\"]<div class=\"plan\"><p>pro</p><span class=\"arrow\"></span></div>\r\n                  <div class=\"price\">\r\n                    <p>$9.99</p>\r\n                    <small>p/m</small>\r\n                  </div>\r\n                  <ul>\r\n                    <li><strong>10Gb</strong> Disc Space</li>\r\n                    <li><strong>100Gb</strong> Bandwidth</li>\r\n                    <li><strong>1</strong> Databases</li>\r\n                    <li><strong>1</strong> Email Accounts</li>\r\n                    <li><strong>Email</strong> Support</li>\r\n                    <li><i class=\"fa fa-times\"></i></li>\r\n                  </ul>\r\n                  <!--<p class=\"pr-btn\"><a href=\"\" class=\"envor-btn envor-btn-secondary envor-btn-normal\">signup now!</a></p>-->\r\n{j2storecart 19}[/AzuraPricingPlan][AzuraPricingPlan columnwidthclass=\"col-md-15\"]<div class=\"plan\"><p>extra</p><span class=\"arrow\"></span></div>\r\n<div class=\"price\">\r\n  <p>$11.99</p>\r\n  <small>p/m</small>\r\n</div>\r\n<ul>\r\n  <li><strong>10Gb</strong> Disc Space</li>\r\n  <li><strong>100Gb</strong> Bandwidth</li>\r\n  <li><strong>1</strong> Databases</li>\r\n  <li><strong>1</strong> Email Accounts</li>\r\n  <li><strong>Email</strong> Support</li>\r\n  <li><i class=\"fa fa-times\"></i></li>\r\n</ul>\r\n<!--<p class=\"pr-btn\"><a href=\"\" class=\"envor-btn envor-btn-secondary envor-btn-normal\">signup now!</a></p>-->\r\n{j2storecart 20}[/AzuraPricingPlan][/AzuraPricingTable][AzuraPricingTable pstyle=\"v2\" animationtype=\"fade-in\" animationdelay=\"\"]<h2>Pricing Tables <strong>#3</strong></h2>[AzuraPricingPlan columnwidthclass=\"col-md-15\"]<div class=\"plan\"><p>free</p><span class=\"arrow\"></span></div>\r\n<div class=\"price\">\r\n  <p>$0.00</p>\r\n  <small>p/m</small>\r\n</div>\r\n<ul>\r\n  <li><strong>10Gb</strong> Disc Space</li>\r\n  <li><strong>100Gb</strong> Bandwidth</li>\r\n  <li><strong>1</strong> Databases</li>\r\n  <li><strong>1</strong> Email Accounts</li>\r\n  <li><strong>Email</strong> Support</li>\r\n  <li><i class=\"fa fa-times\"></i></li>\r\n</ul>\r\n<!--<p class=\"pr-btn\"><a href=\"\" class=\"envor-btn envor-btn-primary-border envor-btn-normal\">signup now!</a></p>-->\r\n{j2storecart 21}[/AzuraPricingPlan][AzuraPricingPlan columnwidthclass=\"col-md-15\"]<div class=\"plan\"><p>basic</p><span class=\"arrow\"></span></div>\r\n<div class=\"price\">\r\n  <p>$4.99</p>\r\n  <small>p/m</small>\r\n</div>\r\n<ul>\r\n  <li><strong>10Gb</strong> Disc Space</li>\r\n  <li><strong>100Gb</strong> Bandwidth</li>\r\n  <li><strong>1</strong> Databases</li>\r\n  <li><strong>1</strong> Email Accounts</li>\r\n  <li><strong>Email</strong> Support</li>\r\n  <li><i class=\"fa fa-times\"></i></li>\r\n</ul>\r\n<!--<p class=\"pr-btn\"><a href=\"\" class=\"envor-btn envor-btn-primary-border envor-btn-normal\">signup now!</a></p>-->\r\n{j2storecart 17}[/AzuraPricingPlan][AzuraPricingPlan columnwidthclass=\"col-md-15\"]<div class=\"plan\"><p>plus</p><span class=\"arrow\"></span></div>\r\n<div class=\"price\">\r\n  <p>$7.99</p>\r\n  <small>p/m</small>\r\n</div>\r\n<ul>\r\n  <li><strong>10Gb</strong> Disc Space</li>\r\n  <li><strong>100Gb</strong> Bandwidth</li>\r\n  <li><strong>1</strong> Databases</li>\r\n  <li><strong>1</strong> Email Accounts</li>\r\n  <li><strong>Email</strong> Support</li>\r\n  <li><strong>24/7</strong> Support</li>\r\n</ul>\r\n<!--<p class=\"pr-btn\"><a href=\"\" class=\"envor-btn envor-btn-primary envor-btn-normal\">signup now!</a></p>-->\r\n{j2storecart 18}[/AzuraPricingPlan][AzuraPricingPlan columnwidthclass=\"col-md-15\"]<div class=\"plan\"><p>pro</p><span class=\"arrow\"></span></div>\r\n                  <div class=\"price\">\r\n                    <p>$9.99</p>\r\n                    <small>p/m</small>\r\n                  </div>\r\n                  <ul>\r\n                    <li><strong>10Gb</strong> Disc Space</li>\r\n                    <li><strong>100Gb</strong> Bandwidth</li>\r\n                    <li><strong>1</strong> Databases</li>\r\n                    <li><strong>1</strong> Email Accounts</li>\r\n                    <li><strong>Email</strong> Support</li>\r\n                    <li><i class=\"fa fa-times\"></i></li>\r\n                  </ul>\r\n                  <!--<p class=\"pr-btn\"><a href=\"\" class=\"envor-btn envor-btn-primary-border envor-btn-normal\">signup now!</a></p>-->\r\n{j2storecart 19}[/AzuraPricingPlan][AzuraPricingPlan columnwidthclass=\"col-md-15\"]<div class=\"plan\"><p>extra</p><span class=\"arrow\"></span></div>\r\n<div class=\"price\">\r\n  <p>$11.99</p>\r\n  <small>p/m</small>\r\n</div>\r\n<ul>\r\n  <li><strong>10Gb</strong> Disc Space</li>\r\n  <li><strong>100Gb</strong> Bandwidth</li>\r\n  <li><strong>1</strong> Databases</li>\r\n  <li><strong>1</strong> Email Accounts</li>\r\n  <li><strong>Email</strong> Support</li>\r\n  <li><i class=\"fa fa-times\"></i></li>\r\n</ul>\r\n<!--<p class=\"pr-btn\"><a href=\"\" class=\"envor-btn envor-btn-primary-border envor-btn-normal\">signup now!</a></p>-->\r\n{j2storecart 20}[/AzuraPricingPlan][/AzuraPricingTable]', '', '', '', '', '1', '2015-01-24 13:08:24', '1000', '', '0', '0000-00-00 00:00:00', '2', '2017-10-17 16:26:05', '1000', '1', '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '13', '{\"og_title\":\"\",\"og_description\":\"\",\"og_image\":\"\",\"tt_description\":\"\",\"tt_image\":\"\"}', '_:homepage', '', '', '', '', '', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '', '13'), ('14', '199', 'Partner', 'partner', '12', '', '', '', '', '%5B%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-3%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22envor-side-navi%22%2C%22moduleid%22%3A%22116%22%2C%22chromestyle%22%3A%220%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Pages%20Navigation%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-9%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-9%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%20class%3D%5C%22align-left%5C%22%3Eour%20respective%20%3Cstrong%3Epartners%3C%2Fstrong%3E%3C%2Fh2%3E%5Cn%3Cp%3EDonec%20imperdiet%20tortor%20augue%2C%20vel%20feugiat%20risus%20accumsan%20nec.%20Duis%20posuere%20enim%20vel%20dui%20porttitor%20vestibulum.%20Integer%20posuere%20est%20et%20justo%20lobortis%20tempor%20id%20id%20elit.%20Nullam%20congue%20est%20at%20posuere%20auctor.%20Nam%20sed%20lectus%20luctus%2C%20tempus%20mauris%20vitae%2C%20dapibus%20odio.%20Donec%20sit%20amet%20iaculis%20massa%2C%20id%20posuere%20turpis.%20Donec%20dolor%20dui%2C%20accumsan%20at%20ipsum%20in%2C%20dictum%20consectetur%20mauris.%20Donec%20vulputate%20egestas%20dapibus.%20Aenean%20adipiscing%20scelerisque%20augue.%20Morbi%20varius%20magna%20vitae%20pretium%20auctor.%20Curabitur%20ultricies%20urna%20a%20pretium%20facilisis.%20Sed%20luctus%20sed%20ligula%20sed%20adipiscing.%20Ut%20eu%20leo%20auctor%2C%20tempor%20enim%20at%2C%20blandit%20tellus.%20Quisque%20commodo%2C%20orci%20eget%20iaculis%20porttitor%2C%20nisi%20mauris%20gravida%20velit%2C%20non%20pellentesque%20urna%20lectus%20vel%20elit.%3C%2Fp%3E%5Cn%3Cp%3E%26nbsp%3B%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Intro%20Text%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraPartner%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22desc%5C%22%3EAenean%20consectetur%20imperdiet%20elit%20quis%20bibendum.%20Morbi%20sit%20amet%20ullamcorper%20felis%2C%20nec%20ornare%20est.%20Mauris%20eget%20rutrum%20velit.%20Vestibulum%20ultrices%20diam%20non%20ipsum%20euismod%2C%20eget%20aliquam%20odio%20molestie.%20Cras%20at%20aliquet%20felis.%20Suspendisse%20feugiat%20lobortis%20eros%2C%20luctus%20facilisis%20felis%20rutrum%20nec.%20%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22name%22%3A%22Monica\'s%22%2C%22website%22%3A%22www.monicas-lingerie.com%22%2C%22photo%22%3A%22images%2Fpartners%2F1.png%22%2C%22extraclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%7D%2C%22name%22%3A%22Monica\'s%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraPartner%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22desc%5C%22%3EAenean%20consectetur%20imperdiet%20elit%20quis%20bibendum.%20Morbi%20sit%20amet%20ullamcorper%20felis%2C%20nec%20ornare%20est.%20Mauris%20eget%20rutrum%20velit.%20Vestibulum%20ultrices%20diam%20non%20ipsum%20euismod%2C%20eget%20aliquam%20odio%20molestie.%20Cras%20at%20aliquet%20felis.%20Suspendisse%20feugiat%20lobortis%20eros%2C%20luctus%20facilisis%20felis%20rutrum%20nec.%20%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22name%22%3A%22Pierre%20Yves%22%2C%22website%22%3A%22www.pierre-yves.com%22%2C%22photo%22%3A%22images%2Fpartners%2F2.png%22%2C%22extraclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%7D%2C%22name%22%3A%22Pierre%20Yves%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraPartner%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22desc%5C%22%3EAenean%20consectetur%20imperdiet%20elit%20quis%20bibendum.%20Morbi%20sit%20amet%20ullamcorper%20felis%2C%20nec%20ornare%20est.%20Mauris%20eget%20rutrum%20velit.%20Vestibulum%20ultrices%20diam%20non%20ipsum%20euismod%2C%20eget%20aliquam%20odio%20molestie.%20Cras%20at%20aliquet%20felis.%20Suspendisse%20feugiat%20lobortis%20eros%2C%20luctus%20facilisis%20felis%20rutrum%20nec.%20%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22name%22%3A%22Leeroy%20Jacks%20CO.%22%2C%22website%22%3A%22www.leeroy-jacks.com%22%2C%22photo%22%3A%22images%2Fpartners%2F3.png%22%2C%22extraclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%7D%2C%22name%22%3A%22Leeroy%20Jacks%20CO.%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraPartner%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22desc%5C%22%3EAenean%20consectetur%20imperdiet%20elit%20quis%20bibendum.%20Morbi%20sit%20amet%20ullamcorper%20felis%2C%20nec%20ornare%20est.%20Mauris%20eget%20rutrum%20velit.%20Vestibulum%20ultrices%20diam%20non%20ipsum%20euismod%2C%20eget%20aliquam%20odio%20molestie.%20Cras%20at%20aliquet%20felis.%20Suspendisse%20feugiat%20lobortis%20eros%2C%20luctus%20facilisis%20felis%20rutrum%20nec.%20%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22name%22%3A%22El%20Nutricionista%22%2C%22website%22%3A%22www.el-nutricionista.com%22%2C%22photo%22%3A%22images%2Fpartners%2F4.png%22%2C%22extraclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%7D%2C%22name%22%3A%22El%20Nutricionista%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraPartner%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22desc%5C%22%3EAenean%20consectetur%20imperdiet%20elit%20quis%20bibendum.%20Morbi%20sit%20amet%20ullamcorper%20felis%2C%20nec%20ornare%20est.%20Mauris%20eget%20rutrum%20velit.%20Vestibulum%20ultrices%20diam%20non%20ipsum%20euismod%2C%20eget%20aliquam%20odio%20molestie.%20Cras%20at%20aliquet%20felis.%20Suspendisse%20feugiat%20lobortis%20eros%2C%20luctus%20facilisis%20felis%20rutrum%20nec.%20%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22name%22%3A%22Jazzcastle%22%2C%22website%22%3A%22www.jazzcastle.com%22%2C%22photo%22%3A%22images%2Fpartners%2F5.png%22%2C%22extraclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%7D%2C%22name%22%3A%22Jazzcastle%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraPartner%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22desc%5C%22%3EAenean%20consectetur%20imperdiet%20elit%20quis%20bibendum.%20Morbi%20sit%20amet%20ullamcorper%20felis%2C%20nec%20ornare%20est.%20Mauris%20eget%20rutrum%20velit.%20Vestibulum%20ultrices%20diam%20non%20ipsum%20euismod%2C%20eget%20aliquam%20odio%20molestie.%20Cras%20at%20aliquet%20felis.%20Suspendisse%20feugiat%20lobortis%20eros%2C%20luctus%20facilisis%20felis%20rutrum%20nec.%20%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22name%22%3A%22The%20Night%20Ligths%22%2C%22website%22%3A%22www.the-night-lights.com%22%2C%22photo%22%3A%22images%2Fpartners%2F6.png%22%2C%22extraclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%7D%2C%22name%22%3A%22The%20Night%20Ligths%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%5D', '1', '2015-01-24 13:08:24', '1000', '', '0', '0000-00-00 00:00:00', '4', '2015-05-03 04:57:20', '1000', '1', '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '14', '', '_:homepage', '', '', '', '', '', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '', '6');
INSERT INTO `#__azurapagebuilder_pages` VALUES ('15', '200', 'Career', 'career', '12', '', '', '', '', '%5B%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-3%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22envor-side-navi%22%2C%22moduleid%22%3A%22116%22%2C%22chromestyle%22%3A%220%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Pages%20Navigation%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-9%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-9%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%20class%3D%5C%22align-left%5C%22%3Ecareer%3C%2Fh2%3E%5Cn%3Cp%3EIn%20commodo%20interdum%20quam%2C%20sed%20rutrum%20dui%20vulputate%20in.%20Praesent%20tempus%20viverra%20adipiscing.%20Fusce%20lacinia%20lectus%20eu%20magna%20pharetra%2C%20sit%20amet%20tempus%20nibh%20adipiscing.%20Quisque%20sit%20amet%20lacinia%20ligula.%20Aliquam%20quis%20magna%20blandit%2C%20gravida%20enim%20non%2C%20convallis%20leo.%20Quisque%20iaculis%20sem%20purus%2C%20sed%20cursus%20diam%20tincidunt%20sed.%20Interdum%20et%20malesuada%20fames%20ac%20ante%20ipsum%20primis%20in%20faucibus.%20Duis%20varius%20felis%20erat%2C%20quis%20fermentum%20felis%20sagittis%20lacinia.%3C%2Fp%3E%5Cn%3Cp%3E%26nbsp%3B%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22IntroText%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cdiv%20class%3D%5C%22envor-career-1%5C%22%3E%5Cn%20%20%3Cheader%3E%5Cn%20%20%20%20%3Ci%20class%3D%5C%22fa%20fa-user%5C%22%3E%3C%2Fi%3E%5Cn%20%20%20%20%3Csmall%3EJob%20Description%3C%2Fsmall%3E%5Cn%20%20%20%20%3Cp%3EMarketing%20Program%20Administrator%3C%2Fp%3E%5Cn%20%20%3C%2Fheader%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22details%5C%22%3E%5Cn%20%20%20%20%3Cp%20class%3D%5C%22title%5C%22%3EOverview%3A%3C%2Fp%3E%5Cn%20%20%20%20%3Cp%3EPraesent%20feugiat%20eget%20leo%20sed%20facilisis.%20Sed%20accumsan%20velit%20vel%20nisl%20pellentesque%20tempor.%20Maecenas%20urna%20mauris%2C%20feugiat%20et%20mauris%20ut%2C%20euismod%20sodales%20justo.%20Curabitur%20eget%20enim%20lorem.%20Praesent%20et%20libero%20sed%20dui%20adipiscing%20rutrum%20eu%20nec%20eros.%20Praesent%20a%20fringilla%20enim%2C%20vitae%20malesuada%20sem.%20Phasellus%20luctus%20facilisis%20urna%20eget%20vestibulum.%3C%2Fp%3E%5Cn%20%20%20%20%3Cp%3ECurabitur%20varius%20est%20a%20tortor%20iaculis%20pulvinar.%20Vestibulum%20accumsan%20tellus%20vel%20justo%20pretium%2C%20quis%20consequat%20leo%20consequat.%20Lorem%20ipsum%20dolor%20sit%20amet%2C%20consectetur%20adipiscing%20elit.%20Donec%20arcu%20purus%2C%20congue%20eu%20ligula%20quis%2C%20faucibus%20lacinia%20libero.%20Aliquam%20vulputate%20justo%20et%20ullamcorper%20ultrices.%20Sed%20a%20lorem%20dictum%20felis%20hendrerit%20mollis.%20Integer%20vel%20sapien%20turpis.%20Phasellus%20semper%20mauris%20venenatis%20massa%20feugiat%2C%20ut%20cursus%20odio%20pulvinar.%20Praesent%20sodales%20nec%20sapien%20sed%20ultricies.%20Nullam%20a%20dolor%20sollicitudin%2C%20sollicitudin%20velit%20quis%2C%20blandit%20quam.%20Sed%20pharetra%20nulla%20a%20sagittis%20commodo.%20Cras%20in%20placerat%20mi.%20Fusce%20lorem%20ante%2C%20venenatis%20id%20eleifend%20a%2C%20blandit%20vel%20quam.%20Proin%20lacinia%20nisi%20velit%2C%20eu%20malesuada%20metus%20semper%20nec.%3C%2Fp%3E%5Cn%20%20%20%20%3Cp%20class%3D%5C%22title%5C%22%3ESkills%3A%3C%2Fp%3E%5Cn%20%20%20%20%3Cul%20class%3D%5C%22e-color-list%5C%22%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20HTML5%3C%2Fli%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20CSS3%3C%2Fli%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20JavaScript%3C%2Fli%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20PHP5%3C%2Fli%3E%5Cn%20%20%20%20%3C%2Ful%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22ca-btn%5C%22%3E%5Cn%20%20%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-small%5C%22%3Eapply%20now!%3C%2Fa%3E%5Cn%20%20%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-secondary%20envor-btn-small%20show-details%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-plus%5C%22%3E%3C%2Fi%3E%20details%3C%2Fa%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%3C%2Fdiv%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Marketing%20Program%20Administrator%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cdiv%20class%3D%5C%22envor-career-1%5C%22%3E%5Cn%20%20%3Cheader%3E%5Cn%20%20%20%20%3Ci%20class%3D%5C%22fa%20fa-user%5C%22%3E%3C%2Fi%3E%5Cn%20%20%20%20%3Csmall%3EJob%20Description%3C%2Fsmall%3E%5Cn%20%20%20%20%3Cp%3EEnvironmental%20Engineer%3C%2Fp%3E%5Cn%20%20%3C%2Fheader%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22details%5C%22%3E%5Cn%20%20%20%20%3Cp%20class%3D%5C%22title%5C%22%3EOverview%3A%3C%2Fp%3E%5Cn%20%20%20%20%3Cp%3EPraesent%20feugiat%20eget%20leo%20sed%20facilisis.%20Sed%20accumsan%20velit%20vel%20nisl%20pellentesque%20tempor.%20Maecenas%20urna%20mauris%2C%20feugiat%20et%20mauris%20ut%2C%20euismod%20sodales%20justo.%20Curabitur%20eget%20enim%20lorem.%20Praesent%20et%20libero%20sed%20dui%20adipiscing%20rutrum%20eu%20nec%20eros.%20Praesent%20a%20fringilla%20enim%2C%20vitae%20malesuada%20sem.%20Phasellus%20luctus%20facilisis%20urna%20eget%20vestibulum.%3C%2Fp%3E%5Cn%20%20%20%20%3Cp%3ECurabitur%20varius%20est%20a%20tortor%20iaculis%20pulvinar.%20Vestibulum%20accumsan%20tellus%20vel%20justo%20pretium%2C%20quis%20consequat%20leo%20consequat.%20Lorem%20ipsum%20dolor%20sit%20amet%2C%20consectetur%20adipiscing%20elit.%20Donec%20arcu%20purus%2C%20congue%20eu%20ligula%20quis%2C%20faucibus%20lacinia%20libero.%20Aliquam%20vulputate%20justo%20et%20ullamcorper%20ultrices.%20Sed%20a%20lorem%20dictum%20felis%20hendrerit%20mollis.%20Integer%20vel%20sapien%20turpis.%20Phasellus%20semper%20mauris%20venenatis%20massa%20feugiat%2C%20ut%20cursus%20odio%20pulvinar.%20Praesent%20sodales%20nec%20sapien%20sed%20ultricies.%20Nullam%20a%20dolor%20sollicitudin%2C%20sollicitudin%20velit%20quis%2C%20blandit%20quam.%20Sed%20pharetra%20nulla%20a%20sagittis%20commodo.%20Cras%20in%20placerat%20mi.%20Fusce%20lorem%20ante%2C%20venenatis%20id%20eleifend%20a%2C%20blandit%20vel%20quam.%20Proin%20lacinia%20nisi%20velit%2C%20eu%20malesuada%20metus%20semper%20nec.%3C%2Fp%3E%5Cn%20%20%20%20%3Cp%20class%3D%5C%22title%5C%22%3ESkills%3A%3C%2Fp%3E%5Cn%20%20%20%20%3Cul%20class%3D%5C%22e-color-list%5C%22%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20HTML5%3C%2Fli%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20CSS3%3C%2Fli%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20JavaScript%3C%2Fli%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20PHP5%3C%2Fli%3E%5Cn%20%20%20%20%3C%2Ful%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22ca-btn%5C%22%3E%5Cn%20%20%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-small%5C%22%3Eapply%20now!%3C%2Fa%3E%5Cn%20%20%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-secondary%20envor-btn-small%20show-details%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-plus%5C%22%3E%3C%2Fi%3E%20details%3C%2Fa%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%3C%2Fdiv%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Environmental%20Engineer%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cdiv%20class%3D%5C%22envor-career-1%5C%22%3E%5Cn%20%20%3Cheader%3E%5Cn%20%20%20%20%3Ci%20class%3D%5C%22fa%20fa-user%5C%22%3E%3C%2Fi%3E%5Cn%20%20%20%20%3Csmall%3EJob%20Description%3C%2Fsmall%3E%5Cn%20%20%20%20%3Cp%3EHRIT%20Director%3C%2Fp%3E%5Cn%20%20%3C%2Fheader%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22details%5C%22%3E%5Cn%20%20%20%20%3Cp%20class%3D%5C%22title%5C%22%3EOverview%3A%3C%2Fp%3E%5Cn%20%20%20%20%3Cp%3EPraesent%20feugiat%20eget%20leo%20sed%20facilisis.%20Sed%20accumsan%20velit%20vel%20nisl%20pellentesque%20tempor.%20Maecenas%20urna%20mauris%2C%20feugiat%20et%20mauris%20ut%2C%20euismod%20sodales%20justo.%20Curabitur%20eget%20enim%20lorem.%20Praesent%20et%20libero%20sed%20dui%20adipiscing%20rutrum%20eu%20nec%20eros.%20Praesent%20a%20fringilla%20enim%2C%20vitae%20malesuada%20sem.%20Phasellus%20luctus%20facilisis%20urna%20eget%20vestibulum.%3C%2Fp%3E%5Cn%20%20%20%20%3Cp%3ECurabitur%20varius%20est%20a%20tortor%20iaculis%20pulvinar.%20Vestibulum%20accumsan%20tellus%20vel%20justo%20pretium%2C%20quis%20consequat%20leo%20consequat.%20Lorem%20ipsum%20dolor%20sit%20amet%2C%20consectetur%20adipiscing%20elit.%20Donec%20arcu%20purus%2C%20congue%20eu%20ligula%20quis%2C%20faucibus%20lacinia%20libero.%20Aliquam%20vulputate%20justo%20et%20ullamcorper%20ultrices.%20Sed%20a%20lorem%20dictum%20felis%20hendrerit%20mollis.%20Integer%20vel%20sapien%20turpis.%20Phasellus%20semper%20mauris%20venenatis%20massa%20feugiat%2C%20ut%20cursus%20odio%20pulvinar.%20Praesent%20sodales%20nec%20sapien%20sed%20ultricies.%20Nullam%20a%20dolor%20sollicitudin%2C%20sollicitudin%20velit%20quis%2C%20blandit%20quam.%20Sed%20pharetra%20nulla%20a%20sagittis%20commodo.%20Cras%20in%20placerat%20mi.%20Fusce%20lorem%20ante%2C%20venenatis%20id%20eleifend%20a%2C%20blandit%20vel%20quam.%20Proin%20lacinia%20nisi%20velit%2C%20eu%20malesuada%20metus%20semper%20nec.%3C%2Fp%3E%5Cn%20%20%20%20%3Cp%20class%3D%5C%22title%5C%22%3ESkills%3A%3C%2Fp%3E%5Cn%20%20%20%20%3Cul%20class%3D%5C%22e-color-list%5C%22%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20HTML5%3C%2Fli%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20CSS3%3C%2Fli%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20JavaScript%3C%2Fli%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20PHP5%3C%2Fli%3E%5Cn%20%20%20%20%3C%2Ful%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22ca-btn%5C%22%3E%5Cn%20%20%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-small%5C%22%3Eapply%20now!%3C%2Fa%3E%5Cn%20%20%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-secondary%20envor-btn-small%20show-details%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-plus%5C%22%3E%3C%2Fi%3E%20details%3C%2Fa%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%3C%2Fdiv%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22HRIT%20Director%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cdiv%20class%3D%5C%22envor-career-1%5C%22%3E%5Cn%20%20%3Cheader%3E%5Cn%20%20%20%20%3Ci%20class%3D%5C%22fa%20fa-user%5C%22%3E%3C%2Fi%3E%5Cn%20%20%20%20%3Csmall%3EJob%20Description%3C%2Fsmall%3E%5Cn%20%20%20%20%3Cp%3ETax%20Director%3C%2Fp%3E%5Cn%20%20%3C%2Fheader%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22details%5C%22%3E%5Cn%20%20%20%20%3Cp%20class%3D%5C%22title%5C%22%3EOverview%3A%3C%2Fp%3E%5Cn%20%20%20%20%3Cp%3EPraesent%20feugiat%20eget%20leo%20sed%20facilisis.%20Sed%20accumsan%20velit%20vel%20nisl%20pellentesque%20tempor.%20Maecenas%20urna%20mauris%2C%20feugiat%20et%20mauris%20ut%2C%20euismod%20sodales%20justo.%20Curabitur%20eget%20enim%20lorem.%20Praesent%20et%20libero%20sed%20dui%20adipiscing%20rutrum%20eu%20nec%20eros.%20Praesent%20a%20fringilla%20enim%2C%20vitae%20malesuada%20sem.%20Phasellus%20luctus%20facilisis%20urna%20eget%20vestibulum.%3C%2Fp%3E%5Cn%20%20%20%20%3Cp%3ECurabitur%20varius%20est%20a%20tortor%20iaculis%20pulvinar.%20Vestibulum%20accumsan%20tellus%20vel%20justo%20pretium%2C%20quis%20consequat%20leo%20consequat.%20Lorem%20ipsum%20dolor%20sit%20amet%2C%20consectetur%20adipiscing%20elit.%20Donec%20arcu%20purus%2C%20congue%20eu%20ligula%20quis%2C%20faucibus%20lacinia%20libero.%20Aliquam%20vulputate%20justo%20et%20ullamcorper%20ultrices.%20Sed%20a%20lorem%20dictum%20felis%20hendrerit%20mollis.%20Integer%20vel%20sapien%20turpis.%20Phasellus%20semper%20mauris%20venenatis%20massa%20feugiat%2C%20ut%20cursus%20odio%20pulvinar.%20Praesent%20sodales%20nec%20sapien%20sed%20ultricies.%20Nullam%20a%20dolor%20sollicitudin%2C%20sollicitudin%20velit%20quis%2C%20blandit%20quam.%20Sed%20pharetra%20nulla%20a%20sagittis%20commodo.%20Cras%20in%20placerat%20mi.%20Fusce%20lorem%20ante%2C%20venenatis%20id%20eleifend%20a%2C%20blandit%20vel%20quam.%20Proin%20lacinia%20nisi%20velit%2C%20eu%20malesuada%20metus%20semper%20nec.%3C%2Fp%3E%5Cn%20%20%20%20%3Cp%20class%3D%5C%22title%5C%22%3ESkills%3A%3C%2Fp%3E%5Cn%20%20%20%20%3Cul%20class%3D%5C%22e-color-list%5C%22%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20HTML5%3C%2Fli%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20CSS3%3C%2Fli%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20JavaScript%3C%2Fli%3E%5Cn%20%20%20%20%20%20%3Cli%3E%3Ci%20class%3D%5C%22glyphicon%20glyphicon-check%5C%22%3E%3C%2Fi%3E%20PHP5%3C%2Fli%3E%5Cn%20%20%20%20%3C%2Ful%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%20%20%3Cdiv%20class%3D%5C%22ca-btn%5C%22%3E%5Cn%20%20%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-small%5C%22%3Eapply%20now!%3C%2Fa%3E%5Cn%20%20%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-secondary%20envor-btn-small%20show-details%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-plus%5C%22%3E%3C%2Fi%3E%20details%3C%2Fa%3E%5Cn%20%20%3C%2Fdiv%3E%5Cn%3C%2Fdiv%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Tax%20Director%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%5D', '1', '2015-01-24 13:08:24', '1000', '', '0', '0000-00-00 00:00:00', '1', '2015-05-03 04:57:32', '1000', '1', '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '15', '', '_:homepage', '', '', '', '', '', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '', '7'), ('16', '201', 'FAQ', 'faq', '12', '', '', '', '', '%5B%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22FAQ%20Section%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-9%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch2%3EChoose%20Questions%20%3Cstrong%3ECategory%3C%2Fstrong%3E%3C%2Fh2%3E%5Cn%3Cp%3ECurabitur%20consequat%20diam%20nec%20massa%20gravida%20pulvinar.%20Sed%20tempor%2C%20enim%20nec%20venenatis%20aliquet%2C%20velit%20orci%20facilisis%20diam%2C%20at%20pulvinar%20arcu%20est%20in%20arcu.%20Curabitur%20lectus%20metus%2C%20blandit%20sed%20neque%20vitae%2C%20rhoncus%20pellentesque%20tellus.%20In%20tempor%20lorem%20ac%20ipsum%20eleifend%2C%20sed%20tempor%20sem%20ultricies.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Intro%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaq%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22extraclass%22%3A%22%22%2C%22showfilter%22%3A%221%22%2C%22layout%22%3A%22envor%3Aazurafaq%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraFaqItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EFusce%20imperdiet%20est%20a%20feugiat%20vehicula.%20Pellentesque%20tempor%20feugiat%20lectus%20vitae%20feugiat.%20Nulla%20aliquet%2C%20diam%20non%20gravida%20iaculis%2C%20nulla%20metus%20bibendum%20ante%2C%20vel%20vehicula%20justo%20ligula%20ac%20dui.%20Vivamus%20lorem%20sem%2C%20scelerisque%20et%20mollis%20et%2C%20vestibulum%20at%20nisl.%20Aenean%20sagittis%20vulputate%20nulla%20a%20tristique.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22globe%22%2C%22question%22%3A%22Sed%20consectetur%20nunc%20eget%20sem%22%2C%22filter%22%3A%22CSS%22%2C%22extraclass%22%3A%22%22%7D%2C%22name%22%3A%22Faq%201%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaqItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3ENullam%20ultricies%20ullamcorper%20nunc%2C%20sit%20amet%20pretium%20turpis%20elementum%20eu.%20Sed%20sodales%20libero%20odio%2C%20vel%20mattis%20nulla%20malesuada%20a.%20Suspendisse%20facilisis%20turpis%20quis%20ante%20interdum%2C%20ut%20tempor%20lectus%20interdum.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22%22%2C%22question%22%3A%22Mauris%20risus%20ante%2C%20volutpat%20eu%20malesuada%22%2C%22filter%22%3A%22HTML%2CCSS%22%2C%22extraclass%22%3A%22%22%7D%2C%22name%22%3A%22Faq%202%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaqItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EMauris%20non%20lacus%20consectetur%2C%20iaculis%20ligula%20at%2C%20tempus%20elit.%20Donec%20vel%20tortor%20non%20nunc%20venenatis%20lobortis.%20Pellentesque%20sapien%20diam%2C%20vestibulum%20id%20risus%20fringilla%2C%20fermentum%20bibendum%20ipsum.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22info-sign%22%2C%22question%22%3A%22Maecenas%20a%20laoreet%20augue%22%2C%22filter%22%3A%22Javascript%2CHTML%22%2C%22extraclass%22%3A%22%22%7D%2C%22name%22%3A%22Faq%203%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaqItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3ENullam%20viverra%20metus%20sed%20odio%20dignissim%20suscipit.%20Class%20aptent%20taciti%20sociosqu%20ad%20litora%20torquent%20per%20conubia%20nostra%2C%20per%20inceptos%20himenaeos.%20Sed%20ut%20neque%20vitae%20ipsum%20auctor%20adipiscing.%20Mauris%20porta%20nulla%20at%20tellus%20eleifend%2C%20id%20dictum%20quam%20aliquam.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22phone-alt%22%2C%22question%22%3A%22Vestibulum%20eu%20felis%20vehicula%20tortor%22%2C%22filter%22%3A%22Joomla%2CCSS%22%2C%22extraclass%22%3A%22%22%7D%2C%22name%22%3A%22Faq%204%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaqItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3ECum%20sociis%20natoque%20penatibus%20et%20magnis%20dis%20parturient%20montes%2C%20nascetur%20ridiculus%20mus.%20Curabitur%20dictum%20malesuada%20ligula%20vel%20vestibulum.%20Maecenas%20mattis%20facilisis%20mollis.%20Vivamus%20molestie%20id%20sem%20non%20congue.%20Aliquam%20congue%20semper%20congue.%20Ut%20id%20metus%20nibh.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22%22%2C%22question%22%3A%22Mauris%20vitae%20turpis%20ante%22%2C%22filter%22%3A%22Design%22%2C%22extraclass%22%3A%22%22%7D%2C%22name%22%3A%22Faq%205%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaqItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EFusce%20imperdiet%20est%20a%20feugiat%20vehicula.%20Pellentesque%20tempor%20feugiat%20lectus%20vitae%20feugiat.%20Nulla%20aliquet%2C%20diam%20non%20gravida%20iaculis%2C%20nulla%20metus%20bibendum%20ante%2C%20vel%20vehicula%20justo%20ligula%20ac%20dui.%20Vivamus%20lorem%20sem%2C%20scelerisque%20et%20mollis%20et%2C%20vestibulum%20at%20nisl.%20Aenean%20sagittis%20vulputate%20nulla%20a%20tristique.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22globe%22%2C%22question%22%3A%22Sed%20consectetur%20nunc%20eget%20sem%22%2C%22filter%22%3A%22CSS%2CJoomla%22%2C%22extraclass%22%3A%22%22%7D%2C%22name%22%3A%22Faq%206%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaqItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3ENullam%20ultricies%20ullamcorper%20nunc%2C%20sit%20amet%20pretium%20turpis%20elementum%20eu.%20Sed%20sodales%20libero%20odio%2C%20vel%20mattis%20nulla%20malesuada%20a.%20Suspendisse%20facilisis%20turpis%20quis%20ante%20interdum%2C%20ut%20tempor%20lectus%20interdum.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22%22%2C%22question%22%3A%22Mauris%20risus%20ante%2C%20volutpat%20eu%20malesuada%22%2C%22filter%22%3A%22Javascript%2CHTML%22%2C%22extraclass%22%3A%22%22%7D%2C%22name%22%3A%22Faq%207%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaqItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EMauris%20non%20lacus%20consectetur%2C%20iaculis%20ligula%20at%2C%20tempus%20elit.%20Donec%20vel%20tortor%20non%20nunc%20venenatis%20lobortis.%20Pellentesque%20sapien%20diam%2C%20vestibulum%20id%20risus%20fringilla%2C%20fermentum%20bibendum%20ipsum.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22info-sign%22%2C%22question%22%3A%22Maecenas%20a%20laoreet%20augue%22%2C%22filter%22%3A%22Javascript%22%2C%22extraclass%22%3A%22%22%7D%2C%22name%22%3A%22Faq%208%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaqItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3ENullam%20viverra%20metus%20sed%20odio%20dignissim%20suscipit.%20Class%20aptent%20taciti%20sociosqu%20ad%20litora%20torquent%20per%20conubia%20nostra%2C%20per%20inceptos%20himenaeos.%20Sed%20ut%20neque%20vitae%20ipsum%20auctor%20adipiscing.%20Mauris%20porta%20nulla%20at%20tellus%20eleifend%2C%20id%20dictum%20quam%20aliquam.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22phone-alt%22%2C%22question%22%3A%22Vestibulum%20eu%20felis%20vehicula%20tortor%22%2C%22filter%22%3A%22Joomla%22%2C%22extraclass%22%3A%22%22%7D%2C%22name%22%3A%22Faq%209%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaqItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3ECum%20sociis%20natoque%20penatibus%20et%20magnis%20dis%20parturient%20montes%2C%20nascetur%20ridiculus%20mus.%20Curabitur%20dictum%20malesuada%20ligula%20vel%20vestibulum.%20Maecenas%20mattis%20facilisis%20mollis.%20Vivamus%20molestie%20id%20sem%20non%20congue.%20Aliquam%20congue%20semper%20congue.%20Ut%20id%20metus%20nibh.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22%22%2C%22question%22%3A%22Mauris%20vitae%20turpis%20ante%22%2C%22filter%22%3A%22Design%2CHTML%22%2C%22extraclass%22%3A%22%22%7D%2C%22name%22%3A%22Faq%2010%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaqItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EFusce%20imperdiet%20est%20a%20feugiat%20vehicula.%20Pellentesque%20tempor%20feugiat%20lectus%20vitae%20feugiat.%20Nulla%20aliquet%2C%20diam%20non%20gravida%20iaculis%2C%20nulla%20metus%20bibendum%20ante%2C%20vel%20vehicula%20justo%20ligula%20ac%20dui.%20Vivamus%20lorem%20sem%2C%20scelerisque%20et%20mollis%20et%2C%20vestibulum%20at%20nisl.%20Aenean%20sagittis%20vulputate%20nulla%20a%20tristique.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22globe%22%2C%22question%22%3A%22Sed%20consectetur%20nunc%20eget%20sem%22%2C%22filter%22%3A%22CSS%2CJavascript%22%2C%22extraclass%22%3A%22%22%7D%2C%22name%22%3A%22Faq%2011%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaqItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3ENullam%20ultricies%20ullamcorper%20nunc%2C%20sit%20amet%20pretium%20turpis%20elementum%20eu.%20Sed%20sodales%20libero%20odio%2C%20vel%20mattis%20nulla%20malesuada%20a.%20Suspendisse%20facilisis%20turpis%20quis%20ante%20interdum%2C%20ut%20tempor%20lectus%20interdum.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22%22%2C%22question%22%3A%22Mauris%20risus%20ante%2C%20volutpat%20eu%20malesuada%22%2C%22filter%22%3A%22Joomla%22%2C%22extraclass%22%3A%22%22%7D%2C%22name%22%3A%22Faq%2012%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaqItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EMauris%20non%20lacus%20consectetur%2C%20iaculis%20ligula%20at%2C%20tempus%20elit.%20Donec%20vel%20tortor%20non%20nunc%20venenatis%20lobortis.%20Pellentesque%20sapien%20diam%2C%20vestibulum%20id%20risus%20fringilla%2C%20fermentum%20bibendum%20ipsum.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22info-sign%22%2C%22question%22%3A%22Maecenas%20a%20laoreet%20augue%22%2C%22filter%22%3A%22HTML%22%2C%22extraclass%22%3A%22%22%7D%2C%22name%22%3A%22Faq%2013%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaqItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3ENullam%20viverra%20metus%20sed%20odio%20dignissim%20suscipit.%20Class%20aptent%20taciti%20sociosqu%20ad%20litora%20torquent%20per%20conubia%20nostra%2C%20per%20inceptos%20himenaeos.%20Sed%20ut%20neque%20vitae%20ipsum%20auctor%20adipiscing.%20Mauris%20porta%20nulla%20at%20tellus%20eleifend%2C%20id%20dictum%20quam%20aliquam.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22phone-alt%22%2C%22question%22%3A%22Vestibulum%20eu%20felis%20vehicula%20tortor%22%2C%22filter%22%3A%22Javascript%2CHTML%22%2C%22extraclass%22%3A%22%22%7D%2C%22name%22%3A%22Faq%2014%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaqItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3ECum%20sociis%20natoque%20penatibus%20et%20magnis%20dis%20parturient%20montes%2C%20nascetur%20ridiculus%20mus.%20Curabitur%20dictum%20malesuada%20ligula%20vel%20vestibulum.%20Maecenas%20mattis%20facilisis%20mollis.%20Vivamus%20molestie%20id%20sem%20non%20congue.%20Aliquam%20congue%20semper%20congue.%20Ut%20id%20metus%20nibh.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22%22%2C%22question%22%3A%22Mauris%20vitae%20turpis%20ante%22%2C%22filter%22%3A%22Design%22%2C%22extraclass%22%3A%22%22%7D%2C%22name%22%3A%22Faq%2015%22%2C%22children%22%3A%5B%5D%7D%5D%2C%22name%22%3A%22%22%7D%2C%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3E%26nbsp%3B%3C%2Fp%3E%5Cn%3Ch2%3EMore%20%3Cstrong%3EInformation%3C%2Fstrong%3E%3C%2Fh2%3E%5Cn%3Cp%3EDonec%20malesuada%20sit%20amet%20felis%20a%20tempus.%20Curabitur%20mauris%20libero%2C%20malesuada%20eget%20velit%20quis%2C%20mollis%20porta%20dolor.%20Nam%20laoreet%20consequat%20tortor%2C%20eu%20ullamcorper%20ante%20sollicitudin%20vitae.%20Maecenas%20in%20nibh%20quis%20tortor%20ullamcorper%20vulputate.%20Fusce%20eu%20sagittis%20lacus%2C%20vitae%20fringilla%20justo.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22More%20Information%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaq2%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3ESuspendisse%20in%20laoreet%20massa%2C%20in%20egestas%20dolor.%20Suspendisse%20convallis%20consequat%20metus%2C%20at%20iaculis%20odio%20congue%20laoreet.%20Sed%20scelerisque%20euismod%20est%20et%20fermentum.%20%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22%22%2C%22question%22%3A%22Sed%20commodo%20rhoncus%20lobortis%3F%22%2C%22extraclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Faq%201%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaq2%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EPellentesque%20ac%20iaculis%20tortor.%20Donec%20lacus%20felis%2C%20commodo%20dapibus%20viverra%20sed%2C%20gravida%20ut%20urna.%20Donec%20interdum%20volutpat%20nibh%2C%20in%20euismod%20felis.%20Pellentesque%20sit%20amet%20eleifend%20sapien.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22%22%2C%22question%22%3A%22Nulla%20aliquet%2C%20turpis%20sit%20amet%20rhoncus%20viverra%2C%20metus%20ipsum%20ullamcorper%3F%22%2C%22extraclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Faq%202%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaq2%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EInteger%20egestas%20quis%20mi%20ac%20vulputate.%20Etiam%20dictum%20dolor%20sit%20amet%20turpis%20ultrices%20scelerisque.%20Ut%20tincidunt%20iaculis%20urna%2C%20eget%20vestibulum%20tortor%20sollicitudin%20vitae.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22%22%2C%22question%22%3A%22Vestibulum%20scelerisque%20ornare%20magna%20id%20luctus%3F%22%2C%22extraclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Faq%203%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaq2%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EMauris%20ornare%20tincidunt%20ante%20vestibulum%20tincidunt.%20In%20vitae%20augue%20et%20nisl%20vehicula%20gravida.%20Lorem%20ipsum%20dolor%20sit%20amet%2C%20consectetur%20adipiscing%20elit.%20Aenean%20fermentum%2C%20erat%20in%20sodales%20pretium%2C%20mauris%20lorem%20tincidunt%20nibh%2C%20ut%20viverra%20lorem%20nisl%20ac%20sem.%20%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22%22%2C%22question%22%3A%22Aenean%20ac%20auctor%20lorem%3F%22%2C%22extraclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Faq%204%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraFaq2%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EPellentesque%20scelerisque%20faucibus%20eros%20sit%20amet%20convallis.%20Praesent%20a%20enim%20lorem.%20Etiam%20tempus%20placerat%20massa%20non%20aliquam.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22icon%22%3A%22%22%2C%22question%22%3A%22Nam%20convallis%2C%20diam%20vel%20convallis%20fringilla%3F%22%2C%22extraclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Faq%205%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-3%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%2289%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Search%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%22119%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Categories%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%2288%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Recent%20Posts%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraModule%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22extraclass%22%3A%22%22%2C%22moduleid%22%3A%22124%22%2C%22chromestyle%22%3A%22Envor-envor%22%2C%22showtitle%22%3A%220%22%2C%22layout%22%3A%22_%3Aazuramodule-none%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Recent%20Tweets%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%5D', '1', '2015-01-24 13:08:24', '1000', '', '0', '0000-00-00 00:00:00', '7', '2015-05-03 04:57:46', '1000', '1', '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '16', '', '_:homepage', '', '', '', '', '', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '', '11'), ('17', '202', 'Elements', 'elements', '12', '', '', '', '', '%5B%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Buttons%20-%20Skills%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-6%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-6%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch3%3Ebuttons%3C%2Fh3%3E%5Cn%3Cp%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-small%5C%22%3Ebutton%20text%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-normal%5C%22%3Ebutton%20text%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-large%5C%22%3Ebutton%20text%3C%2Fa%3E%5Cn%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Primary%20-%20Buttons%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-secondary%20envor-btn-small%5C%22%3Ebutton%20text%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-secondary%20envor-btn-normal%5C%22%3Ebutton%20text%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-secondary%20envor-btn-large%5C%22%3Ebutton%20text%3C%2Fa%3E%5Cn%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Secondary%20-%20Buttons%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary-border%20envor-btn-small%5C%22%3Ebutton%20text%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary-border%20envor-btn-normal%5C%22%3Ebutton%20text%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary-border%20envor-btn-large%5C%22%3Ebutton%20text%3C%2Fa%3E%5Cn%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Primary%20Border%20-%20Buttons%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-secondary-border%20envor-btn-small%5C%22%3Ebutton%20text%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-secondary-border%20envor-btn-normal%5C%22%3Ebutton%20text%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%20class%3D%5C%22envor-btn%20envor-btn-secondary-border%20envor-btn-large%5C%22%3Ebutton%20text%3C%2Fa%3E%5Cn%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Secondary%20Border%20-%20Buttons%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-6%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-6%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch3%3Eskills%3C%2Fh3%3E%5Cn%3Cdiv%20class%3D%5C%22envor-skill-2%5C%22%20data-name%3D%5C%22HTML5%5C%22%20data-value%3D%5C%2289%25%5C%22%3E%3C%2Fdiv%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22HTML5%20-%20Skill%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cdiv%20class%3D%5C%22envor-skill-2%5C%22%20data-name%3D%5C%22CSS3%5C%22%20data-value%3D%5C%2282%25%5C%22%3E%3C%2Fdiv%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22CSS3%20-%20Skill%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cdiv%20class%3D%5C%22envor-skill-2%5C%22%20data-name%3D%5C%22JavaScript%5C%22%20data-value%3D%5C%2279%25%5C%22%3E%3C%2Fdiv%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22JavaScript%20-%20Skill%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cdiv%20class%3D%5C%22envor-skill-2%5C%22%20data-name%3D%5C%22PHP%5C%22%20data-value%3D%5C%2275%25%5C%22%3E%3C%2Fdiv%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22PHP%20-%20Skill%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cdiv%20class%3D%5C%22envor-skill-2%5C%22%20data-name%3D%5C%22Joomla%5C%22%20data-value%3D%5C%2295%25%5C%22%3E%3C%2Fdiv%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Joomla%20-%20Skill%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cdiv%20class%3D%5C%22envor-skill-2%5C%22%20data-name%3D%5C%22Marketing%5C%22%20data-value%3D%5C%2284%25%5C%22%3E%3C%2Fdiv%3E%5Cn%3Cdiv%20class%3D%5C%22envor-skill-2%5C%22%20data-name%3D%5C%22Sales%5C%22%20data-value%3D%5C%2291%25%5C%22%3E%3C%2Fdiv%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Others%20%20-%20Skill%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%220px%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Toggle%20-%20Tabs%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-6%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-6%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch3%3EAccordion%20-%20Toggle%3C%2Fh3%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Title%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraAccordion%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22defaultActive%22%3A%220%22%2C%22acctype%22%3A%22accordion%22%2C%22layout%22%3A%22envor%3Aazuraaccordion-envor%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraAccordionItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EFusce%20imperdiet%20est%20a%20feugiat%20vehicula.%20Pellentesque%20tempor%20feugiat%20lectus%20vitae%20feugiat.%20Nulla%20aliquet%2C%20diam%20non%20gravida%20iaculis%2C%20nulla%20metus%20bibendum%20ante%2C%20vel%20vehicula%20justo%20ligula%20ac%20dui.%20Vivamus%20lorem%20sem%2C%20scelerisque%20et%20mollis%20et%2C%20vestibulum%20at%20nisl.%20Aenean%20sagittis%20vulputate%20nulla%20a%20tristique.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22title%22%3A%22--globe--%20Sed%20consectetur%20nunc%20eget%20sem%22%2C%22subtitle%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%7D%2C%22name%22%3A%22Sed%20consectetur%20nunc%20eget%20sem%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraAccordionItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3ENullam%20ultricies%20ullamcorper%20nunc%2C%20sit%20amet%20pretium%20turpis%20elementum%20eu.%20Sed%20sodales%20libero%20odio%2C%20vel%20mattis%20nulla%20malesuada%20a.%20Suspendisse%20facilisis%20turpis%20quis%20ante%20interdum%2C%20ut%20tempor%20lectus%20interdum.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22title%22%3A%22Mauris%20risus%20ante%2C%20volutpat%20eu%20malesuada%22%2C%22subtitle%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%7D%2C%22name%22%3A%22Mauris%20risus%20ante%2C%20volutpat%20eu%20malesuada%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraAccordionItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EMauris%20non%20lacus%20consectetur%2C%20iaculis%20ligula%20at%2C%20tempus%20elit.%20Donec%20vel%20tortor%20non%20nunc%20venenatis%20lobortis.%20Pellentesque%20sapien%20diam%2C%20vestibulum%20id%20risus%20fringilla%2C%20fermentum%20bibendum%20ipsum.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22title%22%3A%22--info-sign--%20Maecenas%20a%20laoreet%20augue%22%2C%22subtitle%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%7D%2C%22name%22%3A%22Maecenas%20a%20laoreet%20augue%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraAccordionItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3ENullam%20viverra%20metus%20sed%20odio%20dignissim%20suscipit.%20Class%20aptent%20taciti%20sociosqu%20ad%20litora%20torquent%20per%20conubia%20nostra%2C%20per%20inceptos%20himenaeos.%20Sed%20ut%20neque%20vitae%20ipsum%20auctor%20adipiscing.%20Mauris%20porta%20nulla%20at%20tellus%20eleifend%2C%20id%20dictum%20quam%20aliquam.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22title%22%3A%22--phone-alt--%20Vestibulum%20eu%20felis%20vehicula%20tortor%22%2C%22subtitle%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%7D%2C%22name%22%3A%22Vestibulum%20eu%20felis%20vehicula%20tortor%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraAccordionItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3ECum%20sociis%20natoque%20penatibus%20et%20magnis%20dis%20parturient%20montes%2C%20nascetur%20ridiculus%20mus.%20Curabitur%20dictum%20malesuada%20ligula%20vel%20vestibulum.%20Maecenas%20mattis%20facilisis%20mollis.%20Vivamus%20molestie%20id%20sem%20non%20congue.%20Aliquam%20congue%20semper%20congue.%20Ut%20id%20metus%20nibh.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22title%22%3A%22Mauris%20vitae%20turpis%20ante%22%2C%22subtitle%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%7D%2C%22name%22%3A%22Mauris%20vitae%20turpis%20ante%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-6%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-6%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch3%3ETabs%3C%2Fh3%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Title%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTabs%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22defaultactive%22%3A%221%22%2C%22tabstyle%22%3A%22tab%22%2C%22usejustified%22%3A%221%22%2C%22fade%22%3A%221%22%2C%22layout%22%3A%22envor%3Aazuratabs-envor%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraTabsItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ci%20class%3D%5C%22glyphicon%20glyphicon-flag%5C%22%3E%3C%2Fi%3E%5Cn%3Cp%3EMorbi%20hendrerit%20dolor%20nec%20pretium%20malesuada.%20Mauris%20fringilla%20blandit%20tortor%20condimentum%20tempor.%20Proin%20dictum%20accumsan%20pellentesque.%20In%20elementum%2C%20mauris%20vel%20feugiat%20faucibus%2C%20quam%20metus%20ultricies%20erat%2C%20quis%20pretium%20leo%20lacus%20sit%20amet%20ligula.%20Ut%20a%20pellentesque%20ligula.%20In%20aliquam%20turpis%20eget%20tellus%20viverra%2C%20convallis%20ultricies%20elit%20suscipit.%3C%2Fp%3E%5Cn%3Cp%3EUt%20euismod%2C%20mi%20vitae%20facilisis%20tincidunt%2C%20lacus%20arcu%20dictum%20nisl%2C%20in%20egestas%20mi%20magna%20in%20sem.%20Suspendisse%20ultrices%20quam%20eget%20est%20iaculis%2C%20id%20pulvinar%20dolor%20sodales.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22title%22%3A%22Lovely%22%7D%2C%22name%22%3A%22Lovely%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTabsItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cdiv%20class%3D%5C%22dropcap%5C%22%3EN%3C%2Fdiv%3E%5Cn%3Cp%3Eullam%20pharetra%20mattis%20condimentum.%20Maecenas%20venenatis%20aliquet%20dui%20eu%20scelerisque.%20Proin%20nec%20magna%20vel%20lacus%20pretium%20interdum.%20Nam%20eu%20leo%20id%20arcu%20hendrerit%20semper.%20Phasellus%20bibendum%20est%20dignissim%20posuere%20lobortis.%20Sed%20a%20mollis%20est.%20Mauris%20at%20ipsum%20nec%20dui%20fermentum%20bibendum.%20Nullam%20non%20convallis%20enim.%20Quisque%20ornare%20tellus%20ac%20mi%20tincidunt%2C%20non%20auctor%20enim%20cursus.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22title%22%3A%22Exquisite%22%7D%2C%22name%22%3A%22Exquisite%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTabsItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EMaecenas%20quis%20bibendum%20arcu.%20Vestibulum%20placerat%20nunc%20nunc%2C%20at%20rhoncus%20dui%20lacinia%20quis.%20Morbi%20eu%20tortor%20tristique%2C%20semper%20metus%20a%2C%20molestie%20urna.%20Curabitur%20volutpat%20ante%20eros%2C%20eu%20hendrerit%20enim%20ullamcorper%20accumsan.%20Sed%20ipsum%20lectus%2C%20volutpat%20a%20nisi%20in%2C%20euismod%20porta%20elit.%20Vivamus%20viverra%20eu%20sapien%20ut%20aliquam.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22title%22%3A%22Glorious%22%7D%2C%22name%22%3A%22Glorious%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTabsItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EMauris%20porta%20eleifend%20nisi%20sit%20amet%20interdum.%20Donec%20et%20lorem%20eu%20lacus%20aliquam%20tristique%20ut%20eget%20enim.%20Nam%20congue%2C%20leo%20vel%20ullamcorper%20mattis%2C%20ante%20metus%20suscipit%20odio%2C%20et%20convallis%20justo%20justo%20ac%20eros.%20Mauris%20iaculis%20neque%20at%20elit%20laoreet%2C%20nec%20blandit%20risus%20auctor.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22title%22%3A%22Stunning%22%7D%2C%22name%22%3A%22Stunning%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%220px%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22CTA%20-%20Message%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-6%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-6%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch3%3Efeatured%20%3Cstrong%3Ebox%3C%2Fstrong%3E%3C%2Fh3%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Title%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cdiv%20class%3D%5C%22envor-featured-box%5C%22%3E%5Cn%20%20%3Ch3%3E%3Cstrong%3Ebox%3C%2Fstrong%3E%20headline%3C%2Fh3%3E%5Cn%20%20%3Cp%3ELorem%20ipsum%20dolor%20sit%20amet%2C%20consectetur%20adipisicing%20elit%2C%20sed%20do%20eiusmod%20tempor%20incididunt%20ut%20labore%20et%20dolore%20magna%20aliqua.%20Ut%20enim%20ad%20minim%20veniam%2C%20quis%20nostrud%20exercitation%20ullamco%20laboris%20nisi%20ut%20aliquip%20ex%20ea%20commodo%20consequat.%3C%2Fp%3E%5Cn%20%20%3Cp%3E%3Ca%20href%3D%5C%22http%3A%2F%2Fthemeforest.net%2Fuser%2Fcththemes%2Fportfolio%3Fref%3Dcththemes%5C%22%20class%3D%5C%22envor-btn%20envor-btn-primary%20envor-btn-normal%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-arrow-circle-o-down%5C%22%3E%3C%2Fi%3E%20button%20text%3C%2Fa%3E%3C%2Fp%3E%5Cn%3C%2Fdiv%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Call%20to%20action%22%2C%22children%22%3A%5B%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%2C%22id%22%3A%22%22%2C%22class%22%3A%22%22%2C%22wrapclass%22%3A%22%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%2C%22lgoffsetclass%22%3A%22%22%2C%22lgwidthclass%22%3A%22col-lg-6%22%2C%22mdoffsetclass%22%3A%22%22%2C%22mdwidthclass%22%3A%22col-md-6%22%2C%22smoffsetclass%22%3A%22%22%2C%22xsoffsetclass%22%3A%22%22%2C%22xswidthclass%22%3A%22%22%7D%2C%22name%22%3A%22%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch3%3Emessages%3C%2Fh3%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22Title%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraAlert%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EThis%20is%20success%20message.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22type%22%3A%22success%22%2C%22closebtn%22%3A%221%22%2C%22fadeeffect%22%3A%221%22%2C%22extraclass%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazuraalert-envor%22%2C%22title%22%3A%22success!%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%2232%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22success%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraAlert%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EThis%20is%20error%20message.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22type%22%3A%22danger%22%2C%22closebtn%22%3A%221%22%2C%22fadeeffect%22%3A%221%22%2C%22extraclass%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazuraalert-envor%22%2C%22title%22%3A%22error!%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%2232%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22error%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraAlert%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EThis%20is%20info%20message.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22type%22%3A%22info%22%2C%22closebtn%22%3A%221%22%2C%22fadeeffect%22%3A%221%22%2C%22extraclass%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazuraalert-envor%22%2C%22title%22%3A%22info!%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%2232%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22info%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraAlert%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%3EThis%20is%20attention%20message.%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22type%22%3A%22warning%22%2C%22closebtn%22%3A%221%22%2C%22fadeeffect%22%3A%221%22%2C%22extraclass%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazuraalert-envor%22%2C%22title%22%3A%22attention!%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22attention%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%2C%7B%22type%22%3A%22AzuraRow%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22id%22%3A%22%22%2C%22secclass%22%3A%22envor-section%22%2C%22class%22%3A%22%22%2C%22layoutwidth%22%3A%221%22%2C%22stellar%22%3A%22%22%2C%22layout%22%3A%22envor%3Aazurarow-section%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%220px%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Our%20Team%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraColumn%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22columnwidthclass%22%3A%22col-md-12%22%7D%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraText%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Ch3%20class%3D%5C%22align-center%5C%22%3E%3Cstrong%3Eour%3C%2Fstrong%3E%20team%3C%2Fh3%3E%22%2C%22attrs%22%3A%7B%7D%2C%22name%22%3A%22title%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTeamSlider%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%22%2C%22attrs%22%3A%7B%22extraclass%22%3A%22%22%2C%22selector%22%3A%22envor-team-1%22%2C%22visible%22%3A%224%22%2C%22shownavigation%22%3A%221%22%2C%22navigationpos%22%3A%22center%22%2C%22margin_top%22%3A%22%22%2C%22margin_right%22%3A%22%22%2C%22margin_bottom%22%3A%22%22%2C%22margin_left%22%3A%22%22%2C%22border_top_width%22%3A%22%22%2C%22border_right_width%22%3A%22%22%2C%22border_bottom_width%22%3A%22%22%2C%22border_left_width%22%3A%22%22%2C%22padding_top%22%3A%22%22%2C%22padding_right%22%3A%22%22%2C%22padding_bottom%22%3A%22%22%2C%22padding_left%22%3A%22%22%2C%22border_color%22%3A%22%22%2C%22border_style%22%3A%22%22%2C%22background_color%22%3A%22%22%2C%22background_image%22%3A%22%22%2C%22background_repeat%22%3A%22%22%2C%22background_attachment%22%3A%22%22%2C%22background_size%22%3A%22%22%2C%22additional_style%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Our%20Team%22%2C%22children%22%3A%5B%7B%22type%22%3A%22AzuraTeamSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22role%5C%22%3Edeveloper%3C%2Fp%3E%5Cn%3Cp%3EUt%20risus%20quam%2C%20lacinia%20id%20porta%20eu%2C%20pellentesque%20sed%20risus.%20Aenean%20sed%20magna%20ac%20ligula%20ultrices%20consectetur.%3C%2Fp%3E%5Cn%3Cp%20class%3D%5C%22links%5C%22%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-facebook%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-twitter%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-linkedin%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-envelope%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22job%22%3A%22Hi%20there!%20My%20name%20is%22%2C%22name%22%3A%22Anthony%20A.%20Schmidt%22%2C%22photo%22%3A%22images%2Fteam%2F1.jpg%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Anthony%20A.%20Schmidt%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTeamSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22role%5C%22%3Edeveloper%3C%2Fp%3E%5Cn%3Cp%3EMauris%20vel%20diam%20a%20purus%20lobortis%20malesuada.%20Nam%20tincidunt%20tortor%20quis%20ultricies%20ultricies.%3C%2Fp%3E%5Cn%3Cp%20class%3D%5C%22links%5C%22%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-facebook%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-twitter%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-linkedin%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-envelope%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22job%22%3A%22Hi%20there!%20My%20name%20is%22%2C%22name%22%3A%22Nadine%20F.%20Spears%22%2C%22photo%22%3A%22images%2Fteam%2F2.jpg%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Nadine%20F.%20Spears%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTeamSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22role%5C%22%3Edeveloper%3C%2Fp%3E%5Cn%3Cp%3EMauris%20tincidunt%20fringilla%20erat%20at%20dictum.%20Morbi%20justo%20lacus%2C%20mollis%20sit%20amet%20sodales%20quis%2C%20mattis%20ut%20dui.%20Fusce%20porttitor%20rhoncus%20enim.%3C%2Fp%3E%5Cn%3Cp%20class%3D%5C%22links%5C%22%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-facebook%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-twitter%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-linkedin%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-envelope%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22job%22%3A%22Hi%20there!%20My%20name%20is%22%2C%22name%22%3A%22Dennis%20A.%20Pendleton%22%2C%22photo%22%3A%22images%2Fteam%2F3.jpg%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Dennis%20A.%20Pendleton%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTeamSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22role%5C%22%3Edeveloper%3C%2Fp%3E%5Cn%3Cp%3ESed%20quis%20sagittis%20urna%2C%20ac%20commodo%20dolor.%20Nunc%20tincidunt%20volutpat%20sagittis.%20Proin%20eu%20massa%20gravida%2C%20euismod%20justo%20nec%2C%20sollicitudin%20tellus.%3C%2Fp%3E%5Cn%3Cp%20class%3D%5C%22links%5C%22%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-facebook%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-twitter%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-linkedin%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-envelope%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22job%22%3A%22Hi%20there!%20My%20name%20is%22%2C%22name%22%3A%22Marjorie%20L.%20Penland%22%2C%22photo%22%3A%22images%2Fteam%2F4.jpg%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Marjorie%20L.%20Penland%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTeamSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22role%5C%22%3Edeveloper%3C%2Fp%3E%5Cn%3Cp%3EMorbi%20at%20lorem%20mollis%2C%20fermentum%20eros%20eu%2C%20mollis%20metus.%20Cras%20consectetur%20quam%20vitae%20urna%20elementum%20sodales.%3C%2Fp%3E%5Cn%3Cp%20class%3D%5C%22links%5C%22%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-facebook%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-twitter%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-linkedin%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-envelope%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22job%22%3A%22Hi%20there!%20My%20name%20is%22%2C%22name%22%3A%22Jerry%20C.%20Schneider%22%2C%22photo%22%3A%22images%2Fteam%2F5.jpg%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Jerry%20C.%20Schneider%22%2C%22children%22%3A%5B%5D%7D%2C%7B%22type%22%3A%22AzuraTeamSliderItem%22%2C%22id%22%3A%220%22%2C%22published%22%3A%221%22%2C%22language%22%3A%22*%22%2C%22content%22%3A%22%3Cp%20class%3D%5C%22role%5C%22%3Edeveloper%3C%2Fp%3E%5Cn%3Cp%3ENam%20malesuada%20risus%20nulla%2C%20sit%20amet%20sodales%20orci%20lacinia%20nec.%20Curabitur%20nec%20convallis%20quam.%3C%2Fp%3E%5Cn%3Cp%20class%3D%5C%22links%5C%22%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-facebook%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-twitter%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-linkedin%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%20%20%3Ca%20href%3D%5C%22%5C%22%3E%3Ci%20class%3D%5C%22fa%20fa-envelope%5C%22%3E%3C%2Fi%3E%3C%2Fa%3E%5Cn%3C%2Fp%3E%22%2C%22attrs%22%3A%7B%22job%22%3A%22Hi%20there!%20My%20name%20is%22%2C%22name%22%3A%22Minnie%20B.%20Young%22%2C%22photo%22%3A%22images%2Fteam%2F6.jpg%22%2C%22extraclass%22%3A%22%22%2C%22columnwidthclass%22%3A%22%22%2C%22animation%22%3A%220%22%2C%22animationtype%22%3A%22fade-in%22%2C%22hoveranimationtype%22%3A%22flash%22%2C%22animationdelay%22%3A%22%22%2C%22infinite%22%3A%220%22%7D%2C%22name%22%3A%22Minnie%20B.%20Young%22%2C%22children%22%3A%5B%5D%7D%5D%7D%5D%7D%5D%7D%5D', '1', '2015-01-24 13:08:24', '1000', '', '0', '0000-00-00 00:00:00', '1', '2015-05-03 04:58:06', '1000', '1', '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '17', '', '_:homepage', '', '', '', '', '', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '', '10');
