<?php
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;

class AzuraPagebuilderViewPage extends JViewLegacy
{
	protected $item;

	protected $params;

	protected $print;

	protected $state;

	protected $user;
	
	public function display($tpl = null)
	{
		$app        = JFactory::getApplication();
		$user       = JFactory::getUser();
		$state      = $this->get('State');
		$item       = $this->get('Item');

		// Get the parameters
		$params = JComponentHelper::getParams('com_azurapagebuilder');

		if ($item)
		{
			// If we found an item, merge the item parameters
			$params->merge($item->params);

		}

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseWarning(500, implode("\n", $errors));

			return false;
		}

		// // Check if access is not public
		// $groups = $user->getAuthorisedViewLevels();

		// if ((!in_array($item->access, $groups)) || (!in_array($item->category_access, $groups)))
		// {
		// 	$app->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'), 'error');
		// 	$app->setHeader('status', 403, true);

		// 	return false;
		// }

		// Check the view access to the article (the model has already computed the values).
		if ($item->params->get('access-view') == false && ($item->params->get('show_noauth', '0') == '0'))
		{
			$app->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'), 'error');
			$app->setHeader('status', 403, true);

			return false;
		}

		/* Check for no 'access-view' and empty fulltext,
		 * - Redirect guest users to login
		 * - Deny access to logged users with 403 code
		 * NOTE: we do not recheck for no access-view + show_noauth disabled ... since it was checked above
		 */
		// if ($item->params->get('access-view') == false && !strlen($item->fulltext))
		// {
		// 	if ($this->user->get('guest'))
		// 	{
		// 		$return = base64_encode(JUri::getInstance());
		// 		$login_url_with_return = JRoute::_('index.php?option=com_users&return=' . $return);
		// 		$app->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'), 'notice');
		// 		$app->redirect($login_url_with_return, 403);
		// 	}
		// 	else
		// 	{
		// 		$app->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'), 'error');
		// 		$app->setHeader('status', 403, true);
		// 		return;
		// 	}
		// }


		// Add router helpers.
		$item->slug			= $item->alias ? ($item->id.':'.$item->alias) : $item->id;
		$item->catslug		= $item->category_alias ? ($item->catid.':'.$item->category_alias) : $item->catid;
		// $item->parent_slug	= $item->parent_alias ? ($item->parent_id . ':' . $item->parent_alias) : $item->parent_id;

		// // No link for ROOT category
		// if ($item->parent_alias == 'root')
		// {
		// 	$item->parent_slug = null;
		// }

		// // TODO: Change based on shownoauth
		// $item->readmore_link = JRoute::_(AzuraPagebuilderHelperRoute::getPageRoute($item->slug, $item->catslug));

		$item->readmore_link = JRoute::_(AzuraPagebuilderHelperRoute::getPageRoute($item->slug, $item->catid));

		// Escape strings for HTML output
		$this->pageclass_sfx = htmlspecialchars($params->get('pageclass_sfx'));

		$this->params      = &$params;
		$this->state       = &$state;
		$this->item        = &$item;
		$this->user        = &$user;

		$item->tags = new JHelperTags;
		$item->tags->getItemTags('com_azurapagebuilder.page', $this->item->id);
		$item->tagLayout = new JLayoutFile('joomla.content.tags');

		// Override the layout only if this is not the active menu item
		// If it is the active menu item, then the view and item id will match
		$active = $app->getMenu()->getActive();

		// Check to see which parameters should take priority
		if ($active)
		{
			$currentLink = $active->link;

			// If the current view is the active item and an article view for this article, then the menu item params take priority
			if (strpos($currentLink, 'view=page') && strpos($currentLink, '&id=' . (string) $item->id))
			{
				// Load layout from active query (in case it is an alternative menu item)
				if (isset($active->query['layout']))
				{
					$this->setLayout($active->query['layout']);
				}
				// Check for alternative layout of article
				elseif($item->alt_layout !== '_:default'){
					$this->setLayout($item->alt_layout);
				}

				// $item->params are the article params, $temp are the menu item params
				// Merge so that the menu item params take priority
				//$item->params->merge($temp);
			}
			else
			{
				// Current view is not a single article, so the article params take priority here
				// Merge the menu item params with the article params so that the article params take priority
				// $temp->merge($item->params);
				// $item->params = $temp;

				// Check for alternative layouts (since we are not in a single-article menu item)
				// Single-article menu item layout takes priority over alt layout for an article
				if ($item->alt_layout !== '_:default')
				{
					$this->setLayout($item->alt_layout);
				}
			}
		}
		else
		{
			// Merge so that article params take priority
			// $temp->merge($item->params);
			// $item->params = $temp;

			// Check for alternative layouts (since we are not in a single-article menu item)
			// Single-article menu item layout takes priority over alt layout for an article
			if ($item->alt_layout !== '_:default')
			{
				$this->setLayout($item->alt_layout);
			}
		}


		// if ((!$active) || ((strpos($active->link, 'view=page') === false) || (strpos($active->link, '&id=' . (string) $this->item->id) === false)))
		// {
		// 	// if ($layout = $params->get('page_layout'))
		// 	// {
		// 	// 	$this->setLayout($layout);
		// 	// }
		// 	if($item->alt_layout !== '_:default'){//die;
		// 		$this->setLayout($item->alt_layout);
		// 	}
		// }
		// elseif (isset($active->query['layout']))
		// {
		// 	// We need to set the layout in case this is an alternative menu item (with an alternative layout)
		// 	$this->setLayout($active->query['layout']);
		// }

		$model = $this->getModel();
		$model->hit();

		// new in version 2.2
		$item->page_likes	= $this->get('PageLikes');


		$this->_prepareDocument();

		parent::display($tpl);



		// $app		= JFactory::getApplication();
		// $user		= JFactory::getUser();
		// $dispatcher = JEventDispatcher::getInstance();

		// $this->item		= $this->get('Item');
		// $this->print	= $app->input->getBool('print');
		// $this->state	= $this->get('State');
		// $this->user		= $user;

		// // Check for errors.
		// if (count($errors = $this->get('Errors')))
		// {
		// 	JError::raiseWarning(500, implode("\n", $errors));
		// 	return false;
		// }

		// // Create a shortcut for $item.
		// $item = $this->item;
		// if($item->alt_layout !== '_:default'){//die;
		// 	$this->setLayout($item->alt_layout);
		// }

		// $item->tagLayout = new JLayoutFile('joomla.content.tags');

		// // Add router helpers.
		// $item->slug			= $item->alias ? ($item->id.':'.$item->alias) : $item->id;
		// $item->catslug		= $item->category_alias ? ($item->catid.':'.$item->category_alias) : $item->catid;
		// $item->parent_slug	= $item->parent_alias ? ($item->parent_id . ':' . $item->parent_alias) : $item->parent_id;

		// // No link for ROOT category
		// if ($item->parent_alias == 'root')
		// {
		// 	$item->parent_slug = null;
		// }

		// // TODO: Change based on shownoauth
		// $item->readmore_link = JRoute::_(AzuraPagebuilderHelperRoute::getPageRoute($item->slug, $item->catslug));

		// // Merge page params. If this is single-page view, menu params override page params
		// // Otherwise, page params override menu item params
		// $this->params = $this->state->get('params');
		// $active = $app->getMenu()->getActive();
		// $temp = clone ($this->params);

		// // Check to see which parameters should take priority
		// if ($active)
		// {
		// 	$currentLink = $active->link;

		// 	// If the current view is the active item and an page view for this page, then the menu item params take priority
		// 	if (strpos($currentLink, 'view=page') && (strpos($currentLink, '&id='.(string) $item->id)))
		// 	{
				
		// 		// $item->params are the page params, $temp are the menu item params
		// 		// Merge so that the menu item params take priority
		// 		$item->params->merge($temp);
		// 	}
		// 	else
		// 	{
		// 		// Current view is not a single page, so the page params take priority here
		// 		// Merge the menu item params with the page params so that the page params take priority
		// 		$temp->merge($item->params);
		// 		$item->params = $temp;

		// 	}
		// }
		// else
		// {
		// 	// Merge so that page params take priority
		// 	$temp->merge($item->params);
		// 	$item->params = $temp;
		// }

		// //echo'<pre>';var_dump($this->item->params);die;

		// $offset = $this->state->get('list.offset');

		// // Check the view access to the page (the model has already computed the values).
		// if ($item->params->get('access-view') == false && ($item->params->get('show_noauth', '0') == '0'))
		// {
		// 	JError::raiseWarning(403, JText::_('COM_AZP_ALERTNOAUTHOR'));
		// 	return;
		// }

		// $item->tags = new JHelperTags;
		// $item->tags->getItemTags('com_azurapagebuilder.page', $this->item->id);

		// // new in version 2.2
		// $item->page_likes	= $this->get('PageLikes');

		// // Increment the hit counter of the page.
		// if (!$this->params->get('intro_only') && $offset == 0)
		// {
		// 	$model = $this->getModel();
		// 	$model->hit();
		// }

		// $this->pageclass_sfx = htmlspecialchars($this->item->params->get('pageclass_sfx'));

		// $this->_prepareDocument();

		// parent::display($tpl);

	}

	public function parseElementNew($element){
		if(!isset($element->content)) $element->content = AzuraShortcode::getEleDefaultContent($element);
		if($element->published == '0') return '';
		$defaultAttrs = AzuraShortcode::getEleDefaultAttrs($element);
        $element->attrs = (object) array_merge((array) $defaultAttrs, (array) $element->attrs);
		if(isset($element->children) && count($element->children)){
			foreach ($element->children as $child) {
				$element->content .= $this->parseElementNew($child) ;
			}
		}
		return AzuraShortcode::contentNew($element->attrs, $element->content, $element->type);
	}
	protected function getProducts($catid){
		$model = $this->getModel();

		return $model->getProducts($catid);
	}

	protected function getComments(){
		$model = $this->getModel();

		return $model->getComments();
	}

	public function addCustomCss($links =''){
		$linkArray = array();
		if(!empty($links)){
			$linkArray = explode(",", $links);
		}else{
			return false;
		}
		$app = JFactory::getApplication();
		$doc = JFactory::getDocument();
		$themePath = JPATH_THEMES.'/'.$app->getTemplate();
		$themeLink = JURI::base(true).'/templates/'.$app->getTemplate();
		foreach ($linkArray as $ctlink) {
			if(file_exists($themePath.'/css/'.$ctlink)){
				$doc->addStyleSheet($themeLink.'/css/'.$ctlink);
			}elseif(file_exists($themePath.'/stylesheet/'.$ctlink)){
				$doc->addStyleSheet($themeLink.'/stylesheet/'.$ctlink);
			}
		}
	}

	public function addCustomJS($links =''){
		$linkArray = array();
		if(!empty($links)){
			$linkArray = explode(",", $links);
		}else{
			return false;
		}
		$app = JFactory::getApplication();
		$doc = JFactory::getDocument();
		$themePath = JPATH_THEMES.'/'.$app->getTemplate();
		$themeLink = JURI::base(true).'/templates/'.$app->getTemplate();
		foreach ($linkArray as $ctlink) {
			if(file_exists($themePath.'/js/'.$ctlink)){
				$doc->addScript($themeLink.'/js/'.$ctlink);
			}elseif(file_exists($themePath.'/javascript/'.$ctlink)){
				$doc->addScript($themeLink.'/javascript/'.$ctlink);
			}
		}
	}

	/**
	 * Prepares the document
	 */
	protected function _prepareDocument()
	{
		$app		= JFactory::getApplication();
		$menus		= $app->getMenu();
		$pathway	= $app->getPathway();
		$title		= null;

		// Because the application sets a default page title,
		// we need to get it from the menu item itself
		$menu = $menus->getActive();

		//echo'<pre>';var_dump($menu);die;

		if ($menu)
		{
			$this->params->def('page_heading', $this->params->get('page_title', $menu->title));
		}
		else
		{
			$this->params->def('page_heading', JText::_('COM_AZURAPAGEBUILDERS'));
		}

		$title = $this->params->get('page_title', '');

		$id = (int) @$menu->query['id'];

		// if the menu item does not concern this page
		if ($menu && ($menu->query['option'] != 'com_azurapagebuilder' || $menu->query['view'] != 'page' || $id != $this->item->id))
		{
			// If a browser page title is defined, use that, then fall back to the article title if set, then fall back to the page_title option
			//$title = $this->item->params->get('article_page_title', $this->item->title ?: $title);

			// If this is not a single page menu item, set the page title to the page title
			if ($this->item->title)
			{
				$title = $this->item->title;
			}

			$path = array(array('title' => $this->item->title, 'link' => ''));
			$category = JCategories::getInstance('AzuraPagebuilder')->get($this->item->catid);

			while ($category && ($menu->query['option'] !== 'com_azurapagebuilder' || $menu->query['view'] === 'page' || $id != $category->id) && $category->id > 1)
			{
				$path[] = array('title' => $category->title, 'link' => AzuraPagebuilderHelperRoute::getCategoryRoute($this->item->catid));
				$category = $category->getParent();
			}

			$path = array_reverse($path);

			foreach ($path as $item)
			{
				$pathway->addItem($item['title'], $item['link']);
			}

		}



		// Check for empty title and add site name if param is set
		if (empty($title))
		{
			$title = $app->get('sitename');
		}
		elseif ($app->get('sitename_pagetitles', 0) == 1)
		{
			$title = JText::sprintf('JPAGETITLE', $app->get('sitename'), $title);
		}
		elseif ($app->get('sitename_pagetitles', 0) == 2)
		{
			$title = JText::sprintf('JPAGETITLE', $title, $app->get('sitename'));
		}

		if (empty($title))
		{
			$title = $this->item->title;
		}

		$this->document->setTitle($title);

		if ($this->item->metadesc)
		{
			$this->document->setDescription($this->item->metadesc);
		}
		elseif ($this->params->get('menu-meta_description'))
		{
			$this->document->setDescription($this->params->get('menu-meta_description'));
		}

		if ($this->item->metakey)
		{
			$this->document->setMetadata('keywords', $this->item->metakey);
		}
		elseif ($this->params->get('menu-meta_keywords'))
		{
			$this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
		}

		if ($this->params->get('robots'))
		{
			$this->document->setMetadata('robots', $this->params->get('robots'));
		}

		if ($app->get('MetaAuthor') == '1')
		{
			$author = $this->item->created_by_alias ?: $this->item->author;
			$this->document->setMetaData('author', $author);
		}

		$mdata = $this->item->metadata->toArray();

		foreach ($mdata as $k => $v)
		{
			if ($v)
			{
				$this->document->setMetadata($k, $v);
			}
		}
		
		// Open Graph
		if ($this->item->params->get('og_title'))
		{
			$this->document->setMetaData('og:title', $this->item->params->get('og_title'), 'property');
			$this->document->setMetaData('twitter:title', $this->item->params->get('og_title'));
		}
		if ($this->item->params->get('og_description'))
		{
			$this->document->setMetaData('og:description', $this->item->params->get('og_description'), 'property');
		}
		if ($this->item->params->get('og_image'))
		{
			$this->document->setMetaData('og:image', JURI::root().$this->item->params->get('og_image'), 'property');
		}
		if ($this->item->params->get('tt_description'))
		{
			$this->document->setMetaData('twitter:description', $this->item->params->get('tt_description'));
		}
		if ($this->item->params->get('tt_image'))
		{
			$this->document->setMetaData('twitter:image', JURI::root().$this->item->params->get('tt_image'));
		}

	}
}
