<?php
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;

// Include the component HTML helpers.
JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
// Load jQuery 
JHtml::_('jquery.framework');
// Load Mootools Core and More
//JHtml::_('behavior.framework', 'More');

JHtml::_('behavior.formvalidation');
JHtml::_('behavior.keepalive');
//JHtml::_('formbehavior.chosen', 'select');
//JHtml::_('behavior.tooltip','.hasTooltip');
//tooltip($selector = '.hasTip', $params = array())
//new in 2.1
//new update for Joomla 3.5
//JHTML::_('behavior.modal');
//JHTML::_('behavior.modal', 'a.modal_jform_azuramedia');
JHtml::_('behavior.colorpicker');
JHtml::_('jquery.ui', array('core', 'sortable'));
$assoc = JLanguageAssociations::isEnabled();

$doc = JFactory::getDocument();

$scr = '
var cururl = window.location.href;
var adminpos = cururl.indexOf("administrator");
if(adminpos){
	adComBaseUrl = cururl.substring(0, adminpos + 13)+"/";
}
adComRootUrl ="'. JURI::root().'";
';

// get element option types 
$this->elementsOptions = AzuraElements::getElementsOptions();
$scr .= "var azuraElementsOptions = ".json_encode($this->elementsOptions).";";
$doc->addScriptDeclaration($scr);
$doc->addStyleSheet(JURI::base(true).'/components/com_azurapagebuilder/assets/css/bootstrap.custom.css');
$doc->addStyleSheet(JURI::base(true).'/components/com_azurapagebuilder/assets/css/azura-modal.css');
$doc->addStyleSheet(JURI::base(true).'/components/com_azurapagebuilder/assets/fancybox/jquery.fancybox.css');
$doc->addStyleSheet(JURI::root().'/components/com_azurapagebuilder/assets/fonts/themify-icons/themify-icons.css');
$doc->addStyleSheet(JURI::root().'/components/com_azurapagebuilder/assets/fonts/font-awesome/css/font-awesome.min.css');
$doc->addStyleSheet(JURI::root().'/components/com_azurapagebuilder/assets/fonts/lineicons/lineicons.css');
$doc->addStyleSheet(JURI::root().'/components/com_azurapagebuilder/assets/fonts/simple-line-icons/css/simple-line-icons.css');
$doc->addStyleSheet(JURI::root().'/components/com_azurapagebuilder/assets/fonts/et-line/style.css');
$doc->addStyleSheet(JURI::base(true).'/components/com_azurapagebuilder/assets/css/style.css');

$doc->addScript(JURI::base(true).'/components/com_azurapagebuilder/assets/fancybox/jquery.fancybox.pack.js');
$doc->addScript(JURI::base(true).'/components/com_azurapagebuilder/assets/js/azura-modal.js');
$doc->addScript(JURI::base(true).'/components/com_azurapagebuilder/assets/ace/src-min-noconflict/ace.js');
$doc->addScript(JURI::base(true).'/components/com_azurapagebuilder/assets/tinymce/tinymce.min.js');
$doc->addScript('https://ajax.googleapis.com/ajax/libs/webfont/1.6.26/webfont.js');

// $doc->addScriptDeclaration('
//     WebFont.load({
//     	google: { 
//            families: [\'Raleway\'] 
//      	} 
//  	});
// ');
$doc->addScript(JURI::base(true).'/components/com_azurapagebuilder/assets/js/libraries.js');
$doc->addScript(JURI::base(true).'/components/com_azurapagebuilder/assets/js/newapp-editor.js');

$this->tab_name = 'pageTab';
$this->ignore_fieldsets = array('jmetadata');
?>

<form action="<?php echo JRoute::_('index.php?option=com_azurapagebuilder&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="form-validate">

	<?php echo JLayoutHelper::render('joomla.edit.title_alias', $this); ?>

	<div class="form-horizontal">
		<?php echo JHtml::_('bootstrap.startTabSet', 'pageTab', array('active' => 'details')); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'pageTab', 'details', empty($this->item->id) ? JText::_('COM_AZURAPAGEBUILDER_NEW_PAGE', true) : JText::sprintf('COM_AZURAPAGEBUILDER_EDIT_PAGE', $this->item->id, true)); ?>
		<div class="azp_admin-row hide-edit-global" id="azura-pagebuilder-app">
			<div class="azp_admin-col-md-12">
					<div class="azp_admin-row">
						
						<div class="azp_admin-col-md-10 azp-builder-area">
							<div class="pull-left">
								<a href="#" class="btn btn-primary azura-add-new-row" id="azura-add-new-row"><i class="icon-list-2 icon-primary"></i> Add Row</a>&nbsp;&nbsp;&nbsp;<a href="<?php echo JURI::root().'index.php?option=com_azurapagebuilder&view=page&id='.$this->item->id;?>" class="btn btn-default" target="_blank"><i class="icon-eye-open"></i> Preview</a>
								
							</div>
							<div class="pull-right">
								<?php echo $this->form->getInput('alt_layout'); ?>
								<a href="javascript:void(0);" id="azuraPageTemplate" class="btn btn-default" target="_blank"><i class="ti-import"></i> Import Templates</a>
								<a href="javascript:void(0);" id="azuraPageCustomStyle" class="btn btn-default" target="_blank"><i class="ti-brush"></i> Custom Style</a>
							</div>
							<br>
							<hr>
							<div class="azura-pagebuilder azp_admin-clearfix" id="azura-pagebuilder">
								<div class="azp_admin-clearfix">
									<div class="azura-pagebuilder-area" id="azura-pagebuilder-area"></div>
								</div>
							</div>
							<div class="azura-pagebuilder-footer">
								<a href="javascript:void(0)" id="azuraAddPageSection"><i class="ti-plus"></i></a>
							</div>
							<div class="toggle-edit-global-wrap">
								<a href="javascript:void(0);" class="btn btn-primary" title="Toggle global edit"><i class="ti-arrow-circle-right"></i></a>
							</div>
							<div class="azp_introtext-field-wrap">
								<div class="control-group">
									<div class="control-label">
										<label id="azp_article_introtext-lbl" for="azp_article_introtext" class="hasPopover" data-content="<?php echo JText::_('COM_AZURAPAGEBUILDER_INTROTEXT_FIELD_DESC');?>" data-original-title="<?php echo JText::_('COM_AZURAPAGEBUILDER_INTROTEXT_FIELD_LABEL');?>" aria-invalid="false"><?php echo JText::_('COM_AZURAPAGEBUILDER_INTROTEXT_FIELD_LABEL');?></label>
									</div>
									<div class="controls">
										<textarea name="azp_article_introtext" id="azp_article_introtext" cols="130" rows="6" aria-invalid="false"></textarea>
									</div>
								</div>
							</div>

						</div>
						
						<div class="azp_admin-col-md-2 azp-edit-global-area">
							
							<?php echo JLayoutHelper::render('joomla.edit.global', $this); ?>
						</div>
					</div>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php if ($assoc) : ?>
			<?php echo JHtml::_('bootstrap.addTab', 'pageTab', 'associations', JText::_('JGLOBAL_FIELDSET_ASSOCIATIONS', true)); ?>
				<?php echo $this->loadTemplate('associations'); ?>
			<?php echo JHtml::_('bootstrap.endTab'); ?>
		<?php endif; ?>


		<?php echo JHtml::_('bootstrap.addTab', 'pageTab', 'publishing', JText::_('JGLOBAL_FIELDSET_PUBLISHING', true)); ?>
		<div class="row-fluid form-horizontal-desktop">
			<div class="span6">
				<?php echo JLayoutHelper::render('joomla.edit.publishingdata', $this); ?>
			</div>
			<div class="span6">
				<?php echo JLayoutHelper::render('joomla.edit.metadata', $this); ?>
				<hr>
				
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php echo JLayoutHelper::render('joomla.edit.params', $this); ?>


		<?php if ($this->canDo->get('core.admin')) : ?>
			<?php echo JHtml::_('bootstrap.addTab', 'pageTab', 'permissions', JText::_('COM_AZURAPAGEBUILDER_FIELDSET_PERMISSIONS', true)); ?>
				<?php echo $this->form->getInput('rules'); ?>
			<?php echo JHtml::_('bootstrap.endTab'); ?>
		<?php endif; ?>

		<?php echo JHtml::_('bootstrap.endTabSet'); ?>

	</div>

	<input type="hidden" name="task" value="" />
	<?php echo $this->form->getInput('customCssLinks'); ?>
	<?php echo $this->form->getInput('pagecontent'); ?>
	<?php echo $this->form->getInput('shortcode'); ?>
	<?php echo JHtml::_('form.token'); ?>
</form>



<div class="copyright">
	<p><small style="float:left;"><a href="http://azura.cththemes.com" title="Azura - Joomla Page Builder" target="_blank">Azura - Joomla Page Builder</a> &copy; 2014 - <?php echo date('Y');?> by <a href="https://themeforest.net/user/cththemes" title="CTHthemes" target="_blank">CTHthemes</a></small><small style="float:right;">Version <?php echo AZURA_VERSION;?></small></p>
</div>

<?php echo $this->loadTemplate('temp_modals');?>
<?php echo $this->loadTemplate('temp_elements');?>
<?php echo $this->loadTemplate('temp_fields');?>
<?php echo $this->loadTemplate('temp_scripts');?>





