<?php 
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
$el_id = $el_class = $gallery_images = $columns = $tablet_columns = $mobile_columns = $spacing = $filters_text = $filter_all = '';
$loaded = $show_loadmore = $lmore_items = $caption_style = $enable_gallery = '';
//$azura_attrs,$azura_content,$azura_element
extract($azura_attrs);

$gallery_images = json_decode($azura_content);
//echo'<pre>';var_dump($gallery_images);die;
if(!is_array($gallery_images)&& count($gallery_images)) return;

$classes = array(
    'azp_element',
    'azp_images_gallery_wrap',
    'gal-'.$spacing.'-pad-wrapp',
    $el_class,
);
if(!empty($el_id)){
	$el_id = 'id="'.$el_id.'"';
}
$azpgallerystyle = self::buildStyle($azura_attrs);
$animation_data = self::buildAnimation($azura_attrs);
$classes[] = $animation_data['trigger'];
$classes = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $classes ) ) );
        
$gal_classes = 'azp_gallery-items desktop-'. $columns.'-columns tablet-'. $tablet_columns.'-columns mobile-'. $mobile_columns.'-columns gal-'.$spacing.'-pad';
if($enable_gallery == '1'){
	$gal_classes .= ' azp_gallery-popup';
}else{
	$gal_classes .= ' azp_image-popup';
}


	$lmore_data = false;
    if($show_loadmore == '1'){
        $lmore_data = array();
        $lmore_data['images'] = $gallery_images;
        $lmore_data['loaded'] = $loaded;
        $lmore_data['lmore_items'] = $lmore_items;
        $lmore_data['caption_style'] = $caption_style;

    }
?>
<div class="<?php echo $classes;?>" <?php echo $el_id .' ' . $azpgallerystyle.' '.$animation_data['data'];?>>
<?php 
if($filters_text !='') : ?>
    <ul class="azp_filter-items">
    <?php 
    if($filter_all == '1') : ?>
        <li><a href="#" data-filter="*" class="active"><?php echo JText::_('All');?></a></li>
    <?php endif;?>
    <?php 
    $filters_text = explode("|", $filters_text);
    foreach ($filters_text as $key => $fil) {
        if($filter_all != '1' && $key == 0){
            echo '<li><a href="#" class="active" data-filter=".filval-' . self::sanitize_title($fil).'">'.$fil.'</a></li>';
        }else{
            echo '<li><a href="#" data-filter=".filval-' . self::sanitize_title($fil).'">'.$fil.'</a></li>';
        }
        
    }
    ?>
         
    </ul>
<?php endif;?>
    <div class="azp_gallery-items-holder">
    
        <div class="<?php echo $gal_classes;?>" 
        <?php if($show_loadmore == '1' && count($gallery_images) > $loaded ):?>
         data-lm-task="ajax.gallery"
         data-lm-token="<?php echo JSession::getFormToken(); ?>"
         data-lm-settings='<?php echo json_encode($lmore_data);?>'
        <?php endif;?>
        >
            <div class="azp_grid-sizer"></div>
            <?php foreach ($gallery_images as $key => $img) { 
                if($key < $loaded) {
                    $src = '';
                    $alt_text = '';
                    $filtext = '';
                    if(isset($img->src)) $src = $img->src ;
                    if(isset($img->alt_text)) $alt_text = $img->alt_text ;
                    if(isset($img->filters)&& $img->filters !=''){
                        $filters = explode("|", $img->filters);
                        foreach ($filters as $key => $fil) {
                            $filtext .= ' filval-' . self::sanitize_title($fil);
                        }
                    }
            ?>
            <div class="azp_grid-item<?php echo $filtext;?>">
                <div class="img-wrapper demo-image-wrap">
                    <div class="img-caption <?php echo $caption_style ;?>">
                        <a href="<?php echo JURI::root().$src;?>" class="zoomer image_popup_a" title="<?php echo $alt_text;?>">
                        <?php if(isset($img->caption)&& $img->caption !='') : ?>
                            <h4><?php echo $img->caption;?></h4>
                        <?php else : ?>
                            <span><i class="azp_lineicon-plus"></i></span>
                        <?php endif; ?>
                        </a>
                    </div>
                    <img src="<?php echo JURI::root().$src;?>" class="img-responsive" alt="<?php echo $alt_text;?>">
                </div>

            </div>
            <?php
                }
            } 

            ?> 
        </div>
        <?php if($show_loadmore == '1' && count($gallery_images) > $loaded ):?>
        <div class="gallery-lmore-holder">
            <a class="gallery-load-more" data-click="1" data-remain="yes" href="#"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i><span class="sr-only">Loading...</span></a>
        </div>
        <?php endif;?>

    </div>

</div>
<div class="azp_clearfix"></div>
