<?php 
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;
$el_id = $el_class = $title = $value = $size = $thickness = $linecap = $startangle = $colortype = $progress_color = $progress_color2 = $empty_color = $duration = $icon_type = $showanimation = $showanimationpro = '' ;
//$azura_attrs,$azura_content,$azura_element
extract($azura_attrs);

$classes = array(
	'azp_element',
    'azp_circleprogress',
    $el_class,
);
$animation_data = self::buildAnimation($azura_attrs);
$classes[] = $animation_data['trigger'];
$classes[] = self::buildTypography($azura_attrs);//will return custom class for the element without dot


$circleprogressstyle = self::buildStyle($azura_attrs, 'font-size:'.$size.'px;');

if(!empty($el_id)){
	$el_id = 'id="'.$el_id.'"';
}

if($colortype == 'solid'){
	$fill = array('color'=>$progress_color);
}else{
	$fill = array('gradient'=>array($progress_color,$progress_color2));
}
$iconClass = isset( ${'icon_' . $icon_type} ) ? ${'icon_' . $icon_type} : '';

if($iconClass != '') $classes[] = 'hasicon';
if($showanimation == '1') $classes[] = 'showvalue';
if($showanimationpro == '1') $classes[] = 'showpro';

$classes = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $classes ) ) );

?>
<div class="<?php echo $classes;?>" <?php echo $el_id.' '.$circleprogressstyle.' '.$animation_data['data'];?>>
	<div class="circleprogress"
	 data-value="<?php echo $value/100 ;?>"
	 data-size="<?php echo $size ;?>"
	 data-emptyfill="<?php echo $empty_color ;?>"
	 data-linecap="<?php echo $linecap ;?>"
	 data-startangle="<?php echo $startangle ;?>"
	 data-fill="<?php echo htmlspecialchars(json_encode($fill)) ;?>"
	 data-animation="<?php echo htmlspecialchars(json_encode(array('duration'=>(int)$duration))) ;?>"
	 data-thickness="<?php echo $thickness ;?>">
	 	<?php if($showanimation == '1') : ?>
	    <span class="cirprogress-value"></span>
	    <?php endif;?>
	    <?php if($showanimationpro == '1') : ?>
	    <span class="cirprogress-pro"></span>
	    <?php endif;?>
	    <?php if($iconClass != '') : ?>
	    <span class="cirprogress-icon"><i class="<?php echo $iconClass ;?>"></i></span>
		<?php endif;?>
	    <?php if($title != '') : ?>
	    <span class="cirprogress-title"><?php echo $title ;?></span>
		<?php endif;?>
	</div>
</div>
