<?php
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;
$el_class = $el_id = $article_ids = $category = $limit = $order = $orderdir = $showthumbnail = $showtitle = 
$showdate = $showauthor = $showcat = $showtags = $showintrotext = $showloadmore = $showredmore = $showfilter = $filter_all = '';
$slider_items = $slideby = $autoplay = $center_mode = $autoheight = $responsive = $dots = $nav = $loop = '';
//$azura_attrs,$azura_content,$azura_element
extract($azura_attrs);
$animation_data = self::buildAnimation($azura_attrs);
$classes = array(
    'azp_element',
    'azp_articles-slider-wrap',
    'azp_articles-slider',
    $el_class,
);
$classes[] = $animation_data['trigger'];
$classes[] = self::buildTypography($azura_attrs);//will return custom class for the element without dot
$azparticlessliderstyle = self::buildStyle($azura_attrs);
if(!empty($el_id)){
	$el_id = 'id="'.$el_id.'"';
}

$classes = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $classes ) ) );

if($article_ids != ''){
	$article_ids = explode(",", $article_ids);
	$articles = array();
	foreach ($article_ids as $val) {
		if(is_numeric($val) && $item_data = self::getContentItemNew($val)) $articles[] = $item_data;
	}
	
}else{
	if($category == '0' || $category =='') return;
	$articles = self::getContentItems($category, $limit, $order, $orderdir);
}

?>
<?php if(count($articles)) : 
	$dataArr = array();
    
    if($autoplay === '1'){
        $dataArr['autoplay'] = true;
    }else{
        $dataArr['autoplay'] = false;
    }
    $dataArr['items'] = (int)$slider_items;
    if($center_mode === '1'){
        $dataArr['center'] = true;
    }else{
        $dataArr['center'] = false;
    }
    if($autoheight === '1'){
        $dataArr['autoHeight'] = true;
    }else{
        $dataArr['autoHeight'] = false;
    }
    if(!empty($responsive)){
        $dataArr['responsive'] = $responsive;
    }else{
        $dataArr['responsive'] = false;
    }
    if($nav === '1'){
        $dataArr['nav'] = true;
    }else{
        $dataArr['nav'] = false;
    }
    if($dots === '1'){
        $dataArr['dots'] = true;
    }else{
        $dataArr['dots'] = false;
    }
    if($slideby === 'page'){
        $dataArr['slideBy'] = 'page';
    }else{
        $dataArr['slideBy'] = (int)$slideby;
    }
    $dataArr['loop'] = (bool)$loop;

?>
<div class="<?php echo $classes; ?>" <?php echo $el_id .' ' . $azparticlessliderstyle.' '.$animation_data['data'];?>>
	<div class="azp_article-carousel owl-carousel owl-theme topControls" data-options='<?php echo json_encode($dataArr);?>'>

        <?php foreach ($articles as $key => $article) : 
            $article->azp_link = self::cleanUrl( JRoute::_( ContentHelperRoute::getArticleRoute($article->id,$article->catid) ) );
            $article->azp_cat_link = self::cleanUrl( JRoute::_( ContentHelperRoute::getCategoryRoute($article->catid) ) );
		?>
        <div class="item article-item-<?php echo $article->id;?>">
            <div class="azparticle-slider-wrap">
                <div class="img-wrapper">
                    <div class="img-caption capZoomInDown">
                        <a href="<?php echo $article->azp_link;?>" class="zoomer">
                            <span><i class="azp_lineicon-attachment"></i></span>
                        </a>
                    </div>
                    <?php if($showthumbnail === '1') :?>
		            	<?php
		            		$artImages = json_decode($article->images);
		            		if(!empty($artImages->image_intro)) :
		            	?>
		            		<img src="<?php echo JURI::root().$artImages->image_intro;?>" class="azp_img-responsive" alt="<?php echo $artImages->image_intro_alt;?>">
		        		<?php endif;?>
		        	<?php endif;?>
                </div>
                <div class="srb-content">
                    <?php if($showtitle === '1') :?>
						<h4 class="article-slider-title"><a href="<?php echo  $article->azp_link;?>"><?php echo $article->title;?></a></h4>
					<?php endif;?>
                    <?php if($showdate === '1' || $showauthor === '1' || $showcat === '1' || $showtags === '1') :?>
					<ul class="post-meta">
					<?php if($showdate === '1') :?>
						<li><i class="fa fa-calendar"></i> <?php echo JHtml::_('date',$article->created,'d/m/Y');?></li>
					<?php endif;?>
					<?php if($showauthor === '1') :?>
						<li><i class="fa fa-user"></i> <?php echo self::getArticleAuthorName($article);?></li>
					<?php endif;?>
					<?php if($showcat === '1') :?>
						<li><a href="<?php echo $article->azp_cat_link ;?>"><i class="fa fa-file-text"></i> <?php echo $article->cattitle;?></a></li>
					<?php endif;?>
					<?php if($showtags === '1') :
						$tagLayout = new JLayoutFile('joomla.content.tags');
					?>
						<li><i class="fa fa-tags"></i> <?php echo $tagLayout->render($article->tags->itemTags) ;?></li>
					<?php endif;?>
					</ul>
					<?php endif;?>

                    <?php if($showintrotext === '1') :?>
		                <div class="articleIntro">
		                	<?php //if($article->introtext):?>
                                <?php echo $article->introtext;?>
                            <?php //else:?>
                                <?php //echo $article->fulltext;?>
                            <?php //endif;?>
			                
		                </div>
		            <?php endif;?>

                </div>
            </div>
        </div>

        <?php endforeach;?>

    </div>

</div>
<?php endif;?>
