<?php
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;
jimport('joomla.filesystem.file');

class AzuraPagebuilderControllerAjax extends JControllerLegacy
{

	public function __construct($config = array())
	{
		parent::__construct();
	}

	public function saveTemp(){
		$app = JFactory::getApplication();

		$fname = $this->input->getString('name','');
		$data = $this->input->get('data','','raw');
		$is_sec =  $this->input->getString('is_sec','');


		$result = array();
		$result['info'] = 'error';
		$result['msg'] = 'The template name is not empty. Please check';
		if($fname!=''){
			// $pageData = new stdClass;
			// $pageData->templatename = $fname;
			// $pageData->pagecontent = $data;

			$pageData = (object)array(
				'templatename' => $fname,
				'pagecontent' => $data,
				'use_backbone' => 'yes',
			);


			$regex = '#[^A-Za-z0-9\_]#';

			$name = strtolower(preg_replace($regex, '', str_replace(" ", "_", $fname)));
			
			$pageTemplateFolder = JPath::clean(JPATH_COMPONENT_ADMINISTRATOR.'/pagetemplates/');
				
			if($is_sec == 'yes') $pageTemplateFolder = JPath::clean(JPATH_COMPONENT_ADMINISTRATOR.'/sectemplates/');

			if (file_exists(JPath::clean($pageTemplateFolder . '/' . $name . '.php')))
			{
				$result['msg'] = 'Template name exist';

				echo json_encode($result);

				exit();

				//return false;
			}

			$pageData->savename = $name;
			//$pageData = rawurlencode(json_encode($pageData));
			$pageData = json_encode($pageData);

			// create new template file
			$file = fopen(JPath::clean($pageTemplateFolder . '/' . $name . '.php'), 'x');

			if (!$file)
			{
				$result['msg'] = 'There is an error on creating template file. Please check.';

				//echo json_encode($result);

				//exit();
			}else{
				$write = fwrite($file,$pageData);

				if(!$write){

					$result['msg'] = 'There is an error on writing template data. Please check.';

					//echo json_encode($result);

					//fclose($file);

				}else{
					$result['info'] = 'success';
					$result['msg'] = 'Template saved.';

					$result['templatename'] = $fname;
					$result['savename'] = $name;
					//echo json_encode($result);

					

				}	

				
			}

			fclose($file);

			echo json_encode($result);

		}else{
			echo json_encode($result);
		}

		$app->close();
	}
	
	public function loadtemp(){
		$app = JFactory::getApplication();

		$savename = $this->input->getString('name','');
		$is_sec =  $this->input->getString('is_sec','');
		$result = false;

		if($savename != ''){
			
			$pageTemplateFolder = JPath::clean(JPATH_COMPONENT_ADMINISTRATOR.'/pagetemplates/');
				
			if($is_sec == 'yes') $pageTemplateFolder = JPath::clean(JPATH_COMPONENT_ADMINISTRATOR.'/sectemplates/');
			if (file_exists(JPath::clean($pageTemplateFolder . '/' . $savename . '.php')))
			{
				$tempContent = JFile::read($pageTemplateFolder.'/'.$savename . '.php');
	        	if($tempContent != ''){
	        		if(strpos($tempContent, "%7B%22") === 0 ){
	        			$result = json_decode(rawurldecode($tempContent));
	        		}else{
	        			$result = json_decode($tempContent);
	        		}
	        		

	        		//pagecontent: 'json_decode(rawurldecode($tempContent));'

					//savename: "contact_style_1"

					//templatename: "Contact Style 1"

	        	}
			}
		}

		echo json_encode($result);

		$app->close();
	}

	public function deleteTemp(){
		$app = JFactory::getApplication();
		
		$savename = $this->input->getString('name','');
		$is_sec =  $this->input->getString('is_sec','');


		$result = array();
		$result['info'] = 'error';
		$result['msg'] = 'The template name is empty. Please check!';

		if($savename!=''){
			
			$pageTemplateFolder = JPath::clean(JPATH_COMPONENT_ADMINISTRATOR.'/pagetemplates/');
			if($is_sec == 'yes') $pageTemplateFolder = JPath::clean(JPATH_COMPONENT_ADMINISTRATOR.'/sectemplates/');

			if (file_exists(JPath::clean($pageTemplateFolder . '/' . $savename . '.php')))
			{
				if(!JFile::delete(JPath::clean($pageTemplateFolder . '/' . $savename . '.php'))){
					$result['msg'] = 'Error on deleting the template file!';
				}else{
					$result['info'] = 'success'; 
					$result['msg'] = 'The template is deleted!';
				}
			}else{
				$result['msg'] = "The template does not not exist!";
			}

			echo json_encode($result);

		}else{
			echo json_encode($result);
		}

		$app->close();
	}

}


