
if (typeof jQuery === 'undefined') {
  throw new Error('Bootstrap\'s JavaScript requires jQuery')
}

+function ($) {
  'use strict';
  var version = $.fn.jquery.split(' ')[0].split('.')
  if ((version[0] < 2 && version[1] < 9) || (version[0] == 1 && version[1] == 9 && version[2] < 1) || (version[0] > 3)) {
    throw new Error('Bootstrap\'s JavaScript requires jQuery version 1.9.1 or higher, but lower than version 4')
  }
}(jQuery);

/* ========================================================================
 * Bootstrap: transition.js v3.3.7
 * http://getbootstrap.com/javascript/#transitions
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // CSS TRANSITION SUPPORT (Shoutout: http://www.modernizr.com/)
  // ============================================================

  function azpTransitionEnd() {
    var el = document.createElement('azp')

    var transEndEventNames = {
      WebkitTransition : 'webkitTransitionEnd',
      MozTransition    : 'transitionend',
      OTransition      : 'oTransitionEnd otransitionend',
      transition       : 'transitionend'
    }

    for (var name in transEndEventNames) {
      if (el.style[name] !== undefined) {
        return { end: transEndEventNames[name] }
      }
    }

    return false // explicit for ie8 (  ._.)
  }

  // http://blog.alexmaccaw.com/css-transitions
  $.fn.azpEmulateTransitionEnd = function (duration) {
    var called = false
    var $el = this
    $(this).one('azpTransitionEnd', function () { called = true })
    var callback = function () { if (!called) $($el).trigger($.support.azptransition.end) }
    setTimeout(callback, duration)
    return this
  }

  $(function () {
    $.support.azptransition = azpTransitionEnd()

    if (!$.support.azptransition) return

    $.event.special.azpTransitionEnd = {
      bindType: $.support.azptransition.end,
      delegateType: $.support.azptransition.end,
      handle: function (e) {
        if ($(e.target).is(this)) return e.handleObj.handler.apply(this, arguments)
      }
    }
  })

}(jQuery);

/* ========================================================================
 * Bootstrap: modal.js v3.3.7
 * http://getbootstrap.com/javascript/#modals
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // MODAL CLASS DEFINITION
  // ======================

  var AzpModal = function (element, options) {
    this.options             = options
    this.$body               = $(document.body)
    this.$element            = $(element)
    this.$dialog             = this.$element.find('.azp_modal-dialog')
    this.$backdrop           = null
    this.isShown             = null
    this.originalBodyPad     = null
    this.scrollbarWidth      = 0
    this.ignoreBackdropClick = false

    if (this.options.remote) {
      this.$element
        .find('.azp_modal-content')
        .load(this.options.remote, $.proxy(function () {
          this.$element.trigger('loaded.azp.azpmodal')
        }, this))
    }
  }

  AzpModal.VERSION  = '3.3.7'

  AzpModal.TRANSITION_DURATION = 300
  AzpModal.BACKDROP_TRANSITION_DURATION = 150

  AzpModal.DEFAULTS = {
    backdrop: true,
    keyboard: true,
    show: true
  }

  AzpModal.prototype.toggle = function (_relatedTarget) {
    return this.isShown ? this.hide() : this.show(_relatedTarget)
  }

  AzpModal.prototype.show = function (_relatedTarget) {
    var that = this
    var e    = $.Event('show.azp.azpmodal', { relatedTarget: _relatedTarget })

    this.$element.trigger(e)

    if (this.isShown || e.isDefaultPrevented()) return

    this.isShown = true

    this.checkScrollbar()
    this.setScrollbar()
    this.$body.addClass('azp_modal-open')

    this.escape()
    this.resize()

    this.$element.on('click.dismiss.azp.azpmodal', '[data-dismiss="azpmodal"]', $.proxy(this.hide, this))

    this.$dialog.on('mousedown.dismiss.azp.azpmodal', function () {
      that.$element.one('mouseup.dismiss.azp.azpmodal', function (e) {
        if ($(e.target).is(that.$element)) that.ignoreBackdropClick = true
      })
    })

    this.backdrop(function () {
      var transition = $.support.transition && that.$element.hasClass('fade')

      if (!that.$element.parent().length) {
        that.$element.appendTo(that.$body) // don't move modals dom position
      }

      that.$element
        .show()
        .scrollTop(0)

      that.adjustDialog()

      if (transition) {
        that.$element[0].offsetWidth // force reflow
      }

      that.$element.addClass('in')

      that.enforceFocus()

      var e = $.Event('shown.azp.azpmodal', { relatedTarget: _relatedTarget })

      transition ?
        that.$dialog // wait for modal to slide in
          .one('azpTransitionEnd', function () {
            that.$element.trigger('focus').trigger(e)
          })
          .azpEmulateTransitionEnd(AzpModal.TRANSITION_DURATION) :
        that.$element.trigger('focus').trigger(e)
    })
  }

  AzpModal.prototype.hide = function (e) {
    if (e) e.preventDefault()

    e = $.Event('hide.azp.azpmodal')

    this.$element.trigger(e)

    if (!this.isShown || e.isDefaultPrevented()) return

    this.isShown = false

    this.escape()
    this.resize()

    $(document).off('focusin.azp.azpmodal')

    this.$element
      .removeClass('in')
      .off('click.dismiss.azp.azpmodal')
      .off('mouseup.dismiss.azp.azpmodal')

    this.$dialog.off('mousedown.dismiss.azp.azpmodal')

    $.support.transition && this.$element.hasClass('fade') ?
      this.$element
        .one('azpTransitionEnd', $.proxy(this.hideAzpModal, this))
        .azpEmulateTransitionEnd(AzpModal.TRANSITION_DURATION) :
      this.hideAzpModal()
  }

  AzpModal.prototype.enforceFocus = function () {
    $(document)
      .off('focusin.azp.azpmodal') // guard against infinite focus loop
      .on('focusin.azp.azpmodal', $.proxy(function (e) {
        if (document !== e.target &&
            this.$element[0] !== e.target &&
            !this.$element.has(e.target).length) {
          this.$element.trigger('focus')
        }
      }, this))
  }

  AzpModal.prototype.escape = function () {
    if (this.isShown && this.options.keyboard) {
      this.$element.on('keydown.dismiss.azp.azpmodal', $.proxy(function (e) {
        e.which == 27 && this.hide()
      }, this))
    } else if (!this.isShown) {
      this.$element.off('keydown.dismiss.azp.azpmodal')
    }
  }

  AzpModal.prototype.resize = function () {
    if (this.isShown) {
      $(window).on('resize.azp.azpmodal', $.proxy(this.handleUpdate, this))
    } else {
      $(window).off('resize.azp.azpmodal')
    }
  }

  AzpModal.prototype.hideAzpModal = function () {
    var that = this
    this.$element.hide()
    this.backdrop(function () {
      that.$body.removeClass('azp_modal-open')
      that.resetAdjustments()
      that.resetScrollbar()
      that.$element.trigger('hidden.azp.azpmodal')
    })
  }

  AzpModal.prototype.removeBackdrop = function () {
    this.$backdrop && this.$backdrop.remove()
    this.$backdrop = null
  }

  AzpModal.prototype.backdrop = function (callback) {
    var that = this
    var animate = this.$element.hasClass('fade') ? 'fade' : ''

    if (this.isShown && this.options.backdrop) {
      var doAnimate = $.support.transition && animate

      this.$backdrop = $(document.createElement('div'))
        .addClass('azp_modal-backdrop ' + animate)
        .appendTo(this.$body)

      this.$element.on('click.dismiss.azp.azpmodal', $.proxy(function (e) {
        if (this.ignoreBackdropClick) {
          this.ignoreBackdropClick = false
          return
        }
        if (e.target !== e.currentTarget) return
        this.options.backdrop == 'static'
          ? this.$element[0].focus()
          : this.hide()
      }, this))

      if (doAnimate) this.$backdrop[0].offsetWidth // force reflow

      this.$backdrop.addClass('in')

      if (!callback) return

      doAnimate ?
        this.$backdrop
          .one('azpTransitionEnd', callback)
          .azpEmulateTransitionEnd(AzpModal.BACKDROP_TRANSITION_DURATION) :
        callback()

    } else if (!this.isShown && this.$backdrop) {
      this.$backdrop.removeClass('in')

      var callbackRemove = function () {
        that.removeBackdrop()
        callback && callback()
      }
      $.support.transition && this.$element.hasClass('fade') ?
        this.$backdrop
          .one('azpTransitionEnd', callbackRemove)
          .azpEmulateTransitionEnd(AzpModal.BACKDROP_TRANSITION_DURATION) :
        callbackRemove()

    } else if (callback) {
      callback()
    }
  }

  // these following methods are used to handle overflowing modals

  AzpModal.prototype.handleUpdate = function () {
    this.adjustDialog()
  }

  AzpModal.prototype.adjustDialog = function () {
    var azpmodalIsOverflowing = this.$element[0].scrollHeight > document.documentElement.clientHeight

    this.$element.css({
      paddingLeft:  !this.bodyIsOverflowing && azpmodalIsOverflowing ? this.scrollbarWidth : '',
      paddingRight: this.bodyIsOverflowing && !azpmodalIsOverflowing ? this.scrollbarWidth : ''
    })
  }

  AzpModal.prototype.resetAdjustments = function () {
    this.$element.css({
      paddingLeft: '',
      paddingRight: ''
    })
  }

  AzpModal.prototype.checkScrollbar = function () {
    var fullWindowWidth = window.innerWidth
    if (!fullWindowWidth) { // workaround for missing window.innerWidth in IE8
      var documentElementRect = document.documentElement.getBoundingClientRect()
      fullWindowWidth = documentElementRect.right - Math.abs(documentElementRect.left)
    }
    this.bodyIsOverflowing = document.body.clientWidth < fullWindowWidth
    this.scrollbarWidth = this.measureScrollbar()
  }

  AzpModal.prototype.setScrollbar = function () {
    var bodyPad = parseInt((this.$body.css('padding-right') || 0), 10)
    this.originalBodyPad = document.body.style.paddingRight || ''
    if (this.bodyIsOverflowing) this.$body.css('padding-right', bodyPad + this.scrollbarWidth)
  }

  AzpModal.prototype.resetScrollbar = function () {
    this.$body.css('padding-right', this.originalBodyPad)
  }

  AzpModal.prototype.measureScrollbar = function () { // thx walsh
    var scrollDiv = document.createElement('div')
    scrollDiv.className = 'azp_modal-scrollbar-measure'
    this.$body.append(scrollDiv)
    var scrollbarWidth = scrollDiv.offsetWidth - scrollDiv.clientWidth
    this.$body[0].removeChild(scrollDiv)
    return scrollbarWidth
  }


  // MODAL PLUGIN DEFINITION
  // =======================

  function Plugin(option, _relatedTarget) {
    return this.each(function () {
      var $this   = $(this)
      var data    = $this.data('azp.azpmodal')
      var options = $.extend({}, AzpModal.DEFAULTS, $this.data(), typeof option == 'object' && option)

      if (!data) $this.data('azp.azpmodal', (data = new AzpModal(this, options)))
      if (typeof option == 'string') data[option](_relatedTarget)
      else if (options.show) data.show(_relatedTarget)
    })
  }

  var old = $.fn.azpmodal

  $.fn.azpmodal             = Plugin
  $.fn.azpmodal.Constructor = AzpModal


  // MODAL NO CONFLICT
  // =================

  $.fn.azpmodal.noConflict = function () {
    $.fn.azpmodal = old
    return this
  }


  // MODAL DATA-API
  // ==============

  $(document).on('click.azp.azpmodal.data-api', '[data-toggle="azpmodal"]', function (e) {
    var $this   = $(this)
    var href    = $this.attr('href')
    var $target = $($this.attr('data-target') || (href && href.replace(/.*(?=#[^\s]+$)/, ''))) // strip for ie7
    var option  = $target.data('azp.azpmodal') ? 'toggle' : $.extend({ remote: !/#/.test(href) && href }, $target.data(), $this.data())

    if ($this.is('a')) e.preventDefault()

    $target.one('show.azp.azpmodal', function (showEvent) {
      if (showEvent.isDefaultPrevented()) return // only register focus restorer if azpmodal will actually get shown
      $target.one('hidden.azp.azpmodal', function () {
        $this.is(':visible') && $this.trigger('focus')
      })
    })
    Plugin.call($target, option, this)
  })

}(jQuery);
