<?php 
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;
$el_class = $el_id = $video_link = $video_width = $aspect_ratio = $autoplay = $loop = '';
//$azura_attrs,$azura_content,$azura_element
extract($azura_attrs);
$classes = array(
    'azp_video-player',
    'azp_width-'.$video_width,
    'azp_ratio-'.$aspect_ratio,
    $el_class,
);
if(!empty($el_id)){
    $el_id = 'id="'.$el_id.'"';
}

$azpvideostyle = self::buildStyle($azura_attrs);
$animation_data = self::buildAnimation($azura_attrs);
$classes[] = $animation_data['trigger'];

$classes = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $classes ) ) );

$video_urls = parse_url($azura_content);

switch($video_urls['host']) {
    case 'youtu.be':
        $vid = trim($video_urls['path'],'/');
        $src = 'https://www.youtube.com/embed/' . $vid;
    break;
    
    case 'www.youtube.com':
    case 'youtube.com':
        parse_str($video_urls['query'], $query);
        $vid = $query['v'];
        $src = 'https://www.youtube.com/embed/' . $vid;
    break;
    
    case 'vimeo.com':
    case 'www.vimeo.com':
        $vid = trim($video_urls['path'],'/');
        $src = "http://player.vimeo.com/video/{$vid}";
}



?>
<div class="<?php echo $classes; ?>" <?php echo $el_id .' ' . $azpvideostyle.' '.$animation_data['data'];?>>
    <div class="azp_video-wrap">
        <iframe  src="<?php echo $src;?>?autoplay=<?php echo $autoplay;?>&amp;loop=<?php echo $loop;?>"></iframe>
    </div>
</div>