<?php

defined('_JEXEC') or die;

class PlgAzuraAzuraOption extends JPlugin
{

	//add element array
	public function onAzuraPrepareElementsArray(&$elements){

        $elements['AzuraImage'] = array(
            'name'=>'Single Image',
            'desc'=>'',
            'category'=>"content",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/image.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showAnimationTab'=>true,
            'attrs' => array (
                array(
                    'type'=>'image',
                    'param_name'=>'src',
                    'label'=>'Image Source',
                    'desc' => "" ,
                    'default'=>'',
                    'show_in_admin' => true,
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'alttext',
                    'label'=>'Alt Text',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'image_style',
                    'label'=>"Image Style",
                    'desc' => "" ,
                    'default'=>'default',
                    'value'=> array(
                        'Default'=>'default',
                        'Circle'=>'circle',
                        'Thumbnail'=>'thumbnail',
                        // 'Thumbnail with content' => 'withcontent'
                    )
                    
                ),

                
                array(
                    'type'=>'select',
                    'param_name'=>'click_action',
                    'label'=>"Click action",
                    'desc' => "Select action for user click." ,
                    'default'=>'none',
                    'value'=> array(
                        'None'=>'none',
                        'Open popup'=>'lightbox',
                        'Open modal'=>'modal',
                        'Open link'=>'link',
                    )
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'modal_id',
                    'label'=>'Modal ID',
                    'desc' => "Enter your modal ID here to open it." ,
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'click_action',
                        'value' => array('modal'),
                        'has_value' => false,
                    ),
                ),
                array(
                    'type'=>'image',
                    'param_name'=>'large_image',
                    'label'=>'Popup image or video',
                    'desc' => "Large Image or Youtube, Vimeo, Soundcloud link for light box. Leave empty to use default." ,
                    'default'=>'',
                    'depends_on'=> array(
                        'element'=> 'click_action',
                        'value'=> array('lightbox'),
                        'has_value' => false,
                    ),
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'image_link',
                    'label'=>'Image Link',
                    'desc' => "" ,
                    'default'=>'#',
                    'depends_on'=> array(
                        'element'=> 'click_action',
                        'value'=> array('link'),
                        'has_value' => false,
                    ),
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'link_target',
                    'label'=>"Open link in",
                    'desc' => "" ,
                    'default'=>'_blank',
                    'value'=> array(
                        'New tab'=>'_blank',
                        'Current tab'=>'_self',
                    ),
                    'depends_on'=> array(
                        'element'=> 'image_link',
                        'value'=> array(),
                        'has_value' => true,
                    ),
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),

                
            )
        );
        $elements['AzuraVideo']['attrs'][0] = array(
                    'type'=>'text',
                    'param_name'=>'content',
                    'label'=>'Video Link',
                    'desc' => "Video Link (Youtube, Vimeo)" ,
                    'default'=>'https://www.youtube.com/watch?v=Tjvtl3qMRHs',
                    'show_in_admin' => true,
                    'iscontent'=>'yes'
                );

        $elements['AzuraRow']['attrs'][2] = array(
                    'type'=>'select',
                    'param_name'=>'title_align',
                    'label'=>'Section Title Alignment',
                    'desc' => "" ,
                    'default'=>'setcenter',
                    "value" => array(   
                        'Left' => 'setleft',  
                        'Center' => 'setcenter',                                                                                
                        'Right' => 'setright',                                                                                
                    ),
                );

        $elements['AzuraRow']['attrs'][3] = array(
                    'type'=>'switch',
                    'param_name'=>'fullwidth',
                    'label'=>'Content width',
                    'desc' => "" ,
                    'default'=>'0',
                    "value" => array(   
                        'Fluid width' => '1',  
                        'Fixed width' => '0',                                                                                
                    ),
                );


        $elements['AzuraRow']['attrs'][13] = array(
                    'type'=>'text',
                    'param_name'=>'secclass',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                );

        $elements['AzuraColumn']['attrs'][1] = array(
                    'type'=>'text',
                    'param_name'=>'class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,

                    'default'=>''
                );
        

        $elements['AzuraRow']['attrs'][] = array(
                    'type'=>'select',
                    'param_name'=>'sec_padding',
                    'label'=>'Padding Top/Bottom',
                    'desc' => "" ,
                    'default'=>'large-pad',
                    'value'=> array(
                        'None' => 'none-pad',
                        'Small' => 'small-pad',
                        'Large' => 'large-pad',
                        'Extra Large' => 'exlarge-pad',
                    )
                );
        $elements['AzuraTabs']['attrs'][] = array(
                    'type'=>'select',
                    'param_name'=>'layout',
                    'label'=>'Layout',
                    'desc' => "" ,
                    'default'=>'default',
                    "value" => array(   
                        'Default' => 'default',  
                        'Envor Style' => 'envor:azuratabs-envor',  
                    ),
                );
        $elements['AzuraContactForm']['attrs'][] = array(
                    'type'=>'select',
                    'param_name'=>'layout',
                    'label'=>'Layout',
                    'desc' => "" ,
                    'default'=>'default',
                    "value" => array(   
                        'Default' => 'default',  
                        'HTML Style' => 'envor:azuracontactform-html5',  
                    ),
                );
        

        $elements['AzuraTabsItem']['attrs'][1] =array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_awesome',
                    'label'=>'Button Icon',
                    'desc' => "" ,
                    'default'=>'',
                    
                );
        $elements['AzuraAccordion']['attrs'][] = array(
                    'type'=>'select',
                    'param_name'=>'layout',
                    'label'=>'Layout',
                    'desc' => "" ,
                    'default'=>'default',
                    "value" => array(   
                        'Default' => 'default',  
                        'Envor Style' => 'envor:azuraaccordion-envor',  
                    ),
                );

        $elements['socialbutton'] = array(
            'name'=>'Social Button',
            'desc'=>'',
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                
    
                array(
                    'type'=>'text',
                    'param_name'=>'title',
                    'label'=>'Popover Text',
                    'desc' => "" ,
                    'default'=>'facebook',
                    'show_in_admin'=>true,
                    
                ),
                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon',
                    'label'=>'Icon',
                    'desc' => "" ,
                    'default'=>'fa fa-facebook',
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'link',
                    'label'=>'Link',
                    'desc' => "" ,
                    'default'=>'http://www.facebook.com',
                    'show_in_admin'=>true,
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'link_target',
                    'label'=>"Open link in",
                    'desc' => "" ,
                    'default'=>'_blank',
                    'value'=> array(
                        'New tab'=>'_blank',
                        'Current tab'=>'_self',
                    ),
                    'depends_on'=> array(
                        'element'=> 'link',
                        'value'=> array(),
                        'has_value' => true,
                    ),
                    
                ),


                // array(
                //     'type'=>'textarea',
                //     'param_name'=>'content',
                //     'label'=>'Content',
                //     'desc' => "" ,
                //     'iscontent' => 'yes',
                //     'default'=>'',
                //     'show_in_admin' => true,
                // ),

                

                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        

        // $elements['glyphicon'] = array(
        //     'name'=>'Glyphicon Icon',
        //     'desc'=>'',
        //     'category'=>"deprecated",
        //     'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
        //     'open_settings_on_create'=>true,
        //     'showStyleTab'=> false,
        //     'showTypographyTab'=> false,
        //     'showAnimationTab'=> false,
        //     'attrs' => array (
        //         array(
        //             'type'=>'text',
        //             'param_name'=>'name',
        //             'label'=>'Icon Name',
        //             'desc' => "" ,
        //             'default'=>'',
        //             'show_in_admin'=>true,
                    
        //         ),
                
        //         array(
        //             'type'=>'text',
        //             'param_name'=>'extraclass',
        //             'label'=>'Class',
        //             'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
        //             'default'=>''
        //         ),
                
        //     )
        // );
        $elements['portfolio_left'] = array(
            'name'=>'Portfolio Left Content',
            'desc'=>'',
            'category'=>"deprecated",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> false,
            'showTypographyTab'=> false,
            'showAnimationTab'=> false,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'width',
                    'label'=>'Width',
                    'desc' => "" ,
                    'default'=>'col-lg-3',
                    'show_in_admin'=>true,
                    
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );
        $elements['portfolio_right'] = array(
            'name'=>'Portfolio Right Content',
            'desc'=>'',
            'category'=>"deprecated",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> false,
            'showTypographyTab'=> false,
            'showAnimationTab'=> false,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'width',
                    'label'=>'Width',
                    'desc' => "" ,
                    'default'=>'col-lg-9',
                    'show_in_admin'=>true,
                    
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );
        $elements['portfolio_bottom'] = array(
            'name'=>'Portfolio Bottom Content',
            'desc'=>'',
            'category'=>"deprecated",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> false,
            'showTypographyTab'=> false,
            'showAnimationTab'=> false,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'width',
                    'label'=>'Width',
                    'desc' => "" ,
                    'default'=>'col-lg-12',
                    'show_in_admin'=>true,
                    
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'row',
                    'label'=>"Is row",
                    'desc' => "" ,
                    'default'=>'yes',
                    'value'=> array(
                        'Yes'=>'yes',
                        'No'=>'no',
                    ),
                    
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        $elements['feature_box'] = array(
            'name'=>'Feature Box',
            'desc'=>'Feature box element',
            'category'=>"Envor New",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showTypographyTab'=>true,
            'showAnimationTab'=>true,
            'attrs' => array (
                array(
                    'type'=>'select',
                    'param_name'=>'layout',
                    'label'=>'Style',
                    'desc' => "" ,
                    'default'=>'',
                    "value" => array(   
                        'Default' => '',  
                        'Center' => '-2',   

                    ),
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'icon_type',
                    'label'=>"Icon library",
                    'desc' => "Select icon library." ,
                    'default'=>'fontawesome',
                    'value'=> array(
                        'Font Awesome'=>'fontawesome',
                        'Line icon'=>'lineicon',
                        'Simple Line icon'=>'simplelineicon',
                        'ET Line icon'=>'etlineicon',
                    ),
                    
                    
                ),

                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_fontawesome',
                    'label'=>"Icon",
                    'desc' => "Awesome font icon" ,
                    'default'=>'fa fa-globe',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('fontawesome'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'lineicon',
                    'param_name'=>'icon_lineicon',
                    'label'=>"Icon",
                    'desc' => "Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('lineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'simplelineicon',
                    'param_name'=>'icon_simplelineicon',
                    'label'=>"Icon",
                    'desc' => "Simple Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('simplelineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'etlineicon',
                    'param_name'=>'icon_etlineicon',
                    'label'=>"Icon",
                    'desc' => "ET Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('etlineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'image',
                    'param_name'=>'image',
                    'label'=>'Image Icon',
                    'desc' => "" ,
                    'default'=>'',
                    'show_in_admin'=>true
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'title',
                    'label'=>'Title',
                    'desc' => "" ,
                    'default'=>'lovely',
                    'show_in_admin' => true,
                ),
                

                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Item Content',
                    'desc' => "Text Content (Can be use with html tags)" ,
                    'default'=>'<p>Donec cursus ligula ante, non faucibus felis lobortis sed.</p>
<p><a href="http://themeforest.net/user/cththemes/portfolio?ref=cththemes" target="_blank">Details <i class="fa fa-arrow-circle-right"></i></a></p>',
                    'iscontent'=>'yes',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,

                    'default'=>''
                ),


            )
        );

        $elements['our_partners'] = array(
            'name'=>'Our Partners Slider',
            'category'=>"Envor New",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'desc'=>'Slider of partner logos',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showAnimationTab'=>true,
            'attrs' => array (

                array(
                    'type'=>'images',
                    'param_name'=>'content',
                    'label'=>'Select a folder then click to images to use',
                    'desc' => "" ,
                    'default'=>'',
                    'iscontent'=>'yes',
                    'show_in_admin'=> true,
                    'image_attrs'=>array(
                        'Alt-text'=> array(
                                        'type'=>'text',
                                        'desc' => 'Alt Text'
                                    ),
                        'Website'=> array(
                                        'type'=>'text',
                                        'desc' => 'Partner website'
                                    ),
                        'Content'=> array(
                                        'type'=>'textarea',
                                        'desc' => 'Image caption text'
                                    ),
                    ), // define image attr with its field type. text and texarea are allowed and do not allowed SRC for attribute name
                ),

                
                array(
                    'type'=>'text',
                    'param_name'=>'visible',
                    'label'=>'Visible',
                    'desc' => "Number of testimonials show on large screen" ,
                    'default'=>'4',
                    'show_in_admin'=> true,
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'mobilevisible',
                    'label'=>'Mobile Visible',
                    'desc' => "Number of testimonials show on small screen(mobile)" ,
                    'default'=>'1',
                    'show_in_admin'=> true,
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'showpagination',
                    'label'=>'Show Pagination',
                    'desc' => "" ,
                    'default'=>'1',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',   

                    ),
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'paginationpos',
                    'label'=>'Pagination Position',
                    'desc' => "" ,
                    'default'=>'center',
                    "value" => array(   
                        'Center' => 'center',   
                        'Left' => 'left',   
                        'Right' => 'right',   

                    ),
                    'depends_on'=> array(
                        'element' => 'showpagination',
                        'value' => array('1'),
                        'has_value'=> false
                    )
                ),


                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>''
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
                
            )
        );


        $elements['AzuraContainer'] = array(
            'name'=>'Container',
            'desc'=>'Create wrapper in parent column element',
            'category'=>"structure",
            'icon'=> JUri::root().'media/com_azurapagebuilder/eles-icon/container.png',
            'open_settings_on_create'=>true,
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'showResponsiveTab'=> false,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,

                    'default'=>''
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'wraptag',
                    'label'=>'Wrapper Tag',
                    'desc' => "" ,
                    'default'=>'div',
                    'value'=> array(
                        'div'=>'div',
                        'section'=>'section',
                        'article'=>'article',
                        'aside'=>'aside',
                        'ul'=>'ul',
                    )
                ),
                
            )
        );

        $elements['AzuraQuote'] = array(
            'name'=>'Testimonials Slider',
            'desc'=>'Slide element with client comments',
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'hasownchild'=>"yes",
            'childname'=>"Testimonial Item",
            'childtypename'=>"AzuraTestimonial",
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                
                // array(
                //     'type'=>'switch',
                //     'param_name'=>'autoplay',
                //     'label'=>'Autoplay',
                //     'desc' => "" ,
                //     'default'=>'1',
                //     'value'=> array(
                //         'Yes'=>'1',
                //         'No'=>'0'
                //     )
                // ),

                // array(
                //     'type'=>'text',
                //     'param_name'=>'slider_items',
                //     'label'=>'Slider items',
                //     'desc' => "Number of items display in view port" ,
                //     'default'=>'1',
                // ),  

                // array(
                //     'type'=>'text',
                //     'param_name'=>'slideby',
                //     'label'=>'Slide By',
                //     'desc' => "Navigation slide by x. 'page' string can be set to slide by page" ,
                //     'default'=>'1',
                // ),


                // array(
                //     'type'=>'text',
                //     'param_name'=>'id',
                //     'label'=>'Element ID',
                //     'desc' => "Wrapper ID used for script trigger" ,
                //     'default'=>'latest-projects',
                    
                // ),
                // array(
                //     'type'=>'text',
                //     'param_name'=>'selector',
                //     'label'=>'Item Selector',
                //     'desc' => "Slider item selector. Used in script code and style" ,
                //     'default'=>'envor-testimonials-1',
                    
                // ),
                array(
                    'type'=>'text',
                    'param_name'=>'visible',
                    'label'=>'Visible',
                    'desc' => "Number of testimonials show on large screen" ,
                    'default'=>'1',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'mobilevisible',
                    'label'=>'Mobile Visible',
                    'desc' => "Number of testimonials show on small screen(mobile)" ,
                    'default'=>'1',
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'showpagination',
                    'label'=>'Show Pagination',
                    'desc' => "" ,
                    'default'=>'1',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',   

                    ),
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'paginationpos',
                    'label'=>'Pagination Position',
                    'desc' => "" ,
                    'default'=>'center',
                    "value" => array(   
                        'Center' => 'center',   
                        'Left' => 'left',   
                        'Right' => 'right',   

                    ),
                    'depends_on'=> array(
                        'element' => 'showpagination',
                        'value' => array('1'),
                        'has_value'=> false
                    )
                ),

                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Content',
                    'desc' => "" ,
                    'iscontent' => 'yes',
                    'default'=>'',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'layout',
                    'label'=>'Layout',
                    'desc' => "" ,
                    'default'=>'default',
                    "value" => array(   
                        'Default' => 'default',  
                        'Style 2' => 'envor:azuraquote-style2',  
                        'Style 2 - Slider' => 'envor:azuraquote-style2-slider',  
                        'Style 3' => 'envor:azuraquote-style3',  
                        'Style 3 - Slider' => 'envor:azuraquote-style3-slider',  
                    ),
                ),

                array(
                    'type'=>'previewimage',
                    'param_name'=>'quotedefault',
                    'label'=>'Layout Preview',
                    'desc' => "" ,
                    'default'=>JURI::root().'plugins/azura/azuraoption/option_imgs/quote-default.png',
                    'depends_on'=>array(
                        'element'=> 'layout',
                        'value'=> array('default'),
                        'has_value'=> false,
                    )
                ),
                
                

                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        $elements['AzuraTestimonial'] = array(
            'name'=>"Testimonial Item",
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'isownchild' => 'yes',
            'showStyleTab'=> true,
            'showTypographyTab'=> false,
            'showAnimationTab'=> false,
            'showResponsiveTab'=> false,
            'attrs' => array (


                array(
                    'type'=>'text',
                    'param_name'=>'name',
                    'label'=>'Name',
                    'desc' => "" ,
                    'default'=>'Lasmini',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'company',
                    'label'=>'Job',
                    'desc' => "" ,
                    'default'=>'Manager',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'email',
                    'label'=>'Email',
                    'desc' => "" ,
                    'default'=>'',
                ),
                
                array(
                    'type'=>'image',
                    'param_name'=>'photo',
                    'label'=>'Avatar',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Content',
                    'desc' => "" ,
                    'iscontent' => 'yes',
                    'default'=>'<p>Debet error everti ex pri, an vis soluta alienum intellegat. Nusquam praesent ea per, sit no nibh fabulas, pri modo tibique percipitur an pri utinam legere antiopam et.</p>',
                    'show_in_admin' => true,
                ),


                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
                
            )
        );

        $elements['AzuraOurClients'] = array(
            'name'=>'Logos Slider',
            'desc'=>'Slider element with partners logo',
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'hasownchild'=>"yes",
            'childname'=>"Partner Logo",
            'childtypename'=>"AzuraOurClientsItem",
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                
                // array(
                //     'type'=>'text',
                //     'param_name'=>'selector',
                //     'label'=>'Item Selector',
                //     'desc' => "Slider item selector. Used in script code and style" ,
                //     'default'=>'envor-partner-logo',
                    
                // ),
                array(
                    'type'=>'text',
                    'param_name'=>'visible',
                    'label'=>'Visible',
                    'desc' => "Number of testimonials show on large screen" ,
                    'default'=>'5',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'mobilevisible',
                    'label'=>'Mobile Visible',
                    'desc' => "Number of testimonials show on small screen(mobile)" ,
                    'default'=>'1',
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'showpagination',
                    'label'=>'Show Pagination',
                    'desc' => "" ,
                    'default'=>'1',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',   

                    ),
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'paginationpos',
                    'label'=>'Pagination Position',
                    'desc' => "" ,
                    'default'=>'center',
                    "value" => array(   
                        'Center' => 'center',   
                        'Left' => 'left',   
                        'Right' => 'right',   

                    ),
                    'depends_on'=> array(
                        'element' => 'showpagination',
                        'value' => array('1'),
                        'has_value'=> false
                    )
                ),

                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Content',
                    'desc' => "" ,
                    'iscontent' => 'yes',
                    'default'=>'',
                    'show_in_admin' => true,
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        $elements['AzuraOurClientsItem'] = array(
            'name'=>"Partner Logo",
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'isownchild' => 'yes',
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> false,
            'showResponsiveTab'=> false,
            'attrs' => array (
                
                array(
                    'type'=>'image',
                    'param_name'=>'logo',
                    'label'=>'Client Logo',
                    'desc' => "" ,
                    'default'=>'',
                    'show_in_admin'=>true,
                ),
                // array(
                //     'type'=>'select',
                //     'param_name'=>'image_pos',
                //     'label'=>'Image Position',
                //     'desc' => "" ,
                //     'default'=>'owl_img_right',
                //     'value'=> array(
                //         'Above Content'=>'owl_img_above',
                //         'Left - Content Right'=>'owl_img_left',
                //         'Right - Content Left'=>'owl_img_right',
                //     ),
                //     'depends_on'=> array(
                //         'element'=> 'logo',
                //         'value' => array(),
                //         'has_value'=>true
                //     ),
                // ),


                array(
                    'type'=>'text',
                    'param_name'=>'alttext',
                    'label'=>'Image alt text',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'link',
                    'label'=>'Client Website',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'link_target',
                    'label'=>"Open link in",
                    'desc' => "" ,
                    'default'=>'_blank',
                    'value'=> array(
                        'New tab'=>'_blank',
                        'Current tab'=>'_self',
                    ),
                    'depends_on'=> array(
                        'element'=> 'link',
                        'value'=> array(),
                        'has_value' => true,
                    ),
                    
                ),
                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Slide Content (Can be use with html tags.)',
                    'desc' => "" ,
                    'default'=>'',
                    'iscontent'=> 'yes',
                    'show_in_admin'=>true,
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),

                
            )
        );

        $elements['AzuraTeamSlider'] = array(
            'name'=>'Member Slider',
            'desc'=>'Slider element with team member element',
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'hasownchild'=>"yes",
            'childname'=>"Member",
            'childtypename'=>"AzuraTeamSliderItem",
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                
                // array(
                //     'type'=>'text',
                //     'param_name'=>'selector',
                //     'label'=>'Item Selector',
                //     'desc' => "Slider item selector. Used in script code and style" ,
                //     'default'=>'envor-team-1',
                    
                // ),
                array(
                    'type'=>'text',
                    'param_name'=>'visible',
                    'label'=>'Visible',
                    'desc' => "Number of testimonials show on large screen" ,
                    'default'=>'4',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'mobilevisible',
                    'label'=>'Mobile Visible',
                    'desc' => "Number of testimonials show on small screen(mobile)" ,
                    'default'=>'1',
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'shownavigation',
                    'label'=>'Show Navigation',
                    'desc' => "" ,
                    'default'=>'1',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',   

                    ),
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'navigationpos',
                    'label'=>'Navigation Position',
                    'desc' => "" ,
                    'default'=>'center',
                    "value" => array(   
                        'Center' => 'center',   
                        'Left' => 'left',   
                        'Right' => 'right',   

                    ),
                    'depends_on'=> array(
                        'element' => 'shownavigation',
                        'value' => array('1'),
                        'has_value'=> false
                    )
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        $elements['AzuraTeamSliderItem'] = array(
            'name'=>"Member",
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'isownchild' => 'yes',
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> false,
            'showResponsiveTab'=> false,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'job',
                    'label'=>'Greeting',
                    'desc' => "" ,
                    'default'=>'',
                    'show_in_admin'=>true,
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'name',
                    'label'=>'Member Name',
                    'desc' => "" ,
                    'default'=>'',
                    'show_in_admin'=>true,
                ),


                array(
                    'type'=>'image',
                    'param_name'=>'photo',
                    'label'=>'Member Photo',
                    'desc' => "" ,
                    'default'=>'',
                    'show_in_admin'=>true,
                ),
                // array(
                //     'type'=>'select',
                //     'param_name'=>'image_pos',
                //     'label'=>'Image Position',
                //     'desc' => "" ,
                //     'default'=>'owl_img_right',
                //     'value'=> array(
                //         'Above Content'=>'owl_img_above',
                //         'Left - Content Right'=>'owl_img_left',
                //         'Right - Content Left'=>'owl_img_right',
                //     ),
                //     'depends_on'=> array(
                //         'element'=> 'slideimage',
                //         'value' => array(),
                //         'has_value'=>true
                //     ),
                // ),


                // array(
                //     'type'=>'text',
                //     'param_name'=>'alttext',
                //     'label'=>'Image alt text',
                //     'desc' => "" ,
                //     'default'=>''
                // ),
                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Slide Content (Can be use with html tags.)',
                    'desc' => "" ,
                    'default'=>'',
                    'iscontent'=> 'yes',
                    'show_in_admin'=>true,
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        $elements['AzuraFeaturesSlider'] = array(
            'name'=>'Features Slider',
            'desc'=>'Slider element with team member element',
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'hasownchild'=>"yes",
            'childname'=>"Feature Item",
            'childtypename'=>"AzuraFeaturesSliderItem",
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                
                // array(
                //     'type'=>'text',
                //     'param_name'=>'selector',
                //     'label'=>'Item Selector',
                //     'desc' => "Slider item selector. Used in script code and style" ,
                //     'default'=>'envor-feature',
                    
                // ),
                array(
                    'type'=>'text',
                    'param_name'=>'visible',
                    'label'=>'Visible',
                    'desc' => "Number of testimonials show on large screen" ,
                    'default'=>'4',
                    
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'mobilevisible',
                    'label'=>'Mobile Visible',
                    'desc' => "Number of testimonials show on small screen(mobile)" ,
                    'default'=>'1',
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'shownavigation',
                    'label'=>'Show Navigation',
                    'desc' => "" ,
                    'default'=>'1',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',   

                    ),
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'navigationpos',
                    'label'=>'Navigation Position',
                    'desc' => "" ,
                    'default'=>'center',
                    "value" => array(   
                        'Center' => 'center',   
                        'Left' => 'left',   
                        'Right' => 'right',   

                    ),
                    'depends_on'=> array(
                        'element' => 'shownavigation',
                        'value' => array('1'),
                        'has_value'=> false
                    )
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        $elements['AzuraFeaturesSliderItem'] = array(
            'name'=>"Feature Item",
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'isownchild' => 'yes',
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> false,
            'showResponsiveTab'=> false,
            'attrs' => array (
                
                
                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Slide Content (Can be use with html tags.)',
                    'desc' => "" ,
                    'default'=>'<header>
  <i class="fa fa-globe"></i>
  lovely
</header>
<p>Donec cursus ligula ante, non faucibus felis lobortis sed.</p>
<p><a href="#">Details <i class="fa fa-arrow-circle-right"></i></a></p>',
                    'iscontent'=> 'yes',
                    'show_in_admin'=>true,
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        $elements['AzuraPricingTable'] = array(
            'name'=>'Pricing Table',
            'desc'=>'Page section with table of pricing plans',
            'hasownchild'=>'yes',
            'ispagesection'=>'yes',
            'childtypename'=>'AzuraPricingPlan',
            'childname'=>'Plan',
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'showStyleTab'=>true,
            'showTypographyTab'=>true,
            'showAnimationTab'=>true,
            'attrs' => array (
                
                array(
                    'type'=>'switch',
                    'param_name'=>'fullwidth',
                    'label'=>'Fullwidth',
                    'desc' => "Show pricing section as fullwith" ,
                    'default'=>'0',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',   

                    ),
                ),

                array(
                    'type'=>'textarea',
                    'param_name'=>'featured',
                    'label'=>'Featured',
                    'desc' => "Item's number that show as featured" ,
                    'default'=>'3',
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'pstyle',
                    'label'=>'Style',
                    'desc' => "Pricing tables style" ,
                    'default'=>'',
                    "value" => array(   
                        'Style 2' => '',  
                        'Style 3' => 'v2',   

                    ),
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
               
                
            )
        );

        $elements['AzuraPricingPlan'] = array(
            'name'=>'Plan',
            'desc'=>'',
            'isownchild'=>'yes',
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'showStyleTab'=>true,
            'showAnimationTab'=>true,
            'showTypographyTab'=>true,
            'attrs' => array (
            
                
                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Introduction',
                    'desc' => "" ,
                    'default'=>'',
                    'iscontent'=>'yes',
                    'show_in_admin'=>true,
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Extra Class',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'columnwidthclass',
                    'label'=>'Column Width Class',
                    'desc' => "Width" ,
                    'default'=>'col-md-3',
                    "value" => array(   
                        '1 Column - 1/12' => 'col-md-1',  
                        '2 Columns - 1/6' => 'col-md-2',   
                        '3 Columns - 1/4' => 'col-md-3',     
                        '4 Columns - 1/3' => 'col-md-4',     
                        '5 Columns - 5/12' => 'col-md-5',     
                        '6 Columns - 1/2' => 'col-md-6',     
                        '7 Columns - 7/12' => 'col-md-7',     
                        '8 Columns - 2/3' => 'col-md-8',     
                        '9 Columns - 1/4' => 'col-md-9',     
                        '10 Columns - 5/6' => 'col-md-10',     
                        '11 Columns - 11/12' => 'col-md-11',     
                        '12 Columns - 1/1' => 'col-md-12', 


                        '1/5' => 'col-md-15',      
                        '2/5' => 'col-md-25',      
                        '3/5' => 'col-md-35',      
                        '4/5' => 'col-md-45',      

                    ),
                ),
                array(
                    'type'=>'clearfix',
                ),
                
            )
        );

        $elements['AzuraPartner'] = array(
            'name'=>'Partner',
            'desc'=>'Envor partner element',
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'showStyleTab'=>true,
            'showTypographyTab'=>true,
            'showAnimationTab'=>true,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'name',
                    'label'=>'Name',
                    'desc' => "" ,
                    'default'=>'',
                    'show_in_admin'=>true
                ),


                array(
                    'type'=>'image',
                    'param_name'=>'photo',
                    'label'=>'Partner Photo',
                    'desc' => "" ,
                    'default'=>'',
                    'show_in_admin'=>true,
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'web_title',
                    'label'=>'Website Title',
                    'desc' => "" ,
                    'default'=>'',
                    'show_in_admin'=>true
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'website',
                    'label'=>'Website',
                    'desc' => "" ,
                    'default'=>'',
                    'show_in_admin'=>true
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'link_target',
                    'label'=>"Open link in",
                    'desc' => "" ,
                    'default'=>'_blank',
                    'value'=> array(
                        'New tab'=>'_blank',
                        'Current tab'=>'_self',
                    ),
                    'depends_on'=> array(
                        'element'=> 'website',
                        'value'=> array(),
                        'has_value' => true,
                    ),
                    
                ),

                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Description',
                    'desc' => "" ,
                    'default'=>'',
                    'iscontent'=>'yes',
                    'show_in_admin'=>true
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Extra Class',
                    'desc' => "" ,
                    'default'=>'',
                ),
                
            )
        );

        $elements['AzuraFaq'] = array(
            'name'=>'FAQ Section',
            'desc'=>'FAQ Section with question and answer elements',
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'hasownchild'=>"yes",
            'childname'=>"FAQ Item",
            'childtypename'=>"AzuraFaqItem",
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                



                array(
                    'type'=>'switch',
                    'param_name'=>'showfilter',
                    'label'=>'Show All',
                    'desc' => "" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),

                
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        

        $elements['AzuraFaqItem'] = array(
            'name'=>"FAQ Item",
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'isownchild' => 'yes',
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> false,
            'showResponsiveTab'=> false,
            'attrs' => array (
                array(
                    'type'=>'text',
                    'param_name'=>'icon',
                    'label'=>'Icon name',
                    'desc' => "Glyphicon icon name" ,
                    'default'=>'globe',
                    'show_in_admin'=>true,
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'icon_type',
                    'label'=>"Icon library",
                    'desc' => "Select icon library." ,
                    'default'=>'fontawesome',
                    'value'=> array(
                        'Font Awesome'=>'fontawesome',
                        'Line icon'=>'lineicon',
                        'Simple Line icon'=>'simplelineicon',
                        'ET Line icon'=>'etlineicon',
                    ),
                    
                ),

                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_fontawesome',
                    'label'=>"Icon",
                    'desc' => "Awesome font icon" ,
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('fontawesome'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'lineicon',
                    'param_name'=>'icon_lineicon',
                    'label'=>"Icon",
                    'desc' => "Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('lineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'simplelineicon',
                    'param_name'=>'icon_simplelineicon',
                    'label'=>"Icon",
                    'desc' => "Simple Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('simplelineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'etlineicon',
                    'param_name'=>'icon_etlineicon',
                    'label'=>"Icon",
                    'desc' => "ET Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('etlineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'question',
                    'label'=>'Question',
                    'desc' => "" ,
                    'default'=>'Enter your question here',
                    'show_in_admin'=>true,
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'filter',
                    'label'=>'Item filters',
                    'desc' => "Separated by comma" ,
                    'default'=>'Joomla,HTML',
                    'show_in_admin'=>true,
                ),

                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Answer (Can be use with html tags.)',
                    'desc' => "" ,
                    'default'=>'',
                    'iscontent'=> 'yes',
                    'show_in_admin'=>true,
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        $elements['AzuraFaq2'] = array(
            'name'=>'FAQ Section',
            'desc'=>'FAQ Section with question and answer elements',
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (
                
                // <field type="text" 
                //     name="icon" 
                //     id="icon" 
                //     default="" 
                //     label="Icon name" 
                //     description="Glyphicon icon name"
                //     />  
                array(
                    'type'=>'text',
                    'param_name'=>'icon',
                    'label'=>'Icon name',
                    'desc' => "Glyphicon icon name" ,
                    'default'=>'',
                    'show_in_admin'=>true,
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'icon_type',
                    'label'=>"Icon library",
                    'desc' => "Select icon library." ,
                    'default'=>'fontawesome',
                    'value'=> array(
                        'Font Awesome'=>'fontawesome',
                        'Line icon'=>'lineicon',
                        'Simple Line icon'=>'simplelineicon',
                        'ET Line icon'=>'etlineicon',
                    ),
                    
                ),

                array(
                    'type'=>'iconselector',
                    'param_name'=>'icon_fontawesome',
                    'label'=>"Icon",
                    'desc' => "Awesome font icon" ,
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('fontawesome'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'lineicon',
                    'param_name'=>'icon_lineicon',
                    'label'=>"Icon",
                    'desc' => "Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('lineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'simplelineicon',
                    'param_name'=>'icon_simplelineicon',
                    'label'=>"Icon",
                    'desc' => "Simple Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('simplelineicon'),
                        'has_value' => false,
                    ),
                    
                ),
                array(
                    'type'=>'etlineicon',
                    'param_name'=>'icon_etlineicon',
                    'label'=>"Icon",
                    'desc' => "ET Line icon",
                    'default'=>'',
                    'depends_on' => array(
                        'element' => 'icon_type',
                        'value' => array('etlineicon'),
                        'has_value' => false,
                    ),
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'question',
                    'label'=>'Question',
                    'desc' => "" ,
                    'default'=>'Enter your question here',
                    'show_in_admin'=>true,
                ),

                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Answer (Can be use with html tags.)',
                    'desc' => "" ,
                    'default'=>'',
                    'iscontent'=> 'yes',
                    'show_in_admin'=>true,
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        $elements['AzuraK2CatView'] = array(
            'name'=>'K2 Category View',
            'desc'=>'K2 articles view',
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'showStyleTab'=>true,
            'showAnimationTab'=>true,
            'attrs' => array (
                
                array(
                    'type'=>'sqlselect',
                    'param_name'=>'category',
                    'label'=>'Select a category',
                    'desc' => "Select a k2 category get item from" ,
                    'default'=>'',

                    'query'=>"SELECT id AS value, name AS category FROM #__k2_categories WHERE published=1 AND trash=0",
                    'titlekey'=>'category',
                    'valuekey'=>'value',
                    'show_in_admin'=> true,

                ),
                // array(
                //     'type'=>'select',
                //     'param_name'=>'columns',
                //     'label'=>'Columns layout',
                //     'desc' => "" ,
                //     'default'=>'3',
                //     "value" => array(   
                //         '1 Column' => '1',  
                //         '2 Columns' => '2',  
                //         '3 Columns' => '3',  
                //         '4 Columns' => '4',  
                //         '5 Columns' => '5',  
                //     ),
                // ),
                array(
                    'type'=>'text',
                    'param_name'=>'limit',
                    'label'=>'Limit',
                    'desc' => "Number or All" ,
                    'default'=>'All',
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'order',
                    'label'=>'Order',
                    'desc' => "" ,
                    'default'=>'created',
                    "value" => array(   
                        'Created' => 'created',  
                        'ID' => 'id',  
                        'Ordering' => 'ordering',   
                    ),
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'orderdir',
                    'label'=>'Order Direction',
                    'desc' => "" ,
                    'default'=>'DESC',
                    "value" => array(   
                        'Ascending' => 'ASC',  
                        'Descending' => 'DESC',   
                    ),
                ),
                // array(
                //     'type'=>'switch',
                //     'param_name'=>'childcat',
                //     'label'=>'Fetch Child Category',
                //     'desc' => "Get items from child categories?" ,
                //     'default'=>'0',
                //     "value" => array(   
                //         'Yes' => '1',  
                //         'No' => '0',   

                //     ),
                // ),
                array(
                    'type'=>'switch',
                    'param_name'=>'showmore',
                    'label'=>'Show more button',
                    'desc' => "" ,
                    'default'=>'0',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',   

                    ),
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'id',
                    'label'=>'Element ID',
                    'desc' => "Wrapper ID used for script trigger" ,
                    'default'=>'latest-projects',
                    
                ),
                // array(
                //     'type'=>'text',
                //     'param_name'=>'selector',
                //     'label'=>'Item Selector',
                //     'desc' => "Slider item selector. Used in script code and style" ,
                //     'default'=>'envor-project',
                    
                // ),
                array(
                    'type'=>'text',
                    'param_name'=>'visible',
                    'label'=>'Visible',
                    'desc' => "Number of testimonials show on large screen" ,
                    'default'=>'4',
                    'show_in_admin'=> true,
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'mobilevisible',
                    'label'=>'Mobile Visible',
                    'desc' => "Number of testimonials show on small screen(mobile)" ,
                    'default'=>'1',
                    'show_in_admin'=> true,
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'shownavigation',
                    'label'=>'Show Navigation',
                    'desc' => "" ,
                    'default'=>'1',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',   

                    ),
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'navigationpos',
                    'label'=>'Navigation Position',
                    'desc' => "" ,
                    'default'=>'center',
                    "value" => array(   
                        'Center' => 'center',   
                        'Left' => 'left',   
                        'Right' => 'right',   

                    ),
                    'depends_on'=> array(
                        'element' => 'shownavigation',
                        'value' => array('1'),
                        'has_value'=> false
                    )
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'layout',
                    'label'=>'Layout',
                    'desc' => "" ,
                    'default'=>'default',
                    "value" => array(   
                        'Default' => 'default',  
                        'Unlike' => 'envor:azurak2catview-unlike',  
                        'Latest News' => 'envor:azurak2catview-latestnews',  
                        'Latest News 2' => 'envor:azurak2catview-latestnews-2',  
                    ),
                ),

                // array(
                //     'type'=>'previewimage',
                //     'param_name'=>'k2catdefault',
                //     'label'=>'Layout Preview',
                //     'desc' => "" ,
                //     'default'=>JURI::root().'plugins/azura/azuraoption/option_imgs/k2catview-default.png',
                //     'depends_on'=>array(
                //         'element'=> 'layout',
                //         'value'=> array('default'),
                //         'has_value'=> false,
                //     )
                // ),

                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Extra Class',
                    'desc' => "" ,
                    'default'=>'',
                    
                ),

                
            )
        );

        $elements['projects_slider'] = array(
            'name'=>'Projects Slider',
            'desc'=>'K2 projects slider element',
            'category'=>"Envor New",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'showStyleTab'=>true,
            'showAnimationTab'=>true,
            'attrs' => array (
                
                array(
                    'type'=>'sqlselect',
                    'param_name'=>'category',
                    'label'=>'Select a category',
                    'desc' => "Select a k2 category get item from" ,
                    'default'=>'',

                    'query'=>"SELECT id AS value, name AS category FROM #__k2_categories WHERE published=1 AND trash=0",
                    'titlekey'=>'category',
                    'valuekey'=>'value',
                    'show_in_admin'=> true,

                ),
                array(
                    'type'=>'text',
                    'param_name'=>'limit',
                    'label'=>'Limit',
                    'desc' => "Number or All" ,
                    'default'=>'All',
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'order',
                    'label'=>'Order',
                    'desc' => "" ,
                    'default'=>'created',
                    "value" => array(   
                        'Created' => 'created',  
                        'ID' => 'id',  
                        'Ordering' => 'ordering',   
                    ),
                ),
                array(
                    'type'=>'select',
                    'param_name'=>'orderdir',
                    'label'=>'Order Direction',
                    'desc' => "" ,
                    'default'=>'DESC',
                    "value" => array(   
                        'Ascending' => 'ASC',  
                        'Descending' => 'DESC',   
                    ),
                ),
                
            
                array(
                    'type'=>'text',
                    'param_name'=>'visible',
                    'label'=>'Visible',
                    'desc' => "Number of testimonials show on large screen" ,
                    'default'=>'4',
                    'show_in_admin'=> true,
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'mobilevisible',
                    'label'=>'Mobile Visible',
                    'desc' => "Number of testimonials show on small screen(mobile)" ,
                    'default'=>'1',
                    'show_in_admin'=> true,
                    
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'shownavigation',
                    'label'=>'Show Navigation',
                    'desc' => "" ,
                    'default'=>'1',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',   

                    ),
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'navigationpos',
                    'label'=>'Navigation Position',
                    'desc' => "" ,
                    'default'=>'center',
                    "value" => array(   
                        'Center' => 'center',   
                        'Left' => 'left',   
                        'Right' => 'right',   

                    ),
                    'depends_on'=> array(
                        'element' => 'shownavigation',
                        'value' => array('1'),
                        'has_value'=> false
                    )
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'show_rate',
                    'label'=>'Show Item Rate',
                    'desc' => "" ,
                    'default'=>'1',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',   

                    ),
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'showmore',
                    'label'=>'Show more button',
                    'desc' => "" ,
                    'default'=>'0',
                    "value" => array(   
                        'Yes' => '1',  
                        'No' => '0',   

                    ),
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'layout',
                    'label'=>'Layout',
                    'desc' => "" ,
                    'default'=>'default',
                    "value" => array(   
                        'Default' => 'default',  
                        'Unlike' => 'envor:azurak2catview-unlike',  
                        'Latest News' => 'envor:azurak2catview-latestnews',  
                        'Latest News 2' => 'envor:azurak2catview-latestnews-2',  
                    ),
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>'',
                    
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'extraclass',
                    'label'=>'Extra Class',
                    'desc' => "" ,
                    'default'=>'',
                    
                ),

                
            )
        );

        $elements['AzuraFlexSlider'] = array(
            'name'=>'Flex Slider',
            'desc'=>'Slider element using Flex plugin',
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'hasownchild'=>"yes",
            'childname'=>"Slide Item",
            'childtypename'=>"AzuraFlexSliderItem",
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> true,
            'attrs' => array (

                array(
                    'type'=>'select',
                    'param_name'=>'flexanimation',
                    'label'=>'Animation',
                    'desc' => "Controls the animation type" ,
                    'default'=>'fade',
                    'value'=> array(
                        'Fade'=>'fade',
                        'Slide'=>'slide'
                    )
                ),

                array(
                    'type'=>'select',
                    'param_name'=>'direction',
                    'label'=>'Direction',
                    'desc' => "Controls the animation direction" ,
                    'default'=>'horizontal',
                    'value'=> array(
                        'Horizontal'=>'horizontal',
                        'Vertical'=>'vertical'
                    )
                ),

                array(
                    'type'=>'switch',
                    'param_name'=>'slideshow',
                    'label'=>'Slide Show',
                    'desc' => "Setup a slideshow for the slider to animate automatically" ,
                    'default'=>'1',
                    'value'=> array(
                        'Yes'=>'1',
                        'No'=>'0'
                    )
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'slideshowspeed',
                    'label'=>'Slideshow Speed',
                    'desc' => "Set the speed of the slideshow cycling, in milliseconds" ,
                    'default'=>'700',
                ),  

                array(
                    'type'=>'text',
                    'param_name'=>'animationspeed',
                    'label'=>'Animation Speed',
                    'desc' => "Set the speed of animations, in milliseconds" ,
                    'default'=>'600',
                ),  



                array(
                    'type'=>'text',
                    'param_name'=>'id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>''
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'flexslider'
                ),
                
            )
        );

        $elements['AzuraFlexSliderItem'] = array(
            'name'=>"Slide Item",
            'category'=>"envor",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'isownchild' => 'yes',
            'showStyleTab'=> true,
            'showTypographyTab'=> true,
            'showAnimationTab'=> false,
            'showResponsiveTab'=> false,
            'attrs' => array (
                
                array(
                    'type'=>'image',
                    'param_name'=>'slideimage',
                    'label'=>'Slide Image',
                    'desc' => "" ,
                    'default'=>'',
                    'show_in_admin'=>true,
                ),
                
                array(
                    'type'=>'text',
                    'param_name'=>'alttext',
                    'label'=>'Image alt text',
                    'desc' => "" ,
                    'default'=>''
                ),
                array(
                    'type'=>'textarea',
                    'param_name'=>'content',
                    'label'=>'Slide Content (Can be use with html tags.)',
                    'desc' => "" ,
                    'default'=>'',
                    'iscontent'=> 'yes',
                    'show_in_admin'=>true,
                ),
                array(
                    'type'=>'text',
                    'param_name'=>'class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>''
                ),
                
            )
        );

        $elements['images_slider'] = array(
            'name'=>'Image Slider',
            'category'=>"Envor New",
            'icon'=> JUri::root().'plugins/azura/azuraoption/elements/envor-icon.png',
            'desc'=>'Gallery of works',
            'open_settings_on_create'=>true,
            'showStyleTab'=>true,
            'showAnimationTab'=>true,
            'attrs' => array (

                array(
                    'type'=>'images',
                    'param_name'=>'content',
                    'label'=>'Select a folder then click to images to use',
                    'desc' => "" ,
                    'default'=>'',
                    'iscontent'=>'yes',
                    'show_in_admin'=> true,
                    'image_attrs'=>array(
                        'Alt-text'=> array(
                                        'type'=>'text',
                                        'desc' => 'Alt Text'
                                    ),
                        'Content'=> array(
                                        'type'=>'textarea',
                                        'desc' => 'Image caption text'
                                    ),
                    ), // define image attr with its field type. text and texarea are allowed and do not allowed SRC for attribute name
                ),

                



                array(
                    'type'=>'text',
                    'param_name'=>'el_id',
                    'label'=>'Element ID',
                    'desc' => "" ,
                    'default'=>''
                ),

                array(
                    'type'=>'text',
                    'param_name'=>'el_class',
                    'label'=>'Extra Class',
                    'desc' => "Use this field to add a class name and then refer to it in your CSS." ,
                    'default'=>'',
                    
                ),
                
            )
        );

        $elements['ElementResponsiveOptions']['attrs'][17] = array(
            'type'=>'select',
            'param_name'=>'columnwidthclass',
            'label'=>'Width',
            'desc' => "" ,
            'default'=>'col-md-12',
            "value" => array(   
                '1 Column - 1/12' => 'col-md-1',  
                '2 Columns - 1/6' => 'col-md-2',   
                '3 Columns - 1/4' => 'col-md-3',     
                '4 Columns - 1/3' => 'col-md-4',     
                '5 Columns - 5/12' => 'col-md-5',     
                '6 Columns - 1/2' => 'col-md-6',     
                '7 Columns - 7/12' => 'col-md-7',     
                '8 Columns - 2/3' => 'col-md-8',     
                '9 Columns - 1/4' => 'col-md-9',     
                '10 Columns - 5/6' => 'col-md-10',     
                '11 Columns - 11/12' => 'col-md-11',     
                '12 Columns - 1/1' => 'col-md-12', 


                '1/5' => 'col-md-15',      
                '2/5' => 'col-md-25',      
                '3/5' => 'col-md-35',      
                '4/5' => 'col-md-45',      

            ),
        );

        return true;
	}
	
}
