<?php
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */

defined('_JEXEC') or die('Restricted access');

use Joomla\Registry\Registry;

jimport( 'joomla.filesystem.file' );
jimport('joomla.filesystem.folder');
jimport('joomla.application.component.helper');
// Required if show readmore or show more post
require_once JPATH_SITE.'/components/com_content/helpers/route.php';
if (file_exists(JPath::clean(JPATH_SITE.'/components/com_k2/helpers/utilities.php'))) require_once JPATH_SITE.'/components/com_k2/helpers/utilities.php';

//require_once JPATH_SITE.'/administrator/components/com_azurapagebuilder/helpers/elementshelper.php';
//require_once JPATH_SITE.'/administrator/components/com_azurapagebuilder/helpers/cthimageresizer.php';
require_once JPATH_SITE.'/components/com_azurapagebuilder/helpers/azptweetsfeed.php';


class AzuraShortcode {
    private static $toStoreGlobalVar = array();

    private static $azuraShortcodes = array();
    private static $customShortcodes = array();

    public function __construct() {
    }

    public static function getTweets($params= array()){
        //echo'<pre>';var_dump($params);die;
        $com_params = JComponentHelper::getParams('com_azurapagebuilder');
        // $consumer_key = $com_params->get('consumer_key','b1gNFU5p55j7GR0vACWyZf0j8');
        // $consumer_secret = $com_params->get('consumer_secret','V0a7UkD0XTuP4zdoJoBPlpbQC9TtGk8ucotXRZZZP4MYv7TkK2');
        // $user_token = $com_params->get('user_token','2549127786-T8zZA3d7cJcgDkI2kwbfQ2XeU8exphGZu3hZVvK');
        // $user_secret = $com_params->get('user_secret','pQXlpkL9CSCIsEnGF5xgsjKObDRWcD77thGkFG9RLzgjs');

        $enable_cache = $com_params->get('enable_cache','');
        $params_df = array(
            'twittername'=>'CTHthemes',
            'counts'=>3,
            'consumer_key'=> $com_params->get('consumer_key','b1gNFU5p55j7GR0vACWyZf0j8'),
            'consumer_secret'=> $com_params->get('consumer_secret','V0a7UkD0XTuP4zdoJoBPlpbQC9TtGk8ucotXRZZZP4MYv7TkK2'),
            'user_token'=> $com_params->get('user_token','2549127786-T8zZA3d7cJcgDkI2kwbfQ2XeU8exphGZu3hZVvK'),
            'user_secret'=> $com_params->get('user_secret','pQXlpkL9CSCIsEnGF5xgsjKObDRWcD77thGkFG9RLzgjs'),
            'enable_cache'=> $enable_cache == '1'? true : false,
        );



        $params = array_merge($params_df,$params);

        $tweetsClass = new AzpTweetsFeed($params);
        return $tweetsClass->fetch();
    }

    public static function prepareTweet($string) {
        
        //Url
        $pattern = '/((ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?)/i';
        $replacement = '<a class="tweet_url" href="$1">$1</a>';
        $string = preg_replace($pattern, $replacement, $string);

        //Search
            $pattern = '/[\#]+([A-Za-z0-9-_]+)/i';
            $replacement = ' <a  class="tweet_search" href="http://twitter.com/search?q=$1">#$1</a>';
            $string = preg_replace($pattern, $replacement, $string);
    

        //Mention
        //if ($this->params->get('linked_mention')==1) {
            $pattern = '/\s[\@]+([A-Za-z0-9-_]+)/i';
            $replacement = ' <a  class="tweet_mention" href="http://twitter.com/$1">@$1</a>';
            $string = preg_replace($pattern, $replacement, $string);    
        //}
/*
        //Mention
        if ($this->params->get('email_linked')==1) {
            $pattern = '/\s([A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,4})/i';
            $replacement = ' <a class="tweet_email" href="mailto:$1">$1</a>';
            $string = preg_replace($pattern, $replacement, $string);
        }*/
        return $string;
    }

    public static function sanitize_title($str = ''){
        $str = preg_replace('/[^\w]+/', '_', $str);
        return strtolower($str);
    }

    protected static function doRecurse($matches, &$i = 0,$endtag=null){
        for($res = array(); $i < count($matches) ; $i++){
            $val = $matches[$i];
            if($val == $endtag){
                $res[] = $val;
                return array($res); // return as nested
            }else if(preg_match("/^\[\/\w.*?\]$/", $val)){
                $i--;
                return $res; // return as non-nested
            }else if( preg_match("/^\[\w.*?\]$/", $val)!= 1 || !count($res)){
                // normal text or opening tag at start of 
                // new part
                $res[] = $val;
            }else{
                // opening tag: recurse
                if(preg_match("/\w+/", $val, $nmats)){
                    $newres = self::doRecurse($matches, $i,'[/' .$nmats[0] .']');
                    foreach($newres as $nr){
                        $res[] = $nr;
                    }
                }
                
                
            }
        }
        return $res ;
    }

    public static function doContentShortcode($content = ''){
        //var_dump($content);die;
        // replace p tag wrap shortcode 
        $content = preg_replace("/<p>(\[.*\])<\/p>/m", "$1", $content);
        //preg_match_all("/<p>(\[\/?[^<>]*\])<\/p>/m", $content, $matchees);
        $elementsOptions = AzuraElements::getElementsOptions();
        self::$azuraShortcodes = array_keys($elementsOptions);

        //var textShortcodes = s.match(/\[\/?(\w)*/g).map(stripShortcodeChar);//console.log(textShortcodes);
        preg_match_all("/\[\/?(\w)*/", $content, $matchees);

        $textShortcodes = array();
        if(count($matchees[0])){
            $textShortcodes = array_map( 
                function($sc) { return preg_replace("/\[\/?/", "", $sc); }, 
                $matchees[0] 
            ); 
        }

        $textShortcodes = array_filter( $textShortcodes );

        self::$customShortcodes = array_diff(array_unique($textShortcodes), self::$azuraShortcodes);
        if(count(self::$customShortcodes)){
            preg_match_all("/\[\/?(".implode("|", self::$azuraShortcodes).").*?\]|\[{.*?}\]|[^\[]+/", $content, $matchees);

        }else{
            preg_match_all("/\[\/?\w.*?\]|\[{.*?}\]|[^\[]+/", $content, $matchees);
        }
        

        //echo'<pre>';var_dump( $matchees);die;
        if(!count($matchees[0])) return $content;
        //if(!count($matchees[0])) return '';

        //echo'<pre>';var_dump($matchees[0]);die;

        $startisendtag = self::isEndTag($matchees[0][0]) ;
        if($startisendtag){
            array_unshift($matchees[0], '<div>', '['.$startisendtag.']');
        }elseif(self::checkSelfClosedShortcode( $matchees[0][0] )){
            array_unshift($matchees[0], '<div>');
        }
        $endisendtag = self::isEndTag($matchees[0][count($matchees[0]) - 1]) ;
        if($endisendtag){
            $matchees[0][] = '<div>';
        }elseif(self::checkSelfClosedShortcode($matchees[0][ count($matchees[0]) - 1 ]) ){
            $matchees[0][] = '<div>';
        }

        //echo'<pre>';var_dump( $matchees);die;
        ///echo'<pre>';var_dump( $matchees);die;

        // function doRecurse($matches, &$i = 0,$endtag=null){
        //     for($res = array(); $i < count($matches) ; $i++){
        //         $val = $matches[$i];
        //         if($val == $endtag){
        //             $res[] = $val;
        //             return [$res]; // return as nested
        //         }else if(preg_match("/^\[\/\w.*?\]$/", $val)){
        //             $i--;
        //             return $res; // return as non-nested
        //         }else if( preg_match("/^\[\w.*?\]$/", $val)!= 1 || !count($res)){
        //             // normal text or opening tag at start of 
        //             // new part
        //             $res[] = $val;
        //         }else{
        //             // opening tag: recurse
        //             if(preg_match("/\w+/", $val, $nmats)){
        //                 $newres = doRecurse($matches, $i,'[/' .$nmats[0] .']');
        //                 foreach($newres as $nr){
        //                     $res[] = $nr;
        //                 }
        //             }
                    
                    
        //         }
        //     }
        //     return $res ;
        // };

        //$return = doRecurse($matchees[0]);




        $return = self::doRecurse($matchees[0]);
        
        //echo '<pre>';var_dump($return);die;
        $return = array_filter($return, function($sec){
            if(is_array($sec)) {
                return true;
            }elseif(strpos($sec, '[') === 0){
                $lg = strlen($sec);
                if(strrpos($sec, ']') == $lg - 1) return true;
                
            }
            return false;
        });
        //echo '<pre>';var_dump($return);die;

        $pageSections = array_map(function($item){
            return self::parseElementModel($item);
        }, $return);


        //echo '<pre>';var_dump($pageSections);die;

        if(empty($pageSections) && $content != '') return $content;
        //if(empty($pageSections) && $content != '') return '';

        $articletext = '';

        foreach ($pageSections as $key => $row) {
            $articletext .= self::parseArticleElement($row);
        }

        return $articletext;


    }

    protected static function parseArticleElement($element){
        if(!isset($element->content)) $element->content = '';
        if(isset($element->published) && $element->published == '0') return '';
        if(isset($element->attrs->el_disable) && $element->attrs->el_disable == 'yes') return '';
        if(isset($element->children) && count($element->children)){
            foreach ($element->children as $child) {
                $child = self::parseElementModel($child);
                $element->content .= self::parseArticleElement($child) ;
            }
        }
        return self::contentNew($element->attrs, $element->content, $element->type);
    }
    protected static function isEndTag($str){
        if(preg_match('/\[\/([\w_]+)\]/', $str, $matches)){
            return $matches[1];
        }
        return false;
    }

    protected static function checkSelfClosedShortcode($str){
        if(preg_match('/(\[[\w_]+.*?\])/', $str, $matches)){
            //var_dump($matches);
            return $matches[0];
        }
        return false;
    }

    protected static function parseShortcodeName($sc_tag){
        $name = '';
        $reg = "/\[\/?([\w_]+).*?\]/";
        if(preg_match($reg, $sc_tag, $matches)){
            $name = $matches[1];
        }
        return $name ;
    }

    protected static  function parseShortcodeAttrs($sc_tag){
        $attributes = (object)array();
        if(preg_match_all('/[\w-_]+="[^"]*"/', $sc_tag, $matches)!== false){
            if($matches){
                foreach ((array)$matches[0] as $attr) {
                    if(preg_match('/([\w-_]+)="([^"]*)"/',$attr,$attrs)){
                        $attributes->{$attrs[1]} = $attrs[2];
                    }
                }
            }
        }

        return $attributes;
    }

    public static function getEleDefaultContent($ele){
        $defaultContent = '';
        $elementsOptions = AzuraElements::getElementsOptions();
        if($ele->type && isset($elementsOptions[$ele->type])){
            $newele = $elementsOptions[$ele->type];
            if(isset($newele['attrs'])){
                if(count($newele['attrs']) ) {
                    foreach ((array)$newele['attrs'] as $attr) {
                        if((isset($attr['param_name']) && $attr['param_name'] == 'content') || (isset($attr['iscontent']) && $attr['iscontent'] == 'yes') ){
                            if(isset($attr['default'])){
                                $defaultContent = $attr['default'];
                            }
                        }
                    }
                }
            }
        }
        return $defaultContent;
    }

    protected static function generateAttrs($options_array = array()){
        $defaultAttrs = (object)array();
        if(count($options_array) ) {
            foreach ((array)$options_array as $attr) {
                //var_dump($attr);
                if(isset($attr['param_name']) && ($attr['type'] != 'label'|| $attr['type'] != 'clearfix' || $attr['type'] != 'previewimage') ){
                    if(isset($attr['default'])){
                        $defaultAttrs->{$attr['param_name']} = $attr['default'];
                    }else{
                        $defaultAttrs->{$attr['param_name']} = '';
                    }
                }
            }
        }
        return $defaultAttrs;
    }
    //$obj_merged = (object) array_merge((array) $obj1, (array) $obj2);

    public static function getEleDefaultAttrs($ele){
        $defaultAttrs = (object)array();
        //AzuraElements::loadElementsOptions();
        $elementsOptions = AzuraElements::getElementsOptions();
        if($ele->type && isset($elementsOptions[$ele->type])){
            $newele = $elementsOptions[$ele->type];
            if(isset($newele['attrs'])){
                $newAttrs = self::generateAttrs($newele['attrs']);
                $defaultAttrs = (object) array_merge((array) $defaultAttrs, (array) $newAttrs);
            }
            if(isset($newele['showAnimationTab']) && $newele['showAnimationTab'] ){
                if(isset($elementsOptions['ElementAnimationOptions'])){
                    if(isset($elementsOptions['ElementAnimationOptions']['attrs'])){
                        $newAttrs = self::generateAttrs($elementsOptions['ElementAnimationOptions']['attrs']);
                        $defaultAttrs = (object) array_merge((array) $defaultAttrs, (array) $newAttrs);
                    }
                }
            }
            if(isset($newele['showResponsiveTab']) && $newele['showResponsiveTab'] ){
                if(isset($elementsOptions['ElementResponsiveOptions'])){
                    if(isset($elementsOptions['ElementResponsiveOptions']['attrs'])){
                        $newAttrs = self::generateAttrs($elementsOptions['ElementResponsiveOptions']['attrs']);
                        $defaultAttrs = (object) array_merge((array) $defaultAttrs, (array) $newAttrs);
                    }
                }
            }
            if(isset($newele['showStyleTab']) && $newele['showStyleTab'] ){
                if(isset($elementsOptions['ElementStyleOptions'])){
                    if(isset($elementsOptions['ElementStyleOptions']['attrs'])){
                        $newAttrs = self::generateAttrs($elementsOptions['ElementStyleOptions']['attrs']);
                        $defaultAttrs = (object) array_merge((array) $defaultAttrs, (array) $newAttrs);
                    }
                }
            }
            if(isset($newele['showTypographyTab']) && $newele['showTypographyTab'] ){
                if(isset($elementsOptions['ElementTypographyOptions'])){
                    if(isset($elementsOptions['ElementTypographyOptions']['attrs'])){
                        $newAttrs = self::generateAttrs($elementsOptions['ElementTypographyOptions']['attrs']);
                        $defaultAttrs = (object) array_merge((array) $defaultAttrs, (array) $newAttrs);
                    }
                }
            }
            
        }
        //var_dump($defaultAttrs);

        $defaultAttrs->el_disable = 'no';

        return $defaultAttrs;
    }

    protected static function parseElementModel($item){
        $model = (object) array('type' => 'AzuraElement','name' => 'Element 2','published' => '1','language' => '*','content' => null,'attrs' => null,'children'=>array() );
        //var_dump($item);
        



        foreach ((array)$item as $index => $sub) {
            if($index == 0){
                $model->type = self::parseShortcodeName($sub);
                $defaultAttrs = self::getEleDefaultAttrs($model);
                $newAttrs = self::parseShortcodeAttrs($sub);
                $model->attrs = (object) array_merge((array) $defaultAttrs, (array) $newAttrs);
            }else{
                if(is_array($sub)){
                    $model->children[] = $sub;
                }elseif(is_string($sub)){
                    if($selfele = self::checkSelfClosedShortcode($sub)){
                        $model->children[] = $selfele;
                    }else{
                        $tag_end = self::parseShortcodeName($sub);
                        if($tag_end && $tag_end == $model->type) {
                            $model->isContainer = true;
                            if(!isset($model->content)) $model->content = '';
                        }else if($tag_end == ''){
                            if(count(self::$customShortcodes)) {
                                //echo'<pre>';
                                if(preg_match("/^\/?(".implode("|", self::$customShortcodes).")/", $sub)) $sub = "[" . $sub;
                                //var_dump($sub);
                            }
                            if(isset($model->content)) {
                                $model->content .= $sub;
                            }else{
                                $model->content = $sub;
                            }

                        }
                    }
                }
            }
        }
        if(!isset($model->content))  $model->content = self::getEleDefaultContent($model);



        return $model ;
    }

    public static function loadModule($id,$style = 'none'){
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select("title,module")->from("#__modules")->where('id='.(int)$id);
        $db->setQuery($query);
        $result = $db->loadObject();
        $title = $result->title;
        $mod = $result->module;
        //echo'<pre>';var_dump($result);die;
        $module = AzuraModuleHelper::getModule( $mod, $title );
        //echo'<pre>';var_dump($module);die;
        $module->content = AzuraModuleHelper::renderModule( $module,array('style'=>$style));

        if($module->content){
            $app = JFactory::getApplication();
            $user = JFactory::getUser();
            $frontediting = ($app->isSite() && $app->get('frontediting', 1) && !$user->guest);

            $menusEditing = ($app->get('frontediting', 1) == 2) && $user->authorise('core.edit', 'com_menus');
            if ($frontediting && trim($module->content) != '' && $user->authorise('module.edit.frontend', 'com_modules.module.' . $module->id))
            {
                $displayData = array('moduleHtml' => &$module->content, 'module' => $module, 'position' => $module->position, 'menusediting' => $menusEditing);
                JLayoutHelper::render('joomla.edit.frontediting_modules', $displayData);
            }

        }
        return $module;
    }

    // protected static function addShortcodeTemplate($file){
    //     //jimport( 'joomla.filesystem.file' );
    //     $plugOverride       = JPATH_PLUGINS .'/azura/azuraoption/shortcodes/templates/'.$file.'.php';
    //     $tempOverride       = JPATH_THEMES .'/'.JFactory::getApplication()->getTemplate().'/html/com_azurapagebuilder/plugin/shortcodes_template/'.$file.'.php';
    //     $tempBase   = JPATH_ROOT.'/administrator/components/com_azurapagebuilder/elements/shortcodes_template/'.$file.'.php';
    //     if(JFile::exists($plugOverride)){
    //         return $plugOverride;
    //     }elseif(JFile::exists($tempOverride)){
    //         return $tempOverride;
    //     }elseif(JFile::exists($tempBase)){
    //         return $tempBase;
    //     }else{
    //         return false;
    //     }
    // }

    // static function content( $atts, $content = null ,$tag) {
    //     return self::loadTemplate( $atts, $content ,$tag);
    // }
    // public static function getTemplate( $atts, $content = null ,$tag) {
    //     extract(self::merge_atts(array(
    //             'layout'=>''
    //     ), $atts));

    //     $shortcodeTemp = false;

    //     if(stripos($layout, '_:') !== false){
    //         //$shortcodeTemp = JPATH_COMPONENT_ADMINISTRATOR.'/elements/shortcodes_template/'.substr($layout, 2).'.php';
    //         $shortcodeTemp = self::addShortcodeTemplate(substr($layout, 2));
    //     }else{
    //         if(stripos($layout, ':') !== false){
    //             //$shortcodeTemp = JPATH_THEMES .'/'.JFactory::getApplication()->getTemplate(). '/html/com_azurapagebuilder/plugin/shortcodes_template/'.substr($layout, stripos($layout, ':')+1).'.php';
    //             $shortcodeTemp = self::addShortcodeTemplate(substr($layout, stripos($layout, ':')+1));
    //         }else{
    //             $shortcodeTemp = self::addShortcodeTemplate($tag);
    //         }
    //     }

    //     return $shortcodeTemp;

    // }
    // public static function loadTemplate( $atts, $content = null ,$tag) {
    //     extract(self::merge_atts(array(
    //             'layout'=>''
    //     ), $atts));

    //     $shortcodeTemp = false;

    //     if(stripos($layout, '_:') !== false){
    //         //$shortcodeTemp = JPATH_COMPONENT_ADMINISTRATOR.'/elements/shortcodes_template/'.substr($layout, 2).'.php';
    //         $shortcodeTemp = self::addShortcodeTemplate(substr($layout, 2));
    //     }else{
    //         if(stripos($layout, ':') !== false){
    //             //$shortcodeTemp = JPATH_THEMES .'/'.JFactory::getApplication()->getTemplate(). '/html/com_azurapagebuilder/plugin/shortcodes_template/'.substr($layout, stripos($layout, ':')+1).'.php';
    //             $shortcodeTemp = self::addShortcodeTemplate(substr($layout, stripos($layout, ':')+1));
    //         }else{
    //             $shortcodeTemp = self::addShortcodeTemplate($tag);
    //         }
    //     }

    //     //echo'<pre>';var_dump($shortcodeTemp);die;
        
        
    //     $buffer = ob_get_clean();
        
    //     ob_start();
        
    //     if($shortcodeTemp !== false) require $shortcodeTemp;
        
    //     $content = ob_get_clean();
        
    //     ob_start();
        
    //     echo $buffer;
        
    //     return $content;

    // }

    public static function contentNew($attrs, $content = null,$element) {
        return self::loadTemplateNew( (array)$attrs, $content ,$element);
    }

    protected static function loadTemplateNew( $azura_attrs, $azura_content = null ,$azura_element = '') {
        $shortcodeTemp = false;
        $elementsOptions = AzuraElements::getElementsOptions();
        if($azura_element && isset($elementsOptions[$azura_element])){
            if(isset($elementsOptions[$azura_element]['template_path']) && $elementsOptions[$azura_element]['template_path'] != ''){
                if(JFile::exists($elementsOptions[$azura_element]['template_path'])){
                    $shortcodeTemp = $elementsOptions[$azura_element]['template_path'] ;
                }
            }
        }

        if(!$shortcodeTemp) $shortcodeTemp = self::checkShortcodeTemplateNew(strtolower($azura_element));
        
        
        $buffer = ob_get_clean();
        
        ob_start();
        
        if($shortcodeTemp !== false) require $shortcodeTemp;
        
        $content = ob_get_clean();
        
        ob_start();
        
        echo $buffer;
        
        return $content;

    }
    protected static function checkShortcodeTemplateNew($file){
        $plugOverride       = JPATH_PLUGINS .'/azura/azuraoption/elements/'.$file.'.php';
        $tempOverride       = JPATH_THEMES .'/'.JFactory::getApplication()->getTemplate().'/html/com_azurapagebuilder/elements/'.$file.'.php';
        $tempBase   = JPATH_ROOT.'/administrator/components/com_azurapagebuilder/elements/'.$file.'.php';
        if(JFile::exists($plugOverride)){
            return $plugOverride;
        }elseif(JFile::exists($tempOverride)){
            return $tempOverride;
        }elseif(JFile::exists($tempBase)){
            return $tempBase;
        }else{
            return false;
        }
    }

    public static function buildStyle($atts, $addit = '', $pseudo = ''){
        $styleArr = self::merge_atts(array(

            'margin_top'=>'',
            'margin_right' => '',
            'margin_bottom'=>'',
            'margin_left'=>'',

            'border_top'=>'',
            'border_right' => '',
            'border_bottom'=>'',
            'border_left'=>'',

            'padding_top'=>'',
            'padding_right' => '',
            'padding_bottom'=>'',
            'padding_left'=>'',

            'border_color'=>'',
            'border_style' => '',

            'background_color'=>'',
            'background_image'=>'',
            'background_repeat'=>'',
            'background_attachment'=>'',
            'background_size'=>'',
            'background_position' => '',
            'additional_style'=>'',
            'simplified'=>''

        ), $atts);

        //var_dump($styleArr);

        $styleTextArr = self::parseStyle($styleArr);

        $returnstyle = '';

        $styleText = implode(" ", $styleTextArr);
        
        $styleTextTest = trim($styleText);
        if(!empty($styleTextTest)){
          $returnstyle .= trim($styleText);
        }

        if($addit != '') $returnstyle .= $addit;
        //if($pseudo != '') $returnstyle = '{'. $returnstyle .'}'. $pseudo;
        if($pseudo != '') $returnstyle .=  $pseudo;

        if(!empty($returnstyle)){
          $returnstyle = 'style="'.$returnstyle.'"';
        }

        return $returnstyle;
    }

    public static function buildTypography($atts){
        $styleArr = self::merge_atts(array(
            'typo_tempfont' => '1',
            'typo_googlefont' => '',
            'typo_fontsize' => '',
            'typo_lheight' => '',
            'typo_textcolor'=>'',
            'typo_textalign'=>'',
            'typo_texttransform'=>'',
            'typo_letterspacing'=>'',
            'typo_textindent'=>'',


        ), $atts);

        $typo_styles = '';
        if($styleArr['typo_tempfont'] === '0' && $styleArr['typo_googlefont'] !=''){
            $font_family = explode(":", $styleArr['typo_googlefont']);
            AzuraJs::addGoogleFonts($font_family[0],$font_family[1]);

            $typo_styles .= 'font-family:\''.$font_family[0].'\', sans-serif;';

            if($font_family[1] == 'italic'){
                $typo_styles .= 'font-style:italic;';
            }elseif($font_family[1] == 'regular'){
                $typo_styles .= 'font-weight:normal;';
            }else{
                $italic_pos = strpos($font_family[1],'italic');
                if($italic_pos){
                    $typo_styles .= 'font-weight:'.substr($font_family[1],0,$italic_pos).';font-style:italic;';
                }else{
                    $typo_styles .= 'font-weight:'.$font_family[1].';';
                }
              
            }
        }


        if($styleArr['typo_fontsize']!=''){
            if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['typo_fontsize'])){
                $typo_styles .= 'font-size:'.$styleArr['typo_fontsize'].'px;';
            }else{
                $typo_styles .= 'font-size:'.$styleArr['typo_fontsize'].';';
            }
        }
        if($styleArr['typo_lheight']!=''){

            $typo_styles .= 'line-height:'.$styleArr['typo_lheight'].';';

        }

        if($styleArr['typo_textcolor']!=''){
            $typo_styles .= 'color:'.$styleArr['typo_textcolor'].';';
        }

        if($styleArr['typo_textalign']!=''){
            $typo_styles .= 'text-align:'.$styleArr['typo_textalign'].';';
        }
        if($styleArr['typo_texttransform']!=''){
            $typo_styles .= 'text-transform:'.$styleArr['typo_texttransform'].';';
        }
        if($styleArr['typo_letterspacing']!=''){
            if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['typo_letterspacing'])){
                $typo_styles .= 'letter-spacing:'.$styleArr['typo_letterspacing'].'px;';
            }else{
                $typo_styles .= 'letter-spacing:'.$styleArr['typo_letterspacing'].';';
            }
        }
        if($styleArr['typo_textindent']!=''){
            if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['typo_textindent'])){
                $typo_styles .= 'text-indent:'.$styleArr['typo_textindent'].'px;';
            }else{
                $typo_styles .= 'text-indent:'.$styleArr['typo_textindent'].';';
            }
        }


        $typo_styles = trim($typo_styles);
        if(!empty($typo_styles)){
            $custom_typo_class = uniqid('azp_typo_');
            $typo_styles = '.'.$custom_typo_class.'{'.$typo_styles.'}';
            AzuraJs::addInlineStyle($typo_styles);
            return $custom_typo_class;
        }

        return '';
    }

    public static function buildResponsive($atts,$prefix_cl = 'azp_'){
        //$return = array();
        $responsiveTxt = self::parseResponsive(self::merge_atts(array(


            'lgoffsetclass'   =>'',
            'lgwidthclass'    =>'',
            'hidden-lg'     =>'',

            'mdoffsetclass'   =>'',
            'mdwidthclass'    =>'',
            'hidden-md'     =>'',

            'smoffsetclass'   =>'',
            'smwidthclass'    =>'', //is $columnwidthclass
            'hidden-sm'     =>'',

            'xsoffsetclass'   =>'',
            'xswidthclass'    =>'',
            'hidden-xs'     =>'',

        ), $atts),$prefix_cl);

        return $responsiveTxt;
    }

    public static function buildAnimation($atts,$trigger_cl = 'animated'){
        $return = array();
        $animationArgs = self::merge_atts(array(

            'animation'=>'0',
            //'trigger' => 'animate-in',
            'animationtype'=>'',
            'hoveranimationtype'=>'',
            'infinite'=>'0',
            'animationdelay'=>'0',
            'animationduration'=>'',

         ), $atts);

        $return['trigger'] = '';
        $return['data'] = '';
        $animationData = '';
        if($animationArgs['animation'] == '1'){
            $return['trigger'] = 'azp_animation '.$trigger_cl;
            $return['data'] = 'data-anim-type="'.$animationArgs['animationtype'].'" data-anim-delay="'.$animationArgs['animationdelay'].'"';
        }

        return $return;
    }

    public static function getAnimationClass($atts){
        $animationArgs = self::merge_atts(array(

            'use_animation'=>'0',
            'animationtype' => '',
            'is_infinite'=>'0',

         ), $atts);

        if($animationArgs['use_animation'] == '1'){
            $return = ' animated '. $animationArgs['animationtype'] ;
            if($animationArgs['is_infinite'] == '1') $return .= ' infinite';
            return $return;
        }

        return '';
    }

    protected static function parseStyle($styleArr = array()){
        if(empty($styleArr)){
            return '';
        }
        else {
            //echo '<pre>';var_dump($styleArr);die;
            //margin
            $margin_style = '';
            if($styleArr['margin_top']!=''||$styleArr['margin_right']!=''||$styleArr['margin_bottom']!=''||$styleArr['margin_left']!=''){
                if($styleArr['simplified'] == '1'){
                    if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['margin_top'])){
                        $margin_style = 'margin: '.$styleArr['margin_top'].'px;';
                    }else{
                        $margin_style = 'margin: '.$styleArr['margin_top'].';';
                    }
                }else{
                    if($styleArr['margin_top']!=''){
                        if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['margin_top'])){
                            $margin_style = 'margin-top: '.$styleArr['margin_top'].'px;';
                        }else{
                            $margin_style = 'margin-top: '.$styleArr['margin_top'].';';
                        }
                    }

                    if($styleArr['margin_right']!=''){
                        if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['margin_right'])){
                            $margin_style .= 'margin-right: '.$styleArr['margin_right'].'px;';
                        }else{
                            $margin_style .= 'margin-right: '.$styleArr['margin_right'].';';
                        }
                    }

                    if($styleArr['margin_bottom']!=''){
                        if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['margin_bottom'])){
                            $margin_style .= 'margin-bottom: '.$styleArr['margin_bottom'].'px;';
                        }else{
                            $margin_style .= 'margin-bottom: '.$styleArr['margin_bottom'].';';
                        }
                    }

                    if($styleArr['margin_left']!=''){
                        if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['margin_left'])){
                            $margin_style .= 'margin-left: '.$styleArr['margin_left'].'px;';
                        }else{
                            $margin_style .= 'margin-left: '.$styleArr['margin_left'].';';
                        }
                    }
                }
            }

            //padding
            $padding_style = '';
            if($styleArr['padding_top']!=''||$styleArr['padding_right']!=''||$styleArr['padding_bottom']!=''||$styleArr['padding_left']!=''){
                if($styleArr['simplified'] == '1'){
                    if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['padding_top'])){
                        $padding_style = 'padding: '.$styleArr['padding_top'].'px;';
                    }else{
                        $padding_style = 'padding: '.$styleArr['padding_top'].';';
                    }
                }else{
                    if($styleArr['padding_top']!=''){
                        if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['padding_top'])){
                            $padding_style = 'padding-top: '.$styleArr['padding_top'].'px;';
                        }else{
                            $padding_style = 'padding-top: '.$styleArr['padding_top'].';';
                        }
                    }

                    if($styleArr['padding_right']!=''){
                        if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['padding_right'])){
                            $padding_style .= 'padding-right: '.$styleArr['padding_right'].'px;';
                        }else{
                            $padding_style .= 'padding-right: '.$styleArr['padding_right'].';';
                        }
                    }

                    if($styleArr['padding_bottom']!=''){
                        if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['padding_bottom'])){
                            $padding_style .= 'padding-bottom: '.$styleArr['padding_bottom'].'px;';
                        }else{
                            $padding_style .= 'padding-bottom: '.$styleArr['padding_bottom'].';';
                        }
                    }

                    if($styleArr['padding_left']!=''){
                        if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['padding_left'])){
                            $padding_style .= 'padding-left: '.$styleArr['padding_left'].'px;';
                        }else{
                            $padding_style .= 'padding-left: '.$styleArr['padding_left'].';';
                        }
                    }
                }
            }

            //border
            $border_width_style = '';
            if($styleArr['border_top']!=''||$styleArr['border_right']!=''||$styleArr['border_bottom']!=''||$styleArr['border_left']!=''){
                if($styleArr['simplified'] == '1'){
                    if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['border_top'])){
                        $border_width_style = 'border-width: '.$styleArr['border_top'].'px;';
                    }else{
                        $border_width_style = 'border-width: '.$styleArr['border_top'].';';
                    }
                }else{
                    if($styleArr['border_top']!=''){
                        if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['border_top'])){
                            $border_width_style = 'border-top-width: '.$styleArr['border_top'].'px;';
                        }else{
                            $border_width_style = 'border-top-width: '.$styleArr['border_top'].';';
                        }
                    }

                    if($styleArr['border_right']!=''){
                        if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['border_right'])){
                            $border_width_style .= 'border-right-width: '.$styleArr['border_right'].'px;';
                        }else{
                            $border_width_style .= 'border-right-width: '.$styleArr['border_right'].';';
                        }
                    }

                    if($styleArr['border_bottom']!=''){
                        if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['border_bottom'])){
                            $border_width_style .= 'border-bottom-width: '.$styleArr['border_bottom'].'px;';
                        }else{
                            $border_width_style .= 'border-bottom-width: '.$styleArr['border_bottom'].';';
                        }
                    }

                    if($styleArr['border_left']!=''){
                        if(!preg_match('/\d*\.?\d*\s*(%|em|px)$/i', $styleArr['border_left'])){
                            $border_width_style .= 'border-left-width: '.$styleArr['border_left'].'px;';
                        }else{
                            $border_width_style .= 'border-left-width: '.$styleArr['border_left'].';';
                        }
                    }
                }
            }

            if($styleArr['border_color']!=''){
                $border_color = 'border-color: '.$styleArr['border_color'].';';
            }else{
                $border_color = '';
            }



            if($styleArr['border_style']!=''){
                $border_style_style = 'border-style: '.$styleArr['border_style'].';';
            }else{
                $border_style_style = '';
            }

            $border_style = $border_color. ' '.$border_width_style .' '. $border_style_style;

            // background;

            if($styleArr['background_color']!=''){
                $background_color = 'background-color: '.$styleArr['background_color'].';';
            }else{
                $background_color = '';
            }

            if($styleArr['background_image']!=''){
                $background_image = 'background-image: url(\''.JURI::root().$styleArr['background_image'].'\');';
            }else{
                $background_image = '';
            }

            if($styleArr['background_repeat']!='' && $background_image != ''){
                $background_repeat_style = 'background-repeat: '.$styleArr['background_repeat'].';';
                
            }else{
                $background_repeat_style = '';
            }

            if($styleArr['background_attachment']!=''&& $background_image != ''){
                $background_attachment_style = 'background-attachment: '.$styleArr['background_attachment'].';';
                
            }else{
                $background_attachment_style = '';
            }

            if($styleArr['background_size']!=''&& $background_image != ''){
                $background_size_style = '-webkit-background-size: '.$styleArr['background_size'].'; -moz-background-size: '.$styleArr['background_size'].';-o-background-size: '.$styleArr['background_size'].';background-size: '.$styleArr['background_size'].';';
                
            }else{
                $background_size_style = '';
            }
            if($styleArr['background_position']!=''&& $background_image != ''){
                $background_position_style = 'background-position: '.$styleArr['background_position'].';';
                
            }else{
                $background_position_style = '';
            }

            

            $background_style = $background_color .$background_image .$background_repeat_style. $background_attachment_style. $background_size_style.$background_position_style;

            // additional style
            if($styleArr['additional_style']!=''){
                $additional_style = $styleArr['additional_style'];
            }else{
                $additional_style ='';
            }

            $return = array();

            $return['margin'] = $margin_style;
            $return['padding'] = $padding_style;
            $return['border'] = $border_style;
            $return['background'] = $background_style;
            $return['additional_style'] = $additional_style;

            return $return;
        }
    }

    // Parse Column Responsive 
    protected static function parseResponsive($atts,$pre='azp_'){
        //echo'<pre>';var_dump($atts);die;
        if(empty($atts)){
            return '';
        }

        $responsiveText = '';
        // Mobile - Extra Small View
        if($atts['xswidthclass']){
            $responsiveText .= ' '.$pre.$atts['xswidthclass'];
        }
        if($atts['xsoffsetclass']){
            $responsiveText .= ' '.$pre.$atts['xsoffsetclass'];
        }
        if($atts['hidden-xs'] && $atts['hidden-xs'] === '1'){
            $responsiveText .= ' '.$pre.'hidden-xs';
        }
        //Tablet Vertical - Small View
        if($atts['smoffsetclass']){
            $responsiveText .= ' '.$pre.$atts['smoffsetclass'];
        }
        // if($atts['xsoffsetclass']){
        //  $responsiveText .= ' '.$atts['xsoffsetclass'];
        // }
        // Inherit from $columnwidthclass

        if($atts['hidden-sm'] && $atts['hidden-sm'] === '1'){
            $responsiveText .= ' '.$pre.'hidden-sm';
        }

        // Tablet Horizontal - Medium view
        if($atts['mdwidthclass']){
            $responsiveText .= ' '.$pre.$atts['mdwidthclass'];
        }
        if($atts['mdoffsetclass']){
            $responsiveText .= ' '.$pre.$atts['mdoffsetclass'];
        }
        if($atts['hidden-md'] && $atts['hidden-md'] === '1'){
            $responsiveText .= ' '.$pre.'hidden-md';
        }

        // Desktop - Large view
        if($atts['lgwidthclass']){
            $responsiveText .= ' '.$pre.$atts['lgwidthclass'];
        }
        if($atts['lgoffsetclass']){
            $responsiveText .= ' '.$pre.$atts['lgoffsetclass'];
        }
        if($atts['hidden-lg'] && $atts['hidden-lg'] === '1'){
            $responsiveText .= ' '.$pre.'hidden-lg';
        }


        $responsiveText = trim($responsiveText);
        //echo'<pre>';var_dump($responsiveText);die;
        return $responsiveText;
    }
    public static function parseResponsiveNew($atts,$pre='azp_'){
        //echo'<pre>';var_dump($atts);die;

        $atts = array_merge(
            array(


                'lgoffsetclass'   =>'',
                'lgwidthclass'    =>'',
                'hidden-lg'     =>'',

                'mdoffsetclass'   =>'',
                'mdwidthclass'    =>'',
                'hidden-md'     =>'',

                'smoffsetclass'   =>'',
                'smwidthclass'    =>'', //is $columnwidthclass
                'hidden-sm'     =>'',

                'xsoffsetclass'   =>'',
                'xswidthclass'    =>'',
                'hidden-xs'     =>'',

            ),
            $atts
        );

        if(empty($atts)){
            return '';
        }

        //echo'<pre>';var_dump($atts);die;

        $responsiveText = '';
        // Mobile - Extra Small View
        if($atts['xswidthclass']){
            $responsiveText .= ' '.$pre.$atts['xswidthclass'];
        }
        if($atts['xsoffsetclass']){
            $responsiveText .= ' '.$pre.$atts['xsoffsetclass'];
        }
        if($atts['hidden-xs'] && $atts['hidden-xs'] === '1'){
            $responsiveText .= ' '.$pre.'hidden-xs';
        }
        //Tablet Vertical - Small View
        if($atts['smoffsetclass']){
            $responsiveText .= ' '.$pre.$atts['smoffsetclass'];
        }
        // if($atts['xsoffsetclass']){
        //  $responsiveText .= ' '.$atts['xsoffsetclass'];
        // }
        // Inherit from $columnwidthclass

        if($atts['hidden-sm'] && $atts['hidden-sm'] === '1'){
            $responsiveText .= ' '.$pre.'hidden-sm';
        }

        // Tablet Horizontal - Medium view
        if($atts['mdwidthclass']){
            $responsiveText .= ' '.$pre.$atts['mdwidthclass'];
        }
        if($atts['mdoffsetclass']){
            $responsiveText .= ' '.$pre.$atts['mdoffsetclass'];
        }
        if($atts['hidden-md'] && $atts['hidden-md'] === '1'){
            $responsiveText .= ' '.$pre.'hidden-md';
        }

        // Desktop - Large view
        if($atts['lgwidthclass']){
            $responsiveText .= ' '.$pre.$atts['lgwidthclass'];
        }
        if($atts['lgoffsetclass']){
            $responsiveText .= ' '.$pre.$atts['lgoffsetclass'];
        }
        if($atts['hidden-lg'] && $atts['hidden-lg'] === '1'){
            $responsiveText .= ' '.$pre.'hidden-lg';
        }


        $responsiveText = trim($responsiveText);
        //echo'<pre>';var_dump($responsiveText);die;
        return $responsiveText;
    }

    public static function slug($str){
        return preg_replace('/[^a-z0-9_]/i', '-', strtolower($str));
    }
    /*for joomla article*/
    public static function getArticleAuthorName($article = ''){
        if(isset($article->created_by_alias) && $article->created_by_alias != ''){
            return $article->created_by_alias;
        }elseif(isset($article->created_by) && is_numeric($article->created_by)){
            $author = JFactory::getUser((int)$article->created_by);
            return $author->name;
        }
        return '';
    }
    public static function getContentItem($id = 0,$addFields = ''){
        $user   = JFactory::getUser();
        try
            {
                $db = JFactory::getDbo();
                $query = $db->getQuery(true)
                    ->select(
                        //$this->getState(
                            'a.id, a.asset_id, a.title, a.alias, a.introtext, a.fulltext, ' .
                            // If badcats is not null, this means that the article is inside an unpublished category
                            // In this case, the state is set to 0 to indicate Unpublished (even if the article state is Published)
                            'CASE WHEN badcats.id is null THEN a.state ELSE 0 END AS state, ' .
                            'a.catid, a.created, a.created_by, a.created_by_alias, ' .
                            // Use created if modified is 0
                            'CASE WHEN a.modified = ' . $db->quote($db->getNullDate()) . ' THEN a.created ELSE a.modified END as modified, ' .
                            'a.modified_by, a.checked_out, a.checked_out_time, a.publish_up, a.publish_down, ' .
                            'a.images, a.urls, a.attribs, a.version, a.ordering, ' .
                            'a.metakey, a.metadesc, a.access, a.hits, a.metadata, a.featured, a.language, a.xreference'
                        //)
                    );
                $query->from('#__content AS a');

                // Join on category table.
                $query->select('c.title AS category_title, c.alias AS category_alias, c.access AS category_access')
                    ->join('LEFT', '#__categories AS c on c.id = a.catid');

                // Join on user table.
                $query->select('u.name AS author')
                    ->join('LEFT', '#__users AS u on u.id = a.created_by');

                // Filter by language
                // if ($this->getState('filter.language'))
                // {
                //     $query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
                // }

                // Join over the categories to get parent category titles
                $query->select('parent.title as parent_title, parent.id as parent_id, parent.path as parent_route, parent.alias as parent_alias')
                    ->join('LEFT', '#__categories as parent ON parent.id = c.parent_id');

                // Join on voting table
                $query->select('ROUND(v.rating_sum / v.rating_count, 0) AS rating, v.rating_count as rating_count')
                    ->join('LEFT', '#__content_rating AS v ON a.id = v.content_id')

                    ->where('a.id = ' . (int) $id);

                if ((!$user->authorise('core.edit.state', 'com_content')) && (!$user->authorise('core.edit', 'com_content')))
                {
                    // Filter by start and end dates.
                    $nullDate = $db->quote($db->getNullDate());
                    $date = JFactory::getDate();

                    $nowDate = $db->quote($date->toSql());

                    $query->where('(a.publish_up = ' . $nullDate . ' OR a.publish_up <= ' . $nowDate . ')')
                        ->where('(a.publish_down = ' . $nullDate . ' OR a.publish_down >= ' . $nowDate . ')');
                }

                // Join to check for category published state in parent categories up the tree
                // If all categories are published, badcats.id will be null, and we just use the article state
                $subquery = ' (SELECT cat.id as id FROM #__categories AS cat JOIN #__categories AS parent ';
                $subquery .= 'ON cat.lft BETWEEN parent.lft AND parent.rgt ';
                $subquery .= 'WHERE parent.extension = ' . $db->quote('com_content');
                $subquery .= ' AND parent.published <= 0 GROUP BY cat.id)';
                $query->join('LEFT OUTER', $subquery . ' AS badcats ON badcats.id = c.id');

                // Filter by published state.
                $published = 1;//$this->getState('filter.published');
                //$archived = $this->getState('filter.archived');

                if (is_numeric($published))
                {
                    // $query->where('(a.state = ' . (int) $published . ' OR a.state =' . (int) $archived . ')');
                    $query->where('a.state = ' . (int) $published );
                }

                $db->setQuery($query);

                $data = $db->loadObject();

                $item = $data;

            }
            catch (Exception $e)
            {
                if ($e->getCode() == 404)
                {
                    // Need to go thru the error handler to allow Redirect to work.
                    JError::raiseError(404, $e->getMessage());
                }
                else
                {
                    // $this->setError($e);
                    JError::raiseError( 4711, $e->getMessage());
                    $item = false;
                }
            }

        return $item;
    }

    public static function getContentItemNew($id = 0,$addFields = ''){
        $user   = JFactory::getUser();
        try
            {
                $db = JFactory::getDbo();
                $query = $db->getQuery(true);
                $query->select('a.id,a.title,a.alias,a.introtext,a.fulltext,a.catid')
                ->select('a.created,a.created_by,a.created_by_alias,a.ordering,a.images,a.urls,a.attribs');
                if(!empty($addFields)){
                    $query  ->select($addFields);
                }

                    // ->select(
                    //     //$this->getState(
                    //         'a.id, a.asset_id, a.title, a.alias, a.introtext, a.fulltext, ' .
                    //         // If badcats is not null, this means that the article is inside an unpublished category
                    //         // In this case, the state is set to 0 to indicate Unpublished (even if the article state is Published)
                    //         'CASE WHEN badcats.id is null THEN a.state ELSE 0 END AS state, ' .
                    //         'a.catid, a.created, a.created_by, a.created_by_alias, ' .
                    //         // Use created if modified is 0
                    //         'CASE WHEN a.modified = ' . $db->quote($db->getNullDate()) . ' THEN a.created ELSE a.modified END as modified, ' .
                    //         'a.modified_by, a.checked_out, a.checked_out_time, a.publish_up, a.publish_down, ' .
                    //         'a.images, a.urls, a.attribs, a.version, a.ordering, ' .
                    //         'a.metakey, a.metadesc, a.access, a.hits, a.metadata, a.featured, a.language, a.xreference'
                    //     //)
                    // );
                $query->from('#__content AS a');

                // Join on category table.
                $query->select('c.title AS cattitle, c.alias AS catalias, c.description AS catdesc')
                    ->join('LEFT', '#__categories AS c on c.id = a.catid');

                // Join on user table.
                // $query->select('u.name AS author')
                //     ->join('LEFT', '#__users AS u on u.id = a.created_by');

                // Filter by language
                // if ($this->getState('filter.language'))
                // {
                //     $query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
                // }

                // Join over the categories to get parent category titles
                // $query->select('parent.title as parent_title, parent.id as parent_id, parent.path as parent_route, parent.alias as parent_alias')
                //     ->join('LEFT', '#__categories as parent ON parent.id = c.parent_id');

                // Join on voting table
                $query->select('ROUND(v.rating_sum / v.rating_count, 0) AS rating, v.rating_count as rating_count')
                    ->join('LEFT', '#__content_rating AS v ON a.id = v.content_id')

                    ->where('a.id = ' . (int) $id)
                    ->where('a.state = 1');

                if ((!$user->authorise('core.edit.state', 'com_content')) && (!$user->authorise('core.edit', 'com_content')))
                {
                    // Filter by start and end dates.
                    $nullDate = $db->quote($db->getNullDate());
                    $date = JFactory::getDate();

                    $nowDate = $db->quote($date->toSql());

                    $query->where('(a.publish_up = ' . $nullDate . ' OR a.publish_up <= ' . $nowDate . ')')
                        ->where('(a.publish_down = ' . $nullDate . ' OR a.publish_down >= ' . $nowDate . ')');
                }

                // Join to check for category published state in parent categories up the tree
                // If all categories are published, badcats.id will be null, and we just use the article state
                // $subquery = ' (SELECT cat.id as id FROM #__categories AS cat JOIN #__categories AS parent ';
                // $subquery .= 'ON cat.lft BETWEEN parent.lft AND parent.rgt ';
                // $subquery .= 'WHERE parent.extension = ' . $db->quote('com_content');
                // $subquery .= ' AND parent.published <= 0 GROUP BY cat.id)';
                // $query->join('LEFT OUTER', $subquery . ' AS badcats ON badcats.id = c.id');

                $db->setQuery($query);

                $data = $db->loadObject();

                //$item = $data;

                $data->tags = new JHelperTags;
                $data->tags->getItemTags('com_content.article', $data->id);

            }
            catch (Exception $e)
            {
                if ($e->getCode() == 404)
                {
                    // Need to go thru the error handler to allow Redirect to work.
                    JError::raiseError(404, $e->getMessage());
                }
                else
                {
                    // $this->setError($e);
                    JError::raiseError( 4711, $e->getMessage());
                    $data = false;
                }
            }

        return $data;
    }

    public static function getContentItems($catid, $limit='All', $order='created', $orderDir='DESC', $addFields = ''){
        $order = 'a.'.$order;
        if((int)$limit){
            $limit = (int) $limit;
        }else{
            $limit = 'All';
        }
        $db     = JFactory::getDbo();
        $query  = $db->getQuery(true);
        $where  = array('a.state=1');
        if($catid !=0){
            $where[] = 'catid='.(int)$catid;
        }
        $query->select('a.id,a.title,a.alias,a.introtext,a.fulltext,a.catid,c.alias as catalias,c.title as cattitle, c.description as catdesc')
                ->select('a.created,a.created_by,a.created_by_alias,a.ordering,a.images,a.urls,a.attribs');
        if(!empty($addFields)){
            $query  ->select($addFields);
        }

        $query  ->from('#__content AS a')
                ->join('INNER', '#__categories AS c ON (a.catid = c.id)')
                ->where($where)
                ->order($db->escape($order . ' ' . $orderDir));
        $db     ->setQuery($query,0,$limit);

        $articles = array();

        $temp = $db->loadObjectList();

        if(isset($temp) && count($temp)){
            foreach ($temp as $art) {
                $art->tags = new JHelperTags;
                $art->tags->getItemTags('com_content.article', $art->id);

                $articles[] = $art;
            }
        }


        return $articles;
    }

    public static function getArticlesTagsFilter($items){

        $catTags = array();

        if(count($items)){

            foreach ($items as $item) {
                if(isset($item->tags) && count($item->tags->itemTags)){
                    foreach ($item->tags->itemTags as $tag) {
                        $catTags[] = $tag->title;
                    }
                }
            }

            $catTags = array_unique($catTags);
        }
        return $catTags;
    }

    public static function getArticleTagsFilter($item,$implode = " ",$ucf = false){
        
        $tags = array();

        if(isset($item->tags) && count($item->tags->itemTags)) {
            foreach ($item->tags->itemTags as $tag) {
                $tagName = str_replace(" ", "-", $tag->title);
                if($ucf === true){
                    $tags[] = ucfirst($tagName);
                }else{
                    $tags[] = strtolower($tagName);
                }
                
            }
        }
        
        return implode($implode, $tags);
    }


    /*for joomla article end */

    /* for joomla contact component */

    public static function getContactItem($id){
        require_once (JPATH_SITE.'/components/com_contact/models/contact.php');
        require_once (JPATH_SITE.'/components/com_contact/helpers/route.php');

        $contactModel = new ContactModelContact();

        $item = $contactModel->getItem($id);

        $item->azp_link = self::cleanUrl( JRoute::_(ContactHelperRoute::getContactRoute($item->slug, $item->catid)) );

        return $item;

        

    }

    public static function extractBuilderIntroText($content){
        $introtext = '';
        if($content != ''){
            $pattern = '#<hr\s+id=("|\')system-readmore("|\')\s*\/*>#i';
            $tagPos = preg_match($pattern, $content, $matches);
            if($tagPos === 1) list ($introtext) = preg_split($pattern, $content, 2);
        }
        return $introtext;
    }

    /* for joomla contact component end */

    // K2 Component Intergrated

    public static function getK2Items($catid, $limit='All', $order='created', $orderDir='DESC', $addFields = '',$child = '0'){
        //static $itemArray = array();
        //echo'<pre>';var_dump($child);die;
        if($child == '1'){
            return self::getK2ItemsChild($catid, $limit, $order, $orderDir, $addFields);
        }
        $order = 'a.'.$order;
        if((int)$limit){
            $limit = $limit;
        }else{
            $limit = 'All';
        }
        $db =  JFactory::getDbo();
        $query=$db->getQuery(true);
        $where = array('a.published=1','a.trash=0');
        if($catid!=0){
            $where[]='catid='.(int)$catid;
        }
        $query  ->select('a.id,a.title,a.alias,a.extra_fields,a.introtext,a.fulltext,a.catid,c.alias as categoryalias,c.name as c_name, c.description as c_desc')
                ->select('a.created,a.modified,a.created_by,a.created_by_alias,a.ordering,a.image_caption,a.image_credits,a.params');
       if(!empty($addFields)){
        $query  ->select($addFields);
       }

        $query  ->from('#__k2_items AS a')
                ->join('INNER', '#__k2_categories AS c ON (a.catid = c.id)')
                ->where($where)
                ->order($db->escape($order . ' ' . $orderDir));
        $db     ->setQuery($query,0,$limit);

        $items = $db->loadObjectList();

        //return $db->loadObjectList();

        return self::prepareK2Item($items);
    }

    public static function getK2ItemsChild($catid, $limit = 'All', $order = 'created', $orderDir='ASC',$addFields=''){
        $catarray = self::getK2CategoryChildren($catid);
        array_unshift($catarray, $catid);
        //echo'<pre>';var_dump($catarray);die;
        $catsitemsarray = array();

        foreach ($catarray as $cat) {
            $catitemsarray = self::getK2Items($cat,'All',$order,$orderDir);
            foreach ($catitemsarray as $item) {
                $itempush = array();
                $itempush['id'] = $item->id;
                //$itempush['catname'] = $item->c_name;
                //$itempush['catalias'] = $item->categoryalias;
                array_push($catsitemsarray, $itempush);
            }
        }

        $return = array();

        if(is_numeric($limit)){
            for ($i=0; $i < $limit ; $i++) { 
                if($i < count($catsitemsarray)){
                    $itemreturn = self::getK2Item($catsitemsarray[$i]['id']);
                    //$itemreturn->catname = $catsitemsarray[$i]['catname'];
                    //$itemreturn->catalias = $catsitemsarray[$i]['catalias'];
                    array_push($return, $itemreturn);
                }
            }
        }else{
            foreach ($catsitemsarray as $value) {
                $itemreturn = self::getK2Item($value['id']);
                //$itemreturn->catname = $value['catname'];
                //$itemreturn->catalias = $value['catalias'];
                array_push($return, $itemreturn);
            }
        }

        return $return;
    }

    public static function getK2Item($id,$addFields = ''){
        
        $db =  JFactory::getDbo();
        $query=$db->getQuery(true);
        $where = array('a.published=1','a.trash=0');
        if($id!=0){
            //$where[]='id=42';//.$db->quote($id);
            $where[] = "a.id=".$db->quote($id);
        }
        //var_dump($where);die;
        // $query  ->select('a.id,a.title,a.alias,a.extra_fields,a.introtext,a.fulltext,a.catid')
        //         ->select('a.created,a.modified,a.created_by,a.created_by_alias,a.ordering,a.image_caption,a.image_credits,a.params');

        $query  ->select('a.id,a.title,a.alias,a.extra_fields,a.introtext,a.fulltext,a.catid,c.alias as categoryalias,c.name as c_name, c.description as c_desc')
                ->select('a.created,a.modified,a.created_by,a.created_by_alias,a.ordering,a.image_caption,a.image_credits,a.params');
       if(!empty($addFields)){
                $query  ->select($addFields);
       }

        $query  ->from('#__k2_items AS a')
                ->join('INNER', '#__k2_categories AS c ON (a.catid = c.id)')
                ->where($where);
                
        $db     ->setQuery($query);

        $item = $db->loadObject();
        require_once (JPATH_SITE.'/components/com_k2/helpers/route.php');
        require_once JPATH_SITE.'/components/com_k2/models/item.php';
        require_once JPATH_SITE.'/components/com_k2/helpers/permissions.php';

        JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2'.DS.'tables');

        $K2ModelItem = new K2ModelItem;

        
        $item = $K2ModelItem->prepareItem($item, 'itemlist', 'category');

        return $item;
    }

    public static function prepareK2Item($items , $view='itemlist', $layout = 'category'){
        require_once (JPATH_SITE.'/components/com_k2/helpers/route.php');
        require_once JPATH_SITE.'/components/com_k2/models/item.php';
        require_once JPATH_SITE.'/components/com_k2/helpers/permissions.php';

        JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2'.DS.'tables');

        $K2ModelItem = new K2ModelItem;

        
        
        $return = array();
        if($items){
            foreach ((array)$items as $key => $item) {
                $return[] = $K2ModelItem->prepareItem($item, 'itemlist', 'category');
            }
        }

        return $return;
    }

    public static function getK2Cat($catid=0){
        $db =  JFactory::getDbo();
        $query=$db->getQuery(true);
        //$where = array('a.id=1');
        if((int)$catid!=0){
            $where ='a.id='.(int)$catid;
        }
        $query      ->select('a.id,a.name,a.alias,a.description')
            ->from('#__k2_categories AS a')
            ->where($where)
            ->order('a.ordering ASC');
        $db->setQuery($query,0,1);

        return $db->loadObject();
    }

    public static function k2CatHasChildren($id)
    {

        $mainframe = JFactory::getApplication();
        $user = JFactory::getUser();
        $aid = (int)$user->get('aid');
        $id = (int)$id;
        $db = JFactory::getDBO();
        $query = "SELECT * FROM #__k2_categories  WHERE parent={$id} AND published=1 AND trash=0 ";
        if (K2_JVERSION != '15')
        {
            $query .= " AND access IN(".implode(',', $user->getAuthorisedViewLevels()).") ";
            if ($mainframe->getLanguageFilter())
            {
                $languageTag = JFactory::getLanguage()->getTag();
                $query .= " AND language IN (".$db->Quote($languageTag).", ".$db->Quote('*').") ";
            }

        }
        else
        {
            $query .= " AND access <= {$aid}";
        }

        $db->setQuery($query);
        $rows = $db->loadObjectList();
        if ($db->getErrorNum())
        {
            echo $db->stderr();
            return false;
        }

        if (count($rows))
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    public static function getK2CategoryChildren($catid)
    {

        static $array = array();
        $mainframe = JFactory::getApplication();
        $user = JFactory::getUser();
        $aid = (int)$user->get('aid');
        $catid = (int)$catid;
        $db = JFactory::getDBO();
        $query = "SELECT * FROM #__k2_categories WHERE parent={$catid} AND published=1 AND trash=0 ";
        if (K2_JVERSION != '15')
        {
            $query .= " AND access IN(".implode(',', $user->getAuthorisedViewLevels()).") ";
            if ($mainframe->getLanguageFilter())
            {
                $languageTag = JFactory::getLanguage()->getTag();
                $query .= " AND language IN (".$db->Quote($languageTag).", ".$db->Quote('*').") ";
            }
        }
        else
        {
            $query .= " AND access <= {$aid}";
        }
        $query .= " ORDER BY ordering ";

        $db->setQuery($query);
        $rows = $db->loadObjectList();
        if ($db->getErrorNum())
        {
            echo $db->stderr();
            return false;
        }
        foreach ($rows as $row)
        {
            array_push($array, $row->id);
            if (self::k2CatHasChildren($row->id))
            {
                self::getK2CategoryChildren($row->id);
            }
        }
        return $array;
    }


    public static function getK2ItemTagsFilter($item,$implode = " ",$ucf = false,$return_array = false){
        require_once JPATH_BASE.'/components/com_k2/models/item.php';

        $K2ModelItem = new K2ModelItem;

        $tags = array();
        $itemTags = $K2ModelItem->getItemTags($item->id);
        if(count($itemTags)) {
            foreach ($itemTags as $tag) {
                $tagName = str_replace(" ", "-", $tag->name);
                if($ucf === true){
                    $tags[] = ucfirst($tagName);
                }else{
                    $tags[] = strtolower($tagName);
                }
                
            }
        }
        if(!$return_array){
            $filter = implode($implode, $tags);
        }
        
        return $filter;
    }

    public static function getK2TagsFilter($items){

        $catTags = array();

        $allTags = array();

        $tags = array();

        if(count($items)){


            require_once JPATH_BASE.'/components/com_k2/models/item.php';

            $K2ModelItem = new K2ModelItem;

            foreach ($items as $item) {
                $catTags[] = $K2ModelItem->getItemTags($item->id);
            }
            
            if(!empty($catTags)){
                foreach ($catTags as $catTag) {
                    if (!empty($catTag)) {
                        foreach ($catTag as $tag) {
                            $allTags[] = $tag->name;
                        }
                    }
                }
            }

            $tags = array_unique($allTags);
        }
        return $tags;
    }

    public static function getK2ItemLink($id,$alias,$catid,$categoryalias){
        require_once (JPATH_SITE.'/components/com_k2/helpers/route.php');
        return urldecode(JRoute::_(K2HelperRoute::getItemRoute($id.':'.urlencode($alias), $catid.':'.urlencode($categoryalias))));
    }

    public static function getK2CategoryLink($catid){
        require_once (JPATH_SITE.'/components/com_k2/helpers/route.php');
        return urldecode(JRoute::_(K2HelperRoute::getCategoryRoute($catid)));
    }

    public static function userGetName($id){
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select("name")->from("#__users")->where('id='.(int)$id);
        $db->setQuery($query);
        
        return $db->loadResult();
    }

    public static function getK2ItemRates($id){
        require_once JPATH_BASE.'/components/com_k2/models/item.php';

        $K2ModelItem = new K2ModelItem;

        $itemnumOfvotes = $K2ModelItem->getVotesNum($id);
        $itemvotingPercentage = $K2ModelItem->getVotesPercentage($id);

        if($itemnumOfvotes){
            if(preg_match('/([0-9]*)\s/', $itemnumOfvotes,$matches)){
                if($matches[1]){
                    $itemRated = round(($itemvotingPercentage/(int)$matches[1])*0.05);
                }else{
                    $itemRated = JText::_('COM_AZURAPAGEBUILDER_K2_ITEM_UN_RATED');
                }
            }else{
                $itemRated = JText::_('COM_AZURAPAGEBUILDER_K2_ITEM_UN_RATED');
            }

        }else{
            $itemRated = JText::_('COM_AZURAPAGEBUILDER_K2_ITEM_UN_RATED');
        }

        return $itemRated;
    }

    public static function getK2PostLikes($pk){
        if($pk > 0){
            $user   = JFactory::getUser();
            $db = JFactory::getDbo();

            $query = $db->getQuery(true);

            $query->select('*')
                ->from($db->quoteName('#__azurapagebuilder_likes'))
                ->where($db->quoteName('pageID') . ' = ' . (int) $pk .' AND '.$db->quoteName('option') . ' = ' . $db->quote("com_k2"));

            // Set the query and load the result.
            $db->setQuery($query);

            // Check for a database error.
            try
            {
                $like = $db->loadObject();
            }
            catch (RuntimeException $e)
            {
                JError::raiseWarning(500, $e->getMessage());

                return false;
            }

            $post_likes = new JRegistry;

            if(isset($like->like_count)){
                $post_likes->set('like_count',$like->like_count);
                if(!$user->guest){
                    $likedUsers_Reg = new JRegistry;
                    $likedUsers_Reg->loadString($like->likedUsers);
                    $likedUsers_Reg = $likedUsers_Reg->toArray();
                    if(array_search($user->id, $likedUsers_Reg) !== false){
                        $post_likes->set('like_status','liked');
                    }else{
                        $post_likes->set('like_status','unliked');
                    }
                }else{
                    $likedIPs_Reg = new JRegistry;
                    $likedIPs_Reg->loadString($like->likedIPs);
                    $likedIPs_Reg = $likedIPs_Reg->toArray();

                    $userIP = $_SERVER['REMOTE_ADDR'];

                    if(array_search($userIP, $likedIPs_Reg) !== false){
                        $post_likes->set('like_status','liked');
                    }else{
                        $post_likes->set('like_status','unliked');
                    }
                }
            }else{
                $post_likes->set('like_count',0);
                $post_likes->set('like_status','unliked');
            }

            return $post_likes;

        }

        return false;
    }



    private static function merge_atts( $pairs, $atts) {
        $atts = (array)$atts;
        $out = array();
        foreach($pairs as $name => $default) {
            if ( array_key_exists($name, $atts) )
                $out[$name] = $atts[$name];
            else
                $out[$name] = $default;
        }
        return $out;
    }

    public static function cleanUrl($url){
        // preg_match('/(\??|&?|&amp;?)Itemid=(\d+)/', 'fdfdsfsdfsdfsdf&amp;Itemid=002', $matches);
        // var_dump($matches);die;
        if($url != ''){
            return preg_replace('/(\??|&?|&amp;?)Itemid=(\d+)/','', $url);
        }

        return $url;
    }
}


class AzuraModuleHelper extends JModuleHelper {

    /**
     * Get module by name (real, eg 'Breadcrumbs' or folder, eg 'mod_breadcrumbs')
     *
     * @param   string  $name   The name of the module
     * @param   string  $title  The title of the module, optional
     *
     * @return  object  The Module object
     *
     * @since   1.5
     */
    public static function &getModule($name, $title = null)
    {
        $result = null;
        $modules =& static::load();
        //echo'<pre>';var_dump($modules);die;
        $total = count($modules);

        for ($i = 0; $i < $total; $i++)
        {
            // Match the name of the module
            if ($modules[$i]->name == $name || $modules[$i]->module == $name)
            {
                // Match the title if we're looking for a specific instance of the module
                if (!$title || $modules[$i]->title == $title)
                {
                    // Found it
                    $result = &$modules[$i];
                    break;
                }
            }
        }

        // If we didn't find it, and the name is mod_something, create a dummy object
        if (is_null($result) && substr($name, 0, 4) == 'mod_')
        {
            $result            = new stdClass;
            $result->id        = 0;
            $result->title     = '';
            $result->module    = $name;
            $result->position  = '';
            $result->content   = '';
            $result->showtitle = 0;
            $result->control   = '';
            $result->params    = '';
        }

        return $result;
    }

    /**
     * Load published modules.
     *
     * @return  array
     *
     * @since   3.2
     */
    protected static function &load()
    {
        static $clean;

        if (isset($clean))
        {
            return $clean;
        }

        $app = JFactory::getApplication();
        $Itemid = $app->input->getInt('Itemid');
        $user = JFactory::getUser();
        $groups = implode(',', $user->getAuthorisedViewLevels());
        $lang = JFactory::getLanguage()->getTag();
        $clientId = (int) $app->getClientId();

        $db = JFactory::getDbo();

        $query = $db->getQuery(true)
            ->select('m.id, m.title, m.module, m.position, m.content, m.showtitle, m.params, mm.menuid')
            ->from('#__modules AS m')
            ->join('LEFT', '#__modules_menu AS mm ON mm.moduleid = m.id')
            ->where('m.published = 1')

            ->join('LEFT', '#__extensions AS e ON e.element = m.module AND e.client_id = m.client_id')
            ->where('e.enabled = 1');

        $date = JFactory::getDate();
        $now = $date->toSql();
        $nullDate = $db->getNullDate();
        $query->where('(m.publish_up = ' . $db->quote($nullDate) . ' OR m.publish_up <= ' . $db->quote($now) . ')')
            ->where('(m.publish_down = ' . $db->quote($nullDate) . ' OR m.publish_down >= ' . $db->quote($now) . ')')

            ->where('m.access IN (' . $groups . ')')
            ->where('m.client_id = ' . $clientId);
            //->where('(mm.menuid = ' . (int) $Itemid . ' OR mm.menuid <= 0)');

        // Filter by language
        if ($app->isSite() && $app->getLanguageFilter())
        {
            $query->where('m.language IN (' . $db->quote($lang) . ',' . $db->quote('*') . ')');
        }

        $query->order('m.position, m.ordering');

        // Set the query
        $db->setQuery($query);
        $clean = array();

        try
        {
            $modules = $db->loadObjectList();
            // all modules loaded after here
            //echo'<pre>';var_dump($modules);die;
        }
        catch (RuntimeException $e)
        {
            JLog::add(JText::sprintf('JLIB_APPLICATION_ERROR_MODULE_LOAD', $e->getMessage()), JLog::WARNING, 'jerror');

            return $clean;
        }

        // Apply negative selections and eliminate duplicates
        $negId = $Itemid ? -(int) $Itemid : false;
        $dupes = array();

        for ($i = 0, $n = count($modules); $i < $n; $i++)
        {
            $module = &$modules[$i];

            // The module is excluded if there is an explicit prohibition
            // Forced this false to load all module
            $negHit = false;//($negId === (int) $module->menuid);

            if (isset($dupes[$module->id]))
            {
                // If this item has been excluded, keep the duplicate flag set,
                // but remove any item from the cleaned array.
                if ($negHit)
                {
                    unset($clean[$module->id]);
                }

                continue;
            }

            $dupes[$module->id] = true;

            // Only accept modules without explicit exclusions.
            if (!$negHit)
            {
                $module->name = substr($module->module, 4);
                $module->style = null;
                $module->position = strtolower($module->position);
                $clean[$module->id] = $module;
            }
        }

        unset($dupes);

        // Return to simple indexing that matches the query order.
        $clean = array_values($clean);

        return $clean;
    }

    /**
     * Render the module.
     *
     * @param   object  $module   A module object.
     * @param   array   $attribs  An array of attributes for the module (probably from the XML).
     *
     * @return  string  The HTML content of the module output.
     *
     * @since   1.5
     */
    public static function renderModule($module, $attribs = array())
    {
        static $chrome;

        // Check that $module is a valid module object
        if (!is_object($module) || !isset($module->module) || !isset($module->params))
        {
            if (defined('JDEBUG') && JDEBUG)
            {
                JLog::addLogger(array('text_file' => 'jmodulehelper.log.php'), JLog::ALL, array('modulehelper'));
                JLog::add('JModuleHelper::renderModule($module) expects a module object', JLog::DEBUG, 'modulehelper');
            }

            return;
        }

        if (defined('JDEBUG'))
        {
            JProfiler::getInstance('Application')->mark('beforeRenderModule ' . $module->module . ' (' . $module->title . ')');
        }

        $app = JFactory::getApplication();

        // Record the scope.
        $scope = $app->scope;

        // Set scope to component name
        $app->scope = $module->module;

        // Get module parameters
        $params = new JRegistry;
        $params->loadString($module->params);

        // Get the template
        $template = $app->getTemplate();

        // Get module path
        $module->module = preg_replace('/[^A-Z0-9_\.-]/i', '', $module->module);
        $path = JPATH_BASE . '/modules/' . $module->module . '/' . $module->module . '.php';

        // Load the module
        if (file_exists($path))
        {
            $lang = JFactory::getLanguage();

            // 1.5 or Core then 1.6 3PD
            $lang->load($module->module, JPATH_BASE, null, false, true) ||
                $lang->load($module->module, dirname($path), null, false, true);

            $content = '';
            ob_start();
            include $path;
            $module->content = ob_get_contents() . $content;
            ob_end_clean();
        }

        // Load the module chrome functions
        if (!$chrome)
        {
            $chrome = array();
        }

        include_once JPATH_THEMES . '/system/html/modules.php';
        $chromePath = JPATH_THEMES . '/' . $template . '/html/modules.php';

        if (!isset($chrome[$chromePath]))
        {
            if (file_exists($chromePath))
            {
                include_once $chromePath;
            }

            $chrome[$chromePath] = true;
        }
        // Check if the current module has a style param to override template module style
        // $paramsChromeStyle = $params->get('style');

        // if ($paramsChromeStyle)
        // {
        //     $attribs['style'] = preg_replace('/^(system|' . $template . ')\-/i', '', $paramsChromeStyle);
        // }

        $attribs['style'] = preg_replace('/^(system|' . $template . ')\-/i', '', $attribs['style']);

        // Make sure a style is set
        if (!isset($attribs['style']))
        {
            $attribs['style'] = 'none';
        }

        // Dynamically add outline style
        if ($app->input->getBool('tp') && JComponentHelper::getParams('com_templates')->get('template_positions_display'))
        {
            $attribs['style'] .= ' outline';
        }

        foreach (explode(' ', $attribs['style']) as $style)
        {
            $chromeMethod = 'modChrome_' . $style;

            // Apply chrome and render module
            if (function_exists($chromeMethod))
            {
                $module->style = $attribs['style'];

                ob_start();
                $chromeMethod($module, $params, $attribs);
                $module->content = ob_get_contents();
                ob_end_clean();
            }
        }

        // Revert the scope
        $app->scope = $scope;

        if (defined('JDEBUG'))
        {
            JProfiler::getInstance('Application')->mark('afterRenderModule ' . $module->module . ' (' . $module->title . ')');
        }

        return $module->content;
    }

    public static function loadposition($position, $style = -2)
    {
        $document   = JFactory::getDocument();
        $renderer   = $document->loadRenderer('module');
        $params     = array('style'=>$style);

        $contents = '';
        foreach (JModuleHelper::getModules($position) as $mod)  {
            $contents .= $renderer->render($mod, $params);
        }
        return $contents;
    }

    public static function treerecurse(&$params, $id = 0, $level = 0, $begin = false)
    {

        static $output;
        if ($begin)
        {
            $output = '';
        }
        $mainframe = JFactory::getApplication();
        $root_id = (int)$params->get('root_id');
        $end_level = $params->get('end_level', NULL);
        $id = (int)$id;
        $catid = JRequest::getInt('id');
        $option = JRequest::getCmd('option');
        $view = JRequest::getCmd('view');

        $user = JFactory::getUser();
        $aid = (int)$user->get('aid');
        $db = JFactory::getDBO();

        switch ($params->get('categoriesListOrdering'))
        {

            case 'alpha' :
                $orderby = 'name';
                break;

            case 'ralpha' :
                $orderby = 'name DESC';
                break;

            case 'order' :
                $orderby = 'ordering';
                break;

            case 'reversedefault' :
                $orderby = 'id DESC';
                break;

            default :
                $orderby = 'id ASC';
                break;
        }

        if (($root_id != 0) && ($level == 0))
        {
            $query = "SELECT * FROM #__k2_categories WHERE parent={$root_id} AND published=1 AND trash=0 ";

        }
        else
        {
            $query = "SELECT * FROM #__k2_categories WHERE parent={$id} AND published=1 AND trash=0 ";
        }

        if (K2_JVERSION != '15')
        {
            $query .= " AND access IN(".implode(',', $user->getAuthorisedViewLevels()).") ";
            if ($mainframe->getLanguageFilter())
            {
                $languageTag = JFactory::getLanguage()->getTag();
                $query .= " AND language IN (".$db->Quote($languageTag).", ".$db->Quote('*').") ";
            }

        }
        else
        {
            $query .= " AND access <= {$aid}";
        }

        $query .= " ORDER BY {$orderby}";

        $db->setQuery($query);
        $rows = $db->loadObjectList();
        if ($db->getErrorNum())
        {
            echo $db->stderr();
            return false;
        }

        if ($level < intval($end_level) || is_null($end_level))
        {
            $output .= '<ul './*.($params->get('moduleclass_sfx')? 'class="'.$params->get('moduleclass_sfx').'"': '').*/'>';
            foreach ($rows as $row)
            {
                if ($params->get('categoriesListItemsCounter'))
                {
                    $row->numOfItems = modK2ToolsHelper::countCategoryItems($row->id);
                }
                else
                {
                    $row->numOfItems = '';
                }

                if (($option == 'com_k2') && ($view == 'itemlist') && ($catid == $row->id))
                {
                    $active = ' class="active"';
                }
                else
                {
                    $active = '';
                }


                if (modK2ToolsHelper::hasChildren($row->id))
                {
                    $output .= '<li'.$active.'><p><a href="'.urldecode(JRoute::_(K2HelperRoute::getCategoryRoute($row->id.':'.urlencode($row->alias)))).'">'.$row->name.'</a> <span>'.$row->numOfItems.'</span></p>';
                    treerecurse($params, $row->id, $level + 1);
                    $output .= '</li>';
                }
                else
                {
                    $output .= '<li'.$active.'><p><a href="'.urldecode(JRoute::_(K2HelperRoute::getCategoryRoute($row->id.':'.urlencode($row->alias)))).'">'.$row->name.'</a> <span>'.$row->numOfItems.'</span></p>';
                }
            }
            $output .= '</ul>';
        }

        return $output;
    }

    public static function calendar($params)
    {
        require_once (JPATH_SITE.DS.'administrator/components/com_azurapagebuilder/helpers/k2calendarhelper.php');

        $month = JRequest::getInt('month');
        $year = JRequest::getInt('year');

        $months = array(
            JText::_('K2_JANUARY'),
            JText::_('K2_FEBRUARY'),
            JText::_('K2_MARCH'),
            JText::_('K2_APRIL'),
            JText::_('K2_MAY'),
            JText::_('K2_JUNE'),
            JText::_('K2_JULY'),
            JText::_('K2_AUGUST'),
            JText::_('K2_SEPTEMBER'),
            JText::_('K2_OCTOBER'),
            JText::_('K2_NOVEMBER'),
            JText::_('K2_DECEMBER'),
        );
        $days = array(
            JText::_('CTH_K2_SUN'),
            JText::_('CTH_K2_MON'),
            JText::_('CTH_K2_TUE'),
            JText::_('CTH_K2_WED'),
            JText::_('CTH_K2_THU'),
            JText::_('CTH_K2_FRI'),
            JText::_('CTH_K2_SAT'),
        );

        $cal = new CTHCalendar;
        $cal->category = $params->get('calendarCategory', 0);
        $cal->setStartDay(1);
        $cal->setMonthNames($months);
        $cal->setDayNames($days);

        if (($month) && ($year))
        {
            return $cal->getMonthView($month, $year);
        }
        else
        {
            return $cal->getCurrentMonthView();
        }
    }

}

if (!function_exists('azura_hex2rgb')) {
    function azura_hex2rgb($hex) {
        
        $hex = str_replace("#", "", $hex);
        
        if (strlen($hex) == 3) {
            $r = hexdec(substr($hex, 0, 1) . substr($hex, 0, 1));
            $g = hexdec(substr($hex, 1, 1) . substr($hex, 1, 1));
            $b = hexdec(substr($hex, 2, 1) . substr($hex, 2, 1));
        } 
        else {
            $r = hexdec(substr($hex, 0, 2));
            $g = hexdec(substr($hex, 2, 2));
            $b = hexdec(substr($hex, 4, 2));
        }
        $rgb = array($r, $g, $b);
        return $rgb;
    }
}

if (!function_exists('azura_hex2rgba')) {
    function azura_hex2rgba($hex,$alpha) {
        
        $hex = str_replace("#", "", $hex);
        
        if (strlen($hex) == 3) {
            $r = hexdec(substr($hex, 0, 1) . substr($hex, 0, 1));
            $g = hexdec(substr($hex, 1, 1) . substr($hex, 1, 1));
            $b = hexdec(substr($hex, 2, 1) . substr($hex, 2, 1));
        } 
        else {
            $r = hexdec(substr($hex, 0, 2));
            $g = hexdec(substr($hex, 2, 2));
            $b = hexdec(substr($hex, 4, 2));
        }
        //$rgb = array($r, $g, $b);
        return 'rgba('.$r.','.$g.','.$b.','.$alpha.')';
    }
}
if (!function_exists('azura_colourBrightness')) {
    
    /*
     * $hex = '#ae64fe';
     * $percent = 0.5; // 50% brighter
     * $percent = -0.5; // 50% darker
    */
    function azura_colourBrightness($hex, $percent) {
        
        // Work out if hash given
        $hash = '';
        if (stristr($hex, '#')) {
            $hex = str_replace('#', '', $hex);
            $hash = '#';
        }
        
        /// HEX TO RGB
        $rgb = azura_hex2rgb($hex);
        
        //// CALCULATE
        for ($i = 0; $i < 3; $i++) {
            
            // See if brighter or darker
            if ($percent > 0) {
                
                // Lighter
                $rgb[$i] = round($rgb[$i] * $percent) + round(255 * (1 - $percent));
            } 
            else {
                
                // Darker
                $positivePercent = $percent - ($percent * 2);
                $rgb[$i] = round($rgb[$i] * $positivePercent) + round(0 * (1 - $positivePercent));
            }
            
            // In case rounding up causes us to go to 256
            if ($rgb[$i] > 255) {
                $rgb[$i] = 255;
            }
        }
        
        //// RBG to Hex
        $hex = '';
        for ($i = 0; $i < 3; $i++) {
            
            // Convert the decimal digit to hex
            $hexDigit = dechex($rgb[$i]);
            
            // Add a leading zero if necessary
            if (strlen($hexDigit) == 1) {
                $hexDigit = "0" . $hexDigit;
            }
            
            // Append to the hex string
            $hex.= $hexDigit;
        }
        return $hash . $hex;
    }
}


class ElementParser {
    static function do_shortcode( $content ) {
        return AzuraShortcode::doContentShortcode($content);
    }
}


