<?php
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die();
jimport('joomla.application.component.helper');
require_once JPATH_COMPONENT. '/helpers/elementparser.php';

class AzuraPagebuilderControllerAjax extends JControllerLegacy {

	public function doLike(){
		//JSession::checkToken('post') or jexit(JText::_('JInvalid_Token'));

		$app = JFactory::getApplication();
		$input = $app->input;
		$pk = $input->getInt('id',0);
		$opt = $input->getString('opt',"com_azurapagebuilder");

		$user = JFactory::getUser();

		$userIP = $_SERVER['REMOTE_ADDR'];
		$return = array("info"=>'error',"msg"=>"unliked");
		if($pk > 0){

			$db    = JFactory::getDbo();
			$query = $db->getQuery(true);

			// Create the base select statement.
			$query->select('*')
				->from($db->quoteName('#__azurapagebuilder_likes'))
				->where($db->quoteName('pageID') . ' = ' . (int) $pk .' AND '.$db->quoteName('option') . ' = ' . $db->quote($opt));

			// Set the query and load the result.
			$db->setQuery($query);

			// Check for a database error.
			try
			{
				$like = $db->loadObject();
			}
			catch (RuntimeException $e)
			{
				//JError::raiseWarning(500, $e->getMessage());

				echo json_encode($return);
				exit();
			}

			// There are no likes yet, so lets insert our like
			if (!$like)
			{
				$query = $db->getQuery(true);


				$likedUsers = new JRegistry;
				$likedIPs = new JRegistry;
				

				if(!$user->guest){
					$likedUsers->loadArray(array($user->id));
					$likedIPs->loadArray(array());
				}else{
					$likedUsers->loadArray(array());
					$likedIPs->loadArray(array($userIP));
				}

				// Create the base insert statement.
				$query->insert($db->quoteName('#__azurapagebuilder_likes'))
					->columns(array($db->quoteName('pageID'), $db->quoteName('like_count'), $db->quoteName('likedUsers'), $db->quoteName('likedIPs'), $db->quoteName('option')))
					->values((int) $pk . ', 1, '.$db->quote($likedUsers->toString()).', '.$db->quote($likedIPs->toString()).', '.$db->quote($opt));
				// Set the query and execute the insert.
				$db->setQuery($query);

				try
				{
					$db->execute();
				}
				catch (RuntimeException $e)
				{
					//JError::raiseWarning(500, $e->getMessage());
					$return = array("info"=>'error',"msg"=>$e->getMessage());

					echo json_encode($return);
					exit();
				}

				$return = array("info"=>'success',"msg"=>"liked","like_count"=>1);
			}
			else
			{
				$likedUsers = new JRegistry;
				$likedIPs = new JRegistry;
				$likedUsers->loadString($like->likedUsers);
				$likedIPs->loadString($like->likedIPs);

				//$return = array("info"=>'success',"msg"=>$likedIPs->toString(),"like_count","1");


				if(!$user->guest){
					//$likedIPs_Arr = $likedIPs->toArray();
					$likedUsers_Arr = $likedUsers->toArray();
					$us_key = array_search($user->id, $likedUsers_Arr);
					if($us_key !== false){
						$query = $db->getQuery(true);

						unset($likedUsers_Arr[$us_key]);

						$likedUsers = new JRegistry;

						$likedUsers->loadArray($likedUsers_Arr);


						if($like->like_count == 1){
							$query->delete($db->quoteName('#__azurapagebuilder_likes'))
									->where($db->quoteName('pageID') . ' = ' . (int) $pk.' AND '.$db->quoteName('option') . ' = ' . $db->quote($opt));
						}else{
							// Create the base update statement.
							$query->update($db->quoteName('#__azurapagebuilder_likes'))
								 	->set($db->quoteName('like_count') . ' = like_count - 1')
									->set($db->quoteName('likedUsers') . ' = ' . $db->quote($likedUsers->toString()))
									->where($db->quoteName('pageID') . ' = ' . (int) $pk.' AND '.$db->quoteName('option') . ' = ' . $db->quote($opt));
						}

						// Set the query and execute the update.
						$db->setQuery($query);

						try
						{
							$db->execute();
						}
						catch (RuntimeException $e)
						{
							//JError::raiseWarning(500, $e->getMessage());

							$return = array("info"=>'error',"msg"=>$e->getMessage());

							echo json_encode($return);
							exit();
						}

						$return = array("info"=>'success',"msg"=>"unliked","like_count"=>($like->like_count -1));
					}else{
						$likedUsers_Arr[] = $user->id;
						$query = $db->getQuery(true);

						$likedUsers->loadArray($likedUsers_Arr);

						// Create the base update statement.
						$query->update($db->quoteName('#__azurapagebuilder_likes'))
							 	->set($db->quoteName('like_count') . ' = like_count + 1')
								->set($db->quoteName('likedUsers') . ' = ' . $db->quote($likedUsers->toString()))
								->where($db->quoteName('pageID') . ' = ' . (int) $pk.' AND '.$db->quoteName('option') . ' = ' . $db->quote($opt));

						// Set the query and execute the update.
						$db->setQuery($query);

						try
						{
							$db->execute();
						}
						catch (RuntimeException $e)
						{
							//JError::raiseWarning(500, $e->getMessage());

							$return = array("info"=>'error',"msg"=>$e->getMessage());

							echo json_encode($return);
							exit();
						}

						$return = array("info"=>'success',"msg"=>"liked","like_count"=>($like->like_count + 1));
					}
				}else{
					$likedIPs_Arr = $likedIPs->toArray();
					//$return = array("info"=>'success',"msg"=>json_encode($likedIPs_Arr),"like_count","1");
					$ip_key = array_search($userIP, $likedIPs_Arr);
					if($ip_key !== false){
						$query = $db->getQuery(true);

						unset($likedIPs_Arr[$ip_key]);

						$likedIPs = new JRegistry;

						$likedIPs->loadArray($likedIPs_Arr);

						if($like->like_count == 1){
							$query->delete($db->quoteName('#__azurapagebuilder_likes'))
									->where($db->quoteName('pageID') . ' = ' . (int) $pk.' AND '.$db->quoteName('option') . ' = ' . $db->quote($opt));
						}else{
							// Create the base update statement.
							$query->update($db->quoteName('#__azurapagebuilder_likes'))
								 	->set($db->quoteName('like_count') . ' = like_count - 1')
									->set($db->quoteName('likedIPs') . ' = ' . $db->quote($likedIPs->toString()))
									->where($db->quoteName('pageID') . ' = ' . (int) $pk.' AND '.$db->quoteName('option') . ' = ' . $db->quote($opt));
						}

						// Set the query and execute the update.
						$db->setQuery($query);

						try
						{
							$db->execute();
						}
						catch (RuntimeException $e)
						{
							//JError::raiseWarning(500, $e->getMessage());

							$return = array("info"=>'error',"msg"=>$e->getMessage());

							echo json_encode($return);
							exit();
						}

						$return = array("info"=>'success',"msg"=>"unliked","like_count"=>($like->like_count -1));
					}else{
						$likedIPs_Arr[] = $userIP;
						$query = $db->getQuery(true);

						$likedIPs->loadArray($likedIPs_Arr);

						// Create the base update statement.
						$query->update($db->quoteName('#__azurapagebuilder_likes'))
							 	->set($db->quoteName('like_count') . ' = like_count + 1')
								->set($db->quoteName('likedIPs') . ' = ' . $db->quote($likedIPs->toString()))
								->where($db->quoteName('pageID') . ' = ' . (int) $pk.' AND '.$db->quoteName('option') . ' = ' . $db->quote($opt));

						// Set the query and execute the update.
						$db->setQuery($query);

						try
						{
							$db->execute();
						}
						catch (RuntimeException $e)
						{
							//JError::raiseWarning(500, $e->getMessage());

							$return = array("info"=>'error',"msg"=>$e->getMessage());

							echo json_encode($return);
							exit();
						}

						$return = array("info"=>'success',"msg"=>"liked","like_count"=>($like->like_count + 1));
					}
				}
			}
		}

		echo json_encode($return);
		exit();
	}

	public function gallery(){
		$output = array();
	    $output['status'] = 'fail';
	    $output['content'] = '';
	    $output['is_remaining'] = 'no';
	    if ( JSession::checkToken() ) {
	        // This nonce is not valid.
	        $output['content'] = JText::_('JINVALID_TOKEN') ;
	        $output['is_remaining'] = 'no';
	    } else {
	    	$app = JFactory::getApplication();
	    	$settings = $app->input->get('settings','','raw');
	    	$click_num = $app->input->get('click_num','','int');


	  //       $output['content'] = var_dump($settings['images']);

	  //   	echo json_encode($output);
			// exit();

	        $lmore_items = $settings['lmore_items'];
	        $lmore_images = $settings['images'];

	       	

			if(!is_array($lmore_images)&& count($lmore_images)) {

				$output['content'] = '!is_array($lmore_images)&& count($lmore_images)';
				echo json_encode($output);
				exit();
			}


	        $loaded = $settings['loaded'];
	        $caption_style = $settings['caption_style'];


	        $loaded += $lmore_items*($click_num-1);
	        $new_loaded = $loaded + $lmore_items;

	        //if(!empty($lmore_images)){

	            //$images = explode(",", $lmore_images);

	            //if(!empty($images)) : 

	            ob_start(); 

	            foreach ($lmore_images as $key => $img) {
	                if($key >= $loaded && $key < $new_loaded) {
	                	$img = (object) $img;
	                    $src = '';
	                    $alt_text = '';
	                    $filtext = '';
	                    if(isset($img->src)) $src = $img->src ;
	                    if(isset($img->alt_text)) $alt_text = $img->alt_text ;
	                    if(isset($img->filters)&& $img->filters !=''){
	                        $filters = explode("|", $img->filters);
	                        foreach ($filters as $key => $fil) {
	                            $filtext .= ' filval-' . AzuraShortcode::sanitize_title($fil);
	                        }
	                    }
	            		?>
			            <div class="azp_grid-item<?php echo $filtext;?>">
			                <div class="img-wrapper demo-image-wrap">
			                    <div class="img-caption <?php echo $caption_style ;?>">
			                        <a href="<?php echo JURI::root().$src;?>" class="zoomer image_popup_a" title="<?php echo $alt_text;?>">
			                        <?php if(isset($img->caption)&& $img->caption !='') : ?>
			                            <h4><?php echo $img->caption;?></h4>
			                        <?php else : ?>
			                            <span><i class="azp_lineicon-plus"></i></span>
			                        <?php endif; ?>
			                        </a>
			                    </div>
			                    <img src="<?php echo JURI::root().$src;?>" class="img-responsive" alt="<?php echo $alt_text;?>">
			                </div>
			            </div>
	        			<?php
	                }

	            }

	            if($key >= $new_loaded){
	                $output['is_remaining'] = 'yes';
	            }

	            $output['content'] = ob_get_clean();

	            //endif;

	        //}


	        $output['status'] = 'success';

	    }

	    echo json_encode($output);
		exit();
	}

	public function contact(){
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		$app = JFactory::getApplication();
		$input = $app->input;


		$mailfrom 	= $app->get('mailfrom');
		$fromname 	= $app->get('fromname');
		$site_name 	= $app->get('sitename');
		$site_url 	= JUri::base();

		


		$imported = JPluginHelper::importPlugin('captcha');
		if($imported){
			$dispatcher = JEventDispatcher::getInstance();
			$result = $dispatcher->trigger('onCheckAnswer',$input->get('g-recaptcha-response', '', 'string'));
			if(!$result[0]){
				echo json_encode(array("info"=>'error',"msg"=>JText::_('COM_AZURAPAGEBUILDER_CONTACT_ERROR_INVALID_CAPTCHA_CODE_TEXT')));	   
				exit();
			}
		}

		$name		= $input->getString('name');
		$website	= $input->getString('website','');
		$email   	= JStringPunycode::emailToPunycode($input->getString('email'));
		$subject	= $input->getString('subject','');
		$message	= $input->getString('message');

		
		
		$com_params = JComponentHelper::getParams('com_azurapagebuilder');
		$email_template = $com_params->get('email_template','email template');

		$allow_field_names = array('site_name','site_url','name','email','website','subject','message');

		if(preg_match_all("/{([\w-_]+)[^\w-_]*}/", $email_template, $matches)!= FALSE){
            $fieldsPattern = array();//$matches[0];
            $fieldsReplace = array();
            foreach ($matches[1] as $key => $fn) {
                $fieldsPattern[] = "/{(".$fn.")[^\w-_]*}/";
                if( isset($$fn) && in_array($fn, $allow_field_names ) ){
                	$fieldsReplace[] = $$fn;  //'['.$fn.']';
                }else{
                	$fieldsReplace[] = '{'.$fn.'}';
                }
            }
            $email_template = preg_replace($fieldsPattern, $fieldsReplace, $email_template);
        }
        
        $receive_emails = $com_params->get('receive_emails','contact@gmail.com');
        $receive_emails = explode(",", $receive_emails);
        $receive_emails = array_map("JStringPunycode::emailToPunycode", $receive_emails);

		$mailer = JFactory::getMailer();
		$mailer->addRecipient($receive_emails);
		$mailer->setSender(array($mailfrom, $fromname));
		$mailer->setSubject($subject);
		$mailer->setBody($email_template);
		$sent = $mailer->Send();

		if ($sent instanceof Exception){
			echo json_encode(array("info"=>'error',"msg"=>(string)$sent));
			exit();
		}


		//If we are supposed to copy the sender, do so.

		// check whether email copy function activated
		$send_user_email = $com_params->get('send_user_email','0');
		if ($send_user_email == '1')
		{
			$copysubject	= JText::sprintf('COM_AZURAPAGEBUILDER_COPYSUBJECT_OF', $subject);

			$email2_template = $com_params->get('email2_template','email 2 template');

			if(preg_match_all("/{([\w-_]+)[^\w-_]*}/", $email2_template, $matches)!= FALSE){
	            $fieldsPattern = array();//$matches[0];
	            $fieldsReplace = array();
	            foreach ($matches[1] as $key => $fn) {
	                $fieldsPattern[] = "/{(".$fn.")[^\w-_]*}/";
	                if( isset($$fn) && in_array($fn, $allow_field_names ) ){
	                	$fieldsReplace[] = $$fn;  //'['.$fn.']';
	                }else{
	                	$fieldsReplace[] = '{'.$fn.'}';
	                }
	            }
	            $email2_template = preg_replace($fieldsPattern, $fieldsReplace, $email2_template);
	        }

			$mailer = JFactory::getMailer();
			$mailer->addRecipient($email);
			$mailer->setSender(array($mailfrom, $fromname));
			$mailer->setSubject($copysubject);
			$mailer->setBody($email2_template);
			$sent = $mailer->Send();

			if ($sent instanceof Exception){
				echo json_encode(array("info"=>'error',"msg"=>(string)$sent));
				exit();
			}
		}

		echo json_encode(array("info"=>'success',"msg"=>JText::_('THANK_YOU_FOR_CONTACTING_WITH_US') ) );

		exit();
	}

}