<?php
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

class com_AzuraPagebuilderInstallerScript
{   
    //for update component from verison 2.x to 3.0 only - will remove in version 3.1
    public function preflight($type, $parent) 
    {
        // Remove the temporary folder where the package was extracted to
        //admin folder
        // $admin_path = JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR .'components'.DIRECTORY_SEPARATOR.'com_azurapagebuilder';
        // $site_path = JPATH_SITE . DIRECTORY_SEPARATOR .'components'.DIRECTORY_SEPARATOR.'com_azurapagebuilder';
        // $media_path = JPATH_SITE . DIRECTORY_SEPARATOR .'media'.DIRECTORY_SEPARATOR.'com_azurapagebuilder';
        // if (JFolder::exists($admin_path))
        // {
        //   JFolder::delete($admin_path);
        // }
        // if (JFolder::exists($site_path))
        // {
        //   JFolder::delete($site_path);
        // }
        // if (JFolder::exists($media_path))
        // {
        //   JFolder::delete($media_path);
        // }
        //uninstall azura search plugin
        $db = JFactory::getDBO();
        $query = "SELECT `extension_id` FROM #__extensions WHERE type='plugin' AND folder='search' AND element = ".$db->Quote('azura');
        $db->setQuery($query);
        $extensions = $db->loadColumn();
        if (count($extensions))
        {
            foreach ($extensions as $id)
            {
                $installer = new JInstaller;
                $result = $installer->uninstall('plugin', $id);
            }
        }
    }
    
    public function postflight($action, $parent)
    {
    	$db = JFactory::getDBO();
        $src = $parent->getParent()->getPath('source');
        $manifest = $parent->getParent()->manifest;
        $plugins = $manifest->xpath('plugins/plugin');
        
        if($plugins){
            foreach ($plugins as $plugin){
                $name = (string)$plugin->attributes()->plugin;
                $path = $src.'/plugins/'.$name;
                $installer = new JInstaller;
                $result = $installer->install($path);
                $query = "UPDATE #__extensions SET enabled=1 WHERE type='plugin' AND element=".$db->Quote($name);
                $db->setQuery($query);
                $db->query();
            }
        }


        

    }

    public function uninstall($parent)
    {
        $db = JFactory::getDBO();
        $manifest = $parent->getParent()->manifest;
        $plugins = $manifest->xpath('plugins/plugin');
        if($plugins){
            foreach ($plugins as $plugin)
            {
                $name = (string)$plugin->attributes()->plugin;
                $query = "SELECT `extension_id` FROM #__extensions WHERE type='plugin' AND element = ".$db->Quote($name);
                $db->setQuery($query);
                $extensions = $db->loadColumn();
                if (count($extensions))
                {
                    foreach ($extensions as $id)
                    {
                        $installer = new JInstaller;
                        $result = $installer->uninstall('plugin', $id);
                    }
                }
                
            }
        }
    }

    /**
     * This method is called after a component is updated.
     *
     * @param  \stdClass $parent - Parent object calling object.
     *
     * @return void
     */
    public function update($parent) 
    {
        //echo '<pre>';var_dump( $parent->get('manifest') );die; // SimpleXMLElement
    }
    
}