<?php

defined('JPATH_PLATFORM') or die;

JFormHelper::loadFieldClass('imagelist');

/**
 * Supports an HTML select list of image
 *
 * @since  11.1
 */
class JFormFieldAzuraImages extends JFormFieldImageList
{
	/**
	 * The form field type.
	 *
	 * @var    string
	 * @since  11.1
	 */
	protected $type = 'AzuraImages';

	/**
	 * Method to get the list of images field options.
	 * Use the filter attribute to specify allowable file extensions.
	 *
	 * @return  array  The field option objects.
	 *
	 * @since   11.1
	 */
	protected function getOptions()
	{
		// Define the image file type filter.
		$this->filter = '\.png$|\.gif$|\.jpg$|\.bmp$|\.ico$|\.jpeg$|\.psd$|\.eps$';

		// Get the field options.
		return parent::getOptions();
	}
	public function azuraGetOptions(){
		return $this->getOptions();
	}
}
