<?php
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;
$el_class = $el_id = $article_ids = $category = $limit = $order = $orderdir = $columns = $tablet_columns = $mobile_columns = $spacing = $showthumbnail = $showtitle = 
$showdate = $showauthor = $showcat = $showtags = $showintrotext = $showloadmore = $showredmore = $showfilter = $filter_all = '';

//$azura_attrs,$azura_content,$azura_element
extract($azura_attrs);
$animation_data = self::buildAnimation($azura_attrs);
$classes = array(
	'azp_element',
    'azp_articles-grid-wrap',
    'azp_articles-grid',
    $el_class,
);
$classes[] = $animation_data['trigger'];
$classes[] = self::buildTypography($azura_attrs);//will return custom class for the element without dot
$azparticlesgridstyle = self::buildStyle($azura_attrs);
if(!empty($el_id)){
	$el_id = 'id="'.$el_id.'"';
}

$classes = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $classes ) ) );

if($article_ids != ''){
	$article_ids = explode(",", $article_ids);
	$articles = array();
	foreach ($article_ids as $val) {
		if(is_numeric($val) && $item_data = self::getK2Item($val)) $articles[] = $item_data;
	}
	
}else{
	if($category == '0' || $category =='') return;
	//$articles = self::getContentItems($category, $limit, $order, $orderdir);
	$articles = self::getK2Items($category, $limit, $order, $orderdir,'','1');

}



$article_grid_cls = 'azp_k2-grid-items azp_gallery-items desktop-'. $columns.'-columns tablet-'. $tablet_columns.'-columns mobile-'. $mobile_columns.'-columns gal-'.$spacing.'-pad';

?>
<?php if(count($articles)) : ?>
<div class="<?php echo $classes; ?>" <?php echo $el_id .' ' . $azparticlesgridstyle.' '.$animation_data['data'];?>>
	<?php if($showfilter == '1') : $tagsFilter = self::getK2TagsFilter($articles);?>
		<?php if(count($tagsFilter)):  ?>
			<ul class="azp_filter-items">
		    <?php 
		    if($filter_all == '1') : ?>
		        <li><a href="#" data-filter="*" class="active"><?php echo JText::_('All');?></a></li>
		    <?php endif;?>
		    <?php 
		    foreach ($tagsFilter as $key => $tag) {
		        if($filter_all != '1' && $key == 0){
		            echo '<li><a href="#" class="active" data-filter=".'.strtolower(str_replace(" ","-",$tag)).'">'.$tag.'</a></li>';
		        }else{
		            echo '<li><a href="#" data-filter=".'.strtolower(str_replace(" ","-",$tag)).'">'.$tag.'</a></li>';
		        }
		        
		    }
		    ?>
		         
		    </ul>
		<?php endif;?>
	<?php endif;?>
	
	<div class="<?php echo $article_grid_cls;?>">
		<div class="azp_grid-sizer"></div>
		<?php foreach ($articles as $key => $article) : //echo'<pre>';var_dump($article);die;
		?>

		<div class="azp_grid-item article-post-wrap <?php echo self::getK2ItemTagsFilter($article);?> article-<?php echo $article->id;?>">
			<article class="article-post">
			<?php if($showthumbnail === '1') :
				K2HelperUtilities::setDefaultImage($article, 'item');
			?>
            	<div class="media-wrapper"><img src="<?php echo $article->image; ?>" class="azp_img-responsive" alt="<?php echo $article->image_caption;?>"></div>
        	<?php endif;?>

			<?php if($showtitle === '1') :?>
				<h4 class="article-grid-title"><a href="<?php echo $article->link;?>"><?php echo $article->title;?></a></h4>

			<?php endif;?>
			<?php if($showintrotext === '1') :?>
                <div class="articleIntro">
                	<?php if($article->introtext):?>
	                	<?php echo $article->introtext;?>
	                <?php else:?>
	                	<?php echo $article->fulltext;?>
	                <?php endif;?>
	                
                </div>
            <?php endif;?>
            <?php if($showredmore === '1') :?>
				<p><a href="<?php echo $article->link;?>" class="azp_btn azp_btn-primary azp_btn-sm"><?php echo JText::_('Read more');?></a></p>
			<?php endif;?>
			<?php if($showdate === '1' || $showauthor === '1' || $showcat === '1' || $showtags === '1') :?>
				<ul class="post-meta">
				<?php if($showdate === '1') :?>
					<li><i class="fa fa-calendar"></i> <?php echo JHtml::_('date',$article->created,'d/m/Y');?></li>
				<?php endif;?>
				<?php if($showauthor === '1') :?>
					<li><a href="<?php echo $article->author->link ;?>"><i class="fa fa-user"></i> <?php echo $article->author->name ;?></li>
				<?php endif;?>
				<?php if($showcat === '1') :?>
					<li><a href="<?php echo $article->category->link ;?>"><i class="fa fa-file-text"></i> <?php echo $article->category->name;?></a></li>
				<?php endif;?>
				<?php if($showtags === '1' && isset($article->tags) && count($article->tags) && $article->params->get('catItemTags')) :
					//$tagLayout = new JLayoutFile('joomla.content.tags');
				?>
					<li>
						<i class="fa fa-tags"></i> 
						<ul class="catItemTags">
						    <?php foreach ($article->tags as $tag): ?>
						    <li><a href="<?php echo $tag->link; ?>"><?php echo $tag->name; ?></a></li>
						    <?php endforeach; ?>
						</ul>
					 </li>
				<?php endif;?>
				</ul>
			<?php endif;?>
			</article>
        </div>
			
		<?php endforeach;?>


    </div>
    <?php if($showloadmore === '1') :?>
    <div class="azp_row">
    	<div class="azp_col-md-12 text-center">
			<br>
			<a href="<?php echo $article->category->link ;?>" class="azp_btn azp_btn-primary  azp_btn-sm"><?php echo JText::_('COM_AZURAPAGEBUILDER_SHOW_MORE_POSTS_TEXT');?></a>
		</div>
    </div>
	<?php endif;?>

</div>
<?php endif;?>
