<?php 
/**
 * @package Azura Joomla Pagebuilder
 * @author Cththemes - www.cththemes.com
 * @date: 15-07-2014
 *
 * @copyright  Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;

$el_class = $el_id = $acctype = $defaultactive = $layout = '';
extract($azura_attrs);

$classes = array(
    'azp_element',
    'azp_panel-group',
    $el_class,
);

$classes[] = self::buildTypography($azura_attrs);//will return custom class for the element without dot
$animation_data = self::buildAnimation($azura_attrs);
$classes[] = $animation_data['trigger'];
$classes = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $classes ) ) );

$accordionstyle = self::buildStyle($azura_attrs);

if(empty($el_id)){
    $el_id = uniqid();
}
?>

<?php if( isset(self::$toStoreGlobalVar['accordionitems']) && count( self::$toStoreGlobalVar['accordionitems'] )): ?>

    <div class="<?php echo $classes;?>" <?php echo $accordionstyle.' '.$animation_data['data'];?> id="<?php echo $el_id;?>">
    <?php 
    foreach (self::$toStoreGlobalVar['accordionitems'] as $key => $item) : 
    	$pnid = uniqid('panel');
    	?>
    	<div class="azp_panel azp_panel-default acc-item-<?php echo ($key+1);?> <?php echo $item['el_class'];?>">
            <div class="azp_panel-heading">
                <h6 class="azp_panel-title">
                    <a role="button" data-toggle="azpcollapse"
                    <?php if($acctype == 'accordion') : ?>
                     data-parent="#<?php echo $el_id;?>" 
                    <?php endif;?>
                     href="#<?php echo $pnid ;?>" >
                     	<?php if($item['iconclass'] && $item['icon_position'] == 'before') :?>
			            <i class="<?php echo $item['iconclass'];?> icon_before-title"></i>
			            <?php endif;?>
	            		<?php echo $item['title'];?>
	            		<?php if($item['iconclass'] && $item['icon_position'] == 'after') :?>
			            <i class="<?php echo $item['iconclass'];?> icon_after-title"></i>
			            <?php endif;?>
	            	</a>
                </h6>
            </div>
            <div id="<?php echo $pnid ;?>" class="azp_panel-collapse azpcollapse <?php if( ($key+1) == $defaultactive ) echo ' in';?>">
                <div class="azp_panel-body">
                    <?php echo $item['content'];?>
                </div>
            </div>
        </div>


    <?php 
    endforeach;?>

    </div>
<?php endif;

self::$toStoreGlobalVar['accordionitems'] = array();