<?php
/**
 *
 * Edubin functions and definitions
 * @package Edubin
 *
 */
define( 'EDUBIN_DIR', trailingslashit( get_template_directory() ) );
define( 'EDUBIN_URI', trailingslashit( get_template_directory_uri() ) );
define( 'EDUBIN_THEME_VERSION', '3.0.7' );
/**
 * Edubin only works in WordPress 4.7 or later.
 */
if ( version_compare( $GLOBALS['wp_version'], '4.7-alpha', '<' ) ) {
	require get_template_directory() . '/include/back-compat.php';
	return;
}

 //Sets up theme defaults and registers support for various WordPress features.
function edubin_setup() {
	
	//Make theme available for translation.
	load_theme_textdomain( 'edubin', get_template_directory() . '/languages' );
	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	//Let WordPress manage the document title.
	add_theme_support( 'title-tag' );

	//Enable support for Post Thumbnails on posts and pages.
	add_theme_support( 'post-thumbnails' );
	add_image_size( 'edubin-featured-image', 1450, 480, true );
	add_image_size( 'edubin-blog-image', 1140, 710, true );
	add_image_size( 'edubin-thumbnail-avatar', 100, 100, true );

	// Set the default content width.
	$GLOBALS['content_width'] = 525;

	// This theme uses wp_nav_menu() in two locations.
	register_nav_menus( array(
		'primary'    => esc_html__( 'Primary Menu', 'edubin' ),
		'footer_menu' => esc_html__( 'Footer Menu', 'edubin' ),
	) );

	//Switch default core markup for search form, comment form, and comments to output valid HTML5.
	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Enable support for Post Formats.
	add_theme_support( 'post-formats', array(
		'aside',
		'image',
		'video',
		'quote',
		'link',
		'gallery',
		'audio',
	) );

	// Add theme support for Custom Logo.
	add_theme_support( 'custom-logo', array(
		'width'       => 250,
		'height'      => 250,
        'flex-height' => true,
        'flex-width'  => true,
	) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	// Add support for Block Styles.
	add_theme_support( 'wp-block-styles' );

	// Add support for full and wide align images.
	add_theme_support( 'align-wide' );

	// Enqueue editor styles.
	add_editor_style( 'style-editor.css' );

	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, and column width.
	  */
	add_editor_style( array( 'assets/css/editor-style.css', edubin_fonts_url() ) );

	// Load regular editor styles into the new block-based editor.
	add_theme_support( 'editor-styles' );


	// Add support for responsive embeds.
	add_theme_support( 'responsive-embeds' );

	// Add theme support for Custom Background.
	$args = array( 
		'default-color' => '#ffffff',
		'default-image' =>''
	);
	
	add_theme_support( 'custom-background', $args );
	
	$args = array(
		'width'         => 1450,
		'flex-height'    => true,
		'flex-width'    => true,
		'height'        => 480,
		'default-text-color' => '',
		'default-image' => get_template_directory_uri() . '/assets/images/header.jpg',
		'wp-head-callback' => 'edubin_header_style',
	);
	register_default_headers( array(
		'default-image' => array(
			'url'           => '%s/assets/images/header.jpg',
			'thumbnail_url' => '%s/assets/images/header.jpg',
			'description'   => esc_html__( 'Default Header Image', 'edubin' ),
		),
	) );
	add_theme_support( 'custom-header', $args );
}



add_action( 'after_setup_theme', 'edubin_setup' );

/**
 * Register custom fonts.
 */
function edubin_fonts_url() {
	$fonts_url = '';

	/* Translators: If there are any character that are
	* not supported by Montserrat, translate this to off, do not
	* translate into your own language.
	*/
	$roboto = _x('on', 'Roboto font:on or off','edubin');

	/*
	 * Translators: If there are characters in your language that are not
	 * supported by Libre Franklin, translate this to 'off'. Do not translate
	 * into your own language.
	 */
	$Montserrat = _x( 'on', 'Roboto font:on or off', 'edubin' );

	if ('off' !== $roboto || 'off' !== $Montserrat ) {
		$font_families = array();

		if('off' !== $roboto){
			$font_families[] = 'Roboto:300,400,500,700';
		}
		
		if('off' !== $Montserrat){
			$font_families[] = 'Montserrat:300,400,500,600,700';
		}

		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);

		$fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
	}

	return esc_url_raw( $fonts_url );
}

/**
 * Add preconnect for Google Fonts.
 *
 * @since Edubin 1.0
 *
 * @param array  $urls           URLs to print for resource hints.
 * @param string $relation_type  The relation type the URLs are printed.
 * @return array $urls           URLs to print for resource hints.
 */
function edubin_resource_hints( $urls, $relation_type ) {
	if ( wp_style_is( 'edubin-fonts', 'queue' ) && 'preconnect' === $relation_type ) {
		$urls[] = array(
			'href' => '//fonts.gstatic.com',
			'crossorigin',
		);
	}

	return $urls;
}
add_filter( 'wp_resource_hints', 'edubin_resource_hints', 10, 2 );

/**
 * Register widget areas.
 */
function edubin_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Blog Sidebar', 'edubin' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here to appear in your sidebar on blog posts and archive pages.', 'edubin' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Header Top', 'edubin' ),
		'id'            => 'header-top',
		'description'   => esc_html__( 'Add widgets here to appear in your header top area.', 'edubin' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title d-none">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer 1', 'edubin' ),
		'id'            => 'footer-1',
		'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'edubin' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer 2', 'edubin' ),
		'id'            => 'footer-2',
		'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'edubin' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer 3', 'edubin' ),
		'id'            => 'footer-3',
		'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'edubin' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer 4', 'edubin' ),
		'id'            => 'footer-4',
		'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'edubin' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	// LearnDash
	if( class_exists( 'SFWD_LMS' ) ) {
		register_sidebar( array(
			'name'          => esc_html__( 'LearnDash Single Right', 'edubin' ),
			'id'            => 'ld-course-sidebar-1',
			'description'   => esc_html__( 'Add widgets here to appear in your sidebar on LearnDash course details pages.', 'edubin' ),
			'before_widget' => '<section id="%1$s" class="widget edubin-ld-widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		) );
	}
}
add_action( 'widgets_init', 'edubin_widgets_init' );

function edubin_tribe_events_widgets_init() {
	// The Events Calender 
	if( class_exists( 'Tribe__Events__Main' ) ) {
		register_sidebar( array(
			'name'          => esc_html__( 'The Events Calendar Single', 'edubin' ),
			'id'            => 'tribe_event_sidebar',
			'description'   => esc_html__( 'Add widgets here to appear in your sidebar on The Events Calendar details pages.', 'edubin' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		) );
	}
}
add_action( 'widgets_init', 'edubin_tribe_events_widgets_init' );

/**
 * Change the excerpt length
 */
function edubin_excerpt_length( $length ) {
	$excerpt = get_theme_mod('exc_lenght', '45');
	return $excerpt;
}
add_filter( 'excerpt_length', 'edubin_excerpt_length', 999 );

/**
 * Handles JavaScript detection.
 *
 * Adds a `js` class to the root `<html>` element when JavaScript is detected.
 *
 */
function edubin_javascript_detection() {
	echo "<script>(function(html){html.className = html.className.replace(/\bno-js\b/,'js')})(document.documentElement);</script>\n";
}
add_action( 'wp_head', 'edubin_javascript_detection', 0 );

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function edubin_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">' . "\n", get_bloginfo( 'pingback_url' ) );
	}
}
add_action( 'wp_head', 'edubin_pingback_header' );

/**
 * Enqueue scripts and styles.
 */
function edubin_scripts() {
	// Add custom fonts, used in the main stylesheet.
	wp_enqueue_style( 'edubin-fonts', edubin_fonts_url(), array(), null );
	// Theme stylesheet.
	wp_enqueue_style( 'edubin-style', get_stylesheet_uri() );
	// Theme block stylesheet.
	wp_enqueue_style( 'edubin-block-style', get_template_directory_uri() . '/assets/css/blocks.css', array( 'edubin-style' ), EDUBIN_THEME_VERSION );
	if ( is_rtl() ){
		wp_enqueue_style( 'bootstrap-rtl', get_template_directory_uri() . '/assets/css/bootstrap-rtl.min.css');
	}
	wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css', array(), '4.0.0');
	wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/assets/css/font-awesome.min.css', '4.7.0' );
	wp_enqueue_style( 'edubin-flaticon', get_template_directory_uri() . '/assets/fonts/flaticon.css', EDUBIN_THEME_VERSION );
	wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/assets/css/owl.carousel.min.css', '2.3.4' );
	//wp_enqueue_style( 'owl-theme-default', get_template_directory_uri() . '/assets/css/owl.theme.default.min.css', '2.3.4' );
	wp_enqueue_style( 'animate-style', get_template_directory_uri() . '/assets/css/animate.css', '3.7.0' );
	if (class_exists('LearnPress')): 
		wp_enqueue_style( 'edubin-learnpress', get_template_directory_uri() . '/assets/css/learnpress.css', array(), EDUBIN_THEME_VERSION);
	endif;
	if (class_exists('SFWD_LMS')): 
		wp_enqueue_style( 'edubin-learndash', get_template_directory_uri() . '/assets/css/learndash.css', array(), EDUBIN_THEME_VERSION);
	endif;
	if (class_exists('Tribe__Events__Main')): 
		wp_enqueue_style( 'edubin-events', get_template_directory_uri() . '/assets/css/events.css', array(), EDUBIN_THEME_VERSION);
	endif;
	if (class_exists('WPForms')): 
		wp_enqueue_style( 'edubin-wpforms', get_template_directory_uri() . '/assets/css/wpforms.css', array(), EDUBIN_THEME_VERSION);
	endif;
	if (class_exists('UM')): 
		wp_enqueue_style( 'edubin-ultimate-member', get_template_directory_uri() . '/assets/css/ulm.css', array(), EDUBIN_THEME_VERSION);
	endif;
	if (class_exists('WooCommerce')): 
		wp_enqueue_style( 'edubin-woocommerce', get_template_directory_uri() . '/assets/css/wc.css', array(), EDUBIN_THEME_VERSION);
	endif;
	wp_enqueue_style( 'edubin-theme', get_template_directory_uri() . '/assets/css/style.css', array(), EDUBIN_THEME_VERSION);
	
	wp_enqueue_script( 'edubin-skip-link-focus-fix', get_template_directory_uri() .  '/assets/js/skip-link-focus-fix.js', array(), EDUBIN_THEME_VERSION, true );

	$edubin_l10n = array(
		'quote'          => edubin_get_svg( array( 'icon' => 'quote-right' ) ),
	);

	if ( has_nav_menu( 'top' ) ) {
		wp_enqueue_script( 'edubin-navigation', get_template_directory_uri() . '/assets/js/navigation.js', array( 'jquery' ), EDUBIN_THEME_VERSION, true );
		$edubin_l10n['expand']         = esc_html__( 'Expand child menu', 'edubin' );
		$edubin_l10n['collapse']       = esc_html__( 'Collapse child menu', 'edubin' );
		$edubin_l10n['icon']           = edubin_get_svg( array( 'icon' => 'angle-down', 'fallback' => true ) );
	}

	wp_enqueue_script( 'edubin-global', get_template_directory_uri() .  '/assets/js/global.js', array( 'jquery' ), EDUBIN_THEME_VERSION, true );
	wp_enqueue_script( 'jquery-scrollto', get_template_directory_uri() . '/assets/js/jquery.scrollTo.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery-countdown', get_template_directory_uri() . '/assets/js/jquery.countdown.min.js', array( 'jquery' ), '2.2.0', true );
	wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/assets/js/owl.js', array( 'jquery' ), '2.3.4', true );
	wp_enqueue_script( 'bootstrap', get_template_directory_uri() .  '/assets/js/bootstrap.min.js', array( 'jquery' ), '4.1.3', true );
	wp_enqueue_script( 'edubin-theme-script', get_template_directory_uri() . '/assets/js/edubin-theme.js', array( 'jquery' ), EDUBIN_THEME_VERSION, true );

	wp_localize_script( 'edubin-skip-link-focus-fix', 'edubinScreenReaderText', $edubin_l10n );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'edubin_scripts' );

/**
 * Register/Enqueue JS/CSS In Admin Panel
 */
function edubin_register_admin_styles(){
	wp_enqueue_style( 'edubin-admin-css', get_template_directory_uri() . '/assets/css/admin.css' );
	wp_enqueue_style( 'edubin-customizer', get_template_directory_uri() . '/admin/assets/css/customizer.css', '', EDUBIN_THEME_VERSION );
	
}
add_action('admin_enqueue_scripts', 'edubin_register_admin_styles');

/**
 * Enqueues styles for the block-based editor.
 */
function edubin_block_editor_styles() {
	// Block styles.
	wp_enqueue_style( 'edubin-block-editor-style', get_template_directory_uri() . '/assets/css/editor-blocks.css', array(), EDUBIN_THEME_VERSION );
	// Add custom fonts.
	wp_enqueue_style( 'edubin-fonts', edubin_fonts_url(), array(), null );
}
add_action( 'enqueue_block_editor_assets', 'edubin_block_editor_styles' );


/**
 * Filter the `sizes` value in the header image markup.
 * @param string $html   The HTML image tag markup being filtered.
 * @param object $header The custom header object returned by 'get_custom_header()'.
 * @param array  $attr   Array of the attributes for the image tag.
 * @return string The filtered header image HTML.
 */
function edubin_header_image_tag( $html, $header, $attr ) {
	if ( isset( $attr['sizes'] ) ) {
		$html = str_replace( $attr['sizes'], '100vw', $html );
	}
	return $html;
}
add_filter( 'get_header_image_tag', 'edubin_header_image_tag', 10, 3 );


/**
 * Use front-page.php when Front page displays is set to a static page.
 *
 * @param string $template front-page.php.
 *
 * @return string The template to be used: blank if is_home() is true (defaults to index.php), else $template.
 */
function edubin_front_page_template( $template ) {
	return is_home() ? '' : $template;
}
add_filter( 'frontpage_template',  'edubin_front_page_template' );

/**
 * Modifies tag cloud widget arguments to display all tags in the same font size and use list format for better accessibility.
 *
 * @param array $args Arguments for tag cloud widget.
 * @return array The filtered arguments for tag cloud widget.
 */
function edubin_widget_tag_cloud_args( $args ) {
	$args['largest']  = 1;
	$args['smallest'] = 1;
	$args['unit']     = 'em';
	$args['format']   = 'list';

	return $args;
}
add_filter( 'widget_tag_cloud_args', 'edubin_widget_tag_cloud_args' );

function edubin_admin_scripts( $hook ) {

	wp_enqueue_media();

	wp_enqueue_script( 'upload-image', get_template_directory_uri() . '/assets/js/image-upload.js', array( 'jquery' ), '1.0.0' );

}

add_action( 'admin_enqueue_scripts', 'edubin_admin_scripts' );

/**
 * Edubin get id
 */

if(!function_exists('edubin_array_get')) {
	function edubin_array_get($array, $key, $default=null){
		if(!is_array($array)) return $default;
		return array_key_exists($key, $array) ? $array[$key] : $default;
	}
}

if(!function_exists('edubin_get_id')) {
	function edubin_get_id() {
		global $wp_query;
		return $wp_query->get_queried_object_id();
	}
}


add_action('wp_default_scripts', function ($scripts) {
	if (!empty($scripts->registered['jquery'])) {
		$scripts->registered['jquery']->deps = array_diff($scripts->registered['jquery']->deps, ['jquery-migrate']);
	}
});


/**
 * Custom template tags for this theme.
 */
require get_parent_theme_file_path( '/include/template-tags.php' );

/**
 * Additional features to allow styling of the templates.
 */
require get_template_directory() . '/include/template-functions.php';

/**
 * SVG icons functions and filters.
 */
require get_parent_theme_file_path( '/include/icon-functions.php' );

/**
 * breadcrumb.
 */
require get_parent_theme_file_path( '/template-parts/header/breadcrumb.php' );

/**
 * WooCommerce.
 */
require get_parent_theme_file_path( '/include/woocommerce.php' );

/**
 * LearnPress.
 */
require get_parent_theme_file_path( '/include/learnpress.php' );

/**
 * LearnDash.
 */
require get_parent_theme_file_path( '/include/learndash.php' );

/**
 * The Events Calendar.
 */
require get_parent_theme_file_path( '/include/events-calendar.php' );

/**
 * Google Fonts.
 */
require get_template_directory() . '/include/gfonts.php';

/**
 * Edubin Options.
 */
require get_theme_file_path('admin/admin-init.php');
require get_theme_file_path('admin/customizer.php');
/**
 * One click demo import.
 */
require get_theme_file_path('admin/edubin-demo-import.php');


