<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * dynamic css, generated by customizer options
 */

// display navigation to the next/previous set of posts
// ----------------------------------------------------------------------------------------
function digiqole_post_nav() {
   if(digiqole_option('blog_navigation_show','yes')=='no'){
      return;
    }
// Don't print empty markup if there's nowhere to navigate.
	$next_post	 = get_next_post();
   $pre_post	 = get_previous_post();
   
	if ( !$next_post && !$pre_post ) {
		return;
   }
   
?>

	<nav class="post-navigation clearfix">
		<div class="post-previous">
         <?php if ( !empty( $pre_post ) ): ?>
            <?php if(has_post_thumbnail($pre_post->ID)): ?>
                  <?php echo get_the_post_thumbnail($pre_post->ID); ?>
            <?php endif; ?>
            
            <a href="<?php echo get_the_permalink( $pre_post->ID ); ?>">
               <span><?php esc_html_e( 'Previous post', 'digiqole' ) ?></span>
					<p><?php echo esc_html(wp_trim_words( get_the_title($pre_post->ID) ,'8') );  ?></p>
            </a>
            
			<?php endif; ?>
		</div>
		<div class="post-next">
         <?php if ( !empty( $next_post ) ): ?>
            <?php if(has_post_thumbnail($next_post->ID)): ?>
                  <?php echo get_the_post_thumbnail($next_post->ID); ?>
            <?php endif; ?>
            <a href="<?php echo get_the_permalink( $next_post->ID ); ?>">
               <span><?php esc_html_e( 'Next post', 'digiqole' ) ?> </span>
               <p> <?php echo esc_html(wp_trim_words( get_the_title( $next_post->ID ) ,'8') );  ?></p>

            </a>
            
			<?php endif; ?>
		</div>
	</nav>
<?php }


// display meta information for a specific post
// ----------------------------------------------------------------------------------------
if ( !function_exists('digiqole_get_breadcrumbs') ) {
   
      function digiqole_get_breadcrumbs( $seperator = '', $word = '' ) {
         if ( defined( 'FW' ) ) {
            $word = digiqole_option( 'breadcrumb_length' );
         }
         echo '<ol class="breadcrumb" data-wow-duration="2s">';
         if ( !is_home() ) {
            echo '<li><i class="fa fa-home"></i> <a href="';
            echo esc_url( get_home_url( '/' ) );
            echo '">';
         
            echo esc_html__( 'Home', 'digiqole' );
            echo "</a>". wp_kses_post( $seperator )."</li> " ;
            if ( is_category() || is_single() ) {
            
            
               if(is_single()){
                  $category = get_the_category()[0];
               }else{
                  $category = get_category( get_query_var( 'cat' ) );
               } 
               echo '<li> <a href='.get_category_link($category->term_id). '>';
               
               $post		 = get_queried_object();
               $postType	 = get_post_type_object( get_post_type( $post ) );
               if ( !empty( $category ) ) {
                  echo esc_html( $category->cat_name ) . '</a> </li>';
               } else if ( $postType ) {
                  echo esc_html( $postType->labels->singular_name ) . '</a></li>';
               }
               
               if ( is_single() ) {
                  echo '<li>'.wp_kses_post( $seperator );
                  echo esc_html( $word ) != '' ? wp_trim_words( get_the_title(), $word ) : get_the_title();
                  echo '</li>';
                  
               }
               
            } elseif ( is_page() ) {
               echo '<li>';
               echo esc_html( $word ) != '' ? wp_trim_words( get_the_title(), $word ) : get_the_title();
               echo '</li>';
            }
         }
         if ( is_tag() ) {
            echo '<li>';
            single_tag_title();
            echo '</li>';
         } elseif ( is_day() ) {
            echo"<li>" . esc_html__( 'Blogs for', 'digiqole' ) . " ";
            the_time( 'F jS, Y' );
            echo'</li>';
         } elseif ( is_month() ) {
            echo"<li>" . esc_html__( 'Blogs for', 'digiqole' ) . " ";
            the_time( 'F, Y' );
            echo'</li>';
         } elseif ( is_year() ) {
            echo"<li>" . esc_html__( 'Blogs for', 'digiqole' ) . " ";
            the_time( 'Y' );
            echo'</li>';
         } elseif ( is_author() ) {
            echo"<li>" . esc_html__( 'Author Blogs', 'digiqole' );
            echo'</li>';
         } elseif ( isset( $_GET[ 'paged' ] ) && !empty( $_GET[ 'paged' ] ) ) {
            echo "<li>" . esc_html__( 'Blogs', 'digiqole' );
            echo'</li>';
         } elseif ( is_search() ) {
            echo"<li>" . esc_html__( 'Search Result', 'digiqole' );
            echo'</li>';
         } elseif ( is_404() ) {
            echo"<li>" . esc_html__( '404 Not Found', 'digiqole' );
            echo'</li>';
         }
         echo '</ol>';
      }

}

// display meta information for a specific post
// ----------------------------------------------------------------------------------------
function digiqole_post_meta() {
?>
	<ul class="post-meta">
       <?php if(digiqole_option('blog_cat_show')=='yes' && count(get_the_category())): ?>  
         <li class="post-category">
            <?php digiqole_category_meta(); ?> 
         </li>
      <?php endif; ?>
      <?php 
        
         if(digiqole_option('blog_author_image_show','yes')=='yes' && is_single()):
            printf(
               '<li class="post-author">%1$s<a href="%2$s">%3$s</a></li>',
               get_avatar( get_the_author_meta( 'ID' ), 55 ), 
               esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ), 
               get_the_author()
            );

         else:
          
               if(digiqole_option('blog_author_show','yes')=='yes' && is_single()):
                     printf(
                        '<li class="post-author"> <i class="fa fa-user"></i> <a href="%1$s">%2$s</a></li>',
                        esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ), 
                        get_the_author()
                     );
               endif;
         endif;
          
			if ( get_post_type() === 'post' && digiqole_option('blog_date_show','yes')=='yes') {
				echo '<li class="post-meta-date">
					<i class="fa fa-clock-o"></i>
						'.  esc_html( get_the_date() ) . 
					'</li>';
			} 
				
         if(is_category() && digiqole_option('blog_post_comment','yes')=='yes'){
            printf(' <li class="post-comment"><i class="icon icon-comment"></i><a href="#" class="comments-link">%1$s</a></li>',
            get_comments_number(get_the_ID()) 
              ); 
         }
      
         $post_view = digiqole_option('show_view_count','yes');
         $count = intval(get_post_meta(get_the_ID(), 'newszone_post_views_count', true));
           
        

         if(is_single()):
            if(digiqole_option('blog_post_comment','yes')=='yes'){
               printf(' <li class="post-comment"><i class="fa fa-comments"></i><a href="#" class="comments-link">%1$s </a></li>',
                  get_comments_number(get_the_ID()) 
               ); 
            }
            if ( $post_view=='yes' && defined( 'FW' ) ) {
            echo '<li class="meta-post-view">
               <i class="icon icon-fire"></i>
                  '. $count .' 
               </li>';
            }
            if( defined( 'FW' ) ){
               if(digiqole_option('blog_read_time_show','yes')=='yes'):  
                   echo '<li class="read-time">'. content_estimated_reading_time(get_the_content()).'</li>';
               endif;
            }
            $blog_social_share = digiqole_option('blog_social_share');
           if(digiqole_option('blog_social_share_show')=='yes' && defined( 'FW' ) && is_array($blog_social_share) && count($blog_social_share) ) {
            echo '<li class="social-share"> <i class="fa fa-share"></i>';
               echo  digiqole_social_share();
            echo '</li>';
         
         }
         endif;

		?>
	</ul>
<?php }
// category post meta
function digiqole_category_meta(){
        
        if(is_single()){
         $blog_cat_show = digiqole_option('blog_cat_show','yes');
        }else{
         $blog_cat_show = digiqole_option('blog_list_cat_show','yes');
        }
        
        
        $blog_cat_single = digiqole_option('blog_cat_single');
        if($blog_cat_show!='yes'){
          return;
        }
       
         $cat = get_the_category();
         if( $blog_cat_single=='yes'  ) {
          
            shuffle($cat);
            if ( isset($cat[0]) ) {
               echo  '<a 
               class="post-cat" 
               href="'. get_category_link($cat[0]->term_id).'"
               style=" '. esc_attr(digiqole_cat_style($cat[0]->term_id, 'block_highlight_color','bg')) .' "
               >'.
               get_cat_name($cat[0]->term_id).'
            </a>';
           }
           return; 
         }

         if ( $cat) {
            
            foreach($cat as $value):
               echo  '<a 
               class="post-cat" 
               href="'. get_category_link($value->term_id).'"
               style=" '. esc_attr(digiqole_cat_style($value->term_id, 'block_highlight_color','bg')) .' "
               >
               <span class="before" style="'. esc_attr(digiqole_cat_style($value->term_id, 'block_highlight_color','bg')) . ' "></span>'.
               get_cat_name($value->term_id). '<span class="after" style="'. esc_attr(digiqole_cat_style($value->term_id, 'block_highlight_color','bg')).'"></span>
            </a>';
            endforeach;    
         }
         
        
			
}

function digiqole_child_category_meta(){ 
   $post_child_cat = digiqole_option('blog_child_cat_show','yes');
   if($post_child_cat!='yes'){
      return;
   }

   $digiqole_cat_term = get_queried_object();

   $digiqole_cat_children = get_terms( $digiqole_cat_term->taxonomy, array(
       'parent'    => $digiqole_cat_term->term_id,
       'hide_empty' => false
   ) );

   if(!$digiqole_cat_children){
     return;
   }

   if ( $digiqole_cat_children ) { 
      echo '<div class="sub-category-list">';
         foreach( $digiqole_cat_children as $digiqole_subcat )
         {
            echo '<a 
                     class="post-cat" 
                     href="'. esc_url(get_term_link($digiqole_subcat, $digiqole_subcat->taxonomy)) .'"
                     style=" '. esc_attr(digiqole_cat_style($digiqole_subcat->term_id, 'block_highlight_color','bg')) .' "
                  > '.
                        $digiqole_subcat->name. 
                     ' </a>';

         }
      echo '</div>';
   }

}

function digiqole_category_post_meta() {
   ?>
      <div class="post-meta">
         <?php 
         
             $blog_author_show = digiqole_option('blog_list_author_show','yes');
             $blog_author_image_show = digiqole_option('blog_author_avatar_show','no');
          
             if($blog_author_image_show=='yes'){

                  printf('<span class="post-author">%1$s<a href="%2$s">%3$s</a></span>',
                  get_avatar( get_the_author_meta( 'ID' ), 55 ), 
                  esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ), 
                  get_the_author()
               );
               
             }

             if($blog_author_show=='yes'){
  
               printf(
                  '<span class="post-author">'.'<i class="fa fa-user"></i> ' . '<a href="%2$s">%3$s</a></span>',
                  get_avatar( get_the_author_meta( 'ID' ), 55 ), 
                  esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ), 
                  get_the_author()
               );
            }

            $blog_date_show = digiqole_option('blog_list_date_show','yes');

            if ( get_post_type() === 'post' && $blog_date_show=='yes') {
               echo '<span class="post-meta-date">
                  <i class="fa fa-clock-o"></i>
                     '. esc_html( get_the_date() ) . 
                  '</span>';
            } 
           
         ?>
      </div>
   <?php }

if ( !function_exists('content_estimated_reading_time') ) {
  
   function content_estimated_reading_time( $content = '', $wpm = 200 ) {
  
     
      $clean_content = esc_html( $content );
      $word_count = str_word_count( $clean_content );
      $time = ceil( $word_count / $wpm );
      if($time<=1){
         $time.= esc_html__(' minute read','digiqole');
      }else{
         $time.= esc_html__(' minutes read','digiqole'); 
      }
      $output  = '<span class="post-read-time">';
      $output .= '<i class="fa fa-eye"></i>';  
      $output .= '<span class="read-time">' . $time . '</span>' . ' ';
      $output .= '</span>';
      return $output;
     }
}

// display meta date for a specific post
// ----------------------------------------------------------------------------------------
function digiqole_post_meta_date() {
	if ( get_post_type() === 'post' ) {

		echo '<span class="post-meta-date meta-date">
				<span class="day">'. get_the_date( 'm' ) . '</span>
				'. get_the_date( 'M' ) . 
			 '</span>';
	}
}

// comment walker
// ----------------------------------------------------------------------------------------
function digiqole_comment_style( $comment, $args, $depth ) {
	if ( 'div' === $args[ 'style' ] ) {
		$tag		 = 'div';
		$add_below	 = 'comment';
	} else {
		$tag		 = 'li ';
		$add_below	 = 'div-comment';
	}
	?>
	<?php
	if ( $args[ 'avatar_size' ] != 0 ) {
		echo get_avatar( $comment, $args[ 'avatar_size' ], '', '', array( 'class' => 'comment-avatar pull-left' ) );
	}
	?>
	<<?php
	echo digiqole_kses( $tag );
	comment_class( empty( $args[ 'has_children' ] ) ? '' : 'parent'  );
	?> id="comment-<?php comment_ID() ?>"><?php if ( 'div' != $args[ 'style' ] ) { ?>
		<div id="div-comment-<?php comment_ID() ?>" class="comment-body"><?php }
	?>	
		<div class="meta-data">

			<div class="pull-right reply"><?php
				comment_reply_link(
				array_merge(
				$args, array(
					'add_below'	 => $add_below,
					'depth'		 => $depth,
					'max_depth'	 => $args[ 'max_depth' ]
				) ) );
				?>
			</div>


			<span class="comment-author vcard"><?php
				printf( digiqole_kses( '<cite class="fn">%s</cite> <span class="says">%s</span>', 'digiqole' ), get_comment_author_link(), esc_html__( 'says:', 'digiqole' ) );
				?>
			</span>
			<?php if ( $comment->comment_approved == '0' ) { ?>
				<em class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'digiqole' ); ?></em><br/><?php }
			?>

			<div class="comment-meta commentmetadata comment-date">
				<?php
				// translators: 1: date, 2: time
				printf(
				esc_html__( '%1$s at %2$s', 'digiqole' ), get_comment_date(), get_comment_time()
				);
				?>
				<?php edit_comment_link( esc_html__( '(Edit)', 'digiqole' ), '  ', '' ); ?>
			</div>
		</div>	
		<div class="comment-content">
			<?php comment_text(); ?>
		</div>
		<?php if ( 'div' != $args[ 'style' ] ) : ?>
		</div><?php
	endif;
}


// pagination within pages or posts if it has a long content
// ----------------------------------------------------------------------------------------
function digiqole_link_pages() {
  
  
	$args = array(
		'before'			 => '<div class="page-links"><span class="page-link-text">' . esc_html__( 'More pages: ', 'digiqole' ) . '</span>',
		'after'				 => '</div>',
		'link_before'		 => '<span class="page-link">',
		'link_after'		 => '</span>',
		'next_or_number'	 => 'number',
		'separator'			 => '  ',
		'nextpagelink'		 => esc_html__( 'Next ', 'digiqole' ) . '<I class="fa fa-angle-right"></i>',
		'previouspagelink'	 => '<I class="fa fa-angle-left"></i>' . esc_html__( ' Previous', 'digiqole' ),
	);
	wp_link_pages( $args );
}


// digiqole related post by categry
function digiqole_related_posts_by_category( $post_id, $related_count=4, $feature_image = true  ) {
   try{
  
   if($post_id==''){
      $post_id = get_the_ID();
   }

   $terms = get_the_terms( $post_id, 'category' );
  
   if ( empty( $terms ) ) $terms = array();
	
	$term_list = wp_list_pluck( $terms, 'slug' );
	
	$related_args = array(
		'post_type' => 'post',
		'posts_per_page' => $related_count,
		'post_status' => 'publish',
		'post__not_in' => array( $post_id ),
      'orderby' => 'rand',
      'ignore_sticky_posts'=>1,
		'tax_query' => array(
			array(
				'taxonomy' => 'category',
				'field' => 'slug',
				'terms' => $term_list
			)
		)
	);
   if($feature_image){
      $related_args["meta_query"] = array(
         array(
            'key' => '_thumbnail_id',
            'compare' => 'EXISTS'
           ),
      );
   }
  
   return new WP_Query( $related_args );

   } catch(Exception $e) {

      return new WP_Query( [] ); 

  }
}

// digiqole related post by tags
function digiqole_related_posts_by_tags( $post_id = '', $related_count = 4, $feature_image = true ) {
    
  try{
      if($post_id==''){
      $post_id = get_the_ID();
      }
      $tags      = wp_get_post_tags($post_id);
      $term_tags = wp_list_pluck($tags,'term_id');
      $args = array(

         'tag__in' => $term_tags,
         'post__not_in' => array($post_id),
         'posts_per_page'=>$related_count,
         'ignore_sticky_posts'=>1,
      );
      if($feature_image){
         $args["meta_query"] = array(
            array(
               'key' => '_thumbnail_id',
               'compare' => 'EXISTS'
            ),
         );
      }

      return new WP_Query($args);

   } catch(Exception $e) {

   return new WP_Query( [] ); 

  }

}
if ( !function_exists('digiqole_ad') ) {
function digiqole_ad($key, $default){

	$ad = digiqole_option($key, ['ad_link' => '', 'ad_html' => '']);
	if($ad['ad_link'] != '' || $ad['ad_link'] != ''){
		if($ad['ad_html'] != ''){
			echo digiqole_return($ad['ad_html']);
		}else{
         if(isset($ad['ad_image'])){
            
            $img_url = $ad['ad_image'];
            if(!isset($img_url['url'])){
              return;
            }
         }
			?>
			<a href="<?php echo esc_url($ad['ad_link']); ?>" target="_blank">
				<img class="img-fluid" src="<?php echo esc_url($ad['ad_image']['url']); ?>" alt="<?php echo esc_attr('Digiqole ads', 'digiqole'); ?>">
			</a>
			<?php
		}
	}
}
}


function digiqole_single_blog_ad($key='single_blog_banner'){

   $single_ad_html    =  digiqole_option($key)['single_ad_html'];	
   $single_ad_link    =  digiqole_option($key)['single_ad_link'];	
   $single_ad_image   =  digiqole_option($key)['single_ad_image'];	
    
	if($single_ad_image==''){
      return $single_ad_html;
   }else{
     $img_url = $single_ad_image['url'];
     $single_ad_link = $single_ad_link!=''?$single_ad_link:'#';
    
     $image_ad = sprintf('<a target="_blank" class="single-post-ad" href="%s"> <img src="%s" alt="%s">  
     </a>',
     esc_url($single_ad_link),
     esc_url($img_url),
     esc_html__('Digiqole ad','digiqole')
   ); 
    
   }
   return $image_ad; 
}



