<?php 

// Home Parallax
add_shortcode('homepr', 'homepr_func');
function homepr_func($atts, $content = null){
	extract(shortcode_atts(array(
		'stext'		=>	'',
		'slide'		=>	'',	
		'btn'		=>	'',
	), $atts));
		$url 	= vc_build_link( $btn );
		$slides = (array) vc_param_group_parse_atts( $slide );
	ob_start(); ?>

    <div class="center-y fadeScroll relative text-center" data-scroll-speed="2">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="spacer-double"></div>
                    <h1 class="text-slider big no-border">
                    	<?php foreach ( $slides as $sli ) { if($sli) { ?>
                        <span class="text-item"><?php echo esc_html($sli['text']); ?></span>
                        <?php } } ?>
                    </h1>
                    <div class="teaser style-1 id-color"><?php echo htmlspecialchars_decode($stext); ?></div>
                    <div class="spacer-double"></div>
                    <?php if($content) { ?>
                    <div class="lead">
                       <?php echo htmlspecialchars_decode($content); ?> 
                    </div>
                    <div class="spacer-double"></div>                 
                    <?php } if ( strlen( $btn ) > 0 && strlen( $url['url'] ) > 0 ) {
						echo '<a class="btn-slider rounded" href="' . esc_attr( $url['url'] ) . '" target="' . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . '">'. esc_attr( $url['title'] ).'</a>';
					} ?>
                </div>
            </div>
        </div>
    </div>
    	
<?php
    return ob_get_clean();
}


// Background Video
add_shortcode('bgvideo', 'bgvideo_func');
function bgvideo_func($atts, $content = null){
	extract(shortcode_atts(array(
		'btext'		=>	'',
		'video'		=>	'',	
		'btn'		=>	'',
		'style'		=>	'',
	), $atts));
	$url 	= vc_build_link( $btn );
	ob_start(); ?>

	<div class="de-video-container">
        <div class="de-video-content">
            <div class="center-y fadeScroll text-center relative" data-scroll-speed="2">
                <div class="container">
                    <div class="row">
                        <div class="col-md-12">
                        	<?php if($style == 'style1') { ?>
                            <div class="spacer-single"></div>
                            <h1 class="big under-color"><?php echo htmlspecialchars_decode($btext); ?></h1>
                            <div class="spacer-single"></div>
                            <div class="lead">
                               <?php echo htmlspecialchars_decode($content); ?> 
                            </div>
                            <div class="spacer-single"></div>
                            <?php }else{ ?>
                            <h1 class="big ls"><?php echo htmlspecialchars_decode($btext); ?></h1>
                            <div class="spacer-single"></div>
                            <div class="teaser-text id-color">
                                <?php echo htmlspecialchars_decode($content); ?> 
                            </div>
                            <div class="spacer-double"></div>
                            <?php } ?>
                            <?php if ( strlen( $btn ) > 0 && strlen( $url['url'] ) > 0 ) {
								echo '<a class="btn-slider rounded" href="' . esc_attr( $url['url'] ) . '" target="' . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . '">'. esc_attr( $url['title'] ).'</a>';
							} ?>
                            <div class="spacer-double"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="de-video-overlay"></div>

        <!-- load your video here -->
        <video autoplay="" loop="" muted="">
            <source src="<?php echo esc_url($video); ?>" type="video/mp4" />
        </video>

    </div>
    	
<?php
    return ob_get_clean();
}


// Member Team
add_shortcode('member','member_func');
function member_func($atts, $content = null){
	extract(shortcode_atts(array(
		'photo'		=>	'',
		'name'		=>	'',
		'btn'		=>	'',
		'job'		=>	'',
		'social'	=>	'',
	), $atts));
		$img 	 = wp_get_attachment_image_src($photo,'full');
		$img 	 = $img[0];
		$url 	 = vc_build_link( $btn );
		$socials = (array) vc_param_group_parse_atts( $social );
	ob_start(); 
?>
	<div class="profile_pic">
        <figure class="pic-hover hover-scale mb30">
            <img src="<?php echo esc_url($img); ?>" class="img-responsive" alt="">
        </figure>

        <h3><?php echo htmlspecialchars_decode($name); ?></h3>
        <span class="subtitle"><?php echo htmlspecialchars_decode($job); ?></span>
        <span class="tiny-border"></span>
        <?php echo htmlspecialchars_decode($content); ?>
        
		<ul class="social-team">
			<?php foreach ( $socials as $soc ) : if($soc) : ?>
				<li>
					<a href="<?php echo esc_url($soc['link']); ?>"><i class="<?php echo esc_attr($soc['icon']); ?>"></i></a>
				</li>
			<?php endif; endforeach; ?>
		</ul>

        <?php if ( strlen( $btn ) > 0 && strlen( $url['url'] ) > 0 ) {
			echo '<a class="read_more mt10" href="' . esc_attr( $url['url'] ) . '" target="' . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . '">'. esc_attr( $url['title'] ).' <i class="fa fa-chevron-right id-color"></i></a>';
		} ?>
    </div>

<?php
    return ob_get_clean();
}



// Service Box
add_shortcode('iconbox', 'iconbox_func');
function iconbox_func($atts, $content = null){
	extract(shortcode_atts(array(
		'photo'		=>	'',
		'video'		=>	'',
		'title'		=>	'',	
		'btn'		=>	'',
	), $atts));
	$url 	= vc_build_link( $btn );
	$img 	 = wp_get_attachment_image_src($photo,'full');
	$img 	 = $img[0];
	ob_start(); ?>

	<figure class="pic-hover hover-scale">
        <span class="center-xy">
            <a class="<?php if($video) echo 'popup-vimeo'; else echo 'image-popup' ?>" href="<?php if($video) echo esc_url($video);else echo esc_url($img); ?>">
                <i class="fa fa-<?php if($video) echo 'play btn-play'; else echo 'image' ?> btn-action btn-action-hide"></i>
            </a>
        </span>
        <span class="bg-overlay"></span>
        <img src="<?php echo esc_url($img); ?>" class="img-responsive" alt="">
    </figure>

    <h3 class="<?php if($img) echo 'mt20'; ?>"><?php echo htmlspecialchars_decode($title); ?></h3>
    <p>
        <?php echo htmlspecialchars_decode($content); ?>
	<br>
		<?php if ( strlen( $btn ) > 0 && strlen( $url['url'] ) > 0 ) {
			echo '<a class="btn-underline mt20" href="' . esc_attr( $url['url'] ) . '" target="' . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . '">' . esc_attr( $url['title'] ). '</a>';
		} ?>
    </p>
    	
<?php
    return ob_get_clean();
}


// Call To Action
add_shortcode('call_to', 'call_to_func');
function call_to_func($atts, $content = null){
	extract(shortcode_atts(array(
		'title'		=>	'',
		'linkbox'	=>	'',
	), $atts));
		$url 	= vc_build_link( $linkbox );
		
	ob_start(); ?>

	<div class="row call-to-action">
		<div class="col-md-8">
	        <h3 class="mt10"><?php echo htmlspecialchars_decode($title); ?></h3>
	    </div>
	    <div class="col-md-4 text-right">
	    	<?php if ( strlen( $linkbox ) > 0 && strlen( $url['url'] ) > 0 ) {
				echo '<a class="btn btn-slider rounded" href="' . esc_attr( $url['url'] ) . '" target="' . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . '">' . esc_attr( $url['title'] ).'</a>';
			} ?>
	    </div>
    </div>

<?php
    return ob_get_clean();
}


// Lastest Event
add_shortcode('lastest_blog','lastest_blog_func');
function lastest_blog_func($atts, $content = null){
	extract(shortcode_atts(array(
		'number'	=>	'6',
		'cols'		=>	'3',
	), $atts));

	ob_start(); 
?>
	<ul id="blog-carousel" class="article-list">
	<?php		
		$args = array(
			'post_type' => 'event',
			'posts_per_page' => $number,
		);
		$blogpost = new WP_Query($args);
		if($blogpost->have_posts()) : while($blogpost->have_posts()) : $blogpost->the_post();

		$date = get_post_meta(get_the_ID(),'_cmb_event_date', true); 
        $date2 = date('d F Y', strtotime($date));
        $time = get_post_meta(get_the_ID(),'_cmb_event_time', true);
	?>
	<li class="item">
	    <figure class="pic-hover mb10">
	        <span class="center-center">
	            <a href="<?php the_permalink(); ?>">
	                <i class="fa fa-link btn-action btn-action-hide"></i>
	            </a>
	        </span>
	        <span class="bg-overlay"></span>
	        <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>" alt="" class="img-responsive">
	    </figure>
	    <div class="post-content">

	        <div class="post-text">
	            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
	            <div class="date-time"><span class="date"><?php echo esc_html($date2); ?></span><span class="time"><?php echo esc_html($time); ?></span></div>

	        </div>

	    </div>
	</li>	

	<?php endwhile; wp_reset_postdata(); endif; ?>
	</ul>

	<script>
		(function($) { "use strict";

			$("#blog-carousel").owlCarousel({
				items: <?php echo esc_js($cols); ?>,
				itemsDesktop      : [1199,<?php echo esc_js($cols); ?>],
			    itemsDesktopSmall     : [979,<?php echo esc_js($cols); ?> - 1],
			    itemsTablet       : [768,1],
			    itemsMobile       : [479,1],
				navigation: false,
				pagination: true
			}); 

		})(jQuery); 
	</script>

<?php
    return ob_get_clean();
}


// List Menu Items
add_shortcode('menurelated','menurelated_func');
function menurelated_func($atts, $content = null){
	extract(shortcode_atts(array(
		'idpost'	=>	'',
		'title'		=>	'',
		'stitle'	=>	'',
		'col'		=>	'6',
		'col2'		=>	'6',
		'style'		=>	'1',
	), $atts));

	$class = 'col-md-2 col-sm-6';
	if($col == 3){
		$class = 'col-md-4';
	}elseif($col == 4){
		$class = 'col-md-3 col-sm-6';
	}
	$class2 = 'col-md-6';
	if($col2 == 1){
		$class2 = 'col-md-12';
	}

	ob_start(); 
?>

	<h2 class="text-center">
	<?php echo htmlspecialchars_decode($title); ?>
	<span class="teaser"><?php echo htmlspecialchars_decode($stitle); ?></span>
	<?php if($title) { ?><span class="small-border center"></span><?php } ?>
	</h2>
	<div class="row">	
		<?php 

		$args = array(
			'post_type'      => 'menu',
			'posts_per_page' => -1,
		    'post__in' 		 => explode(',',$idpost)
		);
		
		$wp_query = new WP_Query($args);					
		while ($wp_query -> have_posts()) : $wp_query -> the_post(); 
		$price = get_post_meta(get_the_ID(),'_cmb_price', true);
		?>
		<?php if( $style == '2' ) { ?>
		<div class="<?php echo esc_attr($class2); ?> mb30">
            <div class="post-menu">
                <a href="<?php the_permalink(); ?>"><img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>" alt="" /></a>
                <div class="sub-item-service meta">
                    <div class="c1"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
                    <div class="c2"></div>
                    <div class="c3"><?php echo esc_html($price); ?></div>
                </div>
                <?php if(get_the_excerpt()) { ?><div class="service-text meta-content"><?php the_excerpt(); ?></div><?php } ?>
            </div>
        </div>
        <?php }elseif( $style == '1' ){ ?>
        <div class="<?php echo esc_attr($class); ?> mb30">
            <div class="post-menu s1">
                <a href="<?php the_permalink(); ?>"><img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>" alt="" /></a>
                <div class="sub-item-service meta">
                    <div class="c1"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
                    <div class="c3"><?php echo esc_html($price); ?></div>
                </div>
                <?php if(get_the_excerpt()) { ?><div class="service-text meta-content"><?php the_excerpt(); ?></div><?php } ?>
            </div>
        </div>
        <?php }else{ ?>
        <div class="<?php echo esc_attr($class); ?> text-center">
	        <div class="menu-itemss">
	            <figure class="pic-hover hover-scale mb10">
	                <span class="center-xy">
	                    <a class="image-popup" href="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>">
	                        <i class="fa fa-image btn-action btn-action-hide"></i>
	                    </a>
	                </span>
	                <span class="bg-overlay"></span>
	                <span class="border-overlay"></span>
	                <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>" class="img-responsive" alt="">
	            </figure>

	            <h3><?php the_title(); ?></h3>
	            <span class="id-color"><?php echo esc_html($price); ?></span>
	        </div>
	    </div>
        <?php } ?>

    	<?php endwhile; wp_reset_postdata();?>
    </div>

<?php
    return ob_get_clean();
}


// Latest Events
add_shortcode('latestevent', 'latestevent_func');
function latestevent_func($atts, $content = null){
    extract(shortcode_atts(array(

    'number'    =>  '',
    'popup'     =>  '',

    ), $atts));
    if(!$number){
        $number = 3;
    }
    ob_start(); ?>
    
    <div class="events-list">

            <div class="row article-list gallery_view">

            <?php 

            $recent = new WP_Query( array(

            'post_type' => 'event', 

            'posts_per_page' => $number,
            'meta_query' => array(
                  array(
                          'key' => '_cmb_event_date',
                          'value' => time(),
                          'compare' => '>=',
                  ),
	        ),
	        'orderby' => '_cmb_event_date',
	        'order' => 'DESC',
            ) );

            $i = 1;

            while ($recent->have_posts()) :$recent-> the_post();

            
            $date = get_post_meta(get_the_ID(),'_cmb_event_date', true); 
            $date2 = date('d F Y', strtotime($date));
            $time = get_post_meta(get_the_ID(),'_cmb_event_time', true);

            ?>
            <div class="col-md-4 col-sm-6">
            	<div class="event-item">
	                <a href="#" data-toggle="modal" data-target="#id<?php echo esc_attr($i) ?>">
			            <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>" alt="">
			        </a>
	                <div class="post-content">

	                    <div class="post-text">
	                        <h3><a href="#" data-toggle="modal" data-target="#id<?php echo esc_attr($i) ?>"><?php the_title(); ?></a></h3>
	                        <div class="date-time"><span class="date"><?php echo esc_html($date2); ?></span><span class="time"><?php echo esc_html($time); ?></span></div>
	                        <?php the_excerpt(); ?>
	                    </div>

	                </div>
                </div>
            </div>

            <div class="modal fade workshop-detail" id="id<?php echo esc_attr($i) ?>">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h2 class="modal-title"><?php the_title(); ?></h2>
                            <span class="date"><?php echo esc_html($date2); ?></span>
                            <span class="time"><?php echo esc_html($time); ?></span>
                        </div>
                        <div class="modal-body">
                            <?php the_content(); ?>
                            <div class="clearfix">
                            </div>
                        </div><!-- /.modal-body -->
                    </div><!-- /.modal-content -->
                </div><!-- /.modal-dialog -->
            </div><!-- /.modal -->

            <?php $i++; endwhile; wp_reset_postdata(); ?>
        </div>
    </div>

    <?php

    return ob_get_clean();
}


// Our Facts
add_shortcode('facts','facts_func');
function facts_func($atts, $content = null){
	extract(shortcode_atts(array(
		'num'		=>	'',
		'icon'		=>	'',
		'title'		=>	'',
	), $atts));
		
	ob_start(); 
?>
	
	<div class="de_count">
        <?php if($icon) { ?><i class="<?php echo esc_attr($icon); ?>" data-animation="fadeInDown" data-delay="0"></i><?php } ?>
        <h3 class="timer" data-to="<?php echo esc_html($num); ?>" data-speed="2500">0</h3>
        <span><?php echo htmlspecialchars_decode($title); ?></span>
    </div>
  	
<?php
    return ob_get_clean();
}


// Logo Clients
add_shortcode('clients','clients_func');
function clients_func($atts, $content = null){
	extract(shortcode_atts(array(
		'gallery'		=> 	'',
		'speed'		  	=>	'6000',	
		'num'		  	=>	'6',	
	), $atts));
		$img = wp_get_attachment_image_src($gallery,'full');
		$img = $img[0];
		$id = uniqid( 'partner-' );
	ob_start(); ?>

        <div id="<?php echo esc_attr($id); ?>" class="owl-partner">
        	<?php 
				$img_ids = explode(",",$gallery);
				foreach( $img_ids AS $img_id ){
				$meta = wp_prepare_attachment_for_js($img_id);
				$caption = $meta['caption'];
				$title = $meta['title'];	
				$description = $meta['description'];
				$image_src = wp_get_attachment_image_src($img_id,''); 
			?>
			<div class="partner-item">
				<?php if($caption){ ?><a href="<?php echo esc_url($caption); ?>" target="_blank" ><?php } ?>
            		<img src="<?php echo esc_url( $image_src[0] ); ?>" alt="">
            	<?php if($caption){ ?></a><?php } ?>
			</div>
			<?php } ?>
		</div>

		<script>
			(function($) { "use strict";	

				$( "#<?php echo esc_js($id); ?>" ).owlCarousel({

    				autoplay: true,
	            	autoplayTimeout: <?php echo esc_js($speed); ?>,
		            items : <?php echo esc_js($num); ?>,
		            responsiveClass:true,
		            responsive : {
		            // breakpoint from 0 up
		            0 : {
		               items:1,
		            },
		            // breakpoint from 480 up
		            480 : {
		               items:1,
		            },
		            // breakpoint from 768 up
		            768 : {
		                items:3,
		            },
		            992 : {
		                items:3,
		            },
		            1440 : {
		                items:<?php echo esc_js($num); ?> - 1,
		            },
		            1920 : {
		                items:<?php echo esc_js($num); ?>,
		            }
		        },
		            dots:false,
		            nav:false,
		            animateOut: 'fadeOut',
		            animateIn: 'fadeIn',
		        }); 

			})(jQuery); 
		</script>

<?php
    return ob_get_clean();	
}

// Contact Info
add_shortcode('ctinfo','ctinfo_func');
function ctinfo_func($atts, $content = null){
	extract(shortcode_atts(array(
		'info'	=>	'',
	), $atts));
	$cinfo = (array) vc_param_group_parse_atts( $info );
	ob_start(); 
?>

    <div class="row">
    	<?php foreach ( $cinfo as $data ) { ?>
        <div class="col-md-4 text-center">
            <i class="<?php echo esc_html($data['icon']); ?> fontsize48 id-color mb30"></i>
            <h3><?php echo esc_html($data['name']); ?></h3>
            <?php echo htmlspecialchars_decode($data['des']); ?>
        </div>
        <?php } ?>
    </div>

<?php
    return ob_get_clean();
}


//Google Map

add_shortcode('maps','maps_func');
function maps_func($atts, $content = null){
	extract(shortcode_atts(array(
		'height'	 	 => '450px',
		'imgmap'	 	 => '',
		'tooltip'	 	 => '',
		'latitude'		 => '',
		'longitude'	 	 => '',
		'zoom'		 	 => '',
	), $atts));
	$id = 'map-canvas-'.(rand(10,10000));
	ob_start(); ?>
	<?php 
		$img = wp_get_attachment_image_src($imgmap,'full');
		$img = $img[0];
		if(!$zoom){
			$zoom = 12;
		}
	 ?>

	<div id="<?php echo esc_attr($id); ?>" class="map-container-full" data-height="<?php echo esc_attr($height); ?>"></div>

	<script>
	(function($) { "use strict";
		// When the window has finished loading create our google map below
		google.maps.event.addDomListener(window, 'load', init);

		function init() {
		    // Basic options for a simple Google Map
		    // For more options see: https://developers.google.com/maps/documentation/javascript/reference#MapOptions
		    var myLatlng = new google.maps.LatLng(<?php echo esc_js($latitude); ?>, <?php echo esc_js($longitude); ?>);

		    var mapOptions = {
		        // How zoomed in you want the map to start at (always required)
		        zoom: <?php echo esc_js($zoom); ?>,
				scrollwheel: false, 

		        // The latitude and longitude to center the map (always required)

		        center: myLatlng, // New York

		        // How you would like to style the map. 
		        // This is where you would paste any style found on Snazzy Maps.
		        styles: [
		    {
		        "elementType": "geometry",
		        "stylers": [
		            {
		                "hue": "#ff4400"
		            },
		            {
		                "saturation": -68
		            },
		            {
		                "lightness": -4
		            },
		            {
		                "gamma": 0.72
		            }
		        ]
		    },
		    {
		        "featureType": "road",
		        "elementType": "labels.icon"
		    },
		    {
		        "featureType": "landscape.man_made",
		        "elementType": "geometry",
		        "stylers": [
		            {
		                "hue": "#0077ff"
		            },
		            {
		                "gamma": 3.1
		            }
		        ]
		    },
		    {
		        "featureType": "water",
		        "stylers": [
		            {
		                "hue": "#00ccff"
		            },
		            {
		                "gamma": 0.44
		            },
		            {
		                "saturation": -33
		            }
		        ]
		    },
		    {
		        "featureType": "poi.park",
		        "stylers": [
		            {
		                "hue": "#44ff00"
		            },
		            {
		                "saturation": -23
		            }
		        ]
		    },
		    {
		        "featureType": "water",
		        "elementType": "labels.text.fill",
		        "stylers": [
		            {
		                "hue": "#007fff"
		            },
		            {
		                "gamma": 0.77
		            },
		            {
		                "saturation": 65
		            },
		            {
		                "lightness": 99
		            }
		        ]
		    },
		    {
		        "featureType": "water",
		        "elementType": "labels.text.stroke",
		        "stylers": [
		            {
		                "gamma": 0.11
		            },
		            {
		                "weight": 5.6
		            },
		            {
		                "saturation": 99
		            },
		            {
		                "hue": "#0091ff"
		            },
		            {
		                "lightness": -86
		            }
		        ]
		    },
		    {
		        "featureType": "transit.line",
		        "elementType": "geometry",
		        "stylers": [
		            {
		                "lightness": -48
		            },
		            {
		                "hue": "#ff5e00"
		            },
		            {
		                "gamma": 1.2
		            },
		            {
		                "saturation": -23
		            }
		        ]
		    },
		    {
		        "featureType": "transit",
		        "elementType": "labels.text.stroke",
		        "stylers": [
		            {
		                "saturation": -64
		            },
		            {
		                "hue": "#ff9100"
		            },
		            {
		                "lightness": 16
		            },
		            {
		                "gamma": 0.47
		            },
		            {
		                "weight": 2.7
		            }
		        ]
		    }
		]
    };

    // Get the HTML DOM element that will contain your map 
    // We are using a div with id="map" seen below in the <body>
    var mapElement = document.getElementById('<?php echo esc_attr($id); ?>');

    // Create the Google Map using out element and options defined above
    var map = new google.maps.Map(mapElement, mapOptions);
	
    var marker = new google.maps.Marker({
        position: myLatlng,
        map: map,
		icon: '<?php echo esc_url($img); ?>',
        title: 'Delizus'
    });
	
	}

	var high = $('.map-container-full').data('height');
	$('.map-container-full').parents('.vc_rows').css('min-height', high);
	})(jQuery); 

	</script>

	<?php

    return ob_get_clean();

}